<?php
/**
 * Express Forms for Craft.
 *
 * @author        Solspace, Inc.
 * @copyright     Copyright (c) 2019-2024, Solspace, Inc.
 *
 * @see           https://docs.solspace.com/craft/express-forms/v2/
 *
 * @license       https://docs.solspace.com/license-agreement/
 */

return [
    // Field validation
    'Email address is not valid' => 'Email address is not valid',
    'This field is required' => 'This field is required',
    'Please verify that you are not a robot.' => 'Please verify that you are not a robot.',

    // File Upload validation
    'Tried uploading {count} files. Maximum {max} files allowed.' => 'Tried uploading {count} files. Maximum {max} files allowed.',
    'File size too large' => 'File size too large',
    'The file was only partially uploaded' => 'The file was only partially uploaded',
    'Could not upload file' => 'Could not upload file',
    "'{extension}' is not an allowed file extension" => "'{extension}' is not an allowed file extension",
    'You tried uploading {fileSize}KB, but the maximum file upload size is {maxFileSize}KB' => 'You tried uploading {fileSize}KB, but the maximum file upload size is {maxFileSize}KB',

    // CP Form Builder
    'Form saved successfully' => 'Form saved successfully',
    'Select upload location...' => 'Select upload location...',
    'Max file count' => 'Max file count',
    'Max file size (KB)' => 'Max file size (KB)',
    'Restrict file types' => 'Restrict file types',
    'Name' => 'Name',
    'Type' => 'Type',
    'Handle' => 'Handle',
    'Required' => 'Required',
    'Are you sure you want to remove this field?' => 'Are you sure you want to remove this field?',
    'Fields & Layout' => 'Fields & Layout',
    'Add field' => 'Add field',
    'Could not find integration' => 'Could not find integration',
    'Location: ' => 'Location: ',
    'Select...' => 'Select...',
    'Mailing List' => 'Mailing List',
    'Resource' => 'Resource',
    'Choose a mailing list to connect and map form submissions to.' => 'Choose a mailing list to connect and map form submissions to.',
    'Choose a resource for this CRM integration to map form submissions to.' => 'Choose a resource for this CRM integration to map form submissions to.',
    'Refresh' => 'Refresh',
    'Refreshing...' => 'Refreshing...',
    'Form Settings' => 'Form Settings',
    'Control and set the basic settings for your form here.' => 'Control and set the basic settings for your form here.',
    'Color' => 'Color',
    "Used for styling form card in CP as well as differentiating the form's submissions in graphs like widgets, etc. Also available for use in templates." => "Used for styling form card in CP as well as differentiating the form's submissions in graphs like widgets, etc. Also available for use in templates.",
    'Submission Title' => 'Submission Title',
    "The generated title for the submission, similar to Craft Entries, etc. Can use Freeform fields, e.g. '{firstName} {lastName}'." => "The generated title for the submission, similar to Craft Entries, etc. Can use Freeform fields, e.g. '{firstName} {lastName}'.",
    'Save Submissions' => 'Save Submissions',
    'Do you want save submissions for this form to the database?' => 'Do you want save submissions for this form to the database?',
    'The name you see for form in the control panel, and also available for use in templates and email notification templates.' => 'The name you see for form in the control panel, and also available for use in templates and email notification templates.',
    'Used for calling the form inside a template.' => 'Used for calling the form inside a template.',
    'An internal note explaining the purpose of the form, and also available for use in templates.' => 'An internal note explaining the purpose of the form, and also available for use in templates.',
    'Notifications' => 'Notifications',
    'This area allows you to manage email notifications for your form.' => 'This area allows you to manage email notifications for your form.',
    'Admin Notification' => 'Admin Notification',
    'Select the email notification template that should be used for Admin email notifications.' => 'Select the email notification template that should be used for Admin email notifications.',
    'Admin Email(s)' => 'Admin Email(s)',
    'Specify admin email address(es) to be notified. Separate multiples by line breaks only.' => 'Specify admin email address(es) to be notified. Separate multiples by line breaks only.',
    'Submitter Notification' => 'Submitter Notification',
    'Select the email notification template that should be used for sending an email notification to the submitter of the form.' => 'Select the email notification template that should be used for sending an email notification to the submitter of the form.',
    'Submitter Email' => 'Submitter Email',
    'Select the Email field in your form that will contain the email address of the submitter.' => 'Select the Email field in your form that will contain the email address of the submitter.',
    "With Express Forms Pro edition, you'll see options to connect your form to first party API integrations when you have at least 1 setup." => "With Express Forms Pro edition, you'll see options to connect your form to first party API integrations when you have at least 1 setup.",
    'Text' => 'Text',
    'Textarea' => 'Textarea',
    'Email' => 'Email',
    'Checkbox' => 'Checkbox',
    'Hidden' => 'Hidden',
    'Options' => 'Options',
    'File' => 'File',
    'Select template...' => 'Select template...',
    '<a href="{link}">Upgrade to Pro</a> to get access to popular API integrations.' => '<a href="{link}">Upgrade to Pro</a> to get access to popular API integrations.',
    'Saving...' => 'Quick Save',
    'Save and finish' => 'Save and finish',
    'Save and add another' => 'Save and add another',
    'Save as a new form' => 'Save as a new form',

    // CP Forms
    'Form not found' => 'Form not found',
    'Could not find form' => 'Could not find form',
    'New Form' => 'New Form',
    'Handle for this Form' => 'Handle for this Form',
    'No description' => 'No description',
    'Are you sure you want to delete this form?' => 'Are you sure you want to delete this form?',
    'Delete this Form' => 'Delete this Form',
    'Are you sure you want to duplicate this form?' => 'Are you sure you want to duplicate this form?',
    'Duplicate this Form' => 'Duplicate this Form',
    'Rearrange this Form' => 'Rearrange this Form',
    'Mailing List integration for this Form' => 'Mailing List integration for this Form',
    'CRM integration for this Form' => 'CRM integration for this Form',
    'Submissions not stored' => 'Submissions not stored',
    'Submissions blocked by Honeypot Spam Protection' => 'Submissions blocked by Honeypot Spam Protection',
    'Reset count' => 'Reset count',
    'Blocked' => 'Blocked',
    'Export...' => 'Export...',
    "You haven't created any forms yet..." => "You haven't created any forms yet...",
    'Create a New Form now' => 'Create a New Form now',
    'Install the Demo to get a quick start' => 'Install the Demo to get a quick start',

    // CP Submissions
    'Submissions' => 'Submissions',
    'Submission' => 'Submission',
    'Date' => 'Date',
    'Value' => 'Value',
    'Submission with ID {id} not found' => 'Submission with ID {id} not found',
    'Submission not found' => 'Submission not found',
    'Submission updated' => 'Submission updated',
    'Submission could not be updated' => 'Submission could not be updated',
    'Delete...' => 'Delete...',
    'Forms' => 'Forms',
    'Form' => 'Form',
    'Element ID' => 'Element ID',
    'ID' => 'ID',
    'Title' => 'Title',
    'Date Created' => 'Date Created',
    'Date Updated' => 'Date Updated',
    'Are you sure you want to delete the selected submissions?' => 'Are you sure you want to delete the selected submissions?',
    'Submissions deleted.' => 'Submissions deleted.',
    'Submissions restored.' => 'Submissions restored.',
    'Some submissions restored.' => 'Some submissions restored.',
    'Submissions not restored.' => 'Submissions not restored.',
    'yes' => 'yes',
    'no' => 'no',

    // CP Email Notifications
    'Email Notifications' => 'Email Notifications',
    'Template Directory Path' => 'Template Directory Path',
    'Provide a path relative to the Craft Templates folder where your email templates directory is. The directory must be writeable to allow Express Forms to create and edit existing templates.' => 'Provide a path relative to the Craft Templates folder where your email templates directory is. The directory must be writeable to allow Express Forms to create and edit existing templates.',
    'Edit Template' => 'Edit Template',
    'Templates' => 'Templates',
    'Express Forms uses the above path to locate and read the available notification template files in your Craft Templates directory on your server and populates a list of them here. Be sure to have proper file permissions set. Editing of notification templates can be done directly inside the file as well.' => 'Express Forms uses the above path to locate and read the available notification template files in your Craft Templates directory on your server and populates a list of them here. Be sure to have proper file permissions set. Editing of notification templates can be done directly inside the file as well.',
    'There are no templates in this folder yet.' => 'There are no templates in this folder yet.',
    'No email notification templates folder set.' => 'No email notification templates folder set.',
    'Incorrect email notification templates folder set.' => 'Incorrect email notification templates folder set.',
    'Create a new Notification Template' => 'Create a new Notification Template',
    'Notification deleted successfully' => 'Notification deleted successfully',
    'Could not delete notification' => 'Could not delete notification',
    'Malformed email notification template "{filename}" in "{path}"' => 'Malformed email notification template "{filename}" in "{path}"',
    'Email notification template folder not set' => 'Email notification template folder not set',
    'New Template' => 'New Template',
    'Express Forms reads the file in your Craft Templates directory on your server and populates an intuitive form for editing the file. Be sure to have proper file permissions set. Editing of this notification template can be done directly inside the file as well.' => 'Express Forms reads the file in your Craft Templates directory on your server and populates an intuitive form for editing the file. Be sure to have proper file permissions set. Editing of this notification template can be done directly inside the file as well.',
    'Are you sure you want to delete this email notification?' => 'Are you sure you want to delete this email notification?',
    'Delete' => 'Delete',
    'Update' => 'Update',
    'The name of the notification.' => 'The name of the notification.',
    'File Name' => 'File Name',
    'The file name of the notification. Only `.twig` or `.html` extensions are valid.' => 'The file name of the notification. Only `.twig` or `.html` extensions are valid.',
    'Description' => 'Description',
    'Description of this notification.' => 'Description of this notification.',
    'From Name' => 'From Name',
    'The name that the email will appear from in your email notification.' => 'The name that the email will appear from in your email notification.',
    'From Email' => 'From Email',
    'The email address that the email will appear from in your email notification.' => 'The email address that the email will appear from in your email notification.',
    'Reply-to Email' => 'Reply-to Email',
    "The reply-to email address for your email notification. Leave blank to use 'From Email' address." => "The reply-to email address for your email notification. Leave blank to use 'From Email' address.",
    'CC' => 'CC',
    'The CC email address for your email notification. Leave blank to not use any.' => 'The CC email address for your email notification. Leave blank to not use any.',
    'BCC' => 'BCC',
    'The BCC email address for your email notification. Leave blank to not use any.' => 'The BCC email address for your email notification. Leave blank to not use any.',
    'Subject' => 'Subject',
    'The subject line that will appear in your email notification.' => 'The subject line that will appear in your email notification.',
    'Email Body' => 'Email Body',
    'The content of the email notification. See documentation for availability of variables.' => 'The content of the email notification. See documentation for availability of variables.',
    'Include Attachments?' => 'Include Attachments?',
    'Include uploaded files as attachments in email notification.' => 'Include uploaded files as attachments in email notification.',

    // CP Settings
    'Settings updated' => 'Settings updated',
    'Settings could not be updated' => 'Settings could not be updated',
    'Settings' => 'Settings',
    'General Settings' => 'General Settings',
    'Rename Plugin' => 'Rename Plugin',
    'If you wish to display a different name for the plugin in page headings and navigation, enter one here.' => 'If you wish to display a different name for the plugin in page headings and navigation, enter one here.',
    'Enhanced UI in Form Builder' => 'Enhanced UI in Form Builder',
    'When disabled, the field layout column in Form Builder will instead use a regular Craft style select dropdown to choose a field type and regular Craft style inputs for Name and Handle fields.' => 'When disabled, the field layout column in Form Builder will instead use a regular Craft style select dropdown to choose a field type and regular Craft style inputs for Name and Handle fields.',
    'Prevent Duplicate Submissions' => 'Prevent Duplicate Submissions',
    "Prevents users from accidentally submitting the form extra times. If caching forms, you'll have to disable this setting." => "Prevents users from accidentally submitting the form extra times. If caching forms, you'll have to disable this setting.",
    'Save' => 'Save',
    "Sorry, there's nothing here." => "Sorry, there's nothing here.",
    'Resources' => 'Resources',
    'Demo' => 'Demo',
    "To get your site off to a quick start, we include a demo form, notification template and a set of simple demo templates that will help you get acquanted with Express Forms. If this is your first time using this plugin, or if you're experiencing some issues with rendering or submitting forms, we highly recommend you try install the demo as part of the learning and debugging process." => "To get your site off to a quick start, we include a demo form, notification template and a set of simple demo templates that will help you get acquanted with Express Forms. If this is your first time using this plugin, or if you're experiencing some issues with rendering or submitting forms, we highly recommend you try install the demo as part of the learning and debugging process.",
    'Install Path' => 'Install Path',
    'Install' => 'Install',
    'Assets' => 'Assets',
    'Routes' => 'Routes',
    'Successfully created the demo form, demo email notification template, and installed {templates} templates and {assets} assets.' => 'Successfully created the demo form, demo email notification template, and installed {templates} templates and {assets} assets.',
    "You can view the templates <a href='{link}'>here</a>" => "You can view the templates <a href='{link}'>here</a>",
    'Cannot instantiate "{class}". Class not found.' => 'Cannot instantiate "{class}". Class not found.',
    "You don't have permission to access Express Forms settings" => "You don't have permission to access Express Forms settings",

    // CP Spam Settings
    'Spam Protection' => 'Spam Protection',
    'Honeypot' => 'Honeypot',
    'Enable this setting to have a spam honeypot field automatically added to your forms.' => 'Enable this setting to have a spam honeypot field automatically added to your forms.',
    'Honeypot Input Name' => 'Honeypot Input Name',
    'Specify the input name that should be used for the Honeypot field. This input will only be visible to bots and trigger the honeypot if a different value is filled in. Recommend you use something generic that sounds like a real and important field.' => 'Specify the input name that should be used for the Honeypot field. This input will only be visible to bots and trigger the honeypot if a different value is filled in. Recommend you use something generic that sounds like a real and important field.',
    'Behavior' => 'Behavior',
    "Select the behavior you'd like Express Forms to take when it detects a submission as being spam." => "Select the behavior you'd like Express Forms to take when it detects a submission as being spam.",
    'Simulate successful submission (recommended)' => 'Simulate successful submission (recommended)',
    'Display error messages (not recommended)' => 'Display error messages (not recommended)',
    'Reload form' => 'Reload form',
    'reCAPTCHA' => 'reCAPTCHA',
    'reCAPTCHA v2 Checkbox' => 'reCAPTCHA v2 Checkbox',
    'reCAPTCHA v2 Invisible' => 'reCAPTCHA v2 Invisible',
    'reCAPTCHA v3' => 'reCAPTCHA v3',
    "Enable this setting if you wish to use reCAPTCHA v2 Checkbox for your forms. To add to your forms, insert {{ form.recaptcha.render }} into your form template where you'd like it to show." => "Enable this setting if you wish to use reCAPTCHA v2 Checkbox for your forms. To add to your forms, insert {{ form.recaptcha.render }} into your form template where you'd like it to show.",
    'Load Script' => 'Load Script',
    'Enable this to have Express Forms automatically load the reCAPTCHA script tag after the form closing tag. Disable if you wish to load manually yourself.' => 'Enable this to have Express Forms automatically load the reCAPTCHA script tag after the form closing tag. Disable if you wish to load manually yourself.',
    'Site Key' => 'Site Key',
    'Enter the Site Key from the Google reCAPTCHA website in order for it to work correctly.' => 'Enter the Site Key from the Google reCAPTCHA website in order for it to work correctly.',
    'Secret Key' => 'Secret Key',
    'Enter the Secret Key from the Google reCAPTCHA website in order for it to work correctly.' => 'Enter the Secret Key from the Google reCAPTCHA website in order for it to work correctly.',

    // CP API Integrations
    'API Integrations' => 'API Integrations',
    'Virtually any API integration is available with Express Forms. Integrations can be custom built using the Developer Events provided (see documentation), installing third party addon plugins, or purchasing the Pro edition. Only first party integrations from the Pro edition are available for configuration inside the control panel.' => 'Virtually any API integration is available with Express Forms. Integrations can be custom built using the Developer Events provided (see documentation), installing third party addon plugins, or purchasing the Pro edition. Only first party integrations from the Pro edition are available for configuration inside the control panel.',
    'Edit {integration} Integration' => 'Edit {integration} Integration',
    'Edit' => 'Edit',
    'Setup' => 'Setup',
    'Active' => 'Active',
    'Inactive' => 'Inactive',
    'Checking' => 'Checking',
    'Error' => 'Error',
    'Get Pro Edition' => 'Get Pro Edition',
    'Send and map submission data to Constant Contact to subscribe users to a mailing list.' => 'Send and map submission data to Constant Contact to subscribe users to a mailing list.',
    'Send and map submission data to Campaign Monitor to subscribe users to a mailing list.' => 'Send and map submission data to Campaign Monitor to subscribe users to a mailing list.',
    'Send and map submission data to MailChimp to subscribe users to a mailing list.' => 'Send and map submission data to MailChimp to subscribe users to a mailing list.',
    'Send and map submission data to your choice of Salesforce Lead or Opportunity, Account and Contact resources.' => 'Send and map submission data to your choice of Salesforce Lead or Opportunity, Account and Contact resources.',
    'Send and map submission data to HubSpot Deals, Contacts and Companies resources.' => 'Send and map submission data to HubSpot Deals, Contacts and Companies resources.',
    "No 'access_token' present in auth response for Constant Contact" => "No 'access_token' present in auth response for Constant Contact",
    'Fetching token' => 'Fetching token',
    'Could not connect to API endpoint' => 'Could not connect to API endpoint',
    'Could not fetch mailing lists' => 'Could not fetch mailing lists',
    'Opt-in Field' => 'Opt-in Field',
    'First Name' => 'First Name',
    'Last Name' => 'Last Name',
    'Job Title' => 'Job Title',
    'Company Name' => 'Company Name',
    'Cell Phone' => 'Cell Phone',
    'Home Phone' => 'Home Phone',
    'Fax' => 'Fax',
    'Could not add contacts to list' => 'Could not add contacts to list',
    'Could not add emails to lists' => 'Could not add emails to lists',
    'Trying to refresh Constant Contact access token with no credentials present' => 'Trying to refresh Constant Contact access token with no credentials present',
    'Key' => 'Key',
    'API Key' => 'API Key',
    'Could not fetch {serviceProvider} lists' => 'Could not fetch {serviceProvider} lists',
    "No 'access_token' present in auth response for Salesforce" => "No 'access_token' present in auth response for Salesforce",
    'Trying to refresh Salesforce access token with no Salesforce credentials present.' => 'Trying to refresh Salesforce access token with no Salesforce credentials present.',
    'Double Opt-In' => 'Double Opt-In',
    "Toggle on if you\\'d like your users to receive a confirmation email to confirm subscription." => "Toggle on if you\\'d like your users to receive a confirmation email to confirm subscription.",
    'Assign Owner?' => 'Assign Owner?',
    'Enabling this will make Salesforce assign a lead owner based on lead owner assignment rules.' => 'Enabling this will make Salesforce assign a lead owner based on lead owner assignment rules.',
    'Sandbox mode?' => 'Sandbox mode?',
    'Enable this if your Salesforce account is in Sandbox mode (connects to "test.salesforce.com" instead of "login.salesforce.com").' => 'Enable this if your Salesforce account is in Sandbox mode (connects to "test.salesforce.com" instead of "login.salesforce.com").',
    'Using custom URL?' => 'Using custom URL?',
    "Enable this if you connect to your Salesforce account with a custom company URL (e.g. \\'mycompany.my.salesforce.com\\')." => "Enable this if you connect to your Salesforce account with a custom company URL (e.g. \\'mycompany.my.salesforce.com\\').",
    'Close Date (required for Opportunity only)' => 'Close Date (required for Opportunity only)',
    "Enter a relative textual date string for the Close Date of the newly created Opportunity (e.g. \\'7 days\\')." => "Enter a relative textual date string for the Close Date of the newly created Opportunity (e.g. \\'7 days\\').",
    'Stage Name (required for Opportunity only)' => 'Stage Name (required for Opportunity only)',
    "Enter the Stage Name the newly created Opportunity should be assigned to (e.g. \\'Prospecting\\')." => "Enter the Stage Name the newly created Opportunity should be assigned to (e.g. \\'Prospecting\\').",

    // CP Resources
    'Community' => 'Community',
    'The Craft community is diverse, inclusive, and amazingly helpful. You can interact with others in the Craft community in a couple of different ways:' => 'The Craft community is diverse, inclusive, and amazingly helpful. You can interact with others in the Craft community in a couple of different ways:',
    "Craft's Stack Exchange Q&A site is a great place to get help and help others. Tag questions with 'plugin-expressforms'." => "Craft's Stack Exchange Q&A site is a great place to get help and help others. Tag questions with 'plugin-expressforms'.",
    'If you have a quick question about something, Craft Discord group will likely get you a quick response.' => 'If you have a quick question about something, Craft Discord group will likely get you a quick response.',
    'Get an Invite' => 'Get an Invite',
    'Explore' => 'Explore',
    'Explore more options below to go beyond Express Forms or extend the functionality of it by using the documented Developer Events. There may also be third party addons available.' => 'Explore more options below to go beyond Express Forms or extend the functionality of it by using the documented Developer Events. There may also be third party addons available.',
    'Pro Edition' => 'Pro Edition',
    'Get more out of Express Forms with the Pro edition! Switch to Pro and get access to popular first party CRM and mailing list API integrations, Excel, XML and JSON exporting, dashboard widgets, and ability to rename the plugin in CP!' => 'Get more out of Express Forms with the Pro edition! Switch to Pro and get access to popular first party CRM and mailing list API integrations, Excel, XML and JSON exporting, dashboard widgets, and ability to rename the plugin in CP!',
    "If you're looking for more convenience and other powerful features, try checking out Freeform. Some of its key features are automation of form building, multi-column layouts, conditional rules logic, spam protection, map to Craft Elements and much more!" => "If you're looking for more convenience and other powerful features, try checking out Freeform. Some of its key features are automation of form building, multi-column layouts, conditional rules logic, spam protection, map to Craft Elements and much more!",
    "Express Forms was developed with a developer-first mentality, so it’s highly extendable. If you want more out of Express Forms, we've done our best to make it as easily extendable as possible for you! Check out the Developer documentation to learn more!" => "Express Forms was developed with a developer-first mentality, so it’s highly extendable. If you want more out of Express Forms, we've done our best to make it as easily extendable as possible for you! Check out the Developer documentation to learn more!",
    'Support' => 'Support',
    'If you run into any issues or have any feature requests, check out the official support options below. We also appreciate any feedback you can provide us.' => 'If you run into any issues or have any feature requests, check out the official support options below. We also appreciate any feedback you can provide us.',
    'Visit our GitHub Issues page to check for existing issues or create new issues and feature requests.' => 'Visit our GitHub Issues page to check for existing issues or create new issues and feature requests.',
    "Don't have a GitHub account, or have a private issue or feedback? Feel free to send us a regular support ticket." => "Don't have a GitHub account, or have a private issue or feedback? Feel free to send us a regular support ticket.",
    'We value your opinion! If you have a few minutes to spare, we would appreciate you sharing some feedback with us.' => 'We value your opinion! If you have a few minutes to spare, we would appreciate you sharing some feedback with us.',
    'Receive occasional (a few times a year) updates and tips about Express Forms and other Solspace software.' => 'Receive occasional (a few times a year) updates and tips about Express Forms and other Solspace software.',

    // CP Error Log
    'Error Log' => 'Error Log',
    'Level' => 'Level',
    'Details' => 'Details',
    'Everything appears to be okay right now! No errors were found.' => 'Everything appears to be okay right now! No errors were found.',
    'Are you sure you want to clear error logs?' => 'Are you sure you want to clear error logs?',
    'Clear' => 'Clear',
    'There are currently <a href="{link}">{count} logged errors</a> in the Express Forms error log.' => 'There are currently <a href="{link}">{count} logged errors</a> in the Express Forms error log.',
    'Show Error Log alert banner on Forms page' => 'Show Error Log alert banner on Forms page',
    'When enabled, an alert banner will show at the top of the Forms list page if there are any logged Express Forms errors. Helpful for quickly catching and identifying issues.' => 'When enabled, an alert banner will show at the top of the Forms list page if there are any logged Express Forms errors. Helpful for quickly catching and identifying issues.',

    // Widgets
    'Overview Stats' => 'Overview Stats',
    'Line' => 'Line',
    'Bar' => 'Bar',
    'Last 24 hours' => 'Last 24 hours',
    'Last 7 days' => 'Last 7 days',
    'Last 30 days' => 'Last 30 days',
    'Last 60 days' => 'Last 60 days',
    'Last 90 days' => 'Last 90 days',
    "Requires <a href='{link}'>Pro</a> edition" => "Requires <a href='{link}'>Pro</a> edition",
];
