<?php
/**
 * General Configuration
 *
 * All of your system's general configuration settings go in here. You can see a
 * list of the available settings in vendor/craftcms/cms/src/config/GeneralConfig.php.
 *
 * @see \craft\config\GeneralConfig
 */

use craft\config\GeneralConfig;
use craft\helpers\App;

return GeneralConfig::create()
    // Set the default week start day for date pickers (0 = Sunday, 1 = Monday, etc.)
    ->defaultWeekStartDay(1)
    // Prevent generated URLs from including "index.php"
    ->omitScriptNameInUrls()
    // Enable Dev Mode (see https://craftcms.com/guides/what-dev-mode-does)
    ->devMode(App::env('DEV_MODE') ?? false)
    // Allow administrative changes
    ->allowAdminChanges(App::env('ALLOW_ADMIN_CHANGES') ?? false)
    // Disallow robots
    ->disallowRobots(App::env('DISALLOW_ROBOTS') ?? false)
    ->maxUploadFileSize(App::env('MAX_FILE_UPLOAD_SIZE'))
    ->extraAllowedFileExtensions(['ico'])
    ->convertFilenamesToAscii(true)
    ->limitAutoSlugsToAscii(true)
    ->optimizeImageFilesize(false)
    ->aliases([
        '@web' => getenv('PRIMARY_SITE_URL'),
    ])
    ->cpHeadTags( [
        // Traditional favicon
        //['link', ['rel' => 'icon', 'href' => getenv('PRIMARY_SITE_URL') . 'assets/images/favicon/favicon-tdip.png?v=1123098087231']],
        // Scalable favicon for browsers that support them
        //['link', ['rel' => 'icon', 'type' => 'image/png', 'sizes' => '180x180', 'href' => getenv('PRIMARY_SITE_URL') . 'assets/images/favicon/favicon-tdip.png?v=1231']],
        //['link', ['rel' => 'icon', 'type' => 'image/png', 'sizes' => '48x48', 'href' => getenv('PRIMARY_SITE_URL') . 'assets/images/favicon/favicon-tdip.png?v=12353223']],
        //['link', ['rel' => 'icon', 'type' => 'image/png', 'sizes' => '32x32', 'href' => getenv('PRIMARY_SITE_URL') . 'assets/images/favicon/favicon-tdip.png?v=5422134121']],
        // Touch icon for mobile devices
        //['link', ['rel' => 'apple-touch-icon', 'sizes' => '180x180', 'href' => getenv('PRIMARY_SITE_URL') . 'assets/images/favicon/favicon-tdip.png?v=412123053']],
        //['link', ['rel' => 'image/x-icon', 'href' => getenv('PRIMARY_SITE_URL') . 'assets/images/favicon/favicon-tdip.ico?v=79182309312']],
        // Pinned tab icon for Safari
    ])
;
