-- MySQL dump 10.13  Distrib 5.7.41, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: cooperativamaism_junta
-- ------------------------------------------------------
-- Server version	5.7.41

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `addresses`
--

DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addresses` (
  `id` int(11) NOT NULL,
  `ownerId` int(11) DEFAULT NULL,
  `countryCode` varchar(255) NOT NULL,
  `administrativeArea` varchar(255) DEFAULT NULL,
  `locality` varchar(255) DEFAULT NULL,
  `dependentLocality` varchar(255) DEFAULT NULL,
  `postalCode` varchar(255) DEFAULT NULL,
  `sortingCode` varchar(255) DEFAULT NULL,
  `addressLine1` varchar(255) DEFAULT NULL,
  `addressLine2` varchar(255) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `organizationTaxId` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_djfddlsxsevmrvaqemopqoitxylyzlcrixgv` (`ownerId`),
  CONSTRAINT `fk_djfddlsxsevmrvaqemopqoitxylyzlcrixgv` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_iobuwmkbfdoglizemhlhsowgrmhfdgvznpva` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `pluginId` int(11) DEFAULT NULL,
  `heading` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `dateRead` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_nhoronwpuuxwzwhmqksahamcfpychtlqzgzc` (`userId`,`unread`,`dateRead`,`dateCreated`),
  KEY `idx_eiyyaycqgzvggmhneeseusifcffnljymlpro` (`dateRead`),
  KEY `fk_hrgcyvqxnavxrsmwpfayisgiryvkkgpaiahi` (`pluginId`),
  CONSTRAINT `fk_hrgcyvqxnavxrsmwpfayisgiryvkkgpaiahi` FOREIGN KEY (`pluginId`) REFERENCES `plugins` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ssjvnrbhrrhakzzsybhyldouitjeairrmpoi` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexdata`
--

DROP TABLE IF EXISTS `assetindexdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetindexdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sessionId` int(11) NOT NULL,
  `volumeId` int(11) NOT NULL,
  `uri` text,
  `size` bigint(20) unsigned DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `isDir` tinyint(1) DEFAULT '0',
  `recordId` int(11) DEFAULT NULL,
  `isSkipped` tinyint(1) DEFAULT '0',
  `inProgress` tinyint(1) DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_snalxdmvfvbfrrrgtxfiyuhqbpkjaanzmccp` (`sessionId`,`volumeId`),
  KEY `idx_wvvodkedpufyafidkepaqcsuzamdlnnlidzv` (`volumeId`),
  CONSTRAINT `fk_gyjagmcxdkbkhyftthnncgkybfmqsbtyjsqq` FOREIGN KEY (`sessionId`) REFERENCES `assetindexingsessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_oavmzazanwakyzwkgnedrgioxgmkavlqrkbm` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexingsessions`
--

DROP TABLE IF EXISTS `assetindexingsessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetindexingsessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `indexedVolumes` text,
  `totalEntries` int(11) DEFAULT NULL,
  `processedEntries` int(11) NOT NULL DEFAULT '0',
  `cacheRemoteImages` tinyint(1) DEFAULT NULL,
  `listEmptyFolders` tinyint(1) DEFAULT '0',
  `isCli` tinyint(1) DEFAULT '0',
  `actionRequired` tinyint(1) DEFAULT '0',
  `processIfRootEmpty` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assets` (
  `id` int(11) NOT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `folderId` int(11) NOT NULL,
  `uploaderId` int(11) DEFAULT NULL,
  `filename` varchar(255) NOT NULL,
  `kind` varchar(50) NOT NULL DEFAULT 'unknown',
  `alt` text,
  `width` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `size` bigint(20) unsigned DEFAULT NULL,
  `focalPoint` varchar(13) DEFAULT NULL,
  `deletedWithVolume` tinyint(1) DEFAULT NULL,
  `keptFile` tinyint(1) DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_whdamtezijlngxqpjinsdqcavleqrmdsytgp` (`filename`,`folderId`),
  KEY `idx_hnqsyrhpmakzxxtzrnobuhwmqjjqnkynidpj` (`folderId`),
  KEY `idx_ofbxiosogewsfnxwrhzmdajkwrgdmsjgasho` (`volumeId`),
  KEY `fk_ozkjvwleytxdbpoltrepucsqmhfngjikhjbk` (`uploaderId`),
  CONSTRAINT `fk_itlbihhxvwmbfngsbvrxmzphiosipdtnxvxz` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ofwxcjodqxjngwndyeexazhgziwkccdnhemr` FOREIGN KEY (`folderId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ozkjvwleytxdbpoltrepucsqmhfngjikhjbk` FOREIGN KEY (`uploaderId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_usqrqqgwnikriqxunodpshktjbuktxnxlosk` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `parentId` int(11) DEFAULT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_svjihsucnwlmqhmlzsqrzabxwlfvwvjnaqnk` (`groupId`),
  KEY `fk_qwsxhhxzzobsgwflfefzwfivncpxiqpbvhbq` (`parentId`),
  CONSTRAINT `fk_buduahtuexbfjkcfqkmsrytbswlgxdpvcnow` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_gubwxabuucbyilywksaytzusyszriazpdtpc` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qwsxhhxzzobsgwflfefzwfivncpxiqpbvhbq` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups`
--

DROP TABLE IF EXISTS `categorygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorygroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_narlpjblqmamenafrpzsqiluxyfnpyzgxljl` (`name`),
  KEY `idx_wpututxgodvrmgrvqomiqiiyuqzzqqgpfika` (`handle`),
  KEY `idx_niwwjfhspkggoedewtrbncluujdybsldkhhb` (`structureId`),
  KEY `idx_rnvflnlwwascuklcdrjbmjrdoqiegqrwrmbo` (`fieldLayoutId`),
  KEY `idx_jrbledaleziveyjvnvawerxyogzbxzmdmtcq` (`dateDeleted`),
  CONSTRAINT `fk_eoahuivlpsurxlpkpptjqypopagegmtwvbee` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pnmbapnldsivngjsyflevachqfawxampgfjb` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups_sites`
--

DROP TABLE IF EXISTS `categorygroups_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorygroups_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text,
  `template` varchar(500) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_befsbbwkezeepgglykmohvksnnosgjsmgbmv` (`groupId`,`siteId`),
  KEY `idx_mqkydsstjkhwromlbvsrenmhzqkrtcsvkdpj` (`siteId`),
  CONSTRAINT `fk_bfjzdkxrabvltyktmjxbzyrjsyraybmbvfyl` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_cxtwazoifnyzfkxhktojzkhixqzlcwgkeaxe` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedattributes`
--

DROP TABLE IF EXISTS `changedattributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `changedattributes` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `attribute` varchar(255) NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`attribute`),
  KEY `idx_fmimslilrajsnxhjuetetktgdymvmfcybsiw` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_xuafpncfelplgedmhbenumxuyazhvrywjsrx` (`siteId`),
  KEY `fk_sojxmqdbqcjbappcpellquwdblxffkgreuqe` (`userId`),
  CONSTRAINT `fk_ouvbfhudytyemrcsyctryoigvcytajrcxosf` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_sojxmqdbqcjbappcpellquwdblxffkgreuqe` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_xuafpncfelplgedmhbenumxuyazhvrywjsrx` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedfields`
--

DROP TABLE IF EXISTS `changedfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `changedfields` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`fieldId`),
  KEY `idx_lmpzpdjpqqpoilucghbwmfhzanmgvaaieeeo` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_fbnpthihmmjzfwrqaddwuiincsthxvxbkuzy` (`siteId`),
  KEY `fk_aatadzirpsbqwhevkxggklouxgxjyapzbqok` (`fieldId`),
  KEY `fk_mqmwclcgiyunwtafikpbmqllwaaybqongfjz` (`userId`),
  CONSTRAINT `fk_aatadzirpsbqwhevkxggklouxgxjyapzbqok` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_fbnpthihmmjzfwrqaddwuiincsthxvxbkuzy` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_mqmwclcgiyunwtafikpbmqllwaaybqongfjz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_uytbmlurlacetuacgwcaxqbxrpphusyobjdu` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `content`
--

DROP TABLE IF EXISTS `content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  `field_metaTitle_wazzxglf` text,
  `field_metaDescription_ajhdgooe` text,
  `field_html_lybdltli` text,
  `field_organizationName_ukbnjvma` text,
  `field_email_kwodfxjt` varchar(255) DEFAULT NULL,
  `field_address_gklqovpy` text,
  `field_postalCode_zjtrjjfm` text,
  `field_city_ytsfqomq` text,
  `field_country_xfwzdulc` varchar(255) DEFAULT NULL,
  `field_phone_zgcmmyvo` text,
  `field_copyright_gzwezmwi` text,
  `field_richText_bvqpiscs` text,
  `field_seo_cwroofon` text,
  `field_shortDescription_tyatblvb` text,
  `field_latitude_myhuqhkt` text,
  `field_longitude_bzgtlbjm` text,
  `field_location_jjszxiab` text,
  `field_date_pylrxcat` datetime DEFAULT NULL,
  `field_showGallery_ssublcje` tinyint(1) DEFAULT NULL,
  `field_showNews_alfqkvgz` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ohboalewzhvnxhtdxwnkvrauyuzifyilqvlp` (`elementId`,`siteId`),
  KEY `idx_ocuoeacnpkybsiozbmajmwffytwytgmujfrj` (`siteId`),
  KEY `idx_fcgxbdfslsjucggqwsbyefiwzgtohxfqaboy` (`title`),
  CONSTRAINT `fk_ifxeoxzzgaconwygsgvhjfvzhbjhnrtnrmqq` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_jkyukgbhnkzgnqixfkldlzjbtzvdyvxahyqs` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=377 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `craftidtokens`
--

DROP TABLE IF EXISTS `craftidtokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `craftidtokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `accessToken` text NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_bpeoaqcfqwiceohthbrexwllnutsgixjclom` (`userId`),
  CONSTRAINT `fk_bpeoaqcfqwiceohthbrexwllnutsgixjclom` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `deprecationerrors`
--

DROP TABLE IF EXISTS `deprecationerrors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deprecationerrors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `fingerprint` varchar(255) NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) NOT NULL,
  `line` smallint(6) unsigned DEFAULT NULL,
  `message` text,
  `traces` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_aqlhkurqylvdueifdxhqrywaavbivdwyqqgr` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `drafts`
--

DROP TABLE IF EXISTS `drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `drafts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `provisional` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `notes` text,
  `trackChanges` tinyint(1) NOT NULL DEFAULT '0',
  `dateLastMerged` datetime DEFAULT NULL,
  `saved` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_dmfnscilfenalncczmmdvfpehogpffsoctat` (`creatorId`,`provisional`),
  KEY `idx_zwwhlazgnmaemsrvrnlrcmmdgpyggccbuqkn` (`saved`),
  KEY `fk_frxixkjltwwlxogcibfavanvvrrkfhzlgrhf` (`canonicalId`),
  CONSTRAINT `fk_frxixkjltwwlxogcibfavanvvrrkfhzlgrhf` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_slacvlkucwomcvoumpifswosbvqecjnohclv` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elementactivity`
--

DROP TABLE IF EXISTS `elementactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `elementactivity` (
  `elementId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `draftId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`elementId`,`userId`,`type`),
  KEY `idx_ywerebwwiappmvyebrbdlgideeuccqzwmddz` (`elementId`,`timestamp`,`userId`),
  KEY `fk_vkrnikhpxdwljsezncevaussrnanzavwvhtk` (`userId`),
  KEY `fk_uheyjrjvmbtpgxnexjgiqapffzruktkjnytt` (`siteId`),
  KEY `fk_xzbupyvlmwqvnkiemhidycicnuruthyxfuog` (`draftId`),
  CONSTRAINT `fk_uheyjrjvmbtpgxnexjgiqapffzruktkjnytt` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vkrnikhpxdwljsezncevaussrnanzavwvhtk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xzbupyvlmwqvnkiemhidycicnuruthyxfuog` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zagpbchjtlolqxvsgpgysteprhtmtnfwfvpp` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements`
--

DROP TABLE IF EXISTS `elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `elements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `draftId` int(11) DEFAULT NULL,
  `revisionId` int(11) DEFAULT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateLastMerged` datetime DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_jalyauvfdzwqoabqyfkxrdgvaowvnhlklrwp` (`dateDeleted`),
  KEY `idx_hphdevbfjnjhnbtcagtogtdjaxpyphlwpnmw` (`fieldLayoutId`),
  KEY `idx_rshxllxoobzxkbkiswpsifnyfsbglytdrvid` (`type`),
  KEY `idx_xdfsrmuogdodpyzmqagxxhlnnagpbfjndejc` (`enabled`),
  KEY `idx_vekxwetaccyktmhvyapkcoktsroahgmgjppq` (`canonicalId`),
  KEY `idx_xypjicsisbmdjqdhvczthdnpzbeuhmnldota` (`archived`,`dateCreated`),
  KEY `idx_pmpzzocaupqzzejivdxtpbaawjsnezdoqntp` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`),
  KEY `idx_gdinedlecebuwidncbxrnhumftcilmvdrory` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`,`enabled`),
  KEY `fk_dtfgynqskiiaowizjbzncixlqsfsvdgojtij` (`draftId`),
  KEY `fk_qwjzdbsjblwkvrxfhfrjxihhfrahvskymlca` (`revisionId`),
  CONSTRAINT `fk_avuzclknxbcggqiatukaiwlazadnawmxglvd` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_dtfgynqskiiaowizjbzncixlqsfsvdgojtij` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_gsfcxfguspjfxhelucoyegybwntkwyfalgry` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qwjzdbsjblwkvrxfhfrjxihhfrahvskymlca` FOREIGN KEY (`revisionId`) REFERENCES `revisions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=390 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_sites`
--

DROP TABLE IF EXISTS `elements_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `elements_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_xdttpdtbwernvzrpzrjuetswgalndnvxzhsw` (`elementId`,`siteId`),
  KEY `idx_hccocrclajvlcrkgfrtmhgdpghmfndhvniod` (`siteId`),
  KEY `idx_ahqribcnatkariwjrdkalfubjoctlgnjhfah` (`slug`,`siteId`),
  KEY `idx_qwjcetmkxkczgtnghqffsysvwshdblqvyxaq` (`enabled`),
  KEY `idx_eenicetmlfxjslscyqtakhiluduphhszjbaj` (`uri`,`siteId`),
  CONSTRAINT `fk_tzqjdjuhbhidemgmkwqgfxgraalkmcyjffab` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_yvvbgwmhmkfhwuqjjpfqdrusyarqdylhsttv` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=390 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entries` (
  `id` int(11) NOT NULL,
  `sectionId` int(11) NOT NULL,
  `parentId` int(11) DEFAULT NULL,
  `typeId` int(11) NOT NULL,
  `authorId` int(11) DEFAULT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `deletedWithEntryType` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_ifsrelqieavcddhybmwdwokvzioopusuutrd` (`postDate`),
  KEY `idx_kghffkjvrirxxjajysgljoqsohfcgcpkjulw` (`expiryDate`),
  KEY `idx_wbqpeytutkmwadfogjtgbjsqqtzvrxsdfgdd` (`authorId`),
  KEY `idx_epynmnwzzwibfvnrdviymsrpubadfqhvquse` (`sectionId`),
  KEY `idx_hkacrphqqbsfhceheblfoatbucvknczcblmk` (`typeId`),
  KEY `fk_bhlrsxnyozabdqtpzlfygwqqwlegsxszgmys` (`parentId`),
  CONSTRAINT `fk_bhlrsxnyozabdqtpzlfygwqqwlegsxszgmys` FOREIGN KEY (`parentId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_cimbvtdektuprnhmrjtoahhbkdaindproaat` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_feivhncuwvqtkmkcooujhnnsbsjaofihfpuc` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_iseehsxozgrigxsxtelmhggdlzpvrhdbgyzo` FOREIGN KEY (`authorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_otxnypirtfbmbqzxgrbuscgwsefqpjtxckcw` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entrytypes`
--

DROP TABLE IF EXISTS `entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entrytypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `hasTitleField` tinyint(1) NOT NULL DEFAULT '1',
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text,
  `titleFormat` varchar(255) DEFAULT NULL,
  `slugTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `slugTranslationKeyFormat` text,
  `showStatusField` tinyint(1) DEFAULT '1',
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_llihxykmtecyyffnttzjwanyjktzbhevaaih` (`name`,`sectionId`),
  KEY `idx_wseyovcojkuyahqrwjpqwmtcdsdjmxsmunvd` (`handle`,`sectionId`),
  KEY `idx_bfjnqhjqcmnbjyjylrwpfrrcsgjniwmgfpja` (`sectionId`),
  KEY `idx_sfiubfnlrosxmdladrkwavajuphpoyeaavme` (`fieldLayoutId`),
  KEY `idx_rmzhcsdeqgqxlysbxccztfzyjvppocdpjwdf` (`dateDeleted`),
  CONSTRAINT `fk_lyoipjxcfngwngpomtupbnlnhwtjusbmwmkf` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_umlmeiarpayhmouaohlndvlrsimowvtymigc` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldgroups`
--

DROP TABLE IF EXISTS `fieldgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fieldgroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qqgstwxncipctjliafkmgpzsqqfbthukxnpm` (`name`),
  KEY `idx_xowwocdovxbalrikawiklasrchbbbtsqrhtl` (`dateDeleted`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayoutfields`
--

DROP TABLE IF EXISTS `fieldlayoutfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fieldlayoutfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `tabId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_cddebmyjjphlknmztjulakqslxjlepedrtpi` (`layoutId`,`fieldId`),
  KEY `idx_gaiygwqzkkytcxmcsgvhoxheulfhdatdsqrv` (`sortOrder`),
  KEY `idx_yzzdipnwmymrfmuppbtutchmswenzsmyadbg` (`tabId`),
  KEY `idx_mfsscijwnkkdaxutzrjxhwxeclvhsttwdqtm` (`fieldId`),
  CONSTRAINT `fk_bokcfewsbjvqlzxjiclzmgxhrxiquigbgmud` FOREIGN KEY (`layoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pvedbgbyeoaqhetfmubijzwsipywuhzisood` FOREIGN KEY (`tabId`) REFERENCES `fieldlayouttabs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vyuxgellfabzmqohvylfathewrxxfjetoamc` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouts`
--

DROP TABLE IF EXISTS `fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_jegnkimxhuerjsegukmaqouyobsdulbodegg` (`dateDeleted`),
  KEY `idx_anvtmxnzzeweomsszsopcsfdhszqbxvhghxl` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouttabs`
--

DROP TABLE IF EXISTS `fieldlayouttabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fieldlayouttabs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `settings` text,
  `elements` text,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_kzwrkhzvescmfjyxcqadugiojpbkpbricvxf` (`sortOrder`),
  KEY `idx_rtldtcehkereptxaofttfcxjzwagthflehlc` (`layoutId`),
  CONSTRAINT `fk_dmaaijolzclpvmpzkbsiixocakovvdjpaajr` FOREIGN KEY (`layoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `context` varchar(255) NOT NULL DEFAULT 'global',
  `columnSuffix` char(8) DEFAULT NULL,
  `instructions` text,
  `searchable` tinyint(1) NOT NULL DEFAULT '1',
  `translationMethod` varchar(255) NOT NULL DEFAULT 'none',
  `translationKeyFormat` text,
  `type` varchar(255) NOT NULL,
  `settings` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ryapqobflpdllzmhryxjqjzdibwqfspghnqx` (`handle`,`context`),
  KEY `idx_avwomuewvsxnbnvpuvmvwmfaqagmpyfzdooh` (`groupId`),
  KEY `idx_evvtxdgiwakazijerscubayveipkipgovfgj` (`context`),
  CONSTRAINT `fk_sukzptvbndzbrfmbpppgowodqcpuklwpxikw` FOREIGN KEY (`groupId`) REFERENCES `fieldgroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_crm_fields`
--

DROP TABLE IF EXISTS `freeform_crm_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_crm_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `label` text NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `required` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_crm_fields_type_idx` (`type`),
  KEY `freeform_crm_fields_integrationId_fk` (`integrationId`),
  CONSTRAINT `freeform_crm_fields_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_export_notifications`
--

DROP TABLE IF EXISTS `freeform_export_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_export_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profileId` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `fileType` varchar(30) NOT NULL,
  `fileName` varchar(255) DEFAULT NULL,
  `frequency` varchar(20) NOT NULL,
  `recipients` text NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `freeform_export_notifications_profileId_fk` (`profileId`),
  CONSTRAINT `freeform_export_notifications_profileId_fk` FOREIGN KEY (`profileId`) REFERENCES `freeform_export_profiles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_export_profiles`
--

DROP TABLE IF EXISTS `freeform_export_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_export_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `limit` int(11) DEFAULT NULL,
  `dateRange` varchar(255) DEFAULT NULL,
  `rangeStart` varchar(255) DEFAULT NULL,
  `rangeEnd` varchar(255) DEFAULT NULL,
  `fields` text NOT NULL,
  `filters` text,
  `statuses` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `freeform_export_profiles_formId_fk` (`formId`),
  CONSTRAINT `freeform_export_profiles_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_export_settings`
--

DROP TABLE IF EXISTS `freeform_export_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_export_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `setting` mediumtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_export_settings_userId_fk` (`userId`),
  CONSTRAINT `freeform_export_settings_userId_fk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_feed_messages`
--

DROP TABLE IF EXISTS `freeform_feed_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_feed_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feedId` int(11) NOT NULL,
  `message` text NOT NULL,
  `conditions` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `seen` tinyint(1) NOT NULL DEFAULT '0',
  `issueDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_feed_messages_feedId_fk` (`feedId`),
  CONSTRAINT `freeform_feed_messages_feedId_fk` FOREIGN KEY (`feedId`) REFERENCES `freeform_feeds` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_feeds`
--

DROP TABLE IF EXISTS `freeform_feeds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_feeds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hash` varchar(255) NOT NULL,
  `min` varchar(255) DEFAULT NULL,
  `max` varchar(255) DEFAULT NULL,
  `issueDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_feeds_hash_unq_idx` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_fields`
--

DROP TABLE IF EXISTS `freeform_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `required` tinyint(1) DEFAULT '0',
  `instructions` text,
  `metaProperties` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`),
  KEY `freeform_fields_type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms`
--

DROP TABLE IF EXISTS `freeform_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `name` varchar(100) NOT NULL,
  `handle` varchar(100) NOT NULL,
  `spamBlockCount` int(11) unsigned NOT NULL DEFAULT '0',
  `submissionTitleFormat` varchar(255) NOT NULL,
  `description` text,
  `layoutJson` mediumtext,
  `metadata` mediumtext,
  `returnUrl` varchar(255) DEFAULT NULL,
  `defaultStatus` int(11) unsigned DEFAULT NULL,
  `formTemplateId` int(11) unsigned DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `optInDataStorageTargetHash` varchar(20) DEFAULT NULL,
  `limitFormSubmissions` varchar(20) DEFAULT NULL,
  `extraPostUrl` varchar(255) DEFAULT NULL,
  `extraPostTriggerPhrase` varchar(255) DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `gtmEnabled` tinyint(1) DEFAULT '0',
  `gtmId` varchar(255) DEFAULT NULL,
  `gtmEventName` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_integrations`
--

DROP TABLE IF EXISTS `freeform_integrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_integrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `class` varchar(255) DEFAULT NULL,
  `accessToken` text,
  `settings` text,
  `forceUpdate` tinyint(1) DEFAULT '0',
  `lastUpdate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`),
  KEY `freeform_integrations_type_idx` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_integrations_queue`
--

DROP TABLE IF EXISTS `freeform_integrations_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_integrations_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submissionId` int(11) NOT NULL,
  `integrationType` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `fieldHash` varchar(20) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_integrations_queue_status_idx` (`status`),
  KEY `freeform_integrations_queue_submissionId_fk` (`submissionId`),
  CONSTRAINT `freeform_integrations_queue_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_lock`
--

DROP TABLE IF EXISTS `freeform_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_lock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_lock_key_dateCreated_idx` (`key`,`dateCreated`),
  KEY `freeform_lock_dateCreated_idx` (`dateCreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_mailing_list_fields`
--

DROP TABLE IF EXISTS `freeform_mailing_list_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_mailing_list_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mailingListId` int(11) NOT NULL,
  `label` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `required` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_mailing_list_fields_type_idx` (`type`),
  KEY `freeform_mailing_list_fields_mailingListId_fk` (`mailingListId`),
  CONSTRAINT `freeform_mailing_list_fields_mailingListId_fk` FOREIGN KEY (`mailingListId`) REFERENCES `freeform_mailing_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_mailing_lists`
--

DROP TABLE IF EXISTS `freeform_mailing_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_mailing_lists` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `resourceId` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `memberCount` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_mailing_lists_integrationId_resourceId_unq_idx` (`integrationId`,`resourceId`),
  CONSTRAINT `freeform_mailing_lists_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_notification_log`
--

DROP TABLE IF EXISTS `freeform_notification_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_notification_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_notification_log_type_dateCreated_idx` (`type`,`dateCreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_notifications`
--

DROP TABLE IF EXISTS `freeform_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `description` text,
  `fromName` varchar(255) NOT NULL,
  `fromEmail` varchar(255) NOT NULL,
  `replyToName` varchar(255) DEFAULT NULL,
  `replyToEmail` varchar(255) DEFAULT NULL,
  `cc` varchar(255) DEFAULT NULL,
  `bcc` varchar(255) DEFAULT NULL,
  `bodyHtml` text,
  `bodyText` text,
  `autoText` tinyint(1) NOT NULL DEFAULT '1',
  `includeAttachments` tinyint(1) DEFAULT '1',
  `presetAssets` varchar(255) DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_payment_gateway_fields`
--

DROP TABLE IF EXISTS `freeform_payment_gateway_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_payment_gateway_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `label` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `required` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_payment_gateway_fields_type_idx` (`type`),
  KEY `freeform_payment_gateway_fields_integrationId_fk` (`integrationId`),
  CONSTRAINT `freeform_payment_gateway_fields_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_payments_payments`
--

DROP TABLE IF EXISTS `freeform_payments_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_payments_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `submissionId` int(11) NOT NULL,
  `subscriptionId` int(11) DEFAULT NULL,
  `resourceId` varchar(50) DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `last4` smallint(6) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `metadata` mediumtext,
  `errorCode` varchar(20) DEFAULT NULL,
  `errorMessage` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_payments_payments_integrationId_resourceId_unq_idx` (`integrationId`,`resourceId`),
  KEY `freeform_payments_payments_submissionId_fk` (`submissionId`),
  KEY `freeform_payments_payments_subscriptionId_fk` (`subscriptionId`),
  CONSTRAINT `freeform_payments_payments_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_payments_payments_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_payments_payments_subscriptionId_fk` FOREIGN KEY (`subscriptionId`) REFERENCES `freeform_payments_subscriptions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_payments_subscription_plans`
--

DROP TABLE IF EXISTS `freeform_payments_subscription_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_payments_subscription_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `resourceId` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_payments_subscription_plans_integrationId_fk` (`integrationId`),
  CONSTRAINT `freeform_payments_subscription_plans_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_payments_subscriptions`
--

DROP TABLE IF EXISTS `freeform_payments_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_payments_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `submissionId` int(11) NOT NULL,
  `planId` int(11) NOT NULL,
  `resourceId` varchar(50) DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `interval` varchar(20) DEFAULT NULL,
  `intervalCount` smallint(6) DEFAULT NULL,
  `last4` smallint(6) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `metadata` mediumtext,
  `errorCode` varchar(20) DEFAULT NULL,
  `errorMessage` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_payments_subscriptions_integrationId_resourceId_unq_idx` (`integrationId`,`resourceId`),
  KEY `freeform_payments_subscriptions_submissionId_fk` (`submissionId`),
  KEY `freeform_payments_subscriptions_planId_fk` (`planId`),
  CONSTRAINT `freeform_payments_subscriptions_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_payments_subscriptions_planId_fk` FOREIGN KEY (`planId`) REFERENCES `freeform_payments_subscription_plans` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_payments_subscriptions_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_saved_forms`
--

DROP TABLE IF EXISTS `freeform_saved_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_saved_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sessionId` varchar(100) DEFAULT NULL,
  `formId` int(11) NOT NULL,
  `token` varchar(100) NOT NULL,
  `payload` mediumtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_saved_forms_token_idx` (`token`),
  KEY `freeform_saved_forms_dateCreated_idx` (`dateCreated`),
  KEY `freeform_saved_forms_sessionId_idx` (`sessionId`),
  KEY `freeform_saved_forms_formId_fk` (`formId`),
  CONSTRAINT `freeform_saved_forms_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_session_context`
--

DROP TABLE IF EXISTS `freeform_session_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_session_context` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contextKey` varchar(100) NOT NULL,
  `sessionId` varchar(100) NOT NULL,
  `formId` int(11) NOT NULL,
  `propertyBag` mediumtext,
  `attributeBag` mediumtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_session_context_contextKey_formId_idx` (`contextKey`,`formId`),
  KEY `freeform_session_context_sessionId_idx` (`sessionId`),
  KEY `freeform_session_context_formId_fk` (`formId`),
  CONSTRAINT `freeform_session_context_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_spam_reason`
--

DROP TABLE IF EXISTS `freeform_spam_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_spam_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submissionId` int(11) NOT NULL,
  `reasonType` varchar(100) NOT NULL,
  `reasonMessage` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_spam_reason_submissionId_reasonType_idx` (`submissionId`,`reasonType`),
  CONSTRAINT `freeform_spam_reason_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_statuses`
--

DROP TABLE IF EXISTS `freeform_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `color` varchar(30) DEFAULT NULL,
  `isDefault` tinyint(1) DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_submission_notes`
--

DROP TABLE IF EXISTS `freeform_submission_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_submission_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submissionId` int(11) NOT NULL,
  `note` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_submission_notes_submissionId_fk` (`submissionId`),
  CONSTRAINT `freeform_submission_notes_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_submissions`
--

DROP TABLE IF EXISTS `freeform_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_submissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `incrementalId` int(11) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  `statusId` int(11) DEFAULT NULL,
  `formId` int(11) NOT NULL,
  `token` varchar(100) NOT NULL,
  `ip` varchar(46) DEFAULT NULL,
  `isSpam` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_submissions_incrementalId_unq_idx` (`incrementalId`),
  UNIQUE KEY `freeform_submissions_token_unq_idx` (`token`),
  KEY `freeform_submissions_userId_fk` (`userId`),
  KEY `freeform_submissions_formId_fk` (`formId`),
  KEY `freeform_submissions_statusId_fk` (`statusId`),
  CONSTRAINT `freeform_submissions_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_submissions_id_fk` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_submissions_statusId_fk` FOREIGN KEY (`statusId`) REFERENCES `freeform_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_submissions_userId_fk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_unfinalized_files`
--

DROP TABLE IF EXISTS `freeform_unfinalized_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_unfinalized_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assetId` int(11) NOT NULL,
  `fieldHandle` varchar(255) DEFAULT NULL,
  `formToken` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_unfinalized_files_fieldHandle_formToken_idx` (`fieldHandle`,`formToken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_webhooks`
--

DROP TABLE IF EXISTS `freeform_webhooks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_webhooks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `webhook` varchar(255) NOT NULL,
  `settings` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_webhooks_type_idx` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_webhooks_form_relations`
--

DROP TABLE IF EXISTS `freeform_webhooks_form_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `freeform_webhooks_form_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `webhookId` int(11) NOT NULL,
  `formId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_webhooks_form_relations_webhookId_idx` (`webhookId`),
  KEY `freeform_webhooks_form_relations_formId_idx` (`formId`),
  CONSTRAINT `freeform_webhooks_form_relations_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_webhooks_form_relations_webhookId_fk` FOREIGN KEY (`webhookId`) REFERENCES `freeform_webhooks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globalsets`
--

DROP TABLE IF EXISTS `globalsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `globalsets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wsxlpwwacrqjtfrayndbxuezsfoasbtczdqc` (`name`),
  KEY `idx_dxptdbtnpzlfwhjtrmzkxaqyjtgcdaubpuxi` (`handle`),
  KEY `idx_cbsshnybruvlqaykzvmzskgpbsmquwrhjmux` (`fieldLayoutId`),
  KEY `idx_wxoavqeyxzqenemrobxbecwamspbdcqywbxf` (`sortOrder`),
  CONSTRAINT `fk_lcfurqccglookqadzzjjqbaorttebnwfvrlf` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_msljibbpdgpksyfqluzkmxkgykosqlfnqzkz` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqlschemas`
--

DROP TABLE IF EXISTS `gqlschemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gqlschemas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `scope` text,
  `isPublic` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqltokens`
--

DROP TABLE IF EXISTS `gqltokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gqltokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `accessToken` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `expiryDate` datetime DEFAULT NULL,
  `lastUsed` datetime DEFAULT NULL,
  `schemaId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_qjdywawzwqhvbmjjxrgbuovfrufyehzurixc` (`accessToken`),
  UNIQUE KEY `idx_lpixzeafwhrviyxwgbgmivtkcpsetxwghdgf` (`name`),
  KEY `fk_nyyfzrawtqbktpsjlnyrmhfvpmbjwnuxzhmc` (`schemaId`),
  CONSTRAINT `fk_nyyfzrawtqbktpsjlnyrmhfvpmbjwnuxzhmc` FOREIGN KEY (`schemaId`) REFERENCES `gqlschemas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransformindex`
--

DROP TABLE IF EXISTS `imagetransformindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imagetransformindex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assetId` int(11) NOT NULL,
  `transformer` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `transformString` varchar(255) NOT NULL,
  `fileExists` tinyint(1) NOT NULL DEFAULT '0',
  `inProgress` tinyint(1) NOT NULL DEFAULT '0',
  `error` tinyint(1) NOT NULL DEFAULT '0',
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_rmgyxwzugsxjramvsqntxnnfivrjalpveyrp` (`assetId`,`transformString`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransforms`
--

DROP TABLE IF EXISTS `imagetransforms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imagetransforms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `mode` enum('stretch','fit','crop','letterbox') NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') NOT NULL DEFAULT 'center-center',
  `width` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `quality` int(11) DEFAULT NULL,
  `interlace` enum('none','line','plane','partition') NOT NULL DEFAULT 'none',
  `fill` varchar(11) DEFAULT NULL,
  `upscale` tinyint(1) NOT NULL DEFAULT '1',
  `parameterChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qjsihtsydcsefptofqsuutdlwueywmrleooh` (`name`),
  KEY `idx_tejofqwttqibhqsrwczqahyaimdflofemezg` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `info`
--

DROP TABLE IF EXISTS `info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) NOT NULL,
  `schemaVersion` varchar(15) NOT NULL,
  `maintenance` tinyint(1) NOT NULL DEFAULT '0',
  `configVersion` char(12) NOT NULL DEFAULT '000000000000',
  `fieldVersion` char(12) NOT NULL DEFAULT '000000000000',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocks`
--

DROP TABLE IF EXISTS `matrixblocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `matrixblocks` (
  `id` int(11) NOT NULL,
  `primaryOwnerId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `typeId` int(11) NOT NULL,
  `deletedWithOwner` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_qwcywwpouhavkuikwmfpwctbtqtuuurbvfhy` (`primaryOwnerId`),
  KEY `idx_pnqprfijhlzfvvxtjmaiobusfugjlknpvmkr` (`fieldId`),
  KEY `idx_smwmaqayuhtwczfgigezzmloklqiezswmnjd` (`typeId`),
  CONSTRAINT `fk_ahwgopvylonevvsrnwnglelmsoszlvyzexea` FOREIGN KEY (`typeId`) REFERENCES `matrixblocktypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_fodpepigrmyrbhpmfartzhdungdmitxgocnm` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hrqmhugwubcdegyqvlkkovclgbfvkyinnsmn` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lswgsrpoiunlnigfbbumqkxjrypwcmasfynp` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocks_owners`
--

DROP TABLE IF EXISTS `matrixblocks_owners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `matrixblocks_owners` (
  `blockId` int(11) NOT NULL,
  `ownerId` int(11) NOT NULL,
  `sortOrder` smallint(6) unsigned NOT NULL,
  PRIMARY KEY (`blockId`,`ownerId`),
  KEY `fk_hzrybcrrlvtnpcttsgbflghzhgjcdlwingqu` (`ownerId`),
  CONSTRAINT `fk_hzrybcrrlvtnpcttsgbflghzhgjcdlwingqu` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_inqtuyoeajdlbhstztmaowzyfpuvqgtuqqbk` FOREIGN KEY (`blockId`) REFERENCES `matrixblocks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocktypes`
--

DROP TABLE IF EXISTS `matrixblocktypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `matrixblocktypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_sbcwokvagwrjpqrldugrtpxwxmdmeqbqdifq` (`name`,`fieldId`),
  KEY `idx_zrbwhvloaflmiojyhmocceybeeltmuyjuehl` (`handle`,`fieldId`),
  KEY `idx_nkvsbhqrewsseavszzijfxxcowyblbajclxx` (`fieldId`),
  KEY `idx_hmhjcbqgdbssglqojopuvunzwccvrhtzglpx` (`fieldLayoutId`),
  CONSTRAINT `fk_otzruqojucsyrwqrckekgfrpugzuhfucibgf` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_utwbtrzbrvptdjrqncokjatywemhgnyxdcem` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixcontent_contacts`
--

DROP TABLE IF EXISTS `matrixcontent_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `matrixcontent_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  `field_contact_contact_cjxyhlvz` text,
  `field_contact_label_ayfhcoen` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_oyqjlflbjfyreftfvgngfzdkvwsyveopqdms` (`elementId`,`siteId`),
  KEY `fk_jpngmjcxrkjjmqrcfwxlpmapybocrlycbowo` (`siteId`),
  CONSTRAINT `fk_ancjsziemlwocjobipnbzasnwtblatdgczng` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jpngmjcxrkjjmqrcfwxlpmapybocrlycbowo` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixcontent_linkimages`
--

DROP TABLE IF EXISTS `matrixcontent_linkimages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `matrixcontent_linkimages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  `field_link_imageLink_opghxuag` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_rqxslrejrshdvftcgfndptalacmnbuxqvsyi` (`elementId`,`siteId`),
  KEY `fk_fzcbaoqspwinlvnuyyrwldwrsvxvgzbceqmz` (`siteId`),
  CONSTRAINT `fk_fzcbaoqspwinlvnuyyrwldwrsvxvgzbceqmz` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_lczeoyupnqvprxxifidksoaqdrcqxpdfohjq` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixcontent_linkspdf`
--

DROP TABLE IF EXISTS `matrixcontent_linkspdf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `matrixcontent_linkspdf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  `field_link_label_wzfzgsfg` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_lnbrpgayanrbdbpxyezomjpspccvyvunprxf` (`elementId`,`siteId`),
  KEY `fk_fwyjburrqeorpvlksexpsiuefqeotmgnlpkp` (`siteId`),
  CONSTRAINT `fk_fwyjburrqeorpvlksexpsiuefqeotmgnlpkp` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_jwpipjybzknpoixbphcrjxxxcskyslojhpwt` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixcontent_socials`
--

DROP TABLE IF EXISTS `matrixcontent_socials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `matrixcontent_socials` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  `field_social_social_url_ivwrtsfp` varchar(255) DEFAULT NULL,
  `field_social_label_qlcwkydz` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gyogavmzmssqzniobmsocyyswjebhgldjgml` (`elementId`,`siteId`),
  KEY `fk_waiddnuxwoqjbnhasetxdfpivmlzndiusxzm` (`siteId`),
  CONSTRAINT `fk_fwthbkzsxezkokwotkfqkqolrrrlhefwzrdb` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_waiddnuxwoqjbnhasetxdfpivmlzndiusxzm` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `track` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ukmrwfklwnskidofdfqkwwhombeisobgczfi` (`track`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `olivemenus`
--

DROP TABLE IF EXISTS `olivemenus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `olivemenus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `handle` varchar(255) NOT NULL DEFAULT '',
  `site_id` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_sixguezptozqdcvclgqvckpqzygjjzqawoqg` (`name`),
  UNIQUE KEY `idx_eialdvabetkovcrlojfihmauhahbsremvdmk` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `olivemenus_items`
--

DROP TABLE IF EXISTS `olivemenus_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `olivemenus_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `entry_id` int(11) DEFAULT NULL,
  `custom_url` varchar(255) DEFAULT NULL,
  `class` varchar(255) DEFAULT NULL,
  `class_parent` varchar(255) DEFAULT NULL,
  `data_json` varchar(255) DEFAULT NULL,
  `target` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_xpoxeidkqouemhznjhuyurbmnphvelnwpnih` (`menu_id`),
  CONSTRAINT `fk_xpoxeidkqouemhznjhuyurbmnphvelnwpnih` FOREIGN KEY (`menu_id`) REFERENCES `olivemenus` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `schemaVersion` varchar(255) NOT NULL,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_lqdhzltmcnvudgxehdostrnjciwcenxtoecw` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `projectconfig`
--

DROP TABLE IF EXISTS `projectconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `projectconfig` (
  `path` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) NOT NULL DEFAULT 'queue',
  `job` longblob NOT NULL,
  `description` text,
  `timePushed` int(11) NOT NULL,
  `ttr` int(11) NOT NULL,
  `delay` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) unsigned NOT NULL DEFAULT '1024',
  `dateReserved` datetime DEFAULT NULL,
  `timeUpdated` int(11) DEFAULT NULL,
  `progress` smallint(6) NOT NULL DEFAULT '0',
  `progressLabel` varchar(255) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `fail` tinyint(1) DEFAULT '0',
  `dateFailed` datetime DEFAULT NULL,
  `error` text,
  PRIMARY KEY (`id`),
  KEY `idx_nijxiywlpnnqtkmlcirobeljtkkiwtwtveag` (`channel`,`fail`,`timeUpdated`,`timePushed`),
  KEY `idx_zggstncszgzeokflraaewndvximgrfibttzl` (`channel`,`fail`,`timeUpdated`,`delay`)
) ENGINE=InnoDB AUTO_INCREMENT=842 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relations`
--

DROP TABLE IF EXISTS `relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceSiteId` int(11) DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vbcfremrunxmfdpyqdjqscewfzunzrltaskk` (`fieldId`,`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_dvdbztpfwjloqmaewccwnpzylbvgvrhwbdfs` (`sourceId`),
  KEY `idx_rnoisvmcvrksoehkdfvzhaehmkrjqvobxdck` (`targetId`),
  KEY `idx_hbmhffhtkgpiljrcmaktsuybcfdsdrixugay` (`sourceSiteId`),
  CONSTRAINT `fk_jydnzksgyxvwfobvwgtxxrwrvcwldlpcjald` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ufpntrpnynfyhobjmyhhomemazysebyfrzxi` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zjobnstgfscafemjmvuglcgdfgsckkvswnxz` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=463 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `resourcepaths`
--

DROP TABLE IF EXISTS `resourcepaths`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `resourcepaths` (
  `hash` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `revisions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) NOT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `num` int(11) NOT NULL,
  `notes` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_oigjyjolorgzjtqcvdlujrfpldxzguqupctk` (`canonicalId`,`num`),
  KEY `fk_viwtpypksaqsrgwaddrupwggcrvykvsxchsc` (`creatorId`),
  CONSTRAINT `fk_viwtpypksaqsrgwaddrupwggcrvykvsxchsc` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_xjsoswgmvtburbwyaybbfsjaohjculaasbsp` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindex`
--

DROP TABLE IF EXISTS `searchindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `searchindex` (
  `elementId` int(11) NOT NULL,
  `attribute` varchar(25) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `keywords` text NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`siteId`),
  FULLTEXT KEY `idx_delhrfnhhdawvgvpmgziunhzvqvhqozsgqrg` (`keywords`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` enum('single','channel','structure') NOT NULL DEFAULT 'channel',
  `enableVersioning` tinyint(1) NOT NULL DEFAULT '0',
  `propagationMethod` varchar(255) NOT NULL DEFAULT 'all',
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `previewTargets` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_yezorebiguhgmpmgdusqtdeahzikyfrazolm` (`handle`),
  KEY `idx_axwavyocrothghudilsjfwgqapenqsabeowl` (`name`),
  KEY `idx_pumtylkguhtusqkqsegeungyvislgxxxcktx` (`structureId`),
  KEY `idx_fbvacfhzcwdiivqireabrwkkdhbzpvzvjrqi` (`dateDeleted`),
  CONSTRAINT `fk_lewhmfhkrojdkthbzmuyhkffwjpvpqndfncm` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_sites`
--

DROP TABLE IF EXISTS `sections_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sections_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text,
  `template` varchar(500) DEFAULT NULL,
  `enabledByDefault` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wfjibbmbpxujqcuslaekejodgpfmgkvjgjdt` (`sectionId`,`siteId`),
  KEY `idx_iupxjufvujmargukqqsiubpvinrgbmdahogg` (`siteId`),
  CONSTRAINT `fk_ooaoebchdbslmspmzbqqpxzjcalgdanpoybg` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_qridyyvinldsdojwmbhztudtqkzigwzcijuh` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `seo_redirects`
--

DROP TABLE IF EXISTS `seo_redirects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `seo_redirects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) NOT NULL,
  `to` varchar(255) NOT NULL,
  `type` enum('301','302') NOT NULL,
  `siteId` int(11) DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `seo_sitemap`
--

DROP TABLE IF EXISTS `seo_sitemap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `seo_sitemap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group` enum('sections','categories','productTypes','customUrls') NOT NULL,
  `url` varchar(255) NOT NULL,
  `frequency` enum('always','hourly','daily','weekly','monthly','yearly','never') NOT NULL,
  `priority` float NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequences`
--

DROP TABLE IF EXISTS `sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sequences` (
  `name` varchar(255) NOT NULL,
  `next` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `token` char(100) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_hbaqsziczdksygutkjphypznmtqsgfhwhrwa` (`uid`),
  KEY `idx_kkbsirqsuwjmeiormfdzylbaonadahzeahxs` (`token`),
  KEY `idx_rdxrcahphlslttydxkywiqkjwmsljsdjnonw` (`dateUpdated`),
  KEY `idx_hhjqyfbwvzvkjpxqasphddkylpxqofoxrfih` (`userId`),
  CONSTRAINT `fk_xzvjwkyfpgcwhlnvyrerfjsgcffodvlxpxzk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shunnedmessages`
--

DROP TABLE IF EXISTS `shunnedmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shunnedmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `message` varchar(255) NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ybxkdmwgapmktycsiljnnlkzwuaxncfycium` (`userId`,`message`),
  CONSTRAINT `fk_icnnzsrecygejzisjwymfvmlmcxluayioumq` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitegroups`
--

DROP TABLE IF EXISTS `sitegroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sitegroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lvwanyobinyhfukbcsxaizsczadjncbojtmz` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sites`
--

DROP TABLE IF EXISTS `sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `primary` tinyint(1) NOT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `language` varchar(12) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '0',
  `baseUrl` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_atqjxsxfwqkckbylmxpfsugtdjwjzkkyqine` (`dateDeleted`),
  KEY `idx_gczjslwneehvipcbtcjjwodlkwdjqmeeeqvj` (`handle`),
  KEY `idx_nefsqkdmeefignnjzwguaupjcalntciigzml` (`sortOrder`),
  KEY `fk_macqrngvefrlcfqnoafcxlxdrmlvfontfmyv` (`groupId`),
  CONSTRAINT `fk_macqrngvefrlcfqnoafcxlxdrmlvfontfmyv` FOREIGN KEY (`groupId`) REFERENCES `sitegroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structureelements`
--

DROP TABLE IF EXISTS `structureelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `structureelements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `elementId` int(11) DEFAULT NULL,
  `root` int(11) unsigned DEFAULT NULL,
  `lft` int(11) unsigned NOT NULL,
  `rgt` int(11) unsigned NOT NULL,
  `level` smallint(6) unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_logvnvmzetqzdpgzwfdfuxllforwthtvqdck` (`structureId`,`elementId`),
  KEY `idx_vlpezellkdrldexjlxfqjvfbwosvgenywnkk` (`root`),
  KEY `idx_nxqzruidpwwmngiigcopsuvtadwycexglrru` (`lft`),
  KEY `idx_rxcmpcsfrclceserzkkozwkwwayloquxrmxt` (`rgt`),
  KEY `idx_wxufmbygyeccxwyqgovvyuwrbukdqzhtuuxk` (`level`),
  KEY `idx_gdyoeghractqxijxvgiyxzlgceghgiuiczhn` (`elementId`),
  CONSTRAINT `fk_wmtdvmujaqhmnaamilnoqtbbdzsrntbkxgpx` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structures`
--

DROP TABLE IF EXISTS `structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `structures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_oemfqusulgxvnxsvzjhdrxllmocmgkmqzdyy` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systemmessages`
--

DROP TABLE IF EXISTS `systemmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `systemmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_iqljanwnwgswozyoxbbitmooyreieauztbaf` (`key`,`language`),
  KEY `idx_epxvqmidijnfdxbercnihfxrhfburmvodkny` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taggroups`
--

DROP TABLE IF EXISTS `taggroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taggroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zrnjhceqqptaaarfgbrrocggztaqvoinfmnk` (`name`),
  KEY `idx_igpquvwvqcqzmhvuqvrtwcjbxvwexvegeyxc` (`handle`),
  KEY `idx_vehizpdlrvjhvxwzgqkelyrlygpgcycuvlsj` (`dateDeleted`),
  KEY `fk_fveactxycchvygtwnabcjdiuswxgvsjsrxox` (`fieldLayoutId`),
  CONSTRAINT `fk_fveactxycchvygtwnabcjdiuswxgvsjsrxox` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_dcetxnexxqhupkwbpnarhmemjnmdneiwlgvo` (`groupId`),
  CONSTRAINT `fk_bcytxetfwgyyreegllirvomdinjfvfvjgafm` FOREIGN KEY (`groupId`) REFERENCES `taggroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zutiisijeuermojhgmlsugbcegjzghraelhq` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` char(32) NOT NULL,
  `route` text,
  `usageLimit` tinyint(3) unsigned DEFAULT NULL,
  `usageCount` tinyint(3) unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_pbxlrxkjwaviwqwnfehhsxipskypjcptprnj` (`token`),
  KEY `idx_hmhpnomtcpeeoqpycrhagmcgxpzefbashjxj` (`expiryDate`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups`
--

DROP TABLE IF EXISTS `usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_awrlyhdfbmtjvymuuuamwxgaeodruusfokag` (`handle`),
  KEY `idx_oedrufpjgxkavtqejibswrcsynfdkzutsinw` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups_users`
--

DROP TABLE IF EXISTS `usergroups_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usergroups_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_eaxlmhcqzbezjhnjauijmhtepaoxxsqzbrrp` (`groupId`,`userId`),
  KEY `idx_znhpnlrssusuglaqlepnynlibqnatpljjibh` (`userId`),
  CONSTRAINT `fk_gyvwlwczcwlhqsywxvccbyfwycxougrjkgtp` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yckdewpgviywhtxwvjeiuusmtdvxomvsxbwh` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions`
--

DROP TABLE IF EXISTS `userpermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userpermissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gmsgmdpjzguaaegwotjnowxgrqaffcdsifpk` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_usergroups`
--

DROP TABLE IF EXISTS `userpermissions_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userpermissions_usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_becfixfufreavhnfriigwmoxzhxsvlgyzewe` (`permissionId`,`groupId`),
  KEY `idx_dliabyhgfwgyvvigdykurytasprgrbdnbgid` (`groupId`),
  CONSTRAINT `fk_ieygluntssqagxkcsnxplkameotpejxnsgtu` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_saaggwsitmabhqynvgrjdxyepiqdniqmotga` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_users`
--

DROP TABLE IF EXISTS `userpermissions_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userpermissions_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_pgtglcidmifbueimekiyauoxcklbzcfgyfjm` (`permissionId`,`userId`),
  KEY `idx_nyjxtldchsqzjsieodruihwiumandeyqyikl` (`userId`),
  CONSTRAINT `fk_simyeuuztdzotgsgeaamapmllwvknumlylfm` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_snabijgdcbgurgtxbqziqefovwuplnoxzhfu` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpreferences`
--

DROP TABLE IF EXISTS `userpreferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userpreferences` (
  `userId` int(11) NOT NULL AUTO_INCREMENT,
  `preferences` text,
  PRIMARY KEY (`userId`),
  CONSTRAINT `fk_jhjwzxgdljggfrtzjdmbxorgtsottwhaadxi` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `photoId` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `username` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIp` varchar(45) DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint(3) unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `hasDashboard` tinyint(1) NOT NULL DEFAULT '0',
  `verificationCode` varchar(255) DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) DEFAULT NULL,
  `passwordResetRequired` tinyint(1) NOT NULL DEFAULT '0',
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_janrxdfomtzcssampdtvenltkffrafdtcvws` (`active`),
  KEY `idx_fqeuczlnhaahqfpkofzgkjyteoubhislrnmm` (`locked`),
  KEY `idx_dvpeukfufokucsnryrfzjujbqibgzvrwpdxf` (`pending`),
  KEY `idx_hoglppnwawwqlearrdelxtybprtvphubzvrj` (`suspended`),
  KEY `idx_zdpbmgwveogcgmcsymaghthnlyilyptxzjhl` (`verificationCode`),
  KEY `idx_jknateeyxfcqhcaizwzunbaaljuwxahafpwq` (`email`),
  KEY `idx_hzkkfsfrgatmrbyyitjiaaoghxldprttpuix` (`username`),
  KEY `fk_ayycygqtlmxpsnpnctgydjuwjomijvvvojks` (`photoId`),
  CONSTRAINT `fk_ayycygqtlmxpsnpnctgydjuwjomijvvvojks` FOREIGN KEY (`photoId`) REFERENCES `assets` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_zfzwtoobwvdwxjyvikttocgrmciknlkfjkpy` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumefolders`
--

DROP TABLE IF EXISTS `volumefolders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `volumefolders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) DEFAULT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_utvltvmiprddfqzinknqsgngkaxvpwnllgfe` (`name`,`parentId`,`volumeId`),
  KEY `idx_fghkpywxuwymbmbdaakrwgtjgxkftsgfzzcy` (`parentId`),
  KEY `idx_bepblzvluhnjbwnnczcvgvrgavmeswngewdy` (`volumeId`),
  CONSTRAINT `fk_bkhghvybegnmiumredfezsvjfsjjkradcuek` FOREIGN KEY (`parentId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_dyyrxidbadfusghttxhhqktuleeezcwzvzxj` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `volumes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fs` varchar(255) NOT NULL,
  `transformFs` varchar(255) DEFAULT NULL,
  `transformSubpath` varchar(255) DEFAULT NULL,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_oygajhulortrwmxniqcdggfycfahilnhtabp` (`name`),
  KEY `idx_kddnmgvkpvlsqzulwnuslkgxtlurstqzugle` (`handle`),
  KEY `idx_ijnjvhbkjchhyacpmgdualhkbjcaimggrrzz` (`fieldLayoutId`),
  KEY `idx_tyseocclrpjugjxwkghdzkmwdlokfxoxcxbx` (`dateDeleted`),
  CONSTRAINT `fk_uerlvyhsykymfebwetqysgkcbxzutsetwgql` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `colspan` tinyint(3) DEFAULT NULL,
  `settings` text,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qwcycceuvipwzfgvursxzewioniffklqsfyu` (`userId`),
  CONSTRAINT `fk_lttqhlmsjjzkbdkrhqzhqoihxaegjleyxeyr` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'cooperativamaism_junta'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-11 11:25:45
-- MySQL dump 10.13  Distrib 5.7.41, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: cooperativamaism_junta
-- ------------------------------------------------------
-- Server version	5.7.41

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `addresses`
--

LOCK TABLES `addresses` WRITE;
/*!40000 ALTER TABLE `addresses` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `addresses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assetindexingsessions`
--

LOCK TABLES `assetindexingsessions` WRITE;
/*!40000 ALTER TABLE `assetindexingsessions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `assetindexingsessions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets` VALUES (10,1,4,1,'favicon-junta-mesao-frio.png','image',NULL,320,320,74926,NULL,NULL,NULL,'2024-02-19 14:11:23','2024-02-19 14:11:24','2024-02-19 14:11:24'),(11,1,5,1,'meta-img.png','image',NULL,1200,728,119826,NULL,NULL,NULL,'2024-02-19 14:11:31','2024-02-19 14:11:31','2024-02-19 14:11:31'),(12,1,6,1,'logo.png','image',NULL,150,150,30236,NULL,0,0,'2024-02-19 14:12:12','2024-02-19 14:12:12','2024-02-19 14:12:12'),(13,1,6,1,'logo.png','image',NULL,150,150,30236,NULL,NULL,NULL,'2024-02-19 14:13:29','2024-02-19 14:13:29','2024-02-19 14:13:29'),(20,1,4,1,'favicon-junta-mesao-frio.ico','unknown',NULL,NULL,NULL,153272,NULL,NULL,NULL,'2024-02-20 17:19:07','2024-02-20 17:19:07','2024-02-20 17:19:07'),(21,1,7,1,'header-image.png','image','Header BG Image',1366,500,1161988,NULL,NULL,NULL,'2024-02-20 17:51:21','2024-02-20 17:51:21','2024-02-20 17:51:37'),(22,1,1,1,'footer_gradient_iefix.png','image',NULL,1,100,589,NULL,NULL,NULL,'2024-02-22 12:54:46','2024-02-22 12:54:46','2024-02-22 12:54:46'),(23,1,1,1,'header_gradient_iefix.png','image',NULL,1,300,1589,NULL,NULL,NULL,'2024-02-22 12:54:47','2024-02-22 12:54:47','2024-02-22 12:54:47'),(29,1,8,1,'facebook-icon.svg','image',NULL,35,35,849,NULL,NULL,NULL,'2024-02-22 14:28:01','2024-02-22 14:28:01','2024-02-22 14:28:01'),(32,1,9,1,'dummy-document.pdf','pdf',NULL,NULL,NULL,11314,NULL,NULL,NULL,'2024-02-22 14:57:54','2024-02-22 14:57:55','2024-02-22 14:57:55'),(39,1,1,1,'locale-widget-bg.jpg','image',NULL,1024,1539,130776,NULL,NULL,NULL,'2024-02-22 15:05:27','2024-02-22 15:05:27','2024-02-22 15:05:27'),(41,1,1,1,'image-3.png','image',NULL,311,336,45067,NULL,NULL,NULL,'2024-02-22 17:41:41','2024-02-22 17:41:41','2024-02-22 17:41:41'),(42,1,1,1,'image-5.png','image',NULL,345,170,87970,NULL,NULL,NULL,'2024-02-22 17:42:30','2024-02-22 17:42:30','2024-02-22 17:42:30'),(43,1,1,1,'image-2.png','image',NULL,311,336,42656,NULL,NULL,NULL,'2024-02-22 17:43:03','2024-02-22 17:43:03','2024-02-22 17:43:03'),(44,1,1,1,'image-5_2024-02-22-174308_uhvx.png','image',NULL,345,170,87970,NULL,NULL,NULL,'2024-02-22 17:43:08','2024-02-22 17:43:08','2024-02-22 17:43:08'),(47,1,10,1,'image-4.png','image',NULL,345,170,70513,NULL,NULL,NULL,'2024-02-22 17:49:38','2024-02-22 17:49:38','2024-02-22 17:49:38'),(48,1,11,1,'junta-mf-placeholder.jpg','image','Imagem Placeholder',643,350,21251,NULL,NULL,NULL,'2024-02-22 17:54:19','2024-02-22 17:54:19','2024-02-22 17:54:34'),(55,1,12,1,'news-image.png','image',NULL,643,350,364352,NULL,NULL,NULL,'2024-02-22 18:08:02','2024-02-22 18:08:02','2024-02-22 18:08:02'),(64,1,1,1,'news-text-image.png','image',NULL,583,291,213593,NULL,NULL,NULL,'2024-02-22 18:11:03','2024-02-22 18:11:03','2024-02-22 18:11:03'),(129,1,13,1,'event-image.png','image',NULL,643,160,136549,NULL,NULL,NULL,'2024-03-01 16:45:41','2024-03-01 16:45:41','2024-03-01 16:45:41'),(131,1,1,1,'event-image-text.png','image',NULL,583,291,214566,NULL,NULL,NULL,'2024-03-01 16:46:20','2024-03-01 16:46:20','2024-03-01 16:46:20'),(177,1,1,1,'dummy-document.pdf','pdf',NULL,NULL,NULL,11314,NULL,NULL,NULL,'2024-03-04 11:25:45','2024-03-04 11:25:45','2024-03-04 11:25:45'),(179,1,9,1,'dummy-document2.pdf','pdf',NULL,NULL,NULL,15776,NULL,NULL,NULL,'2024-03-04 11:26:07','2024-03-04 11:26:07','2024-03-04 11:26:07'),(183,1,14,1,'aviso_de_abertura_de_procedimento.pdf','pdf',NULL,NULL,NULL,270175,NULL,NULL,NULL,'2022-02-05 14:28:41','2022-02-05 14:28:41','2022-02-05 14:28:41'),(185,1,14,1,'formulario_de_candidatura.pdf','pdf',NULL,NULL,NULL,226845,NULL,NULL,NULL,'2024-03-05 14:29:15','2024-03-05 14:29:15','2024-03-05 14:29:15'),(191,1,15,1,'gallery_1.png','image',NULL,209,128,51658,NULL,NULL,NULL,'2024-03-05 14:49:55','2024-03-05 14:49:55','2024-03-05 14:49:55'),(192,1,15,1,'gallery_2.png','image',NULL,209,128,27266,NULL,NULL,NULL,'2024-03-05 14:49:56','2024-03-05 14:49:56','2024-03-05 14:49:56'),(194,1,15,1,'gallery_3.png','image',NULL,209,128,56572,NULL,NULL,NULL,'2024-03-05 14:49:59','2024-03-05 14:49:59','2024-03-05 14:49:59'),(195,1,15,1,'gallery_4.png','image',NULL,209,129,33877,NULL,NULL,NULL,'2024-03-05 14:50:03','2024-03-05 14:50:03','2024-03-05 14:50:03'),(221,1,16,1,'coletividade.png','image',NULL,100,100,21530,NULL,NULL,NULL,'2024-03-05 15:57:55','2024-03-05 15:57:55','2024-03-05 15:57:55'),(224,1,17,1,'coletividade_2.png','image',NULL,100,100,20624,NULL,NULL,NULL,'2024-03-05 15:59:13','2024-03-05 15:59:13','2024-03-05 15:59:13'),(227,1,16,1,'coletividade_3.png','image',NULL,100,100,26553,NULL,NULL,NULL,'2024-03-05 15:59:57','2024-03-05 15:59:57','2024-03-05 15:59:57'),(284,1,18,1,'hostory.png','image',NULL,583,350,488290,NULL,NULL,NULL,'2024-03-08 15:51:57','2024-03-08 15:51:57','2024-03-08 15:51:57'),(289,1,19,1,'logo-10-1.png','image',NULL,221,220,54134,NULL,NULL,NULL,'2024-03-08 16:02:35','2024-03-08 16:02:35','2024-03-08 16:02:35'),(290,1,19,1,'logo-10-2.png','image',NULL,221,220,43055,NULL,NULL,NULL,'2024-03-08 16:03:55','2024-03-08 16:03:55','2024-03-08 16:03:55'),(299,1,20,1,'patrimonio-1.png','image',NULL,583,350,217238,NULL,NULL,NULL,'2024-03-08 16:11:02','2024-03-08 16:11:02','2024-03-08 16:11:02'),(300,1,20,1,'patrimonio-2.png','image',NULL,583,350,367520,NULL,NULL,NULL,'2024-03-08 16:11:31','2024-03-08 16:11:31','2024-03-08 16:11:31'),(301,1,20,1,'patrimonio-3.png','image',NULL,583,350,440866,NULL,NULL,NULL,'2024-03-08 16:11:32','2024-03-08 16:11:32','2024-03-08 16:11:32'),(302,1,20,1,'patrimonio-4.png','image',NULL,583,350,432270,NULL,NULL,NULL,'2024-03-08 16:11:32','2024-03-08 16:11:33','2024-03-08 16:11:33'),(303,1,20,1,'patrimonio-5.png','image',NULL,583,350,432271,NULL,NULL,NULL,'2024-03-08 16:11:34','2024-03-08 16:11:34','2024-03-08 16:11:34'),(306,1,21,1,'patrimonio-natural-2.png','image',NULL,583,350,447160,NULL,NULL,NULL,'2024-03-08 16:16:18','2024-03-08 16:16:18','2024-03-08 16:16:18'),(307,1,21,1,'patrimonio-natural.png','image',NULL,583,350,454626,NULL,NULL,NULL,'2024-03-08 16:16:19','2024-03-08 16:16:19','2024-03-08 16:16:19'),(324,1,22,1,'johndoe.png','image',NULL,100,100,8951,NULL,NULL,NULL,'2024-03-08 17:19:21','2024-03-08 17:19:21','2024-03-08 17:19:21'),(327,1,23,1,'Rectangle-1.png','image',NULL,100,100,10995,NULL,NULL,NULL,'2024-03-08 17:19:50','2024-03-08 17:19:50','2024-03-08 17:19:50'),(331,1,24,1,'Rectangle-1.png','image',NULL,100,100,8065,NULL,NULL,NULL,'2024-03-08 17:20:23','2024-03-08 17:20:23','2024-03-08 17:20:23'),(335,1,25,1,'Rectangle-1.png','image',NULL,100,100,8247,NULL,NULL,NULL,'2024-03-08 17:21:17','2024-03-08 17:21:17','2024-03-08 17:21:17'),(338,1,26,1,'Rectangle-1.png','image',NULL,100,100,7175,NULL,NULL,NULL,'2024-03-08 17:21:46','2024-03-08 17:21:46','2024-03-08 17:21:46'),(343,1,27,1,'Rectangle-1.png','image',NULL,100,100,9633,NULL,NULL,NULL,'2024-03-08 17:33:54','2024-03-08 17:33:54','2024-03-08 17:33:54'),(346,1,28,1,'Rectangle-1.png','image',NULL,100,100,9573,NULL,NULL,NULL,'2024-03-08 17:34:32','2024-03-08 17:34:32','2024-03-08 17:34:32'),(349,1,29,1,'Rectangle-1.png','image',NULL,100,100,8148,NULL,NULL,NULL,'2024-03-08 17:35:10','2024-03-08 17:35:10','2024-03-08 17:35:10'),(369,1,30,1,'espaco-cidadao.png','image',NULL,281,184,20169,NULL,NULL,NULL,'2024-03-11 11:06:21','2024-03-11 11:06:21','2024-03-11 11:06:21'),(375,1,31,1,'payshop.png','image',NULL,246,409,181829,NULL,NULL,NULL,'2024-03-11 11:16:22','2024-03-11 11:16:22','2024-03-11 11:16:22'),(383,1,32,1,'pagaqui.png','image',NULL,281,115,16830,NULL,NULL,NULL,'2024-03-11 11:20:56','2024-03-11 11:20:56','2024-03-11 11:20:56');
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `categories` VALUES (51,1,NULL,NULL,'2024-02-22 18:06:25','2024-02-22 18:06:25'),(52,1,NULL,NULL,'2024-02-22 18:06:37','2024-02-22 18:06:37'),(53,1,NULL,NULL,'2024-02-22 18:06:47','2024-02-22 18:06:47'),(54,1,NULL,NULL,'2024-02-22 18:06:58','2024-02-22 18:06:58'),(220,2,NULL,NULL,'2024-03-05 15:56:57','2024-03-05 15:56:57'),(222,2,NULL,NULL,'2024-03-05 15:58:40','2024-03-05 15:58:40'),(225,2,NULL,NULL,'2024-03-05 15:59:22','2024-03-05 15:59:22'),(323,3,NULL,NULL,'2024-03-08 17:17:23','2024-03-08 17:17:23'),(326,3,NULL,NULL,'2024-03-08 17:19:32','2024-03-08 17:19:32'),(329,3,NULL,NULL,'2024-03-08 17:19:56','2024-03-08 17:19:56'),(333,3,NULL,NULL,'2024-03-08 17:20:48','2024-03-08 17:20:48'),(336,3,NULL,NULL,'2024-03-08 17:21:23','2024-03-08 17:21:23'),(342,4,NULL,NULL,'2024-03-08 17:33:32','2024-03-08 17:33:32'),(344,4,NULL,NULL,'2024-03-08 17:34:16','2024-03-08 17:34:16'),(347,4,NULL,NULL,'2024-03-08 17:34:47','2024-03-08 17:34:47');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups`
--

LOCK TABLES `categorygroups` WRITE;
/*!40000 ALTER TABLE `categorygroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `categorygroups` VALUES (1,1,16,'Categorias de Noticias','categoriasDeNoticias','end','2024-02-22 18:06:16','2024-02-22 18:06:16',NULL,'8ba433f7-e0da-4428-adb3-a8b33ceef2b9'),(2,2,23,'Coletividades','collectivities','end','2024-03-05 15:56:51','2024-03-05 15:56:51',NULL,'2d5aa6b3-4738-4a1d-a26d-d6b9266791c1'),(3,6,31,'Membros da Assembleia','members','end','2024-03-08 17:17:16','2024-03-08 17:17:16',NULL,'ba11131d-df2e-4907-845c-d15ce05aa210'),(4,7,33,'Executivo','executive','end','2024-03-08 17:33:25','2024-03-08 17:33:25',NULL,'68f7d9df-fe3d-4d7c-be39-7b7f58458e91');
/*!40000 ALTER TABLE `categorygroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups_sites`
--

LOCK TABLES `categorygroups_sites` WRITE;
/*!40000 ALTER TABLE `categorygroups_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `categorygroups_sites` VALUES (1,1,1,1,'noticias/{slug}','news/_category.twig','2024-02-22 18:06:16','2024-02-22 18:09:57','0306bc8e-f5a6-4a6e-8db4-62245ae6e9e1'),(2,2,1,1,'coletividades/{slug}',NULL,'2024-03-05 15:56:51','2024-03-05 15:56:51','9cb38bf4-1553-4179-9dc1-9242c363a1e9'),(3,3,1,1,'membros-da-assembleia/{slug}',NULL,'2024-03-08 17:17:16','2024-03-08 17:17:16','880631fd-dda3-4048-80af-6ad680157197'),(4,4,1,1,'executivo/{slug}',NULL,'2024-03-08 17:33:25','2024-03-08 17:33:25','363cb411-ff72-470d-84e0-96bbeefa9c05');
/*!40000 ALTER TABLE `categorygroups_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedattributes`
--

LOCK TABLES `changedattributes` WRITE;
/*!40000 ALTER TABLE `changedattributes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedattributes` VALUES (14,1,'title','2024-03-04 11:15:48',0,1),(49,1,'postDate','2024-02-22 18:00:40',0,1),(49,1,'slug','2024-02-22 18:00:39',0,1),(49,1,'title','2024-02-22 18:00:39',0,1),(49,1,'uri','2024-02-22 18:00:39',0,1),(51,1,'slug','2024-02-22 18:06:32',0,1),(51,1,'title','2024-02-22 18:06:32',0,1),(51,1,'uri','2024-02-22 18:06:33',0,1),(52,1,'slug','2024-02-22 18:06:41',0,1),(52,1,'title','2024-02-22 18:06:40',0,1),(52,1,'uri','2024-02-22 18:06:41',0,1),(53,1,'slug','2024-02-22 18:06:50',0,1),(53,1,'title','2024-02-22 18:06:49',0,1),(53,1,'uri','2024-02-22 18:06:50',0,1),(54,1,'slug','2024-02-22 18:07:01',0,1),(54,1,'title','2024-02-22 18:07:00',0,1),(54,1,'uri','2024-02-22 18:07:01',0,1),(81,1,'slug','2024-03-01 11:05:07',0,1),(81,1,'title','2024-02-27 17:23:16',0,1),(81,1,'uri','2024-03-01 11:05:07',0,1),(90,1,'postDate','2024-02-27 17:58:53',0,1),(90,1,'title','2024-02-27 17:58:53',0,1),(103,1,'postDate','2024-03-01 14:32:47',0,1),(103,1,'title','2024-03-01 14:32:01',0,1),(109,1,'postDate','2024-03-01 14:32:54',0,1),(109,1,'title','2024-03-01 14:32:39',0,1),(119,1,'postDate','2024-03-01 14:33:30',0,1),(119,1,'slug','2024-03-08 15:48:36',0,1),(119,1,'title','2024-03-01 14:33:30',0,1),(119,1,'uri','2024-03-08 15:48:22',0,1),(127,1,'postDate','2024-03-01 17:05:05',0,1),(127,1,'slug','2024-03-01 16:44:45',0,1),(127,1,'title','2024-03-01 16:44:45',0,1),(127,1,'uri','2024-03-01 16:44:45',0,1),(141,1,'slug','2024-03-01 17:37:44',0,1),(141,1,'title','2024-03-01 17:37:28',0,1),(141,1,'uri','2024-03-01 17:37:44',0,1),(169,1,'title','2024-03-04 11:25:22',0,1),(187,1,'enabled','2024-03-05 15:00:36',0,1),(187,1,'postDate','2024-03-05 14:48:06',0,1),(187,1,'slug','2024-03-05 15:00:56',0,1),(187,1,'title','2024-03-05 15:00:57',0,1),(187,1,'uri','2024-03-05 14:48:07',0,1),(210,1,'slug','2024-03-05 15:01:38',0,1),(210,1,'title','2024-03-05 15:01:18',0,1),(210,1,'uri','2024-03-05 15:01:38',0,1),(216,1,'slug','2024-03-05 15:01:58',0,1),(216,1,'title','2024-03-05 15:01:58',0,1),(220,1,'slug','2024-03-05 16:00:09',0,1),(220,1,'title','2024-03-05 16:00:09',0,1),(220,1,'uri','2024-03-05 15:57:06',0,1),(222,1,'title','2024-03-05 15:59:17',0,1),(234,1,'postDate','2024-03-05 16:20:06',0,1),(234,1,'slug','2024-03-05 16:20:06',0,1),(234,1,'title','2024-03-05 16:20:06',0,1),(234,1,'uri','2024-03-05 16:20:06',0,1),(244,1,'postDate','2024-03-05 16:53:37',0,1),(244,1,'slug','2024-03-05 16:53:35',0,1),(244,1,'title','2024-03-05 16:53:33',0,1),(244,1,'uri','2024-03-05 16:53:35',0,1),(246,1,'postDate','2024-03-05 16:54:22',0,1),(246,1,'slug','2024-03-05 16:54:22',0,1),(246,1,'title','2024-03-05 16:54:21',0,1),(246,1,'uri','2024-03-05 16:54:22',0,1),(250,1,'postDate','2024-03-05 16:54:36',0,1),(250,1,'slug','2024-03-05 16:54:36',0,1),(250,1,'title','2024-03-05 16:54:35',0,1),(250,1,'uri','2024-03-05 16:54:36',0,1),(283,1,'postDate','2024-03-08 15:52:24',0,1),(283,1,'slug','2024-03-08 15:50:50',0,1),(283,1,'title','2024-03-08 15:50:50',0,1),(283,1,'uri','2024-03-08 15:50:51',0,1),(288,1,'postDate','2024-03-08 16:04:16',0,1),(288,1,'slug','2024-03-08 16:01:08',0,1),(288,1,'title','2024-03-08 16:01:08',0,1),(288,1,'uri','2024-03-08 16:01:08',0,1),(296,1,'postDate','2024-03-08 16:10:01',0,1),(296,1,'slug','2024-03-08 16:09:58',0,1),(296,1,'title','2024-03-08 16:09:58',0,1),(296,1,'uri','2024-03-08 16:09:58',0,1),(305,1,'postDate','2024-03-08 16:17:15',0,1),(305,1,'slug','2024-03-08 16:15:42',0,1),(305,1,'title','2024-03-08 16:15:40',0,1),(305,1,'uri','2024-03-08 16:15:42',0,1),(311,1,'postDate','2024-03-08 16:47:25',0,1),(311,1,'slug','2024-03-08 16:47:10',0,1),(311,1,'title','2024-03-08 16:47:08',0,1),(311,1,'uri','2024-03-08 16:47:10',0,1),(317,1,'fieldLayoutId','2024-03-08 17:02:31',0,1),(317,1,'postDate','2024-03-08 17:02:56',0,1),(317,1,'slug','2024-03-08 17:02:57',0,1),(317,1,'title','2024-03-08 17:02:38',0,1),(317,1,'typeId','2024-03-08 17:02:31',0,1),(317,1,'uri','2024-03-08 17:02:57',0,1),(319,1,'fieldLayoutId','2024-03-08 17:09:42',0,1),(319,1,'postDate','2024-03-08 17:09:57',0,1),(319,1,'slug','2024-03-08 17:09:57',0,1),(319,1,'title','2024-03-08 17:09:49',0,1),(319,1,'typeId','2024-03-08 17:09:42',0,1),(319,1,'uri','2024-03-08 17:09:57',0,1),(323,1,'slug','2024-03-08 17:17:31',0,1),(323,1,'title','2024-03-08 17:17:28',0,1),(323,1,'uri','2024-03-08 17:17:31',0,1),(329,1,'title','2024-03-08 17:20:34',0,1),(339,1,'fieldLayoutId','2024-03-08 17:29:28',0,1),(339,1,'postDate','2024-03-08 17:29:47',0,1),(339,1,'slug','2024-03-08 17:29:48',0,1),(339,1,'title','2024-03-08 17:29:34',0,1),(339,1,'typeId','2024-03-08 17:29:28',0,1),(339,1,'uri','2024-03-08 17:29:48',0,1),(342,1,'slug','2024-03-08 17:33:39',0,1),(342,1,'title','2024-03-08 17:33:39',0,1),(342,1,'uri','2024-03-08 17:33:39',0,1),(344,1,'title','2024-03-08 17:34:42',0,1),(347,1,'title','2024-03-08 17:35:12',0,1),(351,1,'fieldLayoutId','2024-03-08 17:35:39',0,1),(351,1,'postDate','2024-03-08 17:35:59',0,1),(351,1,'slug','2024-03-08 17:36:00',0,1),(351,1,'title','2024-03-08 17:35:47',0,1),(351,1,'typeId','2024-03-08 17:35:39',0,1),(351,1,'uri','2024-03-08 17:36:00',0,1),(364,1,'postDate','2024-03-11 10:59:52',0,1),(364,1,'slug','2024-03-11 10:59:46',0,1),(364,1,'title','2024-03-11 10:59:46',0,1),(364,1,'uri','2024-03-11 10:59:46',0,1),(368,1,'postDate','2024-03-11 11:09:57',0,1),(368,1,'slug','2024-03-11 11:05:20',0,1),(368,1,'title','2024-03-11 11:05:19',0,1),(368,1,'uri','2024-03-11 11:05:20',0,1),(374,1,'postDate','2024-03-11 11:17:19',0,1),(374,1,'slug','2024-03-11 11:14:49',0,1),(374,1,'title','2024-03-11 11:14:49',0,1),(374,1,'uri','2024-03-11 11:14:49',0,1),(382,1,'postDate','2024-03-11 11:21:36',0,1),(382,1,'slug','2024-03-11 11:20:33',0,1),(382,1,'title','2024-03-11 11:20:32',0,1),(382,1,'uri','2024-03-11 11:20:33',0,1);
/*!40000 ALTER TABLE `changedattributes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedfields`
--

LOCK TABLES `changedfields` WRITE;
/*!40000 ALTER TABLE `changedfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedfields` VALUES (14,1,2,'2024-02-20 17:14:19',0,1),(14,1,3,'2024-02-26 16:21:09',0,1),(14,1,4,'2024-02-20 17:14:19',0,1),(14,1,33,'2024-02-26 16:27:16',0,1),(24,1,16,'2024-02-22 14:22:29',0,1),(24,1,17,'2024-02-22 14:22:29',0,1),(25,1,16,'2024-02-22 14:22:29',0,1),(25,1,17,'2024-02-22 14:22:29',0,1),(26,1,16,'2024-02-22 14:22:29',0,1),(26,1,17,'2024-02-22 14:22:29',0,1),(27,1,16,'2024-02-22 14:22:29',0,1),(27,1,17,'2024-02-22 14:22:29',0,1),(33,1,24,'2024-02-22 14:58:54',0,1),(33,1,25,'2024-02-22 14:58:54',0,1),(45,1,27,'2024-02-22 17:49:39',0,1),(45,1,28,'2024-02-22 17:49:39',0,1),(46,1,27,'2024-02-22 17:49:40',0,1),(46,1,28,'2024-02-22 17:49:40',0,1),(49,1,3,'2024-02-22 18:00:40',0,1),(49,1,4,'2024-02-22 18:00:40',0,1),(49,1,29,'2024-02-22 18:11:26',0,1),(49,1,30,'2024-02-22 18:08:49',0,1),(49,1,31,'2024-02-22 18:08:49',0,1),(49,1,32,'2024-02-22 18:08:58',0,1),(49,1,34,'2024-02-27 18:01:13',0,1),(81,1,33,'2024-02-27 17:23:43',0,1),(81,1,40,'2024-03-05 17:23:48',0,1),(81,1,41,'2024-03-05 17:23:24',0,1),(90,1,32,'2024-03-01 11:22:05',0,1),(90,1,34,'2024-02-27 18:01:18',0,1),(102,1,33,'2024-03-01 11:22:34',0,1),(103,1,32,'2024-03-01 14:32:21',0,1),(109,1,32,'2024-03-01 14:33:54',0,1),(119,1,32,'2024-03-01 14:34:35',0,1),(127,1,29,'2024-03-01 16:46:45',0,1),(127,1,30,'2024-03-01 16:46:45',0,1),(127,1,33,'2024-03-01 16:44:45',0,1),(127,1,35,'2024-03-01 17:12:48',0,1),(127,1,36,'2024-03-01 17:12:48',0,1),(127,1,37,'2024-03-01 16:46:45',0,1),(127,1,38,'2024-03-01 17:18:30',0,1),(141,1,40,'2024-03-05 17:26:23',0,1),(141,1,41,'2024-03-05 17:26:23',0,1),(147,1,38,'2024-03-04 10:58:57',0,1),(153,1,38,'2024-03-04 10:59:05',0,1),(155,1,38,'2024-03-04 10:59:15',0,1),(157,1,38,'2024-03-04 10:59:24',0,1),(169,1,33,'2024-03-05 17:26:56',0,1),(169,1,39,'2024-03-05 14:29:28',0,1),(169,1,40,'2024-03-05 17:27:05',0,1),(169,1,41,'2024-03-05 17:27:05',0,1),(187,1,30,'2024-03-05 14:50:13',0,1),(187,1,33,'2024-03-05 14:48:25',0,1),(187,1,40,'2024-03-05 17:19:36',0,1),(187,1,41,'2024-03-05 17:19:36',0,1),(197,1,33,'2024-03-05 14:56:27',0,1),(197,1,40,'2024-03-05 17:21:41',0,1),(197,1,41,'2024-03-05 17:21:41',0,1),(220,1,7,'2024-03-05 15:57:30',0,1),(220,1,8,'2024-03-05 16:00:09',0,1),(220,1,12,'2024-03-05 16:00:09',0,1),(220,1,30,'2024-03-05 16:00:09',0,1),(222,1,8,'2024-03-05 15:59:17',0,1),(222,1,30,'2024-03-05 15:59:17',0,1),(228,1,33,'2024-03-05 16:02:19',0,1),(228,1,40,'2024-03-05 17:18:20',0,1),(228,1,41,'2024-03-05 17:18:20',0,1),(234,1,33,'2024-03-05 16:24:05',0,1),(234,1,39,'2024-03-05 16:52:16',0,1),(234,1,40,'2024-03-05 17:15:06',0,1),(234,1,41,'2024-03-05 17:15:06',0,1),(244,1,33,'2024-03-05 16:53:35',0,1),(246,1,33,'2024-03-05 16:54:28',0,1),(283,1,29,'2024-03-08 15:52:24',0,1),(283,1,33,'2024-03-08 15:51:09',0,1),(283,1,40,'2024-03-08 15:52:49',0,1),(283,1,41,'2024-03-08 15:52:49',0,1),(288,1,29,'2024-03-08 16:04:45',0,1),(288,1,33,'2024-03-08 16:01:08',0,1),(288,1,40,'2024-03-08 16:01:10',0,1),(288,1,41,'2024-03-08 16:01:10',0,1),(296,1,29,'2024-03-08 16:14:11',0,1),(296,1,33,'2024-03-08 16:09:58',0,1),(296,1,40,'2024-03-08 16:09:59',0,1),(296,1,41,'2024-03-08 16:10:00',0,1),(305,1,29,'2024-03-08 16:17:15',0,1),(305,1,33,'2024-03-08 16:15:42',0,1),(305,1,40,'2024-03-08 16:18:37',0,1),(305,1,41,'2024-03-08 16:18:37',0,1),(311,1,3,'2024-03-08 16:51:12',0,1),(311,1,29,'2024-03-08 16:47:25',0,1),(311,1,33,'2024-03-08 16:47:10',0,1),(311,1,40,'2024-03-08 16:47:31',0,1),(311,1,41,'2024-03-08 16:47:31',0,1),(317,1,29,'2024-03-08 17:02:56',0,1),(317,1,33,'2024-03-08 17:02:38',0,1),(319,1,29,'2024-03-08 17:09:57',0,1),(319,1,33,'2024-03-08 17:10:26',0,1),(319,1,40,'2024-03-08 17:10:25',0,1),(319,1,41,'2024-03-08 17:10:25',0,1),(323,1,3,'2024-03-08 17:17:36',0,1),(323,1,7,'2024-03-08 17:17:37',0,1),(323,1,12,'2024-03-08 17:17:42',0,1),(323,1,30,'2024-03-08 17:19:23',0,1),(326,1,3,'2024-03-08 17:20:43',0,1),(326,1,30,'2024-03-08 17:19:52',0,1),(329,1,3,'2024-03-08 17:20:34',0,1),(329,1,30,'2024-03-08 17:20:34',0,1),(333,1,30,'2024-03-08 17:21:19',0,1),(336,1,30,'2024-03-08 17:21:47',0,1),(339,1,29,'2024-03-08 17:29:48',0,1),(339,1,33,'2024-03-08 17:35:32',0,1),(342,1,3,'2024-03-08 17:33:41',0,1),(342,1,7,'2024-03-08 17:34:02',0,1),(342,1,12,'2024-03-08 17:34:08',0,1),(342,1,30,'2024-03-08 17:33:57',0,1),(344,1,3,'2024-03-08 17:34:42',0,1),(344,1,30,'2024-03-08 17:34:42',0,1),(347,1,3,'2024-03-08 17:35:12',0,1),(347,1,30,'2024-03-08 17:35:12',0,1),(351,1,29,'2024-03-08 17:35:59',0,1),(351,1,33,'2024-03-08 17:35:47',0,1),(353,1,29,'2024-03-08 17:53:55',0,1),(353,1,33,'2024-03-08 17:51:25',0,1),(353,1,40,'2024-03-08 17:51:25',0,1),(364,1,29,'2024-03-11 11:00:47',0,1),(364,1,33,'2024-03-11 10:59:46',0,1),(364,1,40,'2024-03-11 10:59:49',0,1),(364,1,41,'2024-03-11 10:59:50',0,1),(368,1,29,'2024-03-11 11:11:42',0,1),(368,1,33,'2024-03-11 11:06:53',0,1),(368,1,40,'2024-03-11 11:05:21',0,1),(368,1,41,'2024-03-11 11:05:21',0,1),(374,1,29,'2024-03-11 11:19:05',0,1),(374,1,33,'2024-03-11 11:14:51',0,1),(374,1,40,'2024-03-11 11:19:47',0,1),(374,1,41,'2024-03-11 11:19:47',0,1),(382,1,29,'2024-03-11 11:22:46',0,1),(382,1,33,'2024-03-11 11:21:33',0,1),(382,1,40,'2024-03-11 11:21:42',0,1),(382,1,41,'2024-03-11 11:21:42',0,1);
/*!40000 ALTER TABLE `changedfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `content`
--

LOCK TABLES `content` WRITE;
/*!40000 ALTER TABLE `content` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `content` VALUES (1,1,1,NULL,'2024-02-16 17:40:41','2024-02-16 17:40:41','42df3d24-1556-4bae-ac28-0c2f41ce2508',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,2,1,NULL,'2024-02-19 12:20:57','2024-02-20 17:51:38','a5fc46c1-9635-4032-adcb-d53cced24a5a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,3,1,NULL,'2024-02-19 12:21:07','2024-03-08 18:01:41','5e158427-de9f-4e5b-a14c-112cce113eff',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>©2023 Junta de Freguesia de Mesão Frio. Todos os direitos reservados. Desenvolvido\n                                por <strong>PRIMARIU</strong></p>',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,4,1,NULL,'2024-02-19 12:45:53','2024-03-01 11:04:45','a25aa5e0-8956-4dd6-b017-4c3ba84bf796','Junta de Mesão Frio','Junta de Mesão Frio','{\"value\":\"\",\"language\":\"html\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,5,1,NULL,'2024-02-19 12:53:21','2024-02-22 15:29:00','51f8c3ad-d524-4ff9-be37-8316f00009a6',NULL,NULL,NULL,'Junta de Mesão Frio','juntamesaofrio@gmail.com','Rua Cruz D\'Argola N.º 765','4810-225','Guimarães','PT','(+351) 253 431 367',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,10,1,'Favicon junta mesao frio','2024-02-19 14:11:23','2024-02-19 14:11:23','97949fd5-046c-4e8c-8c89-d52a1a3cbfd6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(11,11,1,'Meta img','2024-02-19 14:11:31','2024-02-19 14:11:31','3d126c0e-0461-42a0-a001-1bf179a21597',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(12,12,1,'Logo','2024-02-19 14:12:12','2024-02-19 14:12:12','ec9a02b3-f38d-47e4-bcbd-38944c54e165',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(13,13,1,'Logo','2024-02-19 14:13:29','2024-02-19 14:13:29','96e715e5-a649-4ff5-98eb-960f8e445657',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(14,14,1,'Seja bem-vindo(a) a Mesão-Frio!','2024-02-20 17:13:27','2024-03-05 17:25:27','99516949-4522-49ac-9af7-59c39ec2a3bd','Homepage','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\",\"2\":\" - Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(15,15,1,'Inicio','2024-02-20 17:13:27','2024-02-20 17:13:27','1833de89-3338-455c-b005-22c8a51c7eef',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(16,16,1,'Inicio','2024-02-20 17:13:27','2024-02-20 17:13:27','3b740822-5ef2-4223-9349-13a34425dbaf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(17,17,1,'Inicio','2024-02-20 17:13:53','2024-02-20 17:13:53','b9469916-a18b-44cf-be99-b3fb82bcb458',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(19,19,1,'Inicio','2024-02-20 17:14:19','2024-02-20 17:14:19','f8c47faa-f766-4567-b592-79b6eedf58b1','Junta de Mesão Frio','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(20,20,1,'Favicon junta mesao frio','2024-02-20 17:19:07','2024-02-20 17:19:07','8258da61-99bc-4c81-a44f-ce47b52b4b03',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(21,21,1,'Header BG Image','2024-02-20 17:51:21','2024-02-20 17:51:37','a7f8dac7-e5aa-41f4-b89b-4a549aa3f2ab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(22,22,1,'Footer gradient iefix','2024-02-22 12:54:46','2024-02-22 12:54:46','6ac35143-732b-4c2d-8c43-229fe78d5faa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(23,23,1,'Header gradient iefix','2024-02-22 12:54:47','2024-02-22 12:54:47','0c96523a-df40-4490-9b49-b3fa129b0543',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(24,28,1,NULL,'2024-02-22 14:24:58','2024-02-22 15:29:00','22c333ed-f094-46ae-85c0-e054571081e3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(25,29,1,'Facebook icon','2024-02-22 14:28:01','2024-02-22 14:28:01','19009524-596c-49d1-9695-bc8cfbb1017b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(26,31,1,NULL,'2024-02-22 14:54:20','2024-02-22 15:29:00','372d6dd8-7cf2-44d5-81f1-eee41146d569',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(27,32,1,'Teste 1','2024-02-22 14:57:55','2024-03-05 16:52:29','7044f02b-e047-4261-b471-e5cd7cbe2211',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(28,39,1,'Locale widget bg','2024-02-22 15:05:27','2024-02-22 15:05:27','88284a42-5678-4cfc-9723-52dd7c3f7a62',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(29,40,1,NULL,'2024-02-22 15:29:15','2024-02-22 17:49:39','935da977-14a2-466e-a9f5-0f9fc1674eeb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(30,41,1,'Image 3','2024-02-22 17:41:41','2024-02-22 17:41:41','892ec4c5-1968-4a8e-b64c-0d8be25bf218',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(31,42,1,'Image 5','2024-02-22 17:42:30','2024-02-22 17:42:30','3d72ce35-821b-4040-a631-94766e7b2ae7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(32,43,1,'Image 2','2024-02-22 17:43:03','2024-02-22 17:43:03','e5bdc2bc-0664-42f6-8e74-10b34c8ddb15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(33,44,1,'Image 5','2024-02-22 17:43:08','2024-02-22 17:43:08','7ca5411c-12e6-483a-8c77-b33cc61a5937',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(34,47,1,'Image 4','2024-02-22 17:49:38','2024-02-22 17:49:38','b6920041-9a4e-4f0d-aa00-6c2efccfe1af',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(35,48,1,'Junta mf placeholder','2024-02-22 17:54:19','2024-02-22 17:54:34','31860874-619f-4339-ad3a-8a54c56fa3c1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(36,49,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-22 18:00:36','2024-03-01 18:11:23','911ce330-fac0-40c1-a2a2-744218041187','BIKE CHALLENGE - Condicionamento do Trânsito','BIKE CHALLENGE - Condicionamento do Trânsito',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(37,50,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-22 18:00:41','2024-02-27 17:19:33','47a4d3ee-e4e9-403d-ac30-ba50d255b533','BIKE CHALLENGE - Condicionamento do Trânsito','BIKE CHALLENGE - Condicionamento do Trânsito',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(38,51,1,'Comunidade','2024-02-22 18:06:25','2024-02-22 18:06:33','56a8d92e-4311-404a-b9b5-6ef2d1187363',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(39,52,1,'Cultura','2024-02-22 18:06:37','2024-02-22 18:06:41','0181156e-723c-4048-b323-b5ab603a2f08',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(40,53,1,'Desporto','2024-02-22 18:06:47','2024-02-22 18:06:50','e226eb5f-08d2-4b55-88ea-a592cb8a298c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(41,54,1,'Obras públicas','2024-02-22 18:06:58','2024-02-22 18:07:01','f10d0040-d97c-45fb-9edf-eb3705b25cb3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(42,55,1,'News image','2024-02-22 18:08:02','2024-02-22 18:08:02','badb1326-7ec4-4ea1-b19c-14322ffa7baa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(44,57,1,'mesao frio','2024-02-22 18:08:13','2024-02-22 18:08:13','05c3d117-5748-42c0-a7be-f467958562fa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(45,58,1,'desporto','2024-02-22 18:08:48','2024-02-22 18:08:48','08ba5f85-96d2-41ef-8ba2-6269fee6a96d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(46,59,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-22 18:08:49','2024-02-27 17:19:33','69502b1d-8d7a-43ac-903c-31478725f829','BIKE CHALLENGE - Condicionamento do Trânsito','BIKE CHALLENGE - Condicionamento do Trânsito',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(48,61,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-22 18:08:58','2024-02-27 17:19:33','9a6caaba-1256-41d0-b430-e4b3050fc9af','BIKE CHALLENGE - Condicionamento do Trânsito','BIKE CHALLENGE - Condicionamento do Trânsito',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(49,62,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-22 18:10:24','2024-02-27 17:19:33','88615317-f514-49a1-bb9d-20325e903b3d','BIKE CHALLENGE - Condicionamento do Trânsito','BIKE CHALLENGE - Condicionamento do Trânsito',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(51,64,1,'News text image','2024-02-22 18:11:03','2024-02-22 18:11:03','8c444438-9731-4db8-824b-bed9bafdd0db',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(52,65,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-22 18:11:26','2024-02-27 17:19:33','05b51832-3625-45ca-b620-89cf31ec4814','BIKE CHALLENGE - Condicionamento do Trânsito','BIKE CHALLENGE - Condicionamento do Trânsito',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(53,66,1,'Inicio','2024-02-26 16:19:24','2024-02-26 16:19:24','1ce2dea8-0396-4737-8896-4879102d05e0','Junta de Mesão Frio','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(54,67,1,'Inicio','2024-02-26 16:19:59','2024-02-26 16:19:59','680a7afc-85a3-4ed5-b6f4-2abfe54796f4','Junta de Mesão Frio','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(56,69,1,'Inicio','2024-02-26 16:20:11','2024-02-26 16:20:11','79d0286f-50a0-47be-aea1-e32f74aa956d',NULL,'Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(57,70,1,'Inicio','2024-02-26 16:20:25','2024-02-26 16:20:25','51998474-9cc9-4648-84c3-7cb5caf8e79f',NULL,'Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(58,71,1,'Inicio','2024-02-26 16:21:09','2024-02-26 16:21:09','cb52a99b-fafe-488c-be29-2f8292722307','Homepage','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Homepage - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(60,73,1,'Inicio','2024-02-26 16:21:28','2024-02-26 16:21:28','bc06ce88-7ed7-4fd0-8304-e751a3787953','Homepage','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Inicio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(61,74,1,'Inicio','2024-02-26 16:22:10','2024-02-26 16:22:10','c4173c7b-b7ed-41db-8a13-b3cc01261225','Homepage','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Inicio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(63,76,1,'Inicio','2024-02-26 16:23:46','2024-02-26 16:23:46','48d56583-6cba-4c06-8b68-22373a165d87','Homepage','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Inicio\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(64,77,1,'Inicio','2024-02-26 16:27:02','2024-02-26 16:27:02','3f5b8de8-24af-4fed-815b-ec836ad2b6ac','Homepage','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(66,79,1,'Inicio','2024-02-26 16:27:16','2024-02-26 16:27:16','9614d551-20b6-4495-845b-b29ea753ac76','Homepage','Junta de Mesão Frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\",\"2\":\" - Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(67,80,1,'Inicio','2024-02-26 16:27:56','2024-02-26 16:27:56','793de7f8-822a-43d2-a6d3-16c1fe7c6ffb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\",\"2\":\" - Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(68,81,1,'Notícias','2024-02-27 17:20:13','2024-03-05 17:23:48','dc8c6b99-6a5f-41f3-a7c8-7220daf05e5b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,0),(69,82,1,'Página de Noticias','2024-02-27 17:20:13','2024-02-27 17:20:13','91170e35-ad99-4769-8081-5e0da0e788f3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(70,83,1,'Página de Noticias','2024-02-27 17:20:14','2024-02-27 17:20:14','62f998a7-d588-4ffa-b8c1-8051ac3f27fa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(71,84,1,'Página de Noticias','2024-02-27 17:20:29','2024-02-27 17:20:29','6f216a20-ebc2-459c-b3cb-114304aee5a5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Página de Noticias - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Página de Noticias - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(73,86,1,'Notícias','2024-02-27 17:23:16','2024-02-27 17:23:16','7697b836-af3f-4a39-ba57-f2e3b20e2942',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(74,87,1,'Notícias','2024-02-27 17:23:22','2024-02-27 17:23:22','8bd03009-bf1d-4a8d-8e82-f07d7b7b5ce5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(76,89,1,'Notícias','2024-02-27 17:23:43','2024-02-27 17:23:43','94919721-c2ca-4dea-8b9f-ebaa1953d26f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(77,90,1,'Recolha Lixo Grosso | 2023','2024-02-27 17:58:30','2024-03-01 18:11:23','4aec6065-e782-4444-99de-f69319a7e75b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(78,91,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-27 17:58:30','2024-02-27 17:58:30','bb2935f0-b3ce-40f6-969c-502139fee60b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(80,93,1,'Recolha Lixo Grosso | 2023','2024-02-27 17:58:53','2024-02-27 17:58:53','d8201c95-b1b3-4de9-93e7-64f80690a829',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(81,94,1,'Recolha Lixo Grosso | 2023','2024-02-27 17:59:06','2024-02-27 17:59:06','fca2a866-d78a-4399-97d1-270d02e31304',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(83,96,1,'BIKE CHALLENGE - Condicionamento do Trânsito','2024-02-27 18:01:13','2024-02-27 18:01:13','0506dd4c-f610-4cf9-a686-5cce684e4fce',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(85,98,1,'Recolha Lixo Grosso | 2023','2024-02-27 18:01:18','2024-02-27 18:01:18','21be483f-4d38-4579-bb99-ebce25cabfcf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(86,99,1,'Notícias','2024-03-01 11:05:07','2024-03-01 11:05:07','0274bdbc-6825-4f22-9d6b-b8a83568cadf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(88,101,1,'Recolha Lixo Grosso | 2023','2024-03-01 11:22:05','2024-03-01 11:22:05','9b7016d9-226a-4a41-9397-dabc0040bac9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(89,102,1,'Recolha Lixo Grosso | 2023','2024-03-01 11:22:34','2024-03-01 11:22:34','7e1c5f84-b87f-4f87-8947-9c1cff785f6b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":{\"1\":\"Recolha Lixo Grosso | 2023\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(90,103,1,'DIA DE TODOS OS SANTOS – Condicionamento de Trânsito','2024-03-01 14:31:51','2024-03-01 18:11:23','79d8c49d-53c4-4999-b2fb-9ee967f93624',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(91,104,1,'Recolha Lixo Grosso | 2023','2024-03-01 14:31:52','2024-03-01 14:31:52','d3cd5145-a5cb-4601-860c-a46bbec1186e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(93,106,1,'DIA DE TODOS OS SANTOS – Condicionamento de Trânsito','2024-03-01 14:32:01','2024-03-01 14:32:01','2169da2d-d00e-4357-961e-ce833dc21581',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(95,108,1,'DIA DE TODOS OS SANTOS – Condicionamento de Trânsito','2024-03-01 14:32:21','2024-03-01 14:32:21','dc522d2b-1d1b-49a2-80ed-bda975368651',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(96,109,1,'Oferta de Kits Escolares – Ano Lectivo 2022/2023','2024-03-01 14:32:28','2024-03-01 18:11:24','8731a02c-4514-4221-bced-0ed751744a6f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(97,110,1,'DIA DE TODOS OS SANTOS – Condicionamento de Trânsito','2024-03-01 14:32:28','2024-03-01 14:32:28','98c31efc-7ab2-49af-be5d-9d23594d365c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(99,112,1,'Oferta de Kits Escolares – Ano Lectivo 2022/2023','2024-03-01 14:32:39','2024-03-01 14:32:39','27fa7c54-86f7-4972-8682-f056925e0709',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(101,114,1,'DIA DE TODOS OS SANTOS – Condicionamento de Trânsito','2024-03-01 14:32:47','2024-03-01 14:32:47','8d24d634-9b68-467e-8103-e3366334cd4d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(103,116,1,'Oferta de Kits Escolares – Ano Lectivo 2022/2023','2024-03-01 14:32:54','2024-03-01 14:32:54','ef8c6d89-87c5-4d53-881d-16a568adfa6b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(105,118,1,'Oferta de Kits Escolares – Ano Lectivo 2022/2023','2024-03-01 14:33:11','2024-03-01 14:33:11','58ef749a-9b0e-47b2-ac0e-3980ec95304d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(106,119,1,'Intervenção – Rua de São Pedro','2024-03-01 14:33:20','2024-03-08 15:48:36','d48b8041-494d-49d9-b7a9-f488584febf4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(107,120,1,'Oferta de Kits Escolares – Ano Lectivo 2022/2023','2024-03-01 14:33:20','2024-03-01 14:33:20','731663c7-2e28-41ee-8890-d6e4819b6cd5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(109,122,1,'Intervenção – Rua de São Pedro','2024-03-01 14:33:30','2024-03-01 14:33:30','65ed2175-6e01-4a65-a32e-0468de62e7e2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(111,124,1,'Oferta de Kits Escolares – Ano Lectivo 2022/2023','2024-03-01 14:33:54','2024-03-01 14:33:54','ba3c62c8-ea95-4dd8-9a43-72344bf92d8f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(113,126,1,'Intervenção – Rua de São Pedro','2024-03-01 14:34:35','2024-03-01 14:34:35','f8b8d2c8-00ef-420d-b053-56558ff98b9e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(114,127,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 16:43:14','2024-03-04 10:58:32','7bb0262a-70ce-4c7d-8f5e-9a68894c69ec',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-03-02 03:21:00',NULL,NULL),(115,128,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 16:45:09','2024-03-01 16:45:09','ba568065-7f78-4c88-ba00-a48c06c61c78',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(116,129,1,'Event image','2024-03-01 16:45:41','2024-03-01 16:45:41','3d113f5a-3df4-4648-a484-6ebe44b7537e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(118,131,1,'Event image text','2024-03-01 16:46:20','2024-03-01 16:46:20','87f0238c-525c-49d6-90ee-8cfad90bb3ac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(119,132,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 16:46:45','2024-03-01 16:46:45','5eddf7f0-3ff9-4e1b-8a2c-add8dbb0eb6e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,'Town Cinema',NULL,NULL,NULL),(120,133,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 16:47:22','2024-03-01 16:47:22','72525b29-8d6f-4992-aa63-2a198c6e6c7c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,'Town Cinema',NULL,NULL,NULL),(122,135,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 17:04:54','2024-03-01 17:04:54','ba6e9ec4-97f2-40fc-8ec1-f9f1c5a50bfe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,'Town Cinema',NULL,NULL,NULL),(124,137,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 17:05:05','2024-03-01 17:05:05','2a619bce-d38c-4be0-8ed4-ef854cf49afa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,'Town Cinema',NULL,NULL,NULL),(125,138,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 17:12:48','2024-03-01 17:12:48','f2d342a6-1b9d-44c4-b97e-00cab15b6fba',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema',NULL,NULL,NULL),(127,140,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 17:18:30','2024-03-01 17:18:30','5fb98c79-e24d-4570-ac05-662eb3170e7c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-03-02 03:21:00',NULL,NULL),(128,141,1,'Eventos','2024-03-01 17:36:55','2024-03-05 17:26:23','46433eb0-7f82-42e0-985e-86712a7963e8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1),(129,142,1,'Página de Eventos','2024-03-01 17:36:55','2024-03-01 17:36:55','1aca0870-2c5c-4f9d-83de-86ea06db0fae',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(130,143,1,'Página de Eventos','2024-03-01 17:36:55','2024-03-01 17:36:55','e09d4363-7c21-466a-b89b-928f313212fd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(131,144,1,'Página de Eventos','2024-03-01 17:37:16','2024-03-01 17:37:16','1c6ad7b8-d8a1-4817-8cec-6ce0dec381ee',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Página de Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Página de Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(132,145,1,'Eventos','2024-03-01 17:37:28','2024-03-01 17:37:28','5105677a-7295-4324-8041-cb85ea94fb6e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(133,146,1,'Eventos','2024-03-01 17:37:44','2024-03-01 17:37:44','ef11108a-7f6c-4cb1-bfd2-ee7dd0123865',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(134,147,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 17:45:57','2024-03-04 10:58:57','8c16aa33-ec65-40ae-bb42-74cc8b3783ef',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-04-25 02:21:00',NULL,NULL),(135,148,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 17:45:57','2024-03-01 17:45:57','912e89dd-00a1-4345-907b-08fc5710cbe8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-03-02 03:21:00',NULL,NULL),(137,150,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 17:46:16','2024-03-01 17:46:16','ef454787-4235-4c01-9cb7-9488e0b89032',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-02-10 03:21:00',NULL,NULL),(139,152,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 18:00:06','2024-03-01 18:00:06','1a69d09b-4891-4299-834e-198f6096e73a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-04-04 02:21:00',NULL,NULL),(140,153,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 18:00:22','2024-03-04 10:59:05','3d80f441-20a1-4494-8b1d-7e9dbd3cf2dd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-05-08 02:21:00',NULL,NULL),(141,154,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 18:00:22','2024-03-01 18:00:22','5279c22a-b92e-4219-8a94-7616cdbc439b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-04-04 02:21:00',NULL,NULL),(142,155,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 18:00:27','2024-03-04 10:59:15','73e8cc8a-fac5-48d5-9903-b461d07e297a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-03-08 03:21:00',NULL,NULL),(143,156,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 18:00:27','2024-03-01 18:00:27','03bee06a-8818-4a72-a24b-146a4c226e72',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-03-02 03:21:00',NULL,NULL),(144,157,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 18:00:27','2024-03-04 10:59:24','56b8366b-ab14-4af0-a0b3-12a4ae31738a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-05-23 02:21:00',NULL,NULL),(145,158,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-01 18:00:27','2024-03-01 18:00:27','e14f32b4-3bff-4de1-a52d-14a9b4460d33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-04-04 02:21:00',NULL,NULL),(147,160,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-04 10:58:57','2024-03-04 10:58:57','d72aa9a8-dfac-43ad-b735-30362706bf08',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-04-25 02:21:00',NULL,NULL),(149,162,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-04 10:59:05','2024-03-04 10:59:05','695bf573-a77e-45d8-bdb3-1a87ad280b4b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-05-08 02:21:00',NULL,NULL),(151,164,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-04 10:59:15','2024-03-04 10:59:15','bba91598-4302-4365-967a-c3dfc32d4d89',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-03-08 03:21:00',NULL,NULL),(153,166,1,'Movie Premiere: Reflex Revenge (Action Drama)','2024-03-04 10:59:24','2024-03-04 10:59:24','d1d40042-d46f-4a2b-a0d6-a337ed61b5e1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n<p></p><figure><img src=\"{asset:131:url||https://junta.cooperativamaismesaofrio.com/assets/images/event-image-text.png}\" alt=\"Event Image Text\" /></figure>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Movie Premiere: Reflex Revenge (Action Drama) - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,'41.43754526917213','-8.299651535197349','Town Cinema','2024-05-23 02:21:00',NULL,NULL),(155,168,1,'Seja bem-vindo(a) a Mesão-Frio!','2024-03-04 11:15:48','2024-03-04 11:15:48','fbc23518-b942-4289-bda0-df59a501e9b4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\",\"2\":\" - Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(156,169,1,'O Cidadão','2024-03-04 11:21:56','2024-03-05 17:27:05','e76e21b5-b455-4d48-a4b0-e8306b7ac152',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"O Cidadão\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(157,170,1,'Cidadão','2024-03-04 11:21:56','2024-03-04 11:21:56','d76245a5-53ea-46fa-b0e7-f00b95bf1425',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(158,171,1,'Cidadão','2024-03-04 11:21:56','2024-03-04 11:21:56','f3ebddda-91cf-4b34-8c8d-052e002631b7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(159,172,1,'Cidadão','2024-03-04 11:22:11','2024-03-04 11:22:11','a8e53404-8479-4c0f-9c2e-e9b2d153ff1f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(160,173,1,'Cidadão','2024-03-04 11:23:07','2024-03-04 11:23:07','67dc0bf7-4e69-427a-af49-3c28ae8a23d1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(161,174,1,'Cidadão','2024-03-04 11:24:53','2024-03-04 11:24:53','aa876e8c-9c4f-4097-af78-cabd8e308aaf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(163,176,1,'O Cidadão','2024-03-04 11:25:22','2024-03-04 11:25:22','3823388b-8ca7-4414-bfd9-76c8b53820b7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(164,177,1,'Dummy document','2024-03-04 11:25:45','2024-03-04 11:25:45','7524d857-8aa5-46f0-b0ae-f421fe10b96e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(166,179,1,'Formulário de candidatura ao Procedimento Concursal','2024-03-04 11:26:07','2024-03-04 11:26:40','8ad56c68-d6ce-47ed-81c3-8997e5aedb89',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(167,180,1,'O Cidadão','2024-03-04 11:26:12','2024-03-04 11:26:12','f536c7c4-7c81-417a-9722-c8ca45533822',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(169,182,1,'O Cidadão','2024-03-05 14:28:17','2024-03-05 14:28:17','54703198-4a93-489b-b1d4-c3f5b5805b53',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(170,183,1,'Aviso de Procedimento Concursal comum para a constituição de vínculo de emprego público','2024-03-05 14:28:41','2024-03-05 14:28:56','f5ccbeaf-6008-41bd-90e6-c606274c596c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(172,185,1,'Formulário de candidatura ao Procedimento Concursal','2024-03-05 14:29:15','2024-03-05 14:29:25','1638bdb5-834f-4e75-8708-c4f8c237f436',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(173,186,1,'O Cidadão','2024-03-05 14:29:27','2024-03-05 14:29:27','fbb05d32-c8b0-4f33-b3d2-a36c39f215d8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(174,187,1,'Alminhas','2024-03-05 14:47:55','2024-03-05 17:19:36','a2db3406-6146-494c-88c0-f5fcb0b2e806',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(175,188,1,'Casa de Paçô Vieira','2024-03-05 14:48:07','2024-03-05 14:48:07','2dff3874-da2d-426c-a212-5f738378d2e1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(177,190,1,'Casa de Paçô Vieira','2024-03-05 14:48:25','2024-03-05 14:48:25','2adfdd96-ae09-43f3-af61-5d55473a61c0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(178,191,1,'Gallery 1','2024-03-05 14:49:54','2024-03-05 14:49:54','019a4aae-9e03-49e9-b624-af6aff20aef4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(179,192,1,'Gallery 2','2024-03-05 14:49:56','2024-03-05 14:49:56','f9b3af0e-a606-4a29-8612-864162178858',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(181,194,1,'Gallery 3','2024-03-05 14:49:59','2024-03-05 14:49:59','9a3403af-6787-4ddc-ba2b-90833a773994',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(182,195,1,'Gallery 4','2024-03-05 14:50:02','2024-03-05 14:50:02','902a279f-f746-481f-b3e7-7edf4ca57bcc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(183,196,1,'Casa de Paçô Vieira','2024-03-05 14:50:13','2024-03-05 14:50:13','31bcb774-e4a3-46fd-b037-ef49ea82dc3d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(184,197,1,'Galeria','2024-03-05 14:53:10','2024-03-05 17:21:41','679b753c-c25b-4d9f-bdf0-3d0b96c04c83',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Galeria\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(185,198,1,'Galeria','2024-03-05 14:53:10','2024-03-05 14:53:10','4987db0c-da59-4e6b-95ee-80f31f297c11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(186,199,1,'Galeria','2024-03-05 14:53:10','2024-03-05 14:53:10','6ba56832-148e-464b-b322-62fd1ddec2ec',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(187,200,1,'Galeria','2024-03-05 14:53:24','2024-03-05 14:53:24','22e73509-5b1f-4d6a-9b2a-bc502264547a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(188,201,1,'Galeria','2024-03-05 14:55:53','2024-03-05 14:55:53','987240e5-c152-4e04-82e7-097eab5836ec',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(190,203,1,'Galeria','2024-03-05 14:56:28','2024-03-05 14:56:28','33545ca6-da37-4e55-b221-c187d2060469',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Galeria\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(191,204,1,'Casa de Paçô Vieira','2024-03-05 15:00:28','2024-03-05 15:00:28','3b0c1eb1-c4cf-49b3-93a7-a46bd5f2b010',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(192,205,1,'Casa de Paçô Vieira','2024-03-05 15:00:36','2024-03-05 15:00:36','a5ce73d7-d589-452f-99f8-514fbefedf81',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(193,206,1,'Casa de Paçô Vieira','2024-03-05 15:00:40','2024-03-05 15:17:08','46ea6dfe-d91b-4600-979e-34a726a6e0fb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(194,207,1,'Casa de Paçô Vieira','2024-03-05 15:00:40','2024-03-05 15:00:40','1986a5a6-177d-435a-929b-845e4d6d97b0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(196,209,1,'Alminhas','2024-03-05 15:00:56','2024-03-05 15:00:56','e0534768-33a8-4b9a-ac80-eeea0d79e8d9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(197,210,1,'Antiga escola primária','2024-03-05 15:01:08','2024-03-05 15:17:08','fe654764-5cf0-4961-b98e-9272e0a35048',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(198,211,1,'Alminhas','2024-03-05 15:01:08','2024-03-05 15:01:08','ed6ae02c-c545-4470-bcb9-7663c5ef37be',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(200,213,1,'Antiga escola primária','2024-03-05 15:01:18','2024-03-05 15:01:18','0bee6893-1b6c-4fae-b117-dcd4780e0d0a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(202,215,1,'Antiga escola primária','2024-03-05 15:01:38','2024-03-05 15:01:38','904eb95f-50cf-4067-affe-b304d2d7f4f8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(203,216,1,'Empreendimentos','2024-03-05 15:01:45','2024-03-05 15:17:08','b92df3e6-cf83-4058-9cb0-fe3f4c87dace',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(204,217,1,'Casa de Paçô Vieira','2024-03-05 15:01:45','2024-03-05 15:01:45','7be49f86-6a07-440a-85a9-47160b4cf4a6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(206,219,1,'Empreendimentos','2024-03-05 15:01:58','2024-03-05 15:01:58','90b636d5-d4cf-4cb5-9cd8-0f8a522d2173',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(207,220,1,'Corpo nacional de Escutas - Agrupamento 702 de Mesão - Frio','2024-03-05 15:56:57','2024-03-05 16:00:08','250d3b21-263e-49c0-8a7d-9ff7a40cf3ad',NULL,NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt','Largo da Igreja, Mesão frio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(208,221,1,'Coletividade','2024-03-05 15:57:55','2024-03-05 15:57:55','589cd0be-0150-42b3-ad88-e8791c4aed2f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(209,222,1,'Escola da Cruz d`Argola','2024-03-05 15:58:40','2024-03-05 15:59:17','4adda892-bd1c-41fa-81de-fd28d9425a43',NULL,NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt','R. C, Guimarães',NULL,NULL,NULL,'(+351) 253 431 381',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(211,224,1,'Coletividade 2','2024-03-05 15:59:13','2024-03-05 15:59:13','e18dffa6-8e6c-40c2-a267-3f8839d11e4f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(212,225,1,'Escola de São Romão','2024-03-05 15:59:22','2024-03-05 15:59:22','219a59c5-5966-4691-aa68-e36cf45dd882',NULL,NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt','Rua de S. Romão - Mesão Frio',NULL,NULL,NULL,'(+351) 253 431 381',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(214,227,1,'Coletividade 3','2024-03-05 15:59:57','2024-03-05 15:59:57','b18ee776-860b-4d70-9de7-01828b772a0d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(215,228,1,'Coletividades','2024-03-05 16:01:28','2024-03-05 17:18:20','8e8718a8-8517-4d49-ba9d-371c6e491c84',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Coletividades\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(216,229,1,'Coletividades','2024-03-05 16:01:28','2024-03-05 16:01:28','790006d6-858b-44c8-b78b-7e1187d96fd4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(217,230,1,'Coletividades','2024-03-05 16:01:28','2024-03-05 16:01:28','266bc9c0-366a-4bef-a96d-f2716384e603',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(218,231,1,'Coletividades','2024-03-05 16:01:55','2024-03-05 16:01:55','03ae7351-5e9b-4e9b-97da-bae3c64a3f6a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(220,233,1,'Coletividades','2024-03-05 16:02:19','2024-03-05 16:02:19','704e28e9-ffdc-44ac-a291-09e4ca316fc8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Coletividades\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(221,234,1,'Atas da Assembleia de Freguesia','2024-03-05 16:19:59','2024-03-05 17:15:06','6032e09b-282d-4ff9-ab74-5fe2fdea1570',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Atas da Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(222,235,1,'Atas da Assembleia de Freguesia','2024-03-05 16:20:07','2024-03-05 16:20:07','60ac8b1e-853f-47e2-8852-41d58a40ae8a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(224,237,1,'Atas da Assembleia de Freguesia','2024-03-05 16:20:19','2024-03-05 16:20:19','e49b2878-402a-44e4-9a98-341a3cded68e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(226,239,1,'Atas da Assembleia de Freguesia','2024-03-05 16:24:05','2024-03-05 16:24:05','efe586a6-c2ec-41c8-9f0a-4ecaf50aa84a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Atas da Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(228,241,1,'Atas da Assembleia de Freguesia','2024-03-05 16:49:14','2024-03-05 16:49:14','19b49b73-5486-4e95-8912-856e282c8492',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Atas da Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(230,243,1,'Atas da Assembleia de Freguesia','2024-03-05 16:52:16','2024-03-05 16:52:16','24db6081-2c29-4a2a-91f1-da845b0a48eb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Atas da Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(231,244,1,'Editais','2024-03-05 16:53:32','2024-03-05 17:06:59','2a74f178-3010-47c8-b793-1963c2f0145f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Editais - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Editais - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(232,245,1,'Editais','2024-03-05 16:53:37','2024-03-05 16:53:37','8eeaec4b-e4ec-4a97-a141-822504e0d1f8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Editais - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Editais - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(233,246,1,'Taxas Freguesia','2024-03-05 16:54:19','2024-03-05 17:06:59','83e75ef3-d156-418e-9dd9-8a584d5116f8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Taxas Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(234,247,1,'Taxas Freguesia','2024-03-05 16:54:22','2024-03-05 16:54:22','1dd11857-4dba-446e-a57b-c6791e875182',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(236,249,1,'Taxas Freguesia','2024-03-05 16:54:28','2024-03-05 16:54:28','f3d479bf-0190-4fef-9973-5449f695fee3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Taxas Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(237,250,1,'Regulamentos','2024-03-05 16:54:33','2024-03-05 17:06:59','4e89353f-9482-4d88-a970-81e08c0bd808',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(238,251,1,'Regulamentos','2024-03-05 16:54:36','2024-03-05 16:54:36','d0c635fe-fb92-44e7-b80f-ae12bce47b0e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"- Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(240,253,1,'Atas da Assembleia de Freguesia','2024-03-05 17:15:06','2024-03-05 17:15:06','96a7287c-b36b-48f6-9d08-59e2b5e5b398',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Atas da Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atas da Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(241,254,1,'Coletividades','2024-03-05 17:18:09','2024-03-05 17:18:09','5c9a956b-c211-4fd9-bb1f-abd4d3dcedb9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Coletividades\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(243,256,1,'Coletividades','2024-03-05 17:18:20','2024-03-05 17:18:20','29ad9be5-1e3a-44b4-ae2c-345a47d92294',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Coletividades\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Coletividades - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(245,258,1,'Alminhas','2024-03-05 17:19:36','2024-03-05 17:19:36','4dbf4434-f139-4046-8aa2-5f157b4ee47a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Casa de Paçô Vieira\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Casa de Paçô Vieira - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(246,259,1,'Galeria','2024-03-05 17:21:32','2024-03-05 17:21:32','20a89a1e-af75-4c47-a8de-9233a2238417',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Galeria\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(248,261,1,'Galeria','2024-03-05 17:21:41','2024-03-05 17:21:41','920143d0-7a3d-4cc2-b014-589efa5fe5c2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Galeria\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Galeria - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(249,262,1,'Notícias','2024-03-05 17:22:34','2024-03-05 17:22:34','561072a6-1463-4b51-a8d0-6bac8b7ee531',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(250,263,1,'Notícias','2024-03-05 17:22:47','2024-03-05 17:22:47','dd2e3fb5-0079-482d-81b4-9903395ebedd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(252,265,1,'Notícias','2024-03-05 17:23:14','2024-03-05 17:23:14','1332036f-cd74-426f-98c7-911790127e2f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(254,267,1,'Notícias','2024-03-05 17:23:24','2024-03-05 17:23:24','17c2dbaa-9c35-4424-9f61-993ede9487cd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(256,269,1,'Notícias','2024-03-05 17:23:48','2024-03-05 17:23:48','73acde47-e1b8-4137-a947-b3473cad9549',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Notícias\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Notícias - Junta Mesão Frio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,0),(257,270,1,'O Cidadão','2024-03-05 17:24:55','2024-03-05 17:24:55','7d39c890-4aaf-4d4e-a0a4-3283acb520d3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,1,0),(258,271,1,'O Cidadão','2024-03-05 17:25:03','2024-03-05 17:25:03','8207aa2f-ba68-4189-870d-4975e5fe8b74',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,1,0),(259,272,1,'Seja bem-vindo(a) a Mesão-Frio!','2024-03-05 17:25:27','2024-03-05 17:25:27','348c3aa4-6c56-4612-a8ab-acde317eebcd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Homepage\",\"2\":\" - Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Inicio\",\"imageId\":\"11\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(260,273,1,'Eventos','2024-03-05 17:26:03','2024-03-05 17:26:03','cc153454-0cea-4b99-8a30-a0dd9c3f6bc3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,1,0),(263,276,1,'Eventos','2024-03-05 17:26:23','2024-03-05 17:26:23','1afee94b-90d0-4b0f-88f8-9e4ca62161a3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Eventos - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,0,1),(264,277,1,'O Cidadão','2024-03-05 17:26:56','2024-03-05 17:26:56','4f2f93b0-14f8-478b-bc32-165bb4edd6dc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"O Cidadão\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(265,278,1,'O Cidadão','2024-03-05 17:27:05','2024-03-05 17:27:05','5608b5fb-db20-40fb-b386-5d07272d4dea',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"O Cidadão\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"O Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(267,280,1,'Intervenção – Rua de São Pedro','2024-03-08 15:48:22','2024-03-08 15:48:22','2492a5ff-e3ac-4cda-9654-c67fde727a95',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(269,282,1,'Intervenção – Rua de São Pedro','2024-03-08 15:48:36','2024-03-08 15:48:36','37c5edb3-28a4-456d-a5b3-cca23c904db6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<br /><br />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><figure><img src=\"{asset:64:url||https://junta.cooperativamaismesaofrio.com/assets/images/news-text-image.png}\" alt=\"\" /></figure>\n<p><br /></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n<p></p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"BIKE CHALLENGE - Condicionamento do Trânsito - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}','Football refers to a number of sports that involve, to varying degrees, kicking a ball with\nthe foot to score a goal. Unqualified, the word football is understood to refer to whichever form of football is the most popular in the regional context in which the word appears.',NULL,NULL,NULL,NULL,NULL,NULL),(270,283,1,'História','2024-03-08 15:50:23','2024-03-08 15:52:49','8cdb5a76-cc98-4c5b-ac1f-8e74efb8bbee',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>História da freguesia</h2>\n<p>Mesão Frio é uma freguesia portuguesa do município de Guimarães, com 4,13 km² de área.</p><figure><img src=\"{asset:284:url||https://junta.cooperativamaismesaofrio.com/assets/images/historia/hostory.png}\" alt=\"History\" /></figure>','{\"titleRaw\":{\"1\":\"História\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"História - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"História - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(271,284,1,'Hostory','2024-03-08 15:51:55','2024-03-08 15:51:55','f9957a5e-72a1-42de-bded-d4ca3a29b109',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(272,285,1,'História','2024-03-08 15:52:24','2024-03-08 15:52:24','ef79a22b-7021-4ede-9d75-1aace5299105',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>História da freguesia</h2>\n<p>Mesão Frio é uma freguesia portuguesa do município de Guimarães, com 4,13 km² de área.</p><figure><img src=\"{asset:284:url||https://junta.cooperativamaismesaofrio.com/assets/images/historia/hostory.png}\" alt=\"History\" /></figure>','{\"titleRaw\":{\"1\":\"História\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"História - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"História - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(274,287,1,'História','2024-03-08 15:52:49','2024-03-08 15:52:49','144d27e3-829a-422b-94d6-9fed89260fc8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>História da freguesia</h2>\n<p>Mesão Frio é uma freguesia portuguesa do município de Guimarães, com 4,13 km² de área.</p><figure><img src=\"{asset:284:url||https://junta.cooperativamaismesaofrio.com/assets/images/historia/hostory.png}\" alt=\"History\" /></figure>','{\"titleRaw\":{\"1\":\"História\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"História - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"História - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(275,288,1,'Heráldica','2024-03-08 16:00:27','2024-03-08 16:04:45','36f0ee3b-9601-4e04-8122-bada5e3d1afe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<figure><img src=\"{asset:289:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-1.png}\" alt=\"logo\" /></figure>\n<p><strong>Brasão: Armas</strong></p>\n<p>Escudo de ouro, com dois pinheiros arrancados de verde, alinhados em faixa, entre um cacho de uvas de púrpura, folhado de verde, em chefe e uma roda dentada de vermelho, em campanha. Coroa mural de prata de três torres. Listel branco, com a legenda a negro: “ MESÃO FRIO - GUIMARÃES “.<br /></p>\n<hr />\n<figure><img src=\"{asset:290:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-2.png}\" alt=\"flag\" /></figure>\n<p><strong>Bandeira</strong></p>\n<p>De verde. Cordões e borlas de ouro e verde. Haste e lança de ouro.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(276,289,1,'Logo 10 1','2024-03-08 16:02:35','2024-03-08 16:02:35','8b025733-112d-4b1a-bd08-2e9f06d632b2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(277,290,1,'Logo 10 2','2024-03-08 16:03:55','2024-03-08 16:03:55','06ecae0c-268d-477d-86e8-3d1d596a0aba',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(278,291,1,'Heráldica','2024-03-08 16:04:17','2024-03-08 16:04:17','6feae7ba-e0ff-4844-8fd1-1d1c2b31f759',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<figure><img src=\"{asset:289:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-1.png}\" alt=\"logo\" /></figure>\n<p><strong>Brasão: Armas</strong></p>\n<p>Escudo de ouro, com dois pinheiros arrancados de verde, alinhados em faixa, entre um cacho de uvas de púrpura, folhado de verde, em chefe e uma roda dentada de vermelho, em campanha. Coroa mural de prata de três torres. Listel branco, com a legenda a negro: “ MESÃO FRIO - GUIMARÃES “.<br /></p>\n<pre>&lt;hr/&gt;\n</pre><figure><img src=\"{asset:290:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-2.png}\" alt=\"flag\" /></figure>\n<p><strong>Bandeira</strong></p>\n<p>De verde. Cordões e borlas de ouro e verde. Haste e lança de ouro.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(280,293,1,'Heráldica','2024-03-08 16:04:23','2024-03-08 16:04:23','612fed34-9dce-4606-a2d2-91950c2651ee',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<figure><img src=\"{asset:289:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-1.png}\" alt=\"logo\" /></figure>\n<p><strong>Brasão: Armas</strong></p>\n<p>Escudo de ouro, com dois pinheiros arrancados de verde, alinhados em faixa, entre um cacho de uvas de púrpura, folhado de verde, em chefe e uma roda dentada de vermelho, em campanha. Coroa mural de prata de três torres. Listel branco, com a legenda a negro: “ MESÃO FRIO - GUIMARÃES “.<br /></p>\n<pre>&lt;hr/&gt;\n</pre><figure><img src=\"{asset:290:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-2.png}\" alt=\"flag\" /></figure>\n<p><strong>Bandeira</strong></p>\n<p>De verde. Cordões e borlas de ouro e verde. Haste e lança de ouro.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(282,295,1,'Heráldica','2024-03-08 16:04:45','2024-03-08 16:04:45','9ba8f15b-a8f5-4aee-8c08-245f5f0f628d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<figure><img src=\"{asset:289:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-1.png}\" alt=\"logo\" /></figure>\n<p><strong>Brasão: Armas</strong></p>\n<p>Escudo de ouro, com dois pinheiros arrancados de verde, alinhados em faixa, entre um cacho de uvas de púrpura, folhado de verde, em chefe e uma roda dentada de vermelho, em campanha. Coroa mural de prata de três torres. Listel branco, com a legenda a negro: “ MESÃO FRIO - GUIMARÃES “.<br /></p>\n<hr />\n<figure><img src=\"{asset:290:url||https://junta.cooperativamaismesaofrio.com/assets/images/heraldica/logo-10-2.png}\" alt=\"flag\" /></figure>\n<p><strong>Bandeira</strong></p>\n<p>De verde. Cordões e borlas de ouro e verde. Haste e lança de ouro.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Heráldica - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(283,296,1,'Património Arquitectónico','2024-03-08 16:09:44','2024-03-08 16:14:11','e1664664-f730-46c7-808d-ea80ff1ccb11',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Património existente na nossa Freguesia.</p>\n<figure><img src=\"{asset:299:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-1.png}\" alt=\"Santo António\" /></figure>\n<p><strong>Santo António</strong></p>\n\n<hr />\n<figure><img src=\"{asset:300:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-2.png}\" alt=\"Junta de Freguesia de Mesão frio\" /></figure>\n<p><strong>Junta de Freguesia de Mesão frio</strong></p><hr /><figure><img src=\"{asset:301:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-3.png}\" alt=\"Casa Margaride\" /></figure>\n<p><strong>Casa Margaride</strong><strong></strong></p><hr /><figure><img src=\"{asset:302:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-4.png}\" alt=\"Igreja Paroquial\" /></figure>\n<p><strong>Igreja Paroquial</strong></p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Património Arquitectónico - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Património Arquitectónico - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(284,297,1,'Património Arquitectónico','2024-03-08 16:10:01','2024-03-08 16:10:01','f8d26d2a-4055-40de-8d3b-ed3e7e3e14cb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Património Arquitectónico - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Património Arquitectónico - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(286,299,1,'Patrimonio 1','2024-03-08 16:11:02','2024-03-08 16:11:02','8b7c484f-ce48-4d9c-b441-567cd58ce5c0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(287,300,1,'Patrimonio 2','2024-03-08 16:11:31','2024-03-08 16:11:31','f90b775a-6bc3-41b7-805c-6816b15fcfd3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(288,301,1,'Patrimonio 3','2024-03-08 16:11:31','2024-03-08 16:11:31','de33c79a-8ff9-49ee-83a4-79da69215f13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(289,302,1,'Patrimonio 4','2024-03-08 16:11:32','2024-03-08 16:11:32','ffc1e1cc-dd88-41cf-a591-7baea6eb5dd3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(290,303,1,'Patrimonio 5','2024-03-08 16:11:33','2024-03-08 16:11:33','b5e16787-d722-41a9-8ce5-09e8e5a26478',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(291,304,1,'Património Arquitectónico','2024-03-08 16:14:12','2024-03-08 16:14:12','b78a2aaa-f0a1-4ce7-9626-3183721e8e9e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Património existente na nossa Freguesia.</p>\n<figure><img src=\"{asset:299:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-1.png}\" alt=\"Santo António\" /></figure>\n<p><strong>Santo António</strong></p>\n\n<hr />\n<figure><img src=\"{asset:300:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-2.png}\" alt=\"Junta de Freguesia de Mesão frio\" /></figure>\n<p><strong>Junta de Freguesia de Mesão frio</strong></p><hr /><figure><img src=\"{asset:301:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-3.png}\" alt=\"Casa Margaride\" /></figure>\n<p><strong>Casa Margaride</strong><strong></strong></p><hr /><figure><img src=\"{asset:302:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio/patrimonio-4.png}\" alt=\"Igreja Paroquial\" /></figure>\n<p><strong>Igreja Paroquial</strong></p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Património Arquitectónico - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Património Arquitectónico - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(292,305,1,'Património Natural','2024-03-08 16:15:38','2024-03-08 16:18:37','67d3dd0d-0921-4550-80be-f9138715fc88',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<figure><img src=\"{asset:307:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio-natural/patrimonio-natural.png}\" alt=\"Monte de Santo Antonino\" /></figure>\n<p><strong>Monte de Santo Antonino</strong></p>\n\n<hr />\n<figure><img src=\"{asset:306:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio-natural/patrimonio-natural-2.png}\" alt=\"Parque da Cidade de Guimarães\" /></figure>\n<p><strong>Parque da Cidade de Guimarães</strong></p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Património Natural - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Património Natural - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(293,306,1,'Patrimonio natural 2','2024-03-08 16:16:18','2024-03-08 16:16:18','89535f95-1ac1-4090-9b7b-75391c522783',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(294,307,1,'Patrimonio natural','2024-03-08 16:16:18','2024-03-08 16:16:18','9f499d4f-4451-4954-a679-0a047904eeab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(295,308,1,'Património Natural','2024-03-08 16:17:15','2024-03-08 16:17:15','c42e064c-190b-442c-8745-5f64bd5c1a4e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<figure><img src=\"{asset:307:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio-natural/patrimonio-natural.png}\" alt=\"Monte de Santo Antonino\" /></figure>\n<p><strong>Monte de Santo Antonino</strong></p>\n\n<hr />\n<figure><img src=\"{asset:306:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio-natural/patrimonio-natural-2.png}\" alt=\"Parque da Cidade de Guimarães\" /></figure>\n<p><strong>Parque da Cidade de Guimarães</strong></p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Património Natural - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Património Natural - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(297,310,1,'Património Natural','2024-03-08 16:18:37','2024-03-08 16:18:37','7858f52c-188f-4cbc-a8c1-db013f266556',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<figure><img src=\"{asset:307:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio-natural/patrimonio-natural.png}\" alt=\"Monte de Santo Antonino\" /></figure>\n<p><strong>Monte de Santo Antonino</strong></p>\n\n<hr />\n<figure><img src=\"{asset:306:url||https://junta.cooperativamaismesaofrio.com/assets/images/patrimonio-natural/patrimonio-natural-2.png}\" alt=\"Parque da Cidade de Guimarães\" /></figure>\n<p><strong>Parque da Cidade de Guimarães</strong></p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Património Natural - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Património Natural - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(298,311,1,'Junta de freguesia','2024-03-08 16:46:54','2024-03-08 16:51:12','abbde75f-614b-4056-9af3-7fe8ad8fef64','Mensagem do Presidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Muito bem vindo/a à nova página da Freguesia de Mesão Frio.<br />De modo a modernizar os nossos serviços, a nossa Junta de Freguesia apresenta esta plataforma online para facilitar os objetivos dos mesão-frienses no acesso à vida social dentro da freguesia.<br />O nosso objetivo é obter uma maior proximidade com os cidadãos, garantindo assim uma maior facilidade de contacto.<br />Com este novo executivo, gostaríamos que nos visitasse de forma a conhecer melhor os cidadãos da nossa Freguesia. Neste website conseguem vão encontrar atividades e novidades brevemente.<br /><br />Melhores Cumprimentos,<br />O vosso Presidente,<strong><br />José Silva</strong></p>','{\"titleRaw\":{\"1\":\"Junta de freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(299,312,1,'Junta de freguesia','2024-03-08 16:47:26','2024-03-08 16:47:26','1c9e54b1-0dc4-4971-81f8-f4f85482e389','Mensagem do Presidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Muito bem vindo/a à nova página da Freguesia de Mesão Frio.<br />De modo a modernizar os nossos serviços, a nossa Junta de Freguesia apresenta esta plataforma online para facilitar os objetivos dos mesão-frienses no acesso à vida social dentro da freguesia.<br />O nosso objetivo é obter uma maior proximidade com os cidadãos, garantindo assim uma maior facilidade de contacto.<br />Com este novo executivo, gostaríamos que nos visitasse de forma a conhecer melhor os cidadãos da nossa Freguesia. Neste website conseguem vão encontrar atividades e novidades brevemente.<br /><br />Melhores Cumprimentos,<br />O vosso Presidente,<strong><br />José Silva</strong></p>','{\"titleRaw\":{\"1\":\"Junta de freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(301,314,1,'Junta de freguesia','2024-03-08 16:47:31','2024-03-08 16:47:31','bec2e1e1-a5db-4736-9976-b7a16a3d5231','Mensagem do Presidente',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Muito bem vindo/a à nova página da Freguesia de Mesão Frio.<br />De modo a modernizar os nossos serviços, a nossa Junta de Freguesia apresenta esta plataforma online para facilitar os objetivos dos mesão-frienses no acesso à vida social dentro da freguesia.<br />O nosso objetivo é obter uma maior proximidade com os cidadãos, garantindo assim uma maior facilidade de contacto.<br />Com este novo executivo, gostaríamos que nos visitasse de forma a conhecer melhor os cidadãos da nossa Freguesia. Neste website conseguem vão encontrar atividades e novidades brevemente.<br /><br />Melhores Cumprimentos,<br />O vosso Presidente,<strong><br />José Silva</strong></p>','{\"titleRaw\":{\"1\":\"Junta de freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(303,316,1,'Junta de freguesia','2024-03-08 16:51:12','2024-03-08 16:51:12','7c3b8cc2-55c5-40fb-a480-f851f1193970',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Muito bem vindo/a à nova página da Freguesia de Mesão Frio.<br />De modo a modernizar os nossos serviços, a nossa Junta de Freguesia apresenta esta plataforma online para facilitar os objetivos dos mesão-frienses no acesso à vida social dentro da freguesia.<br />O nosso objetivo é obter uma maior proximidade com os cidadãos, garantindo assim uma maior facilidade de contacto.<br />Com este novo executivo, gostaríamos que nos visitasse de forma a conhecer melhor os cidadãos da nossa Freguesia. Neste website conseguem vão encontrar atividades e novidades brevemente.<br /><br />Melhores Cumprimentos,<br />O vosso Presidente,<strong><br />José Silva</strong></p>','{\"titleRaw\":{\"1\":\"Junta de freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Junta de freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(304,317,1,'Freguesia','2024-03-08 17:02:27','2024-03-08 17:02:57','d0c05f10-e4de-4cad-835a-28b98a21ece3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Sobre a freguesia</h2>\n<p>O Cultivo da Vinha, os Sobreiros e a Roda Dentada são os símbolos de Mesão Frio, procriando o seu passado no futuro.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(305,318,1,'Freguesia','2024-03-08 17:02:57','2024-03-08 17:02:57','60da9b7f-d3f1-4b41-93c4-865f9d24afb1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Sobre a freguesia</h2>\n<p>O Cultivo da Vinha, os Sobreiros e a Roda Dentada são os símbolos de Mesão Frio, procriando o seu passado no futuro.</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(306,319,1,'Mensagem do Presidente','2024-03-08 17:09:39','2024-03-08 17:10:25','97ae059e-dc62-4848-b639-2e1ead4b4507',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Seja bem Vindo/a à nova página da Freguesia de Mesão – Frio.<br /><br />No mundo cada vez mais apoiado pelas novas tecnologias, a nossa Freguesia não podia deixar de estar presente neste gigantesco mundo virtual com um Website que honre a nossa história e o nosso povo, e orgulhe cada um dos habitantes desta magnífica freguesia.<br /><br />Esperamos que este novo espaço de informação da nossa freguesia seja da maior utilidade para si. Queremos estar mais próximos de todos os MesãoFrienses, garantir mais informação e com mais rapidez de difusão, assegurar que no conforto da sua casa tem acesso a toda a informação que necessita.<br /><br />Desejamos que nos visite inúmeras vezes e nos envie as suas considerações, opiniões, contributos imprescindíveis para que o nosso trabalho seja mais e melhor a cada dia.<br /><br />Abrimos, desta forma, uma nova página na comunicação do Executivo com toda a população que servimos, teremos mais novidades em breve.Hoje, como sempre, estamos para servir.<br /><br />Melhores Cumprimentos,<br />O vosso Presidente,<strong><br />José Silva</strong></p>','{\"titleRaw\":{\"1\":\"Mensagem do Presidente\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Mensagem do Presidente - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Mensagem do Presidente - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(307,320,1,'Mensagem do Presidente','2024-03-08 17:09:57','2024-03-08 17:09:57','310e5ddb-57a6-4633-8b48-0729926a351e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Seja bem Vindo/a à nova página da Freguesia de Mesão – Frio.<br /><br />No mundo cada vez mais apoiado pelas novas tecnologias, a nossa Freguesia não podia deixar de estar presente neste gigantesco mundo virtual com um Website que honre a nossa história e o nosso povo, e orgulhe cada um dos habitantes desta magnífica freguesia.<br /><br />Esperamos que este novo espaço de informação da nossa freguesia seja da maior utilidade para si. Queremos estar mais próximos de todos os MesãoFrienses, garantir mais informação e com mais rapidez de difusão, assegurar que no conforto da sua casa tem acesso a toda a informação que necessita.<br /><br />Desejamos que nos visite inúmeras vezes e nos envie as suas considerações, opiniões, contributos imprescindíveis para que o nosso trabalho seja mais e melhor a cada dia.<br /><br />Abrimos, desta forma, uma nova página na comunicação do Executivo com toda a população que servimos, teremos mais novidades em breve.Hoje, como sempre, estamos para servir.<br /><br />Melhores Cumprimentos,<br />O vosso Presidente,<strong><br />José Silva</strong></p>','{\"titleRaw\":{\"1\":\"Men\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Men - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Men - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(309,322,1,'Mensagem do Presidente','2024-03-08 17:10:25','2024-03-08 17:10:25','bbe7b213-1626-4ae0-8adb-67c1478bf5fa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Seja bem Vindo/a à nova página da Freguesia de Mesão – Frio.<br /><br />No mundo cada vez mais apoiado pelas novas tecnologias, a nossa Freguesia não podia deixar de estar presente neste gigantesco mundo virtual com um Website que honre a nossa história e o nosso povo, e orgulhe cada um dos habitantes desta magnífica freguesia.<br /><br />Esperamos que este novo espaço de informação da nossa freguesia seja da maior utilidade para si. Queremos estar mais próximos de todos os MesãoFrienses, garantir mais informação e com mais rapidez de difusão, assegurar que no conforto da sua casa tem acesso a toda a informação que necessita.<br /><br />Desejamos que nos visite inúmeras vezes e nos envie as suas considerações, opiniões, contributos imprescindíveis para que o nosso trabalho seja mais e melhor a cada dia.<br /><br />Abrimos, desta forma, uma nova página na comunicação do Executivo com toda a população que servimos, teremos mais novidades em breve.Hoje, como sempre, estamos para servir.<br /><br />Melhores Cumprimentos,<br />O vosso Presidente,<strong><br />José Silva</strong></p>','{\"titleRaw\":{\"1\":\"Mensagem do Presidente\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Mensagem do Presidente - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Mensagem do Presidente - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(310,323,1,'John Doe','2024-03-08 17:17:23','2024-03-08 17:19:23','8e519071-0c2c-46b5-b34e-4076ccbab125','Presidente Assembleia',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(311,324,1,'Johndoe','2024-03-08 17:19:21','2024-03-08 17:19:21','dc9c6c4a-232f-45c5-a66e-424156778765',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(313,326,1,'John Doe','2024-03-08 17:19:32','2024-03-08 17:20:43','3d9e5345-6374-4dad-9470-93d43fff1864','Deputado',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(314,327,1,'Rectangle 1','2024-03-08 17:19:50','2024-03-08 17:19:50','acdc53a5-b0b1-454b-9f6f-273f5cbc2825',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(316,329,1,'John Doe 2','2024-03-08 17:19:56','2024-03-08 17:20:34','34b63ca8-db9d-4175-90ec-615ec52f6420','Deputado',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(318,331,1,'Rectangle 1','2024-03-08 17:20:23','2024-03-08 17:20:23','db640b46-fb19-445a-b2cc-ba5a696829b1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(320,333,1,'John Doe 2','2024-03-08 17:20:48','2024-03-08 17:21:19','21ecb372-b924-49b3-a06a-2cd70c748d8e','Deputado',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(322,335,1,'Rectangle 1','2024-03-08 17:21:17','2024-03-08 17:21:17','5318f192-56bd-4bfa-abf1-005c67e25eaf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(323,336,1,'John Doe 2','2024-03-08 17:21:23','2024-03-08 17:21:47','01219d53-9ae8-4968-9702-40ee47adf77e','Deputado',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(325,338,1,'Rectangle 1','2024-03-08 17:21:46','2024-03-08 17:21:46','cbf7dd6c-f031-42bf-88e0-67b60aa18f55',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(326,339,1,'Assembleia de Freguesia','2024-03-08 17:29:25','2024-03-08 17:35:32','70ca2259-eb9f-4b89-9933-ae7bc23bad23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Constituição da Junta de Freguesia de Mesão Frio</h2>\n<p>Lorem ipsum dolor sit</p>','{\"titleRaw\":{\"1\":\"Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(327,340,1,'Assembleia de Freguesia','2024-03-08 17:29:48','2024-03-08 17:29:48','312bd6c6-12b1-412e-ae43-773faab34cb7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Constituição da Junta de Freguesia de Mesão Frio</h2>\n<p>Lorem ipsum dolor sit</p>','{\"titleRaw\":{\"1\":\"Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(329,342,1,'José Pereira da Silva','2024-03-08 17:33:32','2024-03-08 17:34:10','edd8481b-e1b5-4a86-8660-a289e341cf19','Presidente',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(330,343,1,'Rectangle 1','2024-03-08 17:33:54','2024-03-08 17:33:54','890d6f08-ae56-44f5-903b-80daca537c57',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(331,344,1,'António Gonçalves Fernandes','2024-03-08 17:34:16','2024-03-08 17:34:42','d0022ff7-fdab-4802-ad1e-501f5bce1a7e','Secretário',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(333,346,1,'Rectangle 1','2024-03-08 17:34:32','2024-03-08 17:34:32','cd9dafda-0fdd-4235-8613-70329c69f1d0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(334,347,1,'Marta Maria Miranda Vieira','2024-03-08 17:34:47','2024-03-08 17:35:12','5f6f3431-a04d-4ea4-9643-f09f84833f3d','Tesoureira',NULL,NULL,NULL,'email@juntafreguesiamesaofrio.pt',NULL,NULL,NULL,NULL,'(+351) 910 000 000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(336,349,1,'Rectangle 1','2024-03-08 17:35:10','2024-03-08 17:35:10','bea2c016-517d-442f-8319-2ab5ea2d7fea',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(337,350,1,'Assembleia de Freguesia','2024-03-08 17:35:32','2024-03-08 17:35:32','657b1730-25a8-46d9-802a-2955f41f197f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Constituição da Junta de Freguesia de Mesão Frio</h2>\n<p>Lorem ipsum dolor sit</p>','{\"titleRaw\":{\"1\":\"Assembleia de Freguesia\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Assembleia de Freguesia - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(338,351,1,'Executivo','2024-03-08 17:35:37','2024-03-08 17:36:33','a6544177-c3f5-45f7-a2b8-4369daeb92ca',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Constituição da Junta de Freguesia de Mesão Frio</h2>\n<p>Lorem ipsum dolor sit</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Executivo - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Executivo - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(339,352,1,'Executivo','2024-03-08 17:36:00','2024-03-08 17:36:00','6b1b4345-264d-4e10-bca5-bd3ae68e68e7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Constituição da Junta de Freguesia de Mesão Frio</h2>\n<p>Lorem ipsum dolor sit</p>','{\"titleRaw\":{\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Executivo - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Executivo - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(340,353,1,'Política de privacidade','2024-03-08 17:49:48','2024-03-08 17:57:00','967108b6-9cf3-4e01-bdb4-cbceba7d5a26',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Lorem ipsum dolor sit amet</h2>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>','{\"titleRaw\":{\"1\":\"Política de privacidade\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,0),(341,354,1,'Política de privacidade','2024-03-08 17:49:48','2024-03-08 17:49:48','2ce4d666-a337-4cee-9900-9f042838b4fd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(342,355,1,'Política de privacidade','2024-03-08 17:49:48','2024-03-08 17:49:48','271a2987-dada-490a-bd9d-9a8747868e0b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(343,356,1,'Política de privacidade','2024-03-08 17:50:38','2024-03-08 17:50:38','b9cf0cb3-636f-4a08-9e47-25ea241edcc1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,1,0),(345,358,1,'Política de privacidade','2024-03-08 17:51:18','2024-03-08 17:51:18','dbd5baf8-6f60-4592-938d-55921ff75d35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>','{\"titleRaw\":[],\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"neutral\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":null,\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":null}}',NULL,NULL,NULL,NULL,NULL,1,0),(347,360,1,'Política de privacidade','2024-03-08 17:51:25','2024-03-08 17:51:25','894ae46e-12f5-4034-85c0-491c91f26e74',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong>Lorem ipsum dolor sit amet</strong></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>','{\"titleRaw\":{\"1\":\"Política de privacidade\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,0),(349,362,1,'Política de privacidade','2024-03-08 17:53:55','2024-03-08 17:53:55','9acbff2f-0121-480c-a4ef-8e045ebccfc9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Lorem ipsum dolor sit amet</h2>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>','{\"titleRaw\":{\"1\":\"Política de privacidade\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,0),(350,363,1,'Política de privacidade','2024-03-08 17:57:00','2024-03-08 17:57:00','4bbd8e29-9961-46c5-9c75-dba165a242eb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Lorem ipsum dolor sit amet</h2>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>\n<p><strong></strong></p><h2><strong>Lorem ipsum dolor sit amet</strong></h2>\n<p></p>\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Netus et malesuada fames ac turpis egestas. Vestibulum sed arcu non odio euismod lacinia at quis. Vel fringilla est ullamcorper eget nulla facilisi etiam dignissim. Interdum velit euismod in pellentesque massa placerat duis. Ullamcorper velit sed ullamcorper morbi tincidunt. Et tortor at risus viverra adipiscing. Lorem dolor sed viverra ipsum nunc aliquet bibendum enim. Et magnis dis parturient montes. Et sollicitudin ac orci phasellus egestas. Ultrices vitae auctor eu augue ut. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec.</p>','{\"titleRaw\":{\"1\":\"Política de privacidade\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Política de privacidade - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,0),(351,364,1,'Atendimento Geral','2024-03-11 10:59:39','2024-03-11 11:00:47','5e4f6616-2e00-4fbe-a719-298ea99a058e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Serviços Disponíveis no Atendimento Geral</h2><ul><li>Pedidos/Envio de informação</li><li>Pedido de Audiência com o Presidente</li><li>Pedidos de Emissão de Atestados/Certidões/Declarações</li><li>Registo e atribuição da licença de canídeos</li><li>Inscrições e pagamentos de atividades</li><li>Registo de ocorrências e comunicação às entidades competentes</li><li>Preenchimento de requerimentos da segurança social, finanças, entre outros</li><li>Provas de vida (certificação, preenchimento e preenchimento dos avisos de receção e registos dos CTT)</li><li>Gestão dos Processos do Cemitério (Requerimentos e Pagamentos)</li></ul>','{\"titleRaw\":{\"1\":\"Atendimento Geral\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atendimento Geral - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atendimento Geral - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(352,365,1,'Atendimento Geral','2024-03-11 10:59:52','2024-03-11 10:59:52','c1d03f17-3d2f-4420-b55c-8eb589b803e2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"titleRaw\":{\"1\":\"Atendimento Geral\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atendimento Geral - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atendimento Geral - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(354,367,1,'Atendimento Geral','2024-03-11 11:00:47','2024-03-11 11:00:47','59b34c09-baf4-41b0-8b5d-85eb0de84ed5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Serviços Disponíveis no Atendimento Geral</h2><ul><li>Pedidos/Envio de informação</li><li>Pedido de Audiência com o Presidente</li><li>Pedidos de Emissão de Atestados/Certidões/Declarações</li><li>Registo e atribuição da licença de canídeos</li><li>Inscrições e pagamentos de atividades</li><li>Registo de ocorrências e comunicação às entidades competentes</li><li>Preenchimento de requerimentos da segurança social, finanças, entre outros</li><li>Provas de vida (certificação, preenchimento e preenchimento dos avisos de receção e registos dos CTT)</li><li>Gestão dos Processos do Cemitério (Requerimentos e Pagamentos)</li></ul>','{\"titleRaw\":{\"1\":\"Atendimento Geral\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Atendimento Geral - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Atendimento Geral - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(355,368,1,'Espaço Cidadão','2024-03-11 11:05:11','2024-03-11 11:11:42','48db7928-5a22-421d-816c-87079d7cf67d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure>\n            <img src=\"{asset:369:url||https://junta.cooperativamaismesaofrio.com/assets/images/espaco-cidadao/espaco-cidadao.png}\" alt=\"espaco cidadao\" />\n        </figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p>O Espaço de Cidadão de Mesão Frio, funciona das 09h30 às 12h30 e das 14h30 às 18h30, de Segunda a Sexta-Feira.</p>\n    </div>\n</div>\n<hr />\n<p><strong>Dispõe dos seguintes serviços:</strong></p>\n<ul><li>Adquirir livros e publicações da linha editorial da Autoridade para as Condições do Trabalho (ACT)</li><li>Agendar atendimento na Segurança Social</li><li>Agendar atendimento no Serviço de Estrangeiros e Fronteiras (SEF)</li><li>Alterar a morada do Cartão de Cidadão</li><li>Alterar dados pessoais na Segurança Social</li><li>Alterar os dados associados à Chave Móvel Digital</li><li>Alterar os dados de subscritor da Caixa Geral de Aposentações</li><li>Apresentar a declaração anual de rendas recebidas</li><li>Ativar a assinatura digital da Chave Móvel Digital (CMD)</li><li>Ativar a Chave Móvel Digital</li><li>Caderneta predial – certidão</li><li>Caderneta predial – certidão de teor matricial</li><li>Cancelar consulta médica</li><li>Cancelar o Cartão de Cidadão</li><li>Comunicar a contratação de trabalhador/a estrangeiro/a</li><li>Confirmar a alteração de morada do Cartão de Cidadão</li><li>Consultar, gerir e validar faturas no e-Fatura</li><li>Consultar a declaração e obter comprovativo do IRS</li><li>Consultar a lista de espera para cirurgia</li><li>Consultar as despesas com prestadores com acordo com a ADSE</li><li>Consultar a situação contributiva</li><li>Consultar Dívidas fiscais</li><li>Consultar e mudar de tarifário de eletricidade e gás natural através do Poupa Energia</li><li>Consultar o boletim de vacinas</li><li>Consultar o boletim infantil e juvenil</li><li>Consultar os descontos feitos anualmente e a utilização que já fez da ADSE</li><li>Consultar os limites de utilização da ADSE</li><li>Consultar os processos de cancelamento e/ou renovação online do Cartão de Cidadão</li><li>Criar e gerir conta na CGA Direta</li><li>Descarregar Testamento Vital</li><li>Divulgar, gerir e acompanhar ofertas de emprego no Instituto do Emprego e Formação Profissional (IEFP)</li><li>Emitir recibo eletrónico de quitação de rendas</li><li>Entregar os descontos à ADSE</li><li>Fazer prova de condição de recursos do agregado familiar à Caixa Geral de Aposentações (CGA)</li></ul>','{\"titleRaw\":{\"1\":\"Espaço Cidadão\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(356,369,1,'Espaco cidadao','2024-03-11 11:06:20','2024-03-11 11:06:20','0ff0eb24-2644-4b36-95ca-7d446364090a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(357,370,1,'Espaço Cidadão','2024-03-11 11:09:58','2024-03-11 11:09:58','072c8b5e-59da-4a9b-bd84-381313dc9a7a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<div class=\"d-flex\">\n    <div class=\"md-6\">\n        <figure>\n            <img src=\"{asset:369:url||https://junta.cooperativamaismesaofrio.com/assets/images/espaco-cidadao/espaco-cidadao.png}\" alt=\"espaco cidadao\" />\n        </figure>\n    </div>\n    <div class=\"md-6\">\n        <p>O Espaço de Cidadão de Mesão Frio, funciona das 09h30 às 12h30 e das 14h30 às 18h30, de Segunda a Sexta-Feira.</p>\n    </div>\n</div>\n<hr />\n<p><strong>Dispõe dos seguintes serviços:</strong></p>\n<ul><li>Adquirir livros e publicações da linha editorial da Autoridade para as Condições do Trabalho (ACT)</li><li>Agendar atendimento na Segurança Social</li><li>Agendar atendimento no Serviço de Estrangeiros e Fronteiras (SEF)</li><li>Alterar a morada do Cartão de Cidadão</li><li>Alterar dados pessoais na Segurança Social</li><li>Alterar os dados associados à Chave Móvel Digital</li><li>Alterar os dados de subscritor da Caixa Geral de Aposentações</li><li>Apresentar a declaração anual de rendas recebidas</li><li>Ativar a assinatura digital da Chave Móvel Digital (CMD)</li><li>Ativar a Chave Móvel Digital</li><li>Caderneta predial – certidão</li><li>Caderneta predial – certidão de teor matricial</li><li>Cancelar consulta médica</li><li>Cancelar o Cartão de Cidadão</li><li>Comunicar a contratação de trabalhador/a estrangeiro/a</li><li>Confirmar a alteração de morada do Cartão de Cidadão</li><li>Consultar, gerir e validar faturas no e-Fatura</li><li>Consultar a declaração e obter comprovativo do IRS</li><li>Consultar a lista de espera para cirurgia</li><li>Consultar as despesas com prestadores com acordo com a ADSE</li><li>Consultar a situação contributiva</li><li>Consultar Dívidas fiscais</li><li>Consultar e mudar de tarifário de eletricidade e gás natural através do Poupa Energia</li><li>Consultar o boletim de vacinas</li><li>Consultar o boletim infantil e juvenil</li><li>Consultar os descontos feitos anualmente e a utilização que já fez da ADSE</li><li>Consultar os limites de utilização da ADSE</li><li>Consultar os processos de cancelamento e/ou renovação online do Cartão de Cidadão</li><li>Criar e gerir conta na CGA Direta</li><li>Descarregar Testamento Vital</li><li>Divulgar, gerir e acompanhar ofertas de emprego no Instituto do Emprego e Formação Profissional (IEFP)</li><li>Emitir recibo eletrónico de quitação de rendas</li><li>Entregar os descontos à ADSE</li><li>Fazer prova de condição de recursos do agregado familiar à Caixa Geral de Aposentações (CGA)</li></ul>','{\"titleRaw\":{\"1\":\"Espaço Cidadão\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(359,372,1,'Espaço Cidadão','2024-03-11 11:10:56','2024-03-11 11:10:56','0997f59b-7eec-4ad3-85f6-9f7eeec74533',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<div class=\"d-flex\">\n    <div class=\"col-md-6\">\n        <figure>\n            <img src=\"{asset:369:url||https://junta.cooperativamaismesaofrio.com/assets/images/espaco-cidadao/espaco-cidadao.png}\" alt=\"espaco cidadao\" />\n        </figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p>O Espaço de Cidadão de Mesão Frio, funciona das 09h30 às 12h30 e das 14h30 às 18h30, de Segunda a Sexta-Feira.</p>\n    </div>\n</div>\n<hr />\n<p><strong>Dispõe dos seguintes serviços:</strong></p>\n<ul><li>Adquirir livros e publicações da linha editorial da Autoridade para as Condições do Trabalho (ACT)</li><li>Agendar atendimento na Segurança Social</li><li>Agendar atendimento no Serviço de Estrangeiros e Fronteiras (SEF)</li><li>Alterar a morada do Cartão de Cidadão</li><li>Alterar dados pessoais na Segurança Social</li><li>Alterar os dados associados à Chave Móvel Digital</li><li>Alterar os dados de subscritor da Caixa Geral de Aposentações</li><li>Apresentar a declaração anual de rendas recebidas</li><li>Ativar a assinatura digital da Chave Móvel Digital (CMD)</li><li>Ativar a Chave Móvel Digital</li><li>Caderneta predial – certidão</li><li>Caderneta predial – certidão de teor matricial</li><li>Cancelar consulta médica</li><li>Cancelar o Cartão de Cidadão</li><li>Comunicar a contratação de trabalhador/a estrangeiro/a</li><li>Confirmar a alteração de morada do Cartão de Cidadão</li><li>Consultar, gerir e validar faturas no e-Fatura</li><li>Consultar a declaração e obter comprovativo do IRS</li><li>Consultar a lista de espera para cirurgia</li><li>Consultar as despesas com prestadores com acordo com a ADSE</li><li>Consultar a situação contributiva</li><li>Consultar Dívidas fiscais</li><li>Consultar e mudar de tarifário de eletricidade e gás natural através do Poupa Energia</li><li>Consultar o boletim de vacinas</li><li>Consultar o boletim infantil e juvenil</li><li>Consultar os descontos feitos anualmente e a utilização que já fez da ADSE</li><li>Consultar os limites de utilização da ADSE</li><li>Consultar os processos de cancelamento e/ou renovação online do Cartão de Cidadão</li><li>Criar e gerir conta na CGA Direta</li><li>Descarregar Testamento Vital</li><li>Divulgar, gerir e acompanhar ofertas de emprego no Instituto do Emprego e Formação Profissional (IEFP)</li><li>Emitir recibo eletrónico de quitação de rendas</li><li>Entregar os descontos à ADSE</li><li>Fazer prova de condição de recursos do agregado familiar à Caixa Geral de Aposentações (CGA)</li></ul>','{\"titleRaw\":{\"1\":\"Espaço Cidadão\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(360,373,1,'Espaço Cidadão','2024-03-11 11:11:42','2024-03-11 11:11:42','4b3bc783-a619-4677-8a86-95f68742607e',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure>\n            <img src=\"{asset:369:url||https://junta.cooperativamaismesaofrio.com/assets/images/espaco-cidadao/espaco-cidadao.png}\" alt=\"espaco cidadao\" />\n        </figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p>O Espaço de Cidadão de Mesão Frio, funciona das 09h30 às 12h30 e das 14h30 às 18h30, de Segunda a Sexta-Feira.</p>\n    </div>\n</div>\n<hr />\n<p><strong>Dispõe dos seguintes serviços:</strong></p>\n<ul><li>Adquirir livros e publicações da linha editorial da Autoridade para as Condições do Trabalho (ACT)</li><li>Agendar atendimento na Segurança Social</li><li>Agendar atendimento no Serviço de Estrangeiros e Fronteiras (SEF)</li><li>Alterar a morada do Cartão de Cidadão</li><li>Alterar dados pessoais na Segurança Social</li><li>Alterar os dados associados à Chave Móvel Digital</li><li>Alterar os dados de subscritor da Caixa Geral de Aposentações</li><li>Apresentar a declaração anual de rendas recebidas</li><li>Ativar a assinatura digital da Chave Móvel Digital (CMD)</li><li>Ativar a Chave Móvel Digital</li><li>Caderneta predial – certidão</li><li>Caderneta predial – certidão de teor matricial</li><li>Cancelar consulta médica</li><li>Cancelar o Cartão de Cidadão</li><li>Comunicar a contratação de trabalhador/a estrangeiro/a</li><li>Confirmar a alteração de morada do Cartão de Cidadão</li><li>Consultar, gerir e validar faturas no e-Fatura</li><li>Consultar a declaração e obter comprovativo do IRS</li><li>Consultar a lista de espera para cirurgia</li><li>Consultar as despesas com prestadores com acordo com a ADSE</li><li>Consultar a situação contributiva</li><li>Consultar Dívidas fiscais</li><li>Consultar e mudar de tarifário de eletricidade e gás natural através do Poupa Energia</li><li>Consultar o boletim de vacinas</li><li>Consultar o boletim infantil e juvenil</li><li>Consultar os descontos feitos anualmente e a utilização que já fez da ADSE</li><li>Consultar os limites de utilização da ADSE</li><li>Consultar os processos de cancelamento e/ou renovação online do Cartão de Cidadão</li><li>Criar e gerir conta na CGA Direta</li><li>Descarregar Testamento Vital</li><li>Divulgar, gerir e acompanhar ofertas de emprego no Instituto do Emprego e Formação Profissional (IEFP)</li><li>Emitir recibo eletrónico de quitação de rendas</li><li>Entregar os descontos à ADSE</li><li>Fazer prova de condição de recursos do agregado familiar à Caixa Geral de Aposentações (CGA)</li></ul>','{\"titleRaw\":{\"1\":\"Espaço Cidadão\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Espaço Cidadão - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(361,374,1,'Payshop','2024-03-11 11:14:44','2024-03-11 11:19:47','f0945b88-0488-4f3f-82ec-ad0906338b45',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a Payshop, a maior rede de pagamentos presenciais do País.</p>\n<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:375:url||https://junta.cooperativamaismesaofrio.com/assets/images/payshop/payshop.png}\" alt=\"payshop\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento e muito mais!</li></ul>\n<p><strong>Depressa e bem, a Payshop tem!</strong></p>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"Payshop\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(362,375,1,'Payshop','2024-03-11 11:16:22','2024-03-11 11:16:22','054e29b7-fdc7-489a-a337-611e9b25e0fb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(363,376,1,'Payshop','2024-03-11 11:17:20','2024-03-11 11:17:20','aaf27499-e3fd-4c81-a377-bbde97cdcadf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Pague tudo num só ponto!</p>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a Payshop, a maior rede de pagamentos presenciais do País.</p>\n<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:375:url||https://junta.cooperativamaismesaofrio.com/assets/images/payshop/payshop.png}\" alt=\"payshop\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<p>Faturas;<br />Carregamento de Telemóveis;<br />Títulos de Transporte;<br />Portagens;<br />Referências Multibanco;<br />Impostos;<br />Compras Online;<br />Paysafecard;<br />Vouchers Gaming, Entretenimento e muito mais!</p>\n<p><strong>Depressa e bem, a Payshop tem!</strong></p>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"Payshop\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(365,378,1,'Payshop','2024-03-11 11:18:55','2024-03-11 11:18:55','88378dda-4349-459c-980e-e644510cc429',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Pague tudo num só ponto!</p>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a Payshop, a maior rede de pagamentos presenciais do País.</p>\n<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:375:url||https://junta.cooperativamaismesaofrio.com/assets/images/payshop/payshop.png}\" alt=\"payshop\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento e muito mais!</li></ul>\n<p><strong>Depressa e bem, a Payshop tem!</strong></p>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"Payshop\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(366,379,1,'Payshop','2024-03-11 11:19:05','2024-03-11 11:19:05','b2d94eef-fbc4-4f95-b68b-1d9f0d8c89f4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a Payshop, a maior rede de pagamentos presenciais do País.</p>\n<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:375:url||https://junta.cooperativamaismesaofrio.com/assets/images/payshop/payshop.png}\" alt=\"payshop\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento e muito mais!</li></ul>\n<p><strong>Depressa e bem, a Payshop tem!</strong></p>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"Payshop\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(368,381,1,'Payshop','2024-03-11 11:19:47','2024-03-11 11:19:47','bfe9eaf2-2b42-4e24-8769-48119379e966',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a Payshop, a maior rede de pagamentos presenciais do País.</p>\n<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:375:url||https://junta.cooperativamaismesaofrio.com/assets/images/payshop/payshop.png}\" alt=\"payshop\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento e muito mais!</li></ul>\n<p><strong>Depressa e bem, a Payshop tem!</strong></p>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"Payshop\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"Payshop - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(369,382,1,'PAGAQUI','2024-03-11 11:20:23','2024-03-11 11:22:46','15aa7589-6467-4123-9d59-22a36e0b7997',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a PAGAQUI.</p>\n<div class=\"d-flex\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:383:url||https://junta.cooperativamaismesaofrio.com/assets/images/pagaqui/pagaqui.png}\" alt=\"\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento;</li><li>Comprar bilhetes de espetáculo;</li><li>Carregamento de títulos de transporte (nomeadamente Guimabus) e muito mais!</li></ul>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"PAGAQUI\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(370,383,1,'Pagaqui','2024-03-11 11:20:56','2024-03-11 11:20:56','86fc79bd-0475-43eb-b635-fb46cf6b1efd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(371,384,1,'PAGAQUI','2024-03-11 11:21:36','2024-03-11 11:21:36','6d88d161-8be4-4c58-a7f9-04a87d3e17fa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a PAGAQUI.</p>\n<figure><img src=\"{asset:383:url||https://junta.cooperativamaismesaofrio.com/assets/images/pagaqui/pagaqui.png}\" alt=\"\" /></figure>\n<p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento;</li><li>Comprar bilhetes de espetáculo;</li><li>Carregamento de títulos de transporte (nomeadamente Guimabus) e muito mais!</li></ul>','{\"titleRaw\":{\"1\":\"PAGAQUI\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,1,0),(373,386,1,'PAGAQUI','2024-03-11 11:21:42','2024-03-11 11:21:42','d9922aea-6b7d-44c6-af34-86a11423097b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a PAGAQUI.</p>\n<figure><img src=\"{asset:383:url||https://junta.cooperativamaismesaofrio.com/assets/images/pagaqui/pagaqui.png}\" alt=\"\" /></figure>\n<p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento;</li><li>Comprar bilhetes de espetáculo;</li><li>Carregamento de títulos de transporte (nomeadamente Guimabus) e muito mais!</li></ul>','{\"titleRaw\":{\"1\":\"PAGAQUI\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(375,388,1,'PAGAQUI','2024-03-11 11:22:37','2024-03-11 11:22:37','8bc7bd13-fc71-49f5-8d7a-9ac1639eb38c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a PAGAQUI.</p>\n<div class=\"d-flex align-center\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:383:url||https://junta.cooperativamaismesaofrio.com/assets/images/pagaqui/pagaqui.png}\" alt=\"\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento;</li><li>Comprar bilhetes de espetáculo;</li><li>Carregamento de títulos de transporte (nomeadamente Guimabus) e muito mais!</li></ul>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"PAGAQUI\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1),(376,389,1,'PAGAQUI','2024-03-11 11:22:46','2024-03-11 11:22:46','fcc50ba8-9a49-40ad-a608-d933b5b7172c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<h2>Pague tudo num só ponto!</h2>\n<p>Continuando a aposta na proximidade e comodidade dos nossos Fregueses, o executivo da Junta selou um acordo com a PAGAQUI.</p>\n<div class=\"d-flex\">\n    <div class=\"col-md-6\">\n        <figure><img src=\"{asset:383:url||https://junta.cooperativamaismesaofrio.com/assets/images/pagaqui/pagaqui.png}\" alt=\"\" /></figure>\n    </div>\n    <div class=\"col-md-6\">\n        <p><strong>Pague Com Payshop:</strong></p>\n<ul><li>Faturas;</li><li>Carregamento de Telemóveis;</li><li>Títulos de Transporte;</li><li>Portagens;</li><li>Referências Multibanco;</li><li>Impostos;</li><li>Compras Online;</li><li>Paysafecard;</li><li>Vouchers Gaming, Entretenimento;</li><li>Comprar bilhetes de espetáculo;</li><li>Carregamento de títulos de transporte (nomeadamente Guimabus) e muito mais!</li></ul>\n    </div>\n</div>','{\"titleRaw\":{\"1\":\"PAGAQUI\",\"2\":\" - Junta Mesão Frio\"},\"descriptionRaw\":\"\",\"keywords\":[],\"score\":\"\",\"social\":{\"twitter\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"},\"facebook\":{\"handle\":\"\",\"title\":\"PAGAQUI - Junta Mesão Frio\",\"imageId\":\"\",\"description\":\"\"}},\"advanced\":{\"robots\":[],\"canonical\":\"\"}}',NULL,NULL,NULL,NULL,NULL,0,1);
/*!40000 ALTER TABLE `content` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `craftidtokens`
--

LOCK TABLES `craftidtokens` WRITE;
/*!40000 ALTER TABLE `craftidtokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `craftidtokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `deprecationerrors`
--

LOCK TABLES `deprecationerrors` WRITE;
/*!40000 ALTER TABLE `deprecationerrors` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `deprecationerrors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `drafts`
--

LOCK TABLES `drafts` WRITE;
/*!40000 ALTER TABLE `drafts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `drafts` VALUES (20,90,1,1,'Rascunho 1','',1,NULL,1);
/*!40000 ALTER TABLE `drafts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elementactivity`
--

LOCK TABLES `elementactivity` WRITE;
/*!40000 ALTER TABLE `elementactivity` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elementactivity` VALUES (14,1,1,NULL,'edit','2024-03-04 11:15:47'),(14,1,1,NULL,'save','2024-03-04 11:15:49'),(21,1,1,NULL,'save','2024-02-20 17:51:37'),(32,1,1,NULL,'save','2024-03-05 16:52:29'),(48,1,1,NULL,'save','2024-02-22 17:54:34'),(49,1,1,NULL,'edit','2024-02-27 18:01:13'),(49,1,1,NULL,'save','2024-02-27 18:01:13'),(51,1,1,NULL,'save','2024-02-22 18:06:33'),(52,1,1,NULL,'save','2024-02-22 18:06:41'),(53,1,1,NULL,'save','2024-02-22 18:06:50'),(54,1,1,NULL,'save','2024-02-22 18:07:01'),(81,1,1,NULL,'edit','2024-03-05 17:23:48'),(81,1,1,NULL,'save','2024-03-05 17:23:48'),(90,1,1,NULL,'edit','2024-03-01 11:22:34'),(90,1,1,NULL,'save','2024-03-01 11:22:06'),(103,1,1,NULL,'edit','2024-03-01 14:32:45'),(103,1,1,NULL,'save','2024-03-01 14:32:47'),(109,1,1,NULL,'edit','2024-03-01 14:33:53'),(109,1,1,NULL,'save','2024-03-01 14:33:54'),(119,1,1,NULL,'edit','2024-03-08 15:48:35'),(119,1,1,NULL,'save','2024-03-08 15:48:36'),(127,1,1,NULL,'edit','2024-03-01 17:18:29'),(127,1,1,NULL,'save','2024-03-01 17:18:30'),(141,1,1,NULL,'edit','2024-03-05 17:26:22'),(141,1,1,NULL,'save','2024-03-05 17:26:23'),(147,1,1,NULL,'edit','2024-03-04 10:58:56'),(147,1,1,NULL,'save','2024-03-04 10:58:57'),(153,1,1,NULL,'edit','2024-03-04 10:59:04'),(153,1,1,NULL,'save','2024-03-04 10:59:05'),(155,1,1,NULL,'edit','2024-03-04 10:59:13'),(155,1,1,NULL,'save','2024-03-04 10:59:15'),(157,1,1,NULL,'edit','2024-03-04 10:59:24'),(157,1,1,NULL,'save','2024-03-04 10:59:25'),(169,1,1,NULL,'edit','2024-03-05 17:26:15'),(169,1,1,NULL,'save','2024-03-05 17:27:06'),(179,1,1,NULL,'save','2024-03-04 11:26:40'),(183,1,1,NULL,'save','2024-03-05 14:28:56'),(185,1,1,NULL,'save','2024-03-05 14:29:25'),(187,1,1,NULL,'edit','2024-03-05 17:19:34'),(187,1,1,NULL,'save','2024-03-05 17:19:36'),(197,1,1,NULL,'edit','2024-03-05 17:21:40'),(197,1,1,NULL,'save','2024-03-05 17:21:41'),(210,1,1,NULL,'edit','2024-03-05 15:01:36'),(210,1,1,NULL,'save','2024-03-05 15:01:38'),(216,1,1,NULL,'edit','2024-03-05 15:01:53'),(216,1,1,NULL,'save','2024-03-05 15:01:58'),(220,1,1,NULL,'edit','2024-03-05 15:59:59'),(220,1,1,NULL,'save','2024-03-05 16:00:08'),(222,1,1,NULL,'edit','2024-03-05 15:59:16'),(222,1,1,NULL,'save','2024-03-05 15:59:17'),(228,1,1,NULL,'edit','2024-03-05 17:18:20'),(228,1,1,NULL,'save','2024-03-05 17:18:20'),(234,1,1,NULL,'edit','2024-03-05 17:15:03'),(234,1,1,NULL,'save','2024-03-05 17:15:06'),(244,1,1,NULL,'save','2024-03-05 16:53:37'),(246,1,1,NULL,'edit','2024-03-05 16:54:26'),(246,1,1,NULL,'save','2024-03-05 16:54:28'),(250,1,1,NULL,'save','2024-03-05 16:54:36'),(283,1,1,NULL,'edit','2024-03-08 15:52:48'),(283,1,1,NULL,'save','2024-03-08 15:52:49'),(288,1,1,NULL,'edit','2024-03-08 16:04:45'),(288,1,1,NULL,'save','2024-03-08 16:04:45'),(296,1,1,NULL,'edit','2024-03-08 16:14:05'),(296,1,1,NULL,'save','2024-03-08 16:14:12'),(305,1,1,NULL,'edit','2024-03-08 16:18:36'),(305,1,1,NULL,'save','2024-03-08 16:18:37'),(311,1,1,NULL,'edit','2024-03-08 16:49:18'),(311,1,1,NULL,'save','2024-03-08 16:51:12'),(317,1,1,NULL,'save','2024-03-08 17:02:57'),(319,1,1,NULL,'edit','2024-03-08 17:10:23'),(319,1,1,NULL,'save','2024-03-08 17:10:25'),(323,1,1,NULL,'edit','2024-03-08 17:19:22'),(323,1,1,NULL,'save','2024-03-08 17:19:23'),(326,1,1,NULL,'edit','2024-03-08 17:20:42'),(326,1,1,NULL,'save','2024-03-08 17:20:43'),(329,1,1,NULL,'edit','2024-03-08 17:20:34'),(329,1,1,NULL,'save','2024-03-08 17:20:34'),(333,1,1,NULL,'edit','2024-03-08 17:21:18'),(333,1,1,NULL,'save','2024-03-08 17:21:19'),(336,1,1,NULL,'edit','2024-03-08 17:21:47'),(336,1,1,NULL,'save','2024-03-08 17:21:47'),(339,1,1,NULL,'edit','2024-03-08 17:29:54'),(339,1,1,NULL,'save','2024-03-08 17:35:32'),(342,1,1,NULL,'save','2024-03-08 17:34:10'),(344,1,1,NULL,'edit','2024-03-08 17:34:42'),(344,1,1,NULL,'save','2024-03-08 17:34:42'),(347,1,1,NULL,'edit','2024-03-08 17:35:11'),(347,1,1,NULL,'save','2024-03-08 17:35:13'),(351,1,1,NULL,'save','2024-03-08 17:36:00'),(353,1,1,NULL,'edit','2024-03-08 17:53:53'),(353,1,1,NULL,'save','2024-03-08 17:57:00'),(364,1,1,NULL,'edit','2024-03-11 11:00:44'),(364,1,1,NULL,'save','2024-03-11 11:00:47'),(368,1,1,NULL,'edit','2024-03-11 11:10:55'),(368,1,1,NULL,'save','2024-03-11 11:11:42'),(374,1,1,NULL,'edit','2024-03-11 11:19:44'),(374,1,1,NULL,'save','2024-03-11 11:19:47'),(382,1,1,NULL,'edit','2024-03-11 11:22:35'),(382,1,1,NULL,'save','2024-03-11 11:22:46');
/*!40000 ALTER TABLE `elementactivity` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements`
--

LOCK TABLES `elements` WRITE;
/*!40000 ALTER TABLE `elements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements` VALUES (1,NULL,NULL,NULL,NULL,'craft\\elements\\User',1,0,'2024-02-16 17:40:41','2024-02-16 17:40:41',NULL,NULL,'b7d803d1-cf68-4e54-9e03-7d3fc7334017'),(2,NULL,NULL,NULL,4,'craft\\elements\\GlobalSet',1,0,'2024-02-19 12:20:57','2024-02-20 17:51:38',NULL,NULL,'3e1119c5-f94f-4154-a4fb-afb43b303105'),(3,NULL,NULL,NULL,9,'craft\\elements\\GlobalSet',1,0,'2024-02-19 12:21:07','2024-03-08 18:01:41',NULL,NULL,'aa58149c-af35-410e-b08d-bfc93a6e8d9f'),(4,NULL,NULL,NULL,2,'craft\\elements\\GlobalSet',1,0,'2024-02-19 12:45:53','2024-03-01 11:04:45',NULL,NULL,'b1e8401f-82c3-4599-ae64-0034608bd86b'),(5,NULL,NULL,NULL,3,'craft\\elements\\GlobalSet',1,0,'2024-02-19 12:53:21','2024-02-22 15:29:00',NULL,NULL,'b148a766-6998-48cc-8d1e-45790c4cf220'),(10,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-19 14:11:23','2024-02-19 14:11:23',NULL,NULL,'8e3e76ae-3012-41ae-844d-79f54e562485'),(11,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-19 14:11:31','2024-02-19 14:11:31',NULL,NULL,'d17eae91-c787-4e29-af31-5fd67993f659'),(12,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-19 14:12:12','2024-02-19 14:12:12',NULL,'2024-02-19 14:13:15','3be9e25f-91c7-4b58-995d-2d1f11e11e42'),(13,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-19 14:13:29','2024-02-19 14:13:29',NULL,NULL,'610ccf30-3762-4f56-80e5-e32e0bf1d351'),(14,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2024-02-20 17:13:27','2024-03-05 17:25:27',NULL,NULL,'f30b73e6-ef8d-41c5-9a8c-0dba1daedd12'),(15,14,NULL,1,5,'craft\\elements\\Entry',1,0,'2024-02-20 17:13:27','2024-02-20 17:13:27',NULL,NULL,'d771a7b3-911e-435e-8d7a-7d7197fb7951'),(16,14,NULL,2,5,'craft\\elements\\Entry',1,0,'2024-02-20 17:13:27','2024-02-20 17:13:27',NULL,NULL,'4cebd73f-7778-496a-8c9b-55f935663f01'),(17,14,NULL,3,5,'craft\\elements\\Entry',1,0,'2024-02-20 17:13:53','2024-02-20 17:13:53',NULL,NULL,'ee27ee0d-a204-4e13-a5c2-6cae1bd57e6c'),(19,14,NULL,4,5,'craft\\elements\\Entry',1,0,'2024-02-20 17:14:19','2024-02-20 17:14:19',NULL,NULL,'d5f635b1-1d07-4167-ac56-049e76383273'),(20,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-20 17:19:07','2024-02-20 17:19:07',NULL,NULL,'34ed694d-73fe-4ad3-8e93-9c5a7e0ed879'),(21,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-20 17:51:21','2024-02-20 17:51:37',NULL,NULL,'dc6e1fb2-7b56-4df3-94bf-39aa93dfed0b'),(22,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 12:54:46','2024-02-22 12:54:46',NULL,NULL,'c0637100-d28b-4b47-bf0a-980c2489c16a'),(23,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 12:54:47','2024-02-22 12:54:47',NULL,NULL,'c9e4d8a6-0e15-4519-9782-7809133fcc92'),(24,NULL,NULL,NULL,6,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:18:20','2024-02-22 14:22:29',NULL,NULL,'867e89ea-43af-4ed6-bd42-0980df512b87'),(25,NULL,NULL,NULL,6,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:18:50','2024-02-22 14:22:29',NULL,NULL,'ce823613-ded6-4237-8af2-6bf34fbc6b58'),(26,NULL,NULL,NULL,6,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:18:50','2024-02-22 14:22:29',NULL,NULL,'07b2caf3-a4e0-46a4-bcf3-5ba9a5c4a980'),(27,NULL,NULL,NULL,6,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:18:50','2024-02-22 14:22:29',NULL,NULL,'ac967852-d085-4e63-b578-a78a0162ff75'),(28,NULL,NULL,NULL,7,'craft\\elements\\GlobalSet',1,0,'2024-02-22 14:24:58','2024-02-22 15:29:00',NULL,NULL,'d0c2a04c-3370-4bcb-84db-47ce81ab6643'),(29,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 14:28:01','2024-02-22 14:28:01',NULL,NULL,'89fc3bad-c0ea-492c-b313-45314f494832'),(30,NULL,NULL,NULL,8,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:28:09','2024-02-22 14:28:09',NULL,NULL,'c13fccf7-0cee-4e15-a698-f71f0a2b2220'),(31,NULL,NULL,NULL,10,'craft\\elements\\GlobalSet',1,0,'2024-02-22 14:54:20','2024-02-22 15:29:00',NULL,NULL,'2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c'),(32,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 14:57:55','2024-03-05 16:52:29',NULL,NULL,'c061b4c5-b9f9-4be2-9afd-f7f9ef0222c0'),(33,NULL,NULL,NULL,11,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:57:56','2024-02-22 14:58:54',NULL,NULL,'0856433a-e4d9-4572-86b2-230b878ec5ae'),(34,NULL,NULL,NULL,11,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:58:54','2024-02-22 14:58:54',NULL,NULL,'ae4a818b-cb99-44e6-a82d-33eb38d8456c'),(35,NULL,NULL,NULL,11,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:58:54','2024-02-22 14:58:54',NULL,NULL,'997aba8f-27aa-4972-8217-41089d460cc2'),(36,NULL,NULL,NULL,11,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:58:54','2024-02-22 14:58:54',NULL,NULL,'c78acfc3-05f1-4591-914b-58b17c98675b'),(37,NULL,NULL,NULL,11,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:58:54','2024-02-22 14:58:54',NULL,NULL,'1153157c-2141-4b8d-83a9-00e3a10d4790'),(38,NULL,NULL,NULL,11,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 14:58:54','2024-02-22 14:58:54',NULL,NULL,'f1998782-db49-4f83-a310-0fdaeb2e89c1'),(39,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 15:05:27','2024-02-22 15:05:27',NULL,NULL,'9cce67db-bdf5-4f7c-b061-701e60617389'),(40,NULL,NULL,NULL,12,'craft\\elements\\GlobalSet',1,0,'2024-02-22 15:29:15','2024-02-22 17:49:39',NULL,NULL,'1f1e8428-3ee2-4875-a0e1-4867fbe7dfee'),(41,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 17:41:41','2024-02-22 17:41:41',NULL,NULL,'65d421dc-6818-4a9d-9a95-bbd54760299c'),(42,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 17:42:30','2024-02-22 17:42:30',NULL,NULL,'192070bd-8e5e-4f78-8935-4ff8662ed619'),(43,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 17:43:03','2024-02-22 17:43:03',NULL,NULL,'b6892f33-5a90-40c5-a259-c7b76cde73f6'),(44,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 17:43:08','2024-02-22 17:43:08',NULL,NULL,'5055ae93-10c4-4332-a52d-2d74ed26bd54'),(45,NULL,NULL,NULL,13,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 17:43:11','2024-02-22 17:49:39',NULL,NULL,'4371158b-b1dd-4a47-a998-c46678cfdf6b'),(46,NULL,NULL,NULL,13,'craft\\elements\\MatrixBlock',1,0,'2024-02-22 17:43:11','2024-02-22 17:49:40',NULL,NULL,'1264c11c-1d7c-4362-a7ee-c6969d0c54fb'),(47,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 17:49:38','2024-02-22 17:49:38',NULL,NULL,'ae959b00-edbc-44c9-b068-d432994ce4dd'),(48,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 17:54:19','2024-02-22 17:54:34',NULL,NULL,'0fe33e60-da20-45fe-b2c9-718f347e0a8e'),(49,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2024-02-22 18:00:36','2024-02-27 18:01:13',NULL,NULL,'b045fad7-40b9-40fb-8637-d38a8daa7a0e'),(50,49,NULL,5,14,'craft\\elements\\Entry',1,0,'2024-02-22 18:00:41','2024-02-22 18:00:41',NULL,NULL,'8fd99f93-da63-43d7-9429-277b878f1b9a'),(51,NULL,NULL,NULL,16,'craft\\elements\\Category',1,0,'2024-02-22 18:06:25','2024-02-22 18:06:33',NULL,NULL,'7a62e779-6bdc-4d33-ab16-a03a26bf507c'),(52,NULL,NULL,NULL,16,'craft\\elements\\Category',1,0,'2024-02-22 18:06:37','2024-02-22 18:06:41',NULL,NULL,'07c8a0d0-5077-42fc-bedf-e00140ec3998'),(53,NULL,NULL,NULL,16,'craft\\elements\\Category',1,0,'2024-02-22 18:06:47','2024-02-22 18:06:50',NULL,NULL,'e6b49a8a-f63d-454e-ae10-b27dbd388233'),(54,NULL,NULL,NULL,16,'craft\\elements\\Category',1,0,'2024-02-22 18:06:58','2024-02-22 18:07:01',NULL,NULL,'320f6a26-c74a-4efb-90f4-9e2935fa52c4'),(55,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 18:08:02','2024-02-22 18:08:02',NULL,NULL,'b5822459-d5a7-4120-97f8-223c7fb7a231'),(57,NULL,NULL,NULL,15,'craft\\elements\\Tag',1,0,'2024-02-22 18:08:13','2024-02-22 18:08:13',NULL,NULL,'b04dfaad-0db2-4e1f-b7e7-bddf00b014e2'),(58,NULL,NULL,NULL,15,'craft\\elements\\Tag',1,0,'2024-02-22 18:08:48','2024-02-22 18:08:48',NULL,NULL,'e1292110-b1c0-42cb-84a8-73d9245e59d4'),(59,49,NULL,6,14,'craft\\elements\\Entry',1,0,'2024-02-22 18:08:49','2024-02-22 18:08:49',NULL,NULL,'8bd8dd21-6413-4626-9b07-cc8a2432575c'),(61,49,NULL,7,14,'craft\\elements\\Entry',1,0,'2024-02-22 18:08:58','2024-02-22 18:08:58',NULL,NULL,'439248bb-f080-4960-a152-223d88fe86e9'),(62,49,NULL,8,14,'craft\\elements\\Entry',1,0,'2024-02-22 18:10:24','2024-02-22 18:10:24',NULL,NULL,'4ab46bef-b677-4194-be3a-878d59cce0fe'),(64,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-02-22 18:11:03','2024-02-22 18:11:03',NULL,NULL,'1ba29d77-2736-47df-9ea4-41af378707ba'),(65,49,NULL,9,14,'craft\\elements\\Entry',1,0,'2024-02-22 18:11:26','2024-02-22 18:11:26',NULL,NULL,'49ef04f0-33ff-49e9-b9d5-e09206086e9e'),(66,14,NULL,10,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:19:23','2024-02-26 16:19:24',NULL,NULL,'9fecf7d3-5770-4e6c-bd73-1889fe4cf60e'),(67,14,NULL,11,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:19:59','2024-02-26 16:19:59',NULL,NULL,'3292dbb9-a8de-421f-896b-3dacde189d6a'),(69,14,NULL,12,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:20:11','2024-02-26 16:20:11',NULL,NULL,'3220a7a0-7ccf-46d5-82ca-b72c23c0ca64'),(70,14,NULL,13,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:20:25','2024-02-26 16:20:25',NULL,NULL,'7d1d8bd6-3ba7-49c2-a2c6-ed685ee27162'),(71,14,NULL,14,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:21:09','2024-02-26 16:21:09',NULL,NULL,'3fdd77b8-3b93-46cc-a0f7-250680738235'),(73,14,NULL,15,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:21:27','2024-02-26 16:21:28',NULL,NULL,'b311fc68-887c-4688-bc51-a5961e3ac989'),(74,14,NULL,16,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:22:10','2024-02-26 16:22:10',NULL,NULL,'d64420b3-6572-4b49-a3fa-5e2b9f34f9c4'),(76,14,NULL,17,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:23:46','2024-02-26 16:23:46',NULL,NULL,'a6662d3a-7e79-4eb7-a035-674d0e3ed09c'),(77,14,NULL,18,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:27:02','2024-02-26 16:27:02',NULL,NULL,'0c8fbd70-224d-4544-bf03-766eaca211c3'),(79,14,NULL,19,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:27:16','2024-02-26 16:27:16',NULL,NULL,'f916192c-ddeb-4ef6-b3ed-713ad4edad84'),(80,14,NULL,20,5,'craft\\elements\\Entry',1,0,'2024-02-26 16:27:56','2024-02-26 16:27:56',NULL,NULL,'b5d9d426-c357-461f-b520-433e5b495ff5'),(81,NULL,NULL,NULL,17,'craft\\elements\\Entry',1,0,'2024-02-27 17:20:13','2024-03-05 17:23:48',NULL,NULL,'040e8f47-a963-440c-953a-b61d38ecc011'),(82,81,NULL,21,17,'craft\\elements\\Entry',1,0,'2024-02-27 17:20:13','2024-02-27 17:20:13',NULL,NULL,'af2314a9-6d7b-43f6-8244-366bf7866c0b'),(83,81,NULL,22,17,'craft\\elements\\Entry',1,0,'2024-02-27 17:20:14','2024-02-27 17:20:14',NULL,NULL,'3139e2c4-6f08-49b7-85c6-e003e16a9503'),(84,81,NULL,23,17,'craft\\elements\\Entry',1,0,'2024-02-27 17:20:29','2024-02-27 17:20:29',NULL,NULL,'02694384-9102-4b06-9255-606c240db82a'),(86,81,NULL,24,17,'craft\\elements\\Entry',1,0,'2024-02-27 17:23:16','2024-02-27 17:23:16',NULL,NULL,'821cd513-1500-42b9-94ae-f8db53b75aeb'),(87,81,NULL,25,17,'craft\\elements\\Entry',1,0,'2024-02-27 17:23:22','2024-02-27 17:23:22',NULL,NULL,'01fe232c-b610-45dd-8874-9557e5710306'),(89,81,NULL,26,17,'craft\\elements\\Entry',1,0,'2024-02-27 17:23:43','2024-02-27 17:23:43',NULL,NULL,'3e47045f-78bf-4b0d-b0c4-6ce1e9b81640'),(90,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2024-02-27 17:58:30','2024-03-01 11:22:05',NULL,NULL,'1fbb7180-eb0d-48a7-b321-38e0f58cc865'),(91,90,NULL,27,14,'craft\\elements\\Entry',1,0,'2024-02-27 17:58:30','2024-02-27 17:58:30',NULL,NULL,'523c179c-85c2-406b-9a5c-2ca5070f8113'),(93,90,NULL,28,14,'craft\\elements\\Entry',1,0,'2024-02-27 17:58:53','2024-02-27 17:58:53',NULL,NULL,'5cd7cc8d-38af-4a9a-a77b-6e49d140efb0'),(94,90,NULL,29,14,'craft\\elements\\Entry',1,0,'2024-02-27 17:59:06','2024-02-27 17:59:06',NULL,NULL,'0f10f2b3-3173-4e39-b2a6-c56e475edcf2'),(96,49,NULL,30,14,'craft\\elements\\Entry',1,0,'2024-02-27 18:01:13','2024-02-27 18:01:13',NULL,NULL,'1061a8ed-6b75-42d0-b11a-83df95cfbe85'),(98,90,NULL,31,14,'craft\\elements\\Entry',1,0,'2024-02-27 18:01:18','2024-02-27 18:01:18',NULL,NULL,'dcde0148-b76f-46a2-8f5e-18480297df21'),(99,81,NULL,32,17,'craft\\elements\\Entry',1,0,'2024-03-01 11:05:07','2024-03-01 11:05:07',NULL,NULL,'59b60afb-a260-4ebd-9b23-e426796ab013'),(101,90,NULL,33,14,'craft\\elements\\Entry',1,0,'2024-03-01 11:22:05','2024-03-01 11:22:05',NULL,NULL,'1df3215e-8fc0-41eb-8942-7e2586f2266a'),(102,90,20,NULL,14,'craft\\elements\\Entry',1,0,'2024-03-01 11:22:34','2024-03-01 11:22:34',NULL,NULL,'c4288f0c-4e9f-4241-891c-6efd2d7e029e'),(103,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:31:51','2024-03-01 14:32:47',NULL,NULL,'f6888416-0872-4b18-b22d-81818699aed5'),(104,103,NULL,34,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:31:51','2024-03-01 14:31:52',NULL,NULL,'57a6ad55-ce0e-4eca-8b56-7478fdae2bc4'),(106,103,NULL,35,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:32:01','2024-03-01 14:32:01',NULL,NULL,'40dd0427-bae1-4dec-92d6-81940b1b7b68'),(108,103,NULL,36,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:32:21','2024-03-01 14:32:21',NULL,NULL,'7157b392-8593-4688-9534-159c9008d59d'),(109,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:32:28','2024-03-01 14:33:53',NULL,NULL,'e8204e6d-18d7-4bb7-acbd-0fd53c6cea30'),(110,109,NULL,37,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:32:28','2024-03-01 14:32:28',NULL,NULL,'b5f3b5e2-845b-4c7b-9f27-ae5f9f206f12'),(112,109,NULL,38,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:32:39','2024-03-01 14:32:39',NULL,NULL,'ae748d53-111b-4a40-95cd-6a9f6bed96c1'),(114,103,NULL,39,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:32:47','2024-03-01 14:32:47',NULL,NULL,'6307a642-38e8-4094-8bc9-c7c2a8d66198'),(116,109,NULL,40,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:32:54','2024-03-01 14:32:54',NULL,NULL,'908cd46a-9664-4a79-ab84-3c81e6c9e081'),(118,109,NULL,41,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:33:10','2024-03-01 14:33:11',NULL,NULL,'54edd8e3-23fa-485d-977c-d46bb06df34f'),(119,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:33:20','2024-03-08 15:48:36',NULL,NULL,'23b5dc5c-07de-4155-93f0-dc29ab6b4b15'),(120,119,NULL,42,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:33:20','2024-03-01 14:33:20',NULL,NULL,'53f3ef44-f065-4374-8ea2-1ec11adf17fe'),(122,119,NULL,43,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:33:30','2024-03-01 14:33:30',NULL,NULL,'b8f59e7e-175f-449e-9430-861e9cadad13'),(124,109,NULL,44,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:33:53','2024-03-01 14:33:54',NULL,NULL,'f3728900-ce53-48d9-9c77-d1ba2d7abab1'),(126,119,NULL,45,14,'craft\\elements\\Entry',1,0,'2024-03-01 14:34:35','2024-03-01 14:34:35',NULL,NULL,'885c7e63-041e-4e73-95a5-54be1f20f157'),(127,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2024-03-01 16:43:14','2024-03-01 17:18:30',NULL,NULL,'a64222cd-81a9-46a0-9d20-09e68a423e15'),(128,127,NULL,46,18,'craft\\elements\\Entry',1,0,'2024-03-01 16:45:09','2024-03-01 16:45:09',NULL,NULL,'c4fbfcf3-483e-4f5c-878b-c64b9c9dde47'),(129,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-01 16:45:41','2024-03-01 16:45:41',NULL,NULL,'7e5cc7e1-c325-4c4c-a85b-1b982c6d84b3'),(131,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-01 16:46:20','2024-03-01 16:46:20',NULL,NULL,'592f3542-7f44-4be2-972b-d5de82b3c499'),(132,127,NULL,47,18,'craft\\elements\\Entry',1,0,'2024-03-01 16:46:45','2024-03-01 16:46:45',NULL,NULL,'2a9b554b-dbb1-471f-a784-86525877f4ce'),(133,127,NULL,48,18,'craft\\elements\\Entry',1,0,'2024-03-01 16:47:22','2024-03-01 16:47:22',NULL,NULL,'2891a49c-e0b7-439d-bad5-0d0bd5606a15'),(135,127,NULL,49,18,'craft\\elements\\Entry',1,0,'2024-03-01 17:04:54','2024-03-01 17:04:54',NULL,NULL,'7313dd21-1455-4670-a73b-dff4c32c208d'),(137,127,NULL,50,18,'craft\\elements\\Entry',1,0,'2024-03-01 17:05:05','2024-03-01 17:05:05',NULL,NULL,'b0d65155-0a86-48ae-a6d0-814fed44dc40'),(138,127,NULL,51,18,'craft\\elements\\Entry',1,0,'2024-03-01 17:12:48','2024-03-01 17:12:48',NULL,NULL,'cb0f610d-965c-4cec-a3e7-097ac8d3f1be'),(140,127,NULL,52,18,'craft\\elements\\Entry',1,0,'2024-03-01 17:18:30','2024-03-01 17:18:30',NULL,NULL,'f0bd9fe0-8b42-4a8b-b663-54a112e5a0d6'),(141,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2024-03-01 17:36:55','2024-03-05 17:26:23',NULL,NULL,'e4ec90cd-90d2-4ae7-8e4f-7546f80eaf07'),(142,141,NULL,53,19,'craft\\elements\\Entry',1,0,'2024-03-01 17:36:55','2024-03-01 17:36:55',NULL,NULL,'d0c56576-cd31-4c7b-941f-eaa00e3d1e16'),(143,141,NULL,54,19,'craft\\elements\\Entry',1,0,'2024-03-01 17:36:55','2024-03-01 17:36:55',NULL,NULL,'5a1731ba-9ca0-4851-98b2-bd9bc94602f5'),(144,141,NULL,55,19,'craft\\elements\\Entry',1,0,'2024-03-01 17:37:16','2024-03-01 17:37:16',NULL,NULL,'210a674e-51f8-4262-95b7-908e1aa822b9'),(145,141,NULL,56,19,'craft\\elements\\Entry',1,0,'2024-03-01 17:37:28','2024-03-01 17:37:28',NULL,NULL,'c4b07660-4134-4bc0-90d6-6bc8ece44bc9'),(146,141,NULL,57,19,'craft\\elements\\Entry',1,0,'2024-03-01 17:37:44','2024-03-01 17:37:44',NULL,NULL,'5ce0685a-86f8-439c-89f0-1cfc7477d75d'),(147,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2024-03-01 17:45:57','2024-03-04 10:58:57',NULL,NULL,'639c2524-ce6b-4f10-ae78-64f5963009ae'),(148,147,NULL,58,18,'craft\\elements\\Entry',1,0,'2024-03-01 17:45:57','2024-03-01 17:45:57',NULL,NULL,'b055dd65-ab6f-4d2f-a4b0-c3679d58179d'),(150,147,NULL,59,18,'craft\\elements\\Entry',1,0,'2024-03-01 17:46:15','2024-03-01 17:46:16',NULL,NULL,'a7c07f38-bc07-457d-ac8c-a3b379dbd02f'),(152,147,NULL,60,18,'craft\\elements\\Entry',1,0,'2024-03-01 18:00:06','2024-03-01 18:00:06',NULL,NULL,'510817fe-4354-4c93-b288-08d0da480b35'),(153,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2024-03-01 18:00:22','2024-03-04 10:59:05',NULL,NULL,'6798f412-8743-4d8f-9cd5-f0ca1ed10f81'),(154,153,NULL,61,18,'craft\\elements\\Entry',1,0,'2024-03-01 18:00:22','2024-03-01 18:00:22',NULL,NULL,'caebc92d-1396-4166-9d2f-1fd647171a9e'),(155,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2024-03-01 18:00:27','2024-03-04 10:59:15',NULL,NULL,'a47cb337-ad4c-4646-ab10-9861eeaea5d9'),(156,155,NULL,62,18,'craft\\elements\\Entry',1,0,'2024-03-01 18:00:27','2024-03-01 18:00:27',NULL,NULL,'e6af1998-b553-4c5f-9d5a-9b939e318afc'),(157,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2024-03-01 18:00:27','2024-03-04 10:59:24',NULL,NULL,'d30f4974-8f0d-45c0-9dd8-4b25ed5fd031'),(158,157,NULL,63,18,'craft\\elements\\Entry',1,0,'2024-03-01 18:00:27','2024-03-01 18:00:27',NULL,NULL,'de460d98-0036-42a2-9242-23233cdd191c'),(160,147,NULL,64,18,'craft\\elements\\Entry',1,0,'2024-03-04 10:58:57','2024-03-04 10:58:57',NULL,NULL,'fb4f713c-fad4-481f-a2c4-e7ace593842c'),(162,153,NULL,65,18,'craft\\elements\\Entry',1,0,'2024-03-04 10:59:05','2024-03-04 10:59:05',NULL,NULL,'bb5aba63-f233-4aa9-b218-d78dcb0a57d0'),(164,155,NULL,66,18,'craft\\elements\\Entry',1,0,'2024-03-04 10:59:15','2024-03-04 10:59:15',NULL,NULL,'e2217415-060c-4e8e-b5af-ff1528944251'),(166,157,NULL,67,18,'craft\\elements\\Entry',1,0,'2024-03-04 10:59:24','2024-03-04 10:59:24',NULL,NULL,'77616817-04df-490e-b58c-4c1c08ca0f7b'),(168,14,NULL,68,5,'craft\\elements\\Entry',1,0,'2024-03-04 11:15:48','2024-03-04 11:15:48',NULL,NULL,'5085c7c0-552c-439a-9c4a-0a32c4c16ff9'),(169,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:21:56','2024-03-05 17:27:05',NULL,NULL,'547a2271-4410-4d01-99bf-2e2748a47d50'),(170,169,NULL,69,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:21:56','2024-03-04 11:21:56',NULL,NULL,'c324de8a-81a6-413e-ac3d-c619669b3e53'),(171,169,NULL,70,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:21:56','2024-03-04 11:21:56',NULL,NULL,'adb20542-19b2-4631-b953-68ffcd3b5728'),(172,169,NULL,71,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:22:11','2024-03-04 11:22:11',NULL,NULL,'6ed3f7c1-def4-4557-a4e7-7f49f1c8e912'),(173,169,NULL,72,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:23:07','2024-03-04 11:23:07',NULL,NULL,'2d3ad376-5702-4edf-8be3-1fb678bd7f3b'),(174,169,NULL,73,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:24:53','2024-03-04 11:24:53',NULL,NULL,'df216805-677a-4ca4-9652-f6aada0967e6'),(176,169,NULL,74,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:25:22','2024-03-04 11:25:22',NULL,NULL,'0ffeb4d0-8a53-4664-b5f8-6f8bc09e8843'),(177,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-04 11:25:45','2024-03-04 11:25:45',NULL,NULL,'8d4685ab-073c-4637-8642-e804486a8c7c'),(179,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-04 11:26:07','2024-03-04 11:26:40',NULL,NULL,'c6f6d39a-f4fb-405f-bee9-3629f0ad0cbb'),(180,169,NULL,75,20,'craft\\elements\\Entry',1,0,'2024-03-04 11:26:12','2024-03-04 11:26:12',NULL,NULL,'9347fd20-0ece-41ae-898c-0797a5431981'),(182,169,NULL,76,20,'craft\\elements\\Entry',1,0,'2024-03-05 14:28:16','2024-03-05 14:28:16',NULL,NULL,'6bd31227-ea10-417b-86a8-c3d96b2d379d'),(183,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 14:28:41','2024-03-05 14:28:56',NULL,NULL,'1f8309a0-6e60-40b4-bd59-d0f114721b31'),(185,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 14:29:15','2024-03-05 14:29:25',NULL,NULL,'f3435d84-1c14-47c8-81f1-b2d47d382694'),(186,169,NULL,77,20,'craft\\elements\\Entry',1,0,'2024-03-05 14:29:27','2024-03-05 14:29:27',NULL,NULL,'0b15ad95-7ee5-47ae-9325-ff177889af11'),(187,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2024-03-05 14:47:55','2024-03-05 17:19:36',NULL,NULL,'10e83fba-2179-4418-889f-c6b78a68aa04'),(188,187,NULL,78,21,'craft\\elements\\Entry',1,0,'2024-03-05 14:48:07','2024-03-05 14:48:07',NULL,NULL,'27939b64-e7db-48b2-b381-e46f1c8ff943'),(190,187,NULL,79,21,'craft\\elements\\Entry',1,0,'2024-03-05 14:48:25','2024-03-05 14:48:25',NULL,NULL,'3085468d-8fae-4726-8d8c-9fe81e29a6a3'),(191,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 14:49:54','2024-03-05 14:49:54',NULL,NULL,'40c1eb86-4ba6-4808-9c97-10d126af610d'),(192,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 14:49:56','2024-03-05 14:49:56',NULL,NULL,'efafff3f-8b8d-4944-b866-6b5dcbd944d2'),(194,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 14:49:59','2024-03-05 14:49:59',NULL,NULL,'a96ac48f-7d94-4fa0-bf67-b25026c6580e'),(195,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 14:50:02','2024-03-05 14:50:02',NULL,NULL,'6c474d3a-bd10-4304-8b8b-c8aac6185f33'),(196,187,NULL,80,21,'craft\\elements\\Entry',1,0,'2024-03-05 14:50:13','2024-03-05 14:50:13',NULL,NULL,'7efcb607-90f4-4880-9b9f-479f8a137861'),(197,NULL,NULL,NULL,22,'craft\\elements\\Entry',1,0,'2024-03-05 14:53:10','2024-03-05 17:21:41',NULL,NULL,'903a1dc6-965b-4ce7-9fa1-2692be08ebe1'),(198,197,NULL,81,22,'craft\\elements\\Entry',1,0,'2024-03-05 14:53:10','2024-03-05 14:53:10',NULL,NULL,'7829c7df-e37f-469c-b06e-eec8c02cf710'),(199,197,NULL,82,22,'craft\\elements\\Entry',1,0,'2024-03-05 14:53:10','2024-03-05 14:53:10',NULL,NULL,'dfb2944f-cdbe-4fa5-8595-f3ed34318fb7'),(200,197,NULL,83,22,'craft\\elements\\Entry',1,0,'2024-03-05 14:53:24','2024-03-05 14:53:24',NULL,NULL,'3ae71c41-5702-46dc-be38-942ea64f9e8e'),(201,197,NULL,84,22,'craft\\elements\\Entry',1,0,'2024-03-05 14:55:53','2024-03-05 14:55:53',NULL,NULL,'a9f07d39-caa8-48b3-b54f-95b6019aaaf3'),(203,197,NULL,85,22,'craft\\elements\\Entry',1,0,'2024-03-05 14:56:27','2024-03-05 14:56:28',NULL,NULL,'b90d2f58-e31f-4369-9537-95cd066769dd'),(204,187,NULL,86,21,'craft\\elements\\Entry',0,0,'2024-03-05 15:00:28','2024-03-05 15:00:28',NULL,NULL,'a2f875ae-9d8d-4b7d-886a-ca37c18400ef'),(205,187,NULL,87,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:00:36','2024-03-05 15:00:36',NULL,NULL,'fd05b29b-0ee4-4ff3-83b1-6a8e986cd421'),(206,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:00:40','2024-03-05 15:00:40',NULL,NULL,'b0dd7852-ce41-427c-9b10-b8cbc45eb2a4'),(207,206,NULL,88,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:00:40','2024-03-05 15:00:40',NULL,NULL,'b5a4fde2-9f4e-4377-a6c2-361325ffa076'),(209,187,NULL,89,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:00:55','2024-03-05 15:00:56',NULL,NULL,'7f7c8b0f-32fa-4151-be90-0a4c26420b71'),(210,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:01:08','2024-03-05 15:01:37',NULL,NULL,'6efe89ad-c2e6-4064-908b-82e2ebdc0ba9'),(211,210,NULL,90,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:01:08','2024-03-05 15:01:08',NULL,NULL,'ad69dc14-8c0b-4ba3-aff3-cd5d201264d2'),(213,210,NULL,91,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:01:18','2024-03-05 15:01:18',NULL,NULL,'10925ae7-7b3a-4a53-a897-59e62974b134'),(215,210,NULL,92,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:01:37','2024-03-05 15:01:38',NULL,NULL,'76a8b722-1183-4efd-a3e9-534c05b67914'),(216,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:01:45','2024-03-05 15:01:58',NULL,NULL,'1ecbbe19-9ce9-403f-855d-95833228c5b9'),(217,216,NULL,93,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:01:45','2024-03-05 15:01:45',NULL,NULL,'256ce0ca-0d90-4863-9bd6-5c82c45f491e'),(219,216,NULL,94,21,'craft\\elements\\Entry',1,0,'2024-03-05 15:01:58','2024-03-05 15:01:58',NULL,NULL,'b31c322e-1d4d-4508-bc4b-51110290796e'),(220,NULL,NULL,NULL,23,'craft\\elements\\Category',1,0,'2024-03-05 15:56:57','2024-03-05 16:00:08',NULL,NULL,'009e0308-0c82-4a6b-9a48-b923732cbd3a'),(221,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 15:57:55','2024-03-05 15:57:55',NULL,NULL,'48f525c0-38d7-49f7-97ad-2f0d1035dbb7'),(222,NULL,NULL,NULL,23,'craft\\elements\\Category',1,0,'2024-03-05 15:58:40','2024-03-05 15:59:17',NULL,NULL,'41b12816-43e5-49f4-ac4f-ed1e9efec649'),(224,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 15:59:13','2024-03-05 15:59:13',NULL,NULL,'82ab6966-3e4c-4827-96f1-52ec2e38f0cc'),(225,NULL,NULL,NULL,23,'craft\\elements\\Category',1,0,'2024-03-05 15:59:22','2024-03-05 15:59:22',NULL,NULL,'7329459f-4330-4581-80ed-421807e26ab5'),(227,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-05 15:59:57','2024-03-05 15:59:57',NULL,NULL,'fd6d7efc-01b8-4db6-a9e8-b67dcedadfc0'),(228,NULL,NULL,NULL,24,'craft\\elements\\Entry',1,0,'2024-03-05 16:01:28','2024-03-05 17:18:20',NULL,NULL,'ea96a131-349d-420f-a6f8-df32a65614b8'),(229,228,NULL,95,24,'craft\\elements\\Entry',1,0,'2024-03-05 16:01:28','2024-03-05 16:01:28',NULL,NULL,'a9649946-c0f4-4349-be20-8f09116c1f55'),(230,228,NULL,96,24,'craft\\elements\\Entry',1,0,'2024-03-05 16:01:28','2024-03-05 16:01:28',NULL,NULL,'36c54a09-55fb-49df-acf3-34d80e730511'),(231,228,NULL,97,24,'craft\\elements\\Entry',1,0,'2024-03-05 16:01:55','2024-03-05 16:01:55',NULL,NULL,'b3ffbdd4-de70-417f-a85c-fd8f994e28f4'),(233,228,NULL,98,24,'craft\\elements\\Entry',1,0,'2024-03-05 16:02:19','2024-03-05 16:02:19',NULL,NULL,'c38a0d94-f879-4df2-bf0e-988fb6d24b6b'),(234,NULL,NULL,NULL,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:19:59','2024-03-05 17:15:06',NULL,NULL,'d18a354b-b5d5-4f58-8a2a-a89c861882b0'),(235,234,NULL,99,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:20:07','2024-03-05 16:20:07',NULL,NULL,'d1d1175c-0f21-44fa-8174-ed857880bd51'),(237,234,NULL,100,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:20:19','2024-03-05 16:20:19',NULL,NULL,'92f72df0-15be-4355-b5b0-38185290adc0'),(239,234,NULL,101,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:24:05','2024-03-05 16:24:05',NULL,NULL,'188d6138-d940-4188-b37b-4c6b64057980'),(241,234,NULL,102,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:49:14','2024-03-05 16:49:14',NULL,NULL,'6a36abb0-df5a-4319-ae52-689430eb28ab'),(243,234,NULL,103,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:52:16','2024-03-05 16:52:16',NULL,NULL,'afe379fa-9a60-4e42-a9c8-f4d435b73240'),(244,NULL,NULL,NULL,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:53:32','2024-03-05 16:53:37',NULL,NULL,'f82f6c21-7548-458e-a62d-913d4f484823'),(245,244,NULL,104,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:53:37','2024-03-05 16:53:37',NULL,NULL,'2a56248d-6f10-4c4e-9962-60860c7f5bc7'),(246,NULL,NULL,NULL,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:54:19','2024-03-05 16:54:28',NULL,NULL,'122c3c44-85d2-4d5a-bb9d-c79bc05d0919'),(247,246,NULL,105,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:54:22','2024-03-05 16:54:22',NULL,NULL,'3b8ed62a-20cc-455c-8794-aa5048f26f99'),(249,246,NULL,106,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:54:28','2024-03-05 16:54:28',NULL,NULL,'5d96eb21-8a2e-4a74-9f11-1323b899ed81'),(250,NULL,NULL,NULL,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:54:33','2024-03-05 16:54:36',NULL,NULL,'fdf9f693-a83f-4728-91ec-957f1a100e1c'),(251,250,NULL,107,25,'craft\\elements\\Entry',1,0,'2024-03-05 16:54:36','2024-03-05 16:54:36',NULL,NULL,'0faee43d-bf9c-451f-b5d3-3a99bad83361'),(253,234,NULL,108,25,'craft\\elements\\Entry',1,0,'2024-03-05 17:15:06','2024-03-05 17:15:06',NULL,NULL,'f0475bbc-da35-4f14-bc1d-60a48af21e0b'),(254,228,NULL,109,24,'craft\\elements\\Entry',1,0,'2024-03-05 17:18:09','2024-03-05 17:18:09',NULL,NULL,'932777b6-75a8-4057-8cd1-42f336b2f44a'),(256,228,NULL,110,24,'craft\\elements\\Entry',1,0,'2024-03-05 17:18:20','2024-03-05 17:18:20',NULL,NULL,'39230753-c876-41e6-979a-8ee63a6f37be'),(258,187,NULL,111,21,'craft\\elements\\Entry',1,0,'2024-03-05 17:19:36','2024-03-05 17:19:36',NULL,NULL,'692b2b33-2e92-4c9e-a725-907ff1bb4ca8'),(259,197,NULL,112,22,'craft\\elements\\Entry',1,0,'2024-03-05 17:21:32','2024-03-05 17:21:32',NULL,NULL,'ce3b5144-f740-4ee9-a4e3-10a7b451e4fd'),(261,197,NULL,113,22,'craft\\elements\\Entry',1,0,'2024-03-05 17:21:41','2024-03-05 17:21:41',NULL,NULL,'88198edd-8b0e-40b3-a996-4b3629b9606f'),(262,81,NULL,114,17,'craft\\elements\\Entry',1,0,'2024-03-05 17:22:34','2024-03-05 17:22:34',NULL,NULL,'05badc49-7e14-4b9b-bd1a-cee643e0e618'),(263,81,NULL,115,17,'craft\\elements\\Entry',1,0,'2024-03-05 17:22:47','2024-03-05 17:22:47',NULL,NULL,'ba349bde-076c-456d-b411-eda98bb63e38'),(265,81,NULL,116,17,'craft\\elements\\Entry',1,0,'2024-03-05 17:23:14','2024-03-05 17:23:14',NULL,NULL,'8af67ff4-8b4f-4217-bd15-d9f4cc6dd544'),(267,81,NULL,117,17,'craft\\elements\\Entry',1,0,'2024-03-05 17:23:24','2024-03-05 17:23:24',NULL,NULL,'f8ebf919-2f75-46bc-a541-0b88d78aff07'),(269,81,NULL,118,17,'craft\\elements\\Entry',1,0,'2024-03-05 17:23:48','2024-03-05 17:23:48',NULL,NULL,'cd414ca1-971c-4626-bd22-0e174177c2be'),(270,169,NULL,119,20,'craft\\elements\\Entry',1,0,'2024-03-05 17:24:55','2024-03-05 17:24:55',NULL,NULL,'8a012db8-4ba3-4b72-b588-15b9865bc1da'),(271,169,NULL,120,20,'craft\\elements\\Entry',1,0,'2024-03-05 17:25:03','2024-03-05 17:25:03',NULL,NULL,'95375178-54a9-4e01-88e2-32db11328d8f'),(272,14,NULL,121,5,'craft\\elements\\Entry',1,0,'2024-03-05 17:25:27','2024-03-05 17:25:27',NULL,NULL,'4a278e36-5713-44b5-a18a-b644529f1d66'),(273,141,NULL,122,19,'craft\\elements\\Entry',1,0,'2024-03-05 17:26:03','2024-03-05 17:26:03',NULL,NULL,'d082ccc4-0bf1-4e8d-a3f3-5a90fa357e92'),(276,141,NULL,123,19,'craft\\elements\\Entry',1,0,'2024-03-05 17:26:23','2024-03-05 17:26:23',NULL,NULL,'37157a2b-8f73-4f5d-8944-cb65f935c0b0'),(277,169,NULL,124,20,'craft\\elements\\Entry',1,0,'2024-03-05 17:26:56','2024-03-05 17:26:56',NULL,NULL,'4d01293c-e70b-47ff-b963-60e47b04826b'),(278,169,NULL,125,20,'craft\\elements\\Entry',1,0,'2024-03-05 17:27:05','2024-03-05 17:27:05',NULL,NULL,'d2d339c8-52c5-4332-8cde-ec635ce086ba'),(280,119,NULL,126,14,'craft\\elements\\Entry',1,0,'2024-03-08 15:48:22','2024-03-08 15:48:22',NULL,NULL,'e83d4b90-0f10-46d7-9e2c-e9e5bbcdc3e8'),(282,119,NULL,127,14,'craft\\elements\\Entry',1,0,'2024-03-08 15:48:36','2024-03-08 15:48:36',NULL,NULL,'86b2867d-cff9-407d-b856-cc25ee40e9cc'),(283,NULL,NULL,NULL,26,'craft\\elements\\Entry',1,0,'2024-03-08 15:50:23','2024-03-08 15:52:49',NULL,NULL,'0664c596-f806-4ac2-8425-4227a758533e'),(284,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 15:51:55','2024-03-08 15:51:55',NULL,NULL,'fda23064-27a4-4e7a-b68d-0812b967a916'),(285,283,NULL,128,26,'craft\\elements\\Entry',1,0,'2024-03-08 15:52:24','2024-03-08 15:52:24',NULL,NULL,'a153a208-cd63-47a8-b7dd-426ebae1c28d'),(287,283,NULL,129,26,'craft\\elements\\Entry',1,0,'2024-03-08 15:52:49','2024-03-08 15:52:49',NULL,NULL,'8299bb1d-9589-408a-9b56-a6be80e31660'),(288,NULL,NULL,NULL,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:00:27','2024-03-08 16:04:45',NULL,NULL,'0d931b81-10d1-4316-9a69-4882361df122'),(289,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:02:35','2024-03-08 16:02:35',NULL,NULL,'5ba3c78e-350e-443f-9f2f-69e878ac2a43'),(290,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:03:55','2024-03-08 16:03:55',NULL,NULL,'d5c423f5-2841-4d88-ab72-54d62a16ff78'),(291,288,NULL,130,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:04:17','2024-03-08 16:04:17',NULL,NULL,'19a37d99-1698-4b85-b14e-344eadb2db54'),(293,288,NULL,131,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:04:23','2024-03-08 16:04:23',NULL,NULL,'a45ee182-7bcf-4b44-8d37-9f3afed16a5a'),(295,288,NULL,132,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:04:45','2024-03-08 16:04:45',NULL,NULL,'c5d33cb0-f559-43f8-973c-9bd627b2c203'),(296,NULL,NULL,NULL,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:09:44','2024-03-08 16:14:11',NULL,NULL,'ff456722-42a0-4ec2-8ed4-048273949c24'),(297,296,NULL,133,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:10:01','2024-03-08 16:10:01',NULL,NULL,'8870b4b7-cec4-4432-8cec-0196697bb18a'),(299,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:11:02','2024-03-08 16:11:02',NULL,NULL,'c208e442-cd66-4163-973a-2583cd04fcce'),(300,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:11:31','2024-03-08 16:11:31',NULL,NULL,'8937a3cd-ca70-4a27-b2f0-93581fd6a8e8'),(301,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:11:31','2024-03-08 16:11:31',NULL,NULL,'fecc00e5-df73-4252-8166-809a8ed9696b'),(302,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:11:32','2024-03-08 16:11:32',NULL,NULL,'03ff7c88-07c7-4f97-aadd-ca537f0dac6c'),(303,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:11:33','2024-03-08 16:11:33',NULL,NULL,'04180179-9564-40ec-a5de-ff756476f784'),(304,296,NULL,134,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:14:11','2024-03-08 16:14:12',NULL,NULL,'a1a9b442-957f-4946-abbe-c2d00286887c'),(305,NULL,NULL,NULL,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:15:38','2024-03-08 16:18:37',NULL,NULL,'c09fdb53-9b8e-40a6-8068-01f1622d6a48'),(306,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:16:18','2024-03-08 16:16:18',NULL,NULL,'b5276e07-83fb-47d0-8b5f-c6c4602ae846'),(307,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 16:16:18','2024-03-08 16:16:18',NULL,NULL,'aa7fd840-d7ac-4b9a-a581-e48bf80db238'),(308,305,NULL,135,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:17:15','2024-03-08 16:17:15',NULL,NULL,'e6c35303-1e8b-4aa1-b55b-bdab85e17005'),(310,305,NULL,136,26,'craft\\elements\\Entry',1,0,'2024-03-08 16:18:37','2024-03-08 16:18:37',NULL,NULL,'f4c1b1e8-622d-4538-9282-adacb1ddd609'),(311,NULL,NULL,NULL,27,'craft\\elements\\Entry',1,0,'2024-03-08 16:46:54','2024-03-08 16:51:12',NULL,NULL,'09fecdc7-eb30-499c-bead-63402f07054c'),(312,311,NULL,137,27,'craft\\elements\\Entry',1,0,'2024-03-08 16:47:26','2024-03-08 16:47:26',NULL,NULL,'de258741-c9d4-463d-981e-89d935db0710'),(314,311,NULL,138,27,'craft\\elements\\Entry',1,0,'2024-03-08 16:47:31','2024-03-08 16:47:31',NULL,NULL,'6326dc44-2258-41e3-b7bb-f2ed2dac09d1'),(316,311,NULL,139,27,'craft\\elements\\Entry',1,0,'2024-03-08 16:51:12','2024-03-08 16:51:12',NULL,NULL,'a062b9ad-34e2-47de-81f6-9c2b59c39cc5'),(317,NULL,NULL,NULL,28,'craft\\elements\\Entry',1,0,'2024-03-08 17:02:27','2024-03-08 17:02:57',NULL,NULL,'f85fcd42-1672-4953-8cbc-3c843e557ebf'),(318,317,NULL,140,28,'craft\\elements\\Entry',1,0,'2024-03-08 17:02:57','2024-03-08 17:02:57',NULL,NULL,'8f1e1bd7-07b0-4a62-957a-04b8a94c6192'),(319,NULL,NULL,NULL,29,'craft\\elements\\Entry',1,0,'2024-03-08 17:09:39','2024-03-08 17:10:25',NULL,NULL,'f73a8982-6fd8-4a56-906c-ff1900a6abfe'),(320,319,NULL,141,29,'craft\\elements\\Entry',1,0,'2024-03-08 17:09:57','2024-03-08 17:09:57',NULL,NULL,'59957720-0d0e-44d5-af79-9f351f45856f'),(322,319,NULL,142,29,'craft\\elements\\Entry',1,0,'2024-03-08 17:10:25','2024-03-08 17:10:25',NULL,NULL,'13040af0-7d15-4589-971e-ca1de38f1cbd'),(323,NULL,NULL,NULL,31,'craft\\elements\\Category',1,0,'2024-03-08 17:17:23','2024-03-08 17:19:23',NULL,NULL,'151c1ba9-9c7d-4b3e-be3b-eec3bb07b3d7'),(324,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:19:21','2024-03-08 17:19:21',NULL,NULL,'3c5eebce-f964-46d8-bfbc-b10714ff8700'),(326,NULL,NULL,NULL,31,'craft\\elements\\Category',1,0,'2024-03-08 17:19:32','2024-03-08 17:20:43',NULL,NULL,'e7ba154d-3d0e-4505-9988-677df2450ecc'),(327,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:19:50','2024-03-08 17:19:50',NULL,NULL,'3d609ef3-59f3-4ed8-a88b-55111a86e273'),(329,NULL,NULL,NULL,31,'craft\\elements\\Category',1,0,'2024-03-08 17:19:56','2024-03-08 17:20:34',NULL,NULL,'26a03973-4247-40ef-afdc-d29ea30a3d94'),(331,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:20:23','2024-03-08 17:20:23',NULL,NULL,'f478b640-15a0-4461-82e4-94558dc4c56d'),(333,NULL,NULL,NULL,31,'craft\\elements\\Category',1,0,'2024-03-08 17:20:48','2024-03-08 17:21:19',NULL,NULL,'96d2c155-3b4e-4234-b399-9858ae1cfcd9'),(335,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:21:17','2024-03-08 17:21:17',NULL,NULL,'3a76f9cb-2319-459a-bfe1-90df4c9402eb'),(336,NULL,NULL,NULL,31,'craft\\elements\\Category',1,0,'2024-03-08 17:21:23','2024-03-08 17:21:47',NULL,NULL,'f30526ae-548d-4200-88fa-b8e8ee6d7726'),(338,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:21:46','2024-03-08 17:21:46',NULL,NULL,'db7751e5-8fc0-46c8-8ef3-9dbd24afc387'),(339,NULL,NULL,NULL,30,'craft\\elements\\Entry',1,0,'2024-03-08 17:29:25','2024-03-08 17:35:32',NULL,NULL,'1ba079f4-59a3-4f8e-aae8-68e3bae3151f'),(340,339,NULL,143,30,'craft\\elements\\Entry',1,0,'2024-03-08 17:29:48','2024-03-08 17:29:48',NULL,NULL,'7582ea71-c9cc-4963-be48-ec70ff5dfd90'),(342,NULL,NULL,NULL,33,'craft\\elements\\Category',1,0,'2024-03-08 17:33:32','2024-03-08 17:34:10',NULL,NULL,'78782cf8-b386-4d73-8bfc-47a19e5dc533'),(343,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:33:54','2024-03-08 17:33:54',NULL,NULL,'9ff93a5e-a475-4ab1-90dc-da9b53253fe8'),(344,NULL,NULL,NULL,33,'craft\\elements\\Category',1,0,'2024-03-08 17:34:16','2024-03-08 17:34:42',NULL,NULL,'0b2e1bec-2674-4112-926b-d414ddde0531'),(346,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:34:32','2024-03-08 17:34:32',NULL,NULL,'119c01ef-345e-4aa3-b113-906a6b9e7faf'),(347,NULL,NULL,NULL,33,'craft\\elements\\Category',1,0,'2024-03-08 17:34:47','2024-03-08 17:35:12',NULL,NULL,'d036017b-5486-4e58-9680-102287cf4c6f'),(349,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-08 17:35:09','2024-03-08 17:35:09',NULL,NULL,'54db5061-d291-4b1d-b5ee-1165b058f51b'),(350,339,NULL,144,30,'craft\\elements\\Entry',1,0,'2024-03-08 17:35:32','2024-03-08 17:35:32',NULL,NULL,'aa1894e3-81d7-41db-afc2-3fbdd3ea22df'),(351,NULL,NULL,NULL,32,'craft\\elements\\Entry',1,0,'2024-03-08 17:35:37','2024-03-08 17:36:00',NULL,NULL,'ed48a094-cb04-4205-8d13-fb0884b3de49'),(352,351,NULL,145,32,'craft\\elements\\Entry',1,0,'2024-03-08 17:36:00','2024-03-08 17:36:00',NULL,NULL,'55d93c23-b8b7-4222-a5a4-55625577f946'),(353,NULL,NULL,NULL,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:49:48','2024-03-08 17:57:00',NULL,NULL,'2001417d-8ea3-46d4-9ae8-c0adf4ef25d5'),(354,353,NULL,146,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:49:48','2024-03-08 17:49:48',NULL,NULL,'3ad1f166-f9c7-4e84-9835-de155bf179b0'),(355,353,NULL,147,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:49:48','2024-03-08 17:49:48',NULL,NULL,'1f3f3119-2f44-460e-842d-4fb934c3b4ed'),(356,353,NULL,148,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:50:38','2024-03-08 17:50:38',NULL,NULL,'7d6bb6ec-f791-4828-b468-09d233b82827'),(358,353,NULL,149,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:51:18','2024-03-08 17:51:18',NULL,NULL,'a175af69-b63e-4f2a-97da-8575bb171168'),(360,353,NULL,150,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:51:25','2024-03-08 17:51:25',NULL,NULL,'e748e116-fbc4-42ad-a0df-f33a34b0c287'),(362,353,NULL,151,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:53:55','2024-03-08 17:53:55',NULL,NULL,'1f41d9c3-ab65-464e-b9f8-425ef7131cd0'),(363,353,NULL,152,34,'craft\\elements\\Entry',1,0,'2024-03-08 17:57:00','2024-03-08 17:57:00',NULL,NULL,'9d23839b-d9d0-42d7-8518-009365363a80'),(364,NULL,NULL,NULL,35,'craft\\elements\\Entry',1,0,'2024-03-11 10:59:39','2024-03-11 11:00:47',NULL,NULL,'19f98474-04f5-4e68-9518-3243940801ba'),(365,364,NULL,153,35,'craft\\elements\\Entry',1,0,'2024-03-11 10:59:52','2024-03-11 10:59:52',NULL,NULL,'63dde98e-15ba-4494-8792-6f7e12cd8e6e'),(367,364,NULL,154,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:00:47','2024-03-11 11:00:47',NULL,NULL,'719e9524-b1e4-46ef-8fb7-459a69ec3d59'),(368,NULL,NULL,NULL,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:05:11','2024-03-11 11:11:42',NULL,NULL,'22fc22b1-dff9-4413-9787-7a0f5874b8a7'),(369,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-11 11:06:20','2024-03-11 11:06:20',NULL,NULL,'1d645966-d429-4686-af6b-7a72a8035816'),(370,368,NULL,155,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:09:58','2024-03-11 11:09:58',NULL,NULL,'5eb6158b-3448-44a1-ae72-16897a658d3e'),(372,368,NULL,156,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:10:56','2024-03-11 11:10:56',NULL,NULL,'7f315383-be12-494d-98e7-056eba293047'),(373,368,NULL,157,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:11:42','2024-03-11 11:11:42',NULL,NULL,'8a597c2b-f1f3-4d73-b347-a47ca1739c02'),(374,NULL,NULL,NULL,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:14:44','2024-03-11 11:19:47',NULL,NULL,'31edd6c4-26fb-4140-94eb-29ffd65954f8'),(375,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-11 11:16:22','2024-03-11 11:16:22',NULL,NULL,'60036127-2979-49f0-8bc2-2bc1f64d56ea'),(376,374,NULL,158,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:17:20','2024-03-11 11:17:20',NULL,NULL,'0eb8cf79-93f9-4396-9ddc-8c2a7301eafb'),(378,374,NULL,159,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:18:54','2024-03-11 11:18:55',NULL,NULL,'c4db6487-7c81-4645-9aed-8e21dc0500f5'),(379,374,NULL,160,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:19:05','2024-03-11 11:19:05',NULL,NULL,'d9de1b9f-4d0b-4c2d-8a93-0cd1a08b0f12'),(381,374,NULL,161,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:19:47','2024-03-11 11:19:47',NULL,NULL,'e0419838-ee6e-4e6f-b46b-902b6d95e341'),(382,NULL,NULL,NULL,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:20:23','2024-03-11 11:22:46',NULL,NULL,'b972a027-ee3f-4292-8d12-e5da22462765'),(383,NULL,NULL,NULL,1,'craft\\elements\\Asset',1,0,'2024-03-11 11:20:56','2024-03-11 11:20:56',NULL,NULL,'bf57a9af-020b-491a-9cdd-8e48caa9cb3d'),(384,382,NULL,162,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:21:36','2024-03-11 11:21:36',NULL,NULL,'e43441e2-040c-45e8-8810-105087a8e48d'),(386,382,NULL,163,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:21:42','2024-03-11 11:21:42',NULL,NULL,'471d69a4-3a31-4bdf-a90a-1f6ba0010734'),(388,382,NULL,164,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:22:37','2024-03-11 11:22:37',NULL,NULL,'8b741b20-425e-4ffa-acec-c622fd95cf92'),(389,382,NULL,165,35,'craft\\elements\\Entry',1,0,'2024-03-11 11:22:46','2024-03-11 11:22:46',NULL,NULL,'e3afb201-7e2e-4610-8604-0845ae80eb25');
/*!40000 ALTER TABLE `elements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_sites`
--

LOCK TABLES `elements_sites` WRITE;
/*!40000 ALTER TABLE `elements_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_sites` VALUES (1,1,1,NULL,NULL,1,'2024-02-16 17:40:41','2024-02-16 17:40:41','c7bc7fc3-8d38-49d5-a6b4-b5f15d6a32d7'),(2,2,1,NULL,NULL,1,'2024-02-19 12:20:57','2024-02-19 12:20:57','e4263bf8-612f-455d-b898-41aa261e919a'),(3,3,1,NULL,NULL,1,'2024-02-19 12:21:07','2024-02-19 12:21:07','d69b3295-87fa-4729-a435-d8d67d568015'),(4,4,1,NULL,NULL,1,'2024-02-19 12:45:53','2024-02-19 12:45:53','2cd44623-874a-4f1e-a379-f682391016d0'),(5,5,1,NULL,NULL,1,'2024-02-19 12:53:21','2024-02-19 12:53:21','9512bdf3-57cc-4462-8eb9-9b14fb93f05b'),(10,10,1,NULL,NULL,1,'2024-02-19 14:11:23','2024-02-19 14:11:23','d7483cf3-7675-45f1-85f5-099ca8ff237e'),(11,11,1,NULL,NULL,1,'2024-02-19 14:11:31','2024-02-19 14:11:31','994f242c-edd6-482d-916d-113cdc27a4b1'),(12,12,1,NULL,NULL,1,'2024-02-19 14:12:12','2024-02-19 14:12:12','4785eace-94b4-4f24-bc0d-d31664838bd9'),(13,13,1,NULL,NULL,1,'2024-02-19 14:13:29','2024-02-19 14:13:29','43c08b16-4403-4eeb-81ce-5779d7895f07'),(14,14,1,'inicio','__home__',1,'2024-02-20 17:13:27','2024-02-20 17:13:27','350915a2-4f28-4816-90b3-a319f5db74f7'),(15,15,1,'inicio','__home__',1,'2024-02-20 17:13:27','2024-02-20 17:13:27','27936577-1437-4302-a528-831527f81a27'),(16,16,1,'inicio','__home__',1,'2024-02-20 17:13:27','2024-02-20 17:13:27','f7d5adc9-2071-4bc9-92f8-834b748d7886'),(17,17,1,'inicio','__home__',1,'2024-02-20 17:13:53','2024-02-20 17:13:53','6987791a-ed3c-4e6f-b208-da4bde4d8271'),(19,19,1,'inicio','__home__',1,'2024-02-20 17:14:19','2024-02-20 17:14:19','a42406f7-d96a-429c-86e6-bde487589ede'),(20,20,1,NULL,NULL,1,'2024-02-20 17:19:07','2024-02-20 17:19:07','2bcc9e40-7004-41d0-b6e0-8fe5c35e6046'),(21,21,1,NULL,NULL,1,'2024-02-20 17:51:21','2024-02-20 17:51:21','bc666351-945c-4419-821d-41b55f0ba9c2'),(22,22,1,NULL,NULL,1,'2024-02-22 12:54:46','2024-02-22 12:54:46','3789f525-f4ee-44e7-a5e2-be09798c1b51'),(23,23,1,NULL,NULL,1,'2024-02-22 12:54:47','2024-02-22 12:54:47','0b1e01ea-1f5e-4098-a9d1-6ab68e77f9a9'),(24,24,1,NULL,NULL,1,'2024-02-22 14:18:20','2024-02-22 14:18:20','08aa260a-da10-43b7-83aa-a72efd647d8a'),(25,25,1,NULL,NULL,1,'2024-02-22 14:18:50','2024-02-22 14:18:50','aa39ecb0-6190-4e09-b35c-80855c9f8a8a'),(26,26,1,NULL,NULL,1,'2024-02-22 14:18:50','2024-02-22 14:18:50','97c69785-7e63-419d-b880-7eef74379120'),(27,27,1,NULL,NULL,1,'2024-02-22 14:18:50','2024-02-22 14:18:50','4c305b7e-3426-4ab0-8593-c18228957839'),(28,28,1,NULL,NULL,1,'2024-02-22 14:24:58','2024-02-22 14:24:58','1109a60c-fd77-4ca9-b389-3273f39d23bb'),(29,29,1,NULL,NULL,1,'2024-02-22 14:28:01','2024-02-22 14:28:01','b78af202-a3a8-4fdc-b1f3-8ca16aabf713'),(30,30,1,NULL,NULL,1,'2024-02-22 14:28:09','2024-02-22 14:28:09','8552c256-602d-47c5-8883-3b7cb84ebdc5'),(31,31,1,NULL,NULL,1,'2024-02-22 14:54:20','2024-02-22 14:54:20','51b3ad57-aee7-4510-8776-95b958e02714'),(32,32,1,NULL,NULL,1,'2024-02-22 14:57:55','2024-02-22 14:57:55','c608cde1-c290-4ff6-a9f6-923fea083e11'),(33,33,1,NULL,NULL,1,'2024-02-22 14:57:56','2024-02-22 14:57:56','367d7801-3fa8-4a77-83f1-c7ed1249df08'),(34,34,1,NULL,NULL,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','fc517c15-4504-42f7-a8da-542c3b786802'),(35,35,1,NULL,NULL,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','d9f6474d-29d0-408f-8667-e66e336433bc'),(36,36,1,NULL,NULL,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','4b9a46be-b263-447d-a1e9-09bb2c78aa72'),(37,37,1,NULL,NULL,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','4eee9abb-e4f0-4a33-8646-8f18189a4f67'),(38,38,1,NULL,NULL,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','7a55f94e-90b1-4798-a3ad-4af2a819e1b3'),(39,39,1,NULL,NULL,1,'2024-02-22 15:05:27','2024-02-22 15:05:27','14b79211-2e62-480f-8d80-52f8ceb5f061'),(40,40,1,NULL,NULL,1,'2024-02-22 15:29:15','2024-02-22 15:29:15','3c5fd519-715e-432c-832f-c303e6187c05'),(41,41,1,NULL,NULL,1,'2024-02-22 17:41:41','2024-02-22 17:41:41','39671e9b-7c7e-49fa-b273-7265ae7fa811'),(42,42,1,NULL,NULL,1,'2024-02-22 17:42:30','2024-02-22 17:42:30','6df54ad4-e50c-43cf-9fe5-78ae7b2a32ef'),(43,43,1,NULL,NULL,1,'2024-02-22 17:43:03','2024-02-22 17:43:03','7c93fbac-f9a5-4459-a803-30abed8fd61d'),(44,44,1,NULL,NULL,1,'2024-02-22 17:43:08','2024-02-22 17:43:08','b3238101-cf40-40bd-b797-f684f2c19e01'),(45,45,1,NULL,NULL,1,'2024-02-22 17:43:11','2024-02-22 17:43:11','db7aa9a4-7b57-4ea7-b041-61bc50d80c7c'),(46,46,1,NULL,NULL,1,'2024-02-22 17:43:11','2024-02-22 17:43:11','2f46f232-f78b-450a-af26-eb7f919be2e3'),(47,47,1,NULL,NULL,1,'2024-02-22 17:49:38','2024-02-22 17:49:38','20e14542-d635-4bb8-ae51-9723d1d4222e'),(48,48,1,NULL,NULL,1,'2024-02-22 17:54:19','2024-02-22 17:54:19','eaaedc82-6793-4a26-b08f-809c4160d1e8'),(49,49,1,'bike-challenge-condicionamento-do-transito','noticias/bike-challenge-condicionamento-do-transito',1,'2024-02-22 18:00:36','2024-02-22 18:00:39','9b940aa1-4a43-4741-9ff4-41d9468dd99c'),(50,50,1,'bike-challenge-condicionamento-do-transito','noticias/bike-challenge-condicionamento-do-transito',1,'2024-02-22 18:00:41','2024-02-22 18:00:41','a7dd95ff-7ec4-4afa-a107-3d206f505ff8'),(51,51,1,'comunidade','noticias/comunidade',1,'2024-02-22 18:06:25','2024-02-22 18:06:32','7f54bb07-f3d8-4faf-a1ff-6246d95d7e11'),(52,52,1,'cultura','noticias/cultura',1,'2024-02-22 18:06:37','2024-02-22 18:06:41','f8f725b7-e6e1-4056-aeda-2feef9fbe725'),(53,53,1,'desporto','noticias/desporto',1,'2024-02-22 18:06:47','2024-02-22 18:06:50','2512270b-b4af-4a2c-81ce-29f0b0a64f92'),(54,54,1,'obras-publicas','noticias/obras-publicas',1,'2024-02-22 18:06:58','2024-02-22 18:07:01','e9d8ac14-8094-4b67-9704-8182496f228a'),(55,55,1,NULL,NULL,1,'2024-02-22 18:08:02','2024-02-22 18:08:02','628fb8c6-6695-42f6-a7e5-a12939a74f2c'),(57,57,1,'mesao-frio',NULL,1,'2024-02-22 18:08:13','2024-02-22 18:08:13','7761f518-4b06-4cf2-bd99-207db3f0d261'),(58,58,1,'desporto',NULL,1,'2024-02-22 18:08:48','2024-02-22 18:08:48','99c1dab4-00b9-4e49-b767-9cc6418eddab'),(59,59,1,'bike-challenge-condicionamento-do-transito','noticias/bike-challenge-condicionamento-do-transito',1,'2024-02-22 18:08:49','2024-02-22 18:08:49','3cbd0c36-99a8-4b60-bcf6-cc8aea4ab164'),(61,61,1,'bike-challenge-condicionamento-do-transito','noticias/bike-challenge-condicionamento-do-transito',1,'2024-02-22 18:08:58','2024-02-22 18:08:58','6ab851e0-dc8c-4963-8fa2-133a28954ab2'),(62,62,1,'bike-challenge-condicionamento-do-transito','noticias/bike-challenge-condicionamento-do-transito',1,'2024-02-22 18:10:24','2024-02-22 18:10:24','1cdd2a5b-e176-44f2-9f97-512e1070ce3d'),(64,64,1,NULL,NULL,1,'2024-02-22 18:11:03','2024-02-22 18:11:03','12fe20c0-5dc9-48e5-a508-f04778c3556d'),(65,65,1,'bike-challenge-condicionamento-do-transito','noticias/bike-challenge-condicionamento-do-transito',1,'2024-02-22 18:11:26','2024-02-22 18:11:26','9143d10c-af64-405f-94bd-45d5e9304387'),(66,66,1,'inicio','__home__',1,'2024-02-26 16:19:24','2024-02-26 16:19:24','872f6528-43d7-433f-9ace-f8d7b94d515f'),(67,67,1,'inicio','__home__',1,'2024-02-26 16:19:59','2024-02-26 16:19:59','47283397-da9f-4de1-a5cc-2a396f803317'),(69,69,1,'inicio','__home__',1,'2024-02-26 16:20:11','2024-02-26 16:20:11','d60d76b9-2d84-4e02-a709-af8f7b262ff6'),(70,70,1,'inicio','__home__',1,'2024-02-26 16:20:25','2024-02-26 16:20:25','9ff5ae2c-b9e1-4eb0-98d2-58128af6f953'),(71,71,1,'inicio','__home__',1,'2024-02-26 16:21:09','2024-02-26 16:21:09','767db01e-5bec-4ae8-9dce-d03c50edb674'),(73,73,1,'inicio','__home__',1,'2024-02-26 16:21:28','2024-02-26 16:21:28','87a814d1-7a66-4d8e-a13e-f8fe416c5a2d'),(74,74,1,'inicio','__home__',1,'2024-02-26 16:22:10','2024-02-26 16:22:10','9dbe6144-47a0-4fe6-9914-ed60fdb763df'),(76,76,1,'inicio','__home__',1,'2024-02-26 16:23:46','2024-02-26 16:23:46','dd6bc819-1253-4b2c-869c-3a270af8ba20'),(77,77,1,'inicio','__home__',1,'2024-02-26 16:27:02','2024-02-26 16:27:02','c56dc269-dbb6-4eca-86c7-4990040b0791'),(79,79,1,'inicio','__home__',1,'2024-02-26 16:27:16','2024-02-26 16:27:16','13fd0182-635b-4b29-b0a3-54816b74c54f'),(80,80,1,'inicio','__home__',1,'2024-02-26 16:27:56','2024-02-26 16:27:56','7d5d4e96-721d-4c42-8010-5eff9c82b069'),(81,81,1,'noticias','noticias',1,'2024-02-27 17:20:13','2024-03-01 11:05:07','b5da2547-4b14-42ae-ac67-961a0ac320b6'),(82,82,1,'pagina-de-noticias','pagina-de-noticias',1,'2024-02-27 17:20:13','2024-02-27 17:20:13','b0635ac0-7cdf-481d-9876-6edd94578147'),(83,83,1,'pagina-de-noticias','pagina-de-noticias',1,'2024-02-27 17:20:14','2024-02-27 17:20:14','42c32bc0-ec46-466a-ab97-a7019d1ece9a'),(84,84,1,'pagina-de-noticias','pagina-de-noticias',1,'2024-02-27 17:20:29','2024-02-27 17:20:29','3302077e-cbc1-41f1-911d-cb1c5f4c609d'),(86,86,1,'pagina-de-noticias','pagina-de-noticias',1,'2024-02-27 17:23:16','2024-02-27 17:23:16','f5e4ced7-ca3d-48db-bc3a-e5b06454731f'),(87,87,1,'pagina-de-noticias','pagina-de-noticias',1,'2024-02-27 17:23:22','2024-02-27 17:23:22','cd0badb5-18cb-4a9b-9930-602ee124fa59'),(89,89,1,'pagina-de-noticias','pagina-de-noticias',1,'2024-02-27 17:23:43','2024-02-27 17:23:43','5d8808f1-4dc9-4995-b83d-51d79fa44300'),(90,90,1,'bike-challenge-condicionamento-do-transito-2','noticias/bike-challenge-condicionamento-do-transito-2',1,'2024-02-27 17:58:30','2024-02-27 17:58:30','4cfd50b5-478f-4d86-b367-bcc203057f30'),(91,91,1,'bike-challenge-condicionamento-do-transito-2','noticias/bike-challenge-condicionamento-do-transito-2',1,'2024-02-27 17:58:30','2024-02-27 17:58:30','00cf54cd-7b22-4a77-9178-977a603961ed'),(93,93,1,'bike-challenge-condicionamento-do-transito-2','noticias/bike-challenge-condicionamento-do-transito-2',1,'2024-02-27 17:58:53','2024-02-27 17:58:53','1ae07fbe-1694-4209-8ede-68693f608282'),(94,94,1,'bike-challenge-condicionamento-do-transito-2','noticias/bike-challenge-condicionamento-do-transito-2',1,'2024-02-27 17:59:06','2024-02-27 17:59:06','0b6630b4-fc0c-4d33-9936-f84011b48a66'),(96,96,1,'bike-challenge-condicionamento-do-transito','noticias/bike-challenge-condicionamento-do-transito',1,'2024-02-27 18:01:13','2024-02-27 18:01:13','2b3b18ca-715d-4841-8bfa-09b3a936d094'),(98,98,1,'bike-challenge-condicionamento-do-transito-2','noticias/bike-challenge-condicionamento-do-transito-2',1,'2024-02-27 18:01:18','2024-02-27 18:01:18','871f5dae-69c3-4cf9-a9ac-97bb63341dbf'),(99,99,1,'noticias','noticias',1,'2024-03-01 11:05:07','2024-03-01 11:05:07','488ac9f6-b170-402c-af48-bb594830693a'),(101,101,1,'bike-challenge-condicionamento-do-transito-2','noticias/bike-challenge-condicionamento-do-transito-2',1,'2024-03-01 11:22:05','2024-03-01 11:22:05','afd3587f-e989-4957-b029-faa140c8f4d4'),(102,102,1,'bike-challenge-condicionamento-do-transito-2','noticias/bike-challenge-condicionamento-do-transito-2',1,'2024-03-01 11:22:34','2024-03-01 11:22:34','a894f675-7d87-45d2-ad8a-fe75b546122a'),(103,103,1,'bike-challenge-condicionamento-do-transito-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2',1,'2024-03-01 14:31:51','2024-03-01 14:31:51','ed73fa7f-59ec-4eca-a8f9-20c95535e985'),(104,104,1,'bike-challenge-condicionamento-do-transito-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2',1,'2024-03-01 14:31:52','2024-03-01 14:31:52','d3f4165a-4022-48e8-a573-1e5cf9a612dd'),(106,106,1,'bike-challenge-condicionamento-do-transito-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2',1,'2024-03-01 14:32:01','2024-03-01 14:32:01','64cb8b3c-fcca-4033-8849-4d77111b735b'),(108,108,1,'bike-challenge-condicionamento-do-transito-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2',1,'2024-03-01 14:32:21','2024-03-01 14:32:21','3fbe1c0b-0896-491b-af06-8d67e148b0d7'),(109,109,1,'bike-challenge-condicionamento-do-transito-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2',1,'2024-03-01 14:32:28','2024-03-01 14:32:28','c4198580-d7ef-4764-92d0-0bf244c1f79d'),(110,110,1,'bike-challenge-condicionamento-do-transito-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2',1,'2024-03-01 14:32:28','2024-03-01 14:32:28','bd186380-ce82-41a6-b0b6-7a077140c172'),(112,112,1,'bike-challenge-condicionamento-do-transito-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2',1,'2024-03-01 14:32:39','2024-03-01 14:32:39','f0244f25-22db-400d-84a5-83f3afc9618b'),(114,114,1,'bike-challenge-condicionamento-do-transito-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2',1,'2024-03-01 14:32:47','2024-03-01 14:32:47','aeac83f5-2997-4b4f-b788-d9fccb5d6f27'),(116,116,1,'bike-challenge-condicionamento-do-transito-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2',1,'2024-03-01 14:32:54','2024-03-01 14:32:54','8eb2cfa4-e816-48a5-8b33-115e50921ec6'),(118,118,1,'bike-challenge-condicionamento-do-transito-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2',1,'2024-03-01 14:33:11','2024-03-01 14:33:11','7c73188d-4e7f-4789-8a37-432c64767ce1'),(119,119,1,'intervençao-rua-de-sao-pedro','noticias/intervençao-rua-de-sao-pedro',1,'2024-03-01 14:33:20','2024-03-08 15:48:36','e82a8f2d-3456-4f02-9133-596f91f15383'),(120,120,1,'bike-challenge-condicionamento-do-transito-2-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2-2',1,'2024-03-01 14:33:20','2024-03-01 14:33:20','31779ff2-e47c-4bbf-b62b-b0747f8509ba'),(122,122,1,'bike-challenge-condicionamento-do-transito-2-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2-2',1,'2024-03-01 14:33:30','2024-03-01 14:33:30','1a985db5-1f2a-4fea-8121-d53029c6c63e'),(124,124,1,'bike-challenge-condicionamento-do-transito-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2',1,'2024-03-01 14:33:54','2024-03-01 14:33:54','81c68a5d-672a-4ef4-93e2-a72823d43197'),(126,126,1,'bike-challenge-condicionamento-do-transito-2-2-2-2','noticias/bike-challenge-condicionamento-do-transito-2-2-2-2',1,'2024-03-01 14:34:35','2024-03-01 14:34:35','a58d9898-0a88-43a0-b5a1-e95773b1bc79'),(127,127,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 16:43:14','2024-03-01 16:44:45','2329f0c6-875e-470b-b19d-b934c073ec26'),(128,128,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 16:45:09','2024-03-01 16:45:09','60980f69-f423-4df1-b8e4-8ee5b4543fd0'),(129,129,1,NULL,NULL,1,'2024-03-01 16:45:41','2024-03-01 16:45:41','2175fd70-6c26-4f43-a2ac-fe3447f4eee0'),(131,131,1,NULL,NULL,1,'2024-03-01 16:46:20','2024-03-01 16:46:20','2c86c581-f79c-4539-ad86-3dd2b53f098f'),(132,132,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 16:46:45','2024-03-01 16:46:45','cdbdf067-127f-47c3-8e2d-091a6c91f92e'),(133,133,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 16:47:22','2024-03-01 16:47:22','fda3b94e-4c5b-4b07-9971-0d494801ecee'),(135,135,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 17:04:54','2024-03-01 17:04:54','6cbe4a10-63f3-4282-8d1c-0dc10e2839e6'),(137,137,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 17:05:05','2024-03-01 17:05:05','e122ae3f-7f4a-4846-868f-73e7274e8355'),(138,138,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 17:12:48','2024-03-01 17:12:48','6d8fa3f6-a56c-4f6d-9ed4-44b88f6a0528'),(140,140,1,'movie-premiere-reflex-revenge-action-drama','eventos/movie-premiere-reflex-revenge-action-drama',1,'2024-03-01 17:18:30','2024-03-01 17:18:30','f6606de9-127f-4837-907a-f28d3b0fc610'),(141,141,1,'eventos','eventos',1,'2024-03-01 17:36:55','2024-03-01 17:37:44','e4255bec-2108-41bb-a648-2f869a776f3f'),(142,142,1,'pagina-de-eventos','pagina-de-eventos',1,'2024-03-01 17:36:55','2024-03-01 17:36:55','d8026d1b-3203-4f39-8394-802322e8aaf0'),(143,143,1,'pagina-de-eventos','pagina-de-eventos',1,'2024-03-01 17:36:55','2024-03-01 17:36:55','94009188-bb5f-4d21-8cb1-a2c6b1c934e8'),(144,144,1,'pagina-de-eventos','pagina-de-eventos',1,'2024-03-01 17:37:16','2024-03-01 17:37:16','3ffd8a6c-72f8-4b4d-941b-a07b3ad4f466'),(145,145,1,'pagina-de-eventos','pagina-de-eventos',1,'2024-03-01 17:37:28','2024-03-01 17:37:28','7da4eb8e-f0c4-45fe-afd4-7ac2d00e2947'),(146,146,1,'eventos','eventos',1,'2024-03-01 17:37:44','2024-03-01 17:37:44','2cd2fe6f-c64a-47aa-8ff5-a135e7c8e3d8'),(147,147,1,'movie-premiere-reflex-revenge-action-drama-2','eventos/movie-premiere-reflex-revenge-action-drama-2',1,'2024-03-01 17:45:57','2024-03-01 17:45:57','671b5c0a-6b64-4649-a587-0088d9e6259d'),(148,148,1,'movie-premiere-reflex-revenge-action-drama-2','eventos/movie-premiere-reflex-revenge-action-drama-2',1,'2024-03-01 17:45:57','2024-03-01 17:45:57','58733199-163d-4e34-b599-7751f867e98d'),(150,150,1,'movie-premiere-reflex-revenge-action-drama-2','eventos/movie-premiere-reflex-revenge-action-drama-2',1,'2024-03-01 17:46:16','2024-03-01 17:46:16','9618bde9-a443-4afb-aef7-fabe9487592f'),(152,152,1,'movie-premiere-reflex-revenge-action-drama-2','eventos/movie-premiere-reflex-revenge-action-drama-2',1,'2024-03-01 18:00:06','2024-03-01 18:00:06','474435f3-5b23-42fd-8afb-b67d728dd533'),(153,153,1,'movie-premiere-reflex-revenge-action-drama-2-2','eventos/movie-premiere-reflex-revenge-action-drama-2-2',1,'2024-03-01 18:00:22','2024-03-01 18:00:22','7478f15d-459d-46d3-a079-614deba8b664'),(154,154,1,'movie-premiere-reflex-revenge-action-drama-2-2','eventos/movie-premiere-reflex-revenge-action-drama-2-2',1,'2024-03-01 18:00:22','2024-03-01 18:00:22','74083d61-ffeb-4927-bb8f-9824a6f23e6d'),(155,155,1,'movie-premiere-reflex-revenge-action-drama-3','eventos/movie-premiere-reflex-revenge-action-drama-3',1,'2024-03-01 18:00:27','2024-03-01 18:00:27','713ce17f-3d2b-450a-9f33-35683e91493c'),(156,156,1,'movie-premiere-reflex-revenge-action-drama-3','eventos/movie-premiere-reflex-revenge-action-drama-3',1,'2024-03-01 18:00:27','2024-03-01 18:00:27','362be055-1d5b-4cfd-8db2-fa93aa8b4b00'),(157,157,1,'movie-premiere-reflex-revenge-action-drama-2-3','eventos/movie-premiere-reflex-revenge-action-drama-2-3',1,'2024-03-01 18:00:27','2024-03-01 18:00:27','16f5558f-7964-4864-8894-e7916276be7c'),(158,158,1,'movie-premiere-reflex-revenge-action-drama-2-3','eventos/movie-premiere-reflex-revenge-action-drama-2-3',1,'2024-03-01 18:00:27','2024-03-01 18:00:27','66a7ce69-cdc6-4b18-941f-3338414578ab'),(160,160,1,'movie-premiere-reflex-revenge-action-drama-2','eventos/movie-premiere-reflex-revenge-action-drama-2',1,'2024-03-04 10:58:57','2024-03-04 10:58:57','aa8b46f5-52ac-4137-b609-11be596335aa'),(162,162,1,'movie-premiere-reflex-revenge-action-drama-2-2','eventos/movie-premiere-reflex-revenge-action-drama-2-2',1,'2024-03-04 10:59:05','2024-03-04 10:59:05','ac2dfece-04b1-475e-9480-a9278b15a92d'),(164,164,1,'movie-premiere-reflex-revenge-action-drama-3','eventos/movie-premiere-reflex-revenge-action-drama-3',1,'2024-03-04 10:59:15','2024-03-04 10:59:15','2bd976e6-9677-4da3-8ad3-c8a5820cc4e1'),(166,166,1,'movie-premiere-reflex-revenge-action-drama-2-3','eventos/movie-premiere-reflex-revenge-action-drama-2-3',1,'2024-03-04 10:59:24','2024-03-04 10:59:24','79ad7d01-9ee4-4015-b1fc-1dac0645c041'),(168,168,1,'inicio','__home__',1,'2024-03-04 11:15:48','2024-03-04 11:15:48','533a4782-10ec-4cff-b6e6-f21842ad0bd5'),(169,169,1,'cidadao','cidadao',1,'2024-03-04 11:21:56','2024-03-04 11:21:56','e36f94ee-85f1-4881-96b4-e42e770d6674'),(170,170,1,'cidadao','cidadao',1,'2024-03-04 11:21:56','2024-03-04 11:21:56','f9857964-99b3-4f04-a657-0a5ad05957d5'),(171,171,1,'cidadao','cidadao',1,'2024-03-04 11:21:56','2024-03-04 11:21:56','09cc08a8-ffd8-4c19-bce3-21e2c3aa2c05'),(172,172,1,'cidadao','cidadao',1,'2024-03-04 11:22:11','2024-03-04 11:22:11','8a10ac86-b539-44eb-a2d5-1bc7b19a9b6d'),(173,173,1,'cidadao','cidadao',1,'2024-03-04 11:23:07','2024-03-04 11:23:07','ac48b9e5-97a1-4222-812e-ae4187280866'),(174,174,1,'cidadao','cidadao',1,'2024-03-04 11:24:53','2024-03-04 11:24:53','3cab2086-3423-4764-986a-768bb3dba0d9'),(176,176,1,'cidadao','cidadao',1,'2024-03-04 11:25:22','2024-03-04 11:25:22','b105be50-972a-4b73-a03c-a30c1bf5112f'),(177,177,1,NULL,NULL,1,'2024-03-04 11:25:45','2024-03-04 11:25:45','5e5288cd-c535-4194-a665-eb9e329fa301'),(179,179,1,NULL,NULL,1,'2024-03-04 11:26:07','2024-03-04 11:26:07','cff0dd3c-ca3d-485e-8542-ad3221d7df8c'),(180,180,1,'cidadao','cidadao',1,'2024-03-04 11:26:12','2024-03-04 11:26:12','c755d0f8-ec68-47eb-81a2-31cc754fdea1'),(182,182,1,'cidadao','cidadao',1,'2024-03-05 14:28:17','2024-03-05 14:28:17','2f1887e7-5cc8-436c-9b15-c36c05d8fc06'),(183,183,1,NULL,NULL,1,'2024-03-05 14:28:41','2024-03-05 14:28:41','4a44dea8-0d1c-4a6e-8c24-0dce4ab8407d'),(185,185,1,NULL,NULL,1,'2024-03-05 14:29:15','2024-03-05 14:29:15','d9e34c3d-5bdf-454e-ae01-41e8560e3dfc'),(186,186,1,'cidadao','cidadao',1,'2024-03-05 14:29:27','2024-03-05 14:29:27','b3c43f48-8c2d-4c6f-a146-e8be6d5bf406'),(187,187,1,'alminhas','galeria/alminhas',1,'2024-03-05 14:47:55','2024-03-05 15:00:55','0183a8ed-b801-4758-96b9-0c0ba3c69b28'),(188,188,1,'casa-de-paco-vieira','galeria/casa-de-paco-vieira',1,'2024-03-05 14:48:07','2024-03-05 14:48:07','53d7613a-834d-498a-98d6-e899d952f4a6'),(190,190,1,'casa-de-paco-vieira','galeria/casa-de-paco-vieira',1,'2024-03-05 14:48:25','2024-03-05 14:48:25','f1c777e9-04aa-40a8-b616-4f2324dbd025'),(191,191,1,NULL,NULL,1,'2024-03-05 14:49:54','2024-03-05 14:49:54','009fb23e-47b0-44d7-bec4-625550382888'),(192,192,1,NULL,NULL,1,'2024-03-05 14:49:56','2024-03-05 14:49:56','a7e3d358-1c73-4f1a-a2a2-f5c3024d6e3b'),(194,194,1,NULL,NULL,1,'2024-03-05 14:49:59','2024-03-05 14:49:59','4cffc705-4c6f-4dda-acb9-c965e6c45532'),(195,195,1,NULL,NULL,1,'2024-03-05 14:50:02','2024-03-05 14:50:02','37da563d-3a8e-4222-a9a8-9dc706a0a0ba'),(196,196,1,'casa-de-paco-vieira','galeria/casa-de-paco-vieira',1,'2024-03-05 14:50:13','2024-03-05 14:50:13','07841e71-7adf-4405-a399-3cd606b19c13'),(197,197,1,'galeria','galeria',1,'2024-03-05 14:53:10','2024-03-05 14:53:10','0f0f3b56-664c-49de-89ed-672e841b8eb9'),(198,198,1,'galeria','galeria',1,'2024-03-05 14:53:10','2024-03-05 14:53:10','e5172cab-3aa8-4195-ad00-d3103ba6f0ab'),(199,199,1,'galeria','galeria',1,'2024-03-05 14:53:10','2024-03-05 14:53:10','5b1f4846-3761-4feb-ba9b-d70d36d27322'),(200,200,1,'galeria','galeria',1,'2024-03-05 14:53:24','2024-03-05 14:53:24','aa80bd50-0668-49c7-b775-89ecbfd4dedd'),(201,201,1,'galeria','galeria',1,'2024-03-05 14:55:53','2024-03-05 14:55:53','a16a2e60-2c7a-48dc-adde-bf947855d0e6'),(203,203,1,'galeria','galeria',1,'2024-03-05 14:56:28','2024-03-05 14:56:28','51183586-1017-4ea1-8602-75a886ba4fce'),(204,204,1,'casa-de-paco-vieira','galeria/casa-de-paco-vieira',1,'2024-03-05 15:00:28','2024-03-05 15:00:28','52598b99-8886-463f-86d4-2487865c473e'),(205,205,1,'casa-de-paco-vieira','galeria/casa-de-paco-vieira',1,'2024-03-05 15:00:36','2024-03-05 15:00:36','1441295a-8753-44d4-b871-5cef437abb8f'),(206,206,1,'casa-de-paco-vieira-2','galeria/casa-de-paco-vieira-2',1,'2024-03-05 15:00:40','2024-03-05 15:00:40','754d3891-5887-4892-acbb-97c93e84cc01'),(207,207,1,'casa-de-paco-vieira-2','galeria/casa-de-paco-vieira-2',1,'2024-03-05 15:00:40','2024-03-05 15:00:40','f29418fc-a45c-47b6-b892-a18c99e6077c'),(209,209,1,'alminhas','galeria/alminhas',1,'2024-03-05 15:00:56','2024-03-05 15:00:56','06bb3444-23f8-4fb1-ab30-67bbf6ec45e3'),(210,210,1,'antiga-escola-primaria','galeria/antiga-escola-primaria',1,'2024-03-05 15:01:08','2024-03-05 15:01:37','b7e7b864-e6ad-48bb-9876-9a06a32d3612'),(211,211,1,'alminhas-2','galeria/alminhas-2',1,'2024-03-05 15:01:08','2024-03-05 15:01:08','03c23494-6189-496b-b0a0-9076887560b9'),(213,213,1,'antiga-escola-primária','galeria/antiga-escola-primária',1,'2024-03-05 15:01:18','2024-03-05 15:01:18','22d1c47c-a967-49c1-b3e7-c29be6f2a271'),(215,215,1,'antiga-escola-primaria','galeria/antiga-escola-primaria',1,'2024-03-05 15:01:38','2024-03-05 15:01:38','616dfff0-2f42-40e1-b3ec-87ac9f31329f'),(216,216,1,'empreendimentos','galeria/empreendimentos',1,'2024-03-05 15:01:45','2024-03-05 15:01:58','af868cef-8de4-4c8b-a570-4fa20201c195'),(217,217,1,'casa-de-paco-vieira-2-2','galeria/casa-de-paco-vieira-2-2',1,'2024-03-05 15:01:45','2024-03-05 15:01:45','e94a99d2-a55b-4ce0-a30d-cd9948efa865'),(219,219,1,'empreendimentos','galeria/empreendimentos',1,'2024-03-05 15:01:58','2024-03-05 15:01:58','22e97981-ec10-4b17-8351-24f9f0013e3d'),(220,220,1,'corpo-nacional-de-escutas---agrupamento-702-de-mesão---frio','coletividades/corpo-nacional-de-escutas---agrupamento-702-de-mesão---frio',1,'2024-03-05 15:56:57','2024-03-05 16:00:08','1942759d-78f4-4198-8a54-2d444286460f'),(221,221,1,NULL,NULL,1,'2024-03-05 15:57:55','2024-03-05 15:57:55','ce00baec-1f53-4e3d-9f8b-3c2b73a6551c'),(222,222,1,'escola-de-sao-romao-2','coletividades/escola-de-sao-romao-2',1,'2024-03-05 15:58:40','2024-03-05 16:00:26','dab5d4be-e5cf-48ff-a6b9-065e3c6f802b'),(224,224,1,NULL,NULL,1,'2024-03-05 15:59:13','2024-03-05 15:59:13','5c524ecf-cd5a-4f95-8522-ddb6e7c4d4e4'),(225,225,1,'escola-de-sao-romao-3','coletividades/escola-de-sao-romao-3',1,'2024-03-05 15:59:22','2024-03-05 16:00:25','480fb2a6-79a9-44be-b231-fd0fba73f046'),(227,227,1,NULL,NULL,1,'2024-03-05 15:59:57','2024-03-05 15:59:57','158c23da-6e84-4e21-9009-1409f7a2d443'),(228,228,1,'coletividades','coletividades',1,'2024-03-05 16:01:28','2024-03-05 16:01:28','b41e3857-4ed2-4e81-99fb-90cc6559f045'),(229,229,1,'coletividades','coletividades',1,'2024-03-05 16:01:28','2024-03-05 16:01:28','aaa22b29-df73-45d2-899d-79315686a553'),(230,230,1,'coletividades','coletividades',1,'2024-03-05 16:01:28','2024-03-05 16:01:28','402ba55b-035d-4efd-8bdc-9904de542a6e'),(231,231,1,'coletividades','coletividades',1,'2024-03-05 16:01:55','2024-03-05 16:01:55','1a38ab2b-7a90-4888-a7f6-ded4ae2c7ef3'),(233,233,1,'coletividades','coletividades',1,'2024-03-05 16:02:19','2024-03-05 16:02:19','917f2939-fac8-4eb6-9725-be25e9a59eed'),(234,234,1,'atas-da-assembleia-de-freguesia','documentos/atas-da-assembleia-de-freguesia',1,'2024-03-05 16:19:59','2024-03-05 16:20:06','7e561b62-4e20-4b2f-a08e-3f49dae0285d'),(235,235,1,'atas-da-assembleia-de-freguesia','documentos/atas-da-assembleia-de-freguesia',1,'2024-03-05 16:20:07','2024-03-05 16:20:07','bfd0b054-bca6-4916-b4b4-b0cab1b71b99'),(237,237,1,'atas-da-assembleia-de-freguesia','documentos/atas-da-assembleia-de-freguesia',1,'2024-03-05 16:20:19','2024-03-05 16:20:19','f5dbc9f8-1efd-4991-824f-e5eb8552deb7'),(239,239,1,'atas-da-assembleia-de-freguesia','documentos/atas-da-assembleia-de-freguesia',1,'2024-03-05 16:24:05','2024-03-05 16:24:05','435f5118-7fbb-4136-9da0-4e5db2671515'),(241,241,1,'atas-da-assembleia-de-freguesia','documentos/atas-da-assembleia-de-freguesia',1,'2024-03-05 16:49:14','2024-03-05 16:49:14','fee197c8-9eeb-46b4-a06a-a79960f00428'),(243,243,1,'atas-da-assembleia-de-freguesia','documentos/atas-da-assembleia-de-freguesia',1,'2024-03-05 16:52:16','2024-03-05 16:52:16','b1c84d63-1785-4bbf-b9d8-89c6256ee65a'),(244,244,1,'editais','documentos/editais',1,'2024-03-05 16:53:32','2024-03-05 16:53:35','7f4e9869-0e7c-49fe-9a93-09ee1b72e993'),(245,245,1,'editais','documentos/editais',1,'2024-03-05 16:53:37','2024-03-05 16:53:37','37ab16b3-3e5c-4953-a452-642d6afe780f'),(246,246,1,'taxas-freguesia','documentos/taxas-freguesia',1,'2024-03-05 16:54:19','2024-03-05 16:54:22','5f9d2658-6c5f-48b5-b3f1-db4507a288f9'),(247,247,1,'taxas-freguesia','documentos/taxas-freguesia',1,'2024-03-05 16:54:22','2024-03-05 16:54:22','12eda09c-0d71-4add-8303-76911a09b870'),(249,249,1,'taxas-freguesia','documentos/taxas-freguesia',1,'2024-03-05 16:54:28','2024-03-05 16:54:28','3fb91a29-adb8-4bbd-a1cb-2394e5a88371'),(250,250,1,'regulamentos','documentos/regulamentos',1,'2024-03-05 16:54:33','2024-03-05 16:54:36','1bfb4269-4df9-4423-ac40-9282ad9b2ddc'),(251,251,1,'regulamentos','documentos/regulamentos',1,'2024-03-05 16:54:36','2024-03-05 16:54:36','503dc985-9d7e-47e7-9944-7604201c279e'),(253,253,1,'atas-da-assembleia-de-freguesia','documentos/atas-da-assembleia-de-freguesia',1,'2024-03-05 17:15:06','2024-03-05 17:15:06','ca74b516-2081-47b4-9ebd-d915e099a016'),(254,254,1,'coletividades','coletividades',1,'2024-03-05 17:18:09','2024-03-05 17:18:09','f2ba61de-c913-4e9c-8c94-cd827b0d2ad7'),(256,256,1,'coletividades','coletividades',1,'2024-03-05 17:18:20','2024-03-05 17:18:20','861742f4-97d6-45e7-be0c-2835f4c90f15'),(258,258,1,'alminhas','galeria/alminhas',1,'2024-03-05 17:19:36','2024-03-05 17:19:36','4b325369-075d-451b-baa3-0ff0d5ad9210'),(259,259,1,'galeria','galeria',1,'2024-03-05 17:21:32','2024-03-05 17:21:32','0121972d-aa16-4bb6-8075-3265d3f91f2e'),(261,261,1,'galeria','galeria',1,'2024-03-05 17:21:41','2024-03-05 17:21:41','f627ad12-9814-4f7d-9320-d8ca97539598'),(262,262,1,'noticias','noticias',1,'2024-03-05 17:22:34','2024-03-05 17:22:34','60acff51-1e27-4f06-9087-02f0a3f62b15'),(263,263,1,'noticias','noticias',1,'2024-03-05 17:22:47','2024-03-05 17:22:47','d6f98ddc-6360-4763-80bf-92cc3bcbd1c1'),(265,265,1,'noticias','noticias',1,'2024-03-05 17:23:14','2024-03-05 17:23:14','d2d79545-989d-4800-8ec8-f64066d958dc'),(267,267,1,'noticias','noticias',1,'2024-03-05 17:23:24','2024-03-05 17:23:24','d50df629-04e0-4b19-a313-e2f78ae22032'),(269,269,1,'noticias','noticias',1,'2024-03-05 17:23:48','2024-03-05 17:23:48','2a595bd4-7321-4e65-83e3-b9ffa4d55b8f'),(270,270,1,'cidadao','cidadao',1,'2024-03-05 17:24:55','2024-03-05 17:24:55','9c0b5edb-987d-47a1-b417-1d21bcc9fe41'),(271,271,1,'cidadao','cidadao',1,'2024-03-05 17:25:03','2024-03-05 17:25:03','d29c5e31-3e90-4627-bd6e-9f2f67285d58'),(272,272,1,'inicio','__home__',1,'2024-03-05 17:25:27','2024-03-05 17:25:27','47676edb-49cc-4831-b87a-74315ca6b801'),(273,273,1,'eventos','eventos',1,'2024-03-05 17:26:03','2024-03-05 17:26:03','a83c0aa8-d1c0-4feb-8116-182eac249c82'),(276,276,1,'eventos','eventos',1,'2024-03-05 17:26:23','2024-03-05 17:26:23','a9527704-5981-4777-91d4-ff77776a3b0d'),(277,277,1,'cidadao','cidadao',1,'2024-03-05 17:26:56','2024-03-05 17:26:56','3f1b124a-bcac-4e8b-aa60-159cf56d7469'),(278,278,1,'cidadao','cidadao',1,'2024-03-05 17:27:05','2024-03-05 17:27:05','6175fb73-2eda-4eec-903d-28ae048a3655'),(280,280,1,'intervenção-rua-de-são-pedro','noticias/intervenção-rua-de-são-pedro',1,'2024-03-08 15:48:22','2024-03-08 15:48:22','20592755-9e98-456f-8e02-76b92afb8ae5'),(282,282,1,'intervençao-rua-de-sao-pedro','noticias/intervençao-rua-de-sao-pedro',1,'2024-03-08 15:48:36','2024-03-08 15:48:36','76c0f5fd-015e-442e-a9a2-2cfe6700d354'),(283,283,1,'historia','historia',1,'2024-03-08 15:50:23','2024-03-08 15:50:50','c456f069-cd40-4a02-815b-21bb9314c4d9'),(284,284,1,NULL,NULL,1,'2024-03-08 15:51:55','2024-03-08 15:51:55','1c30326e-eb1a-4e76-928c-6aab40784ac0'),(285,285,1,'historia','historia',1,'2024-03-08 15:52:24','2024-03-08 15:52:24','dfb2c9b0-c74d-4911-ac7a-71188c842ad3'),(287,287,1,'historia','historia',1,'2024-03-08 15:52:49','2024-03-08 15:52:49','b77a5dff-d340-4ca3-9fae-2bb5bf8c2e5f'),(288,288,1,'heraldica','heraldica',1,'2024-03-08 16:00:27','2024-03-08 16:01:08','d27ffaa9-a2cf-4325-a161-1c10c4ec43c8'),(289,289,1,NULL,NULL,1,'2024-03-08 16:02:35','2024-03-08 16:02:35','f67b41e4-1d03-4dd2-9518-2d98529f7b14'),(290,290,1,NULL,NULL,1,'2024-03-08 16:03:55','2024-03-08 16:03:55','4a5f6b82-7dfa-4638-b448-a6609d9abff4'),(291,291,1,'heraldica','heraldica',1,'2024-03-08 16:04:17','2024-03-08 16:04:17','3e501721-fe57-4331-9b44-fbab3136b1d5'),(293,293,1,'heraldica','heraldica',1,'2024-03-08 16:04:23','2024-03-08 16:04:23','5d4ed055-e572-41cc-bd0a-62602353a18d'),(295,295,1,'heraldica','heraldica',1,'2024-03-08 16:04:45','2024-03-08 16:04:45','580e1504-3820-4766-950c-28d57b5922d4'),(296,296,1,'patrimonio-arquitectonico','patrimonio-arquitectonico',1,'2024-03-08 16:09:44','2024-03-08 16:09:58','6a6c3681-9bba-40f1-b739-68035fea0df3'),(297,297,1,'patrimonio-arquitectonico','patrimonio-arquitectonico',1,'2024-03-08 16:10:01','2024-03-08 16:10:01','ccb7b357-eab1-4814-997b-64a652fbe419'),(299,299,1,NULL,NULL,1,'2024-03-08 16:11:02','2024-03-08 16:11:02','c7fb741c-fd23-4fb5-8992-77728d069b52'),(300,300,1,NULL,NULL,1,'2024-03-08 16:11:31','2024-03-08 16:11:31','992443e4-db33-4e25-9f1b-a87017611817'),(301,301,1,NULL,NULL,1,'2024-03-08 16:11:31','2024-03-08 16:11:31','da8e3c43-1b47-4557-91af-8bf49ff3de5e'),(302,302,1,NULL,NULL,1,'2024-03-08 16:11:32','2024-03-08 16:11:32','819d9deb-5fd5-448f-abb1-b50c81ca62d9'),(303,303,1,NULL,NULL,1,'2024-03-08 16:11:33','2024-03-08 16:11:33','f230a2dc-2fa9-4652-bca5-26edf59f4742'),(304,304,1,'patrimonio-arquitectonico','patrimonio-arquitectonico',1,'2024-03-08 16:14:12','2024-03-08 16:14:12','4f3acfc6-5162-461c-83db-43e686a76e44'),(305,305,1,'patrimonio-natural','patrimonio-natural',1,'2024-03-08 16:15:38','2024-03-08 16:15:42','67f06c1b-1760-42ec-a1f4-3a0ca10cb763'),(306,306,1,NULL,NULL,1,'2024-03-08 16:16:18','2024-03-08 16:16:18','218fc086-c64c-4ebc-a8dd-bbb3a1eba91c'),(307,307,1,NULL,NULL,1,'2024-03-08 16:16:18','2024-03-08 16:16:18','52ad55cf-e465-4182-9d98-d98234aa0145'),(308,308,1,'patrimonio-natural','patrimonio-natural',1,'2024-03-08 16:17:15','2024-03-08 16:17:15','c7e1248c-3418-499c-94ab-372837cf717d'),(310,310,1,'patrimonio-natural','patrimonio-natural',1,'2024-03-08 16:18:37','2024-03-08 16:18:37','6092dfb0-d160-4b3b-a82a-f05b9320dc14'),(311,311,1,'junta-de-freguesia','junta-de-freguesia',1,'2024-03-08 16:46:54','2024-03-08 16:47:10','746d4e48-ebca-45ea-a769-94329baf4594'),(312,312,1,'junta-de-freguesia','junta-de-freguesia',1,'2024-03-08 16:47:26','2024-03-08 16:47:26','66b91a8d-0a6a-4fa5-b643-a7eb8a8f4385'),(314,314,1,'junta-de-freguesia','junta-de-freguesia',1,'2024-03-08 16:47:31','2024-03-08 16:47:31','156fff38-5b69-4eec-a6a2-161cbb0c9b5a'),(316,316,1,'junta-de-freguesia','junta-de-freguesia',1,'2024-03-08 16:51:12','2024-03-08 16:51:12','96338789-5ed7-424b-9ecc-ce4b72f7f55e'),(317,317,1,'freguesia','freguesia',1,'2024-03-08 17:02:27','2024-03-08 17:02:57','81263d17-f83c-451d-b35a-86ea98d9c39d'),(318,318,1,'freguesia','freguesia',1,'2024-03-08 17:02:57','2024-03-08 17:02:57','02ff7810-5caf-4586-9686-11313d3f7a61'),(319,319,1,'mensagem-do-presidente','mensagem-do-presidente',1,'2024-03-08 17:09:39','2024-03-08 17:09:57','270534bd-db67-484c-b269-a390f5a31c01'),(320,320,1,'mensagem-do-presidente','mensagem-do-presidente',1,'2024-03-08 17:09:57','2024-03-08 17:09:57','5274782b-b495-4283-b699-ecedf18bf559'),(322,322,1,'mensagem-do-presidente','mensagem-do-presidente',1,'2024-03-08 17:10:25','2024-03-08 17:10:25','2a71db0b-60c9-43e9-b5e9-59f145482e08'),(323,323,1,'john-doe','membros-da-assembleia/john-doe',1,'2024-03-08 17:17:23','2024-03-08 17:17:31','4c3e64f8-7d1b-4b11-85df-ee01a0962438'),(324,324,1,NULL,NULL,1,'2024-03-08 17:19:21','2024-03-08 17:19:21','bc4e647c-0800-4e41-847c-a15ba232383d'),(326,326,1,'john-doe-2','membros-da-assembleia/john-doe-2',1,'2024-03-08 17:19:32','2024-03-08 17:19:38','ed7f1e03-c213-4c13-b90b-d453714ddd0c'),(327,327,1,NULL,NULL,1,'2024-03-08 17:19:50','2024-03-08 17:19:50','7419889c-2115-433b-8b63-4370847eec8b'),(329,329,1,'john-doe-3','membros-da-assembleia/john-doe-3',1,'2024-03-08 17:19:56','2024-03-08 17:19:57','f21a6e6c-e470-4221-a960-518cb195e07d'),(331,331,1,NULL,NULL,1,'2024-03-08 17:20:23','2024-03-08 17:20:23','2e6a8737-1c53-4277-bfaf-893d4615ce9c'),(333,333,1,'john-doe-3-2','membros-da-assembleia/john-doe-3-2',1,'2024-03-08 17:20:48','2024-03-08 17:20:49','a54ea9ae-8987-4408-bfe6-540382e99085'),(335,335,1,NULL,NULL,1,'2024-03-08 17:21:17','2024-03-08 17:21:17','56c3325d-4cd8-4909-9f3a-6ddf7bd9e1c2'),(336,336,1,'john-doe-3-3','membros-da-assembleia/john-doe-3-3',1,'2024-03-08 17:21:23','2024-03-08 17:21:24','feebaa36-da77-4303-b278-89de18ded0c9'),(338,338,1,NULL,NULL,1,'2024-03-08 17:21:46','2024-03-08 17:21:46','9eeecc9d-208c-4be7-a6bf-3c1516595524'),(339,339,1,'assembleia-de-freguesia','assembleia-de-freguesia',1,'2024-03-08 17:29:25','2024-03-08 17:29:48','1cb531df-81ee-4e85-94ed-fc4c38b60458'),(340,340,1,'assembleia-de-freguesia','assembleia-de-freguesia',1,'2024-03-08 17:29:48','2024-03-08 17:29:48','7a150fe5-e532-4fc1-8ab6-a833cc6c26e4'),(342,342,1,'jose-pereira-da-silva','executivo/jose-pereira-da-silva',1,'2024-03-08 17:33:32','2024-03-08 17:33:39','280c0725-ae23-4ca6-a8d7-eaa17fecab95'),(343,343,1,NULL,NULL,1,'2024-03-08 17:33:54','2024-03-08 17:33:54','9f803df9-3155-4a61-b884-13794df74e52'),(344,344,1,'jose-pereira-da-silva-2','executivo/jose-pereira-da-silva-2',1,'2024-03-08 17:34:16','2024-03-08 17:34:17','23196e9f-9c5d-4db3-98ba-73d57d3313bc'),(346,346,1,NULL,NULL,1,'2024-03-08 17:34:32','2024-03-08 17:34:32','c189bd3f-758f-4f42-a671-875971ed032a'),(347,347,1,'jose-pereira-da-silva-3','executivo/jose-pereira-da-silva-3',1,'2024-03-08 17:34:47','2024-03-08 17:46:36','9ca2875e-f094-479c-b36f-093daeaf779c'),(349,349,1,NULL,NULL,1,'2024-03-08 17:35:09','2024-03-08 17:35:09','3bb92e15-9da5-4405-9b7e-3af939fac2d9'),(350,350,1,'assembleia-de-freguesia','assembleia-de-freguesia',1,'2024-03-08 17:35:32','2024-03-08 17:35:32','f90de598-9793-44a3-800c-056ea025edb7'),(351,351,1,'executivo','executivo',1,'2024-03-08 17:35:37','2024-03-08 17:36:00','8abcf0c2-825e-42ab-bf7e-a6251fbfe195'),(352,352,1,'executivo','executivo',1,'2024-03-08 17:36:00','2024-03-08 17:36:00','a34e2b09-96e5-4f0f-bfcb-ac24d1054b7b'),(353,353,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:49:48','2024-03-08 17:49:48','3da28675-3115-4e87-b019-2305171ce0c0'),(354,354,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:49:48','2024-03-08 17:49:48','e1815ed3-040b-4c9d-b9db-8a868867f14f'),(355,355,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:49:48','2024-03-08 17:49:48','762b144a-463b-4e56-ab60-e4b97831c30f'),(356,356,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:50:38','2024-03-08 17:50:38','7bd8e877-d1ce-4cb8-b955-b52002e110a6'),(358,358,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:51:18','2024-03-08 17:51:18','9c4e0665-95b9-4f15-8f1f-9021a36a0098'),(360,360,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:51:25','2024-03-08 17:51:25','f92645a4-d534-4e0f-bb06-efcb83b2bc96'),(362,362,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:53:55','2024-03-08 17:53:55','1060bd36-cc15-4fc6-86f4-9af1a85f665d'),(363,363,1,'politica-de-privacidade','politica-de-privacidade',1,'2024-03-08 17:57:00','2024-03-08 17:57:00','6da614ec-2a4c-43c3-af26-e787ab1ba0bf'),(364,364,1,'atendimento-geral','atendimento-geral',1,'2024-03-11 10:59:39','2024-03-11 10:59:46','bbf5952d-43f0-420d-a560-1ed6888fc05c'),(365,365,1,'atendimento-geral','atendimento-geral',1,'2024-03-11 10:59:52','2024-03-11 10:59:52','0dcd6958-7db7-457a-9ab1-132412ea229b'),(367,367,1,'atendimento-geral','atendimento-geral',1,'2024-03-11 11:00:47','2024-03-11 11:00:47','8b6745e1-ad12-4168-95d6-2e43973a5975'),(368,368,1,'espaco-cidadao','espaco-cidadao',1,'2024-03-11 11:05:11','2024-03-11 11:05:20','e7489eca-7d13-48f7-ae02-782b2e4b3ad3'),(369,369,1,NULL,NULL,1,'2024-03-11 11:06:20','2024-03-11 11:06:20','c537ec7f-1e3f-4810-ac89-b66aeead3106'),(370,370,1,'espaco-cidadao','espaco-cidadao',1,'2024-03-11 11:09:58','2024-03-11 11:09:58','c14e45af-7fe9-4898-866d-ed5ed8b238ab'),(372,372,1,'espaco-cidadao','espaco-cidadao',1,'2024-03-11 11:10:56','2024-03-11 11:10:56','3ebdfdc6-830a-4d0d-8637-ec3ebf75082b'),(373,373,1,'espaco-cidadao','espaco-cidadao',1,'2024-03-11 11:11:42','2024-03-11 11:11:42','c346f3c3-777b-4dc5-bb7b-b6e1649925de'),(374,374,1,'payshop','payshop',1,'2024-03-11 11:14:44','2024-03-11 11:14:49','0e9e9081-f041-4733-91f3-a2f3ca045385'),(375,375,1,NULL,NULL,1,'2024-03-11 11:16:22','2024-03-11 11:16:22','5890647b-3a56-43b2-9a60-7b913f18c732'),(376,376,1,'payshop','payshop',1,'2024-03-11 11:17:20','2024-03-11 11:17:20','90b91a4f-0d2c-40e4-a93f-0af222b1c8ec'),(378,378,1,'payshop','payshop',1,'2024-03-11 11:18:55','2024-03-11 11:18:55','a1494364-3932-42c6-9e02-4f89b81ec2e2'),(379,379,1,'payshop','payshop',1,'2024-03-11 11:19:05','2024-03-11 11:19:05','3d93690e-c2dc-4a55-8c29-dc7c0768d5aa'),(381,381,1,'payshop','payshop',1,'2024-03-11 11:19:47','2024-03-11 11:19:47','57e669fa-1ff8-4828-a13e-84d20ed1325a'),(382,382,1,'pagaqui','pagaqui',1,'2024-03-11 11:20:23','2024-03-11 11:20:33','c2954310-b589-43e8-ae24-4735aade24b8'),(383,383,1,NULL,NULL,1,'2024-03-11 11:20:56','2024-03-11 11:20:56','ba979c36-be1e-41e6-aaf5-02dc2ea22465'),(384,384,1,'pagaqui','pagaqui',1,'2024-03-11 11:21:36','2024-03-11 11:21:36','fe627a68-0a48-40fc-a4f1-ec753d751f6a'),(386,386,1,'pagaqui','pagaqui',1,'2024-03-11 11:21:42','2024-03-11 11:21:42','d29bfe8c-72fe-4143-9e6d-3a7bfcfdce04'),(388,388,1,'pagaqui','pagaqui',1,'2024-03-11 11:22:37','2024-03-11 11:22:37','6c2cae6e-2f91-4438-b98d-00df2517d02f'),(389,389,1,'pagaqui','pagaqui',1,'2024-03-11 11:22:46','2024-03-11 11:22:46','59b9c387-bf4c-48c9-ab8d-b205cc1bc76e');
/*!40000 ALTER TABLE `elements_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entries`
--

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entries` VALUES (14,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-20 17:13:27','2024-02-20 17:13:27'),(15,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-20 17:13:27','2024-02-20 17:13:27'),(16,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-20 17:13:27','2024-02-20 17:13:27'),(17,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-20 17:13:53','2024-02-20 17:13:53'),(19,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-20 17:14:19','2024-02-20 17:14:19'),(49,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-22 18:00:36','2024-02-22 18:00:40'),(50,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-22 18:00:41','2024-02-22 18:00:41'),(59,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-22 18:08:49','2024-02-22 18:08:49'),(61,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-22 18:08:58','2024-02-22 18:08:58'),(62,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-22 18:10:24','2024-02-22 18:10:24'),(65,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-22 18:11:26','2024-02-22 18:11:26'),(66,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:19:24','2024-02-26 16:19:24'),(67,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:19:59','2024-02-26 16:19:59'),(69,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:20:11','2024-02-26 16:20:11'),(70,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:20:25','2024-02-26 16:20:25'),(71,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:21:09','2024-02-26 16:21:09'),(73,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:21:28','2024-02-26 16:21:28'),(74,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:22:10','2024-02-26 16:22:10'),(76,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:23:46','2024-02-26 16:23:46'),(77,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:27:02','2024-02-26 16:27:02'),(79,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:27:16','2024-02-26 16:27:16'),(80,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-02-26 16:27:56','2024-02-26 16:27:56'),(81,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-02-27 17:20:13','2024-02-27 17:20:13'),(82,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-02-27 17:20:14','2024-02-27 17:20:14'),(83,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-02-27 17:20:14','2024-02-27 17:20:14'),(84,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-02-27 17:20:29','2024-02-27 17:20:29'),(86,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-02-27 17:23:16','2024-02-27 17:23:16'),(87,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-02-27 17:23:22','2024-02-27 17:23:22'),(89,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-02-27 17:23:43','2024-02-27 17:23:43'),(90,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-02-27 17:58:30','2024-02-27 17:58:53'),(91,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-27 17:58:30','2024-02-27 17:58:30'),(93,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-02-27 17:58:54','2024-02-27 17:58:54'),(94,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-02-27 17:59:06','2024-02-27 17:59:06'),(96,2,NULL,2,1,'2024-02-22 18:00:00',NULL,NULL,'2024-02-27 18:01:13','2024-02-27 18:01:13'),(98,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-02-27 18:01:18','2024-02-27 18:01:18'),(99,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-03-01 11:05:07','2024-03-01 11:05:07'),(101,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-03-01 11:22:05','2024-03-01 11:22:05'),(102,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-03-01 11:22:34','2024-03-01 11:22:34'),(103,2,NULL,2,1,'2024-02-17 18:00:00',NULL,NULL,'2024-03-01 14:31:51','2024-03-01 14:32:47'),(104,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-03-01 14:31:52','2024-03-01 14:31:52'),(106,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-03-01 14:32:01','2024-03-01 14:32:01'),(108,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-03-01 14:32:21','2024-03-01 14:32:21'),(109,2,NULL,2,1,'2024-02-19 18:00:00',NULL,NULL,'2024-03-01 14:32:28','2024-03-01 14:32:54'),(110,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-03-01 14:32:28','2024-03-01 14:32:28'),(112,2,NULL,2,1,'2024-02-15 18:00:00',NULL,NULL,'2024-03-01 14:32:39','2024-03-01 14:32:39'),(114,2,NULL,2,1,'2024-02-17 18:00:00',NULL,NULL,'2024-03-01 14:32:47','2024-03-01 14:32:47'),(116,2,NULL,2,1,'2024-02-19 18:00:00',NULL,NULL,'2024-03-01 14:32:54','2024-03-01 14:32:54'),(118,2,NULL,2,1,'2024-02-19 18:00:00',NULL,NULL,'2024-03-01 14:33:11','2024-03-01 14:33:11'),(119,2,NULL,2,1,'2024-02-21 18:00:00',NULL,NULL,'2024-03-01 14:33:20','2024-03-01 14:33:30'),(120,2,NULL,2,1,'2024-02-19 18:00:00',NULL,NULL,'2024-03-01 14:33:20','2024-03-01 14:33:20'),(122,2,NULL,2,1,'2024-02-21 18:00:00',NULL,NULL,'2024-03-01 14:33:30','2024-03-01 14:33:30'),(124,2,NULL,2,1,'2024-02-19 18:00:00',NULL,NULL,'2024-03-01 14:33:54','2024-03-01 14:33:54'),(126,2,NULL,2,1,'2024-02-21 18:00:00',NULL,NULL,'2024-03-01 14:34:35','2024-03-01 14:34:35'),(127,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 16:43:14','2024-03-01 17:05:05'),(128,4,NULL,4,1,'2024-03-03 18:00:00',NULL,NULL,'2024-03-01 16:45:09','2024-03-01 16:45:09'),(132,4,NULL,4,1,'2024-03-03 18:00:00',NULL,NULL,'2024-03-01 16:46:45','2024-03-01 16:46:45'),(133,4,NULL,4,1,'2024-03-03 18:00:00',NULL,NULL,'2024-03-01 16:47:22','2024-03-01 16:47:22'),(135,4,NULL,4,1,'2024-03-01 18:00:00',NULL,NULL,'2024-03-01 17:04:54','2024-03-01 17:04:54'),(137,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 17:05:05','2024-03-01 17:05:05'),(138,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 17:12:48','2024-03-01 17:12:48'),(140,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 17:18:30','2024-03-01 17:18:30'),(141,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-01 17:36:55','2024-03-01 17:36:55'),(142,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-01 17:36:55','2024-03-01 17:36:55'),(143,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-01 17:36:55','2024-03-01 17:36:55'),(144,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-01 17:37:16','2024-03-01 17:37:16'),(145,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-01 17:37:28','2024-03-01 17:37:28'),(146,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-01 17:37:44','2024-03-01 17:37:44'),(147,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 17:45:57','2024-03-01 17:45:57'),(148,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 17:45:57','2024-03-01 17:45:57'),(150,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 17:46:16','2024-03-01 17:46:16'),(152,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 18:00:06','2024-03-01 18:00:06'),(153,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 18:00:22','2024-03-01 18:00:22'),(154,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 18:00:22','2024-03-01 18:00:22'),(155,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 18:00:27','2024-03-01 18:00:27'),(156,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 18:00:27','2024-03-01 18:00:27'),(157,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 18:00:27','2024-03-01 18:00:27'),(158,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-01 18:00:27','2024-03-01 18:00:27'),(160,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-04 10:58:57','2024-03-04 10:58:57'),(162,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-04 10:59:05','2024-03-04 10:59:05'),(164,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-04 10:59:15','2024-03-04 10:59:15'),(166,4,NULL,4,1,'2024-03-01 03:30:00',NULL,NULL,'2024-03-04 10:59:24','2024-03-04 10:59:24'),(168,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-03-04 11:15:48','2024-03-04 11:15:48'),(169,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:21:56','2024-03-04 11:21:56'),(170,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:21:56','2024-03-04 11:21:56'),(171,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:21:56','2024-03-04 11:21:56'),(172,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:22:11','2024-03-04 11:22:11'),(173,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:23:07','2024-03-04 11:23:07'),(174,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:24:53','2024-03-04 11:24:53'),(176,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:25:22','2024-03-04 11:25:22'),(180,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-04 11:26:12','2024-03-04 11:26:12'),(182,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-05 14:28:17','2024-03-05 14:28:17'),(186,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-05 14:29:27','2024-03-05 14:29:27'),(187,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 14:47:55','2024-03-05 14:48:06'),(188,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 14:48:07','2024-03-05 14:48:07'),(190,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 14:48:25','2024-03-05 14:48:25'),(196,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 14:50:13','2024-03-05 14:50:13'),(197,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 14:53:10','2024-03-05 14:53:10'),(198,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 14:53:10','2024-03-05 14:53:10'),(199,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 14:53:10','2024-03-05 14:53:10'),(200,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 14:53:24','2024-03-05 14:53:24'),(201,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 14:55:53','2024-03-05 14:55:53'),(203,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 14:56:28','2024-03-05 14:56:28'),(204,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:00:28','2024-03-05 15:00:28'),(205,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:00:36','2024-03-05 15:00:36'),(206,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:00:40','2024-03-05 15:00:40'),(207,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:00:40','2024-03-05 15:00:40'),(209,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:00:56','2024-03-05 15:00:56'),(210,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:01:08','2024-03-05 15:01:08'),(211,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:01:08','2024-03-05 15:01:08'),(213,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:01:18','2024-03-05 15:01:18'),(215,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:01:38','2024-03-05 15:01:38'),(216,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:01:45','2024-03-05 15:01:45'),(217,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:01:45','2024-03-05 15:01:45'),(219,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 15:01:58','2024-03-05 15:01:58'),(228,9,NULL,9,NULL,'2024-03-05 16:01:00',NULL,NULL,'2024-03-05 16:01:28','2024-03-05 16:01:28'),(229,9,NULL,9,NULL,'2024-03-05 16:01:00',NULL,NULL,'2024-03-05 16:01:28','2024-03-05 16:01:28'),(230,9,NULL,9,NULL,'2024-03-05 16:01:00',NULL,NULL,'2024-03-05 16:01:28','2024-03-05 16:01:28'),(231,9,NULL,9,NULL,'2024-03-05 16:01:00',NULL,NULL,'2024-03-05 16:01:55','2024-03-05 16:01:55'),(233,9,NULL,9,NULL,'2024-03-05 16:01:00',NULL,NULL,'2024-03-05 16:02:19','2024-03-05 16:02:19'),(234,10,NULL,10,1,'2024-03-05 16:20:00',NULL,NULL,'2024-03-05 16:19:59','2024-03-05 16:20:06'),(235,10,NULL,10,1,'2024-03-05 16:20:00',NULL,NULL,'2024-03-05 16:20:07','2024-03-05 16:20:07'),(237,10,NULL,10,1,'2024-03-05 16:20:00',NULL,NULL,'2024-03-05 16:20:19','2024-03-05 16:20:19'),(239,10,NULL,10,1,'2024-03-05 16:20:00',NULL,NULL,'2024-03-05 16:24:05','2024-03-05 16:24:05'),(241,10,NULL,10,1,'2024-03-05 16:20:00',NULL,NULL,'2024-03-05 16:49:14','2024-03-05 16:49:14'),(243,10,NULL,10,1,'2024-03-05 16:20:00',NULL,NULL,'2024-03-05 16:52:16','2024-03-05 16:52:16'),(244,10,NULL,10,1,'2024-03-05 16:53:00',NULL,NULL,'2024-03-05 16:53:32','2024-03-05 16:53:37'),(245,10,NULL,10,1,'2024-03-05 16:53:00',NULL,NULL,'2024-03-05 16:53:37','2024-03-05 16:53:37'),(246,10,NULL,10,1,'2024-03-05 16:54:00',NULL,NULL,'2024-03-05 16:54:19','2024-03-05 16:54:22'),(247,10,NULL,10,1,'2024-03-05 16:54:00',NULL,NULL,'2024-03-05 16:54:22','2024-03-05 16:54:22'),(249,10,NULL,10,1,'2024-03-05 16:54:00',NULL,NULL,'2024-03-05 16:54:28','2024-03-05 16:54:28'),(250,10,NULL,10,1,'2024-03-05 16:54:00',NULL,NULL,'2024-03-05 16:54:33','2024-03-05 16:54:36'),(251,10,NULL,10,1,'2024-03-05 16:54:00',NULL,NULL,'2024-03-05 16:54:36','2024-03-05 16:54:36'),(253,10,NULL,10,1,'2024-03-05 16:20:00',NULL,NULL,'2024-03-05 17:15:06','2024-03-05 17:15:06'),(254,9,NULL,9,NULL,'2024-03-05 16:01:00',NULL,NULL,'2024-03-05 17:18:09','2024-03-05 17:18:09'),(256,9,NULL,9,NULL,'2024-03-05 16:01:00',NULL,NULL,'2024-03-05 17:18:20','2024-03-05 17:18:20'),(258,7,NULL,7,1,'2024-03-05 14:48:00',NULL,NULL,'2024-03-05 17:19:36','2024-03-05 17:19:36'),(259,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 17:21:32','2024-03-05 17:21:32'),(261,8,NULL,8,NULL,'2024-03-05 14:53:00',NULL,NULL,'2024-03-05 17:21:41','2024-03-05 17:21:41'),(262,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-03-05 17:22:34','2024-03-05 17:22:34'),(263,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-03-05 17:22:47','2024-03-05 17:22:47'),(265,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-03-05 17:23:14','2024-03-05 17:23:14'),(267,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-03-05 17:23:24','2024-03-05 17:23:24'),(269,3,NULL,3,NULL,'2024-02-27 17:20:00',NULL,NULL,'2024-03-05 17:23:48','2024-03-05 17:23:48'),(270,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-05 17:24:55','2024-03-05 17:24:55'),(271,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-05 17:25:03','2024-03-05 17:25:03'),(272,1,NULL,1,NULL,'2024-02-20 17:13:00',NULL,NULL,'2024-03-05 17:25:27','2024-03-05 17:25:27'),(273,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-05 17:26:03','2024-03-05 17:26:03'),(276,5,NULL,5,NULL,'2024-03-01 17:36:00',NULL,NULL,'2024-03-05 17:26:23','2024-03-05 17:26:23'),(277,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-05 17:26:56','2024-03-05 17:26:56'),(278,6,NULL,6,NULL,'2024-03-04 11:21:00',NULL,NULL,'2024-03-05 17:27:05','2024-03-05 17:27:05'),(280,2,NULL,2,1,'2024-02-21 18:00:00',NULL,NULL,'2024-03-08 15:48:22','2024-03-08 15:48:22'),(282,2,NULL,2,1,'2024-02-21 18:00:00',NULL,NULL,'2024-03-08 15:48:36','2024-03-08 15:48:36'),(283,11,NULL,11,1,'2024-03-08 15:52:00',NULL,NULL,'2024-03-08 15:50:23','2024-03-08 15:52:24'),(285,11,NULL,11,1,'2024-03-08 15:52:00',NULL,NULL,'2024-03-08 15:52:24','2024-03-08 15:52:24'),(287,11,NULL,11,1,'2024-03-08 15:52:00',NULL,NULL,'2024-03-08 15:52:49','2024-03-08 15:52:49'),(288,11,NULL,11,1,'2024-03-08 16:04:00',NULL,NULL,'2024-03-08 16:00:27','2024-03-08 16:04:16'),(291,11,NULL,11,1,'2024-03-08 16:04:00',NULL,NULL,'2024-03-08 16:04:17','2024-03-08 16:04:17'),(293,11,NULL,11,1,'2024-03-08 16:04:00',NULL,NULL,'2024-03-08 16:04:23','2024-03-08 16:04:23'),(295,11,NULL,11,1,'2024-03-08 16:04:00',NULL,NULL,'2024-03-08 16:04:45','2024-03-08 16:04:45'),(296,11,NULL,11,1,'2024-03-08 16:10:00',NULL,NULL,'2024-03-08 16:09:44','2024-03-08 16:10:01'),(297,11,NULL,11,1,'2024-03-08 16:10:00',NULL,NULL,'2024-03-08 16:10:01','2024-03-08 16:10:01'),(304,11,NULL,11,1,'2024-03-08 16:10:00',NULL,NULL,'2024-03-08 16:14:12','2024-03-08 16:14:12'),(305,11,NULL,11,1,'2024-03-08 16:17:00',NULL,NULL,'2024-03-08 16:15:38','2024-03-08 16:17:15'),(308,11,NULL,11,1,'2024-03-08 16:17:00',NULL,NULL,'2024-03-08 16:17:15','2024-03-08 16:17:15'),(310,11,NULL,11,1,'2024-03-08 16:17:00',NULL,NULL,'2024-03-08 16:18:37','2024-03-08 16:18:37'),(311,12,NULL,12,1,'2024-03-08 16:47:00',NULL,NULL,'2024-03-08 16:46:54','2024-03-08 16:47:25'),(312,12,NULL,12,1,'2024-03-08 16:47:00',NULL,NULL,'2024-03-08 16:47:26','2024-03-08 16:47:26'),(314,12,NULL,12,1,'2024-03-08 16:47:00',NULL,NULL,'2024-03-08 16:47:31','2024-03-08 16:47:31'),(316,12,NULL,12,1,'2024-03-08 16:47:00',NULL,NULL,'2024-03-08 16:51:12','2024-03-08 16:51:12'),(317,12,NULL,13,1,'2024-03-08 17:02:00',NULL,NULL,'2024-03-08 17:02:27','2024-03-08 17:02:56'),(318,12,NULL,13,1,'2024-03-08 17:02:00',NULL,NULL,'2024-03-08 17:02:57','2024-03-08 17:02:57'),(319,12,NULL,14,1,'2024-03-08 17:09:00',NULL,NULL,'2024-03-08 17:09:39','2024-03-08 17:09:57'),(320,12,NULL,14,1,'2024-03-08 17:09:00',NULL,NULL,'2024-03-08 17:09:57','2024-03-08 17:09:57'),(322,12,NULL,14,1,'2024-03-08 17:09:00',NULL,NULL,'2024-03-08 17:10:25','2024-03-08 17:10:25'),(339,12,NULL,15,1,'2024-03-08 17:29:00',NULL,NULL,'2024-03-08 17:29:25','2024-03-08 17:29:47'),(340,12,NULL,15,1,'2024-03-08 17:29:00',NULL,NULL,'2024-03-08 17:29:48','2024-03-08 17:29:48'),(350,12,NULL,15,1,'2024-03-08 17:29:00',NULL,NULL,'2024-03-08 17:35:32','2024-03-08 17:35:32'),(351,12,NULL,16,1,'2024-03-08 17:35:00',NULL,NULL,'2024-03-08 17:35:37','2024-03-08 17:35:59'),(352,12,NULL,16,1,'2024-03-08 17:35:00',NULL,NULL,'2024-03-08 17:36:00','2024-03-08 17:36:00'),(353,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:49:48','2024-03-08 17:49:48'),(354,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:49:48','2024-03-08 17:49:48'),(355,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:49:48','2024-03-08 17:49:48'),(356,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:50:38','2024-03-08 17:50:38'),(358,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:51:18','2024-03-08 17:51:18'),(360,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:51:25','2024-03-08 17:51:25'),(362,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:53:55','2024-03-08 17:53:55'),(363,13,NULL,17,NULL,'2024-03-08 17:49:00',NULL,NULL,'2024-03-08 17:57:00','2024-03-08 17:57:00'),(364,14,NULL,18,1,'2024-03-11 10:59:00',NULL,NULL,'2024-03-11 10:59:39','2024-03-11 10:59:52'),(365,14,NULL,18,1,'2024-03-11 10:59:00',NULL,NULL,'2024-03-11 10:59:52','2024-03-11 10:59:52'),(367,14,NULL,18,1,'2024-03-11 10:59:00',NULL,NULL,'2024-03-11 11:00:47','2024-03-11 11:00:47'),(368,14,NULL,18,1,'2024-03-11 11:09:00',NULL,NULL,'2024-03-11 11:05:11','2024-03-11 11:09:57'),(370,14,NULL,18,1,'2024-03-11 11:09:00',NULL,NULL,'2024-03-11 11:09:58','2024-03-11 11:09:58'),(372,14,NULL,18,1,'2024-03-11 11:09:00',NULL,NULL,'2024-03-11 11:10:56','2024-03-11 11:10:56'),(373,14,NULL,18,1,'2024-03-11 11:09:00',NULL,NULL,'2024-03-11 11:11:42','2024-03-11 11:11:42'),(374,14,NULL,18,1,'2024-03-11 11:17:00',NULL,NULL,'2024-03-11 11:14:44','2024-03-11 11:17:19'),(376,14,NULL,18,1,'2024-03-11 11:17:00',NULL,NULL,'2024-03-11 11:17:20','2024-03-11 11:17:20'),(378,14,NULL,18,1,'2024-03-11 11:17:00',NULL,NULL,'2024-03-11 11:18:55','2024-03-11 11:18:55'),(379,14,NULL,18,1,'2024-03-11 11:17:00',NULL,NULL,'2024-03-11 11:19:05','2024-03-11 11:19:05'),(381,14,NULL,18,1,'2024-03-11 11:17:00',NULL,NULL,'2024-03-11 11:19:47','2024-03-11 11:19:47'),(382,14,NULL,18,1,'2024-03-11 11:21:00',NULL,NULL,'2024-03-11 11:20:23','2024-03-11 11:21:36'),(384,14,NULL,18,1,'2024-03-11 11:21:00',NULL,NULL,'2024-03-11 11:21:36','2024-03-11 11:21:36'),(386,14,NULL,18,1,'2024-03-11 11:21:00',NULL,NULL,'2024-03-11 11:21:42','2024-03-11 11:21:42'),(388,14,NULL,18,1,'2024-03-11 11:21:00',NULL,NULL,'2024-03-11 11:22:37','2024-03-11 11:22:37'),(389,14,NULL,18,1,'2024-03-11 11:21:00',NULL,NULL,'2024-03-11 11:22:46','2024-03-11 11:22:46');
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entrytypes`
--

LOCK TABLES `entrytypes` WRITE;
/*!40000 ALTER TABLE `entrytypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entrytypes` VALUES (1,1,5,'Inicio','home',1,'site',NULL,'{section.name|raw}','site',NULL,1,1,'2024-02-20 17:13:26','2024-02-20 17:13:53',NULL,'5916ccc3-289a-425c-ac57-30733262cd95'),(2,2,14,'Padrão','newsDetail',1,'site',NULL,NULL,'site',NULL,1,1,'2024-02-22 17:57:52','2024-03-01 18:11:21',NULL,'d2081389-230a-469c-a831-c3c21e62c4c5'),(3,3,17,'Página de Noticias','news',1,'site',NULL,'{section.name|raw}','site',NULL,1,1,'2024-02-27 17:20:13','2024-02-27 17:20:29',NULL,'3f088581-ae6a-423e-963e-2e4dcfe83e68'),(4,4,18,'Padrão','events',1,'site',NULL,NULL,'site',NULL,1,1,'2024-03-01 16:40:18','2024-03-01 18:14:52',NULL,'f684f595-f3e4-4549-b85e-10ac02db1e84'),(5,5,19,'Página de Eventos','eventsPage',1,'site',NULL,'{section.name|raw}','site',NULL,1,1,'2024-03-01 17:36:55','2024-03-01 17:37:16',NULL,'96c34112-5a91-44da-a395-4437349d77f5'),(6,6,20,'Cidadão','citizen',1,'site',NULL,'{section.name|raw}','site',NULL,1,1,'2024-03-04 11:21:56','2024-03-04 11:22:11',NULL,'e3fd92a7-91c9-445b-b530-1d14a834c397'),(7,7,21,'Padrão','galleryItems',1,'site',NULL,NULL,'site',NULL,1,1,'2024-03-05 14:36:35','2024-03-05 15:17:04',NULL,'3ad082f1-c053-47ac-8a3c-02233591984a'),(8,8,22,'Galeria','gallery',1,'site',NULL,'{section.name|raw}','site',NULL,1,1,'2024-03-05 14:53:10','2024-03-05 14:53:24',NULL,'4817e2ca-af0a-4d5a-b7de-77c98ebd01cc'),(9,9,24,'Coletividades','collectivities',1,'site',NULL,'{section.name|raw}','site',NULL,1,1,'2024-03-05 16:01:28','2024-03-05 16:01:55',NULL,'67c8fccf-b525-4af2-8351-b781b203e37a'),(10,10,25,'Padrão','documents',1,'site',NULL,NULL,'site',NULL,1,1,'2024-03-05 16:19:37','2024-03-05 17:06:58',NULL,'f3fb3a62-e5c1-4f56-bee9-c63b75432096'),(11,11,26,'Padrão','default',1,'site',NULL,NULL,'site',NULL,1,1,'2024-03-08 15:49:32','2024-03-08 15:49:32',NULL,'779a12af-77f7-4a03-b08e-ce735335c60c'),(12,12,27,'Junta Freguesia','juntaFreguesia',1,'site',NULL,NULL,'site',NULL,1,1,'2024-03-08 16:39:02','2024-03-08 16:45:56',NULL,'9cf73107-1556-4f7c-a581-e0fce81cd6ad'),(13,12,28,'Freguesia','freguesia',1,'site',NULL,NULL,'site',NULL,1,2,'2024-03-08 16:46:19','2024-03-08 16:46:19',NULL,'7690ee6a-7c32-4e09-a13f-3f2043bc53e6'),(14,12,29,'Mensagem do Presidente','message',1,'site',NULL,NULL,'site',NULL,1,3,'2024-03-08 17:09:23','2024-03-08 17:09:30',NULL,'6c642c6f-07e2-41b2-97bb-5795209fbd4f'),(15,12,30,'Assembleia de Freguesia','assembleia',1,'site',NULL,NULL,'site',NULL,1,4,'2024-03-08 17:15:33','2024-03-08 17:15:43',NULL,'0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4'),(16,12,32,'Executivo','executive',1,'site',NULL,NULL,'site',NULL,1,5,'2024-03-08 17:32:31','2024-03-08 17:36:30',NULL,'b31ba4f6-7968-4e4d-9e68-902b17cceea8'),(17,13,34,'Política de privacidade','politicaDePrivacidade',1,'site',NULL,'{section.name|raw}','site',NULL,1,1,'2024-03-08 17:49:48','2024-03-08 17:50:38',NULL,'50be33a7-5514-4801-9166-562bbdc1278a'),(18,14,35,'Padrão','cms',1,'site',NULL,NULL,'site',NULL,1,1,'2024-03-11 10:57:42','2024-03-11 10:58:21',NULL,'fd7ce2aa-135d-41ae-acc0-904577c28a4b');
/*!40000 ALTER TABLE `entrytypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldgroups`
--

LOCK TABLES `fieldgroups` WRITE;
/*!40000 ALTER TABLE `fieldgroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldgroups` VALUES (1,'Common','2024-02-16 17:40:41','2024-02-16 17:40:41',NULL,'52344ede-a26d-4fbf-a81c-5ddb1d312483'),(2,'head','2024-02-19 12:46:08','2024-02-19 12:46:08',NULL,'de4c86cf-d413-4cfc-859c-cdce25dfdaf8'),(3,'Organização','2024-02-19 12:53:35','2024-02-19 12:53:35',NULL,'511058c6-db65-4bb6-8c7f-a422f0f4e799'),(4,'Header','2024-02-19 13:01:07','2024-02-19 13:01:07',NULL,'81696338-303f-42d6-b600-1ec70299f494'),(5,'Socials','2024-02-22 14:23:35','2024-02-22 14:23:35',NULL,'89b46165-3f9e-42c0-87e6-9d5d9a7a3d03'),(6,'Footer','2024-02-22 14:37:29','2024-02-22 14:37:29',NULL,'0473bf53-6e6d-40d6-ae4e-0dd5aa96b946'),(7,'Coluna da Esquerda','2024-02-22 14:54:58','2024-02-22 14:54:58',NULL,'8aae1370-a834-4c6a-b3ba-eaef8066888c'),(8,'Coluna da Direita','2024-02-22 15:29:38','2024-02-22 15:29:38',NULL,'4e478309-6e01-4647-bea3-aac12ead8ed8'),(9,'Noticias','2024-02-22 18:03:44','2024-02-22 18:03:44',NULL,'2c01c9e9-499b-49d6-b238-72387ed5cf8a'),(10,'Eventos','2024-03-01 16:42:15','2024-03-01 16:42:15',NULL,'b97ab278-fecb-4566-b48b-b5d24c5ca93f'),(11,'Junta','2024-03-08 17:22:17','2024-03-08 17:22:17',NULL,'415b16ce-c08e-43e1-9fe7-17e425d8017e');
/*!40000 ALTER TABLE `fieldgroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayoutfields`
--

LOCK TABLES `fieldlayoutfields` WRITE;
/*!40000 ALTER TABLE `fieldlayoutfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayoutfields` VALUES (26,4,11,13,0,0,'2024-02-20 17:50:51','2024-02-20 17:50:51','0e83c284-0046-4406-baed-9814b6112db7'),(27,4,11,14,0,1,'2024-02-20 17:50:51','2024-02-20 17:50:51','0cea7076-bbe4-4f63-b9bc-1d7f150b89d7'),(45,6,19,17,0,0,'2024-02-22 14:18:25','2024-02-22 14:18:25','275201e6-eecf-41a7-b410-6ff784aba190'),(46,6,19,16,0,1,'2024-02-22 14:18:25','2024-02-22 14:18:25','7cba2211-65c9-4b51-98e3-c32e2f577234'),(51,8,23,20,0,0,'2024-02-22 14:26:45','2024-02-22 14:26:45','b9b9d624-1c82-44e1-b662-97e79bce49cf'),(52,8,23,19,0,1,'2024-02-22 14:26:45','2024-02-22 14:26:45','3bd8111f-659e-4094-9c8f-f2efa43328da'),(53,8,23,21,0,2,'2024-02-22 14:26:45','2024-02-22 14:26:45','c4157a52-d609-425a-bf77-061510a5e17f'),(61,11,30,25,0,0,'2024-02-22 15:02:57','2024-02-22 15:02:57','439a4a19-ccb7-497a-bd1a-834800c176c3'),(62,11,30,24,0,1,'2024-02-22 15:02:57','2024-02-22 15:02:57','ebfb602a-49b5-47f1-a1e4-721a33cea9ab'),(63,10,31,23,0,0,'2024-02-22 15:29:00','2024-02-22 15:29:00','0986ed4b-83b0-4a96-b75c-0c6502e5840b'),(64,9,32,22,0,0,'2024-02-22 15:29:00','2024-02-22 15:29:00','0b191cb5-cc36-439d-b4e6-dcd0a35cf552'),(65,3,33,6,0,0,'2024-02-22 15:29:00','2024-02-22 15:29:00','d04a2ba5-1b5d-481d-9173-af4a633709bb'),(66,3,33,7,0,1,'2024-02-22 15:29:00','2024-02-22 15:29:00','d5f90ac4-0650-4c21-9c2c-b99562120fda'),(67,3,34,8,0,0,'2024-02-22 15:29:00','2024-02-22 15:29:00','20c7fe79-5f62-4629-bf52-a3650a847d40'),(68,3,34,9,0,1,'2024-02-22 15:29:00','2024-02-22 15:29:00','bc7e4252-beaf-4f84-8624-646bcf2808a0'),(69,3,34,10,0,2,'2024-02-22 15:29:00','2024-02-22 15:29:00','43d55d56-ea30-4928-bc15-7aec7728221e'),(70,3,34,11,0,3,'2024-02-22 15:29:00','2024-02-22 15:29:00','6ae2d4e9-7d1a-43a6-b1a6-9d96b34b44eb'),(71,3,34,12,0,4,'2024-02-22 15:29:00','2024-02-22 15:29:00','3db00e08-499e-4af2-946c-b07ffff8852d'),(72,3,35,15,0,0,'2024-02-22 15:29:00','2024-02-22 15:29:00','96c5d694-2544-4c40-ba81-61cb4cb61bb1'),(73,7,36,18,0,0,'2024-02-22 15:29:00','2024-02-22 15:29:00','11d64115-30fe-479e-b4a4-5bfacc82dab5'),(76,12,39,26,0,0,'2024-02-22 17:40:40','2024-02-22 17:40:40','9fc46002-ba9a-4928-bca0-4e037e696dae'),(77,13,40,28,0,0,'2024-02-22 17:43:21','2024-02-22 17:43:21','f68c2893-5eb8-4c32-8f37-a5f17ec41253'),(78,13,40,27,0,1,'2024-02-22 17:43:21','2024-02-22 17:43:21','87395398-d89c-4cf3-86d4-a73e865da778'),(119,2,65,1,0,0,'2024-03-01 11:04:45','2024-03-01 11:04:45','26ff9841-45fb-4908-9cca-43b41c61fecf'),(120,2,65,5,0,1,'2024-03-01 11:04:45','2024-03-01 11:04:45','3a8e7ee4-0806-44cd-b4fe-a5663a0dc901'),(150,14,82,30,0,1,'2024-03-01 18:11:21','2024-03-01 18:11:21','dae67038-66ce-4490-99c5-e8e7d0d270a1'),(151,14,82,31,0,2,'2024-03-01 18:11:21','2024-03-01 18:11:21','cc6e18af-e524-40eb-8884-bff4a71fd492'),(152,14,82,32,0,3,'2024-03-01 18:11:21','2024-03-01 18:11:21','7b9c663d-2f36-4122-b3d6-34e53e6153a4'),(153,14,82,34,0,4,'2024-03-01 18:11:21','2024-03-01 18:11:21','4880f2d4-fbe2-447b-85d8-fc8bc81bab9c'),(154,14,82,29,0,5,'2024-03-01 18:11:21','2024-03-01 18:11:21','c2e7e94f-4272-4b6d-8e21-9691de6d4a7f'),(155,14,83,33,0,0,'2024-03-01 18:11:21','2024-03-01 18:11:21','00190b58-5c4a-40ef-9b70-da1b8cbfad29'),(156,18,84,30,0,1,'2024-03-01 18:14:52','2024-03-01 18:14:52','c5eb2d4f-d730-4333-bf83-f830c7c2b205'),(157,18,84,38,0,2,'2024-03-01 18:14:52','2024-03-01 18:14:52','30f57f12-5eef-4d26-91e3-5be2b2a6520d'),(158,18,84,37,0,3,'2024-03-01 18:14:52','2024-03-01 18:14:52','945257a5-0d3e-4a95-8546-9cfbf7180735'),(159,18,84,29,0,4,'2024-03-01 18:14:52','2024-03-01 18:14:52','be01cb1d-06d1-48e7-aa17-d520b212c9bb'),(160,18,84,35,0,6,'2024-03-01 18:14:52','2024-03-01 18:14:52','16c36893-2b3e-47e2-ba7e-d4e5876333a9'),(161,18,84,36,0,7,'2024-03-01 18:14:52','2024-03-01 18:14:52','4106b4d0-0517-412a-9c7b-b67e39d6f652'),(162,18,85,33,0,0,'2024-03-01 18:14:52','2024-03-01 18:14:52','0918a020-775c-471b-805b-fac2b57aa63a'),(171,23,100,30,0,1,'2024-03-05 15:56:51','2024-03-05 15:56:51','6e3b12cf-487c-4c7e-8bf8-f5f2f0a12fbb'),(172,23,100,8,0,2,'2024-03-05 15:56:51','2024-03-05 15:56:51','d269c179-19dd-4f4c-8c48-5d68651c65ab'),(173,23,100,7,0,3,'2024-03-05 15:56:51','2024-03-05 15:56:51','bf0b4507-ec2b-438f-9250-56bbf52b293d'),(174,23,100,12,0,4,'2024-03-05 15:56:51','2024-03-05 15:56:51','29507460-1441-45d5-a6ba-52d1b235e791'),(180,25,109,39,0,1,'2024-03-05 17:14:49','2024-03-05 17:14:49','be3d240b-956b-47a6-9294-bef5d8faee9a'),(181,25,110,40,0,0,'2024-03-05 17:14:49','2024-03-05 17:14:49','06a448f9-37a8-4e49-9b1a-7573c8bf4087'),(182,25,110,41,0,1,'2024-03-05 17:14:49','2024-03-05 17:14:49','e435e61b-7c0d-4ff1-a608-98066bc9d6b8'),(183,25,111,33,0,0,'2024-03-05 17:14:49','2024-03-05 17:14:49','52067db2-f4ee-46ad-8d4c-d9d0b5fff951'),(184,24,113,40,0,0,'2024-03-05 17:18:09','2024-03-05 17:18:09','9f473bd6-7a77-45b7-ad12-b576d1e45a72'),(185,24,113,41,0,1,'2024-03-05 17:18:09','2024-03-05 17:18:09','5f274020-1abe-4fcc-a4ba-05182d96ff21'),(186,24,114,33,0,0,'2024-03-05 17:18:09','2024-03-05 17:18:09','13977b9d-faf1-47cf-bf47-5985f4ead8c0'),(191,21,118,30,0,1,'2024-03-05 17:20:53','2024-03-05 17:20:53','2bcc97b4-a878-4f2f-8fd8-ca3ef077fc6c'),(192,21,119,33,0,0,'2024-03-05 17:20:53','2024-03-05 17:20:53','0a4a5508-92e0-477f-aea8-8670f4b7c8fe'),(193,22,121,40,0,0,'2024-03-05 17:21:32','2024-03-05 17:21:32','939e61a1-65d2-418b-b29a-8b593681610a'),(194,22,121,41,0,1,'2024-03-05 17:21:32','2024-03-05 17:21:32','ed3fb58d-f7ff-4c65-9aa4-6bbb8b496dea'),(195,22,122,33,0,0,'2024-03-05 17:21:32','2024-03-05 17:21:32','d31ef9cc-e164-4b88-b205-2cc23acc9a6a'),(199,17,127,40,0,0,'2024-03-05 17:22:47','2024-03-05 17:22:47','db753fe6-4586-4c5b-866e-9c7f25c0840b'),(200,17,127,41,0,1,'2024-03-05 17:22:47','2024-03-05 17:22:47','ea6bf626-472a-4bc6-91df-b0a21af8d802'),(201,17,128,33,0,0,'2024-03-05 17:22:47','2024-03-05 17:22:47','71e93826-b1b0-4e73-9fb1-816a2021e0a0'),(202,20,129,39,0,1,'2024-03-05 17:24:54','2024-03-05 17:24:54','13ba9f5c-9ead-42a6-803b-94e7f2044692'),(203,20,130,40,0,0,'2024-03-05 17:24:54','2024-03-05 17:24:54','dbc88545-20d9-4386-9ee4-4e9bc893dae0'),(204,20,130,41,0,1,'2024-03-05 17:24:54','2024-03-05 17:24:54','307a21ca-e02f-4407-9ecf-12aa6c8edbb0'),(205,20,131,33,0,0,'2024-03-05 17:24:54','2024-03-05 17:24:54','7ae03850-1f9d-417d-95a9-3dcc6b36606b'),(206,5,133,40,0,0,'2024-03-05 17:25:27','2024-03-05 17:25:27','541d437a-1916-4dec-aa8e-8b3808fb65b8'),(207,5,133,41,0,1,'2024-03-05 17:25:27','2024-03-05 17:25:27','d8e1f333-3fbb-4f02-b7aa-de4caf3189ff'),(208,5,134,33,0,0,'2024-03-05 17:25:27','2024-03-05 17:25:27','b163b0a0-d28a-4a3a-aa79-6f8c32ef3e43'),(209,19,136,40,0,0,'2024-03-05 17:26:03','2024-03-05 17:26:03','a538ae55-e5d9-4aa3-8522-850a3745f3ba'),(210,19,136,41,0,1,'2024-03-05 17:26:03','2024-03-05 17:26:03','52640849-e2ee-48a3-bea5-a73b8d6e5b97'),(211,19,137,33,0,0,'2024-03-05 17:26:03','2024-03-05 17:26:03','e35ff362-737c-4d6d-ba2f-a4a995870b8c'),(212,26,139,29,0,1,'2024-03-08 15:50:12','2024-03-08 15:50:12','6632a500-1fa4-43d5-843c-f880fc64f753'),(213,26,140,40,0,0,'2024-03-08 15:50:12','2024-03-08 15:50:12','f8687faa-425e-4e02-acd9-e1ea990d08ce'),(214,26,140,41,0,1,'2024-03-08 15:50:12','2024-03-08 15:50:12','b8a342fb-2e9b-4c87-bf66-11319cc09450'),(215,26,141,33,0,0,'2024-03-08 15:50:12','2024-03-08 15:50:12','8e5412e9-bea0-489f-a9c4-d00611e0d8fd'),(234,28,155,29,0,1,'2024-03-08 16:46:41','2024-03-08 16:46:41','857df6a9-4bb3-43e3-a274-7a879ab756f1'),(235,28,156,40,0,0,'2024-03-08 16:46:41','2024-03-08 16:46:41','5ab2b9fb-4282-4f0d-9c2a-d78560c3d7f6'),(236,28,156,41,0,1,'2024-03-08 16:46:41','2024-03-08 16:46:41','7aacadf5-13bf-4666-b1cb-f7e996959146'),(237,28,157,33,0,0,'2024-03-08 16:46:41','2024-03-08 16:46:41','1ef0c339-fd07-4073-b355-9d54af34a9d8'),(238,27,158,29,0,1,'2024-03-08 16:49:25','2024-03-08 16:49:25','44e1b1fd-69bb-42e7-88c6-6d151d96d72c'),(239,27,159,40,0,0,'2024-03-08 16:49:25','2024-03-08 16:49:25','e1ac8f7b-789b-425c-833b-779b0daa32cc'),(240,27,159,41,0,1,'2024-03-08 16:49:25','2024-03-08 16:49:25','3a8ef49c-14ea-4a63-922e-8679482ad2e5'),(241,27,160,33,0,0,'2024-03-08 16:49:25','2024-03-08 16:49:25','81858104-5da4-4bb9-9b04-3f8072d37f91'),(246,29,164,29,0,1,'2024-03-08 17:09:30','2024-03-08 17:09:30','953a0b92-3555-4cf7-8be1-d1fcbc4c5e9f'),(247,29,165,40,0,0,'2024-03-08 17:09:30','2024-03-08 17:09:30','7dd48af4-c747-4ac6-a785-50ee68f089a1'),(248,29,165,41,0,1,'2024-03-08 17:09:30','2024-03-08 17:09:30','d8fad2aa-7c0e-49bc-a901-e4fa7a08ce15'),(249,29,166,33,0,0,'2024-03-08 17:09:30','2024-03-08 17:09:30','39b52c60-4541-444f-b2e5-503946dbd200'),(261,31,174,3,0,1,'2024-03-08 17:18:05','2024-03-08 17:18:05','2e91de73-91a4-4035-844f-d7ae9077ddda'),(262,31,174,30,0,2,'2024-03-08 17:18:05','2024-03-08 17:18:05','928686e4-9699-4508-b851-f566318c1e77'),(263,31,174,12,0,3,'2024-03-08 17:18:05','2024-03-08 17:18:05','1d2b1c9f-d78a-405a-baa8-3b0468444811'),(264,31,174,7,0,4,'2024-03-08 17:18:05','2024-03-08 17:18:05','bf472b44-2b2f-4b81-921f-23acf1f6033a'),(265,30,175,29,0,1,'2024-03-08 17:24:32','2024-03-08 17:24:32','9ea1912a-853a-4b4b-bbb6-a4ea2790c2d8'),(266,30,176,33,0,0,'2024-03-08 17:24:32','2024-03-08 17:24:32','9246d816-4c19-4b6b-bdae-7395076aa31a'),(269,33,179,3,0,1,'2024-03-08 17:33:25','2024-03-08 17:33:25','ad5c84db-9ad4-422d-b4d3-b31858a7ee72'),(270,33,179,30,0,2,'2024-03-08 17:33:25','2024-03-08 17:33:25','be9f8ea5-de1d-482a-845a-e658e8da7e26'),(271,33,179,12,0,3,'2024-03-08 17:33:25','2024-03-08 17:33:25','d72659c8-0d27-40c2-83f5-da903368cbce'),(272,33,179,7,0,4,'2024-03-08 17:33:25','2024-03-08 17:33:25','9cb5d6a1-c858-49fa-9f2c-38e3d0dc5387'),(273,32,180,29,0,1,'2024-03-08 17:36:30','2024-03-08 17:36:30','4aadc850-a115-4153-ac05-868139266ee1'),(274,32,181,33,0,0,'2024-03-08 17:36:30','2024-03-08 17:36:30','d9da9bef-b9dd-4adb-be02-55c9e2e5d8e6'),(275,34,183,29,0,1,'2024-03-08 17:50:38','2024-03-08 17:50:38','e0178d8b-3a46-401f-b006-c24f7b711c5a'),(276,34,184,40,0,0,'2024-03-08 17:50:38','2024-03-08 17:50:38','508676e7-0ec6-4559-b97a-028cdd39aaa6'),(277,34,184,41,0,1,'2024-03-08 17:50:38','2024-03-08 17:50:38','daeaffb4-d7f7-4bfc-bf0d-43e1af7721d5'),(278,34,185,33,0,0,'2024-03-08 17:50:38','2024-03-08 17:50:38','903b9a3f-f7fd-48a2-9356-13863884c650'),(282,35,190,29,0,1,'2024-03-11 11:00:08','2024-03-11 11:00:08','8bc1104b-e81e-4807-aff2-e820907cbbba'),(283,35,191,40,0,0,'2024-03-11 11:00:08','2024-03-11 11:00:08','3453c577-2e7f-4f0d-a72c-1d6f7423e5bb'),(284,35,191,41,0,1,'2024-03-11 11:00:08','2024-03-11 11:00:08','7cbaf231-3f32-43c6-bbee-1435f7a507d3'),(285,35,192,33,0,0,'2024-03-11 11:00:08','2024-03-11 11:00:08','80bd800b-e960-4ca6-954a-13cbc72a1de0');
/*!40000 ALTER TABLE `fieldlayoutfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayouts`
--

LOCK TABLES `fieldlayouts` WRITE;
/*!40000 ALTER TABLE `fieldlayouts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayouts` VALUES (1,'craft\\elements\\Asset','2024-02-19 12:20:43','2024-02-19 12:20:43',NULL,'3d555760-70e3-4aa7-9dc6-60d5a1a46027'),(2,'craft\\elements\\GlobalSet','2024-02-19 12:49:12','2024-02-19 12:49:12',NULL,'6e21f431-870a-471e-9078-80da74f77531'),(3,'craft\\elements\\GlobalSet','2024-02-19 12:59:28','2024-02-19 12:59:28',NULL,'75fb3173-9b11-4043-ae27-31ebc53128c1'),(4,'craft\\elements\\GlobalSet','2024-02-19 14:04:49','2024-02-19 14:04:49',NULL,'19314b8b-ef73-42a6-b849-176472ab8d87'),(5,'craft\\elements\\Entry','2024-02-20 17:13:26','2024-02-20 17:13:26',NULL,'9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510'),(6,'craft\\elements\\MatrixBlock','2024-02-22 14:17:49','2024-02-22 14:17:49',NULL,'b66ad93c-b6ff-4af4-a144-25ef78fb823c'),(7,'craft\\elements\\GlobalSet','2024-02-22 14:24:58','2024-02-22 14:24:58',NULL,'e36f68f4-941a-46aa-a9d6-7caac087ae30'),(8,'craft\\elements\\MatrixBlock','2024-02-22 14:26:31','2024-02-22 14:26:31',NULL,'61a9a6da-2d11-4b32-8b19-b51512d25d22'),(9,'craft\\elements\\GlobalSet','2024-02-22 14:37:59','2024-02-22 14:37:59',NULL,'1f615b22-b226-4348-b9a8-6580566c0606'),(10,'craft\\elements\\GlobalSet','2024-02-22 14:54:20','2024-02-22 14:54:20',NULL,'b98bbf98-6f28-46da-b7a6-443fe0ac515d'),(11,'craft\\elements\\MatrixBlock','2024-02-22 14:56:25','2024-02-22 14:56:25',NULL,'a34550d8-0788-45af-84df-e16730f491ea'),(12,'craft\\elements\\GlobalSet','2024-02-22 15:29:15','2024-02-22 15:29:15',NULL,'21dee9e9-99c4-4577-8a1c-faa06bda19ae'),(13,'craft\\elements\\MatrixBlock','2024-02-22 17:40:29','2024-02-22 17:40:29',NULL,'a35eb9c2-cc01-4a5c-8ce7-4ca322396ddd'),(14,'craft\\elements\\Entry','2024-02-22 17:57:52','2024-02-22 17:57:52',NULL,'b96b9d72-9d99-41b1-9ccc-2a5459ba1080'),(15,'craft\\elements\\Tag','2024-02-22 18:04:25','2024-02-22 18:04:25',NULL,'8ccfab61-43a1-4dda-b382-b8edbdf429f5'),(16,'craft\\elements\\Category','2024-02-22 18:06:16','2024-02-22 18:06:16',NULL,'dc33d828-416a-4059-87c0-3e4f5ceef145'),(17,'craft\\elements\\Entry','2024-02-27 17:20:13','2024-02-27 17:20:13',NULL,'20b7a09a-8139-497b-a498-ec0d694219c7'),(18,'craft\\elements\\Entry','2024-03-01 16:40:18','2024-03-01 16:40:18',NULL,'21405bfc-365b-492c-9199-94cd67d414c1'),(19,'craft\\elements\\Entry','2024-03-01 17:36:55','2024-03-01 17:36:55',NULL,'b62663b8-dfc0-4717-b03e-55c0021a8dd7'),(20,'craft\\elements\\Entry','2024-03-04 11:21:56','2024-03-04 11:21:56',NULL,'5d6d3035-222e-48b1-abcf-881a69622643'),(21,'craft\\elements\\Entry','2024-03-05 14:36:35','2024-03-05 14:36:35',NULL,'59258b63-b925-447c-b816-d43e50df272c'),(22,'craft\\elements\\Entry','2024-03-05 14:53:10','2024-03-05 14:53:10',NULL,'6781505a-92c2-49e7-a0f5-6620d4393b2a'),(23,'craft\\elements\\Category','2024-03-05 15:56:51','2024-03-05 15:56:51',NULL,'0b05e4ea-c344-4584-b273-a11973d23684'),(24,'craft\\elements\\Entry','2024-03-05 16:01:28','2024-03-05 16:01:28',NULL,'d81e1789-2034-4397-a8af-0e07f27ff91e'),(25,'craft\\elements\\Entry','2024-03-05 16:19:37','2024-03-05 16:19:37',NULL,'133f7622-a058-4cd8-8855-fd62d6318c9a'),(26,'craft\\elements\\Entry','2024-03-08 15:49:31','2024-03-08 15:49:31',NULL,'97cd0d1e-d9bf-4bba-9839-60f2df92afde'),(27,'craft\\elements\\Entry','2024-03-08 16:39:02','2024-03-08 16:39:02',NULL,'92b28aec-8e65-48d5-a867-28de2d1f83b9'),(28,'craft\\elements\\Entry','2024-03-08 16:46:19','2024-03-08 16:46:19',NULL,'28497d72-5f3b-4ef1-9d13-7618b713008d'),(29,'craft\\elements\\Entry','2024-03-08 17:09:23','2024-03-08 17:09:23',NULL,'81d68572-e1f1-4d05-accd-de3234308186'),(30,'craft\\elements\\Entry','2024-03-08 17:15:33','2024-03-08 17:15:33',NULL,'b517f335-8ed0-46db-8b1b-7ab97a94d370'),(31,'craft\\elements\\Category','2024-03-08 17:17:16','2024-03-08 17:17:16',NULL,'488cdbc6-757d-4910-ab6a-628a83cc4ad4'),(32,'craft\\elements\\Entry','2024-03-08 17:32:31','2024-03-08 17:32:31',NULL,'41e2a985-40a6-42a0-b02a-362a351960af'),(33,'craft\\elements\\Category','2024-03-08 17:33:25','2024-03-08 17:33:25',NULL,'49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf'),(34,'craft\\elements\\Entry','2024-03-08 17:49:48','2024-03-08 17:49:48',NULL,'b80cc7dc-ab55-4c99-9401-ea3ad94197d3'),(35,'craft\\elements\\Entry','2024-03-11 10:57:42','2024-03-11 10:57:42',NULL,'c3c5d477-2ade-40fd-b0bf-65d6f43025c3');
/*!40000 ALTER TABLE `fieldlayouts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayouttabs`
--

LOCK TABLES `fieldlayouttabs` WRITE;
/*!40000 ALTER TABLE `fieldlayouttabs` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayouttabs` VALUES (1,1,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\assets\\\\AssetTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"e7126d2f-78e1-4eec-abb4-311b228d8ca4\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\assets\\\\AltField\",\"attribute\":\"alt\",\"requirable\":true,\"class\":null,\"rows\":null,\"cols\":null,\"name\":null,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"56dde753-9e23-4549-84f6-e73d9ab3cebf\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-02-19 12:20:43','2024-02-19 12:20:43','f120be0d-263e-4f58-ae8e-12d4fce79ee5'),(11,4,'Conteudo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"4d341794-fd42-4bc8-8495-31f78fa7c899\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"c7af5a64-9068-4c13-959a-e1d5fda71ec9\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"aa3b0b46-d5ce-4c3d-bb37-08fbf9881b5a\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"397182b0-88e7-4f15-a81a-ef29b5e79085\"}]',1,'2024-02-20 17:50:51','2024-02-20 17:50:51','687613b9-dbf5-46e4-91fb-f162f0dc108d'),(19,6,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"c12c3c93-5106-48a9-b92a-20b685b8724c\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"c502d183-3c9f-46e5-a8b8-908199f9fc45\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"b34ec822-82a4-4e91-b708-6b0faaf99ffc\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"ae5b2ed2-2831-4cdd-bb00-98756e51e289\"}]',1,'2024-02-22 14:18:25','2024-02-22 14:18:25','b07ef4ea-7ac7-4cd6-997c-b7f3f2410d98'),(23,8,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"84b9c192-f354-4f2e-afe9-873c5a4a0095\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"6dcf8de8-6e9b-4d86-b816-cd5366542779\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"d1c6b4a2-373e-4b8f-bd2d-ce9eaa7c4112\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2ddb23e1-bd23-459d-b1ab-37bd7021ef18\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"0d0f2a8c-aae8-4eb5-8c85-fe1c6eb650d0\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"1568a823-f93a-4a46-a859-168a822b1f19\"}]',1,'2024-02-22 14:26:45','2024-02-22 14:26:45','0972b1bd-ac26-49bd-8838-37cc8c6484b6'),(30,11,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"e825e124-1148-42b3-8bfb-3f09fbcf13c2\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"3be7ee76-741a-4bc9-8083-a13fe37236e8\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2d13b60a-e774-4457-a865-2a1751584f8f\"}]',1,'2024-02-22 15:02:57','2024-02-22 15:02:57','97e6b6de-e654-4ea4-ad97-a1f95b77e927'),(31,10,'Conteudo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"d9c73150-47b1-4b13-af62-db85acb12e9e\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"ea3b61d5-7e5b-4b00-ac14-8498e58e5592\"}]',1,'2024-02-22 15:29:00','2024-02-22 15:29:00','27a1ab95-17de-470f-b502-393c61bae18b'),(32,9,'Conteudo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"a75154e3-00c9-4c84-899a-e34936ef8c80\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"edb2e939-cc66-40b0-83a9-3755fa783f5e\"}]',1,'2024-02-22 15:29:00','2024-02-22 15:29:00','483ec640-459e-4116-9303-0389951026db'),(33,3,'Informações Gerais','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"0891f8f5-deed-4d6d-854a-1d68efb50095\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"6142f9f7-b123-457c-bc86-ae919de1bcfe\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"072f053d-14c1-478d-91f8-5354168071ae\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"}]',1,'2024-02-22 15:29:00','2024-02-22 15:29:00','39b429c8-e6ac-435e-9517-626136cc9b56'),(34,3,'Morada','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"366806ad-161b-4a38-8956-37662cff805b\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"9bf75c64-3353-4e86-b013-34e66a227011\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"c827a949-4a0e-4e11-acb8-2519507a9205\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"e7257f8f-1d2b-463c-96d5-ca9fb4e0814f\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"121033d5-3620-4d94-9761-861f61f66848\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"6963b7c0-3841-4923-b316-75ce66aefdff\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"db264e5a-94fc-45e2-8dc6-23ff35a6ecde\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"ec4f2482-6a6a-4129-a8f1-70835234cf27\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"6dccc324-e844-4e84-91d7-84e544a07348\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"661451bc-35bc-4d1c-b544-24a4294d9560\"}]',2,'2024-02-22 15:29:00','2024-02-22 15:29:00','05a92c54-b5e5-4cdc-b7f9-3c1eba9226a5'),(35,3,'Outras Informações','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"6c5b896a-44c9-494b-8882-ce2270be6efd\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"3522d11c-1676-489e-b336-4647089388d4\"}]',3,'2024-02-22 15:29:00','2024-02-22 15:29:00','446aad37-90cb-4a77-801f-4fa09da32be6'),(36,7,'Conteudo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"0de666a5-2c42-46a4-bf4f-2c45b537f18d\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"9ba971ee-6616-4e6e-b216-29c1e91a1d2f\"}]',1,'2024-02-22 15:29:00','2024-02-22 15:29:00','39071c8a-20a0-4d7a-97f3-ca06d86ef005'),(39,12,'Conteudo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"9b202a9a-5439-4e65-830a-5c371aabe126\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"09728bc0-0ebd-4cf5-ae04-4416b4e9103c\"}]',1,'2024-02-22 17:40:40','2024-02-22 17:40:40','a0b546e1-c4d1-4e1e-b54b-3f51f28a14b9'),(40,13,'Content','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"3eb605c2-f675-41cc-ac22-2a259a2f3a2c\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"efd17caf-a286-414f-ac89-2bbdbc3ad4b1\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"7e14bb82-08b6-42f2-94f9-6483fb8139da\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"4151d77b-d0fe-41f4-bdb6-6a2f9f00d8b3\"}]',1,'2024-02-22 17:43:21','2024-02-22 17:43:21','7c1e719e-cfc9-432c-92f2-0bbc5df8633c'),(46,15,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\TitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"d5d2c488-92ad-4a49-9dca-67f9524c583b\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-02-22 18:04:25','2024-02-22 18:04:25','cd02a534-5385-4833-9f85-5c88d0cb3d7f'),(52,16,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\TitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"a8f778c4-32d0-4751-9cbe-e24328a85a37\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-02-22 18:09:57','2024-02-22 18:09:57','17d761ea-caf0-4c8a-8b6e-e1aabf5c07fe'),(65,2,'Conteudo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"93b11f06-4d25-48f5-b372-49cb31851d6f\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"625190d1-527c-4ea1-84dd-c752c55aff02\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"43882c53-419f-4776-8cbd-2e5ef0c6f0dc\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"4132f438-075d-4ca1-b68d-2a215d1dd2ea\"}]',1,'2024-03-01 11:04:45','2024-03-01 11:04:45','4cf70fa3-8b95-45b8-be3f-4a4287fce342'),(82,14,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":50,\"uid\":\"431ac07e-b0aa-43f9-8a32-d2a8da622d80\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"4db7e58c-35d3-41e4-b531-a41aa338a944\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"6095191e-39fe-4e53-9f5d-8b3e3f1b02bb\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"175b9d48-8313-4b08-b6e5-45633a5ab848\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"1c3a2257-08cb-494e-be3b-4f09dc319265\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"7c3d6d08-ebc0-4e9d-ae0d-809ab9096549\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"67e69cee-3bae-4b37-8944-f0995d8feede\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"77d3c1fa-0a42-43f7-92e9-e91a592be391\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteúdo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"6e366c02-e2f1-4dc4-a4eb-b318e1bb3320\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-01 18:11:21','2024-03-01 18:11:21','3db40fb8-d734-4d0e-80c2-4c4dc204e20e'),(83,14,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"61e61cc7-2c9a-4401-9b5f-484fd9e806ef\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',2,'2024-03-01 18:11:21','2024-03-01 18:11:21','b94aae6f-e170-4313-a784-900c42ffd776'),(84,18,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"a744c5da-a770-48b9-bda9-31597fc6835a\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Thumbnail\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":25,\"uid\":\"477415a9-f67d-4f41-8592-6e0c1a810888\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":25,\"uid\":\"0704c552-8b84-4b68-9922-5fb34d6c0dc0\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"3f7c029c-b6a9-491a-bf4b-7ccdceac3649\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":25,\"uid\":\"61a0af89-30c4-4a47-9ddb-e1be34c98edd\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2c508b12-7986-41f3-835a-3dada05e9433\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteúdo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"77394c2b-51be-4042-b29e-cfeaa88e9f2e\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\Heading\",\"heading\":\"Coordenadas do mapa\",\"uid\":\"ca331959-7a71-4511-8d64-53f2ce9dbd57\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"25f44224-88f3-4745-97c0-6ee408c9d0ff\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"d8cd947c-079b-440d-9b65-4589c16d23eb\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"58d40bad-033a-4c08-9811-8b2c7ee312d6\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"6e042994-c894-40f0-8b7a-b1ba8bcc666e\"}]',1,'2024-03-01 18:14:52','2024-03-01 18:14:52','ac753b27-95c7-4a07-9e6a-41c19253e677'),(85,18,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"fb5ad3b4-ea0c-4bf2-be8a-12ef8c5cbda4\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',2,'2024-03-01 18:14:52','2024-03-01 18:14:52','ef43cdab-5d18-4865-bcc8-a98a4d7584bd'),(100,23,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\TitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":50,\"uid\":\"5796f2e5-3cee-4ae3-8c7e-d6617460aa48\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"ab18ba20-f6ce-4a0f-808c-d4effee6687b\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"28d89283-bc05-41a3-984e-fb4c19392344\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"9bf75c64-3353-4e86-b013-34e66a227011\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"ec1529fa-7f84-49bf-80a9-8b697c617750\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"b3d1f247-92c0-498d-9209-877e2eb10edc\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"661451bc-35bc-4d1c-b544-24a4294d9560\"}]',1,'2024-03-05 15:56:51','2024-03-05 15:56:51','267b4278-55fb-4e21-b7c4-6588172d03f6'),(109,25,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"486f24c7-29ac-499f-942e-fccf3e3c05ea\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"cc07b316-8954-43f9-b881-8f3296ea6d51\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"c84d03fe-f80d-4194-ba99-08b7fbfba0ed\"}]',1,'2024-03-05 17:14:49','2024-03-05 17:14:49','8b127c9b-2c8b-4486-a692-e83eaf2d7460'),(110,25,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"bd6df0e8-5174-48ce-af34-bfc8f5919ffa\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"806bea8d-054a-4be7-856b-54fd0176f714\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-05 17:14:49','2024-03-05 17:14:49','c0155f5a-a616-4799-ba0c-2a845aa029e6'),(111,25,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"ae3519ad-f581-4c79-b560-aab028a8b4ff\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-05 17:14:49','2024-03-05 17:14:49','8fa8f12b-59c9-428f-a9d9-fd34776780b8'),(112,24,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"afacfa93-8219-40c6-b4f2-373905a4db12\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-03-05 17:18:09','2024-03-05 17:18:09','bfd6421c-ce17-4af9-a251-7163086f07d2'),(113,24,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"406ee2a1-0180-4a49-ba94-fe7d207d7a09\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"0c17338f-39f7-43aa-8e45-c30f8f72e800\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-05 17:18:09','2024-03-05 17:18:09','458e3523-2c1d-427b-9ec9-55d6d60f2e04'),(114,24,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"6a6f7021-0108-4f68-a431-b5f750b77bf6\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-05 17:18:09','2024-03-05 17:18:09','b246d27f-9447-4be8-a78d-4130304933e7'),(118,21,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"b95e0e01-8519-47c8-a7a0-2218458b868c\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Imagens\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"710dce4d-4d15-4e62-b039-03843ca65822\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"}]',1,'2024-03-05 17:20:53','2024-03-05 17:20:53','f4adeacc-dcc4-43d9-a02d-65dd45877339'),(119,21,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"56265a0c-fa0d-4210-b3e5-ec3b240a2d7d\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',2,'2024-03-05 17:20:53','2024-03-05 17:20:53','e94681db-3f1d-4427-9a5e-4ab6e80b4a36'),(120,22,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"e4d6a476-683b-4844-9e40-35f0b03785ee\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-03-05 17:21:32','2024-03-05 17:21:32','e3167cb4-2b26-4bba-a6fb-3243de8b8c41'),(121,22,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"6c1abffc-8b31-47a6-b16b-e9e36d09d53f\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"79a36657-0e01-4622-999e-103a7c21af7b\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-05 17:21:32','2024-03-05 17:21:32','cf8a49e7-2a73-4d92-91f3-a8e998b1f5ce'),(122,22,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"6364d78b-b77a-4ff1-96ab-76cd62ae6f01\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-05 17:21:32','2024-03-05 17:21:32','faf45306-536b-4f6a-bb86-5ec8c197d223'),(126,17,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"c208f0aa-82d4-48fd-a507-4203d7551721\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-03-05 17:22:47','2024-03-05 17:22:47','0e1231d4-0f86-4d3e-baa3-7a97bc58c1ab'),(127,17,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"607c5fcc-573f-4dad-9fe9-62e2ce678b23\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"93dffbe3-78cd-43c4-99be-b2ba7c9070c9\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-05 17:22:47','2024-03-05 17:22:47','fc4345ef-5018-4a1a-802a-e20049e031a3'),(128,17,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"4b30ac6d-9550-467b-8492-20a7642b8d40\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-05 17:22:47','2024-03-05 17:22:47','96a64b91-82f8-49bc-9b6c-f72e951ef897'),(129,20,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"479f8f2d-58d6-462a-975d-04da3294d7bf\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"3ce0b255-de6f-490e-8ac6-7296be24d251\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"c84d03fe-f80d-4194-ba99-08b7fbfba0ed\"}]',1,'2024-03-05 17:24:54','2024-03-05 17:24:54','e4457700-916e-4fef-8cd6-f6ebcf297bd0'),(130,20,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"8af13862-a51c-4564-bf3b-b0624a63ec8f\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"255992f3-2752-4ccc-9a82-62a0b3f5646b\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-05 17:24:54','2024-03-05 17:24:54','c0545140-81ef-4bb4-9704-df723545ec9c'),(131,20,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"787c75d5-a9b8-46ae-a704-e854264814d7\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-05 17:24:54','2024-03-05 17:24:54','3fa02657-b338-45bd-85e0-ec1e2bf68f1b'),(132,5,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"5636a001-44f9-41a0-bcb8-23d5242847ca\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-03-05 17:25:27','2024-03-05 17:25:27','669bdd04-0eee-4469-b69a-1b7251af0bf3'),(133,5,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"246ae813-81c9-4a96-b246-104aa63347dd\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"d1e46d93-98ff-4394-96b7-189569a5c424\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-05 17:25:27','2024-03-05 17:25:27','412b7ade-3d26-456b-a28d-3a6481e5efa0'),(134,5,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"54ef58b9-0315-479e-8bb7-17ffc75f24e8\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-05 17:25:27','2024-03-05 17:25:27','a14d3caa-288b-4d7f-b65b-40aa88285cdd'),(135,19,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"16d1b29e-dda1-4cd1-a4b1-872a21027042\",\"userCondition\":null,\"elementCondition\":null}]',1,'2024-03-05 17:26:03','2024-03-05 17:26:03','eebad716-8e8f-44cc-9465-76b4c2a0fce0'),(136,19,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"c8d97049-0bdc-4adc-8cea-62536f06c26d\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"4f070e67-f28a-4203-b64d-9be69d406616\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-05 17:26:03','2024-03-05 17:26:03','08f95854-d8b5-437e-9caf-1b778a12490b'),(137,19,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"81a3150a-735a-4723-b200-73430372ba40\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-05 17:26:03','2024-03-05 17:26:03','2bc9c892-5edd-4c8b-a962-42d66ea1f9ee'),(139,26,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"f219ca1b-4052-4e94-829f-66b38cd0b052\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"e4205e4f-6f0d-472b-a945-cf25023857e3\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-08 15:50:12','2024-03-08 15:50:12','0a0f35e9-72bc-4c66-bae0-7b409f2e7434'),(140,26,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"1bdc459f-f087-48aa-b1d7-6a384bb15703\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"05248056-4ef2-4cd2-8c98-b8ec3d4132b8\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-08 15:50:12','2024-03-08 15:50:12','f9931f1c-2b43-4ce8-bd39-905b004d375f'),(141,26,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"d7535b2d-bdc8-4b49-94a6-91484765626f\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-08 15:50:12','2024-03-08 15:50:12','266cd40f-f0fb-4603-967c-4b2a2156c518'),(155,28,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"b3f95136-9030-4431-aac7-f8fc2e76dc98\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteudo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"65af5573-8cee-4e77-8cbc-af6238e6f35d\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-08 16:46:41','2024-03-08 16:46:41','542a74a7-0b68-4882-9f79-812cce5c1023'),(156,28,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"a1b58cc5-6c6e-492d-aef5-e8b9d110c74f\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"bfcacf1b-8857-47e5-a6eb-722c4879ce3b\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-08 16:46:41','2024-03-08 16:46:41','df6afe3a-149f-4347-8475-a6a208eb7815'),(157,28,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"9af11eae-b4fe-417d-87a2-583f0cbc8208\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-08 16:46:41','2024-03-08 16:46:41','0823819d-9b1d-4b44-923d-2521308c408f'),(158,27,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"15c0d1b2-1a99-4389-99be-2b609c01d368\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Mensagem do presidente\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"9a502b06-8322-4750-ac66-879b6ccfdd9a\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-08 16:49:25','2024-03-08 16:49:25','a6d39571-3792-4fd9-b7f4-f0e3b28f96cb'),(159,27,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"e29fbdda-bfe3-46f0-872d-c54c9b309fd4\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"de3d3f15-7148-49bf-829c-2b1a3a05e5bc\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-08 16:49:25','2024-03-08 16:49:25','f9638fd3-2834-48e6-967f-b84ac77868a0'),(160,27,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"60166a38-54cf-4930-9814-8bd644b425d0\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-08 16:49:25','2024-03-08 16:49:25','3c6dde44-4c7d-4ee5-9f3c-f668a900fc99'),(164,29,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"588f97e5-7d1d-4b04-b706-b2a911a85e16\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteudo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"07547fef-4f34-428a-aee8-7f8e5b465880\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-08 17:09:30','2024-03-08 17:09:30','4d0dc63b-0c9d-4574-9208-eecc18930c66'),(165,29,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"9adc6f94-af4e-474a-8f76-18023bf74fd0\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"8163169d-5bf4-47d8-9321-077c66f20a6f\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-08 17:09:30','2024-03-08 17:09:30','13d8b4af-9986-4b0a-930f-0091b7e8a51a'),(166,29,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"6a4ceacd-fda7-45ab-ace5-948980f14f69\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-08 17:09:30','2024-03-08 17:09:30','10f3c04f-b93a-41b9-b21d-41da53595ea6'),(174,31,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\TitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":\"Nome\",\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":50,\"uid\":\"0ffe551a-2931-49d8-9b08-ed47747ba6ca\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Cargo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":25,\"uid\":\"ce66162d-2e8f-4a4a-98a5-0fd181fd03cf\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":25,\"uid\":\"6382fb50-b10a-4a83-a1a0-9d19596effc9\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"4a5ad8da-cc7d-4f81-8fcb-0d1f25bdf534\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"661451bc-35bc-4d1c-b544-24a4294d9560\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"384273ee-1f42-4d8c-909f-4d18e7306f26\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"}]',1,'2024-03-08 17:18:05','2024-03-08 17:18:05','3ce886dc-7873-4f97-88af-b29a06d355d1'),(175,30,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"0ef10d66-7f1c-4634-9144-2fba4e66cac9\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteudo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"9115923e-b3b1-401d-94ba-f2fe0c444fa3\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-08 17:24:32','2024-03-08 17:24:32','45107f5a-c628-4862-9115-098092483826'),(176,30,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"c5e9eabf-7028-4175-8b54-93d7dd9e52b6\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',2,'2024-03-08 17:24:32','2024-03-08 17:24:32','2836cad6-c441-4e60-9440-01c359a47e9b'),(179,33,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\TitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":50,\"uid\":\"12c2d326-5eeb-4176-a9dc-ffcb13ff7e81\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Cargo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":25,\"uid\":\"b74da684-659e-41ed-9db9-17eb76b26258\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":25,\"uid\":\"ae15ea40-daf0-4b58-9aa1-467eccef7de3\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"fa288df4-38c1-4fb3-b405-9953d248b33d\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"661451bc-35bc-4d1c-b544-24a4294d9560\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":50,\"uid\":\"5bad0c9b-0265-4921-b1e9-4834b5781229\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"}]',1,'2024-03-08 17:33:25','2024-03-08 17:33:25','9a6c1e2b-a6ec-436a-861f-d6972ca393cc'),(180,32,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"171295c1-f607-411a-b238-60b172d8c130\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteudo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"54308cda-1367-4426-9238-cd8fe63b880a\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-08 17:36:30','2024-03-08 17:36:30','5ecc4dbc-726a-43d8-9005-77b7554243a1'),(181,32,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"9c123ee6-fb27-4e99-9a2f-10b9c797d932\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',2,'2024-03-08 17:36:30','2024-03-08 17:36:30','aae6206d-bb79-454c-9b01-bde66cb44324'),(183,34,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"f9dc10f2-0114-448f-82ef-52b00cc38bce\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteúdo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"2afa0be9-24e3-4670-9b87-c78b809bf9f0\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-08 17:50:38','2024-03-08 17:50:38','4e774542-7b95-4cf7-bfa3-780db0331903'),(184,34,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"fc991cee-dd6b-4739-adbb-38a9304fccc7\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"2c768d83-4990-484a-84ab-10b042892e6d\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-08 17:50:38','2024-03-08 17:50:38','bea54ae7-ccb5-498e-a8ca-d5b7379bc86e'),(185,34,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"07a835a3-0ed2-4706-9ff5-704e07e45171\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-08 17:50:38','2024-03-08 17:50:38','5a526286-339e-4ad2-9eaa-244b03c040e1'),(190,35,'Conteúdo','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\",\"inputType\":null,\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100,\"uid\":\"fac77929-ef58-4c3a-b8cf-dcd5fefe72d0\",\"userCondition\":null,\"elementCondition\":null},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":\"Conteúdo\",\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"bffe7f68-886f-41c0-93db-36a84f13da2e\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"795538db-d8cd-4fb9-922b-e9398f128280\"}]',1,'2024-03-11 11:00:08','2024-03-11 11:00:08','10685269-05da-40dd-99c5-cb6fb537c058'),(191,35,'Coluna da Direita','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"95c3b044-91eb-414e-81f5-6bd920512b1f\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"2423118a-7834-476b-9b22-c9efde226343\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"eca77e23-5cc3-4e59-b107-0a7cbd0e71ae\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"}]',2,'2024-03-11 11:00:08','2024-03-11 11:00:08','cd50a4de-b9a2-4374-9375-e47aeb6e3cce'),(192,35,'SEO','{\"userCondition\":null,\"elementCondition\":null}','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"uid\":\"68b16ce1-cc44-41e7-9767-feda333b6151\",\"userCondition\":null,\"elementCondition\":null,\"fieldUid\":\"722f4bfc-5260-46a5-821c-beebb86e123d\"}]',3,'2024-03-11 11:00:08','2024-03-11 11:00:08','eacb2b7a-cd50-487c-b07b-3ef773092707');
/*!40000 ALTER TABLE `fieldlayouttabs` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fields`
--

LOCK TABLES `fields` WRITE;
/*!40000 ALTER TABLE `fields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fields` VALUES (1,2,'favicon','favicon','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"favicon\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":1,\"previewMode\":\"thumbs\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-02-19 12:46:51','2024-02-19 12:46:51','625190d1-527c-4ea1-84dd-c752c55aff02'),(2,2,'Meta Image','metaImage','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"meta-images\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":0,\"previewMode\":\"thumbs\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-02-19 12:47:47','2024-02-19 12:47:47','9ca854f1-d394-437d-8fd2-04088aceac86'),(3,2,'Meta Title','metaTitle','global','wazzxglf',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-19 12:48:15','2024-02-19 12:48:15','dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5'),(4,2,'Meta Description','metaDescription','global','ajhdgooe',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":true,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-19 12:48:30','2024-02-19 12:48:30','4816bfcc-ee2e-4052-b872-2260bfe93d34'),(5,1,'html','html','global','lybdltli',NULL,0,'none',NULL,'nystudio107\\codefield\\fields\\Code','{\"availableLanguages\":[\"css\",\"html\",\"javascript\",\"json\",\"twig\"],\"codeFolding\":false,\"columnType\":\"text\",\"defaultValue\":\"\",\"fontSize\":14,\"language\":\"html\",\"lineNumbers\":false,\"monacoEditorOptions\":\"\",\"placeholder\":\"\",\"showLanguageDropdown\":true,\"singleLineEditor\":false,\"theme\":\"vs\"}','2024-02-19 12:50:17','2024-02-19 12:50:17','4132f438-075d-4ca1-b68d-2a215d1dd2ea'),(6,3,'Nome da Organização','organizationName','global','ukbnjvma',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-19 12:54:00','2024-02-19 12:54:00','6142f9f7-b123-457c-bc86-ae919de1bcfe'),(7,3,'Email','email','global','kwodfxjt',NULL,0,'none',NULL,'craft\\fields\\Email','{\"placeholder\":\"placeholder@juntamesaofrio.com\"}','2024-02-19 12:55:00','2024-02-19 12:55:00','2b60f963-b36d-4f30-8a79-bc98eb9f0705'),(8,3,'Morada','address','global','gklqovpy',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-19 12:55:21','2024-02-19 12:55:21','9bf75c64-3353-4e86-b013-34e66a227011'),(9,3,'Código Postal','postalCode','global','zjtrjjfm',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-19 12:57:11','2024-02-19 12:57:20','e7257f8f-1d2b-463c-96d5-ca9fb4e0814f'),(10,3,'Cidade','city','global','ytsfqomq',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-19 12:57:38','2024-02-19 12:57:38','6963b7c0-3841-4923-b316-75ce66aefdff'),(11,3,'País','country','global','xfwzdulc',NULL,0,'none',NULL,'craft\\fields\\Country',NULL,'2024-02-19 12:58:08','2024-02-19 12:58:08','ec4f2482-6a6a-4129-a8f1-70835234cf27'),(12,3,'Telefone','phone','global','zgcmmyvo',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-19 12:58:36','2024-02-19 12:58:36','661451bc-35bc-4d1c-b544-24a4294d9560'),(13,4,'logo','logo','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"logo\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":null,\"previewMode\":\"thumbs\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":true,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-02-19 13:01:35','2024-02-19 14:03:34','c7af5a64-9068-4c13-959a-e1d5fda71ec9'),(14,4,'Background Image','backgroundImage','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"header\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":null,\"previewMode\":\"thumbs\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-02-20 17:50:37','2024-02-20 17:50:37','397182b0-88e7-4f15-a81a-ef29b5e79085'),(15,3,'Contactos','contacts','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Matrix','{\"contentTable\":\"{{%matrixcontent_contacts}}\",\"maxBlocks\":null,\"minBlocks\":null,\"propagationKeyFormat\":null,\"propagationMethod\":\"all\"}','2024-02-22 14:17:49','2024-02-22 14:22:37','3522d11c-1676-489e-b336-4647089388d4'),(16,NULL,'Contacto','contact','matrixBlockType:f7fb1fe1-d07b-4cd2-bc13-32ccab9e38e3','cjxyhlvz',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-22 14:17:49','2024-02-22 14:17:49','ae5b2ed2-2831-4cdd-bb00-98756e51e289'),(17,NULL,'Label','label','matrixBlockType:f7fb1fe1-d07b-4cd2-bc13-32ccab9e38e3','ayfhcoen',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-22 14:17:49','2024-02-22 14:17:49','c502d183-3c9f-46e5-a8b8-908199f9fc45'),(18,5,'Redes Sociais','socials','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Matrix','{\"contentTable\":\"{{%matrixcontent_socials}}\",\"maxBlocks\":null,\"minBlocks\":null,\"propagationKeyFormat\":null,\"propagationMethod\":\"all\"}','2024-02-22 14:26:31','2024-02-22 14:26:45','9ba971ee-6616-4e6e-b216-29c1e91a1d2f'),(19,NULL,'Url','social_url','matrixBlockType:a66ff91d-fa54-44be-a228-fc1c55be4647','ivwrtsfp',NULL,0,'none',NULL,'craft\\fields\\Url','{\"maxLength\":255,\"types\":[\"url\",\"tel\",\"email\"]}','2024-02-22 14:26:31','2024-02-22 14:26:31','2ddb23e1-bd23-459d-b1ab-37bd7021ef18'),(20,NULL,'Label','label','matrixBlockType:a66ff91d-fa54-44be-a228-fc1c55be4647','qlcwkydz',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-22 14:26:31','2024-02-22 14:26:31','6dcf8de8-6e9b-4d86-b816-cd5366542779'),(21,NULL,'Icon','icon','matrixBlockType:a66ff91d-fa54-44be-a228-fc1c55be4647',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"socials\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":null,\"previewMode\":\"thumbs\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":true,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-02-22 14:26:31','2024-02-22 14:26:45','1568a823-f93a-4a46-a859-168a822b1f19'),(22,6,'Copyright','copyright','global','gzwezmwi',NULL,0,'none',NULL,'craft\\redactor\\Field','{\"availableTransforms\":\"\",\"availableVolumes\":\"*\",\"columnType\":\"text\",\"configSelectionMode\":\"choose\",\"defaultTransform\":\"\",\"manualConfig\":\"\",\"purifierConfig\":null,\"purifyHtml\":true,\"redactorConfig\":null,\"removeEmptyTags\":false,\"removeInlineStyles\":false,\"removeNbsp\":false,\"showHtmlButtonForNonAdmins\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"uiMode\":\"enlarged\"}','2024-02-22 14:37:42','2024-02-22 14:37:42','edb2e939-cc66-40b0-83a9-3755fa783f5e'),(23,7,'Ligações Úteis','linksPdf','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Matrix','{\"minBlocks\":null,\"maxBlocks\":null,\"contentTable\":\"{{%matrixcontent_linkspdf}}\",\"propagationMethod\":\"all\",\"propagationKeyFormat\":null}','2024-02-22 14:56:25','2024-02-22 14:58:05','ea3b61d5-7e5b-4b00-ac14-8498e58e5592'),(24,NULL,'Documento','document','matrixBlockType:06653406-9909-4c6d-8cb8-a3f1df52467c',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"pdf\",\"powerpoint\",\"text\",\"word\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"documentos\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":1,\"previewMode\":\"thumbs\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":true,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-02-22 14:56:25','2024-02-22 15:02:56','2d13b60a-e774-4457-a865-2a1751584f8f'),(25,NULL,'Label','label','matrixBlockType:06653406-9909-4c6d-8cb8-a3f1df52467c','wzfzgsfg',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-22 14:56:25','2024-02-22 14:56:25','2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b'),(26,8,'Imagens com Link','linkImages','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Matrix','{\"minBlocks\":null,\"maxBlocks\":null,\"contentTable\":\"{{%matrixcontent_linkimages}}\",\"propagationMethod\":\"all\",\"propagationKeyFormat\":null}','2024-02-22 17:40:29','2024-02-22 17:43:21','09728bc0-0ebd-4cf5-ae04-4416b4e9103c'),(27,NULL,'Imagem','image','matrixBlockType:c9027658-85d1-429b-807c-0e4ea12d63a0',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"right-column\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":1,\"previewMode\":\"thumbs\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":true,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-02-22 17:40:29','2024-02-22 17:43:21','4151d77b-d0fe-41f4-bdb6-6a2f9f00d8b3'),(28,NULL,'Image Link','imageLink','matrixBlockType:c9027658-85d1-429b-807c-0e4ea12d63a0','opghxuag',NULL,0,'none',NULL,'craft\\fields\\Url','{\"maxLength\":255,\"types\":[\"url\",\"tel\",\"email\"]}','2024-02-22 17:40:29','2024-02-22 17:40:29','efd17caf-a286-414f-ac89-2bbdbc3ad4b1'),(29,1,'Rich Text','richText','global','bvqpiscs',NULL,0,'none',NULL,'craft\\redactor\\Field','{\"availableTransforms\":\"\",\"availableVolumes\":\"*\",\"columnType\":\"text\",\"configSelectionMode\":\"choose\",\"defaultTransform\":\"\",\"manualConfig\":\"\",\"purifierConfig\":null,\"purifyHtml\":true,\"redactorConfig\":null,\"removeEmptyTags\":false,\"removeInlineStyles\":false,\"removeNbsp\":false,\"showHtmlButtonForNonAdmins\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"uiMode\":\"enlarged\"}','2024-02-22 18:01:20','2024-02-22 18:01:56','795538db-d8cd-4fb9-922b-e9398f128280'),(30,1,'Image','image','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"restrictLocation\":false,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"allowSubfolders\":false,\"restrictedDefaultUploadSubpath\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"{slug}\",\"allowUploads\":true,\"restrictFiles\":false,\"allowedKinds\":null,\"showUnpermittedVolumes\":false,\"showUnpermittedFiles\":false,\"previewMode\":\"thumbs\",\"allowSelfRelations\":false,\"localizeRelations\":false,\"maxRelations\":null,\"minRelations\":null,\"selectionLabel\":null,\"showSiteMenu\":true,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\",\"maintainHierarchy\":false,\"branchLimit\":null}','2024-02-22 18:02:33','2024-02-22 18:03:22','88242a46-c02d-4ea3-b580-d1f5f470c70b'),(31,9,'Tags de Noticias','newsTags','global','gtuinydl',NULL,0,'site',NULL,'craft\\fields\\Tags','{\"allowSelfRelations\":false,\"branchLimit\":null,\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":null,\"selectionLabel\":null,\"showSiteMenu\":true,\"source\":\"taggroup:c1fb845e-e7eb-4cd3-b08e-05465d4cffba\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":null}','2024-02-22 18:04:08','2024-02-22 18:04:37','175b9d48-8313-4b08-b6e5-45633a5ab848'),(32,9,'Categorias','newsCategories','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Categories','{\"allowSelfRelations\":false,\"branchLimit\":null,\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":null,\"selectionLabel\":null,\"showSiteMenu\":true,\"source\":\"group:8ba433f7-e0da-4428-adb3-a8b33ceef2b9\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":null}','2024-02-22 18:07:21','2024-02-22 18:07:45','7c3d6d08-ebc0-4e9d-ae0d-809ab9096549'),(33,2,'SEO','seo','global','cwroofon',NULL,0,'none',NULL,'ether\\seo\\fields\\SeoField','{\"description\":\"\",\"hideSocial\":\"\",\"robots\":[\"\",\"\",\"\",\"\",\"\",\"\"],\"socialImage\":[\"11\"],\"suffixAsPrefix\":null,\"title\":[{\"key\":\"1\",\"locked\":\"0\",\"template\":\"{title}\"},{\"key\":\"2\",\"locked\":\"0\",\"template\":\" - {{ siteName }}\"}],\"titleSuffix\":null}','2024-02-26 16:19:05','2024-02-26 16:23:05','722f4bfc-5260-46a5-821c-beebb86e123d'),(34,9,'Pequena Descrição','shortDescription','global','tyatblvb',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":true,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-02-27 18:00:31','2024-02-27 18:00:31','77d3c1fa-0a42-43f7-92e9-e91a592be391'),(35,10,'Latitude','latitude','global','myhuqhkt',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-03-01 16:42:27','2024-03-01 16:42:27','d8cd947c-079b-440d-9b65-4589c16d23eb'),(36,10,'Longitude','longitude','global','bzgtlbjm',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-03-01 16:42:37','2024-03-01 16:42:37','6e042994-c894-40f0-8b7a-b1ba8bcc666e'),(37,10,'Localização','location','global','jjszxiab',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-03-01 16:43:42','2024-03-01 16:43:42','2c508b12-7986-41f3-835a-3dada05e9433'),(38,10,'Data','date','global','pylrxcat',NULL,0,'none',NULL,'craft\\fields\\Date','{\"max\":null,\"min\":null,\"minuteIncrement\":5,\"showDate\":true,\"showTime\":true,\"showTimeZone\":false}','2024-03-01 17:17:37','2024-03-01 17:18:17','3f7c029c-b6a9-491a-bf4b-7ccdceac3649'),(39,8,'Documentos','documents','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"excel\",\"pdf\",\"powerpoint\",\"text\",\"word\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"defaultUploadLocationSubpath\":\"documents\",\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":\"*\",\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-03-04 11:24:41','2024-03-04 11:24:41','c84d03fe-f80d-4194-ba99-08b7fbfba0ed'),(40,8,'Mostrar Galeria','showGallery','global','ssublcje',NULL,0,'none',NULL,'craft\\fields\\Lightswitch','{\"default\":true,\"offLabel\":\"Não Mostrar\",\"onLabel\":\"Mostrar\"}','2024-03-05 17:13:45','2024-03-05 17:13:45','2423118a-7834-476b-9b22-c9efde226343'),(41,8,'Mostrar Notícias Recentes','showNews','global','alfqkvgz',NULL,0,'none',NULL,'craft\\fields\\Lightswitch','{\"default\":false,\"offLabel\":\"Não mostrar\",\"onLabel\":\"Mostrar\"}','2024-03-05 17:14:21','2024-03-05 17:14:21','098aaa78-a149-4d5e-8832-557a5f2cb95e');
/*!40000 ALTER TABLE `fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_crm_fields`
--

LOCK TABLES `freeform_crm_fields` WRITE;
/*!40000 ALTER TABLE `freeform_crm_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_crm_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_export_notifications`
--

LOCK TABLES `freeform_export_notifications` WRITE;
/*!40000 ALTER TABLE `freeform_export_notifications` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_export_notifications` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_export_profiles`
--

LOCK TABLES `freeform_export_profiles` WRITE;
/*!40000 ALTER TABLE `freeform_export_profiles` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_export_profiles` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_export_settings`
--

LOCK TABLES `freeform_export_settings` WRITE;
/*!40000 ALTER TABLE `freeform_export_settings` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_export_settings` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_feed_messages`
--

LOCK TABLES `freeform_feed_messages` WRITE;
/*!40000 ALTER TABLE `freeform_feed_messages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_feed_messages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_feeds`
--

LOCK TABLES `freeform_feeds` WRITE;
/*!40000 ALTER TABLE `freeform_feeds` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_feeds` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_fields`
--

LOCK TABLES `freeform_fields` WRITE;
/*!40000 ALTER TABLE `freeform_fields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_fields` VALUES (1,'text','firstName','First Name',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','c8927f3c-679b-489d-89e8-bd7dd9fe431b'),(2,'text','lastName','Last Name',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','2670035b-66fe-4bb3-a39e-89c62f414b33'),(3,'email','email','Email',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','30f4fa71-4126-422a-b704-9807c628879d'),(4,'text','website','Website',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','1a07ad34-38af-4877-8529-50346c7d076c'),(5,'text','cellPhone','Cell Phone',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','f2edf3da-a88b-4c20-acf1-ea43bfaf1a00'),(6,'text','homePhone','Home Phone',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','3f66e89d-5205-473c-9ae4-33b3cea8f487'),(7,'text','companyName','Company Name',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','07200ec7-199b-4b14-bdbe-e99924f29299'),(8,'textarea','address','Address',0,NULL,'{\"rows\":2}','2024-03-11 11:24:35','2024-03-11 11:24:35','4c4a0fc5-8b23-4e7c-bb27-8d154be9b629'),(9,'text','city','City',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','4af98a83-0894-4421-86af-663097bc922c'),(10,'select','state','State',0,NULL,'{\"options\":[{\"value\":\"\",\"label\":\"Select a State\"},{\"value\":\"AL\",\"label\":\"Alabama\"},{\"value\":\"AK\",\"label\":\"Alaska\"},{\"value\":\"AZ\",\"label\":\"Arizona\"},{\"value\":\"AR\",\"label\":\"Arkansas\"},{\"value\":\"CA\",\"label\":\"California\"},{\"value\":\"CO\",\"label\":\"Colorado\"},{\"value\":\"CT\",\"label\":\"Connecticut\"},{\"value\":\"DE\",\"label\":\"Delaware\"},{\"value\":\"DC\",\"label\":\"District of Columbia\"},{\"value\":\"FL\",\"label\":\"Florida\"},{\"value\":\"GA\",\"label\":\"Georgia\"},{\"value\":\"HI\",\"label\":\"Hawaii\"},{\"value\":\"ID\",\"label\":\"Idaho\"},{\"value\":\"IL\",\"label\":\"Illinois\"},{\"value\":\"IN\",\"label\":\"Indiana\"},{\"value\":\"IA\",\"label\":\"Iowa\"},{\"value\":\"KS\",\"label\":\"Kansas\"},{\"value\":\"KY\",\"label\":\"Kentucky\"},{\"value\":\"LA\",\"label\":\"Louisiana\"},{\"value\":\"ME\",\"label\":\"Maine\"},{\"value\":\"MD\",\"label\":\"Maryland\"},{\"value\":\"MA\",\"label\":\"Massachusetts\"},{\"value\":\"MI\",\"label\":\"Michigan\"},{\"value\":\"MN\",\"label\":\"Minnesota\"},{\"value\":\"MS\",\"label\":\"Mississippi\"},{\"value\":\"MO\",\"label\":\"Missouri\"},{\"value\":\"MT\",\"label\":\"Montana\"},{\"value\":\"NE\",\"label\":\"Nebraska\"},{\"value\":\"NV\",\"label\":\"Nevada\"},{\"value\":\"NH\",\"label\":\"New Hampshire\"},{\"value\":\"NJ\",\"label\":\"New Jersey\"},{\"value\":\"NM\",\"label\":\"New Mexico\"},{\"value\":\"NY\",\"label\":\"New York\"},{\"value\":\"NC\",\"label\":\"North Carolina\"},{\"value\":\"ND\",\"label\":\"North Dakota\"},{\"value\":\"OH\",\"label\":\"Ohio\"},{\"value\":\"OK\",\"label\":\"Oklahoma\"},{\"value\":\"OR\",\"label\":\"Oregon\"},{\"value\":\"PA\",\"label\":\"Pennsylvania\"},{\"value\":\"RI\",\"label\":\"Rhode Island\"},{\"value\":\"SC\",\"label\":\"South Carolina\"},{\"value\":\"SD\",\"label\":\"South Dakota\"},{\"value\":\"TN\",\"label\":\"Tennessee\"},{\"value\":\"TX\",\"label\":\"Texas\"},{\"value\":\"UT\",\"label\":\"Utah\"},{\"value\":\"VT\",\"label\":\"Vermont\"},{\"value\":\"VA\",\"label\":\"Virginia\"},{\"value\":\"WA\",\"label\":\"Washington\"},{\"value\":\"WV\",\"label\":\"West Virginia\"},{\"value\":\"WI\",\"label\":\"Wisconsin\"},{\"value\":\"WY\",\"label\":\"Wyoming\"}]}','2024-03-11 11:24:35','2024-03-11 11:24:35','6e10c8e7-22eb-43bb-9f10-c6a5fe11d17a'),(11,'text','zipCode','Zip Code',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','9f3c01cf-4b90-4873-89fe-126bdc08c1a0'),(12,'textarea','message','Message',0,NULL,'{\"rows\":5}','2024-03-11 11:24:35','2024-03-11 11:24:35','e97c052c-1c76-4ba8-bcaa-b61c448cf3d7'),(13,'number','number','Number',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','a4ad8672-6624-4d36-9c39-65c5798dced1'),(14,'cc_details','payment','',0,NULL,NULL,'2024-03-11 11:24:35','2024-03-11 11:24:35','91a35fab-3328-4448-9a6d-9e1a72e76d52');
/*!40000 ALTER TABLE `freeform_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms`
--

LOCK TABLES `freeform_forms` WRITE;
/*!40000 ALTER TABLE `freeform_forms` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_forms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_integrations`
--

LOCK TABLES `freeform_integrations` WRITE;
/*!40000 ALTER TABLE `freeform_integrations` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_integrations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_integrations_queue`
--

LOCK TABLES `freeform_integrations_queue` WRITE;
/*!40000 ALTER TABLE `freeform_integrations_queue` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_integrations_queue` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_lock`
--

LOCK TABLES `freeform_lock` WRITE;
/*!40000 ALTER TABLE `freeform_lock` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_lock` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_mailing_list_fields`
--

LOCK TABLES `freeform_mailing_list_fields` WRITE;
/*!40000 ALTER TABLE `freeform_mailing_list_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_mailing_list_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_mailing_lists`
--

LOCK TABLES `freeform_mailing_lists` WRITE;
/*!40000 ALTER TABLE `freeform_mailing_lists` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_mailing_lists` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_notification_log`
--

LOCK TABLES `freeform_notification_log` WRITE;
/*!40000 ALTER TABLE `freeform_notification_log` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_notification_log` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_notifications`
--

LOCK TABLES `freeform_notifications` WRITE;
/*!40000 ALTER TABLE `freeform_notifications` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_notifications` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_payment_gateway_fields`
--

LOCK TABLES `freeform_payment_gateway_fields` WRITE;
/*!40000 ALTER TABLE `freeform_payment_gateway_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_payment_gateway_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_payments_payments`
--

LOCK TABLES `freeform_payments_payments` WRITE;
/*!40000 ALTER TABLE `freeform_payments_payments` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_payments_payments` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_payments_subscription_plans`
--

LOCK TABLES `freeform_payments_subscription_plans` WRITE;
/*!40000 ALTER TABLE `freeform_payments_subscription_plans` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_payments_subscription_plans` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_payments_subscriptions`
--

LOCK TABLES `freeform_payments_subscriptions` WRITE;
/*!40000 ALTER TABLE `freeform_payments_subscriptions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_payments_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_saved_forms`
--

LOCK TABLES `freeform_saved_forms` WRITE;
/*!40000 ALTER TABLE `freeform_saved_forms` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_saved_forms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_session_context`
--

LOCK TABLES `freeform_session_context` WRITE;
/*!40000 ALTER TABLE `freeform_session_context` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_session_context` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_spam_reason`
--

LOCK TABLES `freeform_spam_reason` WRITE;
/*!40000 ALTER TABLE `freeform_spam_reason` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_spam_reason` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_statuses`
--

LOCK TABLES `freeform_statuses` WRITE;
/*!40000 ALTER TABLE `freeform_statuses` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_statuses` VALUES (1,'Pending','pending','light',NULL,1,'2024-03-11 11:24:35','2024-03-11 11:24:35','985f9dc4-b628-4829-8479-975ca4402521'),(2,'Open','open','green',1,2,'2024-03-11 11:24:35','2024-03-11 11:24:35','6bb4b106-6fee-480f-8ff4-eadb2ab0b3e3'),(3,'Closed','closed','grey',NULL,3,'2024-03-11 11:24:35','2024-03-11 11:24:35','6d240683-8585-45ca-bf79-0df2822e4f18');
/*!40000 ALTER TABLE `freeform_statuses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_submission_notes`
--

LOCK TABLES `freeform_submission_notes` WRITE;
/*!40000 ALTER TABLE `freeform_submission_notes` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_submission_notes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_submissions`
--

LOCK TABLES `freeform_submissions` WRITE;
/*!40000 ALTER TABLE `freeform_submissions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_submissions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_unfinalized_files`
--

LOCK TABLES `freeform_unfinalized_files` WRITE;
/*!40000 ALTER TABLE `freeform_unfinalized_files` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_unfinalized_files` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_webhooks`
--

LOCK TABLES `freeform_webhooks` WRITE;
/*!40000 ALTER TABLE `freeform_webhooks` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_webhooks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_webhooks_form_relations`
--

LOCK TABLES `freeform_webhooks_form_relations` WRITE;
/*!40000 ALTER TABLE `freeform_webhooks_form_relations` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_webhooks_form_relations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `globalsets`
--

LOCK TABLES `globalsets` WRITE;
/*!40000 ALTER TABLE `globalsets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `globalsets` VALUES (2,'Header','header',4,2,'2024-02-19 12:20:57','2024-02-19 14:04:49','3e1119c5-f94f-4154-a4fb-afb43b303105'),(3,'Footer','footer',9,4,'2024-02-19 12:21:07','2024-02-22 15:29:00','aa58149c-af35-410e-b08d-bfc93a6e8d9f'),(4,'head','head',2,1,'2024-02-19 12:45:53','2024-02-19 12:53:07','b1e8401f-82c3-4599-ae64-0034608bd86b'),(5,'Organização','organization',3,5,'2024-02-19 12:53:21','2024-02-22 15:29:00','b148a766-6998-48cc-8d1e-45790c4cf220'),(28,'Redes Sociais','socials',7,6,'2024-02-22 14:24:58','2024-02-22 15:29:00','d0c2a04c-3370-4bcb-84db-47ce81ab6643'),(31,'Coluna da Esquerda','leftColumn',10,3,'2024-02-22 14:54:20','2024-02-22 15:29:00','2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c'),(40,'Coluna da Direita','rightColumn',12,7,'2024-02-22 15:29:15','2024-02-22 15:29:15','1f1e8428-3ee2-4875-a0e1-4867fbe7dfee');
/*!40000 ALTER TABLE `globalsets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqlschemas`
--

LOCK TABLES `gqlschemas` WRITE;
/*!40000 ALTER TABLE `gqlschemas` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqlschemas` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqltokens`
--

LOCK TABLES `gqltokens` WRITE;
/*!40000 ALTER TABLE `gqltokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqltokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `imagetransforms`
--

LOCK TABLES `imagetransforms` WRITE;
/*!40000 ALTER TABLE `imagetransforms` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `imagetransforms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `info`
--

LOCK TABLES `info` WRITE;
/*!40000 ALTER TABLE `info` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `info` VALUES (1,'4.8.0','4.5.3.0',1,'xnltlfvbztmn','3@inakousmyk','2024-02-16 17:40:41','2024-03-11 11:25:10','136d5d63-e8cc-4d9a-a803-c8eb4a7c6ec2');
/*!40000 ALTER TABLE `info` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocks`
--

LOCK TABLES `matrixblocks` WRITE;
/*!40000 ALTER TABLE `matrixblocks` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixblocks` VALUES (24,5,15,1,NULL,'2024-02-22 14:18:20','2024-02-22 14:18:20'),(25,5,15,1,NULL,'2024-02-22 14:18:50','2024-02-22 14:18:50'),(26,5,15,1,NULL,'2024-02-22 14:18:50','2024-02-22 14:18:50'),(27,5,15,1,NULL,'2024-02-22 14:18:50','2024-02-22 14:18:50'),(30,28,18,2,NULL,'2024-02-22 14:28:09','2024-02-22 14:28:09'),(33,31,23,3,NULL,'2024-02-22 14:57:56','2024-02-22 14:57:56'),(34,31,23,3,NULL,'2024-02-22 14:58:54','2024-02-22 14:58:54'),(35,31,23,3,NULL,'2024-02-22 14:58:54','2024-02-22 14:58:54'),(36,31,23,3,NULL,'2024-02-22 14:58:54','2024-02-22 14:58:54'),(37,31,23,3,NULL,'2024-02-22 14:58:54','2024-02-22 14:58:54'),(38,31,23,3,NULL,'2024-02-22 14:58:54','2024-02-22 14:58:54'),(45,40,26,4,NULL,'2024-02-22 17:43:11','2024-02-22 17:43:11'),(46,40,26,4,NULL,'2024-02-22 17:43:11','2024-02-22 17:43:11');
/*!40000 ALTER TABLE `matrixblocks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocks_owners`
--

LOCK TABLES `matrixblocks_owners` WRITE;
/*!40000 ALTER TABLE `matrixblocks_owners` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixblocks_owners` VALUES (24,5,1),(25,5,2),(26,5,3),(27,5,4),(30,28,1),(33,31,1),(34,31,2),(35,31,3),(36,31,4),(37,31,5),(38,31,6),(45,40,1),(46,40,2);
/*!40000 ALTER TABLE `matrixblocks_owners` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocktypes`
--

LOCK TABLES `matrixblocktypes` WRITE;
/*!40000 ALTER TABLE `matrixblocktypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixblocktypes` VALUES (1,15,6,'contact','contact',1,'2024-02-22 14:17:49','2024-02-22 14:17:49','f7fb1fe1-d07b-4cd2-bc13-32ccab9e38e3'),(2,18,8,'social','social',1,'2024-02-22 14:26:31','2024-02-22 14:26:31','a66ff91d-fa54-44be-a228-fc1c55be4647'),(3,23,11,'link','link',1,'2024-02-22 14:56:25','2024-02-22 14:56:25','06653406-9909-4c6d-8cb8-a3f1df52467c'),(4,26,13,'link','link',1,'2024-02-22 17:40:29','2024-02-22 17:40:29','c9027658-85d1-429b-807c-0e4ea12d63a0');
/*!40000 ALTER TABLE `matrixblocktypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixcontent_contacts`
--

LOCK TABLES `matrixcontent_contacts` WRITE;
/*!40000 ALTER TABLE `matrixcontent_contacts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixcontent_contacts` VALUES (1,24,1,'2024-02-22 14:18:20','2024-02-22 14:22:29','0c5860ed-fb1f-43c4-94b3-890bfff1a4c6','(+351) 253 000 000','Polícia'),(2,25,1,'2024-02-22 14:18:50','2024-02-22 14:22:29','7b5f9eef-7e6b-4a4e-9084-48d7e8a7934c','(+351) 253 000 000','Quartel dos Bombeiros'),(3,26,1,'2024-02-22 14:18:50','2024-02-22 14:22:29','801eba44-76a4-478a-b5b3-b82d91fdfae4','(+351) 253 000 000','Escola (?)'),(4,27,1,'2024-02-22 14:18:50','2024-02-22 14:22:29','383439e8-94aa-4615-afbf-6f316c3fbea2','(+351) 253 000 000','Escola (?)');
/*!40000 ALTER TABLE `matrixcontent_contacts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixcontent_linkimages`
--

LOCK TABLES `matrixcontent_linkimages` WRITE;
/*!40000 ALTER TABLE `matrixcontent_linkimages` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixcontent_linkimages` VALUES (1,45,1,'2024-02-22 17:43:11','2024-02-22 17:49:39','aa5be893-e199-41e8-9da0-fe440cd07bfc','https://google.com'),(2,46,1,'2024-02-22 17:43:11','2024-02-22 17:49:40','7ca84b6a-e9a2-4b41-8516-7c8f83fd64f7','https://google.com');
/*!40000 ALTER TABLE `matrixcontent_linkimages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixcontent_linkspdf`
--

LOCK TABLES `matrixcontent_linkspdf` WRITE;
/*!40000 ALTER TABLE `matrixcontent_linkspdf` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixcontent_linkspdf` VALUES (1,33,1,'2024-02-22 14:57:56','2024-02-22 14:58:54','4a6b212b-5744-493d-a0aa-555fbe3a4c63','Recolha de Lixo Grosso'),(2,34,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','67470a07-fbaf-47e5-9597-103f55711b21','Recenseamento Militar'),(3,35,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','aef461b4-f21d-4c3f-9af7-269af7893590','Códigos Postais'),(4,36,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','001c513e-43d2-4b25-b9c7-6faee75ff215','Avarias de Iluminação Pública'),(5,37,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','f19a4569-934d-4b28-aece-ff7a335628c0','Serviço de Finanças de Guimarães 2'),(6,38,1,'2024-02-22 14:58:54','2024-02-22 14:58:54','38d0907a-b268-407b-8057-0387cfe7e581','Funerária S. Félix');
/*!40000 ALTER TABLE `matrixcontent_linkspdf` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixcontent_socials`
--

LOCK TABLES `matrixcontent_socials` WRITE;
/*!40000 ALTER TABLE `matrixcontent_socials` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixcontent_socials` VALUES (1,30,1,'2024-02-22 14:28:09','2024-02-22 14:28:09','75034fcb-693c-4ae3-9ca5-b1f7e3159180','https://facebook.com','Facebook');
/*!40000 ALTER TABLE `matrixcontent_socials` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `migrations` VALUES (1,'craft','Install','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','c5fb6e98-6670-4e38-8498-6703035772f2'),(2,'craft','m210121_145800_asset_indexing_changes','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','17dc6c48-8915-42e3-9d83-3d3276df0596'),(3,'craft','m210624_222934_drop_deprecated_tables','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','41ffc141-328b-42d6-b57c-ccab93c60b32'),(4,'craft','m210724_180756_rename_source_cols','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','223d89d9-acfa-416b-86e9-e4cadeb579a8'),(5,'craft','m210809_124211_remove_superfluous_uids','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','1e8e4703-5947-46cf-962f-c829f79b3e4a'),(6,'craft','m210817_014201_universal_users','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','86a0ea29-e29b-4b74-8205-723951ddf9b0'),(7,'craft','m210904_132612_store_element_source_settings_in_project_config','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','57726c38-1823-477d-920d-4abbc4d63fde'),(8,'craft','m211115_135500_image_transformers','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','df636877-9e69-479f-b6f4-84c404bae241'),(9,'craft','m211201_131000_filesystems','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','732e061c-0e9b-4607-a2a4-be44c20ef966'),(10,'craft','m220103_043103_tab_conditions','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','0fbff83d-cc43-45e3-89bc-86b558e424c0'),(11,'craft','m220104_003433_asset_alt_text','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','d91230ec-bd5f-426d-8f55-51120b2b314b'),(12,'craft','m220123_213619_update_permissions','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','a482a0a4-1249-412e-92ff-0fbf3a8fbd2c'),(13,'craft','m220126_003432_addresses','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','6081e3ca-cfa3-46ae-b0b8-08ecaae9e09a'),(14,'craft','m220209_095604_add_indexes','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','efc9732f-0d66-43e5-91d7-1f149d08d7b5'),(15,'craft','m220213_015220_matrixblocks_owners_table','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','b77b1313-ba9c-48c1-8ac7-c49bc4c6c1ff'),(16,'craft','m220214_000000_truncate_sessions','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','945ad1ca-9ac1-4a49-b4df-4467e1344957'),(17,'craft','m220222_122159_full_names','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','bea81685-b2a6-4c17-bcb6-f62aac75a776'),(18,'craft','m220223_180559_nullable_address_owner','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','8461abf7-598d-4af8-a118-3aab888c40c6'),(19,'craft','m220225_165000_transform_filesystems','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','47342d09-da39-4759-a7d1-da93f4554f6c'),(20,'craft','m220309_152006_rename_field_layout_elements','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','ed157e3c-1530-40de-8dcf-4313f523a315'),(21,'craft','m220314_211928_field_layout_element_uids','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','09f212fc-7d7c-49ac-b11f-23959b9dd39f'),(22,'craft','m220316_123800_transform_fs_subpath','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','0aac934f-10b5-42a2-9224-fd418b4d8753'),(23,'craft','m220317_174250_release_all_jobs','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','21a9b865-4f15-4539-897b-a9abf3cb6c10'),(24,'craft','m220330_150000_add_site_gql_schema_components','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','9a46f022-1300-4dd1-817d-e4dac15b5874'),(25,'craft','m220413_024536_site_enabled_string','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','e4d67f82-23de-4610-a376-87847ef4db11'),(26,'craft','m221027_160703_add_image_transform_fill','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','0edf417b-3570-46e1-87e6-a73ce71f2f38'),(27,'craft','m221028_130548_add_canonical_id_index','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','be3f69d2-3c2e-4f4d-92e7-c21d9dc4def1'),(28,'craft','m221118_003031_drop_element_fks','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','968d7fa1-ab43-4cf3-8923-06a4cdc7cc97'),(29,'craft','m230131_120713_asset_indexing_session_new_options','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','43b56d2d-370c-4445-9b80-41eb6f84ed47'),(30,'craft','m230226_013114_drop_plugin_license_columns','2024-02-16 17:40:42','2024-02-16 17:40:42','2024-02-16 17:40:42','02bf8a85-d03b-48f8-9efe-a0eb881c6502'),(31,'craft','m230531_123004_add_entry_type_show_status_field','2024-02-19 12:16:44','2024-02-19 12:16:44','2024-02-19 12:16:44','96707f69-ce65-4351-bfec-39eff37b4eba'),(32,'craft','m230607_102049_add_entrytype_slug_translation_columns','2024-02-19 12:16:44','2024-02-19 12:16:44','2024-02-19 12:16:44','7cf43a55-f6f4-435c-89d0-ca7f886deb58'),(33,'craft','m230710_162700_element_activity','2024-02-19 12:16:44','2024-02-19 12:16:44','2024-02-19 12:16:44','8fb86fbb-f4b7-4fa0-92a0-68743a8f9d16'),(34,'craft','m230820_162023_fix_cache_id_type','2024-02-19 12:16:44','2024-02-19 12:16:44','2024-02-19 12:16:44','c709c6fa-9ec0-4041-afb2-6b7984e1ae1d'),(35,'craft','m230826_094050_fix_session_id_type','2024-02-19 12:16:44','2024-02-19 12:16:44','2024-02-19 12:16:44','83c8817c-886e-4ece-b198-5ab4434961b7'),(36,'plugin:redactor','m180430_204710_remove_old_plugins','2024-02-19 12:18:20','2024-02-19 12:18:20','2024-02-19 12:18:20','d3ddb319-6390-4c9d-a614-6d6005e2935b'),(37,'plugin:redactor','Install','2024-02-19 12:18:20','2024-02-19 12:18:20','2024-02-19 12:18:20','fffb2f9a-2509-4300-a862-83ab0dfb2593'),(38,'plugin:redactor','m190225_003922_split_cleanup_html_settings','2024-02-19 12:18:20','2024-02-19 12:18:20','2024-02-19 12:18:20','5e0bfd1e-8513-4565-a148-21af6d7e4bae'),(39,'plugin:seo','Install','2024-02-19 12:18:29','2024-02-19 12:18:29','2024-02-19 12:18:29','da455c97-8a1e-45c3-bf49-01a03bbf38ae'),(40,'plugin:seo','m180906_152947_add_site_id_to_redirects','2024-02-19 12:18:29','2024-02-19 12:18:29','2024-02-19 12:18:29','c566b1d1-c006-4fe6-b280-d5613cc2ecf7'),(41,'plugin:seo','m190114_152300_upgrade_to_new_data_format','2024-02-19 12:18:29','2024-02-19 12:18:29','2024-02-19 12:18:29','c640fd09-dac3-44ea-9966-a7e3d39d7e1c'),(42,'plugin:seo','m200518_110721_add_order_to_redirects','2024-02-19 12:18:29','2024-02-19 12:18:29','2024-02-19 12:18:29','cbfea1c2-e8be-400c-b033-f5c59bbfe402'),(43,'plugin:seo','m201207_124200_add_product_types_to_sitemap','2024-02-19 12:18:29','2024-02-19 12:18:29','2024-02-19 12:18:29','803dac3e-dfae-4cd0-80c4-9a9bcac2a115'),(44,'plugin:olivemenus','Install','2024-02-22 14:46:50','2024-02-22 14:46:50','2024-02-22 14:46:50','85f88521-8bcd-4ee0-ab01-bbc1572a14ae'),(45,'plugin:olivemenus','m200212_124859_olivemenus_addFieldToMenusItemsTable','2024-02-22 14:46:50','2024-02-22 14:46:50','2024-02-22 14:46:50','f881b759-b4c6-4673-9d3d-71e4ac816bff'),(46,'plugin:olivemenus','m200228_124859_olivemenus_addSiteIdFieldToMenusTable','2024-02-22 14:46:50','2024-02-22 14:46:50','2024-02-22 14:46:50','3c1c7c1e-f7ab-4c94-8bba-d36061eeaaa5'),(47,'plugin:olivemenus','m200515_124130_olivemenus_fixBrokenMultisiteMigrations','2024-02-22 14:46:50','2024-02-22 14:46:50','2024-02-22 14:46:50','4faad1bd-fc3e-47ff-b08d-44932936423b'),(48,'plugin:freeform','Install','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','61f268d0-eebc-4552-a34a-f9dfd199b46f'),(49,'plugin:freeform','m180120_140521_CraftUpgrade','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','123eb6a1-a2e5-4cbc-b7b6-e03d44df2e83'),(50,'plugin:freeform','m180125_124339_UpdateForeignKeyNames','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','a1a50167-b574-46ae-abf7-f98db6625698'),(51,'plugin:freeform','m180214_094247_AddUniqueTokenToSubmissionsAndForms','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','c674aa79-c37c-4f59-871d-19c9f5425c07'),(52,'plugin:freeform','m180220_072652_ChangeFileUploadFieldColumnType','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','5ca04e6a-8fdc-449c-89e4-abcf064b80f4'),(53,'plugin:freeform','m180326_094124_AddIsSpamToSubmissions','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','9962346f-96e7-40a3-8048-52fd1eae30de'),(54,'plugin:freeform','m180405_101920_AddIpAddressToSubmissions','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','5ca870e4-f1e9-4059-9ca9-9941fe4b7584'),(55,'plugin:freeform','m180410_131206_CreateIntegrationsQueue','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','ae791578-79be-414b-82f7-22ca6ae4d456'),(56,'plugin:freeform','m180417_134527_AddMultipleSelectTypeToFields','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','18ffac56-653e-4158-8999-3e4a7d8275b7'),(57,'plugin:freeform','m180430_151626_PaymentGateways','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','5a66139c-5996-4883-b301-a2e7842a496c'),(58,'plugin:freeform','m180508_095131_CreatePaymentGatewayFieldsTable','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','c9f52d9a-5853-4fc9-b7de-f825b94904c5'),(59,'plugin:freeform','m180606_141402_AddConnectionsToFormProperties','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','74add465-3f19-46f6-9107-b8713858560c'),(60,'plugin:freeform','m180730_171628_AddCcDetailsFieldType','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','e2b57299-153e-495b-b19b-c683367dba4c'),(61,'plugin:freeform','m180817_091801_AddRulesToFormProperties','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','b9948449-9fc4-44de-8389-d6e0879f2ab2'),(62,'plugin:freeform','m181112_152751_ChangeTypeEnumColumnsToIndexedText','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','3a71aa05-c029-4544-b17b-2631be7640bd'),(63,'plugin:freeform','m181129_083939_ChangeIntegrationFieldTypeColumnTypeToString','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','86a8504e-1742-4087-9882-edb831fd30ad'),(64,'plugin:freeform','m190501_124050_MergingEditionsMigration','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','40b11d8d-cf05-4da7-a6e4-0fbdb8169291'),(65,'plugin:freeform','m190502_155557_AddCCAndBCCToEmailNotifications','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','5812c0dc-ef17-4606-955e-b62609b367c3'),(66,'plugin:freeform','m190516_085150_AddPresetAssetsToNotifications','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','d0aa21cb-ef67-481d-9c9b-e6c4e6ad5500'),(67,'plugin:freeform','m190529_135307_AddWebhookTables','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','b38386eb-227c-46aa-83a1-7e074e9c79ac'),(68,'plugin:freeform','m190603_160423_UpgradeFreeformHoneypotEnhancement','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','36dfd4e5-65d3-4c43-823f-8d95c0390e3e'),(69,'plugin:freeform','m190604_125112_AddFormLimitSubmissionProperty','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','95cdbd50-1f5d-43ea-b3c4-7fcf0ced2502'),(70,'plugin:freeform','m190610_074840_MigrateScriptInsertLocation','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','5dc84141-8ab3-4982-a0e4-010c39cf5b66'),(71,'plugin:freeform','m190614_103420_AddMissingMetaColumnsToProAndPaymentTables','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','2a5be335-4c36-4efb-a6df-a779a65bce67'),(72,'plugin:freeform','m190617_122427_RemoveBrokenForeignKeys','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','8cad0c6e-d756-42a1-9b00-24183652ab0a'),(73,'plugin:freeform','m190618_142759_AddFixedForeignKeys','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','20280c8a-d4f9-4ed7-868c-11050345b83a'),(74,'plugin:freeform','m190812_125059_AddNotesTable','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','81711a22-1de7-4088-978e-42abbc0c80d7'),(75,'plugin:freeform','m190905_113428_FixIntervalCountNotNullColumn','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','9f2d5cb4-567c-4f51-8196-32daf5ce1889'),(76,'plugin:freeform','m191214_093453_AddExtraPostUrlColumnToForm','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','c46fdf1c-5739-405f-b64d-5f16a0f2fcd2'),(77,'plugin:freeform','m200203_180318_AddSpamReasonTable','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','57391731-a9f4-408a-8980-047bc6d33cc5'),(78,'plugin:freeform','m200214_083115_FixIntegrationQueueIndex','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','d29789d1-2e8e-4d14-9e04-2298a7588e63'),(79,'plugin:freeform','m200616_143808_FormPermissionsUpdate','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','04a4b79b-001e-44b7-a661-77d604fbd4b8'),(80,'plugin:freeform','m200630_103347_IncreaseExportProfileSettingSize','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','aa911093-4fa0-4ec0-93bb-53288be74243'),(81,'plugin:freeform','m200825_124009_SplitPipedriveIntegrationIntoDealsAndLeads','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','4ac6b454-4d89-4fb1-8279-c0e89b859837'),(82,'plugin:freeform','m200907_081059_AddValidationToFormProperties','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','9a3b075d-cf74-43bf-8f0b-cf58ba8ee6de'),(83,'plugin:freeform','m200911_130215_AddReplyToNameToNotifications','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','42f984a4-95f7-4f1e-89bd-f286e7eca540'),(84,'plugin:freeform','m201006_065315_AddFeedTables','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','e15ec6bd-041d-44c8-bf6f-c036ae306328'),(85,'plugin:freeform','m201014_161213_AddFormSortOrder','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','7da3bbc8-a5f1-434a-839d-a25cedee2dc2'),(86,'plugin:freeform','m201027_103933_AddExportProfileDateRanges','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','9f61d2d8-20ad-4ba6-b383-cd5e3bb53beb'),(87,'plugin:freeform','m201209_162655_AddAutoTextColumnToNotifications','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','e3a14762-8711-4554-a4f4-8c9e1be18fb1'),(88,'plugin:freeform','m210105_145259_AddGoogleTagManagerColumnsToForms','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','61f60810-af2b-4166-a712-16dc77140dd5'),(89,'plugin:freeform','m210527_071651_AddDbSessionStorage','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','f8afa279-0f56-43ac-a829-3a06a82f5cee'),(90,'plugin:freeform','m210609_183655_AddContextToUnfinalizedFiles','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','63488e8f-8c5f-415f-86e5-dddc3985ffee'),(91,'plugin:freeform','m210629_172132_AddDateIndexToLockTable','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','7bc86ccd-5ebf-4ff0-b53d-ecbf3b77a907'),(92,'plugin:freeform','m210923_110033_AddSavedFormsTable','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','4c65d8b5-3706-4d12-ae6f-38139d806fc8'),(93,'plugin:freeform','m211109_144235_RemoveContextFromUnfinalizedAssets','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','e40b20f0-2961-437d-84f6-b2ba5e289ab0'),(94,'plugin:freeform','m211227_140312_AddFormTypes','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','83dbf491-83a2-42f1-a136-89352e0d2db0'),(95,'plugin:freeform','m220121_091429_AddUserIdToSubmissions','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','daf8e70b-07e7-44ec-9ad7-f8cf061a7a2d'),(96,'plugin:freeform','m220304_101448_ChangeAccessTokenColumnType','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','65f278a4-9f45-486b-a8a9-1607dc0bf0e0'),(97,'plugin:freeform','m220316_060248_SwitchFormSuccessBehaviourToRedirectReturnUrl','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','02aa13e2-8209-441e-94f2-c196483d832b'),(98,'plugin:freeform','m220322_070819_RenameFormattingTemplates','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','12495ebb-69c9-49d4-a8ab-99c1c0949f94'),(99,'plugin:freeform','m220323_113852_MigrateEmailValuesToString','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','9da1b01f-df72-4616-bf5e-a7e7bdf5b21f'),(100,'plugin:freeform','m220330_111857_SplitSubmissionsTable','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','19e2afa7-f8fb-405f-bed2-c87837d842e6'),(101,'plugin:freeform','m220422_065929_AddExportNotificationsTable','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','725eb654-5eae-4725-9fd3-35c857efd5e0'),(102,'plugin:freeform','m220527_055207_ExpandIntegrationAccessTokenSize','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','e2e5b522-c6a2-43f6-bab4-8e5ae4cee144'),(103,'plugin:freeform','m220530_052327_MigrateFormContentTableNamesToSnakeCase','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','633a85f9-93a3-4b2a-bd9b-c538d9c79474'),(104,'plugin:freeform','m230223_143643_RemoveIntegrationsQueueMailingListFieldIndex','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','4d980b94-4090-468d-b81c-394587c3a9b4'),(105,'plugin:freeform','m230424_010101_announcement_4_0_23','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','f191eaf7-66f2-4683-962b-e8290520f9d9'),(106,'plugin:freeform','m230516_010101_announcement_4_0_24','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','0d634d6b-61ba-42ea-9f98-39247ecffc71'),(107,'plugin:freeform','m230613_010101_announcement_4_1_0','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','06f147ce-8527-4a26-bd0a-ab18bd8f0bc4'),(108,'plugin:freeform','m230901_143430_ChangeLabelFieldColumnType','2024-03-11 11:24:34','2024-03-11 11:24:34','2024-03-11 11:24:34','c445fd98-2b5a-4660-a2d0-f547284994e3');
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `olivemenus`
--

LOCK TABLES `olivemenus` WRITE;
/*!40000 ALTER TABLE `olivemenus` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `olivemenus` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `olivemenus_items`
--

LOCK TABLES `olivemenus_items` WRITE;
/*!40000 ALTER TABLE `olivemenus_items` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `olivemenus_items` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `plugins`
--

LOCK TABLES `plugins` WRITE;
/*!40000 ALTER TABLE `plugins` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `plugins` VALUES (1,'cloner','2.0.4','1.0.0','2024-02-19 12:18:08','2024-02-19 12:18:08','2024-02-19 12:18:08','8872c5a2-c064-4421-b0f1-89bd2205ae42'),(2,'codefield','4.0.12','1.0.0','2024-02-19 12:18:12','2024-02-19 12:18:12','2024-02-20 14:19:49','94bc1bfe-a5e3-4e73-8ff5-249194d8c077'),(3,'redactor','3.0.4','2.3.0','2024-02-19 12:18:20','2024-02-19 12:18:20','2024-02-19 12:18:20','b2808da3-ce46-47b9-a935-c1d6caf6fadd'),(4,'locale-selector','1.0.0','1.0.0','2024-02-19 12:18:24','2024-02-19 12:18:24','2024-02-19 12:18:24','9c00c4bb-242d-4616-aca0-152d778a4c43'),(5,'seo','4.2.2','3.2.0','2024-02-19 12:18:29','2024-02-19 12:18:29','2024-02-20 14:20:01','ef367266-5454-47e2-b10c-86c2e539c1df'),(6,'twig-perversion','3.0.0','1.0.0','2024-02-19 12:18:36','2024-02-19 12:18:36','2024-02-19 12:18:36','65b54825-a056-4f7d-8439-de698680faa0'),(7,'style-inliner','3.0.6','1.0.0','2024-02-19 12:18:42','2024-02-19 12:18:42','2024-02-20 14:20:17','96e7065c-45c3-4e91-8565-fb2b7bd9bef7'),(8,'google-tag-manager','2.0.0','1.1.0','2024-02-20 17:19:36','2024-02-20 17:19:36','2024-02-20 17:19:36','9ae95314-10b1-460f-9e96-3784f683adb1'),(9,'olivemenus','4.0.0','1.1.11','2024-02-22 14:46:50','2024-02-22 14:46:50','2024-02-22 14:46:50','66ec04f1-f0a5-4c7e-a906-d6e0954efbb6'),(10,'freeform','4.1.9','4.2.7','2024-03-11 11:24:33','2024-03-11 11:24:33','2024-03-11 11:24:33','731a9cfc-03aa-4a30-bc89-488e1a1acdf3');
/*!40000 ALTER TABLE `plugins` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `projectconfig`
--

LOCK TABLES `projectconfig` WRITE;
/*!40000 ALTER TABLE `projectconfig` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `projectconfig` VALUES ('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.defaultPlacement','\"end\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elementCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.autocapitalize','true'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.autocomplete','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.autocorrect','true'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.class','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.disabled','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.elementCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.id','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.inputType','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.instructions','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.label','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.max','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.min','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.name','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.orientation','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.placeholder','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.readonly','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.requirable','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.size','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.step','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.tip','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.title','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\TitleField\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.uid','\"5796f2e5-3cee-4ae3-8c7e-d6617460aa48\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.userCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.warning','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.0.width','50'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.elementCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.fieldUid','\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.instructions','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.label','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.required','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.tip','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.uid','\"ab18ba20-f6ce-4a0f-808c-d4effee6687b\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.userCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.warning','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.1.width','50'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.elementCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.fieldUid','\"9bf75c64-3353-4e86-b013-34e66a227011\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.instructions','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.label','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.required','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.tip','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.uid','\"28d89283-bc05-41a3-984e-fb4c19392344\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.userCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.warning','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.2.width','100'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.elementCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.fieldUid','\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.instructions','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.label','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.required','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.tip','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.uid','\"ec1529fa-7f84-49bf-80a9-8b697c617750\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.userCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.warning','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.3.width','50'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.elementCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.fieldUid','\"661451bc-35bc-4d1c-b544-24a4294d9560\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.instructions','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.label','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.required','false'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.tip','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.uid','\"b3d1f247-92c0-498d-9209-877e2eb10edc\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.userCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.warning','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.elements.4.width','50'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.name','\"Conteúdo\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.uid','\"267b4278-55fb-4e21-b7c4-6588172d03f6\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.fieldLayouts.0b05e4ea-c344-4584-b273-a11973d23684.tabs.0.userCondition','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.handle','\"collectivities\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.name','\"Coletividades\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.hasUrls','true'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.template','null'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.uriFormat','\"coletividades/{slug}\"'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.structure.maxLevels','1'),('categoryGroups.2d5aa6b3-4738-4a1d-a26d-d6b9266791c1.structure.uid','\"dd219885-f691-47b8-8053-58b9ad3da7b5\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.defaultPlacement','\"end\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elementCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.autocapitalize','true'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.autocomplete','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.autocorrect','true'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.class','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.disabled','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.elementCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.id','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.inputType','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.instructions','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.label','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.max','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.min','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.name','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.orientation','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.placeholder','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.readonly','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.requirable','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.size','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.step','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.tip','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.title','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\TitleField\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.uid','\"12c2d326-5eeb-4176-a9dc-ffcb13ff7e81\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.userCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.warning','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.0.width','50'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.elementCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.fieldUid','\"dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.instructions','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.label','\"Cargo\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.required','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.tip','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.uid','\"b74da684-659e-41ed-9db9-17eb76b26258\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.userCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.warning','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.1.width','25'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.elementCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.fieldUid','\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.instructions','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.label','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.required','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.tip','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.uid','\"ae15ea40-daf0-4b58-9aa1-467eccef7de3\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.userCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.warning','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.2.width','25'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.elementCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.fieldUid','\"661451bc-35bc-4d1c-b544-24a4294d9560\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.instructions','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.label','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.required','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.tip','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.uid','\"fa288df4-38c1-4fb3-b405-9953d248b33d\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.userCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.warning','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.3.width','50'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.elementCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.fieldUid','\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.instructions','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.label','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.required','false'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.tip','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.uid','\"5bad0c9b-0265-4921-b1e9-4834b5781229\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.userCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.warning','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.elements.4.width','50'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.name','\"Conteúdo\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.uid','\"9a6c1e2b-a6ec-436a-861f-d6972ca393cc\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.fieldLayouts.49250a5d-ee8d-4410-b2a9-5f2bbcb13fdf.tabs.0.userCondition','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.handle','\"executive\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.name','\"Executivo\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.hasUrls','true'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.template','null'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.uriFormat','\"executivo/{slug}\"'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.structure.maxLevels','1'),('categoryGroups.68f7d9df-fe3d-4d7c-be39-7b7f58458e91.structure.uid','\"586e0a58-9035-4226-a43b-a7acaf980250\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.defaultPlacement','\"end\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elementCondition','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.autocapitalize','true'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.autocomplete','false'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.autocorrect','true'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.class','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.disabled','false'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.elementCondition','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.id','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.inputType','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.instructions','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.label','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.max','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.min','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.name','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.orientation','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.placeholder','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.readonly','false'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.requirable','false'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.size','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.step','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.tip','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.title','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\TitleField\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.uid','\"a8f778c4-32d0-4751-9cbe-e24328a85a37\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.userCondition','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.warning','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.elements.0.width','100'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.name','\"Conteúdo\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.uid','\"17d761ea-caf0-4c8a-8b6e-e1aabf5c07fe\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.fieldLayouts.dc33d828-416a-4059-87c0-3e4f5ceef145.tabs.0.userCondition','null'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.handle','\"categoriasDeNoticias\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.name','\"Categorias de Noticias\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.hasUrls','true'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.template','\"news/_category.twig\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.uriFormat','\"noticias/{slug}\"'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.structure.maxLevels','1'),('categoryGroups.8ba433f7-e0da-4428-adb3-a8b33ceef2b9.structure.uid','\"6379f086-6bae-4e82-9627-27349df3fb55\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.defaultPlacement','\"end\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elementCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.autocapitalize','true'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.autocomplete','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.autocorrect','true'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.class','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.disabled','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.elementCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.id','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.inputType','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.instructions','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.label','\"Nome\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.max','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.min','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.name','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.orientation','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.placeholder','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.readonly','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.requirable','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.size','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.step','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.tip','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.title','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\TitleField\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.uid','\"0ffe551a-2931-49d8-9b08-ed47747ba6ca\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.userCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.warning','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.0.width','50'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.elementCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.fieldUid','\"dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.instructions','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.label','\"Cargo\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.required','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.tip','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.uid','\"ce66162d-2e8f-4a4a-98a5-0fd181fd03cf\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.userCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.warning','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.1.width','25'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.elementCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.fieldUid','\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.instructions','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.label','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.required','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.tip','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.uid','\"6382fb50-b10a-4a83-a1a0-9d19596effc9\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.userCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.warning','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.2.width','25'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.elementCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.fieldUid','\"661451bc-35bc-4d1c-b544-24a4294d9560\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.instructions','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.label','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.required','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.tip','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.uid','\"4a5ad8da-cc7d-4f81-8fcb-0d1f25bdf534\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.userCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.warning','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.3.width','50'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.elementCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.fieldUid','\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.instructions','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.label','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.required','false'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.tip','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.uid','\"384273ee-1f42-4d8c-909f-4d18e7306f26\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.userCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.warning','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.elements.4.width','50'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.name','\"Conteúdo\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.uid','\"3ce886dc-7873-4f97-88af-b29a06d355d1\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.fieldLayouts.488cdbc6-757d-4910-ab6a-628a83cc4ad4.tabs.0.userCondition','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.handle','\"members\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.name','\"Membros da Assembleia\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.hasUrls','true'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.template','null'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.siteSettings.26c2b616-574d-43e2-b10c-e89b7a84b056.uriFormat','\"membros-da-assembleia/{slug}\"'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.structure.maxLevels','1'),('categoryGroups.ba11131d-df2e-4907-845c-d15ce05aa210.structure.uid','\"5d396e5a-711c-4e44-9035-2f460134d1eb\"'),('dateModified','1710156294'),('email.fromEmail','\"dev@primariu.pt\"'),('email.fromName','\"Junta Cooperativamaismesaofrio\"'),('email.transportType','\"craft\\\\mail\\\\transportadapters\\\\Sendmail\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elementCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.autocapitalize','true'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.autocomplete','false'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.autocorrect','true'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.class','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.disabled','false'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.elementCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.id','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.inputType','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.instructions','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.label','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.max','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.min','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.name','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.orientation','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.placeholder','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.readonly','false'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.requirable','false'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.size','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.step','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.tip','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.title','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.uid','\"0ef10d66-7f1c-4634-9144-2fba4e66cac9\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.userCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.warning','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.0.width','100'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.elementCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.instructions','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.label','\"Conteudo\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.required','false'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.tip','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.uid','\"9115923e-b3b1-401d-94ba-f2fe0c444fa3\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.userCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.warning','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.elements.1.width','100'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.name','\"Conteúdo\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.uid','\"45107f5a-c628-4862-9115-098092483826\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.0.userCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elementCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.elementCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.instructions','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.label','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.required','false'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.tip','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.uid','\"c5e9eabf-7028-4175-8b54-93d7dd9e52b6\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.userCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.warning','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.elements.0.width','100'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.name','\"SEO\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.uid','\"2836cad6-c441-4e60-9440-01c359a47e9b\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.fieldLayouts.b517f335-8ed0-46db-8b1b-7ab97a94d370.tabs.1.userCondition','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.handle','\"assembleia\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.hasTitleField','true'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.name','\"Assembleia de Freguesia\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.section','\"29ddb763-21fc-4466-a933-a21a9bbafc30\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.showStatusField','true'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.slugTranslationKeyFormat','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.slugTranslationMethod','\"site\"'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.sortOrder','4'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.titleFormat','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.titleTranslationKeyFormat','null'),('entryTypes.0ebc5ab9-ce7c-4da2-9387-a0f77357b2c4.titleTranslationMethod','\"site\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elementCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.autocapitalize','true'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.autocomplete','false'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.autocorrect','true'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.class','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.disabled','false'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.elementCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.id','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.inputType','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.instructions','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.label','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.max','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.min','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.name','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.orientation','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.placeholder','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.readonly','false'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.requirable','false'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.size','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.step','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.tip','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.title','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.uid','\"b95e0e01-8519-47c8-a7a0-2218458b868c\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.userCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.warning','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.0.width','100'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.elementCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.fieldUid','\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.instructions','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.label','\"Imagens\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.required','false'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.tip','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.uid','\"710dce4d-4d15-4e62-b039-03843ca65822\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.userCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.warning','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.elements.1.width','100'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.name','\"Conteúdo\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.uid','\"f4adeacc-dcc4-43d9-a02d-65dd45877339\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.0.userCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elementCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.elementCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.instructions','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.label','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.required','false'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.tip','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.uid','\"56265a0c-fa0d-4210-b3e5-ec3b240a2d7d\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.userCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.warning','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.elements.0.width','100'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.name','\"SEO\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.uid','\"e94681db-3f1d-4427-9a5e-4ab6e80b4a36\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.fieldLayouts.59258b63-b925-447c-b816-d43e50df272c.tabs.1.userCondition','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.handle','\"galleryItems\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.hasTitleField','true'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.name','\"Padrão\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.section','\"e9ab0f05-46bc-41e6-93c1-96d39fc051fd\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.showStatusField','true'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.slugTranslationKeyFormat','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.slugTranslationMethod','\"site\"'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.sortOrder','1'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.titleFormat','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.titleTranslationKeyFormat','null'),('entryTypes.3ad082f1-c053-47ac-8a3c-02233591984a.titleTranslationMethod','\"site\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elementCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.autocapitalize','true'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.autocomplete','false'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.autocorrect','true'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.class','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.disabled','false'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.elementCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.id','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.inputType','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.instructions','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.label','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.max','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.min','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.name','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.orientation','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.placeholder','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.readonly','false'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.requirable','false'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.size','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.step','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.tip','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.title','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.uid','\"c208f0aa-82d4-48fd-a507-4203d7551721\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.userCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.warning','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.elements.0.width','100'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.name','\"Conteúdo\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.uid','\"0e1231d4-0f86-4d3e-baa3-7a97bc58c1ab\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.0.userCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elementCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.elementCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.instructions','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.label','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.required','false'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.tip','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.uid','\"607c5fcc-573f-4dad-9fe9-62e2ce678b23\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.userCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.warning','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.0.width','100'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.elementCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.instructions','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.label','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.required','false'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.tip','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.uid','\"93dffbe3-78cd-43c4-99be-b2ba7c9070c9\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.userCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.warning','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.elements.1.width','100'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.uid','\"fc4345ef-5018-4a1a-802a-e20049e031a3\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.1.userCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elementCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.elementCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.instructions','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.label','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.required','false'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.tip','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.uid','\"4b30ac6d-9550-467b-8492-20a7642b8d40\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.userCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.warning','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.elements.0.width','100'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.name','\"SEO\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.uid','\"96a64b91-82f8-49bc-9b6c-f72e951ef897\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.fieldLayouts.20b7a09a-8139-497b-a498-ec0d694219c7.tabs.2.userCondition','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.handle','\"news\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.hasTitleField','true'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.name','\"Página de Noticias\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.section','\"549f7ee1-8c62-4317-9761-6bce22934757\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.showStatusField','true'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.slugTranslationKeyFormat','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.slugTranslationMethod','\"site\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.sortOrder','1'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.titleFormat','\"{section.name|raw}\"'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.titleTranslationKeyFormat','null'),('entryTypes.3f088581-ae6a-423e-963e-2e4dcfe83e68.titleTranslationMethod','\"site\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elementCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.autocapitalize','true'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.autocomplete','false'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.autocorrect','true'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.class','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.disabled','false'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.elementCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.id','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.inputType','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.instructions','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.label','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.max','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.min','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.name','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.orientation','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.placeholder','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.readonly','false'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.requirable','false'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.size','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.step','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.tip','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.title','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.uid','\"e4d6a476-683b-4844-9e40-35f0b03785ee\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.userCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.warning','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.elements.0.width','100'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.name','\"Conteúdo\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.uid','\"e3167cb4-2b26-4bba-a6fb-3243de8b8c41\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.0.userCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elementCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.elementCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.instructions','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.label','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.required','false'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.tip','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.uid','\"6c1abffc-8b31-47a6-b16b-e9e36d09d53f\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.userCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.warning','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.0.width','100'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.elementCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.instructions','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.label','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.required','false'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.tip','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.uid','\"79a36657-0e01-4622-999e-103a7c21af7b\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.userCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.warning','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.elements.1.width','100'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.uid','\"cf8a49e7-2a73-4d92-91f3-a8e998b1f5ce\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.1.userCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elementCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.elementCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.instructions','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.label','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.required','false'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.tip','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.uid','\"6364d78b-b77a-4ff1-96ab-76cd62ae6f01\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.userCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.warning','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.elements.0.width','100'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.name','\"SEO\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.uid','\"faf45306-536b-4f6a-bb86-5ec8c197d223\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.fieldLayouts.6781505a-92c2-49e7-a0f5-6620d4393b2a.tabs.2.userCondition','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.handle','\"gallery\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.hasTitleField','true'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.name','\"Galeria\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.section','\"c9257a0a-b7bd-4e2d-a09a-b69cc87cbaf2\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.showStatusField','true'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.slugTranslationKeyFormat','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.slugTranslationMethod','\"site\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.sortOrder','1'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.titleFormat','\"{section.name|raw}\"'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.titleTranslationKeyFormat','null'),('entryTypes.4817e2ca-af0a-4d5a-b7de-77c98ebd01cc.titleTranslationMethod','\"site\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.autocapitalize','true'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.autocomplete','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.autocorrect','true'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.class','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.disabled','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.id','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.inputType','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.instructions','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.label','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.max','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.min','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.name','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.orientation','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.placeholder','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.readonly','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.requirable','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.size','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.step','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.tip','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.title','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.uid','\"f9dc10f2-0114-448f-82ef-52b00cc38bce\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.warning','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.0.width','100'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.instructions','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.label','\"Conteúdo\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.required','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.tip','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.uid','\"2afa0be9-24e3-4670-9b87-c78b809bf9f0\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.warning','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.elements.1.width','100'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.name','\"Conteúdo\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.uid','\"4e774542-7b95-4cf7-bfa3-780db0331903\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.0.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.instructions','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.label','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.required','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.tip','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.uid','\"fc991cee-dd6b-4739-adbb-38a9304fccc7\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.warning','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.0.width','100'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.instructions','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.label','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.required','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.tip','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.uid','\"2c768d83-4990-484a-84ab-10b042892e6d\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.warning','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.elements.1.width','100'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.uid','\"bea54ae7-ccb5-498e-a8ca-d5b7379bc86e\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.1.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.elementCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.instructions','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.label','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.required','false'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.tip','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.uid','\"07a835a3-0ed2-4706-9ff5-704e07e45171\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.warning','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.elements.0.width','100'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.name','\"SEO\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.uid','\"5a526286-339e-4ad2-9eaa-244b03c040e1\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.fieldLayouts.b80cc7dc-ab55-4c99-9401-ea3ad94197d3.tabs.2.userCondition','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.handle','\"politicaDePrivacidade\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.hasTitleField','true'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.name','\"Política de privacidade\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.section','\"2d817743-be4e-4769-8c53-7c6f36f97eb5\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.showStatusField','true'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.slugTranslationKeyFormat','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.slugTranslationMethod','\"site\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.sortOrder','1'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.titleFormat','\"{section.name|raw}\"'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.titleTranslationKeyFormat','null'),('entryTypes.50be33a7-5514-4801-9166-562bbdc1278a.titleTranslationMethod','\"site\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elementCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.autocapitalize','true'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.autocomplete','false'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.autocorrect','true'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.class','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.disabled','false'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.elementCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.id','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.inputType','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.instructions','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.label','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.max','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.min','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.name','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.orientation','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.placeholder','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.readonly','false'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.requirable','false'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.size','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.step','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.tip','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.title','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.uid','\"5636a001-44f9-41a0-bcb8-23d5242847ca\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.userCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.warning','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.elements.0.width','100'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.name','\"Conteúdo\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.uid','\"669bdd04-0eee-4469-b69a-1b7251af0bf3\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.0.userCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elementCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.elementCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.instructions','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.label','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.required','false'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.tip','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.uid','\"246ae813-81c9-4a96-b246-104aa63347dd\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.userCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.warning','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.0.width','100'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.elementCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.instructions','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.label','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.required','false'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.tip','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.uid','\"d1e46d93-98ff-4394-96b7-189569a5c424\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.userCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.warning','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.elements.1.width','100'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.uid','\"412b7ade-3d26-456b-a28d-3a6481e5efa0\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.1.userCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elementCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.elementCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.instructions','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.label','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.required','false'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.tip','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.uid','\"54ef58b9-0315-479e-8bb7-17ffc75f24e8\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.userCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.warning','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.elements.0.width','100'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.name','\"SEO\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.uid','\"a14d3caa-288b-4d7f-b65b-40aa88285cdd\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.fieldLayouts.9c4261c1-eb69-4a5b-aaa9-f5e0ab0b7510.tabs.2.userCondition','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.handle','\"home\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.hasTitleField','true'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.name','\"Inicio\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.section','\"4c738b94-d3e8-46f8-854c-f39a6542afc6\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.showStatusField','true'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.slugTranslationKeyFormat','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.slugTranslationMethod','\"site\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.sortOrder','1'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.titleFormat','\"{section.name|raw}\"'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.titleTranslationKeyFormat','null'),('entryTypes.5916ccc3-289a-425c-ac57-30733262cd95.titleTranslationMethod','\"site\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elementCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.autocapitalize','true'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.autocomplete','false'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.autocorrect','true'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.class','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.disabled','false'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.elementCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.id','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.inputType','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.instructions','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.label','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.max','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.min','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.name','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.orientation','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.placeholder','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.readonly','false'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.requirable','false'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.size','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.step','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.tip','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.title','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.uid','\"afacfa93-8219-40c6-b4f2-373905a4db12\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.userCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.warning','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.elements.0.width','100'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.name','\"Conteúdo\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.uid','\"bfd6421c-ce17-4af9-a251-7163086f07d2\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.0.userCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elementCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.elementCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.instructions','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.label','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.required','false'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.tip','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.uid','\"406ee2a1-0180-4a49-ba94-fe7d207d7a09\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.userCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.warning','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.0.width','100'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.elementCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.instructions','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.label','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.required','false'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.tip','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.uid','\"0c17338f-39f7-43aa-8e45-c30f8f72e800\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.userCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.warning','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.elements.1.width','100'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.uid','\"458e3523-2c1d-427b-9ec9-55d6d60f2e04\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.1.userCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elementCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.elementCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.instructions','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.label','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.required','false'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.tip','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.uid','\"6a6f7021-0108-4f68-a431-b5f750b77bf6\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.userCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.warning','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.elements.0.width','100'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.name','\"SEO\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.uid','\"b246d27f-9447-4be8-a78d-4130304933e7\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.fieldLayouts.d81e1789-2034-4397-a8af-0e07f27ff91e.tabs.2.userCondition','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.handle','\"collectivities\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.hasTitleField','true'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.name','\"Coletividades\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.section','\"75a2c2c3-b446-43a4-994e-67145a640218\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.showStatusField','true'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.slugTranslationKeyFormat','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.slugTranslationMethod','\"site\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.sortOrder','1'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.titleFormat','\"{section.name|raw}\"'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.titleTranslationKeyFormat','null'),('entryTypes.67c8fccf-b525-4af2-8351-b781b203e37a.titleTranslationMethod','\"site\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.autocapitalize','true'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.autocomplete','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.autocorrect','true'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.class','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.disabled','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.id','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.inputType','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.instructions','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.label','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.max','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.min','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.name','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.orientation','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.placeholder','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.readonly','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.requirable','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.size','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.step','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.tip','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.title','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.uid','\"588f97e5-7d1d-4b04-b706-b2a911a85e16\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.warning','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.0.width','100'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.instructions','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.label','\"Conteudo\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.required','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.tip','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.uid','\"07547fef-4f34-428a-aee8-7f8e5b465880\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.warning','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.elements.1.width','100'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.name','\"Conteúdo\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.uid','\"4d0dc63b-0c9d-4574-9208-eecc18930c66\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.0.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.instructions','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.label','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.required','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.tip','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.uid','\"9adc6f94-af4e-474a-8f76-18023bf74fd0\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.warning','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.0.width','100'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.instructions','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.label','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.required','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.tip','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.uid','\"8163169d-5bf4-47d8-9321-077c66f20a6f\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.warning','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.elements.1.width','100'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.uid','\"13d8b4af-9986-4b0a-930f-0091b7e8a51a\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.1.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.elementCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.instructions','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.label','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.required','false'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.tip','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.uid','\"6a4ceacd-fda7-45ab-ace5-948980f14f69\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.warning','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.elements.0.width','100'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.name','\"SEO\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.uid','\"10f3c04f-b93a-41b9-b21d-41da53595ea6\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.fieldLayouts.81d68572-e1f1-4d05-accd-de3234308186.tabs.2.userCondition','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.handle','\"message\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.hasTitleField','true'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.name','\"Mensagem do Presidente\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.section','\"29ddb763-21fc-4466-a933-a21a9bbafc30\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.showStatusField','true'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.slugTranslationKeyFormat','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.slugTranslationMethod','\"site\"'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.sortOrder','3'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.titleFormat','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.titleTranslationKeyFormat','null'),('entryTypes.6c642c6f-07e2-41b2-97bb-5795209fbd4f.titleTranslationMethod','\"site\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.autocapitalize','true'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.autocomplete','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.autocorrect','true'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.class','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.disabled','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.id','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.inputType','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.instructions','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.label','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.max','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.min','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.name','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.orientation','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.placeholder','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.readonly','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.requirable','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.size','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.step','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.tip','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.title','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.uid','\"b3f95136-9030-4431-aac7-f8fc2e76dc98\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.warning','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.0.width','100'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.instructions','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.label','\"Conteudo\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.required','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.tip','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.uid','\"65af5573-8cee-4e77-8cbc-af6238e6f35d\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.warning','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.elements.1.width','100'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.name','\"Conteúdo\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.uid','\"542a74a7-0b68-4882-9f79-812cce5c1023\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.0.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.instructions','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.label','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.required','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.tip','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.uid','\"a1b58cc5-6c6e-492d-aef5-e8b9d110c74f\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.warning','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.0.width','100'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.instructions','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.label','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.required','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.tip','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.uid','\"bfcacf1b-8857-47e5-a6eb-722c4879ce3b\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.warning','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.elements.1.width','100'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.uid','\"df6afe3a-149f-4347-8475-a6a208eb7815\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.1.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.elementCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.instructions','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.label','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.required','false'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.tip','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.uid','\"9af11eae-b4fe-417d-87a2-583f0cbc8208\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.warning','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.elements.0.width','100'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.name','\"SEO\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.uid','\"0823819d-9b1d-4b44-923d-2521308c408f\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.fieldLayouts.28497d72-5f3b-4ef1-9d13-7618b713008d.tabs.2.userCondition','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.handle','\"freguesia\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.hasTitleField','true'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.name','\"Freguesia\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.section','\"29ddb763-21fc-4466-a933-a21a9bbafc30\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.showStatusField','true'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.slugTranslationKeyFormat','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.slugTranslationMethod','\"site\"'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.sortOrder','2'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.titleFormat','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.titleTranslationKeyFormat','null'),('entryTypes.7690ee6a-7c32-4e09-a13f-3f2043bc53e6.titleTranslationMethod','\"site\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.autocapitalize','true'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.autocomplete','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.autocorrect','true'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.class','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.disabled','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.id','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.inputType','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.instructions','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.label','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.max','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.min','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.name','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.orientation','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.placeholder','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.readonly','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.requirable','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.size','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.step','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.tip','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.title','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.uid','\"f219ca1b-4052-4e94-829f-66b38cd0b052\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.warning','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.0.width','100'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.instructions','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.label','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.required','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.tip','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.uid','\"e4205e4f-6f0d-472b-a945-cf25023857e3\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.warning','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.elements.1.width','100'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.name','\"Conteúdo\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.uid','\"0a0f35e9-72bc-4c66-bae0-7b409f2e7434\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.0.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.instructions','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.label','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.required','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.tip','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.uid','\"1bdc459f-f087-48aa-b1d7-6a384bb15703\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.warning','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.0.width','100'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.instructions','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.label','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.required','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.tip','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.uid','\"05248056-4ef2-4cd2-8c98-b8ec3d4132b8\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.warning','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.elements.1.width','100'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.uid','\"f9931f1c-2b43-4ce8-bd39-905b004d375f\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.1.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.elementCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.instructions','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.label','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.required','false'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.tip','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.uid','\"d7535b2d-bdc8-4b49-94a6-91484765626f\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.warning','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.elements.0.width','100'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.name','\"SEO\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.uid','\"266cd40f-f0fb-4603-967c-4b2a2156c518\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.fieldLayouts.97cd0d1e-d9bf-4bba-9839-60f2df92afde.tabs.2.userCondition','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.handle','\"default\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.hasTitleField','true'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.name','\"Padrão\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.section','\"58ffa59b-a5a0-432d-9fcd-2d5bd4b17d35\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.showStatusField','true'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.slugTranslationKeyFormat','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.slugTranslationMethod','\"site\"'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.sortOrder','1'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.titleFormat','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.titleTranslationKeyFormat','null'),('entryTypes.779a12af-77f7-4a03-b08e-ce735335c60c.titleTranslationMethod','\"site\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elementCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.autocapitalize','true'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.autocomplete','false'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.autocorrect','true'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.class','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.disabled','false'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.elementCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.id','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.inputType','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.instructions','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.label','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.max','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.min','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.name','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.orientation','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.placeholder','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.readonly','false'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.requirable','false'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.size','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.step','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.tip','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.title','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.uid','\"16d1b29e-dda1-4cd1-a4b1-872a21027042\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.userCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.warning','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.elements.0.width','100'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.name','\"Conteúdo\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.uid','\"eebad716-8e8f-44cc-9465-76b4c2a0fce0\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.0.userCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elementCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.elementCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.instructions','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.label','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.required','false'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.tip','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.uid','\"c8d97049-0bdc-4adc-8cea-62536f06c26d\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.userCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.warning','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.0.width','100'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.elementCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.instructions','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.label','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.required','false'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.tip','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.uid','\"4f070e67-f28a-4203-b64d-9be69d406616\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.userCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.warning','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.elements.1.width','100'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.uid','\"08f95854-d8b5-437e-9caf-1b778a12490b\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.1.userCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elementCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.elementCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.instructions','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.label','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.required','false'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.tip','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.uid','\"81a3150a-735a-4723-b200-73430372ba40\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.userCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.warning','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.elements.0.width','100'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.name','\"SEO\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.uid','\"2bc9c892-5edd-4c8b-a962-42d66ea1f9ee\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.fieldLayouts.b62663b8-dfc0-4717-b03e-55c0021a8dd7.tabs.2.userCondition','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.handle','\"eventsPage\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.hasTitleField','true'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.name','\"Página de Eventos\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.section','\"35754529-e923-4d2b-b1d4-40b38652f4a1\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.showStatusField','true'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.slugTranslationKeyFormat','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.slugTranslationMethod','\"site\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.sortOrder','1'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.titleFormat','\"{section.name|raw}\"'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.titleTranslationKeyFormat','null'),('entryTypes.96c34112-5a91-44da-a395-4437349d77f5.titleTranslationMethod','\"site\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.autocapitalize','true'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.autocomplete','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.autocorrect','true'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.class','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.disabled','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.id','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.inputType','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.instructions','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.label','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.max','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.min','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.name','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.orientation','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.placeholder','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.readonly','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.requirable','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.size','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.step','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.tip','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.title','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.uid','\"15c0d1b2-1a99-4389-99be-2b609c01d368\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.warning','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.0.width','100'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.instructions','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.label','\"Mensagem do presidente\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.required','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.tip','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.uid','\"9a502b06-8322-4750-ac66-879b6ccfdd9a\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.warning','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.elements.1.width','100'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.name','\"Conteúdo\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.uid','\"a6d39571-3792-4fd9-b7f4-f0e3b28f96cb\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.0.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.instructions','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.label','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.required','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.tip','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.uid','\"e29fbdda-bfe3-46f0-872d-c54c9b309fd4\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.warning','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.0.width','100'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.instructions','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.label','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.required','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.tip','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.uid','\"de3d3f15-7148-49bf-829c-2b1a3a05e5bc\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.warning','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.elements.1.width','100'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.uid','\"f9638fd3-2834-48e6-967f-b84ac77868a0\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.1.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.elementCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.instructions','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.label','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.required','false'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.tip','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.uid','\"60166a38-54cf-4930-9814-8bd644b425d0\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.warning','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.elements.0.width','100'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.name','\"SEO\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.uid','\"3c6dde44-4c7d-4ee5-9f3c-f668a900fc99\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.fieldLayouts.92b28aec-8e65-48d5-a867-28de2d1f83b9.tabs.2.userCondition','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.handle','\"juntaFreguesia\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.hasTitleField','true'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.name','\"Junta Freguesia\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.section','\"29ddb763-21fc-4466-a933-a21a9bbafc30\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.showStatusField','true'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.slugTranslationKeyFormat','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.slugTranslationMethod','\"site\"'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.sortOrder','1'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.titleFormat','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.titleTranslationKeyFormat','null'),('entryTypes.9cf73107-1556-4f7c-a581-e0fce81cd6ad.titleTranslationMethod','\"site\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elementCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.autocapitalize','true'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.autocomplete','false'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.autocorrect','true'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.class','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.disabled','false'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.elementCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.id','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.inputType','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.instructions','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.label','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.max','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.min','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.name','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.orientation','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.placeholder','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.readonly','false'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.requirable','false'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.size','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.step','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.tip','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.title','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.uid','\"171295c1-f607-411a-b238-60b172d8c130\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.userCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.warning','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.0.width','100'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.elementCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.instructions','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.label','\"Conteudo\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.required','false'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.tip','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.uid','\"54308cda-1367-4426-9238-cd8fe63b880a\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.userCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.warning','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.elements.1.width','100'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.name','\"Conteúdo\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.uid','\"5ecc4dbc-726a-43d8-9005-77b7554243a1\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.0.userCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elementCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.elementCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.instructions','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.label','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.required','false'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.tip','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.uid','\"9c123ee6-fb27-4e99-9a2f-10b9c797d932\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.userCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.warning','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.elements.0.width','100'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.name','\"SEO\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.uid','\"aae6206d-bb79-454c-9b01-bde66cb44324\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.fieldLayouts.41e2a985-40a6-42a0-b02a-362a351960af.tabs.1.userCondition','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.handle','\"executive\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.hasTitleField','true'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.name','\"Executivo\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.section','\"29ddb763-21fc-4466-a933-a21a9bbafc30\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.showStatusField','true'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.slugTranslationKeyFormat','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.slugTranslationMethod','\"site\"'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.sortOrder','5'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.titleFormat','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.titleTranslationKeyFormat','null'),('entryTypes.b31ba4f6-7968-4e4d-9e68-902b17cceea8.titleTranslationMethod','\"site\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.autocapitalize','true'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.autocomplete','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.autocorrect','true'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.class','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.disabled','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.id','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.inputType','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.instructions','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.label','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.max','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.min','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.name','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.orientation','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.placeholder','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.readonly','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.requirable','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.size','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.step','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.tip','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.title','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.uid','\"431ac07e-b0aa-43f9-8a32-d2a8da622d80\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.warning','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.0.width','50'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.fieldUid','\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.instructions','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.label','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.required','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.tip','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.uid','\"4db7e58c-35d3-41e4-b531-a41aa338a944\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.warning','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.1.width','50'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.fieldUid','\"175b9d48-8313-4b08-b6e5-45633a5ab848\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.instructions','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.label','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.required','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.tip','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.uid','\"6095191e-39fe-4e53-9f5d-8b3e3f1b02bb\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.warning','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.2.width','50'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.fieldUid','\"7c3d6d08-ebc0-4e9d-ae0d-809ab9096549\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.instructions','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.label','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.required','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.tip','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.uid','\"1c3a2257-08cb-494e-be3b-4f09dc319265\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.warning','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.3.width','50'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.fieldUid','\"77d3c1fa-0a42-43f7-92e9-e91a592be391\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.instructions','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.label','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.required','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.tip','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.uid','\"67e69cee-3bae-4b37-8944-f0995d8feede\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.warning','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.4.width','100'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.instructions','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.label','\"Conteúdo\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.required','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.tip','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.uid','\"6e366c02-e2f1-4dc4-a4eb-b318e1bb3320\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.warning','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.elements.5.width','100'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.name','\"Conteúdo\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.uid','\"3db40fb8-d734-4d0e-80c2-4c4dc204e20e\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.0.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.elementCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.instructions','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.label','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.required','false'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.tip','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.uid','\"61e61cc7-2c9a-4401-9b5f-484fd9e806ef\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.warning','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.elements.0.width','100'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.name','\"SEO\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.uid','\"b94aae6f-e170-4313-a784-900c42ffd776\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.fieldLayouts.b96b9d72-9d99-41b1-9ccc-2a5459ba1080.tabs.1.userCondition','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.handle','\"newsDetail\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.hasTitleField','true'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.name','\"Padrão\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.section','\"0f0cfbd0-14aa-46c8-bf31-44b2dc8107f5\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.showStatusField','true'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.slugTranslationKeyFormat','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.slugTranslationMethod','\"site\"'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.sortOrder','1'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.titleFormat','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.titleTranslationKeyFormat','null'),('entryTypes.d2081389-230a-469c-a831-c3c21e62c4c5.titleTranslationMethod','\"site\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.autocapitalize','true'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.autocomplete','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.autocorrect','true'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.class','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.disabled','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.id','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.inputType','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.instructions','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.label','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.max','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.min','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.name','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.orientation','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.placeholder','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.readonly','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.requirable','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.size','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.step','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.tip','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.title','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.uid','\"479f8f2d-58d6-462a-975d-04da3294d7bf\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.warning','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.0.width','100'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.fieldUid','\"c84d03fe-f80d-4194-ba99-08b7fbfba0ed\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.instructions','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.label','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.required','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.tip','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.uid','\"3ce0b255-de6f-490e-8ac6-7296be24d251\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.warning','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.elements.1.width','100'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.name','\"Conteúdo\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.uid','\"e4457700-916e-4fef-8cd6-f6ebcf297bd0\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.0.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.instructions','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.label','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.required','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.tip','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.uid','\"8af13862-a51c-4564-bf3b-b0624a63ec8f\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.warning','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.0.width','100'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.instructions','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.label','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.required','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.tip','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.uid','\"255992f3-2752-4ccc-9a82-62a0b3f5646b\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.warning','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.elements.1.width','100'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.uid','\"c0545140-81ef-4bb4-9704-df723545ec9c\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.1.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.elementCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.instructions','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.label','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.required','false'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.tip','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.uid','\"787c75d5-a9b8-46ae-a704-e854264814d7\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.warning','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.elements.0.width','100'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.name','\"SEO\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.uid','\"3fa02657-b338-45bd-85e0-ec1e2bf68f1b\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.fieldLayouts.5d6d3035-222e-48b1-abcf-881a69622643.tabs.2.userCondition','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.handle','\"citizen\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.hasTitleField','true'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.name','\"Cidadão\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.section','\"9c375d27-8e6e-46d1-9e61-1895273e029a\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.showStatusField','true'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.slugTranslationKeyFormat','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.slugTranslationMethod','\"site\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.sortOrder','1'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.titleFormat','\"{section.name|raw}\"'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.titleTranslationKeyFormat','null'),('entryTypes.e3fd92a7-91c9-445b-b530-1d14a834c397.titleTranslationMethod','\"site\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.autocapitalize','true'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.autocomplete','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.autocorrect','true'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.class','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.disabled','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.id','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.inputType','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.instructions','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.label','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.max','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.min','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.name','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.orientation','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.placeholder','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.readonly','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.requirable','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.size','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.step','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.tip','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.title','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.uid','\"486f24c7-29ac-499f-942e-fccf3e3c05ea\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.warning','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.0.width','100'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.fieldUid','\"c84d03fe-f80d-4194-ba99-08b7fbfba0ed\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.instructions','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.label','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.required','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.tip','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.uid','\"cc07b316-8954-43f9-b881-8f3296ea6d51\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.warning','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.elements.1.width','100'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.name','\"Conteúdo\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.uid','\"8b127c9b-2c8b-4486-a692-e83eaf2d7460\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.0.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.instructions','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.label','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.required','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.tip','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.uid','\"bd6df0e8-5174-48ce-af34-bfc8f5919ffa\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.warning','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.0.width','100'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.instructions','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.label','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.required','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.tip','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.uid','\"806bea8d-054a-4be7-856b-54fd0176f714\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.warning','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.elements.1.width','100'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.uid','\"c0155f5a-a616-4799-ba0c-2a845aa029e6\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.1.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.elementCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.instructions','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.label','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.required','false'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.tip','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.uid','\"ae3519ad-f581-4c79-b560-aab028a8b4ff\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.warning','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.elements.0.width','100'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.name','\"SEO\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.uid','\"8fa8f12b-59c9-428f-a9d9-fd34776780b8\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.fieldLayouts.133f7622-a058-4cd8-8855-fd62d6318c9a.tabs.2.userCondition','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.handle','\"documents\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.hasTitleField','true'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.name','\"Padrão\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.section','\"c413356a-36d3-4c82-8c21-7f200af48eb6\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.showStatusField','true'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.slugTranslationKeyFormat','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.slugTranslationMethod','\"site\"'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.sortOrder','1'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.titleFormat','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.titleTranslationKeyFormat','null'),('entryTypes.f3fb3a62-e5c1-4f56-bee9-c63b75432096.titleTranslationMethod','\"site\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.autocapitalize','true'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.autocomplete','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.autocorrect','true'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.class','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.disabled','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.id','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.inputType','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.label','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.max','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.min','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.name','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.orientation','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.placeholder','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.readonly','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.requirable','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.size','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.step','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.title','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.uid','\"a744c5da-a770-48b9-bda9-31597fc6835a\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.0.width','100'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.fieldUid','\"88242a46-c02d-4ea3-b580-d1f5f470c70b\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.label','\"Thumbnail\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.required','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.uid','\"477415a9-f67d-4f41-8592-6e0c1a810888\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.1.width','25'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.fieldUid','\"3f7c029c-b6a9-491a-bf4b-7ccdceac3649\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.label','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.required','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.uid','\"0704c552-8b84-4b68-9922-5fb34d6c0dc0\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.2.width','25'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.fieldUid','\"2c508b12-7986-41f3-835a-3dada05e9433\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.label','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.required','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.uid','\"61a0af89-30c4-4a47-9ddb-e1be34c98edd\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.3.width','25'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.label','\"Conteúdo\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.required','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.uid','\"77394c2b-51be-4042-b29e-cfeaa88e9f2e\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.4.width','100'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.5.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.5.heading','\"Coordenadas do mapa\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.5.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.5.uid','\"ca331959-7a71-4511-8d64-53f2ce9dbd57\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.5.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.fieldUid','\"d8cd947c-079b-440d-9b65-4589c16d23eb\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.label','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.required','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.uid','\"25f44224-88f3-4745-97c0-6ee408c9d0ff\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.6.width','50'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.fieldUid','\"6e042994-c894-40f0-8b7a-b1ba8bcc666e\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.label','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.required','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.uid','\"58d40bad-033a-4c08-9811-8b2c7ee312d6\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.elements.7.width','50'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.name','\"Conteúdo\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.uid','\"ac753b27-95c7-4a07-9e6a-41c19253e677\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.0.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.elementCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.instructions','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.label','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.required','false'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.tip','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.uid','\"fb5ad3b4-ea0c-4bf2-be8a-12ef8c5cbda4\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.warning','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.elements.0.width','100'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.name','\"SEO\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.uid','\"ef43cdab-5d18-4865-bcc8-a98a4d7584bd\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.fieldLayouts.21405bfc-365b-492c-9199-94cd67d414c1.tabs.1.userCondition','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.handle','\"events\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.hasTitleField','true'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.name','\"Padrão\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.section','\"45e38bd6-10af-4474-9080-52cc148dbe68\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.showStatusField','true'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.slugTranslationKeyFormat','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.slugTranslationMethod','\"site\"'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.sortOrder','1'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.titleFormat','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.titleTranslationKeyFormat','null'),('entryTypes.f684f595-f3e4-4549-b85e-10ac02db1e84.titleTranslationMethod','\"site\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.autocapitalize','true'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.autocomplete','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.autocorrect','true'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.class','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.disabled','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.id','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.inputType','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.instructions','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.label','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.max','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.min','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.name','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.orientation','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.placeholder','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.readonly','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.requirable','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.size','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.step','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.tip','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.title','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.uid','\"fac77929-ef58-4c3a-b8cf-dcd5fefe72d0\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.warning','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.0.width','100'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.fieldUid','\"795538db-d8cd-4fb9-922b-e9398f128280\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.instructions','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.label','\"Conteúdo\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.required','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.tip','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.uid','\"bffe7f68-886f-41c0-93db-36a84f13da2e\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.warning','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.elements.1.width','100'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.name','\"Conteúdo\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.uid','\"10685269-05da-40dd-99c5-cb6fb537c058\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.0.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.fieldUid','\"2423118a-7834-476b-9b22-c9efde226343\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.instructions','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.label','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.required','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.tip','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.uid','\"95c3b044-91eb-414e-81f5-6bd920512b1f\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.warning','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.0.width','100'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.fieldUid','\"098aaa78-a149-4d5e-8832-557a5f2cb95e\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.instructions','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.label','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.required','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.tip','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.uid','\"eca77e23-5cc3-4e59-b107-0a7cbd0e71ae\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.warning','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.elements.1.width','100'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.name','\"Coluna da Direita\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.uid','\"cd50a4de-b9a2-4374-9375-e47aeb6e3cce\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.1.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.elementCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.fieldUid','\"722f4bfc-5260-46a5-821c-beebb86e123d\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.instructions','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.label','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.required','false'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.tip','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.uid','\"68b16ce1-cc44-41e7-9767-feda333b6151\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.warning','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.elements.0.width','100'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.name','\"SEO\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.uid','\"eacb2b7a-cd50-487c-b07b-3ef773092707\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.fieldLayouts.c3c5d477-2ade-40fd-b0bf-65d6f43025c3.tabs.2.userCondition','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.handle','\"cms\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.hasTitleField','true'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.name','\"Padrão\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.section','\"f03e7b29-df4a-41cb-a854-a178dd91f0f2\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.showStatusField','true'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.slugTranslationKeyFormat','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.slugTranslationMethod','\"site\"'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.sortOrder','1'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.titleFormat','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.titleTranslationKeyFormat','null'),('entryTypes.fd7ce2aa-135d-41ae-acc0-904577c28a4b.titleTranslationMethod','\"site\"'),('fieldGroups.0473bf53-6e6d-40d6-ae4e-0dd5aa96b946.name','\"Footer\"'),('fieldGroups.2c01c9e9-499b-49d6-b238-72387ed5cf8a.name','\"Noticias\"'),('fieldGroups.415b16ce-c08e-43e1-9fe7-17e425d8017e.name','\"Junta\"'),('fieldGroups.4e478309-6e01-4647-bea3-aac12ead8ed8.name','\"Coluna da Direita\"'),('fieldGroups.511058c6-db65-4bb6-8c7f-a422f0f4e799.name','\"Organização\"'),('fieldGroups.52344ede-a26d-4fbf-a81c-5ddb1d312483.name','\"Common\"'),('fieldGroups.81696338-303f-42d6-b600-1ec70299f494.name','\"Header\"'),('fieldGroups.89b46165-3f9e-42c0-87e6-9d5d9a7a3d03.name','\"Socials\"'),('fieldGroups.8aae1370-a834-4c6a-b3ba-eaef8066888c.name','\"Coluna da Esquerda\"'),('fieldGroups.b97ab278-fecb-4566-b48b-b5d24c5ca93f.name','\"Eventos\"'),('fieldGroups.de4c86cf-d413-4cfc-859c-cdce25dfdaf8.name','\"head\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.columnSuffix','null'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.contentColumnType','\"string\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.fieldGroup','\"4e478309-6e01-4647-bea3-aac12ead8ed8\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.handle','\"linkImages\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.instructions','null'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.name','\"Imagens com Link\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.searchable','false'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.settings.contentTable','\"{{%matrixcontent_linkimages}}\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.settings.maxBlocks','null'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.settings.minBlocks','null'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.settings.propagationKeyFormat','null'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.settings.propagationMethod','\"all\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.translationKeyFormat','null'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.translationMethod','\"site\"'),('fields.09728bc0-0ebd-4cf5-ae04-4416b4e9103c.type','\"craft\\\\fields\\\\Matrix\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.columnSuffix','\"alfqkvgz\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.contentColumnType','\"boolean\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.fieldGroup','\"4e478309-6e01-4647-bea3-aac12ead8ed8\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.handle','\"showNews\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.instructions','null'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.name','\"Mostrar Notícias Recentes\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.searchable','false'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.settings.default','false'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.settings.offLabel','\"Não mostrar\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.settings.onLabel','\"Mostrar\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.translationKeyFormat','null'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.translationMethod','\"none\"'),('fields.098aaa78-a149-4d5e-8832-557a5f2cb95e.type','\"craft\\\\fields\\\\Lightswitch\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.columnSuffix','\"gtuinydl\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.contentColumnType','\"string\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.fieldGroup','\"2c01c9e9-499b-49d6-b238-72387ed5cf8a\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.handle','\"newsTags\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.instructions','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.name','\"Tags de Noticias\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.searchable','false'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.allowSelfRelations','false'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.branchLimit','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.localizeRelations','false'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.maintainHierarchy','false'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.maxRelations','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.minRelations','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.selectionLabel','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.showSiteMenu','true'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.source','\"taggroup:c1fb845e-e7eb-4cd3-b08e-05465d4cffba\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.targetSiteId','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.validateRelatedElements','false'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.settings.viewMode','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.translationKeyFormat','null'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.translationMethod','\"site\"'),('fields.175b9d48-8313-4b08-b6e5-45633a5ab848.type','\"craft\\\\fields\\\\Tags\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.columnSuffix','\"ssublcje\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.contentColumnType','\"boolean\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.fieldGroup','\"4e478309-6e01-4647-bea3-aac12ead8ed8\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.handle','\"showGallery\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.instructions','null'),('fields.2423118a-7834-476b-9b22-c9efde226343.name','\"Mostrar Galeria\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.searchable','false'),('fields.2423118a-7834-476b-9b22-c9efde226343.settings.default','true'),('fields.2423118a-7834-476b-9b22-c9efde226343.settings.offLabel','\"Não Mostrar\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.settings.onLabel','\"Mostrar\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.translationKeyFormat','null'),('fields.2423118a-7834-476b-9b22-c9efde226343.translationMethod','\"none\"'),('fields.2423118a-7834-476b-9b22-c9efde226343.type','\"craft\\\\fields\\\\Lightswitch\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.columnSuffix','\"kwodfxjt\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.contentColumnType','\"string\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.handle','\"email\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.instructions','null'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.name','\"Email\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.searchable','false'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.settings.placeholder','\"placeholder@juntamesaofrio.com\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.translationKeyFormat','null'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.translationMethod','\"none\"'),('fields.2b60f963-b36d-4f30-8a79-bc98eb9f0705.type','\"craft\\\\fields\\\\Email\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.columnSuffix','\"jjszxiab\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.contentColumnType','\"text\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.fieldGroup','\"b97ab278-fecb-4566-b48b-b5d24c5ca93f\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.handle','\"location\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.instructions','null'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.name','\"Localização\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.searchable','false'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.byteLimit','null'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.charLimit','null'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.code','false'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.columnType','null'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.initialRows','4'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.multiline','false'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.placeholder','null'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.settings.uiMode','\"normal\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.translationKeyFormat','null'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.translationMethod','\"none\"'),('fields.2c508b12-7986-41f3-835a-3dada05e9433.type','\"craft\\\\fields\\\\PlainText\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.columnSuffix','null'),('fields.3522d11c-1676-489e-b336-4647089388d4.contentColumnType','\"string\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.handle','\"contacts\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.instructions','null'),('fields.3522d11c-1676-489e-b336-4647089388d4.name','\"Contactos\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.searchable','false'),('fields.3522d11c-1676-489e-b336-4647089388d4.settings.contentTable','\"{{%matrixcontent_contacts}}\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.settings.maxBlocks','null'),('fields.3522d11c-1676-489e-b336-4647089388d4.settings.minBlocks','null'),('fields.3522d11c-1676-489e-b336-4647089388d4.settings.propagationKeyFormat','null'),('fields.3522d11c-1676-489e-b336-4647089388d4.settings.propagationMethod','\"all\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.translationKeyFormat','null'),('fields.3522d11c-1676-489e-b336-4647089388d4.translationMethod','\"site\"'),('fields.3522d11c-1676-489e-b336-4647089388d4.type','\"craft\\\\fields\\\\Matrix\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.columnSuffix','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.contentColumnType','\"string\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.fieldGroup','\"81696338-303f-42d6-b600-1ec70299f494\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.handle','\"backgroundImage\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.instructions','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.name','\"Background Image\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.searchable','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.allowedKinds.0','\"image\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.allowSelfRelations','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.allowSubfolders','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.allowUploads','true'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.branchLimit','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.defaultUploadLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.defaultUploadLocationSubpath','\"header\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.localizeRelations','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.maintainHierarchy','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.maxRelations','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.minRelations','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.previewMode','\"thumbs\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.restrictedDefaultUploadSubpath','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.restrictedLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.restrictedLocationSubpath','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.restrictFiles','true'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.restrictLocation','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.selectionLabel','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.showSiteMenu','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.showUnpermittedFiles','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.showUnpermittedVolumes','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.sources','\"*\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.targetSiteId','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.validateRelatedElements','false'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.settings.viewMode','\"large\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.translationKeyFormat','null'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.translationMethod','\"site\"'),('fields.397182b0-88e7-4f15-a81a-ef29b5e79085.type','\"craft\\\\fields\\\\Assets\"'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.columnSuffix','\"pylrxcat\"'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.contentColumnType','\"datetime\"'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.fieldGroup','\"b97ab278-fecb-4566-b48b-b5d24c5ca93f\"'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.handle','\"date\"'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.instructions','null'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.name','\"Data\"'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.searchable','false'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.settings.max','null'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.settings.min','null'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.settings.minuteIncrement','5'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.settings.showDate','true'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.settings.showTime','true'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.settings.showTimeZone','false'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.translationKeyFormat','null'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.translationMethod','\"none\"'),('fields.3f7c029c-b6a9-491a-bf4b-7ccdceac3649.type','\"craft\\\\fields\\\\Date\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.columnSuffix','\"lybdltli\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.contentColumnType','\"text\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.fieldGroup','\"52344ede-a26d-4fbf-a81c-5ddb1d312483\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.handle','\"html\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.instructions','null'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.name','\"html\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.searchable','false'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.availableLanguages.0','\"css\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.availableLanguages.1','\"html\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.availableLanguages.2','\"javascript\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.availableLanguages.3','\"json\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.availableLanguages.4','\"twig\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.codeFolding','false'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.columnType','\"text\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.defaultValue','\"\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.fontSize','14'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.language','\"html\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.lineNumbers','false'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.monacoEditorOptions','\"\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.placeholder','\"\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.showLanguageDropdown','true'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.singleLineEditor','false'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.settings.theme','\"vs\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.translationKeyFormat','null'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.translationMethod','\"none\"'),('fields.4132f438-075d-4ca1-b68d-2a215d1dd2ea.type','\"nystudio107\\\\codefield\\\\fields\\\\Code\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.columnSuffix','\"ajhdgooe\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.contentColumnType','\"text\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.fieldGroup','\"de4c86cf-d413-4cfc-859c-cdce25dfdaf8\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.handle','\"metaDescription\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.instructions','null'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.name','\"Meta Description\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.searchable','false'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.byteLimit','null'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.charLimit','null'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.code','false'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.columnType','null'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.initialRows','4'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.multiline','true'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.placeholder','null'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.settings.uiMode','\"normal\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.translationKeyFormat','null'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.translationMethod','\"none\"'),('fields.4816bfcc-ee2e-4052-b872-2260bfe93d34.type','\"craft\\\\fields\\\\PlainText\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.columnSuffix','\"ukbnjvma\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.contentColumnType','\"text\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.handle','\"organizationName\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.instructions','null'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.name','\"Nome da Organização\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.searchable','false'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.byteLimit','null'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.charLimit','null'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.code','false'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.columnType','null'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.initialRows','4'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.multiline','false'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.placeholder','null'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.settings.uiMode','\"normal\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.translationKeyFormat','null'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.translationMethod','\"none\"'),('fields.6142f9f7-b123-457c-bc86-ae919de1bcfe.type','\"craft\\\\fields\\\\PlainText\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.columnSuffix','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.contentColumnType','\"string\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.fieldGroup','\"de4c86cf-d413-4cfc-859c-cdce25dfdaf8\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.handle','\"favicon\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.instructions','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.name','\"favicon\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.searchable','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.allowedKinds.0','\"image\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.allowSelfRelations','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.allowSubfolders','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.allowUploads','true'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.branchLimit','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.defaultUploadLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.defaultUploadLocationSubpath','\"favicon\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.localizeRelations','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.maintainHierarchy','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.maxRelations','1'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.minRelations','1'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.previewMode','\"thumbs\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.restrictedDefaultUploadSubpath','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.restrictedLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.restrictedLocationSubpath','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.restrictFiles','true'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.restrictLocation','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.selectionLabel','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.showSiteMenu','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.showUnpermittedFiles','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.showUnpermittedVolumes','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.sources','\"*\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.targetSiteId','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.validateRelatedElements','false'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.settings.viewMode','\"large\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.translationKeyFormat','null'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.translationMethod','\"site\"'),('fields.625190d1-527c-4ea1-84dd-c752c55aff02.type','\"craft\\\\fields\\\\Assets\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.columnSuffix','\"zgcmmyvo\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.contentColumnType','\"text\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.handle','\"phone\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.instructions','null'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.name','\"Telefone\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.searchable','false'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.byteLimit','null'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.charLimit','null'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.code','false'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.columnType','null'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.initialRows','4'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.multiline','false'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.placeholder','null'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.settings.uiMode','\"normal\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.translationKeyFormat','null'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.translationMethod','\"none\"'),('fields.661451bc-35bc-4d1c-b544-24a4294d9560.type','\"craft\\\\fields\\\\PlainText\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.columnSuffix','\"ytsfqomq\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.contentColumnType','\"text\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.handle','\"city\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.instructions','null'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.name','\"Cidade\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.searchable','false'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.byteLimit','null'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.charLimit','null'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.code','false'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.columnType','null'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.initialRows','4'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.multiline','false'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.placeholder','null'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.settings.uiMode','\"normal\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.translationKeyFormat','null'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.translationMethod','\"none\"'),('fields.6963b7c0-3841-4923-b316-75ce66aefdff.type','\"craft\\\\fields\\\\PlainText\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.columnSuffix','\"bzgtlbjm\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.contentColumnType','\"text\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.fieldGroup','\"b97ab278-fecb-4566-b48b-b5d24c5ca93f\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.handle','\"longitude\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.instructions','null'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.name','\"Longitude\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.searchable','false'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.byteLimit','null'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.charLimit','null'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.code','false'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.columnType','null'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.initialRows','4'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.multiline','false'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.placeholder','null'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.settings.uiMode','\"normal\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.translationKeyFormat','null'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.translationMethod','\"none\"'),('fields.6e042994-c894-40f0-8b7a-b1ba8bcc666e.type','\"craft\\\\fields\\\\PlainText\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.columnSuffix','\"cwroofon\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.contentColumnType','\"text\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.fieldGroup','\"de4c86cf-d413-4cfc-859c-cdce25dfdaf8\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.handle','\"seo\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.instructions','null'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.name','\"SEO\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.searchable','false'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.description','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.hideSocial','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.robots.0','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.robots.1','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.robots.2','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.robots.3','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.robots.4','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.robots.5','\"\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.socialImage.0','\"11\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.suffixAsPrefix','null'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.0.__assoc__.0.0','\"key\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.0.__assoc__.0.1','\"1\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.0.__assoc__.1.0','\"locked\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.0.__assoc__.1.1','\"0\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.0.__assoc__.2.0','\"template\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.0.__assoc__.2.1','\"{title}\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.1.__assoc__.0.0','\"key\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.1.__assoc__.0.1','\"2\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.1.__assoc__.1.0','\"locked\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.1.__assoc__.1.1','\"0\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.1.__assoc__.2.0','\"template\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.title.1.__assoc__.2.1','\" - {{ siteName }}\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.settings.titleSuffix','null'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.translationKeyFormat','null'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.translationMethod','\"none\"'),('fields.722f4bfc-5260-46a5-821c-beebb86e123d.type','\"ether\\\\seo\\\\fields\\\\SeoField\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.columnSuffix','\"tyatblvb\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.contentColumnType','\"text\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.fieldGroup','\"2c01c9e9-499b-49d6-b238-72387ed5cf8a\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.handle','\"shortDescription\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.instructions','null'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.name','\"Pequena Descrição\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.searchable','false'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.byteLimit','null'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.charLimit','null'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.code','false'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.columnType','null'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.initialRows','4'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.multiline','true'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.placeholder','null'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.settings.uiMode','\"normal\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.translationKeyFormat','null'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.translationMethod','\"none\"'),('fields.77d3c1fa-0a42-43f7-92e9-e91a592be391.type','\"craft\\\\fields\\\\PlainText\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.columnSuffix','\"bvqpiscs\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.contentColumnType','\"text\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.fieldGroup','\"52344ede-a26d-4fbf-a81c-5ddb1d312483\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.handle','\"richText\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.instructions','null'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.name','\"Rich Text\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.searchable','false'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.availableTransforms','\"\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.availableVolumes','\"*\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.columnType','\"text\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.configSelectionMode','\"choose\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.defaultTransform','\"\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.manualConfig','\"\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.purifierConfig','null'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.purifyHtml','true'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.redactorConfig','null'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.removeEmptyTags','false'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.removeInlineStyles','false'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.removeNbsp','false'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.showHtmlButtonForNonAdmins','false'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.showUnpermittedFiles','false'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.showUnpermittedVolumes','false'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.settings.uiMode','\"enlarged\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.translationKeyFormat','null'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.translationMethod','\"none\"'),('fields.795538db-d8cd-4fb9-922b-e9398f128280.type','\"craft\\\\redactor\\\\Field\"'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.columnSuffix','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.contentColumnType','\"string\"'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.fieldGroup','\"2c01c9e9-499b-49d6-b238-72387ed5cf8a\"'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.handle','\"newsCategories\"'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.instructions','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.name','\"Categorias\"'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.searchable','false'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.allowSelfRelations','false'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.branchLimit','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.localizeRelations','false'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.maintainHierarchy','false'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.maxRelations','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.minRelations','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.selectionLabel','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.showSiteMenu','true'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.source','\"group:8ba433f7-e0da-4428-adb3-a8b33ceef2b9\"'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.targetSiteId','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.validateRelatedElements','false'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.settings.viewMode','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.translationKeyFormat','null'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.translationMethod','\"site\"'),('fields.7c3d6d08-ebc0-4e9d-ae0d-809ab9096549.type','\"craft\\\\fields\\\\Categories\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.columnSuffix','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.contentColumnType','\"string\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.fieldGroup','\"52344ede-a26d-4fbf-a81c-5ddb1d312483\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.handle','\"image\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.instructions','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.name','\"Image\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.searchable','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.allowedKinds','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.allowSelfRelations','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.allowSubfolders','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.allowUploads','true'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.branchLimit','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.defaultUploadLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.defaultUploadLocationSubpath','\"{slug}\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.localizeRelations','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.maintainHierarchy','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.maxRelations','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.minRelations','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.previewMode','\"thumbs\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.restrictedDefaultUploadSubpath','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.restrictedLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.restrictedLocationSubpath','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.restrictFiles','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.restrictLocation','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.selectionLabel','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.showSiteMenu','true'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.showUnpermittedFiles','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.showUnpermittedVolumes','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.sources','\"*\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.targetSiteId','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.validateRelatedElements','false'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.settings.viewMode','\"large\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.translationKeyFormat','null'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.translationMethod','\"site\"'),('fields.88242a46-c02d-4ea3-b580-d1f5f470c70b.type','\"craft\\\\fields\\\\Assets\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.columnSuffix','null'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.contentColumnType','\"string\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.fieldGroup','\"89b46165-3f9e-42c0-87e6-9d5d9a7a3d03\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.handle','\"socials\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.instructions','null'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.name','\"Redes Sociais\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.searchable','false'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.settings.contentTable','\"{{%matrixcontent_socials}}\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.settings.maxBlocks','null'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.settings.minBlocks','null'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.settings.propagationKeyFormat','null'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.settings.propagationMethod','\"all\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.translationKeyFormat','null'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.translationMethod','\"site\"'),('fields.9ba971ee-6616-4e6e-b216-29c1e91a1d2f.type','\"craft\\\\fields\\\\Matrix\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.columnSuffix','\"gklqovpy\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.contentColumnType','\"text\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.handle','\"address\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.instructions','null'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.name','\"Morada\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.searchable','false'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.byteLimit','null'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.charLimit','null'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.code','false'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.columnType','null'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.initialRows','4'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.multiline','false'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.placeholder','null'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.settings.uiMode','\"normal\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.translationKeyFormat','null'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.translationMethod','\"none\"'),('fields.9bf75c64-3353-4e86-b013-34e66a227011.type','\"craft\\\\fields\\\\PlainText\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.columnSuffix','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.contentColumnType','\"string\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.fieldGroup','\"de4c86cf-d413-4cfc-859c-cdce25dfdaf8\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.handle','\"metaImage\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.instructions','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.name','\"Meta Image\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.searchable','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.allowedKinds.0','\"image\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.allowSelfRelations','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.allowSubfolders','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.allowUploads','true'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.branchLimit','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.defaultUploadLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.defaultUploadLocationSubpath','\"meta-images\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.localizeRelations','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.maintainHierarchy','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.maxRelations','1'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.minRelations','0'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.previewMode','\"thumbs\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.restrictedDefaultUploadSubpath','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.restrictedLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.restrictedLocationSubpath','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.restrictFiles','true'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.restrictLocation','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.selectionLabel','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.showSiteMenu','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.showUnpermittedFiles','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.showUnpermittedVolumes','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.sources','\"*\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.targetSiteId','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.validateRelatedElements','false'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.settings.viewMode','\"large\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.translationKeyFormat','null'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.translationMethod','\"site\"'),('fields.9ca854f1-d394-437d-8fd2-04088aceac86.type','\"craft\\\\fields\\\\Assets\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.columnSuffix','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.contentColumnType','\"string\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.fieldGroup','\"81696338-303f-42d6-b600-1ec70299f494\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.handle','\"logo\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.instructions','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.name','\"logo\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.searchable','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.allowedKinds.0','\"image\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.allowSelfRelations','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.allowSubfolders','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.allowUploads','true'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.branchLimit','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.defaultUploadLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.defaultUploadLocationSubpath','\"logo\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.localizeRelations','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.maintainHierarchy','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.maxRelations','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.minRelations','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.previewMode','\"thumbs\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.restrictedDefaultUploadSubpath','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.restrictedLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.restrictedLocationSubpath','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.restrictFiles','true'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.restrictLocation','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.selectionLabel','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.showSiteMenu','true'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.showUnpermittedFiles','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.showUnpermittedVolumes','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.sources','\"*\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.targetSiteId','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.validateRelatedElements','false'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.settings.viewMode','\"large\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.translationKeyFormat','null'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.translationMethod','\"site\"'),('fields.c7af5a64-9068-4c13-959a-e1d5fda71ec9.type','\"craft\\\\fields\\\\Assets\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.columnSuffix','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.contentColumnType','\"string\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.fieldGroup','\"4e478309-6e01-4647-bea3-aac12ead8ed8\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.handle','\"documents\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.instructions','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.name','\"Documentos\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.searchable','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowedKinds.0','\"excel\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowedKinds.1','\"pdf\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowedKinds.2','\"powerpoint\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowedKinds.3','\"text\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowedKinds.4','\"word\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowSelfRelations','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowSubfolders','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.allowUploads','true'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.branchLimit','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.defaultUploadLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.defaultUploadLocationSubpath','\"documents\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.localizeRelations','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.maintainHierarchy','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.maxRelations','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.minRelations','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.previewMode','\"full\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.restrictedDefaultUploadSubpath','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.restrictedLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.restrictedLocationSubpath','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.restrictFiles','true'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.restrictLocation','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.selectionLabel','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.showSiteMenu','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.showUnpermittedFiles','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.showUnpermittedVolumes','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.sources','\"*\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.targetSiteId','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.validateRelatedElements','false'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.settings.viewMode','\"large\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.translationKeyFormat','null'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.translationMethod','\"site\"'),('fields.c84d03fe-f80d-4194-ba99-08b7fbfba0ed.type','\"craft\\\\fields\\\\Assets\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.columnSuffix','\"myhuqhkt\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.contentColumnType','\"text\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.fieldGroup','\"b97ab278-fecb-4566-b48b-b5d24c5ca93f\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.handle','\"latitude\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.instructions','null'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.name','\"Latitude\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.searchable','false'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.byteLimit','null'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.charLimit','null'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.code','false'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.columnType','null'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.initialRows','4'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.multiline','false'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.placeholder','null'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.settings.uiMode','\"normal\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.translationKeyFormat','null'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.translationMethod','\"none\"'),('fields.d8cd947c-079b-440d-9b65-4589c16d23eb.type','\"craft\\\\fields\\\\PlainText\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.columnSuffix','\"wazzxglf\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.contentColumnType','\"text\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.fieldGroup','\"de4c86cf-d413-4cfc-859c-cdce25dfdaf8\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.handle','\"metaTitle\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.instructions','null'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.name','\"Meta Title\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.searchable','false'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.byteLimit','null'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.charLimit','null'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.code','false'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.columnType','null'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.initialRows','4'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.multiline','false'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.placeholder','null'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.settings.uiMode','\"normal\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.translationKeyFormat','null'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.translationMethod','\"none\"'),('fields.dc6b7b41-06cf-48a2-bc1c-2584a63ae3d5.type','\"craft\\\\fields\\\\PlainText\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.columnSuffix','\"zjtrjjfm\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.contentColumnType','\"text\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.handle','\"postalCode\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.instructions','null'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.name','\"Código Postal\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.searchable','false'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.byteLimit','null'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.charLimit','null'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.code','false'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.columnType','null'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.initialRows','4'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.multiline','false'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.placeholder','null'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.settings.uiMode','\"normal\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.translationKeyFormat','null'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.translationMethod','\"none\"'),('fields.e7257f8f-1d2b-463c-96d5-ca9fb4e0814f.type','\"craft\\\\fields\\\\PlainText\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.columnSuffix','null'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.contentColumnType','\"string\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.fieldGroup','\"8aae1370-a834-4c6a-b3ba-eaef8066888c\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.handle','\"linksPdf\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.instructions','null'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.name','\"Ligações Úteis\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.searchable','false'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.settings.contentTable','\"{{%matrixcontent_linkspdf}}\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.settings.maxBlocks','null'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.settings.minBlocks','null'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.settings.propagationKeyFormat','null'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.settings.propagationMethod','\"all\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.translationKeyFormat','null'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.translationMethod','\"site\"'),('fields.ea3b61d5-7e5b-4b00-ac14-8498e58e5592.type','\"craft\\\\fields\\\\Matrix\"'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.columnSuffix','\"xfwzdulc\"'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.contentColumnType','\"string\"'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.fieldGroup','\"511058c6-db65-4bb6-8c7f-a422f0f4e799\"'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.handle','\"country\"'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.instructions','null'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.name','\"País\"'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.searchable','false'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.translationKeyFormat','null'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.translationMethod','\"none\"'),('fields.ec4f2482-6a6a-4129-a8f1-70835234cf27.type','\"craft\\\\fields\\\\Country\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.columnSuffix','\"gzwezmwi\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.contentColumnType','\"text\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.fieldGroup','\"0473bf53-6e6d-40d6-ae4e-0dd5aa96b946\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.handle','\"copyright\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.instructions','null'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.name','\"Copyright\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.searchable','false'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.availableTransforms','\"\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.availableVolumes','\"*\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.columnType','\"text\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.configSelectionMode','\"choose\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.defaultTransform','\"\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.manualConfig','\"\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.purifierConfig','null'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.purifyHtml','true'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.redactorConfig','null'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.removeEmptyTags','false'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.removeInlineStyles','false'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.removeNbsp','false'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.showHtmlButtonForNonAdmins','false'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.showUnpermittedFiles','false'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.showUnpermittedVolumes','false'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.settings.uiMode','\"enlarged\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.translationKeyFormat','null'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.translationMethod','\"none\"'),('fields.edb2e939-cc66-40b0-83a9-3755fa783f5e.type','\"craft\\\\redactor\\\\Field\"'),('fs.images.hasUrls','true'),('fs.images.name','\"Imagens\"'),('fs.images.settings.path','\"@webroot/assets/images\"'),('fs.images.type','\"craft\\\\fs\\\\Local\"'),('fs.images.url','\"@web/assets/images\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elementCondition','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.elementCondition','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.fieldUid','\"09728bc0-0ebd-4cf5-ae04-4416b4e9103c\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.instructions','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.label','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.required','false'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.tip','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.uid','\"9b202a9a-5439-4e65-830a-5c371aabe126\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.userCondition','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.warning','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.elements.0.width','100'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.name','\"Conteudo\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.uid','\"a0b546e1-c4d1-4e1e-b54b-3f51f28a14b9\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.fieldLayouts.21dee9e9-99c4-4577-8a1c-faa06bda19ae.tabs.0.userCondition','null'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.handle','\"rightColumn\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.name','\"Coluna da Direita\"'),('globalSets.1f1e8428-3ee2-4875-a0e1-4867fbe7dfee.sortOrder','7'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elementCondition','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.elementCondition','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.fieldUid','\"ea3b61d5-7e5b-4b00-ac14-8498e58e5592\"'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.instructions','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.label','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.required','false'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.tip','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.uid','\"d9c73150-47b1-4b13-af62-db85acb12e9e\"'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.userCondition','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.warning','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.elements.0.width','100'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.name','\"Conteudo\"'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.uid','\"27a1ab95-17de-470f-b502-393c61bae18b\"'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.fieldLayouts.b98bbf98-6f28-46da-b7a6-443fe0ac515d.tabs.0.userCondition','null'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.handle','\"leftColumn\"'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.name','\"Coluna da Esquerda\"'),('globalSets.2d9d15b2-9a79-4bdc-aa4f-4d2d19964b5c.sortOrder','3'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elementCondition','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.elementCondition','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.fieldUid','\"c7af5a64-9068-4c13-959a-e1d5fda71ec9\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.instructions','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.label','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.required','false'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.tip','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.uid','\"4d341794-fd42-4bc8-8495-31f78fa7c899\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.userCondition','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.warning','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.0.width','50'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.elementCondition','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.fieldUid','\"397182b0-88e7-4f15-a81a-ef29b5e79085\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.instructions','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.label','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.required','false'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.tip','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.uid','\"aa3b0b46-d5ce-4c3d-bb37-08fbf9881b5a\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.userCondition','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.warning','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.elements.1.width','50'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.name','\"Conteudo\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.uid','\"687613b9-dbf5-46e4-91fb-f162f0dc108d\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.fieldLayouts.19314b8b-ef73-42a6-b849-176472ab8d87.tabs.0.userCondition','null'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.handle','\"header\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.name','\"Header\"'),('globalSets.3e1119c5-f94f-4154-a4fb-afb43b303105.sortOrder','2'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elementCondition','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.elementCondition','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.fieldUid','\"edb2e939-cc66-40b0-83a9-3755fa783f5e\"'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.instructions','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.label','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.required','false'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.tip','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.uid','\"a75154e3-00c9-4c84-899a-e34936ef8c80\"'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.userCondition','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.warning','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.elements.0.width','100'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.name','\"Conteudo\"'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.uid','\"483ec640-459e-4116-9303-0389951026db\"'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.fieldLayouts.1f615b22-b226-4348-b9a8-6580566c0606.tabs.0.userCondition','null'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.handle','\"footer\"'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.name','\"Footer\"'),('globalSets.aa58149c-af35-410e-b08d-bfc93a6e8d9f.sortOrder','4'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.fieldUid','\"6142f9f7-b123-457c-bc86-ae919de1bcfe\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.uid','\"0891f8f5-deed-4d6d-854a-1d68efb50095\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.0.width','50'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.fieldUid','\"2b60f963-b36d-4f30-8a79-bc98eb9f0705\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.uid','\"072f053d-14c1-478d-91f8-5354168071ae\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.elements.1.width','50'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.name','\"Informações Gerais\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.uid','\"39b429c8-e6ac-435e-9517-626136cc9b56\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.0.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.fieldUid','\"9bf75c64-3353-4e86-b013-34e66a227011\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.uid','\"366806ad-161b-4a38-8956-37662cff805b\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.0.width','50'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.fieldUid','\"e7257f8f-1d2b-463c-96d5-ca9fb4e0814f\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.uid','\"c827a949-4a0e-4e11-acb8-2519507a9205\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.1.width','50'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.fieldUid','\"6963b7c0-3841-4923-b316-75ce66aefdff\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.uid','\"121033d5-3620-4d94-9761-861f61f66848\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.2.width','50'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.fieldUid','\"ec4f2482-6a6a-4129-a8f1-70835234cf27\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.uid','\"db264e5a-94fc-45e2-8dc6-23ff35a6ecde\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.3.width','50'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.fieldUid','\"661451bc-35bc-4d1c-b544-24a4294d9560\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.uid','\"6dccc324-e844-4e84-91d7-84e544a07348\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.elements.4.width','100'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.name','\"Morada\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.uid','\"05a92c54-b5e5-4cdc-b7f9-3c1eba9226a5\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.1.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.elementCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.fieldUid','\"3522d11c-1676-489e-b336-4647089388d4\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.instructions','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.label','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.required','false'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.tip','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.uid','\"6c5b896a-44c9-494b-8882-ce2270be6efd\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.warning','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.elements.0.width','100'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.name','\"Outras Informações\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.uid','\"446aad37-90cb-4a77-801f-4fa09da32be6\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.fieldLayouts.75fb3173-9b11-4043-ae27-31ebc53128c1.tabs.2.userCondition','null'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.handle','\"organization\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.name','\"Organização\"'),('globalSets.b148a766-6998-48cc-8d1e-45790c4cf220.sortOrder','5'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elementCondition','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.elementCondition','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.fieldUid','\"625190d1-527c-4ea1-84dd-c752c55aff02\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.instructions','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.label','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.required','false'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.tip','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.uid','\"93b11f06-4d25-48f5-b372-49cb31851d6f\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.userCondition','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.warning','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.0.width','50'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.elementCondition','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.fieldUid','\"4132f438-075d-4ca1-b68d-2a215d1dd2ea\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.instructions','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.label','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.required','false'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.tip','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.uid','\"43882c53-419f-4776-8cbd-2e5ef0c6f0dc\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.userCondition','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.warning','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.elements.1.width','100'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.name','\"Conteudo\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.uid','\"4cf70fa3-8b95-45b8-be3f-4a4287fce342\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.fieldLayouts.6e21f431-870a-471e-9078-80da74f77531.tabs.0.userCondition','null'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.handle','\"head\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.name','\"head\"'),('globalSets.b1e8401f-82c3-4599-ae64-0034608bd86b.sortOrder','1'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elementCondition','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.elementCondition','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.fieldUid','\"9ba971ee-6616-4e6e-b216-29c1e91a1d2f\"'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.instructions','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.label','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.required','false'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.tip','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.uid','\"0de666a5-2c42-46a4-bf4f-2c45b537f18d\"'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.userCondition','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.warning','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.elements.0.width','100'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.name','\"Conteudo\"'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.uid','\"39071c8a-20a0-4d7a-97f3-ca06d86ef005\"'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.fieldLayouts.e36f68f4-941a-46aa-a9d6-7caac087ae30.tabs.0.userCondition','null'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.handle','\"socials\"'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.name','\"Redes Sociais\"'),('globalSets.d0c2a04c-3370-4bcb-84db-47ce81ab6643.sortOrder','6'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.field','\"ea3b61d5-7e5b-4b00-ac14-8498e58e5592\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elementCondition','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.elementCondition','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.fieldUid','\"2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.instructions','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.label','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.required','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.tip','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.uid','\"e825e124-1148-42b3-8bfb-3f09fbcf13c2\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.userCondition','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.warning','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.0.width','50'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.elementCondition','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.fieldUid','\"2d13b60a-e774-4457-a865-2a1751584f8f\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.instructions','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.label','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.required','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.tip','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.uid','\"3be7ee76-741a-4bc9-8083-a13fe37236e8\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.userCondition','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.warning','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.elements.1.width','50'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.name','\"Content\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.uid','\"97e6b6de-e654-4ea4-ad97-a1f95b77e927\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fieldLayouts.a34550d8-0788-45af-84df-e16730f491ea.tabs.0.userCondition','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.columnSuffix','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.contentColumnType','\"string\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.fieldGroup','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.handle','\"document\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.instructions','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.name','\"Documento\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.searchable','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.allowedKinds.0','\"pdf\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.allowedKinds.1','\"powerpoint\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.allowedKinds.2','\"text\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.allowedKinds.3','\"word\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.allowSelfRelations','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.allowSubfolders','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.allowUploads','true'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.branchLimit','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.defaultUploadLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.defaultUploadLocationSubpath','\"documentos\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.localizeRelations','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.maintainHierarchy','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.maxRelations','1'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.minRelations','1'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.previewMode','\"thumbs\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.restrictedDefaultUploadSubpath','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.restrictedLocationSource','\"volume:607d505e-191b-4716-bdb2-1aa2f7bf1b09\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.restrictedLocationSubpath','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.restrictFiles','true'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.restrictLocation','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.selectionLabel','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.showSiteMenu','true'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.showUnpermittedFiles','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.showUnpermittedVolumes','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.sources','\"*\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.targetSiteId','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.validateRelatedElements','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.settings.viewMode','\"large\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.translationKeyFormat','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.translationMethod','\"site\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2d13b60a-e774-4457-a865-2a1751584f8f.type','\"craft\\\\fields\\\\Assets\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.columnSuffix','\"wzfzgsfg\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.contentColumnType','\"text\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.fieldGroup','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.handle','\"label\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.instructions','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.name','\"Label\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.searchable','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.byteLimit','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.charLimit','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.code','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.columnType','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.initialRows','4'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.multiline','false'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.placeholder','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.settings.uiMode','\"normal\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.translationKeyFormat','null'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.translationMethod','\"none\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.fields.2e10c0e6-8d5e-4ee4-a6ef-c03e62534a7b.type','\"craft\\\\fields\\\\PlainText\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.handle','\"link\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.name','\"link\"'),('matrixBlockTypes.06653406-9909-4c6d-8cb8-a3f1df52467c.sortOrder','1'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.field','\"9ba971ee-6616-4e6e-b216-29c1e91a1d2f\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elementCondition','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.elementCondition','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.fieldUid','\"6dcf8de8-6e9b-4d86-b816-cd5366542779\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.instructions','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.label','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.required','false'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.tip','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.uid','\"84b9c192-f354-4f2e-afe9-873c5a4a0095\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.userCondition','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.warning','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.0.width','50'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.elementCondition','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.fieldUid','\"2ddb23e1-bd23-459d-b1ab-37bd7021ef18\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.instructions','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.label','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.required','false'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.tip','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.uid','\"d1c6b4a2-373e-4b8f-bd2d-ce9eaa7c4112\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.userCondition','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.warning','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.1.width','50'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.2.elementCondition','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.2.fieldUid','\"1568a823-f93a-4a46-a859-168a822b1f19\"'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.2.instructions','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.2.label','null'),('matrixBlockTypes.a66ff91d-fa54-44be-a228-fc1c55be4647.fieldLayouts.61a9a6da-2d11-4b32-8b19-b51512d25d22.tabs.0.elements.2.required','fal