<?php
/**
 * @link http://craftcms.com/
 * @copyright Copyright (c) Pixel & Tonic, Inc.
 * @license http://craftcms.com/license
 */

namespace craft\behaviors;

use yii\base\Behavior;

/**
 * Custom field behavior
 *
 * This class provides attributes for all the unique custom field handles.
 *
 * @method static favicon(mixed $value) Sets the [[favicon]] property
 * @method static metaImage(mixed $value) Sets the [[metaImage]] property
 * @method static metaTitle(mixed $value) Sets the [[metaTitle]] property
 * @method static metaDescription(mixed $value) Sets the [[metaDescription]] property
 * @method static html(mixed $value) Sets the [[html]] property
 * @method static organizationName(mixed $value) Sets the [[organizationName]] property
 * @method static email(mixed $value) Sets the [[email]] property
 * @method static address(mixed $value) Sets the [[address]] property
 * @method static postalCode(mixed $value) Sets the [[postalCode]] property
 * @method static city(mixed $value) Sets the [[city]] property
 * @method static country(mixed $value) Sets the [[country]] property
 * @method static phone(mixed $value) Sets the [[phone]] property
 * @method static logo(mixed $value) Sets the [[logo]] property
 * @method static backgroundImage(mixed $value) Sets the [[backgroundImage]] property
 * @method static contacts(mixed $value) Sets the [[contacts]] property
 * @method static contact(mixed $value) Sets the [[contact]] property
 * @method static label(mixed $value) Sets the [[label]] property
 * @method static socials(mixed $value) Sets the [[socials]] property
 * @method static social_url(mixed $value) Sets the [[social_url]] property
 * @method static icon(mixed $value) Sets the [[icon]] property
 * @method static copyright(mixed $value) Sets the [[copyright]] property
 * @method static linksPdf(mixed $value) Sets the [[linksPdf]] property
 * @method static linkImages(mixed $value) Sets the [[linkImages]] property
 * @method static image(mixed $value) Sets the [[image]] property
 * @method static imageLink(mixed $value) Sets the [[imageLink]] property
 * @method static richText(mixed $value) Sets the [[richText]] property
 * @method static newsTags(mixed $value) Sets the [[newsTags]] property
 * @method static newsCategories(mixed $value) Sets the [[newsCategories]] property
 * @method static seo(mixed $value) Sets the [[seo]] property
 * @method static shortDescription(mixed $value) Sets the [[shortDescription]] property
 * @method static latitude(mixed $value) Sets the [[latitude]] property
 * @method static longitude(mixed $value) Sets the [[longitude]] property
 * @method static location(mixed $value) Sets the [[location]] property
 * @method static date(mixed $value) Sets the [[date]] property
 * @method static documents(mixed $value) Sets the [[documents]] property
 * @method static showGallery(mixed $value) Sets the [[showGallery]] property
 * @method static showNews(mixed $value) Sets the [[showNews]] property
 * @method static formHandle(mixed $value) Sets the [[formHandle]] property
 * @method static name(mixed $value) Sets the [[name]] property
 * @method static subject(mixed $value) Sets the [[subject]] property
 * @method static message(mixed $value) Sets the [[message]] property
 * @method static acceptTerms(mixed $value) Sets the [[acceptTerms]] property
 * @method static problem(mixed $value) Sets the [[problem]] property
 * @method static nif(mixed $value) Sets the [[nif]] property
 * @method static morada(mixed $value) Sets the [[morada]] property
 * @method static localidade(mixed $value) Sets the [[localidade]] property
 * @method static estadoCivil(mixed $value) Sets the [[estadoCivil]] property
 * @method static job(mixed $value) Sets the [[job]] property
 * @method static father(mixed $value) Sets the [[father]] property
 * @method static mother(mixed $value) Sets the [[mother]] property
 * @method static birthDate(mixed $value) Sets the [[birthDate]] property
 * @method static naturalidade(mixed $value) Sets the [[naturalidade]] property
 * @method static binumber(mixed $value) Sets the [[binumber]] property
 * @method static validadeDoCC(mixed $value) Sets the [[validadeDoCC]] property
 * @method static emission(mixed $value) Sets the [[emission]] property
 * @method static emissionDate(mixed $value) Sets the [[emissionDate]] property
 * @method static fileUpload(mixed $value) Sets the [[fileUpload]] property
 * @method static institutionName(mixed $value) Sets the [[institutionName]] property
 * @method static nomeDoCurso(mixed $value) Sets the [[nomeDoCurso]] property
 * @method static localidadeDegree(mixed $value) Sets the [[localidadeDegree]] property
 * @method static postalCodeDegree(mixed $value) Sets the [[postalCodeDegree]] property
 * @method static tamanhoDoAgregadoFamiliar(mixed $value) Sets the [[tamanhoDoAgregadoFamiliar]] property
 * @method static pessoa1(mixed $value) Sets the [[pessoa1]] property
 * @method static grauDeParentesco(mixed $value) Sets the [[grauDeParentesco]] property
 * @method static pessoa2(mixed $value) Sets the [[pessoa2]] property
 * @method static pessoa3(mixed $value) Sets the [[pessoa3]] property
 * @method static pessoa4(mixed $value) Sets the [[pessoa4]] property
 * @method static pessoa5(mixed $value) Sets the [[pessoa5]] property
 * @method static pessoa6(mixed $value) Sets the [[pessoa6]] property
 * @method static pessoa7(mixed $value) Sets the [[pessoa7]] property
 * @method static pessoa8(mixed $value) Sets the [[pessoa8]] property
 * @method static pessoa9(mixed $value) Sets the [[pessoa9]] property
 * @method static pessoa10(mixed $value) Sets the [[pessoa10]] property
 * @method static fullName(mixed $value) Sets the [[fullName]] property
 * @method static emailAdress(mixed $value) Sets the [[emailAdress]] property
 * @method static messageContacts(mixed $value) Sets the [[messageContacts]] property
 * @method static acceptTermsContacts(mixed $value) Sets the [[acceptTermsContacts]] property
 * @method static menu(mixed $value) Sets the [[menu]] property
 * @method static linkPrincipal(mixed $value) Sets the [[linkPrincipal]] property
 * @method static submenu(mixed $value) Sets the [[submenu]] property
 * @method static weatherApiKey(mixed $value) Sets the [[weatherApiKey]] property
 * @method static tipoDeLink(mixed $value) Sets the [[tipoDeLink]] property
 * @method static linkExterno(mixed $value) Sets the [[linkExterno]] property
 * @method static linkInterno(mixed $value) Sets the [[linkInterno]] property
 */
class CustomFieldBehavior extends Behavior
{
    /**
     * @var bool Whether the behavior should provide methods based on the field handles.
     */
    public bool $hasMethods = false;

    /**
     * @var bool Whether properties on the class should be settable directly.
     */
    public bool $canSetProperties = true;

    /**
     * @var array<string,bool> List of supported field handles.
     */
    public static $fieldHandles = [
        'favicon' => true,
        'metaImage' => true,
        'metaTitle' => true,
        'metaDescription' => true,
        'html' => true,
        'organizationName' => true,
        'email' => true,
        'address' => true,
        'postalCode' => true,
        'city' => true,
        'country' => true,
        'phone' => true,
        'logo' => true,
        'backgroundImage' => true,
        'contacts' => true,
        'contact' => true,
        'label' => true,
        'socials' => true,
        'social_url' => true,
        'icon' => true,
        'copyright' => true,
        'linksPdf' => true,
        'linkImages' => true,
        'image' => true,
        'imageLink' => true,
        'richText' => true,
        'newsTags' => true,
        'newsCategories' => true,
        'seo' => true,
        'shortDescription' => true,
        'latitude' => true,
        'longitude' => true,
        'location' => true,
        'date' => true,
        'documents' => true,
        'showGallery' => true,
        'showNews' => true,
        'formHandle' => true,
        'name' => true,
        'subject' => true,
        'message' => true,
        'acceptTerms' => true,
        'problem' => true,
        'nif' => true,
        'morada' => true,
        'localidade' => true,
        'estadoCivil' => true,
        'job' => true,
        'father' => true,
        'mother' => true,
        'birthDate' => true,
        'naturalidade' => true,
        'binumber' => true,
        'validadeDoCC' => true,
        'emission' => true,
        'emissionDate' => true,
        'fileUpload' => true,
        'institutionName' => true,
        'nomeDoCurso' => true,
        'localidadeDegree' => true,
        'postalCodeDegree' => true,
        'tamanhoDoAgregadoFamiliar' => true,
        'pessoa1' => true,
        'grauDeParentesco' => true,
        'pessoa2' => true,
        'pessoa3' => true,
        'pessoa4' => true,
        'pessoa5' => true,
        'pessoa6' => true,
        'pessoa7' => true,
        'pessoa8' => true,
        'pessoa9' => true,
        'pessoa10' => true,
        'fullName' => true,
        'emailAdress' => true,
        'messageContacts' => true,
        'acceptTermsContacts' => true,
        'menu' => true,
        'linkPrincipal' => true,
        'submenu' => true,
        'weatherApiKey' => true,
        'tipoDeLink' => true,
        'linkExterno' => true,
        'linkInterno' => true,
    ];

    /**
     * @var \craft\elements\db\AssetQuery|\craft\elements\ElementCollection<\craft\elements\Asset> Value for field with the handle “favicon”.
     */
    public $favicon;

    /**
     * @var \craft\elements\db\AssetQuery|\craft\elements\ElementCollection<\craft\elements\Asset> Value for field with the handle “metaImage”.
     */
    public $metaImage;

    /**
     * @var string|null Value for field with the handle “metaTitle”.
     */
    public $metaTitle;

    /**
     * @var string|null Value for field with the handle “metaDescription”.
     */
    public $metaDescription;

    /**
     * @var mixed Value for field with the handle “html”.
     */
    public $html;

    /**
     * @var string|null Value for field with the handle “organizationName”.
     */
    public $organizationName;

    /**
     * @var string|null|mixed Value for field with the handle “email”.
     */
    public $email;

    /**
     * @var string|null|mixed Value for field with the handle “address”.
     */
    public $address;

    /**
     * @var string|null|mixed Value for field with the handle “postalCode”.
     */
    public $postalCode;

    /**
     * @var string|null Value for field with the handle “city”.
     */
    public $city;

    /**
     * @var string|null Value for field with the handle “country”.
     */
    public $country;

    /**
     * @var string|null|mixed Value for field with the handle “phone”.
     */
    public $phone;

    /**
     * @var \craft\elements\db\AssetQuery|\craft\elements\ElementCollection<\craft\elements\Asset> Value for field with the handle “logo”.
     */
    public $logo;

    /**
     * @var \craft\elements\db\AssetQuery|\craft\elements\ElementCollection<\craft\elements\Asset> Value for field with the handle “backgroundImage”.
     */
    public $backgroundImage;

    /**
     * @var \craft\elements\db\MatrixBlockQuery|\craft\elements\ElementCollection<\craft\elements\MatrixBlock> Value for field with the handle “contacts”.
     */
    public $contacts;

    /**
     * @var string|null Value for field with the handle “contact”.
     */
    public $contact;

    /**
     * @var string|null Value for field with the handle “label”.
     */
    public $label;

    /**
     * @var \craft\elements\db\MatrixBlockQuery|\craft\elements\ElementCollection<\craft\elements\MatrixBlock> Value for field with the handle “socials”.
     */
    public $socials;

    /**
     * @var string|null Value for field with the handle “social_url”.
     */
    public $social_url;

    /**
     * @var \craft\elements\db\AssetQuery|\craft\elements\ElementCollection<\craft\elements\Asset> Value for field with the handle “icon”.
     */
    public $icon;

    /**
     * @var string Value for field with the handle “copyright”.
     */
    public $copyright;

    /**
     * @var \craft\elements\db\MatrixBlockQuery|\craft\elements\ElementCollection<\craft\elements\MatrixBlock> Value for field with the handle “linksPdf”.
     */
    public $linksPdf;

    /**
     * @var \craft\elements\db\MatrixBlockQuery|\craft\elements\ElementCollection<\craft\elements\MatrixBlock> Value for field with the handle “linkImages”.
     */
    public $linkImages;

    /**
     * @var \craft\elements\db\AssetQuery|\craft\elements\ElementCollection<\craft\elements\Asset> Value for field with the handle “image”.
     */
    public $image;

    /**
     * @var string|null Value for field with the handle “imageLink”.
     */
    public $imageLink;

    /**
     * @var string Value for field with the handle “richText”.
     */
    public $richText;

    /**
     * @var \craft\elements\db\TagQuery|\craft\elements\ElementCollection<\craft\elements\Tag> Value for field with the handle “newsTags”.
     */
    public $newsTags;

    /**
     * @var \craft\elements\db\CategoryQuery|\craft\elements\ElementCollection<\craft\elements\Category> Value for field with the handle “newsCategories”.
     */
    public $newsCategories;

    /**
     * @var mixed Value for field with the handle “seo”.
     */
    public $seo;

    /**
     * @var string|null Value for field with the handle “shortDescription”.
     */
    public $shortDescription;

    /**
     * @var string|null Value for field with the handle “latitude”.
     */
    public $latitude;

    /**
     * @var string|null Value for field with the handle “longitude”.
     */
    public $longitude;

    /**
     * @var string|null|mixed Value for field with the handle “location”.
     */
    public $location;

    /**
     * @var \DateTime|null Value for field with the handle “date”.
     */
    public $date;

    /**
     * @var \craft\elements\db\AssetQuery|\craft\elements\ElementCollection<\craft\elements\Asset> Value for field with the handle “documents”.
     */
    public $documents;

    /**
     * @var bool Value for field with the handle “showGallery”.
     */
    public $showGallery;

    /**
     * @var bool Value for field with the handle “showNews”.
     */
    public $showNews;

    /**
     * @var string|null Value for field with the handle “formHandle”.
     */
    public $formHandle;

    /**
     * @var mixed Value for field with the handle “name”.
     */
    public $name;

    /**
     * @var mixed Value for field with the handle “subject”.
     */
    public $subject;

    /**
     * @var mixed Value for field with the handle “message”.
     */
    public $message;

    /**
     * @var mixed Value for field with the handle “acceptTerms”.
     */
    public $acceptTerms;

    /**
     * @var mixed Value for field with the handle “problem”.
     */
    public $problem;

    /**
     * @var mixed Value for field with the handle “nif”.
     */
    public $nif;

    /**
     * @var mixed Value for field with the handle “morada”.
     */
    public $morada;

    /**
     * @var mixed Value for field with the handle “localidade”.
     */
    public $localidade;

    /**
     * @var mixed Value for field with the handle “estadoCivil”.
     */
    public $estadoCivil;

    /**
     * @var mixed Value for field with the handle “job”.
     */
    public $job;

    /**
     * @var mixed Value for field with the handle “father”.
     */
    public $father;

    /**
     * @var mixed Value for field with the handle “mother”.
     */
    public $mother;

    /**
     * @var mixed Value for field with the handle “birthDate”.
     */
    public $birthDate;

    /**
     * @var mixed Value for field with the handle “naturalidade”.
     */
    public $naturalidade;

    /**
     * @var mixed Value for field with the handle “binumber”.
     */
    public $binumber;

    /**
     * @var mixed Value for field with the handle “validadeDoCC”.
     */
    public $validadeDoCC;

    /**
     * @var mixed Value for field with the handle “emission”.
     */
    public $emission;

    /**
     * @var mixed Value for field with the handle “emissionDate”.
     */
    public $emissionDate;

    /**
     * @var mixed Value for field with the handle “fileUpload”.
     */
    public $fileUpload;

    /**
     * @var mixed Value for field with the handle “institutionName”.
     */
    public $institutionName;

    /**
     * @var mixed Value for field with the handle “nomeDoCurso”.
     */
    public $nomeDoCurso;

    /**
     * @var mixed Value for field with the handle “localidadeDegree”.
     */
    public $localidadeDegree;

    /**
     * @var mixed Value for field with the handle “postalCodeDegree”.
     */
    public $postalCodeDegree;

    /**
     * @var mixed Value for field with the handle “tamanhoDoAgregadoFamiliar”.
     */
    public $tamanhoDoAgregadoFamiliar;

    /**
     * @var mixed Value for field with the handle “pessoa1”.
     */
    public $pessoa1;

    /**
     * @var mixed Value for field with the handle “grauDeParentesco”.
     */
    public $grauDeParentesco;

    /**
     * @var mixed Value for field with the handle “pessoa2”.
     */
    public $pessoa2;

    /**
     * @var mixed Value for field with the handle “pessoa3”.
     */
    public $pessoa3;

    /**
     * @var mixed Value for field with the handle “pessoa4”.
     */
    public $pessoa4;

    /**
     * @var mixed Value for field with the handle “pessoa5”.
     */
    public $pessoa5;

    /**
     * @var mixed Value for field with the handle “pessoa6”.
     */
    public $pessoa6;

    /**
     * @var mixed Value for field with the handle “pessoa7”.
     */
    public $pessoa7;

    /**
     * @var mixed Value for field with the handle “pessoa8”.
     */
    public $pessoa8;

    /**
     * @var mixed Value for field with the handle “pessoa9”.
     */
    public $pessoa9;

    /**
     * @var mixed Value for field with the handle “pessoa10”.
     */
    public $pessoa10;

    /**
     * @var mixed Value for field with the handle “fullName”.
     */
    public $fullName;

    /**
     * @var mixed Value for field with the handle “emailAdress”.
     */
    public $emailAdress;

    /**
     * @var mixed Value for field with the handle “messageContacts”.
     */
    public $messageContacts;

    /**
     * @var mixed Value for field with the handle “acceptTermsContacts”.
     */
    public $acceptTermsContacts;

    /**
     * @var \craft\elements\db\MatrixBlockQuery|\craft\elements\ElementCollection<\craft\elements\MatrixBlock> Value for field with the handle “menu”.
     */
    public $menu;

    /**
     * @var \craft\elements\db\EntryQuery|\craft\elements\ElementCollection<\craft\elements\Entry> Value for field with the handle “linkPrincipal”.
     */
    public $linkPrincipal;

    /**
     * @var \craft\elements\db\EntryQuery|\craft\elements\ElementCollection<\craft\elements\Entry>|array|null Value for field with the handle “submenu”.
     */
    public $submenu;

    /**
     * @var string|null Value for field with the handle “weatherApiKey”.
     */
    public $weatherApiKey;

    /**
     * @var bool Value for field with the handle “tipoDeLink”.
     */
    public $tipoDeLink;

    /**
     * @var string|null Value for field with the handle “linkExterno”.
     */
    public $linkExterno;

    /**
     * @var \craft\elements\db\EntryQuery|\craft\elements\ElementCollection<\craft\elements\Entry> Value for field with the handle “linkInterno”.
     */
    public $linkInterno;

    /**
     * @var array Additional custom field values we don’t know about yet.
     */
    private array $_customFieldValues = [];

    /**
     * @inheritdoc
     */
    public function __call($name, $params)
    {
        if ($this->hasMethods && isset(self::$fieldHandles[$name]) && count($params) === 1) {
            $this->$name = $params[0];
            return $this->owner;
        }
        return parent::__call($name, $params);
    }

    /**
     * @inheritdoc
     */
    public function hasMethod($name): bool
    {
        if ($this->hasMethods && isset(self::$fieldHandles[$name])) {
            return true;
        }
        return parent::hasMethod($name);
    }

    /**
     * @inheritdoc
     */
    public function __isset($name): bool
    {
        if (isset(self::$fieldHandles[$name])) {
            return true;
        }
        return parent::__isset($name);
    }

    /**
     * @inheritdoc
     */
    public function __get($name)
    {
        if (isset(self::$fieldHandles[$name])) {
            return $this->_customFieldValues[$name] ?? null;
        }
        return parent::__get($name);
    }

    /**
     * @inheritdoc
     */
    public function __set($name, $value)
    {
        if (isset(self::$fieldHandles[$name])) {
            $this->_customFieldValues[$name] = $value;
            return;
        }
        parent::__set($name, $value);
    }

    /**
     * @inheritdoc
     */
    public function canGetProperty($name, $checkVars = true): bool
    {
        if ($checkVars && isset(self::$fieldHandles[$name])) {
            return true;
        }
        return parent::canGetProperty($name, $checkVars);
    }

    /**
     * @inheritdoc
     */
    public function canSetProperty($name, $checkVars = true): bool
    {
        if (!$this->canSetProperties) {
            return false;
        }
        if ($checkVars && isset(self::$fieldHandles[$name])) {
            return true;
        }
        return parent::canSetProperty($name, $checkVars);
    }
}
