<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* express-forms/forms/index */
class __TwigTemplate_ac026418ec5f425692594f25756b4c09 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'actionButton' => [$this, 'block_actionButton'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context)
    {
        // line 1
        return "_layouts/cp";
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        craft\helpers\Template::beginProfile("template", "express-forms/forms/index");
        // line 3
        $context["title"] = "Forms";
        // line 4
        $context["selectedSubnavItem"] = "forms";
        // line 1
        $this->parent = $this->loadTemplate("_layouts/cp", "express-forms/forms/index", 1);
        $this->parent->display($context, array_merge($this->blocks, $blocks));
        craft\helpers\Template::endProfile("template", "express-forms/forms/index");
    }

    // line 6
    public function block_actionButton($context, array $blocks = [])
    {
        $macros = $this->macros;
        craft\helpers\Template::beginProfile("block", "actionButton");
        // line 7
        echo "
    ";
        // line 8
        if (craft\helpers\Template::attribute($this->env, $this->source, (isset($context["currentUser"]) || array_key_exists("currentUser", $context) ? $context["currentUser"] : (function () { throw new RuntimeError('Variable "currentUser" does not exist.', 8, $this->source); })()), "can", ["express-forms-forms"], "method")) {
            // line 9
            echo "        <a class=\"btn submit add icon\" href=\"";
            echo twig_escape_filter($this->env, craft\helpers\UrlHelper::url("express-forms/forms/new/"), "html", null, true);
            echo "\">
            ";
            // line 10
            echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("New Form", "express-forms"), "html", null, true);
            echo "
        </a>
    ";
        }
        // line 13
        echo "
";
        craft\helpers\Template::endProfile("block", "actionButton");
    }

    // line 16
    public function block_content($context, array $blocks = [])
    {
        $macros = $this->macros;
        craft\helpers\Template::beginProfile("block", "content");
        // line 17
        echo "
    <style>
        #form-cards, .error-log-banner {
            display: none;
        }
    </style>

    ";
        // line 24
        if ((isset($context["errorLogCount"]) || array_key_exists("errorLogCount", $context) ? $context["errorLogCount"] : (function () { throw new RuntimeError('Variable "errorLogCount" does not exist.', 24, $this->source); })())) {
            // line 25
            echo "        <div class=\"error-log-banner\">
            <p>
                ";
            // line 27
            echo $this->extensions['craft\web\twig\Extension']->translateFilter("There are currently <a href=\"{link}\">{count} logged errors</a> in the Express Forms error log.", "express-forms", ["count" =>             // line 28
(isset($context["errorLogCount"]) || array_key_exists("errorLogCount", $context) ? $context["errorLogCount"] : (function () { throw new RuntimeError('Variable "errorLogCount" does not exist.', 28, $this->source); })()), "link" => craft\helpers\UrlHelper::url("express-forms/settings/error-log")]);
            // line 30
            echo "
            </p>
        </div>
    ";
        }
        // line 34
        echo "
    ";
        // line 35
        if ($this->extensions['craft\web\twig\Extension']->lengthFilter($this->env, (isset($context["forms"]) || array_key_exists("forms", $context) ? $context["forms"] : (function () { throw new RuntimeError('Variable "forms" does not exist.', 35, $this->source); })()))) {
            // line 36
            echo "
        <ul id=\"form-cards\">
            ";
            // line 38
            $context['_parent'] = $context;
            $context['_seq'] = twig_ensure_traversable((isset($context["forms"]) || array_key_exists("forms", $context) ? $context["forms"] : (function () { throw new RuntimeError('Variable "forms" does not exist.', 38, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["form"]) {
                // line 39
                echo "                <li data-id=\"";
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "id", []), "html", null, true);
                echo "\">
                    <div class=\"card-body\">
                        <div class=\"corner\"
                             style=\"border-left-color: ";
                // line 42
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "color", []), "html", null, true);
                echo "; border-top-color: ";
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "color", []), "html", null, true);
                echo "\"></div>
                        <div class=\"card-info\">
                            <a class=\"form-name\" href=\"";
                // line 44
                echo twig_escape_filter($this->env, craft\helpers\UrlHelper::cpUrl(("express-forms/forms/" . craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "handle", []))), "html", null, true);
                echo "\">
                                ";
                // line 45
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "name", []), "html", null, true);
                echo "
                            </a>
                            <div class=\"form-handle\"
                                 title=\"";
                // line 48
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Handle for this Form", "express-forms"), "html", null, true);
                echo "\">";
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "handle", []), "html", null, true);
                echo "</div>

                            <p class=\"form-description\">
                                ";
                // line 51
                echo twig_escape_filter($this->env, (((craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "description", [], "any", true, true) &&  !(null === craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "description", [])))) ? (craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "description", [])) : ($this->extensions['craft\web\twig\Extension']->translateFilter("No description", "express-forms"))), "html", null, true);
                echo "
                            </p>
                        </div>

                        <ul class=\"card-actions\">
                            <li>
                                <a class=\"delete-form\"
                                   data-icon=\"remove\"
                                   data-id=\"";
                // line 59
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "id", []), "html", null, true);
                echo "\"
                                   data-message=\"";
                // line 60
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Are you sure you want to delete this form?", "express-forms"), "html", null, true);
                echo "\"
                                   title=\"";
                // line 61
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Delete this Form", "express-forms"), "html", null, true);
                echo "\"></a>
                            </li>
                            <li>
                                <a class=\"duplicate-form icon-docs\"
                                   data-uuid=\"";
                // line 65
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "uuid", []), "html", null, true);
                echo "\"
                                   data-message=\"";
                // line 66
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Are you sure you want to duplicate this form?", "express-forms"), "html", null, true);
                echo "\"
                                   title=\"";
                // line 67
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Duplicate this Form", "express-forms"), "html", null, true);
                echo "\"></a>
                            </li>
                            <li>
                                <a class=\"icon-menu drag-handle\"
                                   title=\"";
                // line 71
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Rearrange this Form", "express-forms"), "html", null, true);
                echo "\"></a>
                            </li>
                        </ul>

                        <ul class=\"integrations\">
                            ";
                // line 76
                if ($this->extensions['craft\web\twig\Extension']->lengthFilter($this->env, craft\helpers\Template::attribute($this->env, $this->source, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "integrations", []), "mailingListMappings", []))) {
                    // line 77
                    echo "                                <li title=\"";
                    echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Mailing List integration for this Form", "express-forms"), "html", null, true);
                    echo "\"><span
                                            class=\"icon-email\"></span></li>
                            ";
                }
                // line 80
                echo "
                            ";
                // line 81
                if ($this->extensions['craft\web\twig\Extension']->lengthFilter($this->env, craft\helpers\Template::attribute($this->env, $this->source, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "integrations", []), "crmMappings", []))) {
                    // line 82
                    echo "                                <li title=\"";
                    echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("CRM integration for this Form", "express-forms"), "html", null, true);
                    echo "\"><span
                                            class=\"icon-upload-cloud\"></span></li>
                            ";
                }
                // line 85
                echo "                        </ul>
                    </div>

                    <div class=\"card-footer\">
                        ";
                // line 89
                if (craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "saveSubmissions", [])) {
                    // line 90
                    echo "                            <a class=\"submissions\" href=\"";
                    echo twig_escape_filter($this->env, craft\helpers\UrlHelper::url(("express-forms/submissions/" . craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "handle", []))), "html", null, true);
                    echo "\">
                                <div>";
                    // line 91
                    echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "submissionCount", []), "html", null, true);
                    echo "</div>
                                ";
                    // line 92
                    echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Submissions", "express-forms"), "html", null, true);
                    echo "
                            </a>
                        ";
                } else {
                    // line 95
                    echo "                            <div class=\"submissions-not-stored\">
                                ";
                    // line 96
                    echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Submissions not stored", "express-forms"), "html", null, true);
                    echo "
                            </div>
                        ";
                }
                // line 99
                echo "
                        <div class=\"spam\"
                             title=\"";
                // line 101
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Submissions blocked by Honeypot Spam Protection", "express-forms"), "html", null, true);
                echo "\">
                            <div>
                            <span>
                                <span class=\"counter\">";
                // line 104
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "spamCount", []), "html", null, true);
                echo "</span>
                                <a class=\"icon-cw btn reset-spam\"
                                   data-uuid=\"";
                // line 106
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "uuid", []), "html", null, true);
                echo "\"
                                   data-message=\"";
                // line 107
                echo "Are you sure you want to reset the spam count for this form?";
                echo "\"
                                   title=\"";
                // line 108
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Reset count", "express-forms"), "html", null, true);
                echo "\"></a>
                            </span>
                            </div>
                            ";
                // line 111
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Blocked", "express-forms"), "html", null, true);
                echo "
                        </div>

                        <div class=\"export\">
                            <div class=\"select\">
                                <form method=\"post\">
                                    ";
                // line 117
                echo craft\helpers\Html::csrfInput();
                echo "
                                    <input type=\"hidden\" name=\"action\" value=\"express-forms/export\" />
                                    <input type=\"hidden\" name=\"id\" value=\"";
                // line 119
                echo twig_escape_filter($this->env, craft\helpers\Template::attribute($this->env, $this->source, $context["form"], "uuid", []), "html", null, true);
                echo "\" />

                                    <select class=\"exporter\" name=\"type\">
                                        <option value=\"\">";
                // line 122
                echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Export...", "express-forms"), "html", null, true);
                echo "</option>
                                        <optgroup label=\"-------------\">
                                            ";
                // line 124
                $context['_parent'] = $context;
                $context['_seq'] = twig_ensure_traversable((isset($context["exportTypes"]) || array_key_exists("exportTypes", $context) ? $context["exportTypes"] : (function () { throw new RuntimeError('Variable "exportTypes" does not exist.', 124, $this->source); })()));
                foreach ($context['_seq'] as $context["handle"] => $context["name"]) {
                    // line 125
                    echo "                                                <option value=\"";
                    echo twig_escape_filter($this->env, $context["handle"], "html", null, true);
                    echo "\">";
                    echo twig_escape_filter($this->env, $context["name"], "html", null, true);
                    echo "</option>
                                            ";
                }
                $_parent = $context['_parent'];
                unset($context['_seq'], $context['_iterated'], $context['handle'], $context['name'], $context['_parent'], $context['loop']);
                $context = array_intersect_key($context, $_parent) + $_parent;
                // line 127
                echo "                                        </optgroup>
                                    </select>
                                </form>
                            </div>
                        </div>
                    </div>
                </li>
            ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_iterated'], $context['_key'], $context['form'], $context['_parent'], $context['loop']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 135
            echo "        </ul>

    ";
        } else {
            // line 138
            echo "
        <p>
            ";
            // line 140
            echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("You haven't created any forms yet...", "express-forms"), "html", null, true);
            echo "
        </p>
        <ul class=\"form-helper-list\">
            <li>
                <a href=\"";
            // line 144
            echo twig_escape_filter($this->env, craft\helpers\UrlHelper::url("express-forms/forms/new/"), "html", null, true);
            echo "\">
                    ";
            // line 145
            echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Create a New Form now", "express-forms"), "html", null, true);
            echo "
                </a>
            </li>
            <li>
                <a href=\"";
            // line 149
            echo twig_escape_filter($this->env, craft\helpers\UrlHelper::url("express-forms/settings/demo/"), "html", null, true);
            echo "\">
                    ";
            // line 150
            echo twig_escape_filter($this->env, $this->extensions['craft\web\twig\Extension']->translateFilter("Install the Demo to get a quick start", "express-forms"), "html", null, true);
            echo "
                </a>
            </li>
        </ul>


    ";
        }
        // line 157
        echo "
";
        craft\helpers\Template::endProfile("block", "content");
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName()
    {
        return "express-forms/forms/index";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable()
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo()
    {
        return array (  380 => 157,  370 => 150,  366 => 149,  359 => 145,  355 => 144,  348 => 140,  344 => 138,  339 => 135,  326 => 127,  315 => 125,  311 => 124,  306 => 122,  300 => 119,  295 => 117,  286 => 111,  280 => 108,  276 => 107,  272 => 106,  267 => 104,  261 => 101,  257 => 99,  251 => 96,  248 => 95,  242 => 92,  238 => 91,  233 => 90,  231 => 89,  225 => 85,  218 => 82,  216 => 81,  213 => 80,  206 => 77,  204 => 76,  196 => 71,  189 => 67,  185 => 66,  181 => 65,  174 => 61,  170 => 60,  166 => 59,  155 => 51,  147 => 48,  141 => 45,  137 => 44,  130 => 42,  123 => 39,  119 => 38,  115 => 36,  113 => 35,  110 => 34,  104 => 30,  102 => 28,  101 => 27,  97 => 25,  95 => 24,  86 => 17,  81 => 16,  75 => 13,  69 => 10,  64 => 9,  62 => 8,  59 => 7,  54 => 6,  48 => 1,  46 => 4,  44 => 3,  36 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("{% extends \"_layouts/cp\" %}

{% set title = \"Forms\" %}
{% set selectedSubnavItem = \"forms\" %}

{% block actionButton %}

    {% if currentUser.can(\"express-forms-forms\") %}
        <a class=\"btn submit add icon\" href=\"{{ url('express-forms/forms/new/') }}\">
            {{ \"New Form\"|t(\"express-forms\") }}
        </a>
    {% endif %}

{% endblock %}

{% block content %}

    <style>
        #form-cards, .error-log-banner {
            display: none;
        }
    </style>

    {% if errorLogCount %}
        <div class=\"error-log-banner\">
            <p>
                {{ 'There are currently <a href=\"{link}\">{count} logged errors</a> in the Express Forms error log.'|t(\"express-forms\", {
                    count: errorLogCount,
                    link: url(\"express-forms/settings/error-log\"),
                })|raw }}
            </p>
        </div>
    {% endif %}

    {% if forms|length %}

        <ul id=\"form-cards\">
            {% for form in forms %}
                <li data-id=\"{{ form.id }}\">
                    <div class=\"card-body\">
                        <div class=\"corner\"
                             style=\"border-left-color: {{ form.color }}; border-top-color: {{ form.color }}\"></div>
                        <div class=\"card-info\">
                            <a class=\"form-name\" href=\"{{ cpUrl(\"express-forms/forms/\" ~ form.handle) }}\">
                                {{ form.name }}
                            </a>
                            <div class=\"form-handle\"
                                 title=\"{{ \"Handle for this Form\"|t(\"express-forms\") }}\">{{ form.handle }}</div>

                            <p class=\"form-description\">
                                {{ form.description ?? \"No description\"|t(\"express-forms\") }}
                            </p>
                        </div>

                        <ul class=\"card-actions\">
                            <li>
                                <a class=\"delete-form\"
                                   data-icon=\"remove\"
                                   data-id=\"{{ form.id }}\"
                                   data-message=\"{{ \"Are you sure you want to delete this form?\"|t(\"express-forms\") }}\"
                                   title=\"{{ \"Delete this Form\"|t(\"express-forms\") }}\"></a>
                            </li>
                            <li>
                                <a class=\"duplicate-form icon-docs\"
                                   data-uuid=\"{{ form.uuid }}\"
                                   data-message=\"{{ \"Are you sure you want to duplicate this form?\"|t(\"express-forms\") }}\"
                                   title=\"{{ \"Duplicate this Form\"|t(\"express-forms\") }}\"></a>
                            </li>
                            <li>
                                <a class=\"icon-menu drag-handle\"
                                   title=\"{{ \"Rearrange this Form\"|t(\"express-forms\") }}\"></a>
                            </li>
                        </ul>

                        <ul class=\"integrations\">
                            {% if form.integrations.mailingListMappings|length %}
                                <li title=\"{{ \"Mailing List integration for this Form\"|t(\"express-forms\") }}\"><span
                                            class=\"icon-email\"></span></li>
                            {% endif %}

                            {% if form.integrations.crmMappings|length %}
                                <li title=\"{{ \"CRM integration for this Form\"|t(\"express-forms\") }}\"><span
                                            class=\"icon-upload-cloud\"></span></li>
                            {% endif %}
                        </ul>
                    </div>

                    <div class=\"card-footer\">
                        {% if form.saveSubmissions %}
                            <a class=\"submissions\" href=\"{{ url('express-forms/submissions/' ~ form.handle) }}\">
                                <div>{{ form.submissionCount }}</div>
                                {{ \"Submissions\"|t(\"express-forms\") }}
                            </a>
                        {% else %}
                            <div class=\"submissions-not-stored\">
                                {{ \"Submissions not stored\"|t(\"express-forms\") }}
                            </div>
                        {% endif %}

                        <div class=\"spam\"
                             title=\"{{ \"Submissions blocked by Honeypot Spam Protection\"|t(\"express-forms\") }}\">
                            <div>
                            <span>
                                <span class=\"counter\">{{ form.spamCount }}</span>
                                <a class=\"icon-cw btn reset-spam\"
                                   data-uuid=\"{{ form.uuid }}\"
                                   data-message=\"{{ 'Are you sure you want to reset the spam count for this form?' }}\"
                                   title=\"{{ \"Reset count\"|t(\"express-forms\") }}\"></a>
                            </span>
                            </div>
                            {{ \"Blocked\"|t(\"express-forms\") }}
                        </div>

                        <div class=\"export\">
                            <div class=\"select\">
                                <form method=\"post\">
                                    {{ csrfInput() }}
                                    <input type=\"hidden\" name=\"action\" value=\"express-forms/export\" />
                                    <input type=\"hidden\" name=\"id\" value=\"{{ form.uuid }}\" />

                                    <select class=\"exporter\" name=\"type\">
                                        <option value=\"\">{{ \"Export...\"|t(\"express-forms\") }}</option>
                                        <optgroup label=\"-------------\">
                                            {% for handle, name in exportTypes %}
                                                <option value=\"{{ handle }}\">{{ name }}</option>
                                            {% endfor %}
                                        </optgroup>
                                    </select>
                                </form>
                            </div>
                        </div>
                    </div>
                </li>
            {% endfor %}
        </ul>

    {% else %}

        <p>
            {{ \"You haven't created any forms yet...\"|t(\"express-forms\") }}
        </p>
        <ul class=\"form-helper-list\">
            <li>
                <a href=\"{{ url('express-forms/forms/new/') }}\">
                    {{ \"Create a New Form now\"|t(\"express-forms\") }}
                </a>
            </li>
            <li>
                <a href=\"{{ url('express-forms/settings/demo/') }}\">
                    {{ \"Install the Demo to get a quick start\"|t(\"express-forms\") }}
                </a>
            </li>
        </ul>


    {% endif %}

{% endblock %}
", "express-forms/forms/index", "/home/cooperativamaism/public_html/junta/vendor/solspace/craft-express-forms/packages/plugin/src/templates/forms/index.twig");
    }
}
