<?php
/**
 * Freeform for Craft CMS.
 *
 * @author        Solspace, Inc.
 * @copyright     Copyright (c) 2008-2022, Solspace, Inc.
 *
 * @see           https://docs.solspace.com/craft/freeform
 *
 * @license       https://docs.solspace.com/license-agreement
 */

return [
    // Universal
    'Save and continue editing' => 'Save and continue editing',
    'Save and add another' => 'Save and add another',
    'Save' => 'Save',
    'Name' => 'Name',
    'Handle' => 'Handle',
    'Delete' => 'Delete',
    'Last Updated' => 'Last Updated',

    'Success Behavior' => 'Success Behavior',
    'Reload Form with Success Message' => 'Reload Form with Success Message',
    'Load Success Template' => 'Load Success Template',
    'Use Return URL' => 'Use Return URL',
    'Success Template' => 'Success Template',
    'Select the desired success template to be used.' => 'Select the desired success template to be used.',
    'Set how you’d like the success return of this form to be handled. May also be overrided at template-level.' => 'Set how you’d like the success return of this form to be handled. May also be overrided at template-level.',
    'Select the type of form this is. When additional form types are installed, you can choose a different form type that enables special behaviors.' => 'Select the type of form this is. When additional form types are installed, you can choose a different form type that enables special behaviors.',
    'Enable AJAX' => 'Enable AJAX',
    'POST Forwarding' => 'POST Forwarding',
    'If you need to have the POST data of this form submitted to an external API, provide that custom URL here.' => 'If you need to have the POST data of this form submitted to an external API, provide that custom URL here.',
    'POST Forwarding Error Trigger' => 'POST Forwarding Error Trigger',
    'Provide a keyword or phrase Freeform should check for in the output of the external POST URL to know if and when there’s an error to log, e.g. ‘error’ or ‘an error occurred’.' => 'Provide a keyword or phrase Freeform should check for in the output of the external POST URL to know if and when there’s an error to log, e.g. ‘error’ or ‘an error occurred’.',
    'Enable Captchas' => 'Enable Captchas',

    // Api Controller
    'Label is required' => 'Label is required',
    'Handle is required' => 'Handle is required',
    'Type {type} is not allowed. Allowed types are ({allowedTypes})' => 'Type {type} is not allowed. Allowed types are ({allowedTypes})',
    'Name is required' => 'Name is required',
    "Template '{name}' already exists" => "Template '{name}' already exists",
    'Submissions' => 'Submissions',
    'Date' => 'Date',
    'Value' => 'Value',

    // CRM Controller
    'Add a CRM integration' => 'Add a CRM integration',
    "CRM integration with handle '{ID}' not found" => "CRM integration with handle '{ID}' not found",
    'CRM Integration saved' => 'CRM Integration saved',
    'CRM Integration not saved' => 'CRM Integration not saved',
    "CRM integration with handle '{handle}' not found" => "CRM integration with handle '{handle}' not found",
    'New CRM Integration' => 'New CRM Integration',
    'CRM' => 'CRM',
    'No CRM integrations exist yet' => 'No CRM integrations exist yet',
    'What this integration will be called in the CP.' => 'What this integration will be called in the CP.',
    'The unique name used to identify this integration.' => 'The unique name used to identify this integration.',
    'Service Provider' => 'Service Provider',
    'Upgrade to Pro to enable' => 'Upgrade to Pro to enable',
    'Requires Pro version' => 'Requires Pro version',
    '<a href="{url}">Upgrade to Pro</a> to get access to popular API integrations.' => '<a href="{url}">Upgrade to Pro</a> to get access to popular API integrations.',
    'Shop for CRM integrations on the {link_open}Solspace Freeform Marketplace{link_close}' => 'Shop for CRM integrations on the {link_open}Solspace Freeform Marketplace{link_close}',
    'Are you sure you want to remove the “{name}” integration?' => 'Are you sure you want to remove the “{name}” integration?',
    'Authorized' => 'Authorized',
    'Not able to authorize.' => 'Not able to authorize.',
    'Click here to re-authorize' => 'Click here to re-authorize',
    'Checking credentials...' => 'Checking credentials...',
    'API Token' => 'API Token',
    'Enter your API Token here.' => 'Enter your API Token here.',
    'Enter your API specific URL here.' => 'Enter your API specific URL here.',
    'Pipeline' => 'Pipeline',
    'Enter the name or ID of the desired Pipeline.' => 'Enter the name or ID of the desired Pipeline.',
    'Stage' => 'Stage',
    'Enter the name or ID of the desired Stage.' => 'Enter the name or ID of the desired Stage.',
    'Owner (Optional if auto-assign enabled in AC)' => 'Owner (Optional if auto-assign enabled in AC)',
    "Enter the username or ID of the user you wish to assign as the deal owner. If you don't specify an owner, Active Campaign will auto-assign an owner if it is set up." => "Enter the username or ID of the user you wish to assign as the deal owner. If you don't specify an owner, Active Campaign will auto-assign an owner if it is set up.",
    'Enter your Freshdesk API key here.' => 'Enter your Freshdesk API key here.',
    'Domain' => 'Domain',
    "Enter your Freshdesk Domain here, e.g. 'https://example.freshdesk.com'." => "Enter your Freshdesk Domain here, e.g. 'https://example.freshdesk.com'.",
    'Default Type (Optional)' => 'Default Type (Optional)',
    "Set the default Type for tickets, e.g. 'Question'." => "Set the default Type for tickets, e.g. 'Question'.",
    'Default Priority (Optional)' => 'Default Priority (Optional)',
    "Set the default Priority for tickets, e.g. '1' (low)." => "Set the default Priority for tickets, e.g. '1' (low).",
    'Default Status (Optional)' => 'Default Status (Optional)',
    "Set the default Status for tickets, e.g. '2' (open)." => "Set the default Status for tickets, e.g. '2' (open).",
    'Default Source (Optional)' => 'Default Source (Optional)',
    "Set the default Source for tickets, e.g. '1' (email), '2' (portal), etc." => "Set the default Source for tickets, e.g. '1' (email), '2' (portal), etc.",
    'Private App Token' => 'Private App Token',
    'Enter your HubSpot Private App token here.' => 'Enter your HubSpot Private App token here.',
    'IP Address Field' => 'IP Address Field',
    "Enter a custom HubSpot Contact field handle where you wish to store the client's IP address from the submission (optional)." => "Enter a custom HubSpot Contact field handle where you wish to store the client's IP address from the submission (optional).",
    'Append checkbox group field values on Contact update?' => 'Append checkbox group field values on Contact update?',
    'If a Contact already exists in HubSpot, enabling this will append additional checkbox group field values to the Contact inside HubSpot, instead of overwriting the options.' => 'If a Contact already exists in HubSpot, enabling this will append additional checkbox group field values to the Contact inside HubSpot, instead of overwriting the options.',
    'Append checkbox group field values on Company update?' => 'Append checkbox group field values on Company update?',
    'If a Company already exists in HubSpot, enabling this will append additional checkbox group field values to the Company inside HubSpot, instead of overwriting the options.' => 'If a Company already exists in HubSpot, enabling this will append additional checkbox group field values to the Company inside HubSpot, instead of overwriting the options.',
    'OAuth 2.0 Return URI' => 'OAuth 2.0 Return URI',
    'Enter the Client ID of your app in here' => 'Enter the Client ID of your app in here',
    'Client Secret' => 'Client Secret',
    'Enter your Insightly API key here.' => 'Enter your Insightly API key here.',
    'Pardot Business Unit ID' => 'Pardot Business Unit ID',
    'Enter your Pardot business unit ID here' => 'Enter your Pardot business unit ID here',
    'Enter your Pipedrive API token here.' => 'Enter your Pipedrive API token here.',
    'User ID' => 'User ID',
    'Enter the Pipedrive User ID you want to assign to new objects.' => 'Enter the Pipedrive User ID you want to assign to new objects.',
    'Detect Duplicates' => 'Detect Duplicates',
    'Enable this setting to prevent creation of organizations or persons with overlapping names and/or email addresses.' => 'Enable this setting to prevent creation of organizations or persons with overlapping names and/or email addresses.',
    'Stage ID' => 'Stage ID',
    'Enter the Pipedrive Stage ID you want the deal to be placed in.' => 'Enter the Pipedrive Stage ID you want the deal to be placed in.',
    'Enter the Client ID of your Salesforce app in here.' => 'Enter the Client ID of your Salesforce app in here.',
    'Enter the Client Secret of your Salesforce app here.' => 'Enter the Client Secret of your Salesforce app here.',
    'Username' => 'Username',
    'Enter your Salesforce username here.' => 'Enter your Salesforce username here.',
    'Enter your Salesforce password here.' => 'Enter your Salesforce password here.',
    'Assign Lead Owner?' => 'Assign Lead Owner?',
    'Enabling this will make Salesforce assign a lead owner based on lead owner assignment rules.' => 'Enabling this will make Salesforce assign a lead owner based on lead owner assignment rules.',
    'Sandbox Mode' => 'Sandbox Mode',
    'Enable this if your Salesforce account is in Sandbox mode (connects to "test.salesforce.com" instead of "login.salesforce.com").' => 'Enable this if your Salesforce account is in Sandbox mode (connects to "test.salesforce.com" instead of "login.salesforce.com").',
    'Using custom URL?' => 'Using custom URL?',
    "Enable this if you connect to your Salesforce account with a custom company URL (e.g. 'mycompany.my.salesforce.com')." => "Enable this if you connect to your Salesforce account with a custom company URL (e.g. 'mycompany.my.salesforce.com').",
    'Convert Leads to Contact Tasks for Returning Customers?' => 'Convert Leads to Contact Tasks for Returning Customers?',
    'When a Salesforce Contact already exists with the same email address, create a new Task for the Contact instead of a new Lead.' => 'When a Salesforce Contact already exists with the same email address, create a new Task for the Contact instead of a new Lead.',
    'Task Subject' => 'Task Subject',
    "Enter the text you'd like to have set for new Task subjects." => "Enter the text you'd like to have set for new Task subjects.",
    'Task Due Date' => 'Task Due Date',
    "Enter a relative textual date string for the Due Date of the newly created Task (e.g. '2 days')." => "Enter a relative textual date string for the Due Date of the newly created Task (e.g. '2 days').",
    'Close Date' => 'Close Date',
    "Enter a relative textual date string for the Close Date of the newly created Opportunity (e.g. '7 days')." => "Enter a relative textual date string for the Close Date of the newly created Opportunity (e.g. '7 days').",
    'Stage Name' => 'Stage Name',
    "Enter the Stage Name the newly created Opportunity should be assigned to (e.g. 'Prospecting')." => "Enter the Stage Name the newly created Opportunity should be assigned to (e.g. 'Prospecting').",
    'If a Contact already exists in Salesforce, enabling this will append additional checkbox group field values to the Contact inside Salesforce, instead of overwriting the options.' => 'If a Contact already exists in Salesforce, enabling this will append additional checkbox group field values to the Contact inside Salesforce, instead of overwriting the options.',
    'Append checkbox group field values on Account update?' => 'Append checkbox group field values on Account update?',
    'If an Account already exists in Salesforce, enabling this will append additional checkbox group field values to the Account inside Salesforce, instead of overwriting the options.' => 'If an Account already exists in Salesforce, enabling this will append additional checkbox group field values to the Account inside Salesforce, instead of overwriting the options.',
    'Check Contact email address and Account website when checking for duplicates?' => 'Check Contact email address and Account website when checking for duplicates?',
    'By default, Freeform will check against Contact first name, last name and email address, as well as and Account name. If enabled, Freeform will instead check against Contact email address only and Account website. If no website is mapped, Freeform will gather the website domain from the Contact email address mapped.' => 'By default, Freeform will check against Contact first name, last name and email address, as well as and Account name. If enabled, Freeform will instead check against Contact email address only and Account website. If no website is mapped, Freeform will gather the website domain from the Contact email address mapped.',
    'Account ID' => 'Account ID',
    'Enter your Account ID here.' => 'Enter your Account ID here.',
    'Secret Key' => 'Secret Key',
    'Enter your Secret Key here.' => 'Enter your Secret Key here.',

    // Payments Controller
    'Payments' => 'Payments',
    'Payment Gateway' => 'Payment Gateway',
    'Gateway' => 'Gateway',
    'Choose a payment gateway.' => 'Choose a payment gateway.',
    'Choose a payment gateway...' => 'Choose a payment gateway...',
    'Refresh Payment Gateways' => 'Refresh Payment Gateways',
    'Payment Type' => 'Payment Type',
    'Select a payment template' => 'Select a payment template',
    'New Payment Integration' => 'New Payment Integration',
    'Suppress Email Notifications & Integrations when Payments Fail' => 'Suppress Email Notifications & Integrations when Payments Fail',
    'Failed payments will still be stored as submissions, but enabling this will suppress email notifications and API integrations from being sent.' => 'Failed payments will still be stored as submissions, but enabling this will suppress email notifications and API integrations from being sent.',
    'Send Success Email from Stripe to Submitter' => 'Send Success Email from Stripe to Submitter',
    "When enabled, Freeform will pass off the submitter's email address to Stripe's 'receipt_email' field, which will then automatically trigger Stripe sending a success email notification." => "When enabled, Freeform will pass off the submitter's email address to Stripe's 'receipt_email' field, which will then automatically trigger Stripe sending a success email notification.",
    'Public Key (Live)' => 'Public Key (Live)',
    'Enter your Stripe LIVE public key here.' => 'Enter your Stripe LIVE public key here.',
    'Secret Key (Live)' => 'Secret Key (Live)',
    'Enter your Stripe LIVE secret key here.' => 'Enter your Stripe LIVE secret key here.',
    'Public Key (Test)' => 'Public Key (Test)',
    'Enter your Stripe TEST public key here.' => 'Enter your Stripe TEST public key here.',
    'Secret Key (Test)' => 'Secret Key (Test)',
    'Enter your Stripe TEST secret key here.' => 'Enter your Stripe TEST secret key here.',
    'LIVE mode' => 'LIVE mode',
    'Enable this to start using LIVE public and secret keys.' => 'Enable this to start using LIVE public and secret keys.',
    'Webhook Secret' => 'Webhook Secret',
    'Webhook URL' => 'Webhook URL',
    'Use this URL to set up webhooks inside your payment gateway dashboard.' => 'Use this URL to set up webhooks inside your payment gateway dashboard.',

    // Webhook Controller
    'Provider' => 'Provider',
    'New Webhook' => 'New Webhook',
    'Type' => 'Type',
    'Choose the webhook type' => 'Choose the webhook type',
    'Webhook Name' => 'Webhook Name',
    'A name for this webhook' => 'A name for this webhook',
    'Enter the Webhook URL.' => 'Enter the Webhook URL.',
    'Select which forms will trigger this webhook.' => 'Select which forms will trigger this webhook.',
    'Message' => 'Message',
    'Enter the notification message the Slack channel should receive. (Can use {{ submission }} and {{ form }} variables)' => 'Enter the notification message the Slack channel should receive. (Can use {{ submission }} and {{ form }} variables)',

    // Email Marketing Controller
    'New Email Marketing Integration' => 'New Email Marketing Integration',
    'No Email Marketing integrations exist yet' => 'No Email Marketing integrations exist yet',
    'Email Marketing' => 'Email Marketing',
    'Service Provider' => 'Service Provider',
    'Last Updated' => 'Last Updated',
    'Create new mailing list' => 'Create new mailing list',
    'Email Marketing integration with ID {id} not found' => 'Email Marketing integration with ID {id} not found',
    'Email Marketing Integration saved' => 'Email Marketing Integration saved',
    'Email Marketing Integration not saved' => 'Email Marketing Integration not saved',
    "Mailing list with handle '{handle}' not found" => "Mailing list with handle '{handle}' not found",
    'Add a Email Marketing integration' => 'Add a Email Marketing integration',
    'Shop for more Email Marketing integrations on the {link_open}Solspace Freeform Marketplace{link_close}' => 'Shop for more Email Marketing integrations on the {link_open}Solspace Freeform Marketplace{link_close}',
    'API Key' => 'API Key',
    'Enter your Mailchimp API key here.' => 'Enter your Mailchimp API key here.',
    'Use double opt-in?' => 'Use double opt-in?',
    'API User Email' => 'API User Email',
    'Enter your Dotmailer API user email.' => 'Enter your Dotmailer API user email.',
    'Enter your Dotmailer API user password' => 'Enter your Dotmailer API user password',
    'Redirect URI' => 'Redirect URI',
    'You must specify this as the Return URI in your app settings to be able to authorize your credentials. DO NOT CHANGE THIS.' => 'You must specify this as the Return URI in your app settings to be able to authorize your credentials. DO NOT CHANGE THIS.',
    'Enter the API Key of your app in here' => 'Enter the API Key of your app in here',
    'App Secret' => 'App Secret',
    'Enter the Client Secret of your app here' => 'Enter the Client Secret of your app here',
    'Enter your Campaign Monitor API key here.' => 'Enter your Campaign Monitor API key here.',
    'Client ID' => 'Client ID',
    'Enter your Campaign Monitor Client ID here.' => 'Enter your Campaign Monitor Client ID here.',
    'API URL' => 'API URL',
    'Enter your ActiveCampaign API Access URL here.' => 'Enter your ActiveCampaign API Access URL here.',
    'Enter your ActiveCampaign API key here.' => 'Enter your ActiveCampaign API key here.',

    // Layout
    'This field is required' => 'This field is required',
    'Form Builder has no properties' => 'Form Builder has no properties',
    'No form builder data present' => 'No form builder data present',
    'No context specified' => 'No context specified',
    'No properties available' => 'No properties available',
    'No form settings specified' => 'No form settings specified',
    "Field with handle '{handle}' not found" => "Field with handle '{handle}' not found",
    "Field with hash '{hash}' not found" => "Field with hash '{hash}' not found",
    'Layout page {pageIndex} does not contain a row array' => 'Layout page {pageIndex} does not contain a row array',
    'Layout page {pageIndex} row {rowIndex} does not contain its ID' => 'Layout page {pageIndex} row {rowIndex} does not contain its ID',
    'Layout page {pageIndex} row {rowIndex} does not contain a list of columns' => 'Layout page {pageIndex} row {rowIndex} does not contain a list of columns',
    'Could not create a field of type {type}' => 'Could not create a field of type {type}',

    // Fields controller
    'Create Field' => 'Create Field',
    'Fields' => 'Fields',
    'Field saved' => 'Field saved',
    'Field not saved' => 'Field not saved',
    'Field with ID {id} not found' => 'Field with ID {id} not found',
    'Checked?' => 'Checked?',
    'Selected?' => 'Selected?',

    // Forms controller
    'Create a new form' => 'Create a new form',
    'Description' => 'Description',
    'Editing: {title}' => 'Editing: {title}',
    'Forms' => 'Forms',
    'No form ID specified' => 'No form ID specified',
    'No forms found' => 'No forms found',
    'Form with ID {id} not found' => 'Form with ID {id} not found',
    'Are you sure you want to delete this form?' => 'Are you sure you want to delete this form?',
    'All Sections' => 'All Sections',
    'All Category Groups' => 'All Category Groups',
    'All Tag Groups' => 'All Tag Groups',
    'All User Groups' => 'All User Groups',
    'All Assets' => 'All Assets',
    'Filename' => 'Filename',
    'Clone' => 'Clone',
    'Handle' => 'Handle',

    // Notifications Controller
    'Email notifications' => 'Email notifications',
    'Notifications' => 'Notifications',
    'Notification saved' => 'Notification saved',
    'Notification not saved' => 'Notification not saved',
    'Notification with ID {id} not found' => 'Notification with ID {id} not found',
    'Include Attachments?' => 'Include Attachments?',
    'Include uploaded files as attachments in email notification.' => 'Include uploaded files as attachments in email notification.',
    'Create a new email notification template' => 'Create a new email notification template',
    'What this notification template will be called in the CP.' => 'What this notification template will be called in the CP.',
    'How you’ll refer to this notification template in the templates.' => 'How you’ll refer to this notification template in the templates.',
    'Description of this notification.' => 'Description of this notification.',
    'The subject line for the email notification.' => 'The subject line for the email notification.',
    'The email address that the email will appear from in your email notification.' => 'The email address that the email will appear from in your email notification.',
    'The name that the email will appear from in your email notification.' => 'The name that the email will appear from in your email notification.',
    "The reply-to email address for your email notification. Leave blank to use 'From Email' address." => "The reply-to email address for your email notification. Leave blank to use 'From Email' address.",
    'The content of the email notification. See documentation for availability of variables.' => 'The content of the email notification. See documentation for availability of variables.',
    'CC' => 'CC',
    "The email address(es) you would like to be CC'd in the email notification. Separate multiples with commas. Leave blank to not use." => "The email address(es) you would like to be CC'd in the email notification. Separate multiples with commas. Leave blank to not use.",
    'BCC' => 'BCC',
    "The email address(es) you would like to be BCC'd in the email notification. Separate multiples with commas. Leave blank to not use." => "The email address(es) you would like to be BCC'd in the email notification. Separate multiples with commas. Leave blank to not use.",
    'Email Body (HTML)' => 'Email Body (HTML)',
    'Email Body (Text)' => 'Email Body (Text)',
    'The HTML content of the email notification. If you wish to use Text only, leave this empty and fill out the Text body (below). See documentation for availability of variables.' => 'The HTML content of the email notification. If you wish to use Text only, leave this empty and fill out the Text body (below). See documentation for availability of variables.',
    'The text content of the email notification. If you wish to send out both HTML and Text options, fill out both the HTML and Text body fields. See documentation for availability of variables.' => 'The text content of the email notification. If you wish to send out both HTML and Text options, fill out both the HTML and Text body fields. See documentation for availability of variables.',
    'Predefined Assets' => 'Predefined Assets',
    'Select any Assets you wish to include as attachments on all email notifications using this template.' => 'Select any Assets you wish to include as attachments on all email notifications using this template.',
    'What this notification template will be called in the CP.' => 'What this notification template will be called in the CP.',
    'File name of the template without the extension.' => 'File name of the template without the extension.',
    'Subject' => 'Subject',
    'From Email' => 'From Email',
    'From Name' => 'From Name',
    'Reply-to Email' => 'Reply-to Email',
    'Reply-to Name' => 'Reply-to Name',
    "Auto 'Text-Only' version?" => "Auto 'Text-Only' version?",
    'When enabled, Freeform will automatically provide a Text-only version of the notification based on the HTML version.' => 'When enabled, Freeform will automatically provide a Text-only version of the notification based on the HTML version.',
    'New Template' => 'New Template',

    // Settings controller
    'Settings' => 'Settings',
    'Settings Saved' => 'Settings Saved',
    'Settings not saved' => 'Settings not saved',
    'No template name specified' => 'No template name specified',
    'No custom template directory specified in settings' => 'No custom template directory specified in settings',
    "Template '{name}' already exists" => "Template '{name}' already exists",
    'Add a sample template' => 'Add a sample template',
    'Demo Templates' => 'Demo Templates',
    'No demo templates present' => 'No demo templates present',
    'Successfully installed <b>{templates} templates</b> and <b>{assets} assets</b>' => 'Successfully installed <b>{templates} templates</b> and <b>{assets} assets</b>',
    "You can view the templates <a href='{link}'>here</a>" => "You can view the templates <a href='{link}'>here</a>",
    'Install Path' => 'Install Path',
    'Install' => 'Install',
    'Templates' => 'Templates',
    'Assets' => 'Assets',
    'Routes' => 'Routes',
    'Directory Path' => 'Directory Path',
    'Spam Protection' => 'Spam Protection',
    "Enable this to use Freeform's built in Javascript-based honeypot spam protection." => "Enable this to use Freeform's built in Javascript-based honeypot spam protection.",
    'Blocked Spam' => 'Blocked Spam',
    'Default View' => 'Default View',
    'General Settings' => 'General Settings',
    'Control Panel' => 'Control Panel',
    'Custom Plugin Name' => 'Custom Plugin Name',
    'Override the plugin name by specifying your own here.' => 'Override the plugin name by specifying your own here.',
    'Form view' => 'Form view',
    'Submission view' => 'Submission view',
    'Plugin Badge' => 'Plugin Badge',
    "Select the options you'd like to be included in the plugin badge count (when applicable)." => "Select the options you'd like to be included in the plugin badge count (when applicable).",
    "Don't Show" => "Don't Show",
    "Update Notices, What's New, Logged Errors" => "Update Notices, What's New, Logged Errors",
    'Update Notices only' => 'Update Notices only',
    'Logged Errors only' => 'Logged Errors only',
    'Submission Count' => 'Submission Count',
    'Spam Folder Count' => 'Spam Folder Count',
    "Hide 'Install Demo' alert message?" => "Hide 'Install Demo' alert message?",
    'Hides the alert message suggesting to install demo templates when this setting is enabled.' => 'Hides the alert message suggesting to install demo templates when this setting is enabled.',
    'Element Field Type' => 'Element Field Type',
    'Restrict Form options in Form Field Type to User permissions?' => 'Restrict Form options in Form Field Type to User permissions?',
    'Enable this to only show forms the user or group has permissions to manage in the list of options for the Form Element Field Type (relating forms in Entries, etc).' => 'Enable this to only show forms the user or group has permissions to manage in the list of options for the Form Element Field Type (relating forms in Entries, etc).',
    'Submission Data' => 'Submission Data',
    'Enable Search Index Updating on New Submissions?' => 'Enable Search Index Updating on New Submissions?',
    'Enable this to have Craft update search indexes whenever a new submission is created.' => 'Enable this to have Craft update search indexes whenever a new submission is created.',
    'Use Option Labels when Exporting' => 'Use Option Labels when Exporting',
    "Enable this to have fields with options use the submission's option labels instead of values when exporting." => "Enable this to have fields with options use the submission's option labels instead of values when exporting.",
    'Use Field Handles for Headings when Exporting' => 'Use Field Handles for Headings when Exporting',
    'Enable this to use field handles as headings instead of field labels when exporting submissions.' => 'Enable this to use field handles as headings instead of field labels when exporting submissions.',
    'Automatically Purge Submission Data' => 'Automatically Purge Submission Data',
    'If you wish to have Freeform automatically purge submission data after a specified number of days, enable this setting and specify the number of days after submission date it should purge submissions.' => 'If you wish to have Freeform automatically purge submission data after a specified number of days, enable this setting and specify the number of days after submission date it should purge submissions.',
    'Enabling this and saving this settings page will result in purging feature beginning, and cannot be undone (it may not happen immediately, and may take a couple hours before the next process runs).' => 'Enabling this and saving this settings page will result in purging feature beginning, and cannot be undone (it may not happen immediately, and may take a couple hours before the next process runs).',
    'Days After Submission Date to Purge' => 'Days After Submission Date to Purge',
    'Select the number of days after spammy submissions have been submitted for Freeform to begin automatically purging. This process will only run every hour, and only when Freeform is accessed on the front end in templates or in the control panel.' => 'Select the number of days after spammy submissions have been submitted for Freeform to begin automatically purging. This process will only run every hour, and only when Freeform is accessed on the front end in templates or in the control panel.',
    'Please select' => 'Please select',
    '1 day' => '1 day',
    '2 days' => '2 days',
    '3 days' => '3 days',
    '4 days' => '4 days',
    '5 days' => '5 days',
    '6 days' => '6 days',
    '7 days' => '7 days',
    '14 days' => '14 days',
    '30 days' => '30 days',
    '60 days' => '60 days',
    '90 days' => '90 days',
    '120 days' => '120 days',
    '180 days' => '180 days',
    '365 days' => '365 days',
    'Form Behavior' => 'Form Behavior',
    'Automatically Scroll to top of the Form on AJAX submit?' => 'Automatically Scroll to top of the Form on AJAX submit?',
    'Enable this when using AJAX to have Freeform use JS to automatically scroll the top of the form on submit. This is especially beneficial when you have longer forms and success/error messages at the top of the form become out of sight.' => 'Enable this when using AJAX to have Freeform use JS to automatically scroll the top of the form on submit. This is especially beneficial when you have longer forms and success/error messages at the top of the form become out of sight.',
    'Remember the Page Order in Multi-page forms?' => 'Remember the Page Order in Multi-page forms?',
    "When enabled, Freeform will take into account Conditional Rules page skipping when the user clicks the 'Previous' button on multi-page forms." => "When enabled, Freeform will take into account Conditional Rules page skipping when the user clicks the 'Previous' button on multi-page forms.",
    'Freeform Script Insert Type' => 'Freeform Script Insert Type',
    'Specify the way Freeform scripts are inserted.' => 'Specify the way Freeform scripts are inserted.',
    "<b>As Static URLs</b> (recommended) offers built-in browser caching and a static endpoint that delivers the latest Freeform scripts, but are not physical files and therefore cannot have server rules applied. <b>As Files</b> (recommended if having issues with Static URLs) are actual physical files generated inside of the 'cpresources' folder by Craft's asset manager with no caching. <b>Inline</b> will add the scripts as inline scripts and may be useful as a workaround if the other 2 options are not working. This doesn't allow for caching, and pollutes the source code." => "<b>As Static URLs</b> (recommended) offers built-in browser caching and a static endpoint that delivers the latest Freeform scripts, but are not physical files and therefore cannot have server rules applied. <b>As Files</b> (recommended if having issues with Static URLs) are actual physical files generated inside of the 'cpresources' folder by Craft's asset manager with no caching. <b>Inline</b> will add the scripts as inline scripts and may be useful as a workaround if the other 2 options are not working. This doesn't allow for caching, and pollutes the source code.",
    'As Static URLs' => 'As Static URLs',
    'As Files' => 'As Files',
    'Inline' => 'Inline',
    ' (recommended)' => ' (recommended)',
    'Freeform Session Context' => 'Freeform Session Context',
    'Choose the way form context is passed between form submits.' => 'Choose the way form context is passed between form submits.',
    'As an encrypted payload (recommended)' => 'As an encrypted payload (recommended)',
    "Using PHP's sessions" => "Using PHP's sessions",
    'Using a database table' => 'Using a database table',
    'Secret key' => 'Secret key',
    'Specify a secret key to encrypt the form payload with. Will use server key if left empty.' => 'Specify a secret key to encrypt the form payload with. Will use server key if left empty.',
    'Session length in minutes' => 'Session length in minutes',
    'Specify when the sessions should expire. Set to 0 for unlimited.' => 'Specify when the sessions should expire. Set to 0 for unlimited.',
    'Amount of active forms per user' => 'Amount of active forms per user',
    'Specify the amount of active forms a user can have.' => 'Specify the amount of active forms a user can have.',
    'Save & Continue Later' => 'Save & Continue Later',
    'Number of Days to Keep Saved Form Data' => 'Number of Days to Keep Saved Form Data',
    'The number of days to store saved form progress in the database before clearing.' => 'The number of days to store saved form progress in the database before clearing.',
    'Maximum Number of Saved Forms Per Session' => 'Maximum Number of Saved Forms Per Session',
    "The maximum number of saved forms per session (per user, though it's possible a user may have multiple sessions when returning to the site over a span of several days). Default is 10, which should be a comfortable and reasonable number. Once the maximum has been reached, Freeform will begin overwriting existing older entries to create new ones." => "The maximum number of saved forms per session (per user, though it's possible a user may have multiple sessions when returning to the site over a span of several days). Default is 10, which should be a comfortable and reasonable number. Once the maximum has been reached, Freeform will begin overwriting existing older entries to create new ones.",
    'Form Builder' => 'Form Builder',
    'Display Order of Fields in Form Builder' => 'Display Order of Fields in Form Builder',
    'The display order for the list of available fields in the Form Builder.' => 'The display order for the list of available fields in the Form Builder.',
    "Live rendering HTML in HTML blocks, field labels and option labels inside the Form Builder interface can sometimes conflict with Freeform's display of the form preview inside the control panel. In cases like these, you'll need to disable this setting to prevent HTML from rendering automatically." => "Live rendering HTML in HTML blocks, field labels and option labels inside the Form Builder interface can sometimes conflict with Freeform's display of the form preview inside the control panel. In cases like these, you'll need to disable this setting to prevent HTML from rendering automatically.",
    'Allow Twig to be Enabled for each HTML block?' => 'Allow Twig to be Enabled for each HTML block?',
    "When enabled, you'll see a checkbox that lets you allow the inclusion of Twig code inside your HTML block fields inside the form builder." => "When enabled, you'll see a checkbox that lets you allow the inclusion of Twig code inside your HTML block fields inside the form builder.",
    'Render HTML block Twig in isolated mode?' => 'Render HTML block Twig in isolated mode?',
    "When enabled, only the Freeform 'form' and 'fields' variables will be available, the rest of Craft's variables will not be included." => "When enabled, only the Freeform 'form' and 'fields' variables will be available, the rest of Craft's variables will not be included.",
    'Default Formatting Template' => 'Default Formatting Template',
    'The default formatting template for new forms.' => 'The default formatting template for new forms.',
    'Formatting Templates' => 'Formatting Templates',
    'Provide a relative path to the Craft Templates folder where your custom formatting templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your form formatting and allows Freeform to locate these files when assigning to a form.' => 'Provide a relative path to the Craft Templates folder where your custom formatting templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your form formatting and allows Freeform to locate these files when assigning to a form.',
    'Email Templates' => 'Email Templates',
    'File Directory Path' => 'File Directory Path',
    'Template Storage Type' => 'Template Storage Type',
    'Choose whether you want to enable email notification templates stored as files, in the database, or have both options available.' => 'Choose whether you want to enable email notification templates stored as files, in the database, or have both options available.',
    'File' => 'File',
    'Database' => 'Database',
    'File & Database' => 'File & Database',
    'Default Email Template Creation Method' => 'Default Email Template Creation Method',
    "Select which storage method to use when creating new email notifications with 'Add New Template' option in the form builder." => "Select which storage method to use when creating new email notifications with 'Add New Template' option in the form builder.",
    'Allow File-based Email Templates to be created inside the CP?' => 'Allow File-based Email Templates to be created inside the CP?',
    'Allowing users to generate template files from inside the CP can potentially cause issues with certain workflows.' => 'Allowing users to generate template files from inside the CP can potentially cause issues with certain workflows.',
    'Add an email template' => 'Add an email template',
    'Migration Utility' => 'Migration Utility',
    'Convert Database email templates to File email templates' => 'Convert Database email templates to File email templates',
    'This is a utility that allows you to migrate your existing database email templates over to file-based email templates (you can continue to edit these from the CP). The utility will also update all existing forms to use the new file version of the email template. If you wish to have Freeform clean up and remove the old database email templates after, check the checkbox as well.' => 'This is a utility that allows you to migrate your existing database email templates over to file-based email templates (you can continue to edit these from the CP). The utility will also update all existing forms to use the new file version of the email template. If you wish to have Freeform clean up and remove the old database email templates after, check the checkbox as well.',
    'Remove database files after migration?' => 'Remove database files after migration?',
    'Migrate' => 'Migrate',
    'Success Templates' => 'Success Templates',
    'Provide a relative path to the Craft Templates folder where your success templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your success formatting and allows Freeform to locate these files when assigning to a form.' => 'Provide a relative path to the Craft Templates folder where your success templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your success formatting and allows Freeform to locate these files when assigning to a form.',
    'Is Default' => 'Is Default',
    'New Status' => 'New Status',
    'Form Type' => 'Form Type',
    'Form Types' => 'Form Types',
    'Spam Settings' => 'Spam Settings',
    'Honeypot' => 'Honeypot',
    'Freeform Honeypot' => 'Freeform Honeypot',
    "Enable this to use Freeform's built in Honeypot spam protection." => "Enable this to use Freeform's built in Honeypot spam protection.",
    'Custom Honeypot Field Name' => 'Custom Honeypot Field Name',
    'If you wish to change the default name of the Freeform Honeypot field, specify a value here.' => 'If you wish to change the default name of the Freeform Honeypot field, specify a value here.',
    'Custom Honeypot Failed Error Message' => 'Custom Honeypot Failed Error Message',
    "If the form fails the Freeform Honeypot upon submit AND the Spam Protection Behavior setting is set to 'Display Errors', show this error message instead of the default." => "If the form fails the Freeform Honeypot upon submit AND the Spam Protection Behavior setting is set to 'Display Errors', show this error message instead of the default.",
    'Javascript Enhancement' => 'Javascript Enhancement',
    "Enable this to use Freeform's built-in Javascript enhancement for the Honeypot feature. This will require users have JS enabled for their browser and help fight spambots more aggressively." => "Enable this to use Freeform's built-in Javascript enhancement for the Honeypot feature. This will require users have JS enabled for their browser and help fight spambots more aggressively.",
    'If caching your forms, please be sure to manually refresh the Honeypot token generated by Freeform with this feature.' => 'If caching your forms, please be sure to manually refresh the Honeypot token generated by Freeform with this feature.',
    'Spam Protection Behavior' => 'Spam Protection Behavior',
    "Select the behavior you'd like Freeform to take when it detects a submission as being spam." => "Select the behavior you'd like Freeform to take when it detects a submission as being spam.",
    'Simulate Success (recommended)' => 'Simulate Success (recommended)',
    'Display Errors (for debugging)' => 'Display Errors (for debugging)',
    'Bypass All Spam Checks for Logged in Users' => 'Bypass All Spam Checks for Logged in Users',
    'When enabled, Freeform will not run any spam protection measures for logged in users.' => 'When enabled, Freeform will not run any spam protection measures for logged in users.',
    'Spam Folder' => 'Spam Folder',
    'Use Spam Folder' => 'Use Spam Folder',
    'When enabled, all submissions caught by the honeypot or blocked email addresses, keywords and IP addresses will be flagged as spam and stored in the database, but available to manage in a separate menu inside Freeform.' => 'When enabled, all submissions caught by the honeypot or blocked email addresses, keywords and IP addresses will be flagged as spam and stored in the database, but available to manage in a separate menu inside Freeform.',
    'Automatically Purge Spam Submissions' => 'Automatically Purge Spam Submissions',
    'If you wish to have Freeform automatically purge submissions flagged as spam after a specified number of days, enable this setting and specify the number of days after submission date it should purge spammy submissions.' => 'If you wish to have Freeform automatically purge submissions flagged as spam after a specified number of days, enable this setting and specify the number of days after submission date it should purge spammy submissions.',
    'Enabling this and saving this settings page will result in the purging of submissions flagged as spam feature beginning, and cannot be undone (it may not happen immediately, and may take a couple hours before the next process runs).' => 'Enabling this and saving this settings page will result in the purging of submissions flagged as spam feature beginning, and cannot be undone (it may not happen immediately, and may take a couple hours before the next process runs).',
    'Blocking' => 'Blocking',
    'Block Email addresses' => 'Block Email addresses',
    'Enter email addresses you would like blocked from being used in Email fields. Use asterisks for wildcards (e.g. *@hotmail.ru), and separate multiples on new lines.' => 'Enter email addresses you would like blocked from being used in Email fields. Use asterisks for wildcards (e.g. *@hotmail.ru), and separate multiples on new lines.',
    'Display errors about blocked email(s) under each email field?' => 'Display errors about blocked email(s) under each email field?',
    "Enable this if you'd like field-based errors to display under the email field(s) that the user has entered blocked emails for. Not recommended for regular use, but helpful if trying to troubleshoot submission issues." => "Enable this if you'd like field-based errors to display under the email field(s) that the user has entered blocked emails for. Not recommended for regular use, but helpful if trying to troubleshoot submission issues.",
    'Blocked Emails Error Message' => 'Blocked Emails Error Message',
    'The message shown to users when blocked emails are submitted. Can use the {email} variable.' => 'The message shown to users when blocked emails are submitted. Can use the {email} variable.',
    'Block Keywords' => 'Block Keywords',
    'Enter keywords you would like blocked from being used in all text and textarea fields. Use quotes for phrases (e.g. "generate new leads"), asterisks for wildcards (e.g. lead*), and separate multiples on new lines. When attempting to block individual characters (e.g. Russian letters) or partial words or strings, be sure to make good use of the wildcard character by placing one before and after.' => 'Enter keywords you would like blocked from being used in all text and textarea fields. Use quotes for phrases (e.g. "generate new leads"), asterisks for wildcards (e.g. lead*), and separate multiples on new lines. When attempting to block individual characters (e.g. Russian letters) or partial words or strings, be sure to make good use of the wildcard character by placing one before and after.',
    'Display errors about blocked keyword(s) under each text/textarea field?' => 'Display errors about blocked keyword(s) under each text/textarea field?',
    "Enable this if you'd like field-based errors to display under the field(s) that the user has entered blocked keywords for. Not recommended for regular use, but helpful if trying to troubleshoot submission issues." => "Enable this if you'd like field-based errors to display under the field(s) that the user has entered blocked keywords for. Not recommended for regular use, but helpful if trying to troubleshoot submission issues.",
    'Blocked Keywords Error Message' => 'Blocked Keywords Error Message',
    'The message shown to users when blocked keywords are submitted. Can use {value} and {keyword} variables.' => 'The message shown to users when blocked keywords are submitted. Can use {value} and {keyword} variables.',
    'Block IP addresses' => 'Block IP addresses',
    'Enter IP addresses you would like blocked. Separate multiples on new lines.' => 'Enter IP addresses you would like blocked. Separate multiples on new lines.',
    'Throttling' => 'Throttling',
    'Form Submission Throttling' => 'Form Submission Throttling',
    'Globally (affecting all users) prevent spam or attacks by limiting the number of times all forms can be submitted within a given timeframe.' => 'Globally (affecting all users) prevent spam or attacks by limiting the number of times all forms can be submitted within a given timeframe.',
    'per minute' => 'per minute',
    'per second' => 'per second',
    'unlimited' => 'unlimited',
    'Minimum Submit Time' => 'Minimum Submit Time',
    'The minimum amount of time (in seconds) that has to go by since loading the form for the user to be able to submit the form successfully. Otherwise the submission will be flagged as spam and the Spam Protection Behavior setting will take effect.' => 'The minimum amount of time (in seconds) that has to go by since loading the form for the user to be able to submit the form successfully. Otherwise the submission will be flagged as spam and the Spam Protection Behavior setting will take effect.',
    'Form Submit Expiration' => 'Form Submit Expiration',
    'The maximum amount of time (in minutes) a user has to submit the form before the form expires and the Spam Protection Behavior setting will take effect. This still has to be less than the Craft CSRF token expiry and PHP Session limit set for your server.' => 'The maximum amount of time (in minutes) a user has to submit the form before the form expires and the Spam Protection Behavior setting will take effect. This still has to be less than the Craft CSRF token expiry and PHP Session limit set for your server.',
    'Captchas' => 'Captchas',
    'Captcha Settings' => 'Captcha Settings',
    'Use Captchas on Forms?' => 'Use Captchas on Forms?',
    'Enable this to allow the use of reCAPTCHA or hCaptcha on your forms.' => 'Enable this to allow the use of reCAPTCHA or hCaptcha on your forms.',
    'Captcha Type' => 'Captcha Type',
    'Choose which Captcha service and type you want to use.' => 'Choose which Captcha service and type you want to use.',
    'If using reCAPTCHA, please be sure the selection here matches the type on the Google reCAPTCHA site admin console and this site has been added to the approved Domains list.' => 'If using reCAPTCHA, please be sure the selection here matches the type on the Google reCAPTCHA site admin console and this site has been added to the approved Domains list.',
    'Captcha Site Key' => 'Captcha Site Key',
    'Captcha Secret Key' => 'Captcha Secret Key',
    'Behavior & Configuration' => 'Behavior & Configuration',
    'Only load Captcha scripts once the user interacts with the form?' => 'Only load Captcha scripts once the user interacts with the form?',
    "If you'd like to have the associated Captcha scripts load only once a user begins filling out the form, enable this setting. If you'd like your forms to be ready to go at page load, disable this setting." => "If you'd like to have the associated Captcha scripts load only once a user begins filling out the form, enable this setting. If you'd like your forms to be ready to go at page load, disable this setting.",
    'Failure Behavior' => 'Failure Behavior',
    'Display Error' => 'Display Error',
    'Send to Freeform Spam Folder' => 'Send to Freeform Spam Folder',
    'Minimum Score' => 'Minimum Score',
    "Enter the minimum score needed to pass the test. The higher the score, the more aggressive the protection will be. Setting this to '0.0' would allow almost all spam through, while '1.0' could potentially block legitimate users. We recommend a value of '0.5' to '0.7'." => "Enter the minimum score needed to pass the test. The higher the score, the more aggressive the protection will be. Setting this to '0.0' would allow almost all spam through, while '1.0' could potentially block legitimate users. We recommend a value of '0.5' to '0.7'.",
    'Theme' => 'Theme',
    'Dark' => 'Dark',
    'Light' => 'Light',
    'Size' => 'Size',
    'Compact' => 'Compact',
    'Normal' => 'Normal',
    'Integrations' => 'Integrations',
    'Reliability' => 'Reliability',
    'Notices & Alerts' => 'Notices & Alerts',
    'Email Issues' => 'Email Issues',
    'Send Email Alerts for Failed Notifications' => 'Send Email Alerts for Failed Notifications',
    'Send an email notification alerting the email address(es) below when an email notification cannot be delivered.' => 'Send an email notification alerting the email address(es) below when an email notification cannot be delivered.',
    'Digest Emails' => 'Digest Emails',
    'Developer Digest Email' => 'Developer Digest Email',
    "Send weekly or daily emails on the day specified (if using 'Weekly') to the email address(es) below. This will include a snapshot of the previous period's performance and any logged errors and upgrade notices." => "Send weekly or daily emails on the day specified (if using 'Weekly') to the email address(es) below. This will include a snapshot of the previous period's performance and any logged errors and upgrade notices.",
    'Developer Digest Email Frequency' => 'Developer Digest Email Frequency',
    "Specify how often and which days (if applicable) you'd like to receive the email notifications. The chosen date will attempt to send a notification in the morning from the period before that date." => "Specify how often and which days (if applicable) you'd like to receive the email notifications. The chosen date will attempt to send a notification in the morning from the period before that date.",
    'Stats Digest Email' => 'Stats Digest Email',
    "Send weekly or daily emails on the day specified (if using 'Weekly') to the email address(es) below. This is the same as the Developer one above, but only includes a snapshot of the previous period's performance." => "Send weekly or daily emails on the day specified (if using 'Weekly') to the email address(es) below. This is the same as the Developer one above, but only includes a snapshot of the previous period's performance.",
    'Stats Digest Email Frequency' => 'Stats Digest Email Frequency',
    'Send Notifications on Live Environment only?' => 'Send Notifications on Live Environment only?',
    'If this setting is enabled, Freeform will only send out Digest emails when the Craft environment is set to production.' => 'If this setting is enabled, Freeform will only send out Digest emails when the Craft environment is set to production.',
    'Control Panel Notices' => 'Control Panel Notices',
    'Display Update Warnings & Notices' => 'Display Update Warnings & Notices',
    'Freeform will detect if any important updates, notices or warnings are available for this site specifically, and display them on the dashboard. Examples of this might be expiring API integrations and fixes to bugs that likely affect your current site. We respect your privacy, and this information cannot and never will make it to Solspace.com servers. The checks only happen locally here on your site after automatically downloading a generic JSON file from Solspace.com.' => 'Freeform will detect if any important updates, notices or warnings are available for this site specifically, and display them on the dashboard. Examples of this might be expiring API integrations and fixes to bugs that likely affect your current site. We respect your privacy, and this information cannot and never will make it to Solspace.com servers. The checks only happen locally here on your site after automatically downloading a generic JSON file from Solspace.com.',
    'Additional Optional Checks' => 'Additional Optional Checks',
    "Help us provide you with more tailored warnings and notices by selecting any of the options below that may affect your site. Freeform's update notices check cannot detect template-level things or flows, so by selecting options below, Freeform will know to check against these as well and provide you with more robust warnings and alerts. We respect your privacy, and this information cannot and never will make it to Solspace.com servers. The checks only happen locally here on your site after automatically downloading a generic JSON file from Solspace.com." => "Help us provide you with more tailored warnings and notices by selecting any of the options below that may affect your site. Freeform's update notices check cannot detect template-level things or flows, so by selecting options below, Freeform will know to check against these as well and provide you with more robust warnings and alerts. We respect your privacy, and this information cannot and never will make it to Solspace.com servers. The checks only happen locally here on your site after automatically downloading a generic JSON file from Solspace.com.",
    'Site uses a JS framework (Vue.js, React.js, etc.)' => 'Site uses a JS framework (Vue.js, React.js, etc.)',
    'Caching on at least some forms' => 'Caching on at least some forms',
    'Custom module or plugin for Freeform' => 'Custom module or plugin for Freeform',
    'Alert me on any GDPR-related improvements or fixes' => 'Alert me on any GDPR-related improvements or fixes',
    'Make use of Editing submissions on front-end' => 'Make use of Editing submissions on front-end',
    'Display submission data on front-end' => 'Display submission data on front-end',
    'Site uses GraphQL' => 'Site uses GraphQL',
    'Sorry, we cannot accept your submission at this time. Not enough time has passed before submitting the form.' => 'Sorry, we cannot accept your submission at this time. Not enough time has passed before submitting the form.',
    'Sorry, we cannot accept your submission at this time. Too much time has passed before submitting the form.' => 'Sorry, we cannot accept your submission at this time. Too much time has passed before submitting the form.',
    'There was an error processing your submission. Please try again later.' => 'There was an error processing your submission. Please try again later.',
    'Default Email Notification Creation Method' => 'Default Email Notification Creation Method',
    'The default page to go to when clicking the Freeform nav item.' => 'The default page to go to when clicking the Freeform nav item.',
    'Provide a relative path to the Craft Templates folder where your email templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your email formatting and allows Freeform to locate these files when setting up notifications.' => 'Provide a relative path to the Craft Templates folder where your email templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your email formatting and allows Freeform to locate these files when setting up notifications.',
    "Which storage method to use when creating new email notifications with 'Add New Notification' option in the Form Builder." => "Which storage method to use when creating new email notifications with 'Add New Notification' option in the Form Builder.",
    'The display order for the list of available fields in the Form Builder.' => 'The display order for the list of available fields in the Form Builder.',
    'Show Form Builder Tutorial' => 'Show Form Builder Tutorial',
    'Enable this to show the interactive tutorial again in the Form Builder. This setting disables again when the tutorial is completed or skipped.' => 'Enable this to show the interactive tutorial again in the Form Builder. This setting disables again when the tutorial is completed or skipped.',
    'Render HTML inside Form Builder & Submissions view?' => 'Render HTML inside Form Builder & Submissions view?',
    'AJAX Enabled for Forms by Default' => 'AJAX Enabled for Forms by Default',
    'By default, the "Enable AJAX" feature checkbox will be checked for new forms.' => 'By default, the "Enable AJAX" feature checkbox will be checked for new forms.',
    'Include Default Freeform Formatting Templates' => 'Include Default Freeform Formatting Templates',
    'Disable this to hide the default Freeform formatting templates in the Formatting Template options list inside Form Builder.' => 'Disable this to hide the default Freeform formatting templates in the Formatting Template options list inside Form Builder.',
    'Remove Newlines from Textareas for Exporting' => 'Remove Newlines from Textareas for Exporting',
    'Enable this to have newlines removed from Textarea fields in submissions when exporting.' => 'Enable this to have newlines removed from Textarea fields in submissions when exporting.',
    'Fill Form Values from the GET Query String?' => 'Fill Form Values from the GET Query String?',
    'Enable this to be able to fill form field values from a GET query string in URI.' => 'Enable this to be able to fill form field values from a GET query string in URI.',
    'Disable Submit Button on Form Submit?' => 'Disable Submit Button on Form Submit?',
    'Enable this to automatically disable the form\'s submit button when the form is submitted. This will prevent the form from double-submitting.' => 'Enable this to automatically disable the form\'s submit button when the form is submitted. This will prevent the form from double-submitting.',
    'Automatically Scroll to Form on Errors and Multipage forms?' => 'Automatically Scroll to Form on Errors and Multipage forms?',
    'Enable this to have Freeform use JS to automatically scroll the page down to the form upon submit when there are errors or the form is continuing to the next page in multipage forms.' => 'Enable this to have Freeform use JS to automatically scroll the page down to the form upon submit when there are errors or the form is continuing to the next page in multipage forms.',
    'Freeform Javascript Insertion Location' => 'Freeform Javascript Insertion Location',
    'The location of where you want Freeform to insert its scripts for form and field functionality.' => 'The location of where you want Freeform to insert its scripts for form and field functionality.',
    'Page Footer' => 'Page Footer',
    'Inside Form' => 'Inside Form',
    'None (add manually)' => 'None (add manually)',

    // Statuses controller
    'Create a new status' => 'Create a new status',
    'The name of the status.' => 'The name of the status.',
    'How you’ll refer to this status in the templates.' => 'How you’ll refer to this status in the templates.',
    'The color of the status circle when viewing inside CP.' => 'The color of the status circle when viewing inside CP.',
    'Set this status to be selected by default when creating new forms?' => 'Set this status to be selected by default when creating new forms?',
    'Status' => 'Status',
    'Statuses' => 'Statuses',
    'Status saved' => 'Status saved',
    'Status not saved' => 'Status not saved',
    'Status with ID {id} not found' => 'Status with ID {id} not found',
    'green' => 'green',
    'orange' => 'orange',
    'red' => 'red',
    'blue' => 'blue',
    'yellow' => 'yellow',
    'pink' => 'pink',
    'purple' => 'purple',
    'turquoise' => 'turquoise',
    'light' => 'light',
    'grey' => 'grey',
    'black' => 'black',

    // Submissions controller
    'Submission Date' => 'Submission Date',
    'Submission updated' => 'Submission updated',
    'Submission could not be updated' => 'Submission could not be updated',
    'Submission with ID {id} not found' => 'Submission with ID {id} not found',
    'Submissions deleted successfully.' => 'Submissions deleted successfully.',
    'Notes about your changes' => 'Notes about your changes',

    // Element type
    'Title' => 'Title',
    'Form' => 'Form',
    'All Submissions' => 'All Submissions',
    'Submission date' => 'Submission date',
    'Freeform Submissions' => 'Freeform Submissions',
    'Add a submission' => 'Add a submission',
    'Submissions deleted' => 'Submissions deleted',
    'Are you sure you want to delete these submissions?' => 'Are you sure you want to delete these submissions?',
    'Are you sure you want to delete this?' => 'Are you sure you want to delete this?',

    // Properties
    "Properties for key '{key}' is not an array" => "Properties for key '{key}' is not an array",
    "Properties for key '{key}' do not contain TYPE" => "Properties for key '{key}' do not contain TYPE",
    "Could not find properties for key '{hash}'" => "Could not find properties for key '{hash}'",
    "Could not find properties for page '{index}'" => "Could not find properties for page '{index}'",
    "Could not find properties for field '{hash}'" => "Could not find properties for field '{hash}'",
    'Could not find properties for form' => 'Could not find properties for form',
    'Could not find properties for integrations' => 'Could not find properties for integrations',
    "Value for '{key}' should be '{valueType}' but is '{expectedType}'" => "Value for '{key}' should be '{valueType}' but is '{expectedType}'",

    // Form
    'Trying to post an invalid form' => 'Trying to post an invalid form',
    "The provided page index '{pageIndex}' does not exist in form '{formName}'" => "The provided page index '{pageIndex}' does not exist in form '{formName}'",

    // Integrations
    '{setting} setting not specified' => '{setting} setting not specified',
    'Could not connect to API endpoint' => 'Could not connect to API endpoint',
    'Could not add emails to lists' => 'Could not add emails to lists',
    'Could not fetch {serviceProvider} lists' => 'Could not fetch {serviceProvider} lists',
    'Unknown integration type specified' => 'Unknown integration type specified',
    'Could not find setting blueprints for {handle}' => 'Could not find setting blueprints for {handle}',
    "No 'access_token' present in auth response for {serviceProvider}" => "No 'access_token' present in auth response for {serviceProvider}",
    "'{key}' key missing in Freeform's plugin configuration" => "'{key}' key missing in Freeform's plugin configuration",

    // Settings model
    "Directory '{directory}' does not exist" => "Directory '{directory}' does not exist",
    'Could not get demo template content. Please contact Solspace.' => 'Could not get demo template content. Please contact Solspace.',

    // Submission record
    '{attribute} cannot be blank' => '{attribute} cannot be blank',

    // CRM service
    'CRM Integration with ID {id} not found' => 'CRM Integration with ID {id} not found',
    "No field mapping specified for '{integration}' integration" => "No field mapping specified for '{integration}' integration",

    // Files service
    'Could not handle file upload' => 'Could not handle file upload',

    // Form service
    "Can't use render() if no form template specified" => "Can't use render() if no form template specified",
    "Form template '{name}' not found" => "Form template '{name}' not found",

    // Mailer service
    'Email notification template with ID {id} not found' => 'Email notification template with ID {id} not found',

    // Mailingliisten service
    'Email Marketing integration with ID {id} not found' => 'Email Marketing integration with ID {id} not found',

    // Text field
    'The allowed maximum length is {{max}} characters. Current size is {{difference}} characters too long.' => 'The allowed maximum length is {{max}} characters. Current size is {{difference}} characters too long.',

    // reCAPTCHA field
    'Please verify that you are not a robot.' => 'Please verify that you are not a robot.',

    // Confirm field
    'This value must match the value for {targetFieldLabel}' => 'This value must match the value for {targetFieldLabel}',

    // Email field
    '{email} is not a valid email address' => '{email} is not a valid email address',

    // Date field
    '"{value}" does not conform to "{format}" format.' => '"{value}" does not conform to "{format}" format.',
    'Date "{date}" must be after "{minDate}"' => 'Date "{date}" must be after "{minDate}"',
    'Date "{date}" must be before "{maxDate}"' => 'Date "{date}" must be before "{maxDate}"',
    'Min Date' => 'Min Date',
    'Max Date' => 'Max Date',
    'Specify a relative textual date string or static date for the earliest date available for date picker and field validation.' => 'Specify a relative textual date string or static date for the earliest date available for date picker and field validation.',
    'Specify a relative textual date string or static date for the latest date available for date picker and field validation.' => 'Specify a relative textual date string or static date for the latest date available for date picker and field validation.',

    // Phone field
    'Invalid phone number' => 'Invalid phone number',
    'Phone number is invalid.' => 'Phone number is invalid.',

    // Rating field
    'Rating must be between {{min}} and {{max}}' => 'Rating must be between {{min}} and {{max}}',

    // Website field
    'Website not valid' => 'Website not valid',

    // File Upload field
    "'{extension}' is not an allowed file extension" => "'{extension}' is not an allowed file extension",
    'You tried uploading {fileSize}KB, but the maximum file upload size is {maxFileSize}KB' => 'You tried uploading {fileSize}KB, but the maximum file upload size is {maxFileSize}KB',
    'Tried uploading {count} files. Maximum {max} files allowed.' => 'Tried uploading {count} files. Maximum {max} files allowed.',
    'Could not upload file' => 'Could not upload file',
    'The file was only partially uploaded' => 'The file was only partially uploaded',
    'File size too large' => 'File size too large',

    // File Upload Drag and Drop field
    'Maximum file upload limit of {limit} reached' => 'Maximum file upload limit of {limit} reached',
    'Maximum file upload size is {maxFileSize}KB' => 'Maximum file upload size is {maxFileSize}KB',
    'Upload in progress...' => 'Upload in progress...',
    'Upload complete!' => 'Upload complete!',
    'Multiple field uploads not supported' => 'Multiple field uploads not supported',
    'Unknown file type' => 'Unknown file type',

    // Number field
    'Value must be numeric' => 'Value must be numeric',
    'The value must be no more than {{max}}' => 'The value must be no more than {{max}}',
    'The value must be no less than {{min}}' => 'The value must be no less than {{min}}',
    'The value must be between {{min}} and {{max}}' => 'The value must be between {{min}} and {{max}}',
    '{{dec}} decimal places allowed' => '{{dec}} decimal places allowed',
    'Only positive numbers allowed' => 'Only positive numbers allowed',
    'The value must be no more than {{max}} characters' => 'The value must be no more than {{max}} characters',
    'The value must be no less than {{min}} characters' => 'The value must be no less than {{min}} characters',
    'The value must be between {{min}} and {{max}} characters' => 'The value must be between {{min}} and {{max}} characters',

    // Fields
    'Create a new field' => 'Create a new field',
    'Default instructions / help text for this field.' => 'Default instructions / help text for this field.',
    'Set this field as required by default.' => 'Set this field as required by default.',
    'What type of field is this?' => 'What type of field is this?',
    'How you’ll refer to this field in the templates.' => 'How you’ll refer to this field in the templates.',
    'The default label for this field.' => 'The default label for this field.',
    'Options' => 'Options',
    'Options for this field. Option values should be unique.' => 'Options for this field. Option values should be unique.',
    'Add an option' => 'Add an option',
    'Custom values' => 'Custom values',
    'Define the default available options.' => 'Define the default available options.',
    'Enable this to check the checkbox by default.' => 'Enable this to check the checkbox by default.',
    'Enable this to specify custom values for each option label.' => 'Enable this to specify custom values for each option label.',
    'Dynamic Recipients' => 'Dynamic Recipients',
    'Define the default available email address options.' => 'Define the default available email address options.',
    'Placeholder' => 'Placeholder',
    'Field placeholder' => 'Field placeholder',
    'The default text that will be shown if the field doesn’t have a value.' => 'The default text that will be shown if the field doesn’t have a value.',
    'Asset Source' => 'Asset Source',
    'Select a default asset source for uploaded files.' => 'Select a default asset source for uploaded files.',
    'Upload Location Subfolder' => 'Upload Location Subfolder',
    'The subfolder path that files should be uploaded to. May contain {{ form.handle }} or {{ form.id }} variables as well.' => 'The subfolder path that files should be uploaded to. May contain {{ form.handle }} or {{ form.id }} variables as well.',
    'Specify the maximum uploadable file count.' => 'Specify the maximum uploadable file count.',
    'Default Value' => 'Default Value',
    'The default value for the field.' => 'The default value for the field.',
    'Rows' => 'Rows',
    'The default number of rows this textarea should have.' => 'The default number of rows this textarea should have.',
    'Maximum File Size' => 'Maximum File Size',
    'Specify the maximum file size, in KB.' => 'Specify the maximum file size, in KB.',
    'Specify the default maximum file size, in KB.' => 'Specify the default maximum file size, in KB.',
    'Allowed File Types' => 'Allowed File Types',
    'Leave everything unchecked to allow all file kinds.' => 'Leave everything unchecked to allow all file kinds.',
    'Select the file types to be allowed by default. Leaving all unchecked will allow all file types.' => 'Select the file types to be allowed by default. Leaving all unchecked will allow all file types.',
    'The handle "{handle}" is a reserved keyword and cannot be used.' => 'The handle "{handle}" is a reserved keyword and cannot be used.',
    'While data is passed along to the Email Marketing provider, Freeform does not store whether or not Email Marketing fields were opted in.' => 'While data is passed along to the Email Marketing provider, Freeform does not store whether or not Email Marketing fields were opted in.',
    'New Field' => 'New Field',
    'Required' => 'Required',
    'Read only' => 'Read only',

    // Form Builder
    'No Value set' => 'No Value set',
    'No Target Field' => 'No Target Field',
    'No Template' => 'No Template',
    'No Asset Source' => 'No Asset Source',
    'Hidden field' => 'Hidden field',
    'Handle is not set' => 'Handle is not set',
    'Handle is a reserved keyword' => 'Handle is a reserved keyword',
    '"${resourceName}" list for ${name}' => '"${resourceName}" list for ${name}',
    'No mailing list for ${name}' => 'No mailing list for ${name}',
    'No email field' => 'No email field',
    'Field type "${type}" not found' => 'Field type "${type}" not found',
    'Are you sure you want to remove this page and all fields on it?' => 'Are you sure you want to remove this page and all fields on it?',
    'Add New Field' => 'Add New Field',
    'Type' => 'Type',
    'Label' => 'Label',
    'Label (Optional)' => 'Label (Optional)',
    'Field label used to describe the field.' => 'Field label used to describe the field.',
    'The value for this field.' => 'The value for this field.',
    'Instructions' => 'Instructions',
    'Field specific user instructions.' => 'Field specific user instructions.',
    'If present, this will be the value pre-populated when the form is rendered.' => 'If present, this will be the value pre-populated when the form is rendered.',
    'The text that will be shown if the field doesn’t have a value.' => 'The text that will be shown if the field doesn’t have a value.',
    'Target Field' => 'Target Field',
    'The target Freeform field to be confirmed by re-entering its value.' => 'The target Freeform field to be confirmed by re-entering its value.',
    'Date Time Type' => 'Date Time Type',
    'Choose between using date, time or both.' => 'Choose between using date, time or both.',
    "Use Freeform's built-in automatic AJAX submit feature. This will prevent the value in the Return URL field from working unless a template-level override is set." => "Use Freeform's built-in automatic AJAX submit feature. This will prevent the value in the Return URL field from working unless a template-level override is set.",
    'Conditional Rules' => 'Conditional Rules',
    'Show field handles?' => 'Show field handles?',
    'Enable this to also show the field handle for all fields for better clarity if you have several fields with the same label.' => 'Enable this to also show the field handle for all fields for better clarity if you have several fields with the same label.',
    'Both' => 'Both',
    'Time' => 'Time',
    "You can use 'now', 'today', '5 days ago', '2017-01-01 20:00:00', etc, which will format the default value according to the chosen format." => "You can use 'now', 'today', '5 days ago', '2017-01-01 20:00:00', etc, which will format the default value according to the chosen format.",
    'Use the Freeform datepicker for this field?' => 'Use the Freeform datepicker for this field?',
    'Generate placeholder from your date format settings?' => 'Generate placeholder from your date format settings?',
    'Date Order' => 'Date Order',
    'Choose the order in which to show day, month and year.' => 'Choose the order in which to show day, month and year.',
    'year month day' => 'year month day',
    'month day year' => 'month day year',
    'day month year' => 'day month year',
    'Four digit year?' => 'Four digit year?',
    'Date leading zero' => 'Date leading zero',
    'If enabled, a leading zero will be used for days and months.' => 'If enabled, a leading zero will be used for days and months.',
    'Date Separator' => 'Date Separator',
    'Used to separate date values.' => 'Used to separate date values.',
    'None' => 'None',
    '24h Clock?' => '24h Clock?',
    'Clock Separator' => 'Clock Separator',
    'Used to separate hours and minutes.' => 'Used to separate hours and minutes.',
    'Lowercase AM/PM?' => 'Lowercase AM/PM?',
    'Separate AM/PM with a space?' => 'Separate AM/PM with a space?',
    'Email Template' => 'Email Template',
    'Legends' => 'Legends',
    'Legend' => 'Legend',
    'Render as' => 'Render as',
    'Select' => 'Select',
    'Radios' => 'Radios',
    'Checkboxes' => 'Checkboxes',
    'Options for this checkbox group' => 'Options for this checkbox group',
    'Select an asset source to be able to store user uploaded files.' => 'Select an asset source to be able to store user uploaded files.',
    'Select an Asset Source...' => 'Select an Asset Source...',
    'File Count' => 'File Count',
    'Specify the maximum uploadable file count.' => 'Specify the maximum uploadable file count.',
    'Maximum File Size' => 'Maximum File Size',
    'Specify the maximum file size, in KB.' => 'Specify the maximum file size, in KB.',
    'Allowed File Kinds' => 'Allowed File Kinds',
    'Leave everything unchecked to allow all file kinds.' => 'Leave everything unchecked to allow all file kinds.',
    'Name or title of the form.' => 'Name or title of the form.',
    'How you’ll refer to this form in the templates.' => 'How you’ll refer to this form in the templates.',
    'Submission Title' => 'Submission Title',
    'What the auto-generated submission titles should look like.' => 'What the auto-generated submission titles should look like.',
    'Return URL' => 'Return URL',
    'The URL the form will redirect to after successful submit. This will not work when the Built-in AJAX setting is enabled unless a template-level override is set.' => 'The URL the form will redirect to after successful submit. This will not work when the Built-in AJAX setting is enabled unless a template-level override is set.',
    'Default Status' => 'Default Status',
    'The default status to be assigned to new submissions.' => 'The default status to be assigned to new submissions.',
    'Formatting Template' => 'Formatting Template',
    'The formatting template to assign to this form when using Render method (optional).' => 'The formatting template to assign to this form when using Render method (optional).',
    'Collect IP Addresses' => 'Collect IP Addresses',
    'Should this form collect the user\'s IP address?' => 'Should this form collect the user\'s IP address?',
    'Store Submitted Data' => 'Store Submitted Data',
    'Should the submission data for this form be stored in the database?' => 'Should the submission data for this form be stored in the database?',
    'Opt-In Data Storage Checkbox' => 'Opt-In Data Storage Checkbox',
    'Allow users to decide whether the submission data is saved to your site or not.' => 'Allow users to decide whether the submission data is saved to your site or not.',
    'Enable Google Tag Manager to push successful form submission events to the Data Layer' => 'Enable Google Tag Manager to push successful form submission events to the Data Layer',
    'Form tag Attributes' => 'Form tag Attributes',
    'Add any tag attributes to the HTML element.' => 'Add any tag attributes to the HTML element.',
    'Show Loading Indicator on Submit' => 'Show Loading Indicator on Submit',
    'Show a loading indicator on the submit button upon submittal of the form.' => 'Show a loading indicator on the submit button upon submittal of the form.',
    'Show Loading Text' => 'Show Loading Text',
    "Enabling this will change the submit button's label to the text of your choice." => "Enabling this will change the submit button's label to the text of your choice.",
    'Loading Text' => 'Loading Text',
    'Attribute' => 'Attribute',
    'Disabled' => 'Disabled',
    'Limit Form Submission Rate' => 'Limit Form Submission Rate',
    'Limit the number of times a user can submit the form.' => 'Limit the number of times a user can submit the form.',
    'Do not limit' => 'Do not limit',
    'Logged in Users only (no limit)' => 'Logged in Users only (no limit)',
    'Once per Cookie only' => 'Once per Cookie only',
    'Once per IP/Cookie combo' => 'Once per IP/Cookie combo',
    'Once per logged in Users only' => 'Once per logged in Users only',
    'Once per logged in User or Guest Cookie only' => 'Once per logged in User or Guest Cookie only',
    'Once per logged in User or Guest IP/Cookie combo' => 'Once per logged in User or Guest IP/Cookie combo',
    'Stop Submissions After' => 'Stop Submissions After',
    'Set a date after which the form will no longer accept submissions.' => 'Set a date after which the form will no longer accept submissions.',
    'Form Color' => 'Form Color',
    'Used for Widget Charts' => 'Used for Widget Charts',
    'Description / Notes' => 'Description / Notes',
    'Description or notes for this form.' => 'Description or notes for this form.',
    'Hash' => 'Hash',
    'Used to access this field on the frontend.' => 'Used to access this field on the frontend.',
    'Field Mapping' => 'Field Mapping',
    'Map CRM fields to your Freeform fields.' => 'Map CRM fields to your Freeform fields.',
    'Map Email Marketing fields to your Freeform fields.' => 'Map Email Marketing fields to your Freeform fields.',
    'Form Fields' => 'Form Fields',
    'Integration' => 'Integration',
    'Choose an integration type' => 'Choose an integration type',
    'Choose an integration...' => 'Choose an integration...',
    'Refreshing...' => 'Refreshing...',
    'Refresh Integration' => 'Refresh Integration',
    'Choose the opt-in mailing list that users will be added to.' => 'Choose the opt-in mailing list that users will be added to.',
    'Select a list...' => 'Select a list...',
    'Target Email Field' => 'Target Email Field',
    'The email field used to push to the mailing list.' => 'The email field used to push to the mailing list.',
    'Select a field...' => 'Select a field...',
    'Decimal Separator' => 'Decimal Separator',
    'Used to separate decimals.' => 'Used to separate decimals.',
    'Allow negative numbers?' => 'Allow negative numbers?',
    'Min/Max Values' => 'Min/Max Values',
    'The minimum and/or maximum numeric value this field is allowed to have (optional).' => 'The minimum and/or maximum numeric value this field is allowed to have (optional).',
    'Min/Max Length' => 'Min/Max Length',
    'The minimum and/or maximum character length this field is allowed to have (optional).' => 'The minimum and/or maximum character length this field is allowed to have (optional).',
    'Step' => 'Step',
    'The step' => 'The step',
    'Decimal Count' => 'Decimal Count',
    'The number of decimal places allowed.' => 'The number of decimal places allowed.',
    'Leave blank for no decimals.' => 'Leave blank for no decimals.',
    'Thousands Separator' => 'Thousands Separator',
    'Used to separate thousands.' => 'Used to separate thousands.',
    'Label for this page tab.' => 'Label for this page tab.',
    'Use JS validation' => 'Use JS validation',
    'Enable this to force JS to validate the input on this field based on the pattern.' => 'Enable this to force JS to validate the input on this field based on the pattern.',
    'Pattern' => 'Pattern',
    "Custom phone pattern (e.g. '(000) 000-0000' or '+0 0000 000000'), where '0' stands for a digit between 0-9. If left blank, any number and dash, dot, space, parentheses and optional + at the beginning will be validated." => "Custom phone pattern (e.g. '(000) 000-0000' or '+0 0000 000000'), where '0' stands for a digit between 0-9. If left blank, any number and dash, dot, space, parentheses and optional + at the beginning will be validated.",

    'Optional' => 'Optional',
    'Maximum Number of Stars' => 'Maximum Number of Stars',
    'Set how many stars there should be for this rating.' => 'Set how many stars there should be for this rating.',
    'Unselected Color' => 'Unselected Color',
    'Hover Color' => 'Hover Color',
    'Selected Color' => 'Selected Color',
    'Enter any regex pattern here.' => 'Enter any regex pattern here.',
    'e.g. /^[a-zA-Z0-9]*$/' => 'e.g. /^[a-zA-Z0-9]*$/',
    'Error Message' => 'Error Message',
    'The message a user should receive if an incorrect value is given. It will replace any occurrences of \'{{pattern}}\' with the supplied regex pattern inside the message if any are found.' => 'The message a user should receive if an incorrect value is given. It will replace any occurrences of \'{{pattern}}\' with the supplied regex pattern inside the message if any are found.',
    'Value is not valid' => 'Value is not valid',
    'Submit button Label' => 'Submit button Label',
    'The label of the submit button' => 'The label of the submit button',
    'Disable the Previous button' => 'Disable the Previous button',
    'Previous button Label' => 'Previous button Label',
    'The label of the previous button' => 'The label of the previous button',
    'Maximum Length' => 'Maximum Length',
    'The maximum number of characters for this field.' => 'The maximum number of characters for this field.',
    'The number of rows in height for this field.' => 'The number of rows in height for this field.',
    'Hide field' => 'Hide field',
    'Hide the mailing list checkbox from the form and make it always trigger a subscription' => 'Hide the mailing list checkbox from the form and make it always trigger a subscription',
    'Mailing Lists' => 'Mailing Lists',
    'Map Mailing List fields to your Freeform fields.' => 'Map Mailing List fields to your Freeform fields.',
    'Default' => 'Default',
    'Live HTML rendering currently disabled.' => 'Live HTML rendering currently disabled.',
    'Quick save' => 'Quick save',
    'Saving...' => 'Saving...',
    'Cancel' => 'Cancel',
    'Save and finish' => 'Save and finish',
    'Save as a new form' => 'Save as a new form',
    'Saved successfully' => 'Saved successfully',
    'Name must not be empty' => 'Name must not be empty',
    'Label must not be empty' => 'Label must not be empty',
    'Handle must not be empty' => 'Handle must not be empty',
    'Field type must not be empty' => 'Field type must not be empty',
    'Field added successfully' => 'Field added successfully',
    'Special Fields' => 'Special Fields',
    'Craft Field' => 'Craft Field',
    'Freeform Field' => 'Freeform Field',
    'Field mapping' => 'Field mapping',
    'Activate users?' => 'Activate users?',
    'The user will be activated upon creation if this is checked. Will be set to pending otherwise.' => 'The user will be activated upon creation if this is checked. Will be set to pending otherwise.',
    'Disable entries?' => 'Disable entries?',
    'The entry will be set to disabled upon creation if this is checked. Will be set to enabled otherwise.' => 'The entry will be set to disabled upon creation if this is checked. Will be set to enabled otherwise.',
    'CRM Field' => 'CRM Field',
    'FF Field' => 'FF Field',
    'Use custom values' => 'Use custom values',
    "Select the Email field that will contain the user's email address in order to send the email notification. Good practice would be to have the email field on the first page of the form." => "Select the Email field that will contain the user's email address in order to send the email notification. Good practice would be to have the email field on the first page of the form.",
    'Select an email field...' => 'Select an email field...',
    'Positioning' => 'Positioning',
    'Choose how the previous and submit buttons should be placed.' => 'Choose how the previous and submit buttons should be placed.',
    'Left' => 'Left',
    'Center' => 'Center',
    'Right' => 'Right',
    'Apart at Left and Right' => 'Apart at Left and Right',
    'Together at Left' => 'Together at Left',
    'Together at Center' => 'Together at Center',
    'Together at Right' => 'Together at Right',
    'Choose whether the submit button is positioned on the left, center or right side.' => 'Choose whether the submit button is positioned on the left, center or right side.',
    'Save button Label' => 'Save button Label',
    'The label of the Save & Continue Later button.' => 'The label of the Save & Continue Later button.',
    'The URL the user will be redirected to after saving. Can use {token} and {key}.' => 'The URL the user will be redirected to after saving. Can use {token} and {key}.',
    'Add new template' => 'Add new template',
    'Form Settings' => 'Form Settings',
    'Admin Notifications' => 'Admin Notifications',
    'CRM Integrations' => 'CRM Integrations',
    'CRM Integration' => 'CRM Integration',
    'Element Connections' => 'Element Connections',
    'Add a connection' => 'Add a connection',
    'Section' => 'Section',
    'Select a section' => 'Select a section',
    'Entry Type' => 'Entry Type',
    'Select an entry type' => 'Select an entry type',
    'User Group' => 'User Group',
    'Validation' => 'Validation',

    'Payment Field Mapping' => 'Payment Field Mapping',
    'Amount' => 'Amount',
    'Interval' => 'Interval',
    'Daily' => 'Daily',
    'Weekly' => 'Weekly',
    'Biweekly' => 'Biweekly',
    'Monthly' => 'Monthly',
    'Annually' => 'Annually',
    'Currency' => 'Currency',
    'Fixed (see below)' => 'Fixed (see below)',
    'Fixed Amount' => 'Fixed Amount',
    'Fixed payment amount.' => 'Fixed payment amount.',
    'Fixed Currency' => 'Fixed Currency',
    'Payment currency.' => 'Payment currency.',
    'Payment Description' => 'Payment Description',
    'Enter a custom payment description' => 'Enter a custom payment description',
    'Payment Succeeded Email' => 'Payment Succeeded Email',
    'Payment Failed Email' => 'Payment Failed Email',
    'Subscription Created Email' => 'Subscription Created Email',
    'Subscription Ended Email' => 'Subscription Ended Email',
    'Fixed Subscription Plan' => 'Fixed Subscription Plan',
    'Select an existing subscription plan' => 'Select an existing subscription plan',
    'Choose a subscription plan...' => 'Choose a subscription plan...',
    'Plan' => 'Plan',
    'Refresh plans' => 'Refresh plans',
    'Add new plan' => 'Add new plan',
    'Fixed Interval' => 'Fixed Interval',
    'The frequency with which a subscription should be billed.' => 'The frequency with which a subscription should be billed.',

    'Notification added successfully' => 'Notification added successfully',
    'Template added successfully' => 'Template added successfully',
    'Template Name' => 'Template Name',
    'File Name' => 'File Name',

    'Custom Options' => 'Custom Options',
    'Entries' => 'Entries',
    'Categories' => 'Categories',
    'Tags' => 'Tags',
    'Users' => 'Users',
    'Predefined Options' => 'Predefined Options',
    'Source' => 'Source',
    'Empty Option Label (optional)' => 'Empty Option Label (optional)',
    'To show an empty option at the beginning of the Select field options, enter a value here. Leave blank if you don\'t want a first option.' => 'To show an empty option at the beginning of the Select field options, enter a value here. Leave blank if you don\'t want a first option.',
    'Target' => 'Target',
    'Order By' => 'Order By',
    'Sort' => 'Sort',
    'Option Label' => 'Option Label',
    'Option Value' => 'Option Value',
    'Options for this field' => 'Options for this field',
    'Abbreviated' => 'Abbreviated',
    'Full' => 'Full',
    'Range Start' => 'Range Start',
    'Range End' => 'Range End',
    'Sort Direction' => 'Sort Direction',
    'Ascending' => 'Ascending',
    'Descending' => 'Descending',
    'Single number' => 'Single number',
    '2-digit number' => '2-digit number',
    'Submit' => 'Submit',
    'Confirm' => 'Confirm',
    'Password' => 'Password',

    'States' => 'States',
    'States & Territories' => 'States & Territories',
    'Provinces' => 'Provinces',
    'Provinces - English' => 'Provinces - English',
    'Provinces - French' => 'Provinces - French',
    'Provinces - Bilingual' => 'Provinces - Bilingual',
    'Countries' => 'Countries',
    'Languages' => 'Languages',
    'Currencies' => 'Currencies',
    'Numbers' => 'Numbers',
    'Years' => 'Years',
    'Months' => 'Months',
    'Days' => 'Days',
    'Days of Week' => 'Days of Week',

    'The notification template used to send an email to the email value entered into this field (optional).' => 'The notification template used to send an email to the email value entered into this field (optional).',
    'Select a template...' => 'Select a template...',
    'Admin Recipients' => 'Admin Recipients',
    'Email address(es) to receive an email notification. Enter each on a new line.' => 'Email address(es) to receive an email notification. Enter each on a new line.',

    'This field is required?' => 'This field is required?',
    'Use built-in Table JS?' => 'Use built-in Table JS?',
    'Check this to enable built-in javascript for handling adding new rows.' => 'Check this to enable built-in javascript for handling adding new rows.',
    'Table Layout' => 'Table Layout',
    'Use semicolon ";" separated values for select options.' => 'Use semicolon ";" separated values for select options.',
    'Style' => 'Style',
    'Select style.' => 'Select style.',
    'Accent Color' => 'Accent Color',
    'Select accent color' => 'Select accent color',
    'Layout' => 'Layout',
    'Field layout.' => 'Field layout.',
    'Two rows' => 'Two rows',
    'Three rows' => 'Three rows',
    'Configuration' => 'Configuration',
    'Options Editor' => 'Options Editor',
    'Attribute Editor' => 'Attribute Editor',
    'Site' => 'Site',
    'Credit Card Number' => 'Credit Card Number',
    'Expiry Date' => 'Expiry Date',
    'CVC/CVV' => 'CVC/CVV',
    'Field label used to describe credit card number field.' => 'Field label used to describe credit card number field.',
    'Checked by default' => 'Checked by default',
    'Show all options in a single line?' => 'Show all options in a single line?',
    "Show 'Clear' button?" => "Show 'Clear' button?",
    'Width' => 'Width',
    'Canvas width in pixels.' => 'Canvas width in pixels.',
    'Height' => 'Height',
    'Canvas height in pixels.' => 'Canvas height in pixels.',
    'Border Color' => 'Border Color',
    'Background Color' => 'Background Color',
    'Pen Color' => 'Pen Color',
    'Pen Dot Size' => 'Pen Dot Size',
    'Edit in Fullscreen mode' => 'Edit in Fullscreen mode',
    'Exit Fullscreen mode' => 'Exit Fullscreen mode',
    'Allow Twig' => 'Allow Twig',
    'Used to enable Twig in HTML blocks' => 'Used to enable Twig in HTML blocks',
    'Disabling this option removes the Captcha check for this specific form.' => 'Disabling this option removes the Captcha check for this specific form.',

    'Input attributes' => 'Input attributes',
    'Label attributes' => 'Label attributes',
    'Error attributes' => 'Error attributes',
    'Instruction attributes' => 'Instruction attributes',
    'Error' => 'Error',
    'Instruction' => 'Instruction',
    'Add any tag attributes to the HTML element.' => 'Add any tag attributes to the HTML element.',

    'Could not finish the tutorial' => 'Could not finish the tutorial',
    "Adjust all settings including return URL and formatting template for your form here. To get back here at a later time, just click the \\'Form Settings\\' button." => "Adjust all settings including return URL and formatting template for your form here. To get back here at a later time, just click the \\'Form Settings\\' button.",
    'Admin Email Notifications' => 'Admin Email Notifications',
    'If you wish to send an email notification to admin(s) upon users successfully submitting this form, set that up here.' => 'If you wish to send an email notification to admin(s) upon users successfully submitting this form, set that up here.',
    'Available Fields' => 'Available Fields',
    'Fields are global throughout all forms, but are customizable for each form. Drag and drop any of these fields into position on the blank layout area in the center column of this page.' => 'Fields are global throughout all forms, but are customizable for each form. Drag and drop any of these fields into position on the blank layout area in the center column of this page.',
    'Quickly create new fields as you need them. Then adjust their properties and options in the Property Editor in the column on the right. Note: fields created here will be available for all other forms as well.' => 'Quickly create new fields as you need them. Then adjust their properties and options in the Property Editor in the column on the right. Note: fields created here will be available for all other forms as well.',
    'Drag and drop these when you need them. You can have as many HTML fields as you need, but should only have 1 submit button per page.' => 'Drag and drop these when you need them. You can have as many HTML fields as you need, but should only have 1 submit button per page.',
    'Form Layout' => 'Form Layout',
    'This is a live preview of what your form will look like. Drag and drop and fields from the left column into position here. New rows and columns will automatically be created as you position the fields.' => 'This is a live preview of what your form will look like. Drag and drop and fields from the left column into position here. New rows and columns will automatically be created as you position the fields.',
    'Editing Fields' => 'Editing Fields',
    'Fields can easily be moved around whenever you need. Clicking on any field will open up its properties in the Property Editor in the right column.' => 'Fields can easily be moved around whenever you need. Clicking on any field will open up its properties in the Property Editor in the right column.',
    'Multi-page Forms' => 'Multi-page Forms',
    'To create multi-page forms, click the + button to add more pages. You can edit the names of the pages in the Property Editor in the right column. To rearrange pages, click and drag page tabs to shuffle order. To move fields from one page to another, drag and drop fields onto the page tab you\'d like it to be on.' => 'To create multi-page forms, click the + button to add more pages. You can edit the names of the pages in the Property Editor in the right column. To rearrange pages, click and drag page tabs to shuffle order. To move fields from one page to another, drag and drop fields onto the page tab you\'d like it to be on.',
    'Property Editor' => 'Property Editor',
    'Page Property Editor' => 'Page Property Editor',
    'This is where all your configuration will happen. Clicking on any field, page tab, etc in Form Builder layout area will load its configuration options here.' => 'This is where all your configuration will happen. Clicking on any field, page tab, etc in Form Builder layout area will load its configuration options here.',

    'Field Property Editor' => 'Field Property Editor',
    'Reset' => 'Reset',
    'Reset to default values' => 'Reset to default values',
    'Please select an element' => 'Please select an element',
    'Database Templates' => 'Database Templates',
    'File Templates' => 'File Templates',
    'Table settings are controlled inside Form Builder.' => 'Table settings are controlled inside Form Builder.',

    // Conditional logic
    'Select a page to add rules to' => 'Select a page to add rules to',
    'Add a new field rule' => 'Add a new field rule',
    'Add a new goto rule' => 'Add a new goto rule',
    'Field rules' => 'Field rules',
    'Page rules' => 'Page rules',
    'Rules for {page}' => 'Rules for {page}',
    'Go to {page} when' => 'Go to {page} when',
    'of its criteria match' => 'of its criteria match',
    'any' => 'any',
    'all' => 'all',
    'Add...' => 'Add...',
    'Add criteria...' => 'Add criteria...',
    'Show' => 'Show',
    'Hide' => 'Hide',
    'this item when' => 'this item when',
    'is' => 'is',
    'is not' => 'is not',
    'Field' => 'Field',
    'Add a rule' => 'Add a rule',
    'Add Field rule' => 'Add Field rule',
    'Choose a field' => 'Choose a field',

    // Payments
    'Enter your Stripe public key here.' => 'Enter your Stripe public key here.',
    'Enter your Stripe secret key here.' => 'Enter your Stripe secret key here.',
    'Enter your Stripe webhook secret here.' => 'Enter your Stripe webhook secret here.',

    'Payment Gateway' => 'Payment Gateway',
    'Choose a payment gateway.' => 'Choose a payment gateway.',
    'Refresh Payment Gateways' => 'Refresh Payment Gateways',
    'Payment Type' => 'Payment Type',
    'Select a payment template' => 'Select a payment template',
    'Choose payment type...' => 'Choose payment type...',
    'Single payment' => 'Single payment',
    'Predefined subscription plan' => 'Predefined subscription plan',
    'Customer defined subscription plan' => 'Customer defined subscription plan',
    'Customer Field Mapping' => 'Customer Field Mapping',
    'Payment fields to your Freeform fields.' => 'Payment fields to your Freeform fields.',

    // Dashboard
    'Dashboard' => 'Dashboard',
    'Access Dashboard' => 'Access Dashboard',
    'Manage' => 'Manage',
    'Spam ({count})' => 'Spam ({count})',
    'New Form' => 'New Form',
    'New' => 'New',

    // Logs
    'Logs' => 'Logs',
    'View Log' => 'View Log',
    'Clear' => 'Clear',
    'Errors' => 'Errors',
    'Error Log' => 'Error Log',
    'Error Log <span class="badge">{count}</span>' => 'Error Log <span class="badge">{count}</span>',
    'Everything appears to be okay right now! No errors were found.' => 'Everything appears to be okay right now! No errors were found.',
    'You don\'t have any submissions yet!' => 'You don\'t have any submissions yet!',
    'You haven\'t created any forms yet!' => 'You haven\'t created any forms yet!',
    'Are you sure you want to clear the Error log?' => 'Are you sure you want to clear the Error log?',
    'Level' => 'Level',
    'Details' => 'Details',

    // Diagnostics
    'Diagnostics' => 'Diagnostics',
    'Warnings' => 'Warnings',
    'Suggestions' => 'Suggestions',
    'Server Checks' => 'Server Checks',
    'Freeform Stats' => 'Freeform Stats',
    'Freeform Checks' => 'Freeform Checks',

    // Resources
    'Resources' => 'Resources',
    'Community' => 'Community',
    'Explore' => 'Explore',
    'Support' => 'Support',
    'The Craft community is diverse, inclusive, and amazingly helpful. You can interact with others in the Craft community in a couple of different ways:' => 'The Craft community is diverse, inclusive, and amazingly helpful. You can interact with others in the Craft community in a couple of different ways:',
    "Check out Solspace's other offerings and explore more options below to go beyond Freeform or extend the functionality of it by using the documented Developer Events." => "Check out Solspace's other offerings and explore more options below to go beyond Freeform or extend the functionality of it by using the documented Developer Events.",
    'If you run into any issues or have any feature requests, check out the official support options below. We also appreciate any feedback you can provide us.' => 'If you run into any issues or have any feature requests, check out the official support options below. We also appreciate any feedback you can provide us.',

    // Craft Dashboard Widgets
    'Customize the widget title. Leave blank for default.' => 'Customize the widget title. Leave blank for default.',
    'Success Message' => 'Success Message',
    'The text to be shown at the top of the form if the submit is successful (AJAX), or load in your template with `form.successMessage`.' => 'The text to be shown at the top of the form if the submit is successful (AJAX), or load in your template with `form.successMessage`.',
    'The text to be shown at the top of the form if there are any errors upon submit (AJAX), or load in your template with `form.errorMessage`.' => 'The text to be shown at the top of the form if there are any errors upon submit (AJAX), or load in your template with `form.errorMessage`.',
    'Customize the message to be displayed to the user when the form has been successfully submitted.' => 'Customize the message to be displayed to the user when the form has been successfully submitted.',
    'Form submitted successfully!' => 'Form submitted successfully!',
    'Select the form to be displayed.' => 'Select the form to be displayed.',
    'Chart Type' => 'Chart Type',
    'Chart Height' => 'Chart Height',
    'Select Date Range' => 'Select Date Range',
    'Show all form data as a single, combined line?' => 'Show all form data as a single, combined line?',
    'Which form submissions do you wish to show?' => 'Which form submissions do you wish to show?',
    'Show empty values?' => 'Show empty values?',
    'Limit' => 'Limit',
    'The maximum amount of submissions to show.' => 'The maximum amount of submissions to show.',
    'Choose which forms to use for statistics.' => 'Choose which forms to use for statistics.',
    'Choose which submission statuses should be used for statistics.' => 'Choose which submission statuses should be used for statistics.',
    'Show Global Statistics' => 'Show Global Statistics',
    'Enable this to show the total form, field and notification template count.' => 'Enable this to show the total form, field and notification template count.',

    // Front End
    'Form has been submitted successfully!' => 'Form has been submitted successfully!',
    'Error! Please review the form and try submitting again.' => 'Error! Please review the form and try submitting again.',

    // Payments
    'Subscription not found' => 'Subscription not found',
    'Error during subscription cancellation' => 'Error during subscription cancellation',
    'Unsubscribed successfully' => 'Unsubscribed successfully',
    'Invalid integration' => 'Invalid integration',
    'Integration is not configured properly' => 'Integration is not configured properly',
    'Invalid payload' => 'Invalid payload',
    'Invalid signature' => 'Invalid signature',
    'Event is not linked to freeform submission' => 'Event is not linked to freeform submission',
    'Fix Missing Payments' => 'Fix Missing Payments',
    'Form does not contain payment fields' => 'Form does not contain payment fields',
    'Payments are not set up for the form' => 'Payments are not set up for the form',
    'No submissions found' => 'No submissions found',
    'Payment gateway is not configured!' => 'Payment gateway is not configured!',
    'Payment type is not configured!' => 'Payment type is not configured!',
    'Payment amount is not configured!' => 'Payment amount is not configured!',
    'Subscription plan is not configured!' => 'Subscription plan is not configured!',
    '<a href="{url}">Upgrade to Pro</a> to get access to popular API integrations.' => '<a href="{url}">Upgrade to Pro</a> to get access to popular API integrations.',
    'Requires Pro version' => 'Requires Pro version',
    'Unknown' => 'Unknown',
    'Cancel Subscription' => 'Cancel Subscription',
    'Card Number' => 'Card Number',
    'See in' => 'See in',

    // Exporting
    'Quick Export' => 'Quick Export',
    'Export data' => 'Export data',
    'Export as' => 'Export as',
    'Fields for' => 'Fields for',
    'No export profiles found' => 'No export profiles found',
    'Export Profiles' => 'Export Profiles',
    'New Export Profile' => 'New Export Profile',
    'Profiles' => 'Profiles',
    'Filter Type' => 'Filter Type',
    'Filters' => 'Filters',
    'Add filters to narrow down your results. For searching into arrays, use LIKE and wrap values with "%", e.g. %"option a"% for a checkbox group field.' => 'Add filters to narrow down your results. For searching into arrays, use LIKE and wrap values with "%", e.g. %"option a"% for a checkbox group field.',
    'Field Name' => 'Field Name',
    'Fields to export' => 'Fields to export',
    'What this export profile will be called in the CP.' => 'What this export profile will be called in the CP.',
    'Select which statuses to use' => 'Select which statuses to use',
    'The date range for fetching submissions' => 'The date range for fetching submissions',
    'Maximum number of submissions to fetch.' => 'Maximum number of submissions to fetch.',
    'Specify the fields you wish to export and their order.' => 'Specify the fields you wish to export and their order.',
    'Custom Range' => 'Custom Range',
    'Last 7 days' => 'Last 7 days',
    'Last 30 days' => 'Last 30 days',
    'Last 365 days' => 'Last 365 days',
    'Presets' => 'Presets',
    "Enter the beginning of the time period. Specify an exact date (e.g. '2020-09-01') or use something relative like '15 days ago'. Default is 'today'." => "Enter the beginning of the time period. Specify an exact date (e.g. '2020-09-01') or use something relative like '15 days ago'. Default is 'today'.",
    "Enter the end of the time period. Specify an exact date (e.g. '2020-09-30') or use something relative like '15 days ago'. Default is 'today'." => "Enter the end of the time period. Specify an exact date (e.g. '2020-09-30') or use something relative like '15 days ago'. Default is 'today'.",
    'Like' => 'Like',
    'Equal To' => 'Equal To',
    'Not Equal To' => 'Not Equal To',
    'Export Notifications' => 'Export Notifications',
    'New Export Notification' => 'New Export Notification',
    'Profile' => 'Profile',
    'Frequency' => 'Frequency',
    'Recipients' => 'Recipients',
    'Daily' => 'Daily',
    'Weekly on Sundays' => 'Weekly on Sundays',
    'Weekly on Mondays' => 'Weekly on Mondays',
    'Weekly on Tuesdays' => 'Weekly on Tuesdays',
    'Weekly on Wednesdays' => 'Weekly on Wednesdays',
    'Weekly on Thursdays' => 'Weekly on Thursdays',
    'Weekly on Fridays' => 'Weekly on Fridays',
    'Weekly on Saturdays' => 'Weekly on Saturdays',
    'What this export notification will be called in the control panel.' => 'What this export notification will be called in the control panel.',
    'Export Profile' => 'Export Profile',
    'Choose the Export Profile to use for this notification.' => 'Choose the Export Profile to use for this notification.',
    'File Type' => 'File Type',
    'Choose the export file type to use for this notification.' => 'Choose the export file type to use for this notification.',
    "Specify how often and which days (if applicable) you'd like to receive the email notifications. The chosen date will attempt to send a notification in the morning." => "Specify how often and which days (if applicable) you'd like to receive the email notifications. The chosen date will attempt to send a notification in the morning.",
    'Emails to Notify' => 'Emails to Notify',
    'Enter the email address(es) that should be notified. If more than one, enter each one on a new line.' => 'Enter the email address(es) that should be notified. If more than one, enter each one on a new line.',
    'The file name to be generated for the export. You can use the `form`, `profile` and `date` objects as a Twig template here to name your file. (e.g. `"{{ form.handle }}-{{ date.toDateString }}"` which would generate a filename of "`some-form-handle-2022-01-01.csv`"). The extension will be added automatically.' => 'The file name to be generated for the export. You can use the `form`, `profile` and `date` objects as a Twig template here to name your file. (e.g. `"{{ form.handle }}-{{ date.toDateString }}"` which would generate a filename of "`some-form-handle-2022-01-01.csv`"). The extension will be added automatically.',
    'Email Subject' => 'Email Subject',
    'Email Message' => 'Email Message',
    'The text content of the email notification.' => 'The text content of the email notification.',

    // Spam
    'Spam Reasons' => 'Spam Reasons',
    'Marked as spam because' => 'Marked as spam because',
    'generic' => 'Unknown',
    'honeypot' => 'Honeypot',
    'js_test' => 'Honeypot JS Test',
    'recaptcha' => 'Captcha Failure',
    'blocked_keywords' => 'Blocked Keywords',
    'blocked_email_address' => 'Blocked Email Address',
    'blocked_ip' => 'Blocked IP',
    'minimum_submit_time' => 'Minimum Submit Time',
    'maximum_submit_time' => 'Maximum Submit Time',
    'Honeypot check failed' => 'Honeypot check failed',
    'reCAPTCHA -' => 'reCAPTCHA -',
    'Minimum submit time check failed' => 'Minimum submit time check failed',
    'Maximum submit time check failed' => 'Maximum submit time check failed',
    'Form contains a restricted keyword' => 'Form contains a restricted keyword',
    'Form contains a blocked email' => 'Form contains a blocked email',
    'Your IP has been blocked' => 'Your IP has been blocked',
    'Sorry, we cannot accept your submission at this time. Not enough time has passed before submitting the form.' => 'Sorry, we cannot accept your submission at this time. Not enough time has passed before submitting the form.',
    'Sorry, we cannot accept your submission at this time. Too much time has passed before submitting the form.' => 'Sorry, we cannot accept your submission at this time. Too much time has passed before submitting the form.',
    'Allow' => 'Allow',
];
