<?php
/**
 * Freeform for Craft CMS.
 *
 * @author        Solspace, Inc.
 * @copyright     Copyright (c) 2008-2022, Solspace, Inc.
 *
 * @see           https://docs.solspace.com/craft/freeform
 *
 * @license       https://docs.solspace.com/license-agreement
 */

return [
    // Algemeen
    'Save and continue editing' => 'Opslaan en doorgaan met bewerken',
    'Save and add another' => 'Opslaan en nog een toevoegen',
    'Save' => 'Opslaan',
    'Name' => 'Naam',
    'Handle' => 'Handle',
    'Delete' => 'Verwijder',
    'Last Updated' => 'Laatst bijgewerkt',

    'Success Behavior' => 'Succes Gedrag',
    'Reload Form with Success Message' => 'Formulier opnieuw laden met succesbericht',
    'Load Success Template' => 'Successjabloon laden',
    'Use Return URL' => 'Gebruik retour-URL',
    'Success Template' => 'Succes Sjabloon',
    'Select the desired success template to be used.' => 'Selecteer de gewenste successjabloon die moet worden gebruikt.',
    'Set how you’d like the success return of this form to be handled. May also be overrided at template-level.' => 'Stel in hoe u wilt dat de succesvolle terugkeer van dit formulier wordt afgehandeld. Kan ook worden overschreven op sjabloonniveau.',
    'Select the type of form this is. When additional form types are installed, you can choose a different form type that enables special behaviors.' => 'Selecteer het type formulier. Wanneer extra formuliertypen zijn geïnstalleerd, kunt u een ander formuliertype kiezen dat speciaal gedrag mogelijk maakt.',
    'Enable AJAX' => 'AJAX Inschakelen',
    'POST Forwarding' => 'POST Doorsturen',
    'If you need to have the POST data of this form submitted to an external API, provide that custom URL here.' => 'Als u de POST-gegevens van dit formulier naar een externe API wilt laten verzenden, geeft u die aangepaste URL hier op.',
    'POST Forwarding Error Trigger' => 'POST Doorstuurfouttrigger',
    'Provide a keyword or phrase Freeform should check for in the output of the external POST URL to know if and when there’s an error to log, e.g. ‘error’ or ‘an error occurred’.' => 'Geef een trefwoord of woordgroep op waarop Freeform moet controleren in de uitvoer van de externe POST-URL om te weten of en wanneer er een fout is om te loggen, b.v. ‘fout’ of ‘er is een fout opgetreden’.',
    'Enable Captchas' => 'Captchas Inschakelen',

    // API Controller
    'Label is required' => 'Label is verplicht',
    'Handle is required' => 'Handle is verplicht',
    'Type {type} is not allowed. Allowed types are ({allowedTypes})' => 'Type {type} is niet toegestaan. Toegestaande types zijn ({allowedTypes})',
    'Name is required' => 'Naam is verplicht',
    "Template '{name}' already exists" => "Template '{name}' bestaat al",
    'Submissions' => 'Inzendingen',
    'Date' => 'Datum',
    'Value' => 'Waarde',

    // CRM Controller
    'Add a CRM integration' => 'Voeg een CRM integratie toe',
    "CRM integration with handle '{ID}' not found" => "CRM-integratie met handle '{ID}' niet gevonden",
    'CRM Integration saved' => 'CRM-integratie opgeslagen',
    'CRM Integration not saved' => 'CRM-integratie niet opgeslagen',
    "CRM integration with handle '{handle}' not found" => "CRM-integratie met handle '{handle}' niet gevonden",
    'New CRM Integration' => 'Nieuwe CRM-integratie',
    'CRM' => 'CRM',
    'No CRM integrations exist yet' => 'Er bestaan nog geen CRM-integraties',
    'What this integration will be called in the CP.' => 'Hoe deze integratie genoemd wordt in de CP.',
    'The unique name used to identify this integration.' => 'De unieke naam die wordt gebruikt om deze integratie te identificeren.',
    'Service Provider' => 'Service Provider',
    'Upgrade to Pro to enable' => 'Upgrade naar Pro om in te schakelen',
    'Requires Pro version' => 'Vereist Pro-versie',
    '<a href="{url}">Upgrade to Pro</a> to get access to popular API integrations.' => '<a href="{url}">Upgrade naar Pro</a> om toegang te krijgen tot populaire API-integraties.',
    'Shop for CRM integrations on the {link_open}Solspace Freeform Marketplace{link_close}' => 'Zoek naar CRM integraties op de {link_open}Solspace Freeform Marketplace{link_close}',
    'Are you sure you want to remove the “{name}” integration?' => 'Weet je zeker dat je de integratie “{name}” wilt verwijderen?',
    'Authorized' => 'Gemachtigde',
    'Not able to authorize.' => 'Kan niet autoriseren.',
    'Click here to re-authorize' => 'Klik hier om opnieuw te autoriseren',
    'Checking credentials...' => 'Inloggegevens controleren...',
    'API Token' => 'API-token',
    'Enter your API Token here.' => 'Voer hier uw API-token in.',
    'Enter your API specific URL here.' => 'Voer hier uw API-specifieke URL in.',
    'Pipeline' => 'Pijpleiding',
    'Enter the name or ID of the desired Pipeline.' => 'Voer de naam of ID van de gewenste pijplijn in.',
    'Stage' => 'Fase',
    'Enter the name or ID of the desired Stage.' => 'Voer de naam of het ID van de gewenste fase in.',
    'Owner (Optional if auto-assign enabled in AC)' => 'Eigenaar (optioneel als automatisch toewijzen is ingeschakeld in AC)',
    "Enter the username or ID of the user you wish to assign as the deal owner. If you don't specify an owner, Active Campaign will auto-assign an owner if it is set up." => 'Voer de gebruikersnaam of ID in van de gebruiker die u wilt toewijzen als eigenaar van de deal. Als u geen eigenaar opgeeft, wijst Active Campaign automatisch een eigenaar toe als deze is ingesteld.',
    'Enter your Freshdesk API key here.' => 'Voer hier uw Freshdesk API-sleutel in.',
    'Domain' => 'Domein',
    "Enter your Freshdesk Domain here, e.g. 'https://example.freshdesk.com'." => "Voer hier uw Freshdesk-domein in, b.v. 'https://voorbeeld.freshdesk.com'.",
    'Default Type (Optional)' => 'Standaardtype (optioneel)',
    "Set the default Type for tickets, e.g. 'Question'." => "Stel het standaard Type in voor tickets, b.v. 'Vraag'.",
    'Default Priority (Optional)' => 'Standaardprioriteit (optioneel)',
    "Set the default Priority for tickets, e.g. '1' (low)." => "Stel de standaardprioriteit in voor tickets, b.v. '1' (laag).",
    'Default Status (Optional)' => 'Standaardstatus (optioneel)',
    "Set the default Status for tickets, e.g. '2' (open)." => "Stel de standaardstatus in voor tickets, b.v. '2' (geopend).",
    'Default Source (Optional)' => 'Standaardbron (optioneel)',
    "Set the default Source for tickets, e.g. '1' (email), '2' (portal), etc." => "Stel de standaardbron voor tickets in, b.v. '1' (e-mail), '2' (portal), enz.",
    'Private App Token' => 'Private App-token',
    'Enter your HubSpot Private App token here.' => 'Voer hier uw HubSpot Private App-token in.',
    'IP Address Field' => 'IP-adresveld',
    "Enter a custom HubSpot Contact field handle where you wish to store the client's IP address from the submission (optional)." => 'Voer een aangepast HubSpot Contact-veldhandvat in waar u het IP-adres van de klant vanaf de indiening wilt opslaan (optioneel).',
    'Append checkbox group field values on Contact update?' => 'Veldwaarden van checkbox-groep toevoegen bij bijwerken van contactpersoon?',
    'If a Contact already exists in HubSpot, enabling this will append additional checkbox group field values to the Contact inside HubSpot, instead of overwriting the options.' => 'Als er al een Contact bestaat in HubSpot, zal het inschakelen hiervan extra checkbox groepsveldwaarden toevoegen aan het Contact binnen HubSpot, in plaats van de opties te overschrijven.',
    'Append checkbox group field values on Company update?' => 'Veldwaarden van checkbox-groepen toevoegen aan Bedrijfsupdate?',
    'If a Company already exists in HubSpot, enabling this will append additional checkbox group field values to the Company inside HubSpot, instead of overwriting the options.' => 'Als er al een bedrijf bestaat in HubSpot, zal het inschakelen hiervan extra checkbox groepsveldwaarden toevoegen aan het bedrijf binnen HubSpot, in plaats van de opties te overschrijven.',
    'OAuth 2.0 Return URI' => 'OAuth 2.0 Retour-URI',
    'Enter the Client ID of your app in here' => 'Voer hier de klant-ID van uw app in',
    'Client Secret' => 'Cliënt geheim',
    'Enter your Insightly API key here.' => 'Voer hier uw Insightly API-sleutel in.',
    'Pardot Business Unit ID' => 'Pardot Business Unit-ID',
    'Enter your Pardot business unit ID here' => 'Vul hier uw Pardot business unit ID in',
    'Enter your Pipedrive API token here.' => 'Voer hier uw Pipedrive API-token in.',
    'User ID' => 'Gebruiker ID',
    'Enter the Pipedrive User ID you want to assign to new objects.' => 'Voer de Pipedrive-gebruikers-ID in die u aan nieuwe objecten wilt toewijzen.',
    'Detect Duplicates' => 'Detecteer duplicaten',
    'Enable this setting to prevent creation of organizations or persons with overlapping names and/or email addresses.' => 'Schakel deze instelling in om te voorkomen dat organisaties of personen met overlappende namen en/of e-mailadressen worden aangemaakt.',
    'Stage ID' => 'Stage-ID',
    'Enter the Pipedrive Stage ID you want the deal to be placed in.' => 'Voer de Pipedrive Stage-ID in waarin u de deal wilt plaatsen.',
    'Enter the Client ID of your Salesforce app in here.' => 'Voer hier de klant-ID van uw Salesforce-app in.',
    'Enter the Client Secret of your Salesforce app here.' => 'Voer hier het Clientgeheim van uw Salesforce-app in.',
    'Username' => 'Gebruikersnaam',
    'Enter your Salesforce username here.' => 'Voer hier uw Salesforce-gebruikersnaam in.',
    'Enter your Salesforce password here.' => 'Voer hier uw Salesforce-wachtwoord in.',
    'Assign Lead Owner?' => 'Hoofdeigenaar toewijzen?',
    'Enabling this will make Salesforce assign a lead owner based on lead owner assignment rules.' => 'Als u dit inschakelt, wijst Salesforce een leadeigenaar toe op basis van toewijzingsregels voor leadeigenaar.',
    'Sandbox Mode' => 'Sandbox-modus',
    'Enable this if your Salesforce account is in Sandbox mode (connects to "test.salesforce.com" instead of "login.salesforce.com").' => 'Schakel dit in als uw Salesforce-account in Sandbox-modus staat (maakt verbinding met "test.salesforce.com" in plaats van "login.salesforce.com").',
    'Using custom URL?' => 'Aangepaste URL gebruiken?',
    "Enable this if you connect to your Salesforce account with a custom company URL (e.g. 'mycompany.my.salesforce.com')." => "Schakel dit in als u verbinding maakt met uw Salesforce-account met een aangepaste bedrijfs-URL (bijvoorbeeld 'mijnbedrijf.my.salesforce.com').",
    'Convert Leads to Contact Tasks for Returning Customers?' => 'Leads omzetten naar contacttaken voor terugkerende klanten?',
    'When a Salesforce Contact already exists with the same email address, create a new Task for the Contact instead of a new Lead.' => 'Als er al een Salesforce-contactpersoon bestaat met hetzelfde e-mailadres, maakt u een nieuwe taak voor de contactpersoon in plaats van een nieuwe lead.',
    'Task Subject' => 'Taak Onderwerp',
    "Enter the text you'd like to have set for new Task subjects." => 'Voer de tekst in die u wilt instellen voor nieuwe taakonderwerpen.',
    'Task Due Date' => 'Vervaldatum taak',
    "Enter a relative textual date string for the Due Date of the newly created Task (e.g. '2 days')." => "Voer een relatieve tekstuele datumreeks in voor de vervaldatum van de nieuw gemaakte taak (bijv. '2 days').",
    'Close Date' => 'Sluitingsdatum',
    "Enter a relative textual date string for the Close Date of the newly created Opportunity (e.g. '7 days')." => "Voer een relatieve tekstuele datumreeks in voor de Sluitingsdatum van de nieuw gecreëerde Opportunity (bijv. '7 days').",
    'Stage Name' => 'Fasenaam',
    "Enter the Stage Name the newly created Opportunity should be assigned to (e.g. 'Prospecting')." => "Voer de fasenaam in waaraan de nieuw gecreëerde Opportunity moet worden toegewezen (bijv. 'Prospectie').",
    'If a Contact already exists in Salesforce, enabling this will append additional checkbox group field values to the Contact inside Salesforce, instead of overwriting the options.' => 'Als er al een contactpersoon bestaat in Salesforce, worden bij het inschakelen hiervan aanvullende groepsveldwaarden voor selectievakjes toegevoegd aan de contactpersoon binnen Salesforce, in plaats van de opties te overschrijven.',
    'Append checkbox group field values on Account update?' => 'Veldwaarden van selectievakjegroep toevoegen bij Accountupdate?',
    'If an Account already exists in Salesforce, enabling this will append additional checkbox group field values to the Account inside Salesforce, instead of overwriting the options.' => 'Als er al een account bestaat in Salesforce, worden bij het inschakelen hiervan aanvullende groepsveldwaarden voor selectievakjes toegevoegd aan de account in Salesforce, in plaats van de opties te overschrijven.',
    'Check Contact email address and Account website when checking for duplicates?' => 'E-mailadres van contactpersoon en website van account controleren bij het controleren op duplicaten?',
    'By default, Freeform will check against Contact first name, last name and email address, as well as and Account name. If enabled, Freeform will instead check against Contact email address only and Account website. If no website is mapped, Freeform will gather the website domain from the Contact email address mapped.' => 'Freeform controleert standaard de voornaam, achternaam en het e-mailadres van de contactpersoon, evenals de accountnaam. Indien ingeschakeld, controleert Freeform in plaats daarvan alleen het e-mailadres van de contactpersoon en de accountwebsite. Als er geen website is toegewezen, verzamelt Freeform het websitedomein van het toegewezen e-mailadres voor contact.',
    'Account ID' => 'Account ID',
    'Enter your Account ID here.' => 'Voer hier uw account-ID in.',
    'Secret Key' => 'Geheime Sleutel',
    'Enter your Secret Key here.' => 'Voer hier uw geheime sleutel in.',

    // Payments Controller
    'Payments' => 'Betalingen',
    'Payment Gateway' => 'Betalingsgateway',
    'Gateway' => 'Poort',
    'Choose a payment gateway.' => 'Kies een betalingsgateway.',
    'Choose a payment gateway...' => 'Kies een betalingsgateway...',
    'Refresh Payment Gateways' => 'Ververs betalingsgateways',
    'Payment Type' => 'Betalingswijze',
    'Select a payment template' => 'Kies een betalingsgateway template',
    'New Payment Integration' => 'Nieuwe Betalingsintegratie',
    'Suppress Email Notifications & Integrations when Payments Fail' => 'Onderdruk e-mailmeldingen en integraties wanneer betalingen mislukken',
    'Failed payments will still be stored as submissions, but enabling this will suppress email notifications and API integrations from being sent.' => 'Mislukte betalingen worden nog steeds opgeslagen als inzendingen, maar als u dit inschakelt, worden e-mailmeldingen en API-integraties niet verzonden.',
    'Send Success Email from Stripe to Submitter' => 'Stuur een succes-e-mail van Stripe naar de indiener',
    "When enabled, Freeform will pass off the submitter's email address to Stripe's 'receipt_email' field, which will then automatically trigger Stripe sending a success email notification." => "Indien ingeschakeld, geeft Freeform het e-mailadres van de indiener door aan het veld 'receipt_email' van Stripe, waardoor Stripe automatisch een e-mailmelding met succes verzendt.",
    'Public Key (Live)' => 'Openbare sleutel (Live)',
    'Enter your Stripe LIVE public key here.' => 'Voer hier uw Stripe LIVE openbare sleutel in.',
    'Secret Key (Live)' => 'Geheime sleutel (Live)',
    'Enter your Stripe LIVE secret key here.' => 'Voer hier uw Stripe LIVE geheime sleutel in.',
    'Public Key (Test)' => 'Openbare sleutel (Test)',
    'Enter your Stripe TEST public key here.' => 'Voer hier uw Stripe TEST openbare sleutel in.',
    'Secret Key (Test)' => 'Geheime sleutel (Test)',
    'Enter your Stripe TEST secret key here.' => 'Voer hier uw Stripe TEST geheime sleutel in.',
    'LIVE mode' => 'LIVE-modus',
    'Enable this to start using LIVE public and secret keys.' => 'Schakel dit in om LIVE openbare en geheime sleutels te gaan gebruiken.',
    'Webhook Secret' => 'Webhook geheim',
    'Webhook URL' => 'Webhook-URL',
    'Use this URL to set up webhooks inside your payment gateway dashboard.' => 'Gebruik deze URL om webhooks in te stellen binnen het dashboard van uw betalingsgateway.',

    // Webhook Controller
    'Provider' => 'Aanbieder',
    'New Webhook' => 'Nieuwe Webhook',
    'Type' => 'Type',
    'Choose the webhook type' => 'Kies het type webhook',
    'Webhook Name' => 'Webhook-naam',
    'A name for this webhook' => 'Een naam voor deze webhook',
    'Enter the Webhook URL.' => 'Voer de webhook-URL in.',
    'Select which forms will trigger this webhook.' => 'Selecteer welke formulieren deze webhook activeren.',
    'Message' => 'Bericht',
    'Enter the notification message the Slack channel should receive. (Can use {{ submission }} and {{ form }} variables)' => 'Voer het meldingsbericht in dat het Slack-kanaal moet ontvangen. (Kan {{ submission }} en {{ form }} variabelen gebruiken)',

    // Mailinglijst Controller
    'New Email Marketing Integration' => 'Nieuwe mailinglijst integratie',
    'No Email Marketing integrations exist yet' => 'Er bestaan nog geen mailinglijst-integraties',
    'Email Marketing' => 'Email Reclame',
    'Service Provider' => 'Dienstverlener',
    'Last Updated' => 'Laatst aangepast',
    'Create new mailing list' => 'Creëer nieuwe mailinglijst',
    'Email Marketing integration with ID {id} not found' => 'Mailinglijst integratie met ID {id} niet gevonden',
    'Email Marketing Integration saved' => 'Mailinglijstintegratie opgeslagen',
    'Email Marketing Integration not saved' => 'Mailinglijstintegratie niet opgeslagen',
    "Mailing list with handle '{handle}' not found" => "Mailinglijst met handle '{handle}' niet gevonden",
    'Add a Email Marketing integration' => 'Voeg een Mailing lijst integratie toe',
    'Shop for more Email Marketing integrations on the {link_open}Solspace Freeform Marketplace{link_close}' => 'Vind meer mailinglijst integraties op de {link_open}Solspace Freeform Marketplace{link_close}',
    'API Key' => 'API Sleutel',
    'Enter your Mailchimp API key here.' => 'Voer hier uw Mailchimp API-sleutel in.',
    'Use double opt-in?' => 'Dubbele opt-in gebruiken?',
    'API User Email' => 'E-mailadres API-gebruiker',
    'Enter your Dotmailer API user email.' => 'Voer uw Dotmailer API-gebruikerse-mailadres in.',
    'Enter your Dotmailer API user password' => 'Voer uw Dotmailer API-gebruikerswachtwoord in',
    'Redirect URI' => 'Omleidings-URI',
    'You must specify this as the Return URI in your app settings to be able to authorize your credentials. DO NOT CHANGE THIS.' => 'U moet dit opgeven als de retour-URI in uw app-instellingen om uw inloggegevens te kunnen autoriseren. VERANDER DIT NIET.',
    'Enter the API Key of your app in here' => 'Voer hier de API-sleutel van uw app in',
    'App Secret' => 'App-geheim',
    'Enter the Client Secret of your app here' => 'Voer hier het clientgeheim van uw app in',
    'Enter your Campaign Monitor API key here.' => 'Voer hier uw Campaign Monitor API-sleutel in.',
    'Client ID' => 'Klant ID',
    'Enter your Campaign Monitor Client ID here.' => 'Voer hier uw Campaign Monitor Klant ID in.',
    'API URL' => 'API URL',
    'Enter your ActiveCampaign API Access URL here.' => 'Voer hier uw ActiveCampaign API-toegangs-URL in.',
    'Enter your ActiveCampaign API key here.' => 'Voer hier uw ActiveCampaign API-sleutel in.',

    // Layout
    'This field is required' => 'Dit veld is verplicht',
    'Form Builder has no properties' => 'Form Builder heeft geen eigenschappen',
    'No form builder data present' => 'Geen form builder gegevens aanwezig',
    'No context specified' => 'Geen context opgegeven',
    'No properties available' => 'Geen eigenschappen beschikbaar',
    'No form settings specified' => 'Geen formuliereninstellingen opgegeven',
    "Field with handle '{handle}' not found" => "Veld met handle '{handle}' niet gevonden",
    "Field with hash '{hash}' not found" => "Veld met hash '{hash}' niet gevonden",
    'Layout page {pageIndex} does not contain a row array' => 'Layout pagina {pageIndex} bevat geen rij array',
    'Layout page {pageIndex} row {rowIndex} does not contain its ID' => 'Layout pagina {pageIndex} rij {rowIndex} bevat geen ID',
    'Layout page {pageIndex} row {rowIndex} does not contain a list of columns' => 'Layout pagina {pageIndex} rij {rowIndex} bevat geen lijst met kolommen',
    'Could not create a field of type {type}' => 'Kon geen veld van type {type} maken',

    // Velden controller
    'Create Field' => 'Creëer veld',
    'Fields' => 'Velden',
    'Field saved' => 'Veld opgeslagen',
    'Field not saved' => 'Veld is niet opgeslagen',
    'Field with ID {id} not found' => 'Veld met ID {id} niet gevonden',
    'Checked?' => 'Gecontroleerd?',
    'Selected?' => 'Geselecteerd?',

    // Formulieren controller
    'Create a new form' => 'Maak een nieuw formulier aan',
    'Description' => 'Beschrijving',
    'Editing: {title}' => 'Bewerken: {title}',
    'Forms' => 'Formulieren',
    'No form ID specified' => 'Geen formulier ID opgegeven',
    'No forms found' => 'Geen formulier gevonden',
    'Form with ID {id} not found' => 'Formulier met ID {id} niet gevonden',
    'Are you sure you want to delete this form?' => 'Weet u zeker dat u dit formulier wilt verwijderen?',
    'All Sections' => 'Alle secties',
    'All Category Groups' => 'Alle categorie groepen',
    'All Tag Groups' => 'Alle Tag Groepen',
    'All User Groups' => 'Alle gebruikersgroepen',
    'All Assets' => 'Alle middelen',
    'Filename' => 'Bestandsnaam',
    'Clone' => 'Kloon',
    'Handle' => 'Handle',

    // Meldingen Controller
    'Email Notifications' => 'Email Notificaties',
    'Notifications' => 'Notificaties',
    'Notification saved' => 'Notificatie opgeslagen',
    'Notification not saved' => 'Notificatie niet opgeslagen',
    'Notification with ID {id} not found' => 'Notificatie met ID {id} niet gevonden',
    'Include Attachments?' => 'Bijlagen toevoegen?',
    'Include uploaded files as attachments in email notification.' => 'Neem geüploade bestanden op als bijlagen in email notificatie.',
    'Create a new email notification template' => 'Maak een nieuwe emailnotificatie template',
    'What this field will be called in the CP.' => 'Hoe dit veld in de CP genoemd wordt.',
    'How you’ll refer to this notification template in the templates.' => 'Hoe u naar deze notificatietemplate in de templates verwijst.',
    'Description of this notification.' => 'Beschrijving van deze notificatie.',
    'The subject line for the email notification.' => 'De onderwerpsregel voor de e-mailnotificatie.',
    'The email address that the email will appear from in your email notification.' => 'Het emailadres waarvan de email zal verschijnen in jouw emailnotificatie.',
    'The name that the email will appear from in your email notification.' => 'De naam waaruit de email zal verschijnen in uw e-mail notificatie.',
    "The reply-to email address for your email notification. Leave blank to use 'From Email' address." => "Het antwoord e-mailadres voor uw e-mail notificatie. Laat leeg om het 'van e-mail' adres te gebruiken.",
    'The content of the email notification. See documentation for availability of variables.' => 'De inhoud van de e-mail notificatie. Bekijk de documentatie voor de beschikbaarheid van variabelen.',
    'CC' => 'CC',
    "The email address(es) you would like to be CC'd in the email notification. Separate multiples with commas. Leave blank to not use." => "De e-mailadressen die u ge'CCt wilt hebben in de e-mailnotificatie. Gescheiden veelvouden met komma's. Laat leeg om niet te gebruiken.",
    'BCC' => 'BCC',
    "The email address(es) you would like to be BCC'd in the email notification. Separate multiples with commas. Leave blank to not use." => "De e-mailadressen die u ge'BCCt wilt hebben in de e-mailnotificatie. Gescheiden veelvouden met komma's. Laat leeg om niet te gebruiken.",
    'Email Body (HTML)' => 'E-mail body (HTML)',
    'Email Body (Text)' => 'E-mail body (Tekst)',
    'The HTML content of the email notification. If you wish to use Text only, leave this empty and fill out the Text body (below). See documentation for availability of variables.' => 'De HTML content van de e-mail notificatie. Als u alleen tekst wilt gebruiken, laat u dit leeg en vult u de body tekst (hieronder) in. Zie documentatie voor beschikbaarheid van variabelen.',
    'The text content of the email notification. If you wish to send out both HTML and Text options, fill out both the HTML and Text body fields. See documentation for availability of variables.' => 'De tekst inhoud van de e-mail notificatie. Als u zowel HTML- als tekstopties wilt verzenden, vult u zowel HTML- als de tekstvelden in. Zie documentatie voor beschikbaarheid van variabelen.',
    'Predefined Assets' => 'Vooraf gedefinieerde middelen',
    'Select any Assets you wish to include as attachments on all email notifications using this template.' => 'Selecteer een middel die u wenst toe te voegen als bijlage in alle e-mailnotificaties met behulp van deze template.',
    'What this notification template will be called in the CP.' => 'Hoe deze meldingssjabloon in de CP wordt genoemd.',
    'File name of the template without the extension.' => 'Bestandsnaam van de sjabloon zonder de extensie.',
    'Subject' => 'Onderwerp',
    'From Email' => 'Van E-mail',
    'From Name' => 'Van Naam',
    'Reply-to Email' => 'Antwoord E-mail',
    'Reply-to Name' => 'Antwoord Naam',
    "Auto 'Text-Only' version?" => "Automatische 'Alleen tekst'-versie?",
    'When enabled, Freeform will automatically provide a Text-only version of the notification based on the HTML version.' => 'Indien ingeschakeld, levert Freeform automatisch een alleen-tekstversie van de melding op basis van de HTML-versie.',
    'New Template' => 'Nieuw Template',

    // Instellingen controller
    'Settings' => 'Instellingen',
    'Settings Saved' => 'Instellingen opgeslagen',
    'Settings not saved' => 'Instellingen niet opgeslagen',
    'No template name specified' => 'Geen template naam opgegeven',
    'No custom template directory specified in settings' => 'Geen aangepaste template map opgegeven in instellingen',
    "Template '{name}' already exists" => "Template '{name}' bestaat al",
    'Add a sample template' => 'Voeg een voorbeeld template toe',
    'Demo Templates' => 'Demo Sjablonen',
    'No demo templates present' => 'Geen demo sjablonen aanwezig',
    'Successfully installed <b>{templates} templates</b> and <b>{assets} assets</b>' => 'Succesvol geïnstalleerd <b>{templates} templates</b> en <b>{assets} middelen</b>',
    "You can view the templates <a href='{link}'>here</a>" => "U kunt de templates <a href='{link}'>hier</a> bekijken",
    'Install Path' => 'Installeer pad',
    'Install' => 'Installeer',
    'Templates' => 'Templates',
    'Assets' => 'Middelen',
    'Routes' => 'Routes',
    'Directory Path' => 'Map pad',
    'Spam Protection' => 'Spambescherming',
    "Enable this to use Freeform's built in Javascript-based honeypot spam protection." => 'Schakel dit in om Freeform’s ingebouwde Javascript-gebaseerde honeypot spambeveiliging.',
    'Blocked Spam' => 'Geblokkeerde Spam',
    'Default View' => 'Standaardweergave',
    'General Settings' => 'Algemene Instellingen',
    'Control Panel' => 'Controlepaneel',
    'Custom Plugin Name' => 'Aangepaste Plug-innaam',
    'Override the plugin name by specifying your own here.' => 'Overschrijf de naam van de plug-in door hier uw eigen naam op te geven.',
    'Form view' => 'Formulier weergave',
    'Submission view' => 'Inzending bekijken',
    'Plugin Badge' => 'Plug-in-badge',
    "Select the options you'd like to be included in the plugin badge count (when applicable)." => 'Selecteer de opties die u wilt opnemen in het aantal plugin-badges (indien van toepassing).',
    "Don't Show" => 'Niet laten zien',
    "Update Notices, What's New, Logged Errors" => 'Update Mededelingen, Wat is er Nieuw, Gelogde fouten',
    'Update Notices only' => 'Alleen kennisgevingen bijwerken',
    'Logged Errors only' => 'Alleen geregistreerde fouten',
    'Submission Count' => 'Aantal inzendingen',
    'Spam Folder Count' => 'Aantal spammappen',
    "Hide 'Install Demo' alert message?" => "Waarschuwingsbericht 'Demo installeren' verbergen?",
    'Hides the alert message suggesting to install demo templates when this setting is enabled.' => 'Verbergt het waarschuwingsbericht waarin wordt voorgesteld demosjablonen te installeren wanneer deze instelling is ingeschakeld.',
    'Element Field Type' => 'Element Veldtype',
    'Restrict Form options in Form Field Type to User permissions?' => 'Formulieropties in Formulierveldtype beperken tot gebruikersmachtigingen?',
    'Enable this to only show forms the user or group has permissions to manage in the list of options for the Form Element Field Type (relating forms in Entries, etc).' => 'Schakel dit in om alleen formulieren weer te geven waarvoor de gebruiker of groep machtigingen heeft om te beheren in de lijst met opties voor het veldtype Formulierelement (relatieve formulieren in Entries, enz.).',
    'Submission Data' => 'Indieningsgegevens',
    'Enable Search Index Updating on New Submissions?' => 'Bijwerken van zoekindex bij nieuwe inzendingen inschakelen?',
    'Enable this to have Craft update search indexes whenever a new submission is created.' => 'Schakel dit in om Craft zoekindexen te laten updaten wanneer een nieuwe inzending wordt gemaakt.',
    'Use Option Labels when Exporting' => 'Gebruik optielabels bij het exporteren',
    "Enable this to have fields with options use the submission's option labels instead of values when exporting." => 'Schakel dit in om velden met opties de optielabels van de inzending te laten gebruiken in plaats van waarden bij het exporteren.',
    'Use Field Handles for Headings when Exporting' => 'Gebruik veldhandvatten voor koppen bij het exporteren',
    'Enable this to use field handles as headings instead of field labels when exporting submissions.' => 'Schakel dit in om veldhandvatten te gebruiken als koppen in plaats van veldlabels bij het exporteren van inzendingen.',
    'Automatically Purge Submission Data' => 'Inzendingsgegevens automatisch opschonen',
    'If you wish to have Freeform automatically purge submission data after a specified number of days, enable this setting and specify the number of days after submission date it should purge submissions.' => 'Als u wilt dat Freeform inzendingsgegevens na een bepaald aantal dagen automatisch verwijdert, schakelt u deze instelling in en geeft u het aantal dagen op na de indieningsdatum dat inzendingen moeten worden verwijderd.',
    'Enabling this and saving this settings page will result in purging feature beginning, and cannot be undone (it may not happen immediately, and may take a couple hours before the next process runs).' => 'Als u dit inschakelt en deze instellingenpagina opslaat, wordt het opschonen van de functie gestart en kan dit niet ongedaan worden gemaakt (dit gebeurt mogelijk niet onmiddellijk en het kan een paar uur duren voordat het volgende proces wordt uitgevoerd).',
    'Days After Submission Date to Purge' => 'Dagen na indieningsdatum om te verwijderen',
    'Select the number of days after spammy submissions have been submitted for Freeform to begin automatically purging. This process will only run every hour, and only when Freeform is accessed on the front end in templates or in the control panel.' => 'Selecteer het aantal dagen nadat inzendingen met spam zijn ingediend voordat Freeform automatisch begint met opschonen. Dit proces wordt alleen elk uur uitgevoerd en alleen wanneer Freeform aan de voorkant wordt geopend in sjablonen of in het configuratiescherm.',
    'Please select' => 'Selecteer alstublieft',
    '1 day' => '1 dag',
    '2 days' => '2 dagen',
    '3 days' => '3 dagen',
    '4 days' => '4 dagen',
    '5 days' => '5 dagen',
    '6 days' => '6 dagen',
    '7 days' => '7 dagen',
    '14 days' => '14 dagen',
    '30 days' => '30 dagen',
    '60 days' => '60 dagen',
    '90 days' => '90 dagen',
    '120 days' => '120 dagen',
    '180 days' => '180 dagen',
    '365 days' => '365 dagen',
    'Form Behavior' => 'Formulier Gedrag',
    'Automatically Scroll to top of the Form on AJAX submit?' => 'Automatisch naar de bovenkant van het formulier op AJAX verzenden verzenden?',
    'Enable this when using AJAX to have Freeform use JS to automatically scroll the top of the form on submit. This is especially beneficial when you have longer forms and success/error messages at the top of the form become out of sight.' => 'Schakel dit in wanneer u AJAX gebruikt om Freeform JS te laten gebruiken om automatisch naar de bovenkant van het formulier te scrollen bij het indienen. Dit is vooral handig wanneer u langere formulieren heeft en succes-/foutmeldingen bovenaan het formulier uit het zicht verdwijnen.',
    'Remember the Page Order in Multi-page forms?' => "Denk aan de paginavolgorde in formulieren met meerdere pagina's?",
    "When enabled, Freeform will take into account Conditional Rules page skipping when the user clicks the 'Previous' button on multi-page forms." => "Indien ingeschakeld, houdt Freeform rekening met het overslaan van pagina's met voorwaardelijke regels wanneer de gebruiker op de knop 'Vorige' klikt op formulieren met meerdere pagina's.",
    'Freeform Script Insert Type' => 'Freeform-script invoegtype',
    'Specify the way Freeform scripts are inserted.' => 'Specificeer de manier waarop Freeform-scripts worden ingevoegd.',
    "<b>As Static URLs</b> (recommended) offers built-in browser caching and a static endpoint that delivers the latest Freeform scripts, but are not physical files and therefore cannot have server rules applied. <b>As Files</b> (recommended if having issues with Static URLs) are actual physical files generated inside of the 'cpresources' folder by Craft's asset manager with no caching. <b>Inline</b> will add the scripts as inline scripts and may be useful as a workaround if the other 2 options are not working. This doesn't allow for caching, and pollutes the source code." => "<b>Aangezien statische URL's</b> (aanbevolen) ingebouwde browsercaching bieden en een statisch eindpunt dat de nieuwste Freeform-scripts levert, maar geen fysieke bestanden zijn en daarom geen serverregels kunnen toepassen. <b>As-bestanden</b> (aanbevolen als u problemen heeft met statische URL's) zijn daadwerkelijke fysieke bestanden die in de map 'cpresources' worden gegenereerd door Craft's activabeheerder zonder caching. <b>Inline</b> voegt de scripts toe als inline scripts en kan handig zijn als tijdelijke oplossing als de andere 2 opties niet werken. Dit staat caching niet toe en vervuilt de broncode.",
    'As Static URLs' => "Als statische URL's",
    'As Files' => 'Als bestanden',
    'Inline' => 'In lijn',
    ' (recommended)' => ' (aanbevolen)',
    'Freeform Session Context' => 'Vrije vorm sessiecontext',
    'Choose the way form context is passed between form submits.' => 'Kies de manier waarop formuliercontext wordt doorgegeven tussen formulierverzendingen.',
    'As an encrypted payload (recommended)' => 'Als een versleutelde payload (aanbevolen)',
    "Using PHP's sessions" => 'PHP-sessies gebruiken',
    'Using a database table' => 'Een databasetabel gebruiken',
    'Secret key' => 'Geheime sleutel',
    'Specify a secret key to encrypt the form payload with. Will use server key if left empty.' => 'Geef een geheime sleutel op om de payload van het formulier mee te coderen. Zal de serversleutel gebruiken als deze leeg wordt gelaten.',
    'Session length in minutes' => 'Sessieduur in minuten',
    'Specify when the sessions should expire. Set to 0 for unlimited.' => 'Geef op wanneer de sessies moeten verlopen. Zet op 0 voor onbeperkt.',
    'Amount of active forms per user' => 'Aantal actieve formulieren per gebruiker',
    'Specify the amount of active forms a user can have.' => 'Specificeer het aantal actieve formulieren dat een gebruiker kan hebben.',
    'Save & Continue Later' => 'Opslaan en Later Doorgaan',
    'Number of Days to Keep Saved Form Data' => 'Aantal dagen om opgeslagen formuliergegevens te bewaren',
    'The number of days to store saved form progress in the database before clearing.' => 'Het aantal dagen dat opgeslagen formuliervoortgang in de database moet worden opgeslagen voordat het wordt gewist.',
    'Maximum Number of Saved Forms Per Session' => 'Maximaal aantal opgeslagen formulieren per sessie',
    "The maximum number of saved forms per session (per user, though it's possible a user may have multiple sessions when returning to the site over a span of several days). Default is 10, which should be a comfortable and reasonable number. Once the maximum has been reached, Freeform will begin overwriting existing older entries to create new ones." => 'Het maximum aantal opgeslagen formulieren per sessie (per gebruiker, hoewel het mogelijk is dat een gebruiker meerdere sessies heeft wanneer hij over een periode van meerdere dagen terugkeert naar de site). Standaard is 10, wat een comfortabel en redelijk aantal zou moeten zijn. Zodra het maximum is bereikt, begint Freeform bestaande oudere vermeldingen te overschrijven om nieuwe te maken.',
    'Form Builder' => 'Formulier Bouwer',
    'Display Order of Fields in Form Builder' => 'Volgorde van velden weergeven in Formulier Bouwer',
    'The display order for the list of available fields in the Form Builder.' => 'De weergavevolgorde voor de lijst met beschikbare velden in de formulier bouwer.',
    "Live rendering HTML in HTML blocks, field labels and option labels inside the Form Builder interface can sometimes conflict with Freeform's display of the form preview inside the control panel. In cases like these, you'll need to disable this setting to prevent HTML from rendering automatically." => "Live weergave van HTML in HTML-blokken, veldlabels en optielabels in de Form Builder-interface kan soms conflicten geven met Freeform's weergave van de formulieren voor weergave in het bedieningspaneel. In dit soort gevallen, heb je dit nodig om deze instelling uit te schakelen om te voorkomen dat HTML automatisch wordt weergegeven.",
    'Allow Twig to be Enabled for each HTML block?' => 'Toestaan dat Twig wordt ingeschakeld voor elk HTML-blok?',
    "When enabled, you'll see a checkbox that lets you allow the inclusion of Twig code inside your HTML block fields inside the form builder." => 'Indien ingeschakeld, ziet u een selectievakje waarmee u Twig-code kunt opnemen in uw HTML-blokvelden in de formulierbouwer.',
    'Render HTML block Twig in isolated mode?' => 'HTML-blok Twig in geïsoleerde modus renderen?',
    "When enabled, only the Freeform 'form' and 'fields' variables will be available, the rest of Craft's variables will not be included." => "Indien ingeschakeld, zijn alleen de variabelen Freeform 'form' en 'fields' beschikbaar, de rest van Craft's variabelen wordt niet opgenomen.",
    'Default Formatting Template' => 'Standaard opmaaksjabloon',
    'The default formatting template for new forms.' => 'De standaard opmaaksjabloon voor nieuwe formulieren.',
    'Formatting Templates' => 'Sjablonen Opmaken',
    'Provide a relative path to the Craft Templates folder where your custom formatting templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your form formatting and allows Freeform to locate these files when assigning to a form.' => 'Geef een relatief pad op naar de map Craft Templates waar uw map met aangepaste opmaaksjablonen zich bevindt. Als je de directory nog niet hebt aangemaakt, doe dat dan voordat je deze instelling invult. Hierdoor kunt u Twig-sjabloonbestanden gebruiken voor uw formulieropmaak en kan Freeform deze bestanden lokaliseren bij het toewijzen aan een formulier.',
    'Email Templates' => 'E-mailsjablonen',
    'File Directory Path' => 'Bestandsmappad',
    'Template Storage Type' => 'Sjabloonopslagtype',
    'Choose whether you want to enable email notification templates stored as files, in the database, or have both options available.' => 'Kies of u sjablonen voor e-mailmeldingen wilt inschakelen die zijn opgeslagen als bestanden, in de database, of dat u beide opties beschikbaar wilt hebben.',
    'File' => 'Bestand',
    'Database' => 'Database',
    'File & Database' => 'Bestand en Database',
    'Default Email Template Creation Method' => 'Standaard methode voor het maken van e-mailsjablonen',
    "Select which storage method to use when creating new email notifications with 'Add New Template' option in the form builder." => "Selecteer welke opslagmethode u wilt gebruiken bij het maken van nieuwe e-mailmeldingen met de optie 'Nieuwe sjabloon toevoegen' in de formulierbouwer.",
    'Allow File-based Email Templates to be created inside the CP?' => 'Toestaan dat op bestanden gebaseerde e-mailsjablonen worden gemaakt binnen de CP?',
    'Allowing users to generate template files from inside the CP can potentially cause issues with certain workflows.' => 'Gebruikers toestaan om sjabloonbestanden te genereren vanuit de CP kan mogelijk problemen veroorzaken met bepaalde workflows.',
    'Add an email template' => 'Voeg een e-mailsjabloon toe',
    'Migration Utility' => 'Migratie Hulpprogramma',
    'Convert Database email templates to File email templates' => 'Converteer database-e-mailsjablonen naar bestands-e-mailsjablonen',
    'This is a utility that allows you to migrate your existing database email templates over to file-based email templates (you can continue to edit these from the CP). The utility will also update all existing forms to use the new file version of the email template. If you wish to have Freeform clean up and remove the old database email templates after, check the checkbox as well.' => 'Dit is een hulpprogramma waarmee u uw bestaande database-e-mailsjablonen kunt migreren naar op bestanden gebaseerde e-mailsjablonen (u kunt deze blijven bewerken vanaf de CP). Het hulpprogramma zal ook alle bestaande formulieren bijwerken om de nieuwe bestandsversie van de e-mailsjabloon te gebruiken. Als u Freeform wilt laten opschonen en de oude database-e-mailsjablonen daarna wilt verwijderen, vinkt u ook het selectievakje aan.',
    'Remove database files after migration?' => 'Databasebestanden verwijderen na migratie?',
    'Migrate' => 'Migreren',
    'Success Templates' => 'Sjablonen Succes',
    'Provide a relative path to the Craft Templates folder where your success templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your success formatting and allows Freeform to locate these files when assigning to a form.' => 'Geef een relatief pad op naar de map Craft Templates waar uw map met successjablonen zich bevindt. Als je de directory nog niet hebt aangemaakt, doe dat dan voordat je deze instelling invult. Hierdoor kunt u Twig-sjabloonbestanden gebruiken voor uw succesopmaak en kan Freeform deze bestanden lokaliseren bij het toewijzen aan een formulier.',
    'Is Default' => 'Is standaard',
    'New Status' => 'Nieuwe Status',
    'Form Type' => 'Formuliertype',
    'Form Types' => 'Formulier Typen',
    'Spam Settings' => 'Spam Instellingen',
    'Honeypot' => 'Honeypot',
    'Freeform Honeypot' => 'Freeform Honeypot',
    "Enable this to use Freeform's built in Honeypot spam protection." => 'Schakel dit in om de ingebouwde Honeypot-spambeveiliging van Freeform te gebruiken.',
    'Custom Honeypot Field Name' => 'Aangepaste Honeypot-veldnaam',
    'If you wish to change the default name of the Freeform Honeypot field, specify a value here.' => 'Als u de standaardnaam van het Freeform Honeypot-veld wilt wijzigen, geeft u hier een waarde op.',
    'Custom Honeypot Failed Error Message' => 'Aangepaste foutmelding Honeypot mislukt',
    "If the form fails the Freeform Honeypot upon submit AND the Spam Protection Behavior setting is set to 'Display Errors', show this error message instead of the default." => "Als het formulier faalt in Freeform Honeypot bij het verzenden EN de instelling Spam Protection Behavior is ingesteld op 'Display Errors'",
    'Javascript Enhancement' => 'Javascript-verbetering',
    "Enable this to use Freeform's built-in Javascript enhancement for the Honeypot feature. This will require users have JS enabled for their browser and help fight spambots more aggressively." => 'Schakel dit in om de ingebouwde Javascript-verbetering van Freeform voor de Honeypot-functie te gebruiken. Dit vereist dat gebruikers JS hebben ingeschakeld voor hun browser en helpen spambots agressiever te bestrijden.',
    'If caching your forms, please be sure to manually refresh the Honeypot token generated by Freeform with this feature.' => 'Als u uw formulieren in de cache plaatst, zorg er dan voor dat u de door Freeform gegenereerde Honeypot-token met deze functie handmatig vernieuwt.',
    'Spam Protection Behavior' => 'Spambeveiligingsgedrag',
    "Select the behavior you'd like Freeform to take when it detects a submission as being spam." => 'Selecteer het gedrag dat Freeform moet vertonen wanneer het een inzending als spam detecteert.',
    'Simulate Success (recommended)' => 'Succes simuleren (aanbevolen)',
    'Display Errors (for debugging)' => 'Fouten weergeven (voor foutopsporing)',
    'Bypass All Spam Checks for Logged in Users' => 'Omzeil alle spamcontroles voor ingelogde gebruikers',
    'When enabled, Freeform will not run any spam protection measures for logged in users.' => 'Indien ingeschakeld, voert Freeform geen spambeschermingsmaatregelen uit voor ingelogde gebruikers.',
    'Spam Folder' => 'Spam Map',
    'Use Spam Folder' => 'Gebruik de map Spam',
    'When enabled, all submissions caught by the honeypot or blocked email addresses, keywords and IP addresses will be flagged as spam and stored in the database, but available to manage in a separate menu inside Freeform.' => 'Indien ingeschakeld, worden alle inzendingen die door de honeypot worden opgevangen of geblokkeerde e-mailadressen, trefwoorden en IP-adressen gemarkeerd als spam en opgeslagen in de database, maar kunnen ze worden beheerd in een apart menu in Freeform.',
    'Automatically Purge Spam Submissions' => 'Spaminzendingen automatisch opschonen',
    'If you wish to have Freeform automatically purge submissions flagged as spam after a specified number of days, enable this setting and specify the number of days after submission date it should purge spammy submissions.' => 'Als u wilt dat Freeform automatisch als spam gemarkeerde inzendingen na een bepaald aantal dagen verwijdert, schakelt u deze instelling in en specificeert u het aantal dagen na de indieningsdatum dat inzendingen met spam moeten worden verwijderd.',
    'Enabling this and saving this settings page will result in the purging of submissions flagged as spam feature beginning, and cannot be undone (it may not happen immediately, and may take a couple hours before the next process runs).' => 'Als u dit inschakelt en deze instellingenpagina opslaat, begint het opschonen van inzendingen die als spam zijn gemarkeerd. Dit kan niet ongedaan worden gemaakt (dit gebeurt mogelijk niet onmiddellijk en het kan een paar uur duren voordat het volgende proces wordt uitgevoerd).',
    'Blocking' => 'Blokkeren',
    'Block Email addresses' => 'E-mailadressen blokkeren',
    'Enter email addresses you would like blocked from being used in Email fields. Use asterisks for wildcards (e.g. *@hotmail.ru), and separate multiples on new lines.' => 'Voer e-mailadressen in waarvan u wilt dat ze niet worden gebruikt in e-mailvelden. Gebruik sterretjes voor jokertekens (bijv. *@hotmail.ru) en scheid veelvouden op nieuwe regels.',
    'Display errors about blocked email(s) under each email field?' => 'Fouten weergeven over geblokkeerde e-mail(s) onder elk e-mailveld?',
    "Enable this if you'd like field-based errors to display under the email field(s) that the user has entered blocked emails for. Not recommended for regular use, but helpful if trying to troubleshoot submission issues." => 'Schakel dit in als u wilt dat op velden gebaseerde fouten worden weergegeven onder de e-mailvelden waarvoor de gebruiker geblokkeerde e-mails heeft ingevoerd. Niet aanbevolen voor regelmatig gebruik, maar handig als u problemen met indiening probeert op te lossen.',
    'Blocked Emails Error Message' => 'Foutmelding geblokkeerde e-mails',
    'The message shown to users when blocked emails are submitted. Can use the {email} variable.' => 'Het bericht dat aan gebruikers wordt getoond wanneer geblokkeerde e-mails worden verzonden. Kan de variabele {email} gebruiken.',
    'Block Keywords' => 'Zoekwoorden blokkeren',
    'Enter keywords you would like blocked from being used in all text and textarea fields. Use quotes for phrases (e.g. "generate new leads"), asterisks for wildcards (e.g. lead*), and separate multiples on new lines. When attempting to block individual characters (e.g. Russian letters) or partial words or strings, be sure to make good use of the wildcard character by placing one before and after.' => 'Voer trefwoorden in waarvan u wilt dat ze niet worden gebruikt in alle tekst- en tekstgebiedvelden. Gebruik aanhalingstekens voor woordgroepen (bijv. "genereer nieuwe leads"), sterretjes voor wildcards (bijv. lead*) en afzonderlijke veelvouden op nieuwe regels. Wanneer u probeert afzonderlijke tekens (bijv. Russische letters) of gedeeltelijke woorden of tekenreeksen te blokkeren, zorg er dan voor dat u goed gebruik maakt van het jokerteken door er een voor en achter te plaatsen.',
    'Display errors about blocked keyword(s) under each text/textarea field?' => 'Fouten weergeven over geblokkeerde zoekwoorden onder elk tekst-/tekstgebiedveld?',
    "Enable this if you'd like field-based errors to display under the field(s) that the user has entered blocked keywords for. Not recommended for regular use, but helpful if trying to troubleshoot submission issues." => 'Schakel dit in als u wilt dat op velden gebaseerde fouten worden weergegeven onder de velden waarvoor de gebruiker geblokkeerde trefwoorden heeft ingevoerd. Niet aanbevolen voor regelmatig gebruik, maar handig als u problemen met indiening probeert op te lossen.',
    'Blocked Keywords Error Message' => 'Foutmelding geblokkeerde zoekwoorden',
    'The message shown to users when blocked keywords are submitted. Can use {value} and {keyword} variables.' => 'Het bericht dat aan gebruikers wordt getoond wanneer geblokkeerde zoekwoorden worden ingediend. Kan variabelen {value} en {keyword} gebruiken.',
    'Block IP addresses' => 'IP-adressen blokkeren',
    'Enter IP addresses you would like blocked. Separate multiples on new lines.' => 'Voer IP-adressen in die u wilt blokkeren. Scheid veelvouden op nieuwe regels.',
    'Throttling' => 'Afknijpen',
    'Form Submission Throttling' => 'Formulieren indienen throttling',
    'Globally (affecting all users) prevent spam or attacks by limiting the number of times all forms can be submitted within a given timeframe.' => 'Wereldwijd (betreft alle gebruikers) spam of aanvallen voorkomen door het aantal keren te beperken dat alle formulieren binnen een bepaald tijdsbestek kunnen worden ingediend.',
    'per minute' => 'per minuut',
    'per second' => 'per seconde',
    'unlimited' => 'onbeperkt',
    'Minimum Submit Time' => 'Minimale verzendtijd',
    'The minimum amount of time (in seconds) that has to go by since loading the form for the user to be able to submit the form successfully. Otherwise the submission will be flagged as spam and the Spam Protection Behavior setting will take effect.' => 'De minimale hoeveelheid tijd (in seconden) die moet verstrijken sinds het laden van het formulier voordat de gebruiker het formulier met succes kan indienen. Anders wordt de inzending gemarkeerd als spam en wordt de instelling Spam Protection Behavior van kracht.',
    'Form Submit Expiration' => 'Vervaldatum formulier indienen',
    'The maximum amount of time (in minutes) a user has to submit the form before the form expires and the Spam Protection Behavior setting will take effect. This still has to be less than the Craft CSRF token expiry and PHP Session limit set for your server.' => 'De maximale hoeveelheid tijd (in minuten) die een gebruiker heeft om het formulier in te dienen voordat het formulier verloopt en de instelling Spambeveiligingsgedrag van kracht wordt. Dit moet nog steeds minder zijn dan de vervaldatum van het Craft CSRF-token en de PHP-sessielimiet die voor uw server zijn ingesteld.',
    'Captchas' => "Captcha's",
    'Captcha Settings' => 'Captcha-instellingen',
    'Use Captchas on Forms?' => "Captcha's gebruiken op formulieren?",
    'Enable this to allow the use of reCAPTCHA or hCaptcha on your forms.' => 'Schakel dit in om het gebruik van reCAPTCHA of hCaptcha op uw formulieren toe te staan.',
    'Captcha Type' => 'Captcha-type',
    'Choose which Captcha service and type you want to use.' => 'Kies welke Captcha-service en welk type u wilt gebruiken.',
    'If using reCAPTCHA, please be sure the selection here matches the type on the Google reCAPTCHA site admin console and this site has been added to the approved Domains list.' => 'Als u reCAPTCHA gebruikt, zorg er dan voor dat de selectie hier overeenkomt met het type in de beheerconsole van de Google reCAPTCHA-site en dat deze site is toegevoegd aan de lijst met goedgekeurde domeinen.',
    'Captcha Site Key' => 'Captcha-sitesleutel',
    'Captcha Secret Key' => 'Captcha geheime sleutel',
    'Behavior & Configuration' => 'Gedrag & Configuratie',
    'Only load Captcha scripts once the user interacts with the form?' => 'Captcha-scripts alleen laden als de gebruiker interactie heeft met het formulier?',
    "If you'd like to have the associated Captcha scripts load only once a user begins filling out the form, enable this setting. If you'd like your forms to be ready to go at page load, disable this setting." => 'Als u wilt dat de bijbehorende Captcha-scripts pas worden geladen zodra een gebruiker het formulier begint in te vullen, schakelt u deze instelling in. Schakel deze instelling uit als u wilt dat uw formulieren klaar zijn voor gebruik bij het laden van de pagina.',
    'Failure Behavior' => 'Faalgedrag',
    'Display Error' => 'Fout weergeven',
    'Send to Freeform Spam Folder' => 'Verzenden naar Freeform Spam-map',
    'Minimum Score' => 'Minimale score',
    "Enter the minimum score needed to pass the test. The higher the score, the more aggressive the protection will be. Setting this to '0.0' would allow almost all spam through, while '1.0' could potentially block legitimate users. We recommend a value of '0.5' to '0.7'." => "Voer de minimale score in die nodig is om voor de test te slagen. Hoe hoger de score, hoe agressiever de bescherming zal zijn. Als u dit op '0.0' instelt, wordt bijna alle spam doorgelaten, terwijl '1.0' mogelijk legitieme gebruikers blokkeert. We raden een waarde van '0,5' tot '0,7' aan.",
    'Theme' => 'Thema',
    'Dark' => 'Donker',
    'Light' => 'Licht',
    'Size' => 'Maat',
    'Compact' => 'Compact',
    'Normal' => 'Normaal',
    'Integrations' => 'Integraties',
    'Reliability' => 'Betrouwbaarheid',
    'Notices & Alerts' => 'Probleemmelding',
    'Email Issues' => 'E-mail Problemen',
    'Send Email Alerts for Failed Notifications' => 'Stuur e-mailwaarschuwingen voor mislukte meldingen',
    'Send an email notification alerting the email address(es) below when an email notification cannot be delivered.' => 'Stuur een e-mailmelding naar het/de onderstaande e-mailadres(sen) wanneer een e-mailmelding niet kan worden bezorgd.',
    'Digest Emails' => 'Verwerk E-mails',
    'Developer Digest Email' => 'Ontwikkelaarssamenvatting e-mail',
    "Send weekly or daily emails on the day specified (if using 'Weekly') to the email address(es) below. This will include a snapshot of the previous period's performance and any logged errors and upgrade notices." => "Stuur wekelijkse of dagelijkse e-mails op de aangegeven dag (bij gebruik van 'Wekelijks') naar onderstaand e-mailadres. Dit omvat een momentopname van de prestaties van de vorige periode en eventuele geregistreerde fouten en upgrademeldingen.",
    'Developer Digest Email Frequency' => 'E-mailfrequentie ontwikkelaarssamenvatting',
    "Specify how often and which days (if applicable) you'd like to receive the email notifications. The chosen date will attempt to send a notification in the morning from the period before that date." => 'Geef aan hoe vaak en op welke dagen (indien van toepassing) u de e-mailmeldingen wilt ontvangen. De gekozen datum zal proberen om in de ochtend een notificatie te versturen uit de periode voor die datum.',
    'Stats Digest Email' => 'Statistieken samenvatting e-mail',
    "Send weekly or daily emails on the day specified (if using 'Weekly') to the email address(es) below. This is the same as the Developer one above, but only includes a snapshot of the previous period's performance." => "Stuur wekelijkse of dagelijkse e-mails op de aangegeven dag (bij gebruik van 'Wekelijks') naar onderstaand e-mailadres. Dit is dezelfde als die van de ontwikkelaar hierboven, maar bevat alleen een momentopname van de prestaties van de vorige periode.",
    'Stats Digest Email Frequency' => 'Statistieken Overzicht e-mailfrequentie',
    'Send Notifications on Live Environment only?' => 'Alleen meldingen verzenden in Live-omgeving?',
    'If this setting is enabled, Freeform will only send out Digest emails when the Craft environment is set to production.' => 'Als deze instelling is ingeschakeld, verstuurt Freeform alleen Digest-e-mails wanneer de Craft-omgeving is ingesteld op productie.',
    'Control Panel Notices' => 'Mededelingen van het Configuratiescherm',
    'Display Update Warnings & Notices' => 'Updatewaarschuwingen en kennisgevingen weergeven',
    'Freeform will detect if any important updates, notices or warnings are available for this site specifically, and display them on the dashboard. Examples of this might be expiring API integrations and fixes to bugs that likely affect your current site. We respect your privacy, and this information cannot and never will make it to Solspace.com servers. The checks only happen locally here on your site after automatically downloading a generic JSON file from Solspace.com.' => 'Freeform detecteert of er belangrijke updates, mededelingen of waarschuwingen beschikbaar zijn voor deze site specifiek en geeft deze weer op het dashboard. Voorbeelden hiervan zijn aflopende API-integraties en oplossingen voor bugs die waarschijnlijk van invloed zijn op uw huidige site. We respecteren uw privacy en deze informatie kan en zal nooit de servers van Solspace.com bereiken. De controles gebeuren alleen lokaal hier op uw site na het automatisch downloaden van een generiek JSON-bestand van Solspace.com.',
    'Additional Optional Checks' => 'Aanvullende optionele controles',
    "Help us provide you with more tailored warnings and notices by selecting any of the options below that may affect your site. Freeform's update notices check cannot detect template-level things or flows, so by selecting options below, Freeform will know to check against these as well and provide you with more robust warnings and alerts. We respect your privacy, and this information cannot and never will make it to Solspace.com servers. The checks only happen locally here on your site after automatically downloading a generic JSON file from Solspace.com." => "Help ons u te voorzien van meer op maat gemaakte waarschuwingen en mededelingen door een van de onderstaande opties te selecteren die van invloed kunnen zijn op uw site. Freeform's updatemeldingencontrole kan geen dingen of stromen op sjabloonniveau detecteren, dus door onderstaande opties te selecteren, weet Freeform ook hiertegen te controleren en u robuustere waarschuwingen en waarschuwingen te geven. We respecteren uw privacy en deze informatie kan en zal nooit de servers van Solspace.com bereiken. De controles gebeuren alleen lokaal hier op uw site na het automatisch downloaden van een generiek JSON-bestand van Solspace.com.",
    'Site uses a JS framework (Vue.js, React.js, etc.)' => 'Site gebruikt een JS-framework (Vue.js, React.js, etc.)',
    'Caching on at least some forms' => 'Caching op ten minste enkele formulieren',
    'Custom module or plugin for Freeform' => 'Aangepaste module of plug-in voor Freeform',
    'Alert me on any GDPR-related improvements or fixes' => 'Breng me op de hoogte van alle GDPR-gerelateerde verbeteringen of fixes',
    'Make use of Editing submissions on front-end' => 'Maak gebruik van Inzendingen bewerken op front-end',
    'Display submission data on front-end' => 'Geef indieningsgegevens weer op front-end',
    'Site uses GraphQL' => 'Site gebruikt GraphQL',
    'Sorry, we cannot accept your submission at this time. Not enough time has passed before submitting the form.' => 'Sorry, we kunnen uw inzending op dit moment niet accepteren. Er is niet genoeg tijd verstreken voordat het formulier is verzonden.',
    'Sorry, we cannot accept your submission at this time. Too much time has passed before submitting the form.' => 'Sorry, we kunnen uw inzending op dit moment niet accepteren. Er is te veel tijd verstreken voordat het formulier is verzonden.',
    'There was an error processing your submission. Please try again later.' => 'Er is een fout opgetreden bij het verwerken van uw inzending. Probeer het later opnieuw.',
    'Default Email Notification Creation Method' => 'Standaardmethode voor het maken van e-mailnotificaties',
    'The default page to go to when clicking the Freeform nav item.' => 'De standaardpagina om naar te gaan wanneer geklikt wordt op het Freeform nav item.',
    'Provide a relative path to the Craft Templates folder where your email templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your email formatting and allows Freeform to locate these files when setting up notifications.' => 'Geef een relatief pad op naar de Craft-hoofdmap waar uw map met e-mail templates zich bevindt. Hiermee kunt u Twig templatebestanden gebruiken voor uw e-mailopmaak, en helpt Form Builder deze bestanden te vinden bij het instellen van notificaties.',
    "Which storage method to use when creating new email notifications with 'Add New Notification' option in Form Builder." => "Welke opslagmethode moet worden gebruikt bij het maken van nieuwe e-mail notificaties met de optie 'Voeg nieuwe notificatie toe' in Form Builder.",
    'The display order for the list of available fields in Form Builder.' => 'De weergave volgorde voor de lijst met beschikbare velden in Form Builder.',
    'Show Form Builder Tutorial' => 'Toon Form Builder handleiding',
    'Enable this to show the interactive tutorial again in the Form Builder. This setting disables again when the tutorial is completed or skipped.' => 'Schakel dit in om de interactieve handleiding opnieuw te tonen in Form Builder. Deze instelling zet zichzelf terug wanneer de handleiding is voltooid of overgeslagen.',
    'Render HTML inside Form Builder & Submissions view?' => 'HTML weergeven in de weergave Componist & Inzendingen?',
    'AJAX Enabled for Forms by Default' => 'AJAX standaard ingeschakeld voor formulieren',
    'By default, the "Enable AJAX" feature checkbox will be checked for new forms.' => 'Standaard wordt het selectievakje "AJAX inschakelen" aangevinkt voor nieuwe formulieren.',
    'Include Default Freeform Formatting Templates' => 'Standaardsjablonen voor vrije opmaak opnemen',
    'Disable this to hide the default Freeform formatting templates in the Formatting Template options list inside Form Builder.' => 'Schakel dit uit om de standaard Freeform-opmaaksjablonen te verbergen in de lijst met opmaaksjabloonopties in Form Builder.',
    'Remove Newlines from Textareas for Exporting' => 'Newlines verwijderen uit tekstgebieden voor export',
    'Enable this to have newlines removed from Textarea fields in submissions when exporting.' => 'Schakel dit in om nieuwe regels uit tekstvelden in inzendingen te laten verwijderen bij het exporteren.',
    'Fill Form Values from the GET Query String?' => 'Formulierwaarden invullen uit de GET Query String?',
    'Enable this to be able to fill form field values from a GET query string in URI.' => 'Schakel dit in om formulierveldwaarden uit een GET-queryreeks in URI te kunnen invullen.',
    'Disable Submit Button on Form Submit?' => 'Knop Verzenden op formulier verzenden uitschakelen?',
    'Enable this to automatically disable the form\'s submit button when the form is submitted. This will prevent the form from double-submitting.' => 'Schakel dit in om het formulier automatisch uit te schakelen \' s-toets in te dienen wanneer het formulier wordt ingediend. Dit voorkomt dat het formulier dubbel wordt verzonden.',
    'Automatically Scroll to Form on Errors and Multipage forms?' => "Automatisch naar formulier scrollen bij fouten en formulieren met meerdere pagina's?",
    'Enable this to have Freeform use JS to automatically scroll the page down to the form upon submit when there are errors or the form is continuing to the next page in multipage forms.' => "Schakel dit in om Freeform JS te laten gebruiken om de pagina automatisch naar het formulier te laten scrollen bij het verzenden als er fouten zijn of het formulier verder gaat naar de volgende pagina in formulieren met meerdere pagina's.",
    'Freeform Script Insertion Location' => 'Freeform Script Invoeglocatie',
    'The location of where you want Freeform to insert its scripts for form and field functionality.' => 'De locatie van waar u wilt dat Freeform de scripts voor formulier- en veldfunctionaliteit invoegt.',
    'Page Footer' => 'Pagina Footer',
    'Inside Form' => 'Inside Form',
    'None (add manually)' => 'Geen (handmatig toevoegen)',

    // Statussen controller
    'Create a new status' => 'Creëer een nieuwe status',
    'The name of the status.' => 'De naam van de status.',
    'How you’ll refer to this status in the templates.' => 'Hoe u naar deze status in de sjablonen zult verwijzen.',
    'The color of the status circle when viewing inside CP.' => 'De kleur van de statuscirkel bij het bekijken binnen CP.',
    'Set this status to be selected by default when creating new forms?' => 'Deze status standaard laten instellen bij het maken van nieuwe formulieren?',
    'Status' => 'Status',
    'Statuses' => 'Statussen',
    'Status saved' => 'Status opgeslagen',
    'Status not saved' => 'Status niet opgeslagen',
    'Status with ID {id} not found' => 'Status met ID {id} niet gevonden',
    'green' => 'groen',
    'orange' => 'oranje',
    'red' => 'rood',
    'blue' => 'blauw',
    'yellow' => 'geel',
    'pink' => 'roze',
    'purple' => 'paars',
    'turquoise' => 'turkoois',
    'light' => 'licht',
    'grey' => 'grijs',
    'black' => 'zwart',

    // Inzendingen controller
    'Submissions' => 'Inzendingen',
    'Submission Date' => 'Inzendingsdatum',
    'Submission updated' => 'Inzending aangepast',
    'Submission could not be updated' => 'Inzending kon niet worden aangepast',
    'Submission with ID {id} not found' => 'Inzending met ID {id} niet gevonden',
    'Submissions deleted successfully.' => 'Inzendingen succesvol verwijderd.',

    // Element type
    'Title' => 'Titel',
    'Form' => 'Formulier',
    'All Submissions' => 'Alle inzendingen',
    'Submission date' => 'Inzendingsdatum',
    'Freeform Submissions' => 'Freeform inzendingen',
    'Add a submission' => 'Voeg een inzending toe',
    'Submissions deleted' => 'Inzendingen verwijderd',
    'Are you sure you want to delete these submissions?' => 'Ben je zeker dat je deze inzendingen wilt verwijderen?',
    'Are you sure you want to delete this?' => 'Weet je zeker dat je dit wilt verwijderen?',

    // Eigenschappen
    "Properties for key '{key}' is not an array" => "Eigenschappen voor key'{key}' is geen array",
    "Properties for key '{key}' do not contain TYPE" => "Eigenschappen voor key '{key}' bevatten geen TYPE",
    "Could not find properties for key '{hash}'" => "Kon geen eigenschappen vinden voor key '{hash}'",
    "Could not find properties for page '{index}'" => "Kon geen eigenschappen vinden voor pagina '{index}'",
    "Could not find properties for field '{hash}'" => "Kon geen eigenschappen vinden voor veld '{hash}'",
    'Could not find properties for form' => 'Kon geen eigenschappen vinden voor formulier',
    'Could not find properties for integrations' => 'Kon geen eigenschappen vinden voor integraties',
    "Value for '{key}' should be '{valueType}' but is '{expectedType}'" => "Waarde voor '{key}' zou '{valueType}' moeten zijn maar is '{expectedType}'",

    // Formulieren
    'Trying to post an invalid form' => 'Een incorrect formulier proberen te verzenden',
    "The provided page index '{pageIndex}' does not exist in form '{formName}'" => "De gegeven pagina index '{pageIndex}' bestaat niet in formulier '{formName}'",

    // Integraties
    '{setting} setting not specified' => '{setting} instelling niet gespecificeerd',
    'Could not connect to API endpoint' => 'Kon geen verbinding maken met API-eindpunt',
    'Could not add emails to lists' => 'Kan e-mails niet toevoegen aan lijsten',
    'Could not fetch {serviceProvider} lists' => 'Kon {serviceProvider} lijsten niet ophalen',
    'Unknown integration type specified' => 'Onbekend integratietype gespecificeerd',
    'Could not find setting blueprints for {handle}' => 'Kon geen blauwprint instellingen vinden voor {handle}',
    "No 'access_token' present in auth response for {serviceProvider}" => "Geen 'access_token' beschikbaar in authenticatie antwoord van {serviceProvider}",
    "'{key}' key missing in Freeform's plugin configuration" => "'{key}' key niet beschikbaar in Freeform plugin configuratie",

    // Instellingen model
    "Directory '{directory}' does not exist" => "Map '{directory}' bestaat niet",
    'Could not get demo template content. Please contact Solspace.' => 'Kon demo inhoud niet ophalen. Neem contact op met Solspace.',

    // Inzendingen record
    '{attribute} cannot be blank' => '{attribute} mag niet leeg zijn',

    // CRM service
    'CRM Integration with ID {id} not found' => 'CRM Integratie met ID {id} niet gevonden',
    "No field mapping specified for '{integration}' integration" => "Geen veld map gespecificeerd voor '{integration}' integratie",

    // Bestanden service
    'Could not handle file upload' => 'Kon bestandsupload niet verwerken',

    // Formulieren service
    "Can't use render() if no form template specified" => 'Kan render() niet gebruiken als er geen formulier template is gespecificeerd',
    "Form template '{name}' not found" => "Formulier template '{name}' niet gevonden",

    // Mailer service
    'Email notification template with ID {id} not found' => 'E-mail notificatie template met ID {id} niet gevonden',

    // Mailingliisten service
    'Email Marketing integration with ID {id} not found' => 'Mailinglijst integratie met ID {id} niet gevonden',

    // Text field
    'The allowed maximum length is {{max}} characters. Current size is {{difference}} characters too long.' => 'De toegestane maximale lengte is {{max}} tekens. Huidige grootte is {{difference}} tekens te lang.',

    // reCAPTCHA field
    'Please verify that you are not a robot.' => 'Controleer of u geen robot bent.',

    // Confirm field
    'This value must match the value for {targetFieldLabel}' => 'Deze waarde moet overeenkomen met de waarde voor {targetFieldLabel}',

    // Email field
    '{email} is not a valid email address' => '{email} is geen geldig e-mailadres',

    // Date field
    '"{value}" does not conform to "{format}" format.' => '"{value}" komt niet overeen met de indeling "{format}".',
    'Date "{date}" must be after "{minDate}"' => 'Datum "{date}" moet na "{minDate}"',
    'Date "{date}" must be before "{maxDate}"' => 'Datum "{date}" moet zijn voor "{maxDate}"',
    'Min Date' => 'Min Datum',
    'Max Date' => 'Max Datum',
    'Specify a relative textual date string or static date for the earliest date available for date picker and field validation.' => 'Geef een relatieve tekstuele datumreeks of statische datum op voor de vroegst beschikbare datum voor datumkiezer en veldvalidatie.',
    'Specify a relative textual date string or static date for the latest date available for date picker and field validation.' => 'Geef een relatieve tekstuele datumreeks of statische datum op voor de laatst beschikbare datum voor datumkiezer en veldvalidatie.',

    // Phone field
    'Invalid phone number' => 'Ongeldig telefoonnummer',
    'Phone number is invalid.' => 'Telefoonnummer is ongeldig.',

    // Rating field
    'Rating must be between {{min}} and {{max}}' => 'Beoordeling moet tussen {{min}} en {{max}} liggen',

    // Website field
    'Website not valid' => 'Website niet geldig',

    // File Upload field
    "'{extension}' is not an allowed file extension" => "'{extension}' is geen toegelaten bestandsextensie",
    'You tried uploading {fileSize}KB, but the maximum file upload size is {maxFileSize}KB' => 'Je probeerde {fileSize}KB aan bestanden te uploaden, maar de maximum bestandsgrootte is {maxFileSize}KB',
    'Tried uploading {count} files. Maximum {max} files allowed.' => 'Probeerde {count} bestanden te uploaden. Maximaal {max} bestanden toegestaan.',
    'Could not upload file' => 'Kon bestand niet uploaden',
    'The file was only partially uploaded' => 'Het bestand is slechts gedeeltelijk geüpload',
    'File size too large' => 'Bestandsgrootte te groot',

    // File Upload Drag and Drop field
    'Maximum file upload limit of {limit} reached' => 'Maximale uploadlimiet van {limit} bereikt',
    'Maximum file upload size is {maxFileSize}KB' => 'Maximale bestandsuploadgrootte is {maxFileSize}KB',
    'Upload in progress...' => 'Bezig met uploaden...',
    'Upload complete!' => 'Upload compleet!',
    'Multiple field uploads not supported' => 'Meerdere velduploads worden niet ondersteund',
    'Unknown file type' => 'Onbekend bestandstype',

    // Number field
    'Value must be numeric' => 'Waarde moet numeriek zijn',
    'The value must be no more than {{max}}' => 'De waarde mag niet meer zijn dan {{max}}',
    'The value must be no less than {{min}}' => 'De waarde mag niet kleiner zijn dan {{min}}',
    'The value must be between {{min}} and {{max}}' => 'De waarde moet tussen {{min}} en {{max}} liggen',
    '{{dec}} decimal places allowed' => '{{dec}} decimalen toegestaan',
    'Only positive numbers allowed' => 'Alleen positieve getallen toegestaan',
    'The value must be no more than {{max}} characters' => 'De waarde mag niet meer dan {{max}} tekens bevatten',
    'The value must be no less than {{min}} characters' => 'De waarde mag niet minder zijn dan {{min}} tekens',
    'The value must be between {{min}} and {{max}} characters' => 'De waarde moet tussen {{min}} en {{max}} tekens zijn',

    // Velden
    'Create a new field' => 'Maak een nieuw veld aan',
    'Default instructions / help text for this field.' => 'Standaardinstructies/ help tekst voor dit veld.',
    'Set this field as required by default.' => 'Zet dit veld standaard in als vereist.',
    'What type of field is this?' => 'Wat voor soort veld is dit?',
    'How you’ll refer to this field in the templates.' => 'Hoe dit veld refereert in de templates.',
    'The default label for this field.' => 'Het standaard label voor dit veld.',
    'Options' => 'Opties',
    'Options for this field. Option values should be unique.' => 'Opties voor dit veld. Optiewaarden moeten uniek zijn.',
    'Add an option' => 'Voeg een optie toe',
    'Custom values' => 'Aangepaste waarden',
    'Define the default available options.' => 'Definieer de standaard beschikbare opties.',
    'Enable this to check the checkbox by default.' => 'Schakel dit in om het selectievakje standaard aan te kruisen.',
    'Enable this to specify custom values for each option label.' => 'Schakel dit in om aangepaste waarden te bepalen voor elk optielabel.',
    'Dynamic Recipients' => 'Dynamische ontvangers',
    'Define the default available email address options.' => 'Definieer de standaard beschikbare e-mailadres opties.',
    'Placeholder' => 'Plaatsaanduider',
    'Field placeholder' => 'Veld tijdelijke aanduiding',
    'The default text that will be shown if the field doesn’t have a value.' => 'De standaard tekst dat getoond wordt als het veld geen waarde heeft.',
    'Asset Source' => 'Bestandsbron',
    'Select a default asset source for uploaded files.' => 'Selecteer een standaard bestandsbron voor geüploade bestanden.',
    'Upload Location Subfolder' => 'Upload locatiesubmap',
    'The subfolder path that files should be uploaded to. May contain {{ form.handle }} or {{ form.id }} variables as well.' => 'Het submappad waarnaar bestanden moeten worden geüpload. Kan ook {{ form.handle }} of {{ form.id }} variabelen bevatten.',
    'Specify the maximum uploadable file count.' => 'Geef het maximale aantal te uploaden bestanden op.',
    'Default Value' => 'Standaardwaarde',
    'The default value for the field.' => 'De standaardwaarde voor het veld.',
    'Rows' => 'Rijen',
    'The default number of rows this textarea should have.' => 'Het standaard aantal rijen dat dit tekstveld moet hebben.',
    'Maximum File Size' => 'Maximum bestandsgrootte',
    'Specify the maximum file size, in KB.' => 'Geef de maximale bestandsgrootte op in KB.',
    'Specify the default maximum file size, in KB.' => 'Specifieer de standaard maximum bestandsgrootte, in KB.',
    'Allowed File Types' => 'Toegelaten bestandstypes',
    'Leave everything unchecked to allow all file kinds.' => 'Laat alles uitgeschakeld om alle bestandstypen toe te staan.',
    'Select the file types to be allowed by default. Leaving all unchecked will allow all file types.' => 'Selecteer de standaard toegelaten bestandstypes. Alles onaangekruist laten wil zeggen dat alle bestandstypes toegelaten zijn.',
    'The handle "{handle}" is a reserved keyword and cannot be used.' => 'De ingang "{handle}" is een gereserveerd trefwoord en kan niet gebruikt worden.',
    'While data is passed along to the Email Marketing provider, Freeform does not store whether or not Email Marketing fields were opted in.' => 'Terwijl gegevens worden doorgegeven aan de mailinglijstprovider, slaat Freeform niet op of de velden voor de mailinglijst al dan niet zijn aangemeld.',
    'New Field' => 'Nieuw Veld',
    'Required' => 'Verplicht',
    'Read only' => 'Alleen-lezen',

    // Form Builder
    'No Value set' => 'Geen waarde ingesteld',
    'No Target Field' => 'Geen doelveld',
    'No Template' => 'Geen template',
    'No Asset Source' => 'Geen activabron',
    'Hidden field' => 'Verborgen veld',
    'Handle is not set' => 'Handle is niet ingesteld',
    'Handle is a reserved keyword' => 'Handle is een gereserveerd trefwoord',
    '"${resourceName}" list for ${name}' => '"${resourceName}" lijst voor ${name}',
    'No mailing list for ${name}' => 'Geen mailinglijst voor ${name}',
    'No email field' => 'Geen emailveld',
    'Field type "${type}" not found' => 'veld type "${type}" niet gevonden',
    'Are you sure you want to remove this page and all fields on it?' => 'Weet je zeker dat je deze pagina en alle velden erop wilt verwijderen?',
    'Add New Field' => 'Nieuw Veld',
    'Type' => 'Type',
    'Label' => 'Label',
    'Label (Optional)' => 'Label (optioneel)',
    'Field label used to describe the field.' => 'Veldlabel dat wordt gebruikt om het veld te beschrijven.',
    'The value for this field.' => 'De waarde voor dit veld.',
    'Instructions' => 'Instructies',
    'Field specific user instructions.' => 'Veldspecifieke gebruikersinstructies.',
    'If present, this will be the value pre-populated when the form is rendered.' => 'Indien aanwezig, is dit de vooraf ingevulde waarde wanneer het formulier wordt weergegeven.',
    'The text that will be shown if the field doesn’t have a value.' => 'De tekst die wordt weergegeven als het veld geen waarde heeft.',
    'Target Field' => 'Doel veld',
    'The target Freeform field to be confirmed by re-entering its value.' => 'Het doel Freeform-veld moet worden bevestigd door de waarde opnieuw in te voeren.',
    'Date Time Type' => 'Datum tijd type',
    'Choose between using date, time or both.' => 'Kies tussen datum, tijd of beide.',
    "Use Freeform's built-in automatic AJAX submit feature. This will prevent the value in the Return URL field from working unless a template-level override is set." => 'Gebruik de ingebouwde automatische AJAX-verzendfunctie van Freeform. Dit voorkomt dat de waarde in het veld Retour-URL werkt, tenzij er een override op sjabloonniveau is ingesteld.',
    'Conditional Rules' => 'Voorwaardelijke Regels',
    'Show field handles?' => 'Veldhandvatten tonen?',
    'Enable this to also show the field handle for all fields for better clarity if you have several fields with the same label.' => 'Schakel dit in om ook de veldhandle voor alle velden weer te geven voor meer duidelijkheid als u meerdere velden met hetzelfde label heeft.',
    'Both' => 'Beide',
    'Time' => 'Tijd',
    "You can use 'now', 'today', '5 days ago', '2017-01-01 20:00:00', etc, which will format the default value according to the chosen format." => "U kunt 'nu', 'vandaag', '5 dagen geleden', '2017-01-01 20:00:00', enz. Gebruiken, waarmee de standaardwaarde wordt opgemaakt volgens het gekozen formaat.",
    'Use the Freeform datepicker for this field?' => 'Freeform datumprikker gebruiken voor dit veld?',
    'Generate placeholder from your date format settings?' => 'Plaatsaanduiding genereren op basis van uw datumnotatie-instellingen?',
    'Date Order' => 'Orderdatum',
    'Choose the order in which to show day, month and year.' => 'Kies de volgorde waarin u dag, maand en jaar wilt weergeven.',
    'year month day' => 'jaar maand dag',
    'month day year' => 'maand dag jaar',
    'day month year' => 'dag maand jaar',
    'Four digit year?' => 'Vier cijferig jaar?',
    'Date leading zero' => 'Datum leidend nul',
    'If enabled, a leading zero will be used for days and months.' => 'Indien ingeschakeld, wordt dagenlang een voorloop nul gebruikt.',
    'Date Separator' => 'Datum scheidingsteken',
    'Used to separate date values.' => 'Gebruikt om datumwaarden te scheiden.',
    'None' => 'Geen',
    '24h Clock?' => '24uur klok?',
    'Clock Separator' => 'Klok scheidingsteken',
    'Used to separate hours and minutes.' => 'Gebruikt om uren en minuten te scheiden.',
    'Lowercase AM/PM?' => 'Kleine letters AM/PM?',
    'Separate AM/PM with a space?' => 'AM/PM scheiden met een spatie?',
    'Email Template' => 'Email Sjabloon',
    'Legends' => 'Legenden',
    'Legend' => 'Legende',
    'Render as' => 'Render als',
    'Select' => 'Selecteer',
    'Radios' => 'Radio’s',
    'Checkboxes' => 'Selectievakken',
    'Options for this checkbox group' => 'Opties voor deze checkbox groep',
    'Select an asset source to be able to store user uploaded files.' => 'Selecteer een activabron om door gebruikers geüploade bestanden te kunnen opslaan.',
    'Select an Asset Source...' => 'Selecteer een activabron...',
    'File Count' => 'Aantal bestanden',
    'Specify the maximum uploadable file count' => 'Geef het maximale aantal uploadbare bestanden op',
    'Maximum filesize' => 'Maximale bestandsgrootte',
    'Specify the maximum filesize in KB' => 'Specificeer de maximale bestandsgrootte in KB',
    'Allowed File Kinds' => 'Toegestane bestandssoorten',
    'Leave everything unchecked to allow all file kinds' => 'Laat alles uitgeschakeld om alle bestandstypen toe te staan',
    'Name or title of the form.' => 'Naam of titel van het formulier.',
    'How you’ll refer to this form in the templates.' => 'Hoe u dit formulier in de sjablonen zult raadplegen.',
    'Submission Title' => 'Inzending titel',
    'What the auto-generated submission titles should look like.' => 'Hoe de automatisch gegenereerde indieningstitels eruit moeten zien.',
    'Return URL' => 'Terugkeer URL',
    'The URL the form will redirect to after successful submit. This will not work when the Built-in AJAX setting is enabled unless a template-level override is set.' => 'De URL waarnaar het formulier wordt omgeleid na het verzenden.',
    'Default Status' => 'Standaard Status',
    'The default status to be assigned to new submissions.' => 'De standaardstatus die moet worden toegewezen aan nieuwe inzendingen.',
    'Formatting Template' => 'Template opmaken',
    'The formatting template to assign to this form when using Render method (optional).' => 'De opmaaksjabloon die moet worden toegewezen aan dit formulier bij gebruik van de Render-methode (optioneel).',
    'Collect IP Addresses' => 'Verzamel IP Adressen',
    'Should this form collect the user\'s IP address?' => 'Moet dit formulier het formulier van de gebruiker verzamelen?',
    'Store Submitted Data' => 'Ingediende gegevens opslaan',
    'Should the submission data for this form be stored in the database?' => 'Moeten de ingediende gegevens voor dit formulier worden opgeslagen in de database?',
    'Opt-In Data Storage Checkbox' => 'Opt-In Gegevensopslag Checkbox',
    'Allow users to decide whether the submission data is saved to your site or not.' => "Gebruikers toestaan \u{200b}\u{200b}te beslissen of de ingediende gegevens op uw site worden opgeslagen of niet.",
    'Enable Google Tag Manager to push successful form submission events to the Data Layer' => 'Schakel Google Tag Manager in om succesvolle formulierinzendingen naar de gegevenslaag te pushen',
    'Form tag Attributes' => 'Formulier tag attributen',
    'Add any tag attributes to the HTML element.' => 'Voeg eventuele tagattributen toe aan het HTML-element.',
    'Show Loading Indicator on Submit' => 'Toon laadindicator bij verzenden',
    'Show a loading indicator on the submit button upon submittal of the form.' => 'Toon een laadindicator op de verzendknop bij het indienen van het formulier.',
    'Show Loading Text' => 'Toon laadtekst',
    "Enabling this will change the submit button's label to the text of your choice." => 'Als u dit inschakelt, wordt het label van de verzendknop gewijzigd in de tekst van uw keuze.',
    'Loading Text' => 'Tekst laden',
    'Attribute' => 'Attribuut',
    'Disabled' => 'Uitgeschakeld',
    'Limit Form Submission Rate' => 'Verzendingslimiet formulier',
    'Limit the number of times a user can submit the form.' => 'Beperk het aantal keren dat een gebruiker het formulier kan verzenden.',
    'Do not limit' => 'Niet beperken',
    'Logged in Users only (no limit)' => 'Alleen ingelogde gebruikers (geen limiet)',
    'Once per Cookie only' => 'Alleen per cookie',
    'Once per IP/Cookie combo' => 'Eén keer per IP / Cookie-combinatie',
    'Once per logged in Users only' => 'Een keer per ingelogde gebruiker',
    'Once per logged in User or Guest Cookie only' => 'Eén keer per ingelogde Gebruiker of Gastcookie',
    'Once per logged in User or Guest IP/Cookie combo' => 'Een keer per ingelogde Gebruiker of Gast IP/Cookie combo',
    'Stop Submissions After' => 'Stop inzendingen daarna',
    'Set a date after which the form will no longer accept submissions.' => 'Stel een datum in waarna het formulier geen inzendingen meer accepteert.',
    'Form Color' => 'Formulierkleur',
    'Used for Widget Charts' => 'Gebruikt voor Widgets',
    'Description / Notes' => 'Beschrijving / opmerkingen',
    'Description or notes for this form.' => 'Beschrijving of opmerkingen voor dit formulier.',
    'Hash' => 'Hash',
    'Used to access this field on the frontend.' => 'Gebruikt om toegang te krijgen tot dit veld op de frontend.',
    'Field Mapping' => 'Veldmapping',
    'Map CRM fields to your Freeform fields.' => 'Wijs CRM-velden toe aan uw Freeform-velden.',
    'Map Email Marketing fields to your Freeform fields.' => 'Map mailinglijstvelden toewijzen aan uw Freeform-velden.',
    'Form Fields' => 'Formulier Velden',
    'Integration' => 'Integratie',
    'Choose an integration type' => 'Kies een integratietype',
    'Choose an integration...' => 'Kies een integratie...',
    'Refreshing...' => 'Verversen...',
    'Refresh Integration' => 'Ververs integratie',
    'Choose the opt-in mailing list that users will be added to.' => 'Kies de opt-in mailinglijst waaraan gebruikers worden toegevoegd.',
    'Select a list...' => 'Selecteer een lijst...',
    'Target Email Field' => 'Target Emailveld',
    'The email field used to push to the mailing list.' => 'Het e-mailveld dat werd gebruikt om naar de mailinglijst te gaan.',
    'Select a field...' => 'Selecteer een veld...',
    'Decimal Separator' => 'Decimal scheidingsteken',
    'Used to separate decimals.' => 'Gebruikt om decimalen te scheiden.',
    'Allow negative numbers?' => 'Negatieve getallen toestaan?',
    'Min/Max Values' => 'Min/Max waardes',
    'The minimum and/or maximum numeric value this field is allowed to have (optional).' => 'De minimale en / of maximale numerieke waarde die dit veld mag hebben (optioneel).',
    'Min/Max Length' => 'Min/Max lengte',
    'The minimum and/or maximum character length this field is allowed to have (optional).' => 'De minimale en/of maximale tekenlengte die dit veld mag hebben (optioneel).',
    'Step' => 'Stap',
    'The step' => 'De stap',
    'Decimal Count' => 'Decimale telling',
    'The number of decimal places allowed.' => 'Het aantal toegestane decimalen.',
    'Leave blank for no decimals.' => 'Laat leeg voor geen decimalen.',
    'Thousands Separator' => 'Duizenden scheidingsteken',
    'Used to separate thousands.' => 'Gebruikt om duizenden te scheiden.',
    'Label for this page tab.' => 'Label voor dit paginatabblad.',
    'Use JS validation' => 'Gebruik JS validatie',
    'Enable this to force JS to validate the input on this field based on the pattern.' => 'Schakel dit in om JS te dwingen de invoer op dit veld te valideren op basis van het patroon.',
    'Pattern' => 'Patroon',
    "Custom phone pattern (e.g. '(000) 000-0000' or '+0 0000 000000'), where '0' stands for a digit between 0-9. If left blank, any number and dash, dot, space, parentheses and optional + at the beginning will be validated." => "Aangepast telefoonpatroon (bijvoorbeeld '(000) 000-0000' of '+0 0000 000000' ), waarbij '0' staat voor een cijfer tussen 0-9. Indien leeg gelaten, word elk getal, streepje, punt, spatie, haakjes en optioneel + aan het begin gevalideerd.",

    'Optional' => 'Optioneel',
    'Maximum Number of Stars' => 'Maximaal aantal sterren',
    'Set how many stars there should be for this rating.' => 'Stel in hoeveel sterren er voor deze beoordeling moeten zijn.',
    'Unselected Color' => 'Niet-geselecteerde kleur',
    'Hover Color' => 'Zeef kleur',
    'Selected Color' => 'Geselecteerde kleur',
    'Enter any regex pattern here.' => 'Voer hier een regex-patroon in.',
    'e.g. /^[a-zA-Z0-9]*$/' => 'e.g. /^[a-zA-Z0-9]*$/',
    'Error Message' => 'Foutmelding',
    'The message a user should receive if an incorrect value is given. It will replace any occurrences of \'{{pattern}}\' with the supplied regex pattern inside the message if any are found.' => 'Het bericht dat een gebruiker moet ontvangen als een onjuiste waarde wordt opgegeven. Het zal alle gevallen van \'{{pattern}}\' vervangen door het meegeleverde regex-patroon in het bericht als er een wordt gevonden.',
    'Value is not valid' => 'Waarde is niet geldig',
    'Submit button Label' => 'Button labelindienen',
    'The label of the submit button' => 'Het label van de verzendknop',
    'Disable the Previous button' => 'Schakel de knop Vorige uit',
    'Previous button Label' => 'Vorige knop Label',
    'The label of the previous button' => 'Het label van de vorige knop',
    'Maximum Length' => 'Maximale lengte',
    'The maximum number of characters for this field.' => 'Het maximale aantal tekens voor dit veld.',
    'The number of rows in height for this field.' => 'Het aantal rijen in hoogte voor dit veld.',
    'Hide field' => 'Verberg veld',
    'Hide the mailing list checkbox from the form and make it always trigger a subscription' => 'Verberg het aankruisvakje van de verzendlijst in het formulier en zorg ervoor dat het altijd een abonnement activeert',
    'Mailing Lists' => 'Mail Lijst',
    'Map Mailing List fields to your Freeform fields.' => 'Wijs mailinglijstvelden toe aan uw vrije formuliervelden.',
    'Default' => 'Standaard',
    'Live HTML rendering currently disabled.' => 'Live HTML-rendering momenteel uitgeschakeld.',
    'Quick save' => 'Snel opslaan',
    'Saving...' => 'Opslaan...',
    'Cancel' => 'Annuleer',
    'Save and finish' => 'Opslaan en afsluiten',
    'Save as a new form' => 'Opslaan als een nieuw formulier',
    'Saved successfully' => 'Successvol opgeslagen',
    'Name must not be empty' => 'Naam mag niet leeg zijn',
    'Label must not be empty' => 'Label mag niet leeg zijn',
    'Handle must not be empty' => 'Handle mag niet leeg zijn',
    'Field type must not be empty' => 'Veldtype mag niet leeg zijn',
    'Field added successfully' => 'Veld succesvol toegevoegd',
    'Special Fields' => 'Speciale velden',
    'Craft Field' => 'Craft veld',
    'Freeform Field' => 'Freeform veld',
    'Field mapping' => 'Veldmapping',
    'Activate users?' => 'Gebruikers activeren?',
    'The user will be activated upon creation if this is checked. Will be set to pending otherwise.' => 'De gebruiker wordt bij het aanmaken geactiveerd als dit is aangevinkt. Wordt anders ingesteld op in behandeling.',
    'Disable entries?' => 'Invoer uitschakelen?',
    'The entry will be set to disabled upon creation if this is checked. Will be set to enabled otherwise.' => 'Het item wordt bij het aanmaken uitgeschakeld als dit is aangevinkt. Wordt anders ingeschakeld.',
    'CRM Field' => 'CRM Veld',
    'FF Field' => 'FF Veld',
    'Use custom values' => 'Gebruik aangepaste waarden',
    "Select the Email field that will contain the user's email address in order to send the email notification. Good practice would be to have the email field on the first page of the form." => 'Selecteer het veld E-mail dat het e-mailadres van de gebruiker zal bevatten om de e-mailmelding te verzenden. Een goede gewoonte zou zijn om het e-mailveld op de eerste pagina van het formulier te plaatsen.',
    'Select an email field...' => 'Selecteer een e-mailveld...',
    'Positioning' => 'Positionering',
    'Choose how the previous and submit buttons should be placed.' => 'Kies hoe de vorige en verzendknoppen moeten worden geplaatst.',
    'Left' => 'Links',
    'Center' => 'Centrum',
    'Right' => 'Rechts',
    'Apart at Left and Right' => 'Uit elkaar links en rechts',
    'Together at Left' => 'Samen op Links',
    'Together at Center' => 'Samen in het Centrum',
    'Together at Right' => 'Samen op Rechts',
    'Choose whether the submit button is positioned on the left, center or right side.' => 'Kies of de verzendknop zich aan de linker-, centrum- of rechterkant bevindt.',
    'Save button Label' => 'Knop Label opslaan',
    'The label of the Save & Continue Later button.' => 'Het label van de knop Opslaan en later doorgaan.',
    'The URL the user will be redirected to after saving. Can use {token} and {key}.' => 'De URL waarnaar de gebruiker wordt omgeleid na het opslaan. Kan {token} en {key} gebruiken.',
    'Add new template' => 'Voeg een nieuw template toe',
    'Form Settings' => 'Formulier Instellingen',
    'Admin Notifications' => 'Admin Notificaties',
    'CRM Integrations' => 'CRM Integraties',
    'CRM Integration' => 'CRM Integratie',
    'Element Connections' => 'Element Verbinding',
    'Add a connection' => 'Voeg een verbinding toe',
    'Section' => 'Sectie',
    'Select a section' => 'Selecteer een sectie',
    'Entry Type' => 'Invoertype',
    'Select an entry type' => 'Selecteer een invoertype',
    'User Group' => 'Gebruikersgroep',
    'Validation' => 'Geldigmaking',

    'Payment Field Mapping' => 'Betalingsveld in kaart brengen',
    'Amount' => 'Hoeveelheid',
    'Interval' => 'Interval',
    'Daily' => 'Dagelijks',
    'Weekly' => 'Wekelijks',
    'Biweekly' => 'Tweewekelijks',
    'Monthly' => 'Maandelijks',
    'Annually' => 'Jaarlijks',
    'Currency' => 'Munteenheid',
    'Fixed (see below)' => 'Vast (zie hieronder)',
    'Fixed Amount' => 'Vaste hoeveelheid',
    'Fixed payment amount.' => 'Vast betalingsbedrag.',
    'Fixed Currency' => 'Vaste valuta',
    'Payment currency.' => 'Betalingsvaluta.',
    'Payment Description' => 'Betalingsomschrijving',
    'Enter a custom payment description' => 'Voer een aangepaste betalingsbeschrijving in',
    'Payment Succeeded Email' => 'Betaling geslaagd E-mail',
    'Payment Failed Email' => 'Betaling mislukt E-mail',
    'Subscription Created Email' => 'Abonnement gemaakt e-mail',
    'Subscription Ended Email' => 'Abonnement beëindigd e-mail',
    'Fixed Subscription Plan' => 'Vast abonnement',
    'Select an existing subscription plan' => 'Selecteer een bestaand abonnement',
    'Choose a subscription plan...' => 'Kies een abonnement...',
    'Plan' => 'Plan',
    'Refresh plans' => 'Plannen vernieuwen',
    'Add new plan' => 'Nieuw plan toevoegen',
    'Fixed Interval' => 'Vast interval',
    'The frequency with which a subscription should be billed.' => 'De frequentie waarmee een abonnement moet worden gefactureerd.',

    'Notification added successfully' => 'Notificatie succesvol toegevoegd',
    'Template added successfully' => 'Template succesvol toegevoegd',
    'Template Name' => 'Template naam',
    'File Name' => 'Bestandsnaam',

    'Custom Options' => 'Aangepaste opties',
    'Entries' => 'Ingangen',
    'Categories' => 'Categorieën',
    'Tags' => 'Tags',
    'Users' => 'Gebruikers',
    'Predefined Options' => 'Voorgedefinieerde opties',
    'Source' => 'Bron',
    'Empty Option Label (optional)' => 'Leeg optielabel (optioneel)',
    'To show an empty option at the beginning of the Select field options, enter a value here. Leave blank if you don\'t want a first option.' => "Voer hier een waarde in om een \u{200b}\u{200b}lege optie aan het begin van de veldopties te tonen. Laat leeg als u don ' t wil een eerste optie.",
    'Target' => 'Doel',
    'Order By' => 'Bestel door',
    'Sort' => 'Soort',
    'Option Label' => 'Optielabel',
    'Option Value' => 'Optiewaarde',
    'Options for this field' => 'Opties voor dit veld',
    'Abbreviated' => 'Afgekort',
    'Full' => 'Vol',
    'Range Start' => 'Range Start',
    'Range End' => 'Range Einde',
    'Sort Direction' => 'Sorteer richting',
    'Ascending' => 'Oplopend',
    'Descending' => 'Aflopend',
    'Single number' => 'Enkel nummer',
    '2-digit number' => '2-cijferig nummer',
    'Submit' => 'Verzenden',
    'Confirm' => 'Bevestigen',
    'Password' => 'Wachtwoord',

    'States' => 'Staten',
    'States & Territories' => 'Staten & gebieden',
    'Provinces' => 'Provincies',
    'Provinces - English' => 'Provincies - Engels',
    'Provinces - French' => 'Provincies - Frans',
    'Provinces - Bilingual' => 'Provinces - Tweetalig',
    'Countries' => 'Landen',
    'Languages' => 'Talen',
    'Currencies' => 'Valuta’s',
    'Numbers' => 'Nummers',
    'Years' => 'Jaren',
    'Months' => 'Maanden',
    'Days' => 'Dagen',
    'Days of Week' => 'Dagen van de week',

    'The notification template used to send an email to the email value entered into this field (optional).' => "De notificatiesjabloon die wordt gebruikt om een \u{200b}\u{200b}e-mail te verzenden naar de e-mailwaarde die in dit veld is ingevoerd (optioneel).",
    'Select a template...' => 'Selecteer een template...',
    'Admin Recipients' => 'Admin ontvangers',
    'Email address(es) to receive an email notification. Enter each on a new line.' => 'E-mailadres om een e-mailmelding te ontvangen. Voer elk op een nieuwe regel in.',

    'This field is required?' => 'Dit veld is verplicht?',
    'Use built-in Table JS?' => 'Ingebouwde tabel JS gebruiken?',
    'Check this to enable built-in javascript for handling adding new rows.' => 'Vink dit aan om ingebouwde javascript in te schakelen voor het afhandelen van het toevoegen van nieuwe rijen.',
    'Table Layout' => 'Tabelindeling',
    'Use semicolon ";" separated values for select options.' => 'Gebruik puntkomma ";" gescheiden waarden voor geselecteerde opties.',
    'Style' => 'Stijl',
    'Select style.' => 'Selecteer stijl.',
    'Accent Color' => 'Accent kleur',
    'Select accent color' => 'Selecteer accentkleur',
    'Layout' => 'Lay-out',
    'Field layout.' => 'Veld lay-out.',
    'Two rows' => 'Twee rijen',
    'Three rows' => 'Drie rijen',
    'Configuration' => 'Configuratie',
    'Options Editor' => 'Optie Editor',
    'Attribute Editor' => 'Attribuut Editor',
    'Site' => 'Website',
    'Credit Card Number' => 'Creditcardnummer',
    'Expiry Date' => 'Vervaldatum',
    'CVC/CVV' => 'CVC/CVV',
    'Field label used to describe credit card number field.' => 'Veldlabel dat wordt gebruikt om het creditcardnummerveld te beschrijven.',
    'Checked by default' => 'Standaard aangevinkt',
    'Show all options in a single line?' => 'Alle opties op één regel weergeven?',
    "Show 'Clear' button?" => "Knop 'Wissen' tonen?",
    'Width' => 'Breedte',
    'Canvas width in pixels.' => 'Canvasbreedte in pixels.',
    'Height' => 'Hoogte',
    'Canvas height in pixels.' => 'Canvashoogte in pixels.',
    'Border Color' => 'Rand kleur',
    'Background Color' => 'Achtergrond kleur',
    'Pen Color' => 'Pen Kleur',
    'Pen Dot Size' => 'Grootte van de punt van de pen',
    'Edit in Fullscreen mode' => 'Bewerken in de modus Volledig scherm',
    'Exit Fullscreen mode' => 'Sluit de modus Volledig scherm af',
    'Allow Twig' => 'Toestaan Twig',
    'Used to enable Twig in HTML blocks' => 'Wordt gebruikt om Twig in HTML-blokken in te schakelen',
    'Disabling this option removes the Captcha check for this specific form.' => 'Als u deze optie uitschakelt, wordt de Captcha-controle voor dit specifieke formulier verwijderd.',

    'Input attributes' => 'Input attributen',
    'Label attributes' => 'Label attributen',
    'Error attributes' => 'Verkeerde attributen',
    'Instruction attributes' => 'Instructie attributen',
    'Error' => 'Verkeerde',
    'Instruction' => 'Instructie',
    'Add any tag attributes to the HTML element.' => 'Voeg eventuele tagkenmerken toe aan het HTML-element.',

    'Could not finish the tutorial' => 'Kon de tutorial niet afmaken',
    "Adjust all settings including return URL and formatting template for your form here. To get back here at a later time, just click the \\'Form Settings\\' button." => "Pas hier alle instellingen aan, inclusief de retour-URL en de opmaaksjabloon voor uw formulier. Klik hier om later terug te keren op de knop 'Formulierinstellingen'.",
    'Admin Email Notifications' => 'Admin Email notificaties',
    'If you wish to send an email notification to admin(s) upon users successfully submitting this form, set that up here.' => 'Als u een e-mailmelding naar de beheerder(s) wilt verzenden wanneer gebruikers dit formulier hebben ingediend, stelt u dat hier in.',
    'Available Fields' => 'Beschikbare velden',
    'Fields are global throughout all forms, but are customizable for each form. Drag and drop any of these fields into position on the blank layout area in the center column of this page.' => 'Velden zijn globaal in alle formulieren, maar kunnen voor elk formulier worden aangepast. Sleep deze velden naar een positie in het lege lay-outgebied in de middelste kolom van deze pagina.',
    'Quickly create new fields as you need them. Then adjust their properties and options in the Property Editor in the column on the right. Note: fields created here will be available for all other forms as well.' => 'Maak snel nieuwe velden wanneer u ze nodig hebt. Pas vervolgens hun eigenschappen en opties aan in de Eigenschappeneditor in de rechterkolom. Opmerking: velden die hier worden gemaakt, zijn ook beschikbaar voor alle andere formulieren.',
    'Drag and drop these when you need them. You can have as many HTML fields as you need, but should only have 1 submit button per page.' => 'Sleep deze wanneer je ze nodig hebt. U kunt zoveel HTML-velden hebben als u nodig heeft, maar zou slechts 1 verzendknop per pagina moeten hebben.',
    'Form Layout' => 'Formulierlay-out',
    'This is a live preview of what your form will look like. Drag and drop and fields from the left column into position here. New rows and columns will automatically be created as you position the fields.' => 'Dit is een live preview van hoe uw formulier eruit zal zien. Sleep en plaats en velden van de linkerkolom hier in positie. Nieuwe rijen en kolommen worden automatisch gemaakt wanneer u de velden positioneert.',
    'Editing Fields' => 'Velden bewerken',
    'Fields can easily be moved around whenever you need. Clicking on any field will open up its properties in the Property Editor in the right column.' => 'Velden kunnen gemakkelijk worden verplaatst wanneer u maar wilt. Als u op een willekeurig veld klikt, worden de eigenschappen ervan geopend in de eigenschappeneditor in de rechterkolom.',
    'Multi-page Forms' => 'Formulieren voor meerdere pagina\'s',
    'To create multi-page forms, click the + button to add more pages. You can edit the names of the pages in the Property Editor in the right column. To rearrange pages, click and drag page tabs to shuffle order. To move fields from one page to another, drag and drop fields onto the page tab you\'d like it to be on.' => 'Om formulieren met meerdere pagina\'s te maken, klikt u op de knop + om meer pagina\'s toe te voegen. U kunt de namen van de pagina\'s in de eigenschappeneditor in de rechterkolom bewerken. Als u pagina\'s opnieuw wilt rangschikken, klikt en sleept u paginatabs om de volgorde te wijzigen. Om velden van de ene pagina naar de andere, sleep en zet de velden neer op het tabblad pagina waar u ze wilt hebben staan.',
    'Property Editor' => 'Eigenschap Editor',
    'Page Property Editor' => 'Editor voor Pagina-eigenschappen',
    'This is where all your configuration will happen. Clicking on any field, page tab, etc in Form Builder layout area will load its configuration options here.' => 'Hier zal al uw configuratie gebeuren. Klikken op een willekeurig veld, paginatabblad, enz. In het layoutgebied van de Form Builder laadt de configuratie-opties hier.',

    'Field Property Editor' => 'Veldeneigenschap Editor',
    'Reset' => 'Resetten',
    'Reset to default values' => 'Resetten naar standaardwaardes',
    'Please select an element' => 'Selecteer een element',
    'Database Templates' => 'Database sjablonen',
    'File Templates' => 'Bestand sjablonen',
    'Table settings are controlled inside Form Builder.' => 'Tabelinstellingen worden beheerd in Form Builder.',

    // Voorwaardelijke logica
    'Select a page to add rules to' => 'Selecteer een pagina om regels aan toe te voegen',
    'Add a new field rule' => 'Voeg een nieuw veldregel toe',
    'Add a new goto rule' => 'Voeg een nieuwe ga naar regel toe',
    'Field rules' => 'Veldregels',
    'Page rules' => 'Paginaregels',
    'Rules for {page}' => 'Regels voor {page}',
    'Go to {page} when' => 'Ga naar {page} wanneer',
    'of its criteria match' => 'of het criteria overeenkomt',
    'any' => 'een',
    'all' => 'alle',
    'Add...' => 'Voeg toe...',
    'Add criteria...' => 'Criteria toevoegen...',
    'Show' => 'Laat zien',
    'Hide' => 'Verberg',
    'this item when' => 'dit item wanneer',
    'is' => 'is',
    'is not' => 'is niet',
    'Field' => 'Veld',
    'Add a rule' => 'Voeg een regel toe',
    'Add Field rule' => 'Voeg een veldregel toe',
    'Choose a field' => 'Kies een veld',

    // Betalingen
    'Enter your Stripe public key here.' => 'Voer hier uw Stripe openbare key in.',
    'Enter your Stripe secret key here.' => 'Voer hier uw Stripe geheime key in.',
    'Enter your Stripe webhook secret here.' => 'Voer hier uw Stripe webhook-geheim in.',

    'Payment Gateway' => 'Betalingspoort',
    'Choose a payment gateway.' => 'Kies een betalingspoort.',
    'Refresh Payment Gateways' => 'Ververs betalingspoort.',
    'Payment Type' => 'Betalingsype',
    'Select a payment template' => 'Selecteer een betalingssjabloon',
    'Choose payment type...' => 'Kies betalingstype...',
    'Single payment' => 'Eenmalige betaling',
    'Predefined subscription plan' => 'Voorgedefinieerde abonnement',
    'Customer defined subscription plan' => 'Door de klant gedefinieerd abonnement',
    'Customer Field Mapping' => 'Klanten veldmapping',
    'Payment fields to your Freeform fields.' => 'Betalingsvelden voor uw Freeform velden.',

    // Dashboard
    'Dashboard' => 'Dashboard',
    'Access Dashboard' => 'Toegang Dashboard',
    'Manage' => 'Beheren',
    'Spam ({count})' => 'Spam ({count})',
    'New Form' => 'Nieuw Formulier',
    'New' => 'Nieuw',

    // Logboeken
    'Logs' => 'Logboeken',
    'View Log' => 'Bekijk logboek',
    'Clear' => 'Wissen',
    'Errors' => 'Fouten',
    'Error Log' => 'Fout Logboek',
    'Error Log <span class="badge">{count}</span>' => 'Fout Logboek <span class="badge">{count}</span>',
    'Everything appears to be okay right now! No errors were found.' => 'Alles lijkt nu goed te zijn! Er zijn geen fouten gevonden.',
    'You don\'t have any submissions yet!' => 'U hebt nog geen inzendingen!',
    'You haven\'t created any forms yet!' => 'U heeft nog geen formulieren gemaakt!',
    'Are you sure you want to clear the Error log?' => 'Weet u zeker dat u het foutenlogboek wilt wissen?',
    'Level' => 'Niveau',
    'Details' => 'Details',

    // Diagnostics
    'Diagnostics' => 'Diagnostiek',
    'Warnings' => 'Waarschuwingen',
    'Suggestions' => 'Suggesties',
    'Server Checks' => 'Servercontroles',
    'Freeform Stats' => 'Freeform Statistieken',
    'Freeform Checks' => 'Freeform Controles',

    // Resources
    'Resources' => 'Bronnen',
    'Community' => 'Gemeenschap',
    'Explore' => 'Ontdekken',
    'Support' => 'Steun',
    'The Craft community is diverse, inclusive, and amazingly helpful. You can interact with others in the Craft community in a couple of different ways:' => 'De Craft-gemeenschap is divers, inclusief en ongelooflijk behulpzaam. Je kunt op verschillende manieren communiceren met anderen in de Craft-community:',
    "Check out Solspace's other offerings and explore more options below to go beyond Freeform or extend the functionality of it by using the documented Developer Events." => 'Bekijk het andere aanbod van Solspace en verken hieronder meer opties om verder te gaan dan Freeform of de functionaliteit ervan uit te breiden door gebruik te maken van de gedocumenteerde Developer Events.',
    'If you run into any issues or have any feature requests, check out the official support options below. We also appreciate any feedback you can provide us.' => 'Als je problemen tegenkomt of functieverzoeken hebt, bekijk dan de officiële ondersteuningsopties hieronder. We stellen ook alle feedback op prijs die u ons kunt geven.',

    // Craft Dashboard Widgets
    'Customize the widget title. Leave blank for default.' => 'Pas de widgettitel aan. Standaard leeg laten.',
    'Success Message' => 'Successbericht',
    'The text to be shown at the top of the form if the submit is successful (AJAX), or load in your template with `form.successMessage`.' => 'De tekst die bovenaan het formulier moet worden weergegeven als het verzenden is gelukt (AJAX), of laad uw sjabloon in met `form.successMessage`.',
    'The text to be shown at the top of the form if there are any errors upon submit (AJAX), or load in your template with `form.errorMessage`.' => 'De tekst die bovenaan het formulier moet worden weergegeven als er fouten zijn bij het verzenden (AJAX), of laad uw sjabloon in met `form.errorMessage`.',
    'Customize the message to be displayed to the user when the form has been successfully submitted.' => 'Pas het bericht aan dat aan de gebruiker moet worden getoond wanneer het formulier succesvol is verzonden.',
    'Form submitted successfully!' => 'Formulier succesvol verzonden!',
    'Select the form to be displayed.' => 'Selecteer het formulier dat moet worden weergegeven.',
    'Chart Type' => 'Grafiektype',
    'Chart Height' => 'Grafiekhoogte',
    'Select Date Range' => 'Selecteer datumbereik',
    'Show all form data as a single, combined line?' => 'Alle formuliergegevens weergeven als een enkele, gecombineerde lijn?',
    'Which form submissions do you wish to show?' => 'Welke formulierinzendingen wilt u laten zien?',
    'Show empty values?' => 'Lege waarden weergeven?',
    'Limit' => 'Limiet',
    'The maximum amount of submissions to show.' => 'Het maximale aantal te tonen inzendingen.',
    'Choose which forms to use for statistics.' => 'Kies welke formulieren u wilt gebruiken voor statistieken.',
    'Choose which submission statuses should be used for statistics.' => 'Kies welke indieningsstatussen voor statistieken moeten worden gebruikt.',
    'Show Global Statistics' => 'Toon globale statistieken',
    'Enable this to show the total form, field and notification template count.' => 'Schakel dit in om het totale aantal formulieren, velden en meldingen weer te geven.',

    // Front End
    'Form has been submitted successfully!' => 'Formulier is succesvol verstuurd!',
    'Error! Please review the form and try submitting again.' => 'Fout! Gelieve het formulier na te kijken en opnieuw te proberen.',

    // Betalingen
    'Subscription not found' => 'Abonnement niet gevonden',
    'Error during subscription cancellation' => 'Fout tijdens opzegging abonnement',
    'Unsubscribed successfully' => 'Successvol uitgeschreven',
    'Invalid integration' => 'Ongeldige integratie',
    'Integration is not configured properly' => 'Integratie is niet correct geconfigureerd',
    'Invalid payload' => 'Ongeldige lading',
    'Invalid signature' => 'Ongeldige handtekening',
    'Event is not linked to freeform submission' => 'Evenement is niet gekoppeld aan freeform inzending',
    'Fix Missing Payments' => 'Ontbrekende betalingen corrigeren',
    'Form does not contain payment fields' => 'Formulier bevat geen betalingsvelden',
    'Payments are not set up for the form' => 'Betalingen zijn niet ingesteld voor formulieren',
    'No submissions found' => 'Geen inzendingen gevonden',
    'Payment gateway is not configured!' => 'Betalingspoort is niet geconfigureerd!',
    'Payment type is not configured!' => 'Betalingstype is niet geconfigureerd!',
    'Payment amount is not configured!' => 'Betalingsbedrag is niet geconfigureerd!',
    'Subscription plan is not configured!' => 'Abonnementsplan is niet geconfigureerd!',
    '<a href="{url}">Upgrade to Pro</a> to get access to popular API integrations.' => '<a href="{url}">Opwaarderen naar Pro</a> om toegang te krijgen tot populaire API integraties.',
    'Requires Pro version' => 'Vereist Pro versie',
    'Unknown' => 'Onbekend',
    'Cancel Subscription' => 'Annuleer abonnement',
    'Card Number' => 'Kaartnummer',
    'See in' => 'Zien in',

    // Exporting
    'Quick Export' => 'Snel Exporteren',
    'Export data' => 'Exportgegevens',
    'Export as' => 'Exporteren als',
    'Fields for' => 'Velden voor',
    'No export profiles found' => 'Geen exportprofielen gevonden',
    'Export Profiles' => 'Profielen Exporteren',
    'New Export Profile' => 'Nieuw Export Profiel',
    'Profiles' => 'Profielen',
    'Filter Type' => 'Filtertype',
    'Filters' => 'Filters',
    'Add filters to narrow down your results. For searching into arrays, use LIKE and wrap values with "%", e.g. %"option a"% for a checkbox group field.' => 'Voeg filters toe om uw resultaten te verfijnen. Gebruik voor het zoeken in arrays LIKE en verpak waarden met "%", b.v. %"option a"% voor een checkbox-groepsveld.',
    'Field Name' => 'Veldnaam',
    'Fields to export' => 'Velden om te exporteren',
    'What this export profile will be called in the CP.' => 'Hoe dit exportprofiel in de CP zal heten.',
    'Select which statuses to use' => 'Selecteer welke statussen u wilt gebruiken',
    'The date range for fetching submissions' => 'Het datumbereik voor het ophalen van inzendingen',
    'Maximum number of submissions to fetch.' => 'Maximaal aantal inzendingen om op te halen.',
    'Specify the fields you wish to export and their order.' => 'Specificeer de velden die u wilt exporteren en hun volgorde.',
    'Custom Range' => 'Aangepast Bereik',
    'Last 7 days' => 'Laatste 7 dagen',
    'Last 30 days' => 'Laatste 30 dagen',
    'Last 365 days' => 'Laatste 365 dagen',
    'Presets' => 'Voorinstellingen',
    "Enter the beginning of the time period. Specify an exact date (e.g. '2020-09-01') or use something relative like '15 days ago'. Default is 'today'." => "Voer het begin van de periode in. Geef een exacte datum op (bijv. '2020-09-01') of gebruik iets relatiefs zoals '15 dagen geleden'. Standaard is 'vandaag'.",
    "Enter the end of the time period. Specify an exact date (e.g. '2020-09-30') or use something relative like '15 days ago'. Default is 'today'." => "Voer het einde van de periode in. Geef een exacte datum op (bijv. '30-09-2020') of gebruik iets relatiefs zoals '15 dagen geleden'. Standaard is 'vandaag'.",
    'Like' => 'Soortgelijk',
    'Equal To' => 'Gelijk aan',
    'Not Equal To' => 'Niet gelijk aan',
    'Export Notifications' => 'Meldingen Exporteren',
    'New Export Notification' => 'Nieuwe Uitvoermelding',
    'Profile' => 'Profiel',
    'Frequency' => 'Frequentie',
    'Recipients' => 'Ontvangers',
    'Daily' => 'Dagelijks',
    'Weekly on Sundays' => 'Wekelijks op Zondagen',
    'Weekly on Mondays' => 'Wekelijks op Maandagen',
    'Weekly on Tuesdays' => 'Wekelijks op Dinsdagen',
    'Weekly on Wednesdays' => 'Wekelijks op Woensdagen',
    'Weekly on Thursdays' => 'Wekelijks op Donderdagen',
    'Weekly on Fridays' => 'Wekelijks op Vrijdagen',
    'Weekly on Saturdays' => 'Wekelijks op Zaterdagen',
    'What this export notification will be called in the control panel.' => 'Hoe deze exportmelding zal heten in het controlepaneel.',
    'Export Profile' => 'Profiel Exporteren',
    'Choose the Export Profile to use for this notification.' => 'Kies het exportprofiel dat u voor deze melding wilt gebruiken.',
    'File Type' => 'Bestandstype',
    'Choose the export file type to use for this notification.' => 'Kies het exportbestandstype dat u voor deze melding wilt gebruiken.',
    "Specify how often and which days (if applicable) you'd like to receive the email notifications. The chosen date will attempt to send a notification in the morning." => "Geef aan hoe vaak en op welke dagen (indien van toepassing) u de e-mailmeldingen wilt ontvangen. De gekozen datum zal 's ochtends proberen een melding te verzenden.",
    'Emails to Notify' => 'E-mails om op de hoogte te stellen',
    'Enter the email address(es) that should be notified. If more than one, enter each one on a new line.' => 'Voer het e-mailadres of de e-mailadressen in die op de hoogte moeten worden gebracht. Als er meer dan één zijn, voert u ze allemaal op een nieuwe regel in.',
    'The file name to be generated for the export. You can use the `form`, `profile` and `date` objects as a Twig template here to name your file. (e.g. `"{{ form.handle }}-{{ date.toDateString }}"` which would generate a filename of "`some-form-handle-2022-01-01.csv`"). The extension will be added automatically.' => 'De bestandsnaam die moet worden gegenereerd voor de export. U kunt hier de objecten `form`, `profile` en `date` als Twig-sjabloon gebruiken om uw bestand een naam te geven. (bijv. `"{{ form.handle }}-{{ date.toDateString }}"` die een bestandsnaam zou genereren van "`some-form-handle-2022-01-01.csv`"). De extensie wordt automatisch toegevoegd.',
    'Email Subject' => 'E-mail Onderwerp',
    'Email Message' => 'Email Bericht',
    'The text content of the email notification.' => 'De tekstinhoud van de e-mailmelding.',

    // Spam Reasons
    'Spam Reasons' => 'Spam-redenen',
    'Marked as spam because' => 'Gemarkeerd als spam omdat',
    'generic' => 'Onbekend',
    'honeypot' => 'Honeypot',
    'js_test' => 'Honeypot JS-test',
    'recaptcha' => 'Captcha-fout',
    'blocked_keywords' => 'Geblokkeerde zoekwoorden',
    'blocked_email_address' => 'Geblokkeerd e-mailadres',
    'blocked_ip' => 'Geblokkeerd IP-adres',
    'minimum_submit_time' => 'Minimale verzendtijd',
    'maximum_submit_time' => 'Maximale verzendtijd',
    'Honeypot check failed' => 'Honeypot-controle mislukt',
    'reCAPTCHA -' => 'reCAPTCHA -',
    'Minimum submit time check failed' => 'Controle minimale verzendtijd mislukt',
    'Maximum submit time check failed' => 'Controle van maximale verzendtijd mislukt',
    'Form contains a restricted keyword' => 'Formulier bevat een beperkt trefwoord',
    'Form contains a blocked email' => 'Formulier bevat een geblokkeerde e-mail',
    'Your IP has been blocked' => 'Uw IP is geblokkeerd',
    'Sorry, we cannot accept your submission at this time. Not enough time has passed before submitting the form.' => 'Sorry, we kunnen uw inzending op dit moment niet accepteren. Er is niet genoeg tijd verstreken voordat het formulier verzonden kan worden.',
    'Sorry, we cannot accept your submission at this time. Too much time has passed before submitting the form.' => 'Sorry, we kunnen uw inzending op dit moment niet accepteren. Er is te veel tijd verstreken om het formulier te verzenden.',
    'Allow' => 'Toestaan',
];
