# Twig Perversion plugin for Craft CMS

Making twig do things it really shouldn&#39;t. Twig is not intended to be a general purpose programming language, and there are some things that really don't belong in the language. This plugin adds a few of those things anyway.

- `{% while %}`, `{% break %}`, `{% continue %}`, and `{% return %}` tags
- `===`, `!==`, and `<=>` operators
- `is numeric`, `is string`, and `is array` tests
- `array_splice`, `string`, `float`, `int`, and `bool` filters

## Requirements

This plugin requires Craft CMS 3.1.29 or later.

## Installation

1. Install with Composer via `composer require marionnewlevant/twig-perversion` from your project directory
2. Install plugin in the Craft Control Panel under Settings > Plugins

or

1. Install via the [Plugin Store](https://plugins.craftcms.com/twig-perversion)

## Using Twig Perversion

### Tags

- `{% while %}` loop:

  ```Twig
  {% set x = 0 %}
  {% while x < 5 %}
    {# do whatever... #}
    {% set x = x + 1 %}
  {% endwhile %}
  ```

  Note that twig's [loop](https://twig.symfony.com/doc/2.x/tags/for.html#the-loop-variable) variables (except for `revindex`, `revindex0`, `last`, and `length`) are available inside of a while loop, as are the `{% break %}` and `{% continue %}` tags.

- `{% break %}` to exit a for loop or while loop:

  ```Twig
  {% for straw in haystack %}
    {% if straw == needle %}
      {% break %}
    {% endif %}
  {% endfor %}

  {% while true %}
    {# do whatever... #}
    {% if someCondition %}
      {% break %}
    {% endif %}
  {% endwhile %}
  ```

- `{% continue %}` to continue to next iteration:

  ```Twig
  {% for straw in haystack %}
    {% if not isInteresting(straw) %}
      {% continue %}
    {% endif %}
    {# do whatever... #}
  {% endfor %}
  ```

- `{% return value %}` to return a value from a macro:

  ```Twig
  {% macro foo() %}
    {# ... calculate someValue ... #}
    {% return someValue %}
  {% endmacro %}
  ```

- `{% return %}` to return the empty string from a macro:

  ```Twig
  {% macro foo() %}
    {# ... do stuff %}
    {% return %}
  {% endmacro %}
  ```

  A macro with a `{% return %}` tag will return whatever the return value is (which can be a complex expression). Any other output generated by the macro will be discarded.

### Operators

- **===** and **!==**

  Compares two values for equivalence, using php's `===` and `!==` operators.

- **&lt;=&gt;**

  Compares two values using php's [`<=>` (spaceship)](http://php.net/manual/en/migration70.new-features.php#migration70.new-features.spaceship-op) operator. Returns `-1`, `0`, or `1` when the first argument is respectively less than, equal to, or greater than the second.

### Tests

- **Numeric**

  Test whether given value is numeric (behaviour like PHP 7 `is_numeric`). (Note that as of PHP 7, hexadecimal strings are not considered numeric)

```Twig

{{ 12 is numeric ? 'Yes' : 'No' }}
{# Yes #}

{{ '-1.3' is numeric ? 'Yes' : 'No' }}
{# Yes #}

{{ '0x539' is numeric ? 'Yes' : 'No'}}
{# No #}
```

- **String**

  Test whether given value is a string.

```Twig
{{ '12' is string ? 'Yes' : 'No' }}
{# Yes #}

{{ 12 is string  ? 'Yes' : 'No' }}
{# No #}
```

- **Array**

  Test whether given value is an array.

```Twig
{ [] is array ? 'Yes' : 'No' }}
{# Yes #}

{{ '12' is array  ? 'Yes' : 'No' }}
{# No #}
```

### Filters

- **array_splice**

  Remove a portion of an array and replace it with something else. Uses the PHP [array_splice](http://php.net/manual/en/function.array-splice.php) function. Note that unlike the php function, this filter returns the modified array rather than the extracted elements. The original array is unchanged. Since the implementation requires copying the array, this will be less efficient than the raw php function. The **array_splice** filter is passed an `offset`, an optional `length`, and an optional `replacement`.

- **string**

  Typecast variable as a string.

- **float**

  Typecast variable as a float.

- **int**

  Typecast variable as an integer.

- **bool**

  Typecast variable as a boolean.

Brought to you by [Marion Newlevant](http://marion.newlevant.com)
