# Setup Guide

This guide assumes you have a [HubSpot](https://www.hubspot.com) account already.

<span class="note warning"><b>Important:</b> This is a complete integration between Freeform and HubSpot and should NOT be used along with <a href="https://knowledge.hubspot.com/forms/use-non-hubspot-forms">HubSpot's "Collected Forms" javascript-based feature</a>. Otherwise, you may observe unintended behavior.</span>

## Compatibility

Uses private app on `v3` of the REST API.

### Endpoints
Maps data to the following endpoints:

- **Deals**
- **Contacts**
- **Companies**

### Fields
Maps data to the following field types (of text/number string type only):

- **Standard**
- **Custom**

## Duplicate Check & Update

A duplicate check on records is done in the following way:

1. Check whether the *Contact* already exists:
    - Check against **Email address** as the identifier.
    - If there's a match, update the *Contact* with new values, where supplied.
    - If no match, create a new HubSpot *Contact*.
2. Check whether the *Company* already exists:
    - Check against **Company domain name**, which is automatically generated by HubSpot from the *Contact* email address domain name.
    - If there's a match, update the *Company* with new values, where supplied.
    - If no match, create a new HubSpot *Company*.
    - If a new *Contact* was created, link the contact to the *Company*.
3. Create new *Deal*.
    - Attach the *Deal* to existing or newly created HubSpot *Company* and *Contact*.

## Setup Instructions

### 1. Prepare Freeform's end for Integration

- Select *HubSpot (v3)* from the **Service Provider** select dropdown.
- Enter a name and handle for the integration. e.g. `My HubSpot Integration`
- Leave this page open and open a new tab to go to the HubSpot site...

### 2. Prepare HubSpot's end for Integration

- Open another browser tab and log into your [HubSpot account](https://app.hubspot.com/).
- Click on the account name at the top right.
- Select _Profile & Preferences_ from the menu.
- On the left navigation, click on _Integrations_, and then select _Private Apps_.
- On the next page, click the **Create a Private App** button, and then choose **Private** app.
- You will be taken to a page where you will need to fill out some details:
    - Enter a name for the app in the **Name** field.
    - Switch to the **Scopes** tab and add the following:
        CRM | Read | Write
        --- | --- | ---
        `crm.objects.companies` | ✓ | ✓
        `crm.objects.contacts` | ✓ | ✓
        `crm.objects.deals` | ✓ | ✓
- Click the **Create app** button at the top right.
- After the app saves and reloads the page, copy the token it just created.
- Click the _Close_ button.

### 3. Finish the Integration on your site

- Flip back to the Freeform CP browser tab.
- Paste the HubSpot **Token** value into the **Access Token** field in Freeform.

#### Additional Configuration

- **IP Address Field** (optional)
    - If you want to have the user's IP address sent over to the Contact in HubSpot, you can specify the custom HubSpot Contact field handle to receive it.
- **Append checkboxes field values on Contact update?**
    - If a Contact already exists in HubSpot, enabling this will append additional checkboxes field values to the Contact inside HubSpot, instead of overwriting the options.
- **Append checkboxes field values on Company update?**
    - If a Company already exists in HubSpot, enabling this will append additional checkboxes field values to the Company inside HubSpot, instead of overwriting the options.

Click the **Save** button.

### 4. Verify Authorization

- After the integration is saved, it'll return you to the list of CRM integrations.
- Click on the newly created integration.
- Confirm that there is a green circle with **Authorized** in the middle of the page.

### 5. Configure the Form

To use this integration on your form(s), you'll need to configure each form individually.

- Visit the form inside the form builder.
- Click on the **Integrations** tab.
- Click on **HubSpot** in the list of available integrations.
- On the right side of the page:
    - Enable the integration.
    - Select the API endpoints you wish to map to.
    - Map Freeform fields to the HubSpot fields as needed.

---

<small>Do you need more from this integration? Is the integration you're looking for not here? Solspace offers [custom software development services](https://docs.solspace.com/support/premium/) to build any feature or change you need.</small>

<style type="text/css">.warning {display:block;padding:10px 15px;border:1px solid var(--warning-color);border-radius:5px;}</style>