<?php

namespace Solspace\Freeform\migrations;

use craft\db\Migration;
use Solspace\Freeform\Library\Migrations\ForeignKey;

class m230101_100030_FF4to5_MigrateNotifications extends Migration
{
    public function safeUp(): bool
    {
        $this->renameTable('{{%freeform_notifications}}', '{{%freeform_notification_templates}}');
        $this->alterColumn('{{%freeform_notification_templates}}', 'bodyHtml', $this->mediumText());
        $this->alterColumn('{{%freeform_notification_templates}}', 'bodyText', $this->mediumText());

        $this->createTable(
            '{{%freeform_forms_notifications}}',
            [
                'id' => $this->primaryKey(),
                'formId' => $this->integer()->notNull(),
                'class' => $this->string(255)->notNull(),
                'enabled' => $this->boolean()->defaultValue(true),
                'metadata' => $this->longText(),
                'dateCreated' => $this->dateTime()->notNull(),
                'dateUpdated' => $this->dateTime()->notNull(),
                'uid' => $this->uid(),
            ]
        );

        $this->addForeignKey(
            null,
            '{{%freeform_forms_notifications}}',
            ['formId'],
            '{{%freeform_forms}}',
            ['id'],
            ForeignKey::CASCADE,
        );

        return true;
    }

    public function safeDown(): bool
    {
        echo "m230101_100030_FF4to5_MigrateNotifications cannot be reverted.\n";

        return false;
    }
}
