<?php
/**
 * Freeform for Craft CMS.
 *
 * @author        Solspace, Inc.
 * @copyright     Copyright (c) 2008-2024, Solspace, Inc.
 *
 * @see           https://docs.solspace.com/craft/freeform
 *
 * @license       https://docs.solspace.com/license-agreement
 */

return [
    // Universal
    'Save and continue editing' => 'Speichern und Bearbeiten fortsetzen',
    'Save and add another' => 'Speichern und ein weiteres hinzufügen',
    'Save' => 'Speichern',
    'Name' => 'Name',
    'Handle' => 'Handle',
    'Delete' => 'Löschen',
    'Last Updated' => 'Zuletzt aktualisiert',

    // Api Controller
    'Label is required' => 'Label wird benötigt',
    'Handle is required' => 'Handle wird benötigt',
    'Type {type} is not allowed. Allowed types are ({allowedTypes})' => 'Typ {type} ist nicht erlaubt. Erlaubte Typen sind ({allowedTypes})',
    'Name is required' => 'Name wird benötigt',
    "Template '{name}' already exists" => "Template '{name}' existiert bereits",
    'Submissions' => 'Einreichungen',
    'Date' => 'Datum',
    'Value' => 'Wert',

    // CRM Controller
    'Add a CRM integration' => 'CRM-Integration hinzufügen',
    "CRM integration with handle '{ID}' not found" => "CRM-Integration mit Handle '{ID}' nicht gefunden",
    'CRM Integration saved' => 'CRM Integration gespeichert',
    'CRM Integration not saved' => 'CRM-Integration nicht gespeichert',
    "CRM integration with handle '{handle}' not found" => "CRM-Integration mit Handle '{handle}' nicht gefunden",
    'New CRM Integration' => 'Neue CRM-Integration',
    'CRM' => 'CRM',
    'No CRM integrations exist yet' => 'Es existieren noch keine CRM-Integrationen',
    'What this integration will be called in the CP.' => 'Wie diese Integration im CP genannt wird.',
    'The unique name used to identify this integration.' => 'Der eindeutige Name zur Identifizierung der Integration.',
    'Service Provider' => 'Service Provider',
    'Upgrade to Pro to enable' => 'Auf Pro-Version upgraden zum Freischalten',
    'Requires Pro version' => 'Benötigt Pro-Version',
    '<a href="{url}">Upgrade to Pro</a> to get access to popular API integrations.' => '<a href="{url}">Auf Pro-Version upgraden</a> um Zugriff auf beliebte API-Integrationen zu bekommen.',
    'Are you sure you want to remove the “{name}” integration?' => 'Bist du dir sicher, dass du die “{name}” Integration entfernen möchtest?',
    'Authorized' => 'Autorisiert',
    'Not able to authorize.' => 'Autorisieren fehlgeschlagen.',
    'Click here to re-authorize' => 'Hier klicken, um erneut zu autorisieren',
    'Checking credentials...' => 'Prüfe Zugangsdaten...',

    // Email Marketing Controller
    'New Email Marketing Integration' => 'Neue Email Marketing-Integration',
    'No Email Marketing integrations exist yet' => 'Es existieren noch keine Email Marketing-Integrationen',
    'Email Marketing' => 'Email Marketing',
    'Create new Email Marketing' => 'Neue Email Marketing anlegen',
    'Email Marketing integration with ID {id} not found' => 'Email Marketing-Integration mit ID {id} nicht gefunden',
    'Email Marketing Integration saved' => 'Email Marketing Integration gespeichert',
    'Email Marketing Integration not saved' => 'Email Marketing Integration nicht gespeichert',
    "Email Marketing with handle '{handle}' not found" => "Email Marketing mit Handle '{handle}' nicht gefunden",
    'Add an Email Marketing integration' => 'Email Marketing-Integration hinzufügen',

    // Layout
    'This field is required' => 'Dieses Feld wird benötigt',
    'Form Builder has no properties' => 'Form Builder hat keine Properties',
    'No form builder data present' => 'Keine Form Builder Daten verfügbar',
    'No context specified' => 'Kein Kontext festgelegt',
    'No properties available' => 'Keine Properties verfügbar',
    'No form settings specified' => 'Keine Formular-Einstellungen festgelegt',
    "Field with handle '{handle}' not found" => "Feld mit Handle '{handle}' nicht gefunden",
    "Field with hash '{hash}' not found" => "Feld mit Hash '{hash}' nicht gefunden",
    'Layout page {pageIndex} does not contain a row array' => 'Layout-Page {pageIndex} beinhaltet kein Row Array',
    'Layout page {pageIndex} row {rowIndex} does not contain its ID' => 'Layout-Page {pageIndex} Zeile {rowIndex} beinhaltet keine ID',
    'Layout page {pageIndex} row {rowIndex} does not contain a list of columns' => 'Layout-Page {pageIndex} Zeile {rowIndex} beinhaltet keine Spalten-Liste',
    'Could not create a field of type {type}' => 'Konnte kein feld des Typs {type} erstellen',

    // Fields controller
    'Create Field' => 'Feld erstellen',
    'Fields' => 'Felder',
    'Field saved' => 'Feld gespeichert',
    'Field not saved' => 'Feld nicht gespeichert',
    'Field with ID {id} not found' => 'Feld mit ID {id} nicht gefunden',
    'Checked?' => 'Geprüft?',
    'Selected?' => 'Ausgewählt?',

    // Forms controller
    'Create a new form' => 'Neues Formular erstellen',
    'Editing: {title}' => 'Bearbeiten: {title}',
    'Forms' => 'Formulare',
    'No form ID specified' => 'Keine Formular ID festgelegt',
    'No forms found' => 'Keine Formulare gefunden',
    'Form with ID {id} not found' => 'Formular mit ID {id} nicht gefunden',
    'Are you sure you want to delete this form?' => 'Bist du sicher, dass du dieses Formular löschen willst?',
    'All Sections' => 'Alle Sections',
    'All Category Groups' => 'Alle Category Groups',
    'All Tag Groups' => 'Alle Tag Groups',
    'All User Groups' => 'Alle User Groups',
    'All Assets' => 'Alle Assets',
    'Filename' => 'Dateiname',

    // Notifications Controller
    'Email notifications' => 'Email-Benachrichtigungen',
    'Notifications' => 'Benachrichtigungen',
    'Notification saved' => 'Benachrichtigung gespeichert',
    'Notification not saved' => 'Benachrichtigung nicht gespeichert',
    'Notification with ID {id} not found' => 'Benachrichtigung mit ID {id} nicht gefunden',
    'Include Attachments' => 'Anhänge hinzufügen?',
    'Include uploaded files as attachments in email notification.' => 'Hochgeladene Files als Anhänge in Email-Benachrichtigung hinzufügen',
    'Create a new email notification template' => 'Neues Email-Benachrichtungstemplate erstellen',
    'What this notification template will be called in the CP.' => 'Wie dieses Feld im CP genannt wird.',
    'How you’ll refer to this notification template in the templates.' => 'Wie du in den Templates auf dieses Benachrichtungstemplate verweist.',
    'Description of this notification.' => 'Beschreibung dieser Benachrichtigung.',
    'The subject line for the email notification.' => 'Die Betreffzeile für die Email-Benachrichtigung',
    'The email address that the email will appear from in your email notification.' => 'Die Email-Adresse, die als Sender in deiner Email-Benachrichtigung angezeigt wird.',
    'The name that the email will appear from in your email notification.' => 'Der Name des Senders deiner Email-Benachrichtigung',
    "The reply-to email address for your email notification. Leave blank to use 'From Email' address." => 'Die Antwort-Emailadresse für deine Email-Benachrichtigung. Leer lassen, um die Sender-Adresse zu verwenden.',
    'CC' => 'CC',
    "The email address(es) you would like to be CC'd in the email notification. Separate multiples with commas. Leave blank to not use." => 'Die E-Mail-Adresse, die Sie in der E-Mail-Benachrichtigung mit CC versehen möchten. Trennen Sie Vielfache durch Kommas. Lassen Sie das Feld leer, um es nicht zu verwenden.',
    'BCC' => 'BCC',
    "The email address(es) you would like to be BCC'd in the email notification. Separate multiples with commas. Leave blank to not use." => 'Die E-Mail-Adresse, die Sie in der E-Mail-Benachrichtigung mit BCC versehen möchten. Trennen Sie Vielfache durch Kommas. Lassen Sie das Feld leer, um es nicht zu verwenden.',
    'Email Body (HTML)' => 'Email Body (HTML)',
    'Email Body (Text)' => 'Email Body (Text)',
    'The HTML content of the email notification. If you wish to use Text only, leave this empty and fill out the Text body (below). See documentation for availability of variables.' => 'Der HTML-Inhalt der Email-Benachrichtigung. Wenn du Text only verwenden möchtest, lass dieses Feld leer und pflege nur den Text Body (unten). Beachte die Dokumentation zur Verwendung von Variablen.',
    'The text content of the email notification. If you wish to send out both HTML and Text options, fill out both the HTML and Text body fields. See documentation for availability of variables.' => 'Der Text-Inhalt der Email-Benachrichtigung. Wenn du HTML und Text aussenden möchtest, pflege beide Varianten. Beachte die Dokumentation zur Verwendung von Variablen.',
    'Predefined Assets' => 'Vordefinierte Assets',
    'Select any Assets you wish to include as attachments on all email notifications using this template.' => 'Wähle Assets, die du als Anhänge an alle Email-Benachrichtigungen senden möchtest, die dieses Template verwenden.',

    // Settings controller
    'Settings' => 'Einstellungen',
    'Settings Saved' => 'Einstellungen gespeichert',
    'Settings not saved' => 'Einstellungen nicht gespeichert',
    'No template name specified' => 'Kein Template-Name festgelegt',
    'No custom template directory specified in settings' => 'Kein eigenes Template-Verzeichnis in Einstellungen festgelegt',
    'Add a sample template' => 'Beispiel-Template hinzufügen',
    'Demo Templates' => 'Demo-Templates',
    'No demo templates present' => 'Kein Demo-Template verfügbar',
    'Successfully installed <b>{templates} templates</b> and <b>{assets} assets</b>' => '<b>{templates} Templates</b> und <b>{assets} Assets</b> erfolgreich installiert',
    "You can view the templates <a href='{link}'>here</a>" => "Du kannst die Templates <a href='{link}'>hier</a> ansehen",
    'Install Path' => 'Installations-Pfad',
    'Install' => 'Installieren',
    'Templates' => 'Templates',
    'Assets' => 'Assets',
    'Routes' => 'Routes',
    'Directory Path' => 'Verzeichnispfad',
    'Spam Protection' => 'Spamschutz',
    "Enable this to use Freeform's built in Javascript-based honeypot spam protection." => 'Aktivieren, um Freeforms eingebaute Javascript-basierte honeypot spam protection zu verwenden.',
    'Default View' => 'Standardansicht',
    'Default Email Notification Creation Method' => 'Standard Email-Benachrichtigungsmethode',
    'The default page to go to when clicking the Freeform nav item.' => 'Standardseite, die beim Klicken auf das Freeform Nav Item aufgerufen wird.',
    'Provide a relative path to the Craft Templates folder where your email templates directory is. If you have not yet created the directory, please do that before filling in this setting. This allows you to use Twig template files for your email formatting and allows Freeform to locate these files when setting up notifications.' => 'Definiere einen relativen Pfad zum Craft Root-Verzeichnis, in dem dein Email-Template-Verzeichnis liegt. Das ermöglicht es dir, Twig Template Files für deine Email-Formatierung zu nutzen, und hilft dem Form Builder, die Files beim Setup neuer Benachrichtigungen zu lokalisieren',
    "Which storage method to use when creating new email notifications with 'Add New Notification' option in Form Builder." => 'Welche Speichermethode soll beim Erstellen neuer Email-Benachrichtigungen mit "Neue Benachrichtigung hinzufügen" verwendet werden?',
    'Display Order of Fields in Form Builder' => 'Anzeige-Reihenfolge von Feldern im Form Builder',
    'The display order for the list of available fields in Form Builder.' => 'Anzeige-Reihenfolge für die Liste von verfügbaren Feldern im Form Builder.',
    'Render HTML inside Form Builder & Submissions view?' => 'HTML im Form Builder & Submissions view rendern?',
    'AJAX Enabled for Forms by Default' => 'AJAX für Formulare standardmäßig aktiviert',
    'By default, the "Enable AJAX" feature checkbox will be checked for new forms.' => 'Die "Enable AJAX" Feature-Checkbox wird für neue Formulare standardmäßig aktiviert.',
    'Live rendering HTML in HTML blocks, field labels and option labels inside the Form Builder interface can sometimes conflict with Freeform\'s display of the form preview inside the control panel. In cases like these, you\'ll need to disable this setting to prevent HTML from rendering automatically.' => 'Das Live Rendering von HTML in HTML-Blöcken, Field Labels und Option Labels im Form Builder Interface kann in der Freeform-Anzeige der Formular-Vorschau im Control Panel für Fehler sorgen. In diesen Fällen musst du die Einstellung deaktivieren, um das automatische HTML-Rendering zu unterbinden.',
    'Include Default Freeform Formatting Templates' => 'Inkludiere standardmäßige Freeform Formatierungstemplates',
    'Disable this to hide the default Freeform formatting templates in the Formatting Template options list inside Form Builder.' => 'Deaktivieren, um die standardmäßigen Freeform Formatierungs-Templates in der Format-Optionenliste im Form Builder unsichtbar zu machen',
    'Remove Newlines from Textareas for Exporting' => 'Zeilenumbrüche von Textblöcken für Export entfernen',
    'Enable this to have newlines removed from Textarea fields in submissions when exporting.' => 'Aktivieren, um Zeilenumbrüche von Textblock-Feldern in Einreichungen beim Export zu entfernen.',
    'Fill Form Values from the GET Query String' => 'Formular-Werte vom GET Query String befüllen?',
    'Allow Dashes in Field Handles' => 'Bindestriche in Feldgriffen zulassen',
    'Enable this to be able to fill form field values from a GET query string in URI.' => 'Aktivieren, um Feldwerte im Formular von einem GET Query String im URI befüllen zu können.',
    'Enable this to be able to allow users to include dashes in field handle names in the form builder.' => 'Aktivieren Sie diese Option, damit Benutzer Bindestriche in Feld-Handle-Namen im Formular-Builder einfügen können.',
    'Dashes in field handle names are not allowed by default. Enabling this could negatively affect other parts of Craft, especially GraphQL functionality. Use with caution and only if necessary.' => 'Bindestriche in Feld-Handle-Namen sind standardmäßig nicht zulässig. Die Aktivierung könnte sich negativ auf andere Teile von Craft auswirken, insbesondere auf die GraphQL-Funktionalität. Mit Vorsicht und nur bei Bedarf verwenden.',
    'Disable Submit Button on Form Submit' => 'Submit-Button auf dem Formular beim Senden deaktivieren?',
    'Enable this to automatically disable the form\'s submit button when the form is submitted. This will prevent the form from double-submitting.' => 'Aktivieren, um den Submit-Button des Formulars beim Senden zu deaktivieren. Das verhindert ein doppeltes Absenden des Formulars.',
    'Automatically Scroll to Form on Errors and Multipage forms' => 'Automatisch Scrollen bei Fehlern oder mehrseitigen Formularen?',
    'Enable this to have Freeform use JS to automatically scroll the page down to the form upon submit when there are errors or the form is continuing to the next page in multipage forms.' => 'Aktivieren, damit Freeform zum Runterscrollen nach Submit JS verwendet, wenn es Fehler gibt oder es sich um ein mehrseitiges Formular handelt.',
    'Freeform Javascript Insertion Location' => 'Ort zur Einbindung von Freeform Javascript',
    'The location of where you want Freeform to insert its scripts for form and field functionality.' => 'Der Ort, an dem Freeform Javascript für Formular- und Feld-Funktionalität einbinden soll.',
    'Page Footer' => 'Page Footer',
    'Inside Form' => 'Im Formular',
    'None (add manually)' => 'Nichts (manuell hinzufügen)',

    // Statuses controller
    'Create a new status' => 'Neuen Status erstellen',
    'The name of the status.' => 'Der Name des Status',
    'How you’ll refer to this status in the templates.' => 'Wie du auf den Status in den Templates verweist.',
    'The color of the status circle when viewing inside CP.' => 'Die Farbe des Status-Kreises bei Ansicht im CP.',
    'Set this status to be selected by default when creating new forms?' => 'Soll dieser Status beim Erstellen neuer Formulare standardmäßig ausgewählt werden?',
    'Statuses' => 'Status',
    'Status saved' => 'Status gespeichert',
    'Status not saved' => 'Status nicht gespeichert',
    'Status with ID {id} not found' => 'Status mit ID {id} nicht gefunden',

    // Submissions controller
    'Submission Date' => 'Einreich-Datum',
    'Submission updated' => 'Einreichung aktualisiert',
    'Submission could not be updated' => 'Einreichung konnte nicht geupdated werden',
    'Submission with ID {id} not found' => 'Einreichung mit ID {id} nicht gefunden',
    'Submissions deleted successfully.' => 'Einreichungen erfolgreich gelöscht.',
    'Notes about your changes' => 'Notizen zu Ihren Änderungen',

    // Element type
    'Title' => 'Titel',
    'Form' => 'Formular',
    'All Submissions' => 'Alle Einreichungen',
    'Submission date' => 'Einreich-Datum',
    'Freeform Submissions' => 'Freeform-Einreichungen',
    'Add a submission' => 'Einreichung hinzufügen',
    'Submissions deleted' => 'Einreichungen gelöscht',
    'Are you sure you want to delete these submissions?' => 'Bist du sicher, dass du diese Einreichungen löschen möchtest?',

    // Properties
    "Properties for key '{key}' is not an array" => "Properties für den Key '{key}' sind kein Array",
    "Properties for key '{key}' do not contain TYPE" => "Properties für den Key '{key}' beinhalten nicht TYPE",
    "Could not find properties for key '{hash}'" => "Konnte keine Properties für den Key '{hash}' finden",
    "Could not find properties for page '{index}'" => "Konnte keine Properties für die Seite '{index}' finden",
    "Could not find properties for field '{hash}'" => "Konnte keine Properties für das Feld '{hash}' finden",
    'Could not find properties for form' => 'Konnte keine Properties für Formular finden',
    'Could not find properties for integrations' => 'Konnte keine Properties für Integrationen finden',
    "Value for '{key}' should be '{valueType}' but is '{expectedType}'" => "Der Wert für '{key}' sollte '{valueType}' sein, ist aber '{expectedType}'",

    // Form
    'Trying to post an invalid form' => 'Versucht, ein ungültiges Formular zu veröffentlichen',
    "The provided page index '{pageIndex}' does not exist in form '{formName}'" => "Der angegebene Seiten-Index '{pageIndex}' existiert nicht im Formular '{formName}'",

    // Integrations
    '{setting} setting not specified' => '{setting} Einstelung nicht festgelegt',
    'Could not connect to API endpoint' => 'Konnte nicht zum API Endpoint verbinden',
    'Could not add emails to lists' => 'Konnte keine Emails zu Listen hinzufügen',
    'Could not fetch {serviceProvider} lists' => 'Konnte {serviceProvider} Listen nicht abrufen',
    'Unknown integration type specified' => 'Unbekannter Integrations-Typ festgelegt',
    'Could not find setting blueprints for {handle}' => 'Konnte keine Einstellungs-Blueprintsfür {handle} finden',
    "No 'access_token' present in auth response for {serviceProvider}" => "Kein 'access_token' in Authentifikations-Antwort für {serviceProvider}",
    "'{key}' key missing in Freeform's plugin configuration" => "'{key}' Key fehlt in Freeform Plugin-Konfiguration",

    // Settings model
    "Directory '{directory}' does not exist" => "Verzeichnis '{directory}' fehlt",
    'Could not get demo template content. Please contact Solspace.' => 'Konnte Demo-Template-Content nicht abrufen. Bitte kontaktiere Solspace.',

    // Submission record
    '{attribute} cannot be blank' => '{attribute} darf nicht leer sein',

    // CRM service
    'CRM Integration with ID {id} not found' => 'CRM-Integration mit ID {id} nicht gefunden',
    "No field mapping specified for '{integration}' integration" => "Kein Field Mapping für '{integration}'-Integration festgelegt",

    // Files service
    'Could not handle file upload' => 'File-Upload konnte nicht durchgeführt werden',

    // Form service
    "Can't use render() if no form template specified" => 'Kann render() nicht verwenden, wenn kein Formular-Template festgelegt ist',
    "Form template '{name}' not found" => "Formular-Template '{name}' nicht gefunden",

    // Mailer service
    'Email notification template with ID {id} not found' => 'Email-Benachrichtigungs-Template mit ID {id} nicht gefunden',

    // Text field
    'The allowed maximum length is {{max}} characters. Current size is {{difference}} characters too long.' => 'Die zulässige maximale Länge beträgt {{max}} Zeichen. Die aktuelle Größe ist {{difference}} Zeichen zu lang.',

    // Captcha field
    'Please verify that you are not a robot.' => 'Bitte vergewissern Sie sich, dass Sie kein Roboter sind.',

    // Confirm field
    'This value must match the value for {targetFieldLabel}' => 'Dieser Wert muss mit dem Wert für {targetFieldLabel} übereinstimmen',

    // Email field
    '{email} is not a valid email address' => '{email} ist keine gültige Email-Adresse',

    // Date field
    '"{value}" does not conform to "{format}" format.' => '"{value}" entspricht nicht dem "{format}" Format.',
    'Date "{date}" must be after "{minDate}"' => 'Datum "{date}" muss nach "{minDate}" liegen',
    'Date "{date}" must be before "{maxDate}"' => 'Datum "{date}" muss vor "{maxDate}" liegen',
    'Minimum date' => 'Mindestdatum',
    'Maximum date' => 'Max. Datum',
    "You can use 'now', 'today', '5 days ago', '2024-01-01 20:00:00', etc." => 'Definiere ein zugehöriges Datum für das frühestmögliche Datum, das im Datepicker und bei der Feldverifikation verfügbar ist.',
    "You can use 'now', 'today', '5 days ago', '2024-01-01 20:00:00', etc." => 'Definiere ein zugehöriges Datum für das spätestmögliche Datum, das im Datepicker und bei der Feldverifikation verfügbar ist.',

    // Phone field
    'Invalid phone number' => 'Ungültige Telefonnummer',
    'Phone number is invalid.' => 'Telefonnummer ist ungültig.',

    // Rating field
    'Rating must be between {{min}} and {{max}}' => 'Die Bewertung muss zwischen {{min}} und {{max}} liegen',

    // Website field
    'Website not valid' => 'Webseite nicht gültig',

    // File Upload field
    "'{extension}' is not an allowed file extension" => "'{extension}' ist keine gestattete Dateiendung",
    'You tried uploading {fileSize}KB, but the maximum file upload size is {maxFileSize}KB' => 'Du hast versucht {fileSize}KB hochzuladen, die maximale Dateiupload-Größe ist jedoch {maxFileSize}KB',
    'Tried uploading {count} files. Maximum {max} files allowed.' => 'Versucht, {count} Dateien hochzuladen. Maximal {max} Dateien zulässig.',
    'Could not upload file' => 'Konnte Datei nicht hochladen',
    'The file was only partially uploaded' => 'Die Datei wurde nur teilweise hochgeladen',
    'File size too large' => 'Dateigröße zu groß',

    // File Upload Drag and Drop field
    'Maximum file upload limit of {limit} reached' => 'Maximales Datei-Upload-Limit von {limit} erreicht',
    'Maximum file upload size is {maxFileSize}KB' => 'Die maximale Datei-Upload-Größe beträgt {maxFileSize}KB',
    'Upload in progress...' => 'Hochladen läuft...',
    'Upload complete!' => 'Hochladen abgeschlossen!',
    'Multiple field uploads not supported' => 'Das Hochladen mehrerer Felder wird nicht unterstützt',
    'Unknown file type' => 'Unbekannter Dateityp',

    // Number field
    'Value must be numeric' => 'Wert muss numerisch sein',
    'The value must be no more than {{max}}' => 'Der Wert darf nicht größer als {{max}} sein.',
    'The value must be no less than {{min}}' => 'Der Wert darf nicht kleiner als {{min}} sein.',
    'The value must be between {{min}} and {{max}}' => 'Der Wert muss zwischen {{min}} und {{max}} liegen.',
    '{{dec}} decimal places allowed' => '{{dec}} Dezimalstellen erlaubt',
    'Only positive numbers allowed' => 'Nur positive Zahlen erlaubt',
    'The value must be no more than {{max}} characters' => 'Der Wert darf nicht mehr als {{max}} Zeichen umfassen',
    'The value must be no less than {{min}} characters' => 'Der Wert darf nicht weniger als {{min}} Zeichen umfassen',
    'The value must be between {{min}} and {{max}} characters' => 'Der Wert muss zwischen {{min}} und {{max}} Zeichen liegen',

    // Fields
    'Create a new field' => 'Erstelle ein neues Feld',
    'Default instructions / help text for this field.' => 'Standard Hilfetext für dieses Feld.',
    'Set this field as required by default.' => 'Definiere dieses Feld als standardmäßig benötigt.',
    'What type of field is this?' => 'Welcher Feld-Typ ist das?',
    'How you’ll refer to this field in the templates.' => 'Wie du auf das Feld in den Templates verweist.',
    'The default label for this field.' => 'Das Standard-Label für dieses Feld.',
    'Options' => 'Optionen',
    'Custom values' => 'Benutzerdefinierte Werte',
    'Define the default available options.' => 'Definiere die standardmäßig verfügbaren Optionen.',
    'Enable this to check the checkbox by default.' => 'Aktivieren, um die Checkbox standardmäßig zu aktivieren.',
    'Enable this to specify custom values for each option label.' => 'Aktivieren, um benutzerdefinierte Werte für jedes Options-Label zu definieren.',
    'Dynamic Recipients' => 'Dynamische Empfänger',
    'Define the default available email address options.' => 'Definiere die standardmäßig verfügbaren Email-Adressen-Optionen.',
    'Placeholder' => 'Platzhalter',
    'The default text that will be shown if the field doesn’t have a value.' => 'Der standardmäßige Text, der angezeigt wird wenn das Feld keinen Wert hat.',
    'Asset Source' => 'Asset-Quelle',
    'Select a default asset source for uploaded files.' => 'Wähle eine standardmäßige Asset-Quelle für hochgeladene Dateien aus.',
    'Default value' => 'Standardwert',
    'The default value for the field.' => 'Der Standardwert für das Feld',
    'Rows' => 'Zeilen',
    'The default number of rows this textarea should have.' => 'Die standardmäßige Anzahl Zeilen, die dieses Textfeld haben sollte.',
    'Maximum File Size' => 'Maximale Dateigröße',
    'Specify the default maximum file size, in KB.' => 'Definiere die standardmäßige maximale Dateigröße in KB.',
    'Allowed File Types' => 'Erlaubte Dateitypen',
    'Select the file types to be allowed by default. Leaving all unchecked will allow all file types.' => 'Wähle die Dateitypen, die standardmäßig gestattet sind. Sind keine ausgewählt, so sind alle Dateitypen gestattet.',
    'The handle "{handle}" is a reserved keyword and cannot be used.' => 'Der Handle "{handle}" ist ein reserviertes Schlüsselwort und kann nicht verwendet werden.',
    'While data is passed along to the Email Marketing provider, Freeform does not store whether or not Email Marketing fields were opted in.' => 'Während die Daten zum Mailingliste-Provider übertragen werden, speichert Freeform nicht, ob Mailingliste-Felder ausgewählt waren',

    // Form Builder
    'No Value set' => 'Kein Wert gesetzt',
    'No Target field' => 'Kein Zielfeld',
    'No Template' => 'Kein Template',
    'No Asset Source' => 'Keine Asset-Quelle',
    'Hidden field' => 'Verstecktes Feld',
    'Handle is not set' => 'Handle ist nicht gesetzt',
    'Handle is a reserved keyword' => 'Handle ist ein reserviertes Schlüsselwort',
    '"${resourceName}" list for ${name}' => '"${resourceName}" Liste für ${name}',
    'No mailing list for ${name}' => 'Keine Mailing-Liste für ${name}',
    'No email field' => 'Kein Email-Feld',
    'Field type "${type}" not found' => 'Feldtyp "${type}" nicht gefunden',
    'Are you sure you want to remove this page and all fields on it?' => 'Bist du dir sicher, dass du diese Seite und alle darauf befindlichen Felder löschen möchtest?',
    'Add New Field' => 'Neues Feld hinzufügen',
    'Type' => 'Typ',
    'Label' => 'Label',
    'Field label used to describe the field.' => 'Feld-Label, um das Feld zu beschreiben.',
    'The value for this field.' => 'Der Wert für dieses Feld.',
    'Instructions' => 'Instruktionen',
    'Field specific user instructions.' => 'Feld-spezifische User-Instruktionen.',
    'If present, this will be the value pre-populated when the form is rendered.' => 'Wenn gesetzt, ist das der vorausgefüllte Wert wenn das Formular gerendert wird.',
    'The text that will be shown if the field doesn’t have a value.' => 'Der Text, der angezeigt wird, wenn das Feld keinen Wert hat.',
    'Target field' => 'Zielfeld',
    'The target Freeform field to be confirmed by re-entering its value.' => 'Das Freeform-Zielfeld, das bestätigt wird indem sein Wert erneut eingegeben wird.',
    'Date Time Type' => 'Date Time Type',
    'Use date, time or both.' => 'Wähle, ob du Datum, Zeit oder beide nutzen möchtest.',
    'Both' => 'Beide',
    'Time' => 'Zeit',
    "You can use 'now', 'today', '5 days ago', '2024-01-01 20:00:00', etc." => "You can use 'now', 'today', '5 days ago', '2024-01-01 20:00:00', etc.",
    'Use built-in datepicker' => 'Den Freeform Datepicker für dieses Feld nutzen?',
    'Use date format as placeholder' => 'Generiere einen Platzhalter für deine Datumsformat-Einstellungen?',
    'Date order' => 'Datums-Reihenfolge',
    'Choose the order in which to show day, month and year.' => 'Wähle die Reihenfolge, in der Tag, Monat und Jahr angezeigt werden sollen.',
    'year month day' => 'Jahr Monat Tag',
    'month day year' => 'Monat tag Jahr',
    'day month year' => 'Tag Monat Jahr',
    'Four digit year' => 'Jahr mit vier Ziffern?',
    'Date leading zero' => 'Datum mit vorangestellten Nullen',
    'Include a leading zero for day and month numbers.' => 'Wenn aktiviert, wird Tagen und Monaten eine Null vorangestellt.',
    'Date separator' => 'Datums-Trennzeichen',
    'Used to separate date values.' => 'Trennzeichen für Datums-Werte.',
    'None' => 'Keine',
    '24h clock' => '24h Uhr?',
    'Clock Separator' => 'Uhr-Trennzeichen',
    'Used to separate hours and minutes.' => 'Trennzeichen für Stunden und Minuten.',
    'Lowercase AM/PM?' => 'AM/PM in kleingeschriebenen Buchstaben?',
    'Separate AM/PM with a space' => 'AM/PM mit Leerzeichen zu trennen?',
    'Email Template' => 'Email-Template',
    'The notification template used to send an email to the email value entered into this field (optional). Leave empty to just store the email address without sending anything.' => 'Das Benachrichtigungs-Template, das zum Senden einer Email an die Adresse in diesem Feld verwendet wird (optional). Leer lassen, um nur die Adresse zu speichern, ohne eine Mail zu senden.',
    'Render as' => 'Rendern als',
    'Select' => 'Wählen',
    'Radios' => 'Radio-Buttons',
    'Checkboxes' => 'Checkboxen',
    'Options for this checkbox group' => 'Optionen für diese Checkbox-Gruppe',
    'Select an asset source to be able to store user uploaded files.' => 'Wähle ein Asset, um vom User hochgeladene Files zu speichern.',
    'Select an Asset Source...' => 'Wähle eine Asset-Quelle...',
    'File Count' => 'Datei-Anzahl',
    'Specify the maximum uploadable file count.' => 'Lege die maximale Anzahl an hochladbaren Dateien fest',
    'Maximum File Size' => 'Maximale Dateigröße',
    'Specify the maximum file size, in KB.' => 'Definiere die maximale Dateigröße in KB',
    'Allowed File Kinds' => 'Gestattete Dateitypen',
    'Leave everything unchecked to allow all file kinds.' => 'Nichts auswählen, um alle Dateitypen zu gestatten',
    'Name or title of the form.' => 'Name oder Titel des Formulars.',
    'How you’ll refer to this form in the templates.' => 'Wie du auf das Formular in den Templates verweist.',
    'Submission Title' => 'Einreichungs-Titel',
    'What the auto-generated submission titles should look like.' => 'Wie der automatisch generierte Einreichungs-Titel aussehen soll.',
    'Return URL' => 'Rückkehr-URL',
    'The URL the form will redirect to after successful submit. This will not work when the Built-in AJAX setting is enabled unless a template-level override is set.' => 'Die URL, zu der das Formular nach erfolgreichem Absenden weiterleitet.',
    'Default Status' => 'Standard-Status',
    'The default status to be assigned to new submissions.' => 'Der standardmäßige Status, der neuen Einreichungen zugewiesen wird.',
    'Formatting Template' => 'Formatierungs-Template',
    'The formatting template to assign to this form when using Render method (optional).' => 'Das Formatierungstemplate, das diesem Formular beim Verwenden der Render-Methode zugewiesen wird.',
    'Collect IP Addresses' => 'IP Adressen sammeln',
    'Should this form collect the user\'s IP address?' => 'Soll dieses Formular die IP Adressen der User sammeln?',
    'Store Submitted Data' => 'Speichere eingereichte Daten',
    'Should the submission data for this form be stored in the database?' => 'Sollen eingereichte Daten dieses Formulars in der Datenbank gespeichert werden?',
    'Opt-In Data Storage Checkbox' => 'Opt-In Checkbox für Datenspeicherung',
    'Allow users to decide whether the submission data is saved to your site or not.' => 'Erlaube Usern, zu entscheiden, ob eingereichte Daten von deiner Seite gespeichert werden oder nicht.',
    'Disabled' => 'Deaktiviert',
    'Limit Form Submission Rate' => 'Limitiere das Intervall für Formulareinreichungen',
    'Limit the number of times a user can submit the form.' => 'Limitiere die Anzahl der Einreichungen, die User für ein Formular durchführen können.',
    'Do not limit' => 'Nicht limitieren',
    'Once per Cookie only' => 'Nur einmal per Cookie',
    'Once per IP/Cookie combo' => 'Nur einmal per IP/Cookie - Kombination',
    'Form Color' => 'Formular-Farbe',
    'Used for Widget Charts' => 'Verwendet für Widget Charts',
    'Description / Notes' => 'Beschreibung / Notizen',
    'Description or notes for this form.' => 'Beschreibung oder Notizen für dieses Formular.',
    'Hash' => 'Hash',
    'Used to access this field on the frontend.' => 'Verwendet, um auf dieses Feld im Frontend zuzugreifen.',
    'Field Mapping' => 'Field Mapping',
    'Map CRM fields to your Freeform fields.' => 'CRM-Felder den Freeform-Feldern zuweisen.',
    'Map Email Marketing fields to your Freeform fields.' => 'Mailing-Liste Felder den Freeform-Feldern zuweisen',
    'Integration' => 'Integration',
    'Choose an integration type' => 'Wähle einen Integrationstyp',
    'Choose an integration...' => 'Wähle eine Integration...',
    'Refreshing...' => 'Aktualisiert...',
    'Refresh Integration' => 'Aktualisiere Integration',
    'Choose the opt-in mailing list that users will be added to.' => 'Wähle die opt-in Malingliste, zu der User hinzugefügt werden.',
    'Select a list...' => 'Wähle eine Liste...',
    'Target Email Field' => 'Ziel-Emailfeld',
    'The email field used to push to the mailing list.' => 'Das Emailfeld, das zur Mailingliste führt.',
    'Select a field...' => 'Wähle ein Feld...',
    'Decimal Separator' => 'Dezimal-Trennzeichen',
    'Used to separate decimals.' => 'Verwendet, um Dezimalzahlen zu trennen.',
    'Allow negative numbers' => 'Gestatte negative Zahlen?',
    'Min/Max Values' => 'Min/Max Werte',
    'The minimum and/or maximum numeric value this field is allowed to have (optional).' => 'Der minimale und/oder maximale numerische Wert, den dieses Feld haben darf (optional).',
    'Min/Max Length' => 'Min/Max Länge',
    'The minimum and/or maximum character length this field is allowed to have (optional).' => 'Die minimale und/oder maximale Zeichenanzahl, die dieses Feld haben darf (optional).',
    'Decimal Count' => 'Dezimalstellen',
    'The number of decimal places allowed.' => 'Die Anzahl erlaubter Dezimalstellen.',
    'Leave blank for no decimals.' => 'Leer lassen, um keine Dezimalstellen zu erlauben',
    'Thousands Separator' => 'Tausender-Trennzeichen',
    'Used to separate thousands.' => 'Verwendet, um Tausenderschritte zu trennen.',
    'Label for this page tab.' => 'Label für diesen Page-Tab.',
    'Use built-in javascript validation on pattern' => 'Verwende JS Validierung',
    'Enable this to force JS to validate the input on this field based on the pattern.' => 'Freischalten, um JS zur Validierung des Feldinhalts basierend auf dem Muster zu zwingen',
    'Pattern validation' => 'Muster',
    'Custom phone pattern (e.g. \'(000) 000-0000\' or \'+0 0000 000000\'), where \'0\' stands for a digit between 0-9. If left blank, any number and dash, dot, space, parentheses and optional + at the beginning will be validated.' => 'Benutzerdefiniertes Telefonnummer-Muster (bspw. \'(000) 000-0000\' oder \'+0 0000 000000\'), worin \'0\' für eine Ziffer zwischen 0 und 9 steht. Ist das Feld leer, wird jede Nummer, Bindestrich, Punkt, Leerzeichen, Klammern und optional + zu Beginn validiert.',
    'Optional' => 'Optional',
    'Maximum Number of Stars' => 'Maximale Anzahl an Sternen',
    'Set how many stars there should be for this rating.' => 'Stelle ein, wie viele Sterne das Rating haben soll.',
    'Unselected Color' => 'Nicht ausgewählt Farbe',
    'Hover Color' => 'Hover Farbe',
    'Selected Color' => 'Ausgewählt Farbe',
    'Enter any regex pattern here.' => 'Gib hier ein beliebiges regex-Muster ein.',
    'e.g. /^[a-zA-Z0-9]*$/' => 'Bspw. /^[a-zA-Z0-9]*$/',
    'Error Message' => 'Error-Nachricht',
    'The message a user should receive if an incorrect value is given. It will replace any occurrences of \'{{pattern}}\' with the supplied regex pattern inside the message if any are found.' => 'Die Nachricht, die ein Nutzer erhält, wenn ein falscher Wert eingegeben wird. Es wird jedes Auftreten von \'{{pattern}}\' ersetzt mit dem gelieferten regex-Muster in der Nachricht, wenn eines gefunden wird.',
    'Value is not valid' => 'Wert ist ungültig.',
    'Submit button Label' => 'Submit-Button Label',
    'The label of the submit button' => 'Das Label des Submit-Buttons',
    'Disable the Previous button' => 'Deaktiviere den Previous Button',
    'Previous button Label' => 'Previous-Button Label',
    'The label of the previous button' => 'Das Label des Previoius-Buttons',
    'Maximum Length' => 'Maximale Länge',
    'The maximum number of characters for this field.' => 'Die maximale Zeichenanzahl für dieses Feld..',
    'The number of rows in height for this field.' => 'Die Anzahl an Zeilen in der Höhe für dieses Feld',
    'Hide field' => 'Feld verstecken',
    'Hide the mailing list checkbox from the form and make it always trigger a subscription.' => 'Verstecke die Mailingliste-Checkbox vom Formular. Triggert immer eine Subscription.',
    'Live HTML rendering currently disabled.' => 'Live HTML-Rendering ist deaktiviert.',
    'Quick save' => 'Schnell speichern',
    'Saving...' => 'Speichern...',
    'Cancel' => 'Abbrechen',
    'Save and finish' => 'Speichern und Fertigstellen',
    'Save as a new form' => 'Speichern als neues Formular',
    'Saved successfully' => 'Erfolgreich gespeichert',
    'Name must not be empty' => 'Name darf nicht leer sein',
    'Label must not be empty' => 'Label darf nicht leer sein',
    'Handle must not be empty' => 'Handle darf nicht leer sein',
    'Field type must not be empty' => 'Feldtyp darf nicht leer sein',
    'Field added successfully' => 'Feld erfolgreich hinzugefügt',
    'Special Fields' => 'Spezielle Felder',
    'Craft Field' => 'Craft-Feld',
    'Freeform Field' => 'Freeform-Feld',
    'Field mapping' => 'Field mapping',
    'Activate users?' => 'Aktiviere User?',
    'The user will be activated upon creation if this is checked. Will be set to pending otherwise.' => 'User werden direkt nach dem Erstellen aktiviert, wenn dies aktiviert ist. Wird ansonsten auf Pending gesetzt.',
    'Disable entries?' => 'Deaktiviere Einträge',
    'The entry will be set to disabled upon creation if this is checked. Will be set to enabled otherwise.' => 'Der Eintrag wird auf Deaktiviert gesetzt nach dem Erstellen, wenn dies aktiviert ist. Wird ansonsten auf Aktiviert gesetzt.',
    'CRM Field' => 'CRM-Feld',
    'FF Field' => 'FF-Feld',
    'Use custom values' => 'Verwende benutzerdefinierte Werte',
    'Positioning' => 'Positionierung',
    'Choose how the previous and submit buttons should be placed.' => 'Wähle, wie Previous und Submit-Buttons platziert werden sollen',
    'Apart at Left and Right' => 'Getrennt links und rechts',
    'Together at Left' => 'Zusammen links',
    'Together at Center' => 'Zusammen zentriert',
    'Together at Right' => 'Zusammen rechts',
    'Choose whether the submit button is positioned on the left, center or right side.' => 'Wähle, ob der Submit-Button links, zentriert oder rechts positioniert wird',
    'Add new template' => 'Füge neues Template hinzu',
    'Form Settings' => 'Formular-Einstellungen',
    'Admin Notifications' => 'Admin-Benachrichtigungen',
    'CRM Integrations' => 'CRM-Integrationen',
    'Element Connections' => 'Element-Verbindungen',
    'Notification added successfully' => 'Benachrichtigung erfolgreich hinzugefügt',
    'Template added successfully' => 'Template erfolgreich hinzugefügt',
    'Template Name' => 'Template-Name',
    'File Name' => 'File-Name',
    'Custom Options' => 'Benutzerdefinierte Optionen',
    'Entries' => 'Einträge',
    'Categories' => 'Kategorien',
    'Tags' => 'Tags',
    'Users' => 'Benutzer',
    'Predefined Options' => 'Vordefinierte Optionen',
    'Source' => 'Quelle',
    'Empty Option Label (optional)' => 'Leeres Options-Label (optional)',
    'To show an empty option at the beginning of the Select field options, enter a value here. Leave blank if you don\'t want a first option.' => 'Um eine leere Option zu Beginn der Feldauswahl-Optionen anzuzeigen, gib einen Wert ein. Leer lassen, wenn du keine Option möchtest.',
    'Target' => 'Ziel',
    'Option Label' => 'Options-Label',
    'Option Value' => 'Options-Wert',
    'Options for this field' => 'Optionsen für dieses Feld',
    'Abbreviated' => 'Zusammengefasst',
    'Full' => 'Voll',
    'Range Start' => 'Bereichsanfang',
    'Range End' => 'Bereichsende',
    'Sort Direction' => 'Sortier-Richtung',
    'Ascending' => 'Aufsteigend',
    'Descending' => 'Absteigend',
    'Single number' => 'Einzelne Ziffer',
    '2-digit number' => 'Nummer mit zwei Ziffern',
    'Submit' => 'Submit',
    'Confirm' => 'Bestätigen',
    'Password' => 'Passwort',
    'States' => 'Staaten',
    'States & Territories' => 'Staaten & Regionen',
    'Provinces' => 'Bundesländer',
    'Provinces - English' => 'Bundesländer - English',
    'Provinces - French' => 'Bundesländer - French',
    'Provinces - Bilingual' => 'Bundesländer - Bilingual',
    'Countries' => 'Länder',
    'Languages' => 'Sprachen',
    'Currencies' => 'Währungen',
    'Numbers' => 'Zahlen',
    'Years' => 'Jahre',
    'Months' => 'Monate',
    'Days' => 'Tage',
    'Days of Week' => 'Wochentage',
    'The notification template used to send an email to the email value entered into this field (optional).' => 'Das Benachrichtigungstemplate wird verwendet, um eine Email an die Adresse in diesem Feld zu versenden (optional).',
    'Select a template...' => 'Wähle ein Template...',
    'Admin Recipients' => 'Admin-Empfänger',
    'Email address(es) to receive an email notification. Enter each on a new line.' => 'Email-Adressen, die eine Benachrichtigung erhalten. Eine Adresse pro Zeile.',
    'This field is required?' => 'Dieses Feld ist benötigt?',
    'Use built-in javascript for adding and removing rows' => 'Use built-in javascript for adding and removing rows',
    'Configuration' => 'Configuration',
    'Options Editor' => 'Options Editor',
    'Attribute Editor' => 'Attribute Editor',
    'Credit Card Number' => 'Credit Card Number',
    'Expiry Date' => 'Expiry Date',
    'CVC/CVV' => 'CVC/CVV',
    'Checked by default' => 'Standardmäßig ausgewählt',
    'Show all options on one line' => 'Zeige alle Optionen in einer Zeile?',
    'Enable AJAX' => 'Aktiviere AJAX',
    'Use Freeform\'s built-in automatic AJAX submit feature. This will prevent the value in the Return URL field from working unless a template-level override is set.' => 'Verwende das automatische AJAX Submit-Feature von Freeform.',
    'Enable Captchas' => 'Aktivieren Sie Captchas',
    'Disabling this option removes the Captcha check for this specific form.' => 'Durch Deaktivieren dieser Option wird die Captcha-Prüfung für dieses bestimmte Formular entfernt.',
    'Input attributes' => 'Input-Attribute',
    'Label attributes' => 'Label-Attribute',
    'Error attributes' => 'Error-Attribute',
    'Instruction attributes' => 'Instruktions-Attribute',
    'Add any tag attributes to the HTML element.' => 'Füge alle Tag-Attribute zum HTML-Element hinzu.',
    "Adjust all settings including return URL and formatting template for your form here. To get back here at a later time, just click the \\'Form Settings\\' button." => "Stelle alle Einstellungen hier ein, inklusie Rückkehr-URL und Formatierungs-Template. Um später hierhin zurückzukehren, klicke einfach den \\'Form Settings\\' button.",
    'Admin Email Notifications' => 'Admin-Emailbenachrichtigungen',
    'If you wish to send an email notification to admin(s) upon users successfully submitting this form, set that up here.' => 'Wenn du Emails an Admin(s) versenden möchtest, wenn User das Formular abschicken, kannst du das hier einstellen.',
    'Available Fields' => 'Verfügbare Felder',
    'Fields are global throughout all forms, but are customizable for each form. Drag and drop any of these fields into position on the blank layout area in the center column of this page.' => 'Felder sind in allen Formularen global, jedoch benutzerdefinierbar für jedes Formular. Du kannst jedes der Felder auf der leeren Layout-Fläche in der mittleren Spalte dieser Seite anordnen, indem du sie via Drag and Drop platzierst.',
    'Quickly create new fields as you need them. Then adjust their properties and options in the Property Editor in the column on the right. Note: fields created here will be available for all other forms as well.' => 'Erstelle schnell neue Felder, wenn du sie brauchst. Passe ihre Properties und OPTIONEN im Property-Editor in der rechten Spalte an. Beachte: Felder die hier erstellt werden, sind für alle anderen Formulare auch verfügbar.',
    'Drag and drop these when you need them. You can have as many HTML fields as you need, but should only have 1 submit button per page.' => 'Nutze Drag and Drop, wenn du sie brauchst. Du kannst so viele HTML-Felder haben, wie du benötigst, solltest aber nur einen Submit-Button pro Seite verwenden.',
    'Form Layout' => 'Formular-Layout',
    'This is a live preview of what your form will look like. Drag and drop and fields from the left column into position here. New rows and columns will automatically be created as you position the fields.' => 'Dies ist eine Live-Vorschau, wie dein Formular aussehen wird. Verwende Drag and Drop, um Felder von der rechten Spalte hier in Position zu bringen. Neue Zeilen und Spalten werden automatisch erstellt, während du die Felder positionierst.',
    'Editing Fields' => 'Bearbeite Felder',
    'Fields can easily be moved around whenever you need. Clicking on any field will open up its properties in the Property Editor in the right column.' => 'Felder können einfach dort hin bewegt werden, wo sie gebraucht werden. Ein Klick auf ein Feld öffnet seine Properties im Property-Editor in der rechten Spalte.',
    'Multi-page Forms' => 'Mehrseitige Formulare',
    'To create multi-page forms, click the + button to add more pages. You can edit the names of the pages in the Property Editor in the right column. To rearrange pages, click and drag page tabs to shuffle order. To move fields from one page to another, drag and drop fields onto the page tab you\'d like it to be on.' => 'Um mehrseitige Formulare zu erstellen, klicke auf den + Button zum Seiten hinzufügen. Um Seiten anzuordnen, klicke und ziehe die Page-Tabs zum Anpassen der Reihenfolge. Um Felder von einer zur nächsten Seite zu verschieben, klicke und ziehe die Felder auf den Page-Tab, zu dem du das Feld verschieben möchtest.',
    'Property Editor' => 'Property-Editor',
    'This is where all your configuration will happen. Clicking on any field, page tab, etc in Form Builder layout area will load its configuration options here.' => 'Hier erfolgt die gesamte Konfiguration. Klicken auf ein Feld, einen Page-Tab etc. im Form Builder Layout-Bereich lädt die jeweiligen Konfigurationen hier.',
    'Field Property Editor' => 'Feld-Property Editor',
    'Reset to default values' => 'Zurücksetzen auf Standardwerte',
    'Please select an element' => 'Bitte wähle ein Element',
    'Database Templates' => 'DB Benachrichtigungen',
    'File Templates' => 'Template-Benachrichtigungen',

    // Conditional logic
    'Select a page to add rules to' => 'Wähle eine Seite, der du Regeln hinzufügen möchtest',
    'Add a new field rule' => 'Füge eine neue Feld-Regel hinzu',
    'Add a new goto rule' => 'Füge eine neue Goto-Regel hinzu',
    'Field rules' => 'Feldregeln',
    'Page rules' => 'Seitenregeln',
    'Rules for {page}' => 'Regeln für {page}',
    'Go to {page} when' => 'Gehe zu {page} wenn',
    'of its criteria match' => 'der Kriterien übereinstimmen',
    'any' => 'irgendwelche',
    'all' => 'alle',
    'Add...' => 'Hinzufügen...',
    'Add criteria...' => 'Kriterien hinzufügen...',
    'Show' => 'Zeigen',
    'Hide' => 'Verstecken',
    'this item when' => 'dieses Item wenn',
    'is' => 'ist',
    'is not' => 'ist nicht',

    // Payments
    'Enter your Stripe public key here.' => 'Gib deinen Stripe Public Key ein.',
    'Enter your Stripe secret key here.' => 'Gib deinen Stripe Secret Key ein.',
    'Enter your Stripe webhook secret here.' => 'Gib deinen Stripe Webhook Secret ein.',
    'Payment Gateway' => 'Zahlungs-Gateway',
    'Choose a payment gateway.' => 'Wähle ein Zahlungs-Gateway.',
    'Refresh Payment Gateways' => 'Aktualisiere Zahlungs-Gateways',
    'Payment Type' => 'Zahlungs-Typ',
    'Select a payment template' => 'Wähle eines der Zahlungs-Templates',
    'Choose payment type...' => 'Wähle Zahlungstyp...',
    'Customer Field Mapping' => 'Kunden Feld-Mapping',
    'Payment fields to your Freeform fields.' => 'Zahlungs-Felder zu deinen Freeform-Feldern',
    'Add a rule' => 'Füge eine Regel hinzu',
    'Add Field rule' => 'Füge eine Feld-Regel hinzu',
    'Choose a field' => 'Wähle ein Feld',

    // Dashboard
    'Dashboard' => 'Dashboard',
    'Access Dashboard' => 'Greife aufs Dashboard zu',
    'Manage' => 'Organisieren',
    'Spam ({count})' => 'Spam ({count})',

    // Logs
    'Logs' => 'Logs',
    'View Log' => 'Log ansehen',
    'Clear' => 'Leeren',
    'Errors' => 'Errors',
    'Error Log' => 'Error Log',
    'Error Log <span class="badge">{count}</span>' => 'Error Log <span class="badge">{count}</span>',
    'Everything appears to be okay right now! No errors were found.' => 'Derzeit scheint alles okay zu sein! Keine Errors wurden gefunden.',
    'You don\'t have any submissions yet!' => 'Du hast noch keine Einreichungen!',
    'You haven\'t created any forms yet!' => 'Du hast noch keine Formulare erstellt!',
    'Are you sure you want to clear the Error log?' => 'Bist du dir sicher, dass du den Error Log leeren möchtest?',

    // Craft Dashboard Widgets
    'Enter a custom widget title, or leave blank to use default.' => 'Passe den Widget-Titel an. Leer lassen für standardmäßigen Titel.',
    'Success Message' => 'Erfolgsnachricht',
    'Customize the message to be displayed to the user when the form has been successfully submitted.' => 'Passe die Nachricht an, die Usern bei erfolgreichem Submit des Formulars angezeigt wird.',
    'Form submitted successfully!' => 'Formular erfolgreich abgesendet!',
    'Select the form to be displayed.' => 'Wähle das Formular, das angezeigt werden soll.',
    'Chart Type' => 'Chart Typ',
    'Chart Height' => 'Chart Höhe',
    'Date Range' => 'Wähle Datumsbereich',
    'Display all Form Data as a Single Combined Line' => 'Zeige alle Formular-Daten als einzelne, zusammengefügte Zeile?',
    'Select the forms for which submission data should be included.' => 'Welche Formular-Einreichungen möchtest du anzeigen?',
    'Include Empty Values' => 'Zeige leere Werte?',
    'Limit' => 'Limit',
    'The maximum number of submissions to show.' => 'Die maximale Anzahl an Einreichungen, die angezeigt wird',
    'Choose which forms to use for statistics.' => 'Wähle, welche Formulare für Statistiken verwendet werden.',
    'Choose which submission statuses should be used for statistics.' => 'Wähle, welche Einreich-Status für Statistiken verwendet werden sollen.',
    'Show Global Statistics' => 'Zeige globale Statistiken',
    'Enable this to show the total form, field and notification template count.' => 'Aktivieren um die Gesamtanzahl für Formulare, Felder und Benachrichtigungstemplates zu zeigen.',

    // Front End
    'Form has been submitted successfully!' => 'Formular erfolgreich abgesendet!',
    'Error! Please review the form and try submitting again.' => 'Error! Bitte überprüfe nochmal das Formular und versuche es erneut abzusenden.',

    // Payments
    'Subscription not found' => 'Subscription nicht gefunden',
    'Error during subscription cancellation' => 'Error während dem Beenden der Subscription',
    'Unsubscribed successfully' => 'Erfolgreich unsubscribed',
    'Invalid integration' => 'Ungültige Integration',
    'Integration is not configured properly' => 'Integration ist nicht richtig konfiguriert',
    'Invalid payload' => 'Ungültige Nutzlast',
    'Invalid signature' => 'Ungültige Signatur',
    'Event is not linked to freeform submission' => 'Event ist nicht mit Freeform-Einreichung verknüpft',
    'Fix Missing Payments' => 'Behebe fehlende Zahlungen',
    'Form does not contain payment fields' => 'Formular beinhaltet keine Zahlungsfelder.',
    'Payments are not set up for the form' => 'Zahlungen für das Formular nicht eingerichtet',
    'No submissions found' => 'Keine Einreichungen gefunden',
    'Payment gateway is not configured!' => 'Zahlungs-Gateway ist nicht konfiguriert!',
    'Payment type is not configured!' => 'Zahlungstyp ist nicht konfiguriert!',
    'Payment amount is not configured!' => 'Zahlungs-Betrag ist nicht konfiguriert!',
    'Subscription plan is not configured!' => 'Subscription-Plan ist nicht konfiguriert!',
];
