const weatherCodeFullDay = {
    "0": "Unknown",
    "1000": "/assets/images/weather-icon/1000_clear_small.png",
    "1001": "/assets/images/weather-icon/1001_cloudy_small.png",
    "1100": "/assets/images/weather-icon/1100_mostly_clear_small.png",
    "1101": "/assets/images/weather-icon/1101_partly_cloudy_small.png",
    "1102": "/assets/images/weather-icon/1102_mostly_cloudy_small.png",
    "1103": "/assets/images/weather-icon/1103_mostly_clear_small.png",
    "2000": "/assets/images/weather-icon/2000_fog_small.png",
    "2100": "/assets/images/weather-icon/2100_fog_light_small.png",
    "2101": "/assets/images/weather-icon/2101_fog_light_mostly_clear_small.png",
    "2102": "/assets/images/weather-icon/2102_fog_light_partly_cloudy_small.png",
    "2103": "/assets/images/weather-icon/2103_fog_light_mostly_cloudy_small.png",
    "2106": "/assets/images/weather-icon/2106_fog_mostly_clear_small.png",
    "2107": "/assets/images/weather-icon/2107_fog_partly_cloudy_small.png",
    "2108": "/assets/images/weather-icon/2108_fog_mostly_cloudy_small.png",
    "4000": "/assets/images/weather-icon/4000_drizzle_small.png",
    "4001": "/assets/images/weather-icon/4001_rain_small.png",
    "4200": "/assets/images/weather-icon/4200_rain_light_small.png",
    "4201": "/assets/images/weather-icon/4201_rain_heavy_small.png",
    "4202": "/assets/images/weather-icon/4202_rain_heavy_partly_cloudy_small.png",
    "4203": "/assets/images/weather-icon/4203_drizzle_mostly_clear_small.png",
    "4204": "/assets/images/weather-icon/4204_drizzle_partly_cloudy_small.png",
    "4205": "/web/assets/images/weather-icon/4205_drizzle_mostly_cloudy_small.png",
    "4208": "/assets/images/weather-icon/4208_rain_partly_cloudy_small.png",
    "4209": "/assets/images/weather-icon/4209_rain_mostly_clear_small.png",
    "4210": "/assets/images/weather-icon/4210_rain_mostly_cloudy_small.png",
    "4211": "/assets/images/weather-icon/4211_rain_heavy_mostly_clear_small.png",
    "4212": "/assets/images/weather-icon/4212_rain_heavy_mostly_cloudy_small.png",
    "4213": "/assets/images/weather-icon/4213_rain_light_mostly_clear_small.png",
    "4214": "/assets/images/weather-icon/4214_rain_light_partly_cloudy_small.png",
    "4215": "/assets/images/weather-icon/4215_rain_light_mostly_cloudy_small.png",
    "5000": "/assets/images/weather-icon/5000_snow_small.png",
    "5001": "/assets/images/weather-icon/5001_flurries_small.png",
    "5100": "/assets/images/weather-icon/5100_snow_light_small.png",
    "5101": "/assets/images/weather-icon/5101_snow_heavy_small.png",
    "5102": "/assets/images/weather-icon/5102_snow_light_mostly_clear_small.png",
    "5103": "/assets/images/weather-icon/5103_snow_light_partly_cloudy_small.png",
    "5104": "/assets/images/weather-icon/5104_snow_light_mostly_cloudy_small.png",
    "5105": "/assets/images/weather-icon/5105_snow_mostly_clear_small.png",
    "5106": "/assets/images/weather-icon/5106_snow_partly_cloudy_small.png",
    "5107": "/assets/images/weather-icon/5107_snow_mostly_cloudy_small.png",
    "5108": "/assets/images/weather-icon/5108_wintry_mix_small.png",
    "5110": "/assets/images/weather-icon/5110_wintry_mix_small.png",
    "5112": "/assets/images/weather-icon/5112_wintry_mix_small.png",
    "5114": "/assets/images/weather-icon/5114_wintry_mix_small.png",
    "5115": "/assets/images/weather-icon/5115_flurries_mostly_clear_small.png",
    "5116": "/assets/images/weather-icon/5116_flurries_partly_cloudy_small.png",
    "5117": "/assets/images/weather-icon/5117_flurries_mostly_cloudy_small.png",
    "5119": "/assets/images/weather-icon/5119_snow_heavy_mostly_clear_small.png",
    "5120": "/assets/images/weather-icon/5120_snow_heavy_partly_cloudy_small.png",
    "5121": "/assets/images/weather-icon/5121_snow_heavy_mostly_cloudy_small.png",
    "5122": "/assets/images/weather-icon/5122_wintry_mix_small.png",
    "6000": "/assets/images/weather-icon/6000_freezing_rain_drizzle_small.png",
    "6001": "/assets/images/weather-icon/6001_freezing_rain_small.png",
    "6002": "/assets/images/weather-icon/6002_freezing_rain_drizzle_partly_cloudy_small.png",
    "6003": "/assets/images/weather-icon/6003_freezing_rain_drizzle_mostly_clear_small.png",
    "6004": "/assets/images/weather-icon/6004_freezing_rain_drizzle_mostly_cloudy_small.png",
    "6200": "/assets/images/weather-icon/6200_freezing_rain_light_small.png",
    "6201": "/assets/images/weather-icon/6201_freezing_rain_heavy_small.png",
    "6202": "/assets/images/weather-icon/6202_freezing_rain_heavy_partly_cloudy_small.png",
    "6203": "/assets/images/weather-icon/6203_freezing_rain_light_partly_cloudy_small.png",
    "6204": "/assets/images/weather-icon/6204_wintry_mix_small.png",
    "6205": "/assets/images/weather-icon/6205_freezing_rain_light_mostly_clear_small.png",
    "6206": "/assets/images/weather-icon/6206_wintry_mix_small.png",
    "6207": "/assets/images/weather-icon/6207_freezing_rain_heavy_mostly_clear_small.png",
    "6208": "/assets/images/weather-icon/6208_freezing_rain_heavy_mostly_cloudy_small.png",
    "6209": "/assets/images/weather-icon/6209_freezing_rain_light_mostly_cloudy_small.png",
    "6212": "/assets/images/weather-icon/6212_wintry_mix_small.png",
    "6213": "/assets/images/weather-icon/6213_freezing_rain_mostly_clear_small.png",
    "6214": "/assets/images/weather-icon/6214_freezing_rain_partly_cloudy_small.png",
    "6215": "/assets/images/weather-icon/6215_freezing_rain_mostly_cloudy_small.png",
    "6220": "/assets/images/weather-icon/6220_wintry_mix_small.png",
    "6222": "/assets/images/weather-icon/6222_wintry_mix_small.png",
    "7000": "/assets/images/weather-icon/7000_ice_pellets_small.png",
    "7101": "/assets/images/weather-icon/7101_ice_pellets_heavy_small.png",
    "7102": "/assets/images/weather-icon/7102_ice_pellets_light_small.png",
    "7103": "/assets/images/weather-icon/7103_wintry_mix_small.png",
    "7105": "/assets/images/weather-icon/7105_wintry_mix_small.png",
    "7106": "/assets/images/weather-icon/7106_wintry_mix_small.png",
    "7107": "/assets/images/weather-icon/7107_ice_pellets_partly_cloudy_small.png",
    "7108": "/assets/images/weather-icon/7108_ice_pellets_mostly_clear_small.png",
    "7109": "/assets/images/weather-icon/7109_ice_pellets_mostly_cloudy_small.png",
    "7110": "/assets/images/weather-icon/7110_ice_pellets_light_mostly_clear_small.png",
    "7111": "/assets/images/weather-icon/7111_ice_pellets_light_partly_cloudy_small.png",
    "7112": "/assets/images/weather-icon/7112_ice_pellets_light_mostly_cloudy_small.png",
    "7113": "/assets/images/weather-icon/7113_ice_pellets_heavy_mostly_clear_small.png",
    "7114": "/assets/images/weather-icon/7114_ice_pellets_heavy_partly_cloudy_small.png",
    "7115": "/assets/images/weather-icon/7115_wintry_mix_small.png",
    "7116": "/assets/images/weather-icon/7116_ice_pellets_heavy_mostly_cloudy_small.png",
    "7117": "/assets/images/weather-icon/77117_wintry_mix_small.png",
    "8000": "/assets/images/weather-icon/8000_tstorm_small.png",
    "8001": "/assets/images/weather-icon/8001_tstorm_mostly_clear_small.png",
    "8002": "/assets/images/weather-icon/8002_tstorm_mostly_cloudy_small.png",
    "8003": "/assets/images/weather-icon/8003_tstorm_partly_cloudy_small.png",
};

async function getWeatherData(city) {
    const apiWeatherURL = `https://api.tomorrow.io/v4/timelines?apikey=${weatherAPi}`
    //const apiWeatherURL = `https://api.tomorrow.io/v4/timelines?apikey=Vp6EwUsN2LS0w50uyBsMPJEtkhasPss5`
    try {
        const options = {
            method: 'POST',
            headers: {
                accept: 'application/json',
                'Accept-Encoding': 'gzip',
                'content-type': 'application/json'
            },
            body: JSON.stringify({
                location: '41.1608, -7.88765',
                fields: ['temperature', 'windSpeed', 'weatherCodeFullDay'],
                units: 'metric',
                timesteps: ['1d'],
                startTime: 'now',
                // Ajustar o endTime para 4 dias
                endTime: "nowPlus4d"
            })
        };
        const response = await fetch(apiWeatherURL, options);
        const data = await response.json();
        console.log(data); // Você pode manipular os dados aqui
        return data;
    } catch (error) {
        console.error("Erro ao obter dados meteorológicos:", error.message);
        throw error;
    }
}

async function updateWeatherWidget() {
    // Definir a cidade desejada, por exemplo, Mesão Frio
    const city = {
        latitude: 41.1590081513046,
        longitude: -7.885376501726179
    };

    try {
        // Obter os dados meteorológicos para a cidade
        const weatherData = await getWeatherData(city);
        //console.log("weatherData => ", weatherData.data.timelines[0]);
        //let jsonData = JSON.parse(weatherCodeFullDay);

        if(weatherData.data) {
            let intervals = weatherData.data.timelines[0].intervals
            for (let i = 0; i < intervals.length; i++) {
                let widgetContent = document.querySelector("div.widget.locale-info-widget ul")
                console.log(intervals[i])
                let title = ''
                //Verify Dates
                let date = new Date(intervals[i].startTime).toLocaleDateString('pt-PT')
                let currentDate = new Date().toLocaleDateString('pt-PT')
                if (date === currentDate) {
                    title = 'Hoje';
                } else {
                    title = new Date(intervals[i].startTime).toLocaleDateString('pt-PT', {weekday: 'long'})
                }

                let image = weatherCodeFullDay[intervals[i].values.weatherCodeFullDay];
                image = `<img src="${image}" alt="Weather Icon"/>`

                let li = document.createElement("li");
                let titleContainer = '<div class="row-title">' +
                    '<h4>' + title + '</h4>' +
                    '<div>' +
                    '<span class="notice-date">' + date + '</span>' +
                    '</div>' +
                    '</div>';



                //Create Temperature Div Container
                let temperatureContainer =
                    '<div class="temperature-container">' +
                    '<div class="icon">' +
                    image +
                    '</div>' +
                    '<div class="temp-info">' +
                    '<div class="temperature">' +
                    Math.ceil(intervals[i].values.temperature) + 'ºC' +
                    '</div>' +
                    '<div>' +
                    Math.ceil(intervals[i].values.windSpeed) + ' m/s' +
                    '</div>' +
                    '</div>' +
                    '</div>';
                li.insertAdjacentHTML('beforeend', titleContainer)
                li.insertAdjacentHTML('beforeend', temperatureContainer)
                widgetContent.appendChild(li)
            }
            if(document.querySelector(".widget.locale-info-widget")) {
                document.querySelector(".widget.locale-info-widget").style.display = 'block'
            }
        }else {
            if(document.querySelector(".widget.locale-info-widget")) {
                document.querySelector(".widget.locale-info-widget").style.display = 'none'
            }
        }


        /*const currentDate = new Date();
        const formattedDate = currentDate.toLocaleDateString('pt-PT');
        // Atualizar os elementos na página com os dados obtidos
        const temperatureElement = document.getElementById("temperature");
        const weatherIconElement = document.getElementById("icon");
        const windElement = document.getElementById("wind");

        const apiWeatherCode = weatherData.data.timelines[0].intervals[0].values.weatherCodeFullDay;
        let jsonData = JSON.parse(weatherCodeFullDay);

        let image = jsonData[`${apiWeatherCode}`];
        console.log(image)
        //chamar a imagem
        document.getElementById("icon").innerHTML = `<img src="/assets/images/weather-icon/${apiWeatherCode}" alt="Weather Icon"/>`;

        // Adicione logs para verificar a estrutura dos dados
        console.log("Temperatura:", weatherData.data.timelines[0].intervals[0].values.temperature);
        console.log("Ícone do Tempo:", weatherData.data.timelines[0].intervals[0].values.weatherCodeFullDay);
        console.log("Velocidade do Vento:", weatherData.data.timelines[0].intervals[0].values.windSpeed);


        // Atualizar os elementos na página com os dados obtidos
        if (temperatureElement && weatherIconElement && windElement) {

            temperatureElement.innerHTML = `<span>${Math.floor(weatherData.data.timelines[0].intervals[0].values.temperature)}&deg;C</span>`;

            weatherIconElement.innerHTML = `<img src="/assets/images/weather-icon/${apiWeatherCode}"/>`;

            windElement.innerHTML = `<span>${Math.round(weatherData.data.timelines[0].intervals[0].values.windSpeed)}m/s</span>`;
        } else {
            console.error("Elementos HTML não encontrados");
        }


        // Exibir as datas dos próximos três dias:
        const tomorrow = new Date(currentDate.getTime() + (1 * 24 * 60 * 60 * 1000));
        const dayAfterTomorrow = new Date(currentDate.getTime() + (2 * 24 * 60 * 60 * 1000));
        const fourthDay = new Date(currentDate.getTime() + (3 * 24 * 60 * 60 * 1000));

        // Alterar o texto dos elementos "span" que representam as datas
        document.querySelector(".notice-date-today").innerHTML = formatarData(currentDate);
        document.querySelector(".notice-date-tomorrow").innerHTML = formatarData(tomorrow);
        document.querySelector(".notice-date-day-after-tomorrow").innerHTML = formatarData(dayAfterTomorrow);
        document.querySelector(".notice-date-fourth-day").innerHTML = formatarData(fourthDay);

        // Alterar o texto dos elementos "h4" que representam os dias
        document.querySelector(".day-one").innerHTML = 'Hoje';
        document.querySelector(".day-two").innerHTML = tomorrow.toLocaleDateString('pt-PT', { weekday: 'long' }).slice(0, 1).toUpperCase() + tomorrow.toLocaleDateString('pt-PT', { weekday: 'long' }).slice(1);
        document.querySelector(".day-three").innerHTML = dayAfterTomorrow.toLocaleDateString('pt-PT', { weekday: 'long' }).slice(0, 1).toUpperCase() + dayAfterTomorrow.toLocaleDateString('pt-PT', { weekday: 'long' }).slice(1);
        document.querySelector(".day-four").innerHTML = fourthDay.toLocaleDateString('pt-PT', { weekday: 'long' }).slice(0, 1).toUpperCase() + fourthDay.toLocaleDateString('pt-PT', { weekday: 'long' }).slice(1);*/

    } catch (error) {
        console.error("Erro ao atualizar o widget:", error.message);
    }
}

window.onload = updateWeatherWidget;