!function(e,t){"function"==typeof define&&define.amd?define([],t):e.htmx=e.htmx||t()}("undefined"!=typeof self?self:this,(function(){return function(){"use strict";var htmx={onLoad:onLoadHelper,process:processNode,on:addEventListenerImpl,off:removeEventListenerImpl,trigger:triggerEvent,ajax:ajaxHelper,find:find,findAll:findAll,closest:closest,values:function(e,t){return getInputValues(e,t||"post").values},remove:removeElement,addClass:addClassToElement,removeClass:removeClassFromElement,toggleClass:toggleClassOnElement,takeClass:takeClassForElement,defineExtension:defineExtension,removeExtension:removeExtension,logAll:logAll,logger:null,config:{historyEnabled:!0,historyCacheSize:10,refreshOnHistoryMiss:!1,defaultSwapStyle:"innerHTML",defaultSwapDelay:0,defaultSettleDelay:20,includeIndicatorStyles:!0,indicatorClass:"htmx-indicator",requestClass:"htmx-request",addedClass:"htmx-added",settlingClass:"htmx-settling",swappingClass:"htmx-swapping",allowEval:!0,inlineScriptNonce:"",attributesToSettle:["class","style","width","height"],withCredentials:!1,timeout:0,wsReconnectDelay:"full-jitter",disableSelector:"[hx-disable], [data-hx-disable]",useTemplateFragments:!1,scrollBehavior:"smooth",defaultFocusScroll:!1},parseInterval:parseInterval,_:internalEval,createEventSource:function(e){return new EventSource(e,{withCredentials:!0})},createWebSocket:function(e){return new WebSocket(e,[])},version:"1.8.4"},internalAPI={addTriggerHandler:addTriggerHandler,bodyContains:bodyContains,canAccessLocalStorage:canAccessLocalStorage,filterValues:filterValues,hasAttribute:hasAttribute,getAttributeValue:getAttributeValue,getClosestMatch:getClosestMatch,getExpressionVars:getExpressionVars,getHeaders:getHeaders,getInputValues:getInputValues,getInternalData:getInternalData,getSwapSpecification:getSwapSpecification,getTriggerSpecs:getTriggerSpecs,getTarget:getTarget,makeFragment:makeFragment,mergeObjects:mergeObjects,makeSettleInfo:makeSettleInfo,oobSwap:oobSwap,selectAndSwap:selectAndSwap,settleImmediately:settleImmediately,shouldCancel:shouldCancel,triggerEvent:triggerEvent,triggerErrorEvent:triggerErrorEvent,withExtensions:withExtensions},VERBS=["get","post","put","delete","patch"],VERB_SELECTOR=VERBS.map((function(e){return"[hx-"+e+"], [data-hx-"+e+"]"})).join(", ");function parseInterval(e){if(null!=e)return"ms"==e.slice(-2)?parseFloat(e.slice(0,-2))||void 0:"s"==e.slice(-1)?1e3*parseFloat(e.slice(0,-1))||void 0:"m"==e.slice(-1)?1e3*parseFloat(e.slice(0,-1))*60||void 0:parseFloat(e)||void 0}function getRawAttribute(e,t){return e.getAttribute&&e.getAttribute(t)}function hasAttribute(e,t){return e.hasAttribute&&(e.hasAttribute(t)||e.hasAttribute("data-"+t))}function getAttributeValue(e,t){return getRawAttribute(e,t)||getRawAttribute(e,"data-"+t)}function parentElt(e){return e.parentElement}function getDocument(){return document}function getClosestMatch(e,t){for(;e&&!t(e);)e=parentElt(e);return e||null}function getAttributeValueWithDisinheritance(e,t,r){var n=getAttributeValue(t,r),o=getAttributeValue(t,"hx-disinherit");return e!==t&&o&&("*"===o||o.split(" ").indexOf(r)>=0)?"unset":n}function getClosestAttributeValue(e,t){var r=null;if(getClosestMatch(e,(function(n){return r=getAttributeValueWithDisinheritance(e,n,t)})),"unset"!==r)return r}function matches(e,t){var r=e.matches||e.matchesSelector||e.msMatchesSelector||e.mozMatchesSelector||e.webkitMatchesSelector||e.oMatchesSelector;return r&&r.call(e,t)}function getStartTag(e){var t=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i.exec(e);return t?t[1].toLowerCase():""}function parseHTML(e,t){for(var r=(new DOMParser).parseFromString(e,"text/html").body;t>0;)t--,r=r.firstChild;return null==r&&(r=getDocument().createDocumentFragment()),r}function makeFragment(e){if(htmx.config.useTemplateFragments)return parseHTML("<body><template>"+e+"</template></body>",0).querySelector("template").content;switch(getStartTag(e)){case"thead":case"tbody":case"tfoot":case"colgroup":case"caption":return parseHTML("<table>"+e+"</table>",1);case"col":return parseHTML("<table><colgroup>"+e+"</colgroup></table>",2);case"tr":return parseHTML("<table><tbody>"+e+"</tbody></table>",2);case"td":case"th":return parseHTML("<table><tbody><tr>"+e+"</tr></tbody></table>",3);case"script":return parseHTML("<div>"+e+"</div>",1);default:return parseHTML(e,0)}}function maybeCall(e){e&&e()}function isType(e,t){return Object.prototype.toString.call(e)==="[object "+t+"]"}function isFunction(e){return isType(e,"Function")}function isRawObject(e){return isType(e,"Object")}function getInternalData(e){var t="htmx-internal-data",r=e[t];return r||(r=e[t]={}),r}function toArray(e){var t=[];if(e)for(var r=0;r<e.length;r++)t.push(e[r]);return t}function forEach(e,t){if(e)for(var r=0;r<e.length;r++)t(e[r])}function isScrolledIntoView(e){var t=e.getBoundingClientRect(),r=t.top,n=t.bottom;return r<window.innerHeight&&n>=0}function bodyContains(e){return e.getRootNode&&e.getRootNode()instanceof ShadowRoot?getDocument().body.contains(e.getRootNode().host):getDocument().body.contains(e)}function splitOnWhitespace(e){return e.trim().split(/\s+/)}function mergeObjects(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r]);return e}function parseJSON(e){try{return JSON.parse(e)}catch(e){return logError(e),null}}function canAccessLocalStorage(){var e="htmx:localStorageTest";try{return localStorage.setItem(e,e),localStorage.removeItem(e),!0}catch(e){return!1}}function internalEval(str){return maybeEval(getDocument().body,(function(){return eval(str)}))}function onLoadHelper(e){return htmx.on("htmx:load",(function(t){e(t.detail.elt)}))}function logAll(){htmx.logger=function(e,t,r){console&&console.log(t,e,r)}}function find(e,t){return t?e.querySelector(t):find(getDocument(),e)}function findAll(e,t){return t?e.querySelectorAll(t):findAll(getDocument(),e)}function removeElement(e,t){e=resolveTarget(e),t?setTimeout((function(){removeElement(e)}),t):e.parentElement.removeChild(e)}function addClassToElement(e,t,r){e=resolveTarget(e),r?setTimeout((function(){addClassToElement(e,t)}),r):e.classList&&e.classList.add(t)}function removeClassFromElement(e,t,r){e=resolveTarget(e),r?setTimeout((function(){removeClassFromElement(e,t)}),r):e.classList&&(e.classList.remove(t),0===e.classList.length&&e.removeAttribute("class"))}function toggleClassOnElement(e,t){(e=resolveTarget(e)).classList.toggle(t)}function takeClassForElement(e,t){forEach((e=resolveTarget(e)).parentElement.children,(function(e){removeClassFromElement(e,t)})),addClassToElement(e,t)}function closest(e,t){if((e=resolveTarget(e)).closest)return e.closest(t);do{if(null==e||matches(e,t))return e}while(e=e&&parentElt(e))}function querySelectorAllExt(e,t){return 0===t.indexOf("closest ")?[closest(e,t.substr(8))]:0===t.indexOf("find ")?[find(e,t.substr(5))]:0===t.indexOf("next ")?[scanForwardQuery(e,t.substr(5))]:0===t.indexOf("previous ")?[scanBackwardsQuery(e,t.substr(9))]:"document"===t?[document]:"window"===t?[window]:getDocument().querySelectorAll(t)}var scanForwardQuery=function(e,t){for(var r=getDocument().querySelectorAll(t),n=0;n<r.length;n++){var o=r[n];if(o.compareDocumentPosition(e)===Node.DOCUMENT_POSITION_PRECEDING)return o}},scanBackwardsQuery=function(e,t){for(var r=getDocument().querySelectorAll(t),n=r.length-1;n>=0;n--){var o=r[n];if(o.compareDocumentPosition(e)===Node.DOCUMENT_POSITION_FOLLOWING)return o}};function querySelectorExt(e,t){return t?querySelectorAllExt(e,t)[0]:querySelectorAllExt(getDocument().body,e)[0]}function resolveTarget(e){return isType(e,"String")?find(e):e}function processEventArgs(e,t,r){return isFunction(t)?{target:getDocument().body,event:e,listener:t}:{target:resolveTarget(e),event:t,listener:r}}function addEventListenerImpl(e,t,r){return ready((function(){var n=processEventArgs(e,t,r);n.target.addEventListener(n.event,n.listener)})),isFunction(t)?t:r}function removeEventListenerImpl(e,t,r){return ready((function(){var n=processEventArgs(e,t,r);n.target.removeEventListener(n.event,n.listener)})),isFunction(t)?t:r}var DUMMY_ELT=getDocument().createElement("output");function findAttributeTargets(e,t){var r=getClosestAttributeValue(e,t);if(r){if("this"===r)return[findThisElement(e,t)];var n=querySelectorAllExt(e,r);return 0===n.length?(logError('The selector "'+r+'" on '+t+" returned no matches!"),[DUMMY_ELT]):n}}function findThisElement(e,t){return getClosestMatch(e,(function(e){return null!=getAttributeValue(e,t)}))}function getTarget(e){var t=getClosestAttributeValue(e,"hx-target");return t?"this"===t?findThisElement(e,"hx-target"):querySelectorExt(e,t):getInternalData(e).boosted?getDocument().body:e}function shouldSettleAttribute(e){for(var t=htmx.config.attributesToSettle,r=0;r<t.length;r++)if(e===t[r])return!0;return!1}function cloneAttributes(e,t){forEach(e.attributes,(function(r){!t.hasAttribute(r.name)&&shouldSettleAttribute(r.name)&&e.removeAttribute(r.name)})),forEach(t.attributes,(function(t){shouldSettleAttribute(t.name)&&e.setAttribute(t.name,t.value)}))}function isInlineSwap(e,t){for(var r=getExtensions(t),n=0;n<r.length;n++){var o=r[n];try{if(o.isInlineSwap(e))return!0}catch(e){logError(e)}}return"outerHTML"===e}function oobSwap(e,t,r){var n="#"+t.id,o="outerHTML";"true"===e||(e.indexOf(":")>0?(o=e.substr(0,e.indexOf(":")),n=e.substr(e.indexOf(":")+1,e.length)):o=e);var a=getDocument().querySelectorAll(n);return a?(forEach(a,(function(e){var n,a=t.cloneNode(!0);(n=getDocument().createDocumentFragment()).appendChild(a),isInlineSwap(o,e)||(n=a);var i={shouldSwap:!0,target:e,fragment:n};triggerEvent(e,"htmx:oobBeforeSwap",i)&&(e=i.target,i.shouldSwap&&swap(o,e,e,n,r),forEach(r.elts,(function(e){triggerEvent(e,"htmx:oobAfterSwap",i)})))})),t.parentNode.removeChild(t)):(t.parentNode.removeChild(t),triggerErrorEvent(getDocument().body,"htmx:oobErrorNoTarget",{content:t})),e}function handleOutOfBandSwaps(e,t,r){var n=getClosestAttributeValue(e,"hx-select-oob");if(n){var o=n.split(",");for(let e=0;e<o.length;e++){var a=o[e].split(":",2),i=a[0];0===i.indexOf("#")&&(i=i.substring(1));var s=a[1]||"true",l=t.querySelector("#"+i);l&&oobSwap(s,l,r)}}forEach(findAll(t,"[hx-swap-oob], [data-hx-swap-oob]"),(function(e){var t=getAttributeValue(e,"hx-swap-oob");null!=t&&oobSwap(t,e,r)}))}function handlePreservedElements(e){forEach(findAll(e,"[hx-preserve], [data-hx-preserve]"),(function(e){var t=getAttributeValue(e,"id"),r=getDocument().getElementById(t);null!=r&&e.parentNode.replaceChild(r,e)}))}function handleAttributes(e,t,r){forEach(t.querySelectorAll("[id]"),(function(t){if(t.id&&t.id.length>0){var n=e.querySelector(t.tagName+"[id='"+t.id+"']");if(n&&n!==e){var o=t.cloneNode();cloneAttributes(t,n),r.tasks.push((function(){cloneAttributes(t,o)}))}}}))}function makeAjaxLoadTask(e){return function(){removeClassFromElement(e,htmx.config.addedClass),processNode(e),processScripts(e),processFocus(e),triggerEvent(e,"htmx:load")}}function processFocus(e){var t="[autofocus]",r=matches(e,t)?e:e.querySelector(t);null!=r&&r.focus()}function insertNodesBefore(e,t,r,n){for(handleAttributes(e,r,n);r.childNodes.length>0;){var o=r.firstChild;addClassToElement(o,htmx.config.addedClass),e.insertBefore(o,t),o.nodeType!==Node.TEXT_NODE&&o.nodeType!==Node.COMMENT_NODE&&n.tasks.push(makeAjaxLoadTask(o))}}function stringHash(e,t){for(var r=0;r<e.length;)t=(t<<5)-t+e.charCodeAt(r++)|0;return t}function attributeHash(e){for(var t=0,r=0;r<e.attributes.length;r++){var n=e.attributes[r];n.value&&(t=stringHash(n.name,t),t=stringHash(n.value,t))}return t}function deInitNode(e){var t=getInternalData(e);t.webSocket&&t.webSocket.close(),t.sseEventSource&&t.sseEventSource.close(),t.listenerInfos&&forEach(t.listenerInfos,(function(e){e.on&&e.on.removeEventListener(e.trigger,e.listener)}))}function cleanUpElement(e){triggerEvent(e,"htmx:beforeCleanupElement"),deInitNode(e),e.children&&forEach(e.children,(function(e){cleanUpElement(e)}))}function swapOuterHTML(e,t,r){if("BODY"===e.tagName)return swapInnerHTML(e,t,r);var n,o=e.previousSibling;for(insertNodesBefore(parentElt(e),e,t,r),n=null==o?parentElt(e).firstChild:o.nextSibling,getInternalData(e).replacedWith=n,r.elts=[];n&&n!==e;)n.nodeType===Node.ELEMENT_NODE&&r.elts.push(n),n=n.nextElementSibling;cleanUpElement(e),parentElt(e).removeChild(e)}function swapAfterBegin(e,t,r){return insertNodesBefore(e,e.firstChild,t,r)}function swapBeforeBegin(e,t,r){return insertNodesBefore(parentElt(e),e,t,r)}function swapBeforeEnd(e,t,r){return insertNodesBefore(e,null,t,r)}function swapAfterEnd(e,t,r){return insertNodesBefore(parentElt(e),e.nextSibling,t,r)}function swapDelete(e,t,r){return cleanUpElement(e),parentElt(e).removeChild(e)}function swapInnerHTML(e,t,r){var n=e.firstChild;if(insertNodesBefore(e,n,t,r),n){for(;n.nextSibling;)cleanUpElement(n.nextSibling),e.removeChild(n.nextSibling);cleanUpElement(n),e.removeChild(n)}}function maybeSelectFromResponse(e,t){var r=getClosestAttributeValue(e,"hx-select");if(r){var n=getDocument().createDocumentFragment();forEach(t.querySelectorAll(r),(function(e){n.appendChild(e)})),t=n}return t}function swap(e,t,r,n,o){switch(e){case"none":return;case"outerHTML":return void swapOuterHTML(r,n,o);case"afterbegin":return void swapAfterBegin(r,n,o);case"beforebegin":return void swapBeforeBegin(r,n,o);case"beforeend":return void swapBeforeEnd(r,n,o);case"afterend":return void swapAfterEnd(r,n,o);case"delete":return void swapDelete(r,n,o);default:for(var a=getExtensions(t),i=0;i<a.length;i++){var s=a[i];try{var l=s.handleSwap(e,r,n,o);if(l){if(void 0!==l.length)for(var u=0;u<l.length;u++){var c=l[u];c.nodeType!==Node.TEXT_NODE&&c.nodeType!==Node.COMMENT_NODE&&o.tasks.push(makeAjaxLoadTask(c))}return}}catch(e){logError(e)}}"innerHTML"===e?swapInnerHTML(r,n,o):swap(htmx.config.defaultSwapStyle,t,r,n,o)}}function findTitle(e){if(e.indexOf("<title")>-1){var t=e.replace(/<svg(\s[^>]*>|>)([\s\S]*?)<\/svg>/gim,"").match(/<title(\s[^>]*>|>)([\s\S]*?)<\/title>/im);if(t)return t[2]}}function selectAndSwap(e,t,r,n,o){o.title=findTitle(n);var a=makeFragment(n);if(a)return handleOutOfBandSwaps(r,a,o),handlePreservedElements(a=maybeSelectFromResponse(r,a)),swap(e,r,t,a,o)}function handleTrigger(e,t,r){var n=e.getResponseHeader(t);if(0===n.indexOf("{")){var o=parseJSON(n);for(var a in o)if(o.hasOwnProperty(a)){var i=o[a];isRawObject(i)||(i={value:i}),triggerEvent(r,a,i)}}else triggerEvent(r,n,[])}var WHITESPACE=/\s/,WHITESPACE_OR_COMMA=/[\s,]/,SYMBOL_START=/[_$a-zA-Z]/,SYMBOL_CONT=/[_$a-zA-Z0-9]/,STRINGISH_START=['"',"'","/"],NOT_WHITESPACE=/[^\s]/;function tokenizeString(e){for(var t=[],r=0;r<e.length;){if(SYMBOL_START.exec(e.charAt(r))){for(var n=r;SYMBOL_CONT.exec(e.charAt(r+1));)r++;t.push(e.substr(n,r-n+1))}else if(-1!==STRINGISH_START.indexOf(e.charAt(r))){var o=e.charAt(r);for(n=r,r++;r<e.length&&e.charAt(r)!==o;)"\\"===e.charAt(r)&&r++,r++;t.push(e.substr(n,r-n+1))}else{var a=e.charAt(r);t.push(a)}r++}return t}function isPossibleRelativeReference(e,t,r){return SYMBOL_START.exec(e.charAt(0))&&"true"!==e&&"false"!==e&&"this"!==e&&e!==r&&"."!==t}function maybeGenerateConditional(e,t,r){if("["===t[0]){t.shift();for(var n=1,o=" return (function("+r+"){ return (",a=null;t.length>0;){var i=t[0];if("]"===i){if(0==--n){null===a&&(o+="true"),t.shift(),o+=")})";try{var s=maybeEval(e,(function(){return Function(o)()}),(function(){return!0}));return s.source=o,s}catch(e){return triggerErrorEvent(getDocument().body,"htmx:syntax:error",{error:e,source:o}),null}}}else"["===i&&n++;isPossibleRelativeReference(i,a,r)?o+="(("+r+"."+i+") ? ("+r+"."+i+") : (window."+i+"))":o+=i,a=t.shift()}}}function consumeUntil(e,t){for(var r="";e.length>0&&!e[0].match(t);)r+=e.shift();return r}var INPUT_SELECTOR="input, textarea, select";function getTriggerSpecs(e){var t=getAttributeValue(e,"hx-trigger"),r=[];if(t){var n=tokenizeString(t);do{consumeUntil(n,NOT_WHITESPACE);var o=n.length,a=consumeUntil(n,/[,\[\s]/);if(""!==a)if("every"===a){var i={trigger:"every"};consumeUntil(n,NOT_WHITESPACE),i.pollInterval=parseInterval(consumeUntil(n,/[,\[\s]/)),consumeUntil(n,NOT_WHITESPACE),(s=maybeGenerateConditional(e,n,"event"))&&(i.eventFilter=s),r.push(i)}else if(0===a.indexOf("sse:"))r.push({trigger:"sse",sseEvent:a.substr(4)});else{var s,l={trigger:a};for((s=maybeGenerateConditional(e,n,"event"))&&(l.eventFilter=s);n.length>0&&","!==n[0];){consumeUntil(n,NOT_WHITESPACE);var u=n.shift();if("changed"===u)l.changed=!0;else if("once"===u)l.once=!0;else if("consume"===u)l.consume=!0;else if("delay"===u&&":"===n[0])n.shift(),l.delay=parseInterval(consumeUntil(n,WHITESPACE_OR_COMMA));else if("from"===u&&":"===n[0]){n.shift();var c=consumeUntil(n,WHITESPACE_OR_COMMA);"closest"!==c&&"find"!==c&&"next"!==c&&"previous"!==c||(n.shift(),c+=" "+consumeUntil(n,WHITESPACE_OR_COMMA)),l.from=c}else"target"===u&&":"===n[0]?(n.shift(),l.target=consumeUntil(n,WHITESPACE_OR_COMMA)):"throttle"===u&&":"===n[0]?(n.shift(),l.throttle=parseInterval(consumeUntil(n,WHITESPACE_OR_COMMA))):"queue"===u&&":"===n[0]?(n.shift(),l.queue=consumeUntil(n,WHITESPACE_OR_COMMA)):"root"!==u&&"threshold"!==u||":"!==n[0]?triggerErrorEvent(e,"htmx:syntax:error",{token:n.shift()}):(n.shift(),l[u]=consumeUntil(n,WHITESPACE_OR_COMMA))}r.push(l)}n.length===o&&triggerErrorEvent(e,"htmx:syntax:error",{token:n.shift()}),consumeUntil(n,NOT_WHITESPACE)}while(","===n[0]&&n.shift())}return r.length>0?r:matches(e,"form")?[{trigger:"submit"}]:matches(e,'input[type="button"]')?[{trigger:"click"}]:matches(e,INPUT_SELECTOR)?[{trigger:"change"}]:[{trigger:"click"}]}function cancelPolling(e){getInternalData(e).cancelled=!0}function processPolling(e,t,r){var n=getInternalData(e);n.timeout=setTimeout((function(){bodyContains(e)&&!0!==n.cancelled&&(maybeFilterEvent(r,makeEvent("hx:poll:trigger",{triggerSpec:r,target:e}))||t(e),processPolling(e,t,r))}),r.pollInterval)}function isLocalLink(e){return location.hostname===e.hostname&&getRawAttribute(e,"href")&&0!==getRawAttribute(e,"href").indexOf("#")}function boostElement(e,t,r){if("A"===e.tagName&&isLocalLink(e)&&(""===e.target||"_self"===e.target)||"FORM"===e.tagName){var n,o;if(t.boosted=!0,"A"===e.tagName)n="get",o=getRawAttribute(e,"href");else{var a=getRawAttribute(e,"method");n=a?a.toLowerCase():"get",o=getRawAttribute(e,"action")}r.forEach((function(r){addEventListener(e,(function(t){issueAjaxRequest(n,o,e,t)}),t,r,!0)}))}}function shouldCancel(e,t){if("submit"===e.type||"click"===e.type){if("FORM"===t.tagName)return!0;if(matches(t,'input[type="submit"], button')&&null!==closest(t,"form"))return!0;if("A"===t.tagName&&t.href&&("#"===t.getAttribute("href")||0!==t.getAttribute("href").indexOf("#")))return!0}return!1}function ignoreBoostedAnchorCtrlClick(e,t){return getInternalData(e).boosted&&"A"===e.tagName&&"click"===t.type&&(t.ctrlKey||t.metaKey)}function maybeFilterEvent(e,t){var r=e.eventFilter;if(r)try{return!0!==r(t)}catch(e){return triggerErrorEvent(getDocument().body,"htmx:eventFilter:error",{error:e,source:r.source}),!0}return!1}function addEventListener(e,t,r,n,o){forEach(n.from?querySelectorAllExt(e,n.from):[e],(function(a){var i=function(r){if(bodyContains(e)){if(!ignoreBoostedAnchorCtrlClick(e,r)&&((o||shouldCancel(r,e))&&r.preventDefault(),!maybeFilterEvent(n,r))){var s=getInternalData(r);s.triggerSpec=n,null==s.handledFor&&(s.handledFor=[]);var l=getInternalData(e);if(s.handledFor.indexOf(e)<0){if(s.handledFor.push(e),n.consume&&r.stopPropagation(),n.target&&r.target&&!matches(r.target,n.target))return;if(n.once){if(l.triggeredOnce)return;l.triggeredOnce=!0}if(n.changed){if(l.lastValue===e.value)return;l.lastValue=e.value}if(l.delayed&&clearTimeout(l.delayed),l.throttle)return;n.throttle?l.throttle||(t(e,r),l.throttle=setTimeout((function(){l.throttle=null}),n.throttle)):n.delay?l.delayed=setTimeout((function(){t(e,r)}),n.delay):t(e,r)}}}else a.removeEventListener(n.trigger,i)};null==r.listenerInfos&&(r.listenerInfos=[]),r.listenerInfos.push({trigger:n.trigger,listener:i,on:a}),a.addEventListener(n.trigger,i)}))}var windowIsScrolling=!1,scrollHandler=null;function initScrollHandler(){scrollHandler||(scrollHandler=function(){windowIsScrolling=!0},window.addEventListener("scroll",scrollHandler),setInterval((function(){windowIsScrolling&&(windowIsScrolling=!1,forEach(getDocument().querySelectorAll("[hx-trigger='revealed'],[data-hx-trigger='revealed']"),(function(e){maybeReveal(e)})))}),200))}function maybeReveal(e){!hasAttribute(e,"data-hx-revealed")&&isScrolledIntoView(e)&&(e.setAttribute("data-hx-revealed","true"),getInternalData(e).initHash?triggerEvent(e,"revealed"):e.addEventListener("htmx:afterProcessNode",(function(t){triggerEvent(e,"revealed")}),{once:!0}))}function processWebSocketInfo(e,t,r){for(var n=splitOnWhitespace(r),o=0;o<n.length;o++){var a=n[o].split(/:(.+)/);"connect"===a[0]&&ensureWebSocket(e,a[1],0),"send"===a[0]&&processWebSocketSend(e)}}function ensureWebSocket(e,t,r){if(bodyContains(e)){if(0==t.indexOf("/")){var n=location.hostname+(location.port?":"+location.port:"");"https:"==location.protocol?t="wss://"+n+t:"http:"==location.protocol&&(t="ws://"+n+t)}var o=htmx.createWebSocket(t);o.onerror=function(t){triggerErrorEvent(e,"htmx:wsError",{error:t,socket:o}),maybeCloseWebSocketSource(e)},o.onclose=function(n){if([1006,1012,1013].indexOf(n.code)>=0){var o=getWebSocketReconnectDelay(r);setTimeout((function(){ensureWebSocket(e,t,r+1)}),o)}},o.onopen=function(e){r=0},getInternalData(e).webSocket=o,o.addEventListener("message",(function(t){if(!maybeCloseWebSocketSource(e)){var r=t.data;withExtensions(e,(function(t){r=t.transformResponse(r,null,e)}));for(var n=makeSettleInfo(e),o=toArray(makeFragment(r).children),a=0;a<o.length;a++){var i=o[a];oobSwap(getAttributeValue(i,"hx-swap-oob")||"true",i,n)}settleImmediately(n.tasks)}}))}}function maybeCloseWebSocketSource(e){if(!bodyContains(e))return getInternalData(e).webSocket.close(),!0}function processWebSocketSend(e){var t=getClosestMatch(e,(function(e){return null!=getInternalData(e).webSocket}));t?e.addEventListener(getTriggerSpecs(e)[0].trigger,(function(r){var n=getInternalData(t).webSocket,o=getHeaders(e,t),a=getInputValues(e,"post"),i=a.errors,s=filterValues(mergeObjects(a.values,getExpressionVars(e)),e);s.HEADERS=o,i&&i.length>0?triggerEvent(e,"htmx:validation:halted",i):(n.send(JSON.stringify(s)),shouldCancel(r,e)&&r.preventDefault())})):triggerErrorEvent(e,"htmx:noWebSocketSourceError")}function getWebSocketReconnectDelay(e){var t=htmx.config.wsReconnectDelay;if("function"==typeof t)return t(e);if("full-jitter"===t){var r=Math.min(e,6);return 1e3*Math.pow(2,r)*Math.random()}logError('htmx.config.wsReconnectDelay must either be a function or the string "full-jitter"')}function processSSEInfo(e,t,r){for(var n=splitOnWhitespace(r),o=0;o<n.length;o++){var a=n[o].split(/:(.+)/);"connect"===a[0]&&processSSESource(e,a[1]),"swap"===a[0]&&processSSESwap(e,a[1])}}function processSSESource(e,t){var r=htmx.createEventSource(t);r.onerror=function(t){triggerErrorEvent(e,"htmx:sseError",{error:t,source:r}),maybeCloseSSESource(e)},getInternalData(e).sseEventSource=r}function processSSESwap(e,t){var r=getClosestMatch(e,hasEventSource);if(r){var n=getInternalData(r).sseEventSource,o=function(a){if(maybeCloseSSESource(r))n.removeEventListener(t,o);else{var i=a.data;withExtensions(e,(function(t){i=t.transformResponse(i,null,e)}));var s=getSwapSpecification(e),l=getTarget(e),u=makeSettleInfo(e);selectAndSwap(s.swapStyle,e,l,i,u),settleImmediately(u.tasks),triggerEvent(e,"htmx:sseMessage",a)}};getInternalData(e).sseListener=o,n.addEventListener(t,o)}else triggerErrorEvent(e,"htmx:noSSESourceError")}function processSSETrigger(e,t,r){var n=getClosestMatch(e,hasEventSource);if(n){var o=getInternalData(n).sseEventSource,a=function(){maybeCloseSSESource(n)||(bodyContains(e)?t(e):o.removeEventListener(r,a))};getInternalData(e).sseListener=a,o.addEventListener(r,a)}else triggerErrorEvent(e,"htmx:noSSESourceError")}function maybeCloseSSESource(e){if(!bodyContains(e))return getInternalData(e).sseEventSource.close(),!0}function hasEventSource(e){return null!=getInternalData(e).sseEventSource}function loadImmediately(e,t,r,n){var o=function(){r.loaded||(r.loaded=!0,t(e))};n?setTimeout(o,n):o()}function processVerbs(e,t,r){var n=!1;return forEach(VERBS,(function(o){if(hasAttribute(e,"hx-"+o)){var a=getAttributeValue(e,"hx-"+o);n=!0,t.path=a,t.verb=o,r.forEach((function(r){addTriggerHandler(e,r,t,(function(e,t){issueAjaxRequest(o,a,e,t)}))}))}})),n}function addTriggerHandler(e,t,r,n){if(t.sseEvent)processSSETrigger(e,n,t.sseEvent);else if("revealed"===t.trigger)initScrollHandler(),addEventListener(e,n,r,t),maybeReveal(e);else if("intersect"===t.trigger){var o={};t.root&&(o.root=querySelectorExt(e,t.root)),t.threshold&&(o.threshold=parseFloat(t.threshold)),new IntersectionObserver((function(t){for(var r=0;r<t.length;r++)if(t[r].isIntersecting){triggerEvent(e,"intersect");break}}),o).observe(e),addEventListener(e,n,r,t)}else"load"===t.trigger?maybeFilterEvent(t,makeEvent("load",{elt:e}))||loadImmediately(e,n,r,t.delay):t.pollInterval?(r.polling=!0,processPolling(e,n,t)):addEventListener(e,n,r,t)}function evalScript(e){if("text/javascript"===e.type||"module"===e.type||""===e.type){var t=getDocument().createElement("script");forEach(e.attributes,(function(e){t.setAttribute(e.name,e.value)})),t.textContent=e.textContent,t.async=!1,htmx.config.inlineScriptNonce&&(t.nonce=htmx.config.inlineScriptNonce);var r=e.parentElement;try{r.insertBefore(t,e)}catch(e){logError(e)}finally{r.removeChild(e)}}}function processScripts(e){matches(e,"script")&&evalScript(e),forEach(findAll(e,"script"),(function(e){evalScript(e)}))}function hasChanceOfBeingBoosted(){return document.querySelector("[hx-boost], [data-hx-boost]")}function findElementsToProcess(e){if(e.querySelectorAll){var t=hasChanceOfBeingBoosted()?", a, form":"";return e.querySelectorAll(VERB_SELECTOR+t+", [hx-sse], [data-hx-sse], [hx-ws], [data-hx-ws], [hx-ext], [data-hx-ext]")}return[]}function initButtonTracking(e){var t=function(t){matches(t.target,"button, input[type='submit']")&&(getInternalData(e).lastButtonClicked=t.target)};e.addEventListener("click",t),e.addEventListener("focusin",t),e.addEventListener("focusout",(function(t){getInternalData(e).lastButtonClicked=null}))}function initNode(e){if(!e.closest||!e.closest(htmx.config.disableSelector)){var t=getInternalData(e);if(t.initHash!==attributeHash(e)){t.initHash=attributeHash(e),deInitNode(e),triggerEvent(e,"htmx:beforeProcessNode"),e.value&&(t.lastValue=e.value);var r=getTriggerSpecs(e);processVerbs(e,t,r)||"true"!==getClosestAttributeValue(e,"hx-boost")||boostElement(e,t,r),"FORM"===e.tagName&&initButtonTracking(e);var n=getAttributeValue(e,"hx-sse");n&&processSSEInfo(e,t,n);var o=getAttributeValue(e,"hx-ws");o&&processWebSocketInfo(e,t,o),triggerEvent(e,"htmx:afterProcessNode")}}}function processNode(e){initNode(e=resolveTarget(e)),forEach(findElementsToProcess(e),(function(e){initNode(e)}))}function kebabEventName(e){return e.replace(/([a-z0-9])([A-Z])/g,"$1-$2").toLowerCase()}function makeEvent(e,t){var r;return window.CustomEvent&&"function"==typeof window.CustomEvent?r=new CustomEvent(e,{bubbles:!0,cancelable:!0,detail:t}):(r=getDocument().createEvent("CustomEvent")).initCustomEvent(e,!0,!0,t),r}function triggerErrorEvent(e,t,r){triggerEvent(e,t,mergeObjects({error:t},r))}function ignoreEventForLogging(e){return"htmx:afterProcessNode"===e}function withExtensions(e,t){forEach(getExtensions(e),(function(e){try{t(e)}catch(e){logError(e)}}))}function logError(e){console.error?console.error(e):console.log&&console.log("ERROR: ",e)}function triggerEvent(e,t,r){e=resolveTarget(e),null==r&&(r={}),r.elt=e;var n=makeEvent(t,r);htmx.logger&&!ignoreEventForLogging(t)&&htmx.logger(e,t,r),r.error&&(logError(r.error),triggerEvent(e,"htmx:error",{errorInfo:r}));var o=e.dispatchEvent(n),a=kebabEventName(t);if(o&&a!==t){var i=makeEvent(a,n.detail);o=o&&e.dispatchEvent(i)}return withExtensions(e,(function(e){o=o&&!1!==e.onEvent(t,n)})),o}var currentPathForHistory=location.pathname+location.search;function getHistoryElement(){return getDocument().querySelector("[hx-history-elt],[data-hx-history-elt]")||getDocument().body}function saveToHistoryCache(e,t,r,n){if(canAccessLocalStorage()){for(var o=parseJSON(localStorage.getItem("htmx-history-cache"))||[],a=0;a<o.length;a++)if(o[a].url===e){o.splice(a,1);break}var i={url:e,content:t,title:r,scroll:n};for(triggerEvent(getDocument().body,"htmx:historyItemCreated",{item:i,cache:o}),o.push(i);o.length>htmx.config.historyCacheSize;)o.shift();for(;o.length>0;)try{localStorage.setItem("htmx-history-cache",JSON.stringify(o));break}catch(e){triggerErrorEvent(getDocument().body,"htmx:historyCacheError",{cause:e,cache:o}),o.shift()}}}function getCachedHistory(e){if(!canAccessLocalStorage())return null;for(var t=parseJSON(localStorage.getItem("htmx-history-cache"))||[],r=0;r<t.length;r++)if(t[r].url===e)return t[r];return null}function cleanInnerHtmlForHistory(e){var t=htmx.config.requestClass,r=e.cloneNode(!0);return forEach(findAll(r,"."+t),(function(e){removeClassFromElement(e,t)})),r.innerHTML}function saveCurrentPageToHistory(){var e=getHistoryElement(),t=currentPathForHistory||location.pathname+location.search;triggerEvent(getDocument().body,"htmx:beforeHistorySave",{path:t,historyElt:e}),htmx.config.historyEnabled&&history.replaceState({htmx:!0},getDocument().title,window.location.href),saveToHistoryCache(t,cleanInnerHtmlForHistory(e),getDocument().title,window.scrollY)}function pushUrlIntoHistory(e){htmx.config.historyEnabled&&history.pushState({htmx:!0},"",e),currentPathForHistory=e}function replaceUrlInHistory(e){htmx.config.historyEnabled&&history.replaceState({htmx:!0},"",e),currentPathForHistory=e}function settleImmediately(e){forEach(e,(function(e){e.call()}))}function loadHistoryFromServer(e){var t=new XMLHttpRequest,r={path:e,xhr:t};triggerEvent(getDocument().body,"htmx:historyCacheMiss",r),t.open("GET",e,!0),t.setRequestHeader("HX-History-Restore-Request","true"),t.onload=function(){if(this.status>=200&&this.status<400){triggerEvent(getDocument().body,"htmx:historyCacheMissLoad",r);var t=makeFragment(this.response);t=t.querySelector("[hx-history-elt],[data-hx-history-elt]")||t;var n=getHistoryElement(),o=makeSettleInfo(n),a=findTitle(this.response);if(a){var i=find("title");i?i.innerHTML=a:window.document.title=a}swapInnerHTML(n,t,o),settleImmediately(o.tasks),currentPathForHistory=e,triggerEvent(getDocument().body,"htmx:historyRestore",{path:e,cacheMiss:!0,serverResponse:this.response})}else triggerErrorEvent(getDocument().body,"htmx:historyCacheMissLoadError",r)},t.send()}function restoreHistory(e){saveCurrentPageToHistory();var t=getCachedHistory(e=e||location.pathname+location.search);if(t){var r=makeFragment(t.content),n=getHistoryElement(),o=makeSettleInfo(n);swapInnerHTML(n,r,o),settleImmediately(o.tasks),document.title=t.title,window.scrollTo(0,t.scroll),currentPathForHistory=e,triggerEvent(getDocument().body,"htmx:historyRestore",{path:e,item:t})}else htmx.config.refreshOnHistoryMiss?window.location.reload(!0):loadHistoryFromServer(e)}function addRequestIndicatorClasses(e){var t=findAttributeTargets(e,"hx-indicator");return null==t&&(t=[e]),forEach(t,(function(e){var t=getInternalData(e);t.requestCount=(t.requestCount||0)+1,e.classList.add.call(e.classList,htmx.config.requestClass)})),t}function removeRequestIndicatorClasses(e){forEach(e,(function(e){var t=getInternalData(e);t.requestCount=(t.requestCount||0)-1,0===t.requestCount&&e.classList.remove.call(e.classList,htmx.config.requestClass)}))}function haveSeenNode(e,t){for(var r=0;r<e.length;r++)if(e[r].isSameNode(t))return!0;return!1}function shouldInclude(e){return""!==e.name&&null!=e.name&&!e.disabled&&"button"!==e.type&&"submit"!==e.type&&"image"!==e.tagName&&"reset"!==e.tagName&&"file"!==e.tagName&&("checkbox"!==e.type&&"radio"!==e.type||e.checked)}function processInputValue(e,t,r,n,o){if(null!=n&&!haveSeenNode(e,n)){if(e.push(n),shouldInclude(n)){var a=getRawAttribute(n,"name"),i=n.value;if(n.multiple&&(i=toArray(n.querySelectorAll("option:checked")).map((function(e){return e.value}))),n.files&&(i=toArray(n.files)),null!=a&&null!=i){var s=t[a];s?Array.isArray(s)?Array.isArray(i)?t[a]=s.concat(i):s.push(i):Array.isArray(i)?t[a]=[s].concat(i):t[a]=[s,i]:t[a]=i}o&&validateElement(n,r)}matches(n,"form")&&forEach(n.elements,(function(n){processInputValue(e,t,r,n,o)}))}}function validateElement(e,t){e.willValidate&&(triggerEvent(e,"htmx:validation:validate"),e.checkValidity()||(t.push({elt:e,message:e.validationMessage,validity:e.validity}),triggerEvent(e,"htmx:validation:failed",{message:e.validationMessage,validity:e.validity})))}function getInputValues(e,t){var r=[],n={},o={},a=[],i=getInternalData(e),s=matches(e,"form")&&!0!==e.noValidate||"true"===getAttributeValue(e,"hx-validate");if(i.lastButtonClicked&&(s=s&&!0!==i.lastButtonClicked.formNoValidate),"get"!==t&&processInputValue(r,o,a,closest(e,"form"),s),processInputValue(r,n,a,e,s),i.lastButtonClicked){var l=getRawAttribute(i.lastButtonClicked,"name");l&&(n[l]=i.lastButtonClicked.value)}return forEach(findAttributeTargets(e,"hx-include"),(function(e){processInputValue(r,n,a,e,s),matches(e,"form")||forEach(e.querySelectorAll(INPUT_SELECTOR),(function(e){processInputValue(r,n,a,e,s)}))})),n=mergeObjects(n,o),{errors:a,values:n}}function appendParam(e,t,r){""!==e&&(e+="&"),"[object Object]"===String(r)&&(r=JSON.stringify(r));var n=encodeURIComponent(r);return e+(encodeURIComponent(t)+"=")+n}function urlEncode(e){var t="";for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];Array.isArray(n)?forEach(n,(function(e){t=appendParam(t,r,e)})):t=appendParam(t,r,n)}return t}function makeFormData(e){var t=new FormData;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];Array.isArray(n)?forEach(n,(function(e){t.append(r,e)})):t.append(r,n)}return t}function getHeaders(e,t,r){var n={"HX-Request":"true","HX-Trigger":getRawAttribute(e,"id"),"HX-Trigger-Name":getRawAttribute(e,"name"),"HX-Target":getAttributeValue(t,"id"),"HX-Current-URL":getDocument().location.href};return getValuesForElement(e,"hx-headers",!1,n),void 0!==r&&(n["HX-Prompt"]=r),getInternalData(e).boosted&&(n["HX-Boosted"]="true"),n}function filterValues(e,t){var r=getClosestAttributeValue(t,"hx-params");if(r){if("none"===r)return{};if("*"===r)return e;if(0===r.indexOf("not "))return forEach(r.substr(4).split(","),(function(t){t=t.trim(),delete e[t]})),e;var n={};return forEach(r.split(","),(function(t){t=t.trim(),n[t]=e[t]})),n}return e}function isAnchorLink(e){return getRawAttribute(e,"href")&&getRawAttribute(e,"href").indexOf("#")>=0}function getSwapSpecification(e,t){var r=t||getClosestAttributeValue(e,"hx-swap"),n={swapStyle:getInternalData(e).boosted?"innerHTML":htmx.config.defaultSwapStyle,swapDelay:htmx.config.defaultSwapDelay,settleDelay:htmx.config.defaultSettleDelay};if(getInternalData(e).boosted&&!isAnchorLink(e)&&(n.show="top"),r){var o=splitOnWhitespace(r);if(o.length>0){n.swapStyle=o[0];for(var a=1;a<o.length;a++){var i=o[a];if(0===i.indexOf("swap:")&&(n.swapDelay=parseInterval(i.substr(5))),0===i.indexOf("settle:")&&(n.settleDelay=parseInterval(i.substr(7))),0===i.indexOf("scroll:")){var s=(u=i.substr(7).split(":")).pop(),l=u.length>0?u.join(":"):null;n.scroll=s,n.scrollTarget=l}if(0===i.indexOf("show:")){var u,c=(u=i.substr(5).split(":")).pop();l=u.length>0?u.join(":"):null,n.show=c,n.showTarget=l}if(0===i.indexOf("focus-scroll:")){var f=i.substr("focus-scroll:".length);n.focusScroll="true"==f}}}}return n}function usesFormData(e){return"multipart/form-data"===getClosestAttributeValue(e,"hx-encoding")||matches(e,"form")&&"multipart/form-data"===getRawAttribute(e,"enctype")}function encodeParamsForBody(e,t,r){var n=null;return withExtensions(t,(function(o){null==n&&(n=o.encodeParameters(e,r,t))})),null!=n?n:usesFormData(t)?makeFormData(r):urlEncode(r)}function makeSettleInfo(e){return{tasks:[],elts:[e]}}function updateScrollState(e,t){var r=e[0],n=e[e.length-1];if(t.scroll){var o=null;t.scrollTarget&&(o=querySelectorExt(r,t.scrollTarget)),"top"===t.scroll&&(r||o)&&((o=o||r).scrollTop=0),"bottom"===t.scroll&&(n||o)&&((o=o||n).scrollTop=o.scrollHeight)}if(t.show){if(o=null,t.showTarget){var a=t.showTarget;"window"===t.showTarget&&(a="body"),o=querySelectorExt(r,a)}"top"===t.show&&(r||o)&&(o=o||r).scrollIntoView({block:"start",behavior:htmx.config.scrollBehavior}),"bottom"===t.show&&(n||o)&&(o=o||n).scrollIntoView({block:"end",behavior:htmx.config.scrollBehavior})}}function getValuesForElement(e,t,r,n){if(null==n&&(n={}),null==e)return n;var o=getAttributeValue(e,t);if(o){var a,i=o.trim(),s=r;if("unset"===i)return null;for(var l in 0===i.indexOf("javascript:")?(i=i.substr(11),s=!0):0===i.indexOf("js:")&&(i=i.substr(3),s=!0),0!==i.indexOf("{")&&(i="{"+i+"}"),a=s?maybeEval(e,(function(){return Function("return ("+i+")")()}),{}):parseJSON(i))a.hasOwnProperty(l)&&null==n[l]&&(n[l]=a[l])}return getValuesForElement(parentElt(e),t,r,n)}function maybeEval(e,t,r){return htmx.config.allowEval?t():(triggerErrorEvent(e,"htmx:evalDisallowedError"),r)}function getHXVarsForElement(e,t){return getValuesForElement(e,"hx-vars",!0,t)}function getHXValsForElement(e,t){return getValuesForElement(e,"hx-vals",!1,t)}function getExpressionVars(e){return mergeObjects(getHXVarsForElement(e),getHXValsForElement(e))}function safelySetHeaderValue(e,t,r){if(null!==r)try{e.setRequestHeader(t,r)}catch(n){e.setRequestHeader(t,encodeURIComponent(r)),e.setRequestHeader(t+"-URI-AutoEncoded","true")}}function getPathFromResponse(e){if(e.responseURL&&"undefined"!=typeof URL)try{var t=new URL(e.responseURL);return t.pathname+t.search}catch(t){triggerErrorEvent(getDocument().body,"htmx:badResponseUrl",{url:e.responseURL})}}function hasHeader(e,t){return e.getAllResponseHeaders().match(t)}function ajaxHelper(e,t,r){return e=e.toLowerCase(),r?r instanceof Element||isType(r,"String")?issueAjaxRequest(e,t,null,null,{targetOverride:resolveTarget(r),returnPromise:!0}):issueAjaxRequest(e,t,resolveTarget(r.source),r.event,{handler:r.handler,headers:r.headers,values:r.values,targetOverride:resolveTarget(r.target),swapOverride:r.swap,returnPromise:!0}):issueAjaxRequest(e,t,null,null,{returnPromise:!0})}function hierarchyForElt(e){for(var t=[];e;)t.push(e),e=e.parentElement;return t}function issueAjaxRequest(e,t,r,n,o,a){var i=null,s=null;if((o=null!=o?o:{}).returnPromise&&"undefined"!=typeof Promise)var l=new Promise((function(e,t){i=e,s=t}));null==r&&(r=getDocument().body);var u=o.handler||handleAjaxResponse;if(bodyContains(r)){var c=o.targetOverride||getTarget(r);if(null!=c&&c!=DUMMY_ELT){if(!a&&!1===triggerEvent(r,"htmx:confirm",{target:c,elt:r,path:t,verb:e,triggeringEvent:n,etc:o,issueRequest:function(){return issueAjaxRequest(e,t,r,n,o,!0)}}))return;var f=r,g=getInternalData(r),d=getClosestAttributeValue(r,"hx-sync"),h=null,m=!1;if(d){var v=d.split(":"),p=v[0].trim();if(f="this"===p?findThisElement(r,"hx-sync"):querySelectorExt(r,p),d=(v[1]||"drop").trim(),g=getInternalData(f),"drop"===d&&g.xhr&&!0!==g.abortable)return;if("abort"===d){if(g.xhr)return;m=!0}else"replace"===d?triggerEvent(f,"htmx:abort"):0===d.indexOf("queue")&&(h=(d.split(" ")[1]||"last").trim())}if(g.xhr){if(!g.abortable){if(null==h){if(n){var E=getInternalData(n);E&&E.triggerSpec&&E.triggerSpec.queue&&(h=E.triggerSpec.queue)}null==h&&(h="last")}return null==g.queuedRequests&&(g.queuedRequests=[]),void("first"===h&&0===g.queuedRequests.length||"all"===h?g.queuedRequests.push((function(){issueAjaxRequest(e,t,r,n,o)})):"last"===h&&(g.queuedRequests=[],g.queuedRequests.push((function(){issueAjaxRequest(e,t,r,n,o)}))))}triggerEvent(f,"htmx:abort")}var b=new XMLHttpRequest;g.xhr=b,g.abortable=m;var y=function(){g.xhr=null,g.abortable=!1,null!=g.queuedRequests&&g.queuedRequests.length>0&&g.queuedRequests.shift()()},S=getClosestAttributeValue(r,"hx-prompt");if(S){var x=prompt(S);if(null===x||!triggerEvent(r,"htmx:prompt",{prompt:x,target:c}))return maybeCall(i),y(),l}var C=getClosestAttributeValue(r,"hx-confirm");if(C&&!confirm(C))return maybeCall(i),y(),l;var w=getHeaders(r,c,x);o.headers&&(w=mergeObjects(w,o.headers));var A=getInputValues(r,e),T=A.errors,I=A.values;o.values&&(I=mergeObjects(I,o.values));var H=mergeObjects(I,getExpressionVars(r)),R=filterValues(H,r);"get"===e||usesFormData(r)||(w["Content-Type"]="application/x-www-form-urlencoded"),null!=t&&""!==t||(t=getDocument().location.href);var O=getValuesForElement(r,"hx-request"),D=getInternalData(r).boosted,L={boosted:D,parameters:R,unfilteredParameters:H,headers:w,target:c,verb:e,errors:T,withCredentials:o.credentials||O.credentials||htmx.config.withCredentials,timeout:o.timeout||O.timeout||htmx.config.timeout,path:t,triggeringEvent:n};if(!triggerEvent(r,"htmx:configRequest",L))return maybeCall(i),y(),l;if(t=L.path,e=L.verb,w=L.headers,R=L.parameters,(T=L.errors)&&T.length>0)return triggerEvent(r,"htmx:validation:halted",L),maybeCall(i),y(),l;var q=t.split("#"),k=q[0],N=q[1],M=null;if("get"===e?(M=k,0!==Object.keys(R).length&&(M.indexOf("?")<0?M+="?":M+="&",M+=urlEncode(R),N&&(M+="#"+N)),b.open("GET",M,!0)):b.open(e.toUpperCase(),t,!0),b.overrideMimeType("text/html"),b.withCredentials=L.withCredentials,b.timeout=L.timeout,O.noHeaders);else for(var F in w)if(w.hasOwnProperty(F)){var V=w[F];safelySetHeaderValue(b,F,V)}var P={xhr:b,target:c,requestConfig:L,etc:o,boosted:D,pathInfo:{requestPath:t,finalRequestPath:M||t,anchor:N}};if(b.onload=function(){try{var e=hierarchyForElt(r);if(P.pathInfo.responsePath=getPathFromResponse(b),u(r,P),removeRequestIndicatorClasses(B),triggerEvent(r,"htmx:afterRequest",P),triggerEvent(r,"htmx:afterOnLoad",P),!bodyContains(r)){for(var t=null;e.length>0&&null==t;){var n=e.shift();bodyContains(n)&&(t=n)}t&&(triggerEvent(t,"htmx:afterRequest",P),triggerEvent(t,"htmx:afterOnLoad",P))}maybeCall(i),y()}catch(e){throw triggerErrorEvent(r,"htmx:onLoadError",mergeObjects({error:e},P)),e}},b.onerror=function(){removeRequestIndicatorClasses(B),triggerErrorEvent(r,"htmx:afterRequest",P),triggerErrorEvent(r,"htmx:sendError",P),maybeCall(s),y()},b.onabort=function(){removeRequestIndicatorClasses(B),triggerErrorEvent(r,"htmx:afterRequest",P),triggerErrorEvent(r,"htmx:sendAbort",P),maybeCall(s),y()},b.ontimeout=function(){removeRequestIndicatorClasses(B),triggerErrorEvent(r,"htmx:afterRequest",P),triggerErrorEvent(r,"htmx:timeout",P),maybeCall(s),y()},!triggerEvent(r,"htmx:beforeRequest",P))return maybeCall(i),y(),l;var B=addRequestIndicatorClasses(r);return forEach(["loadstart","loadend","progress","abort"],(function(e){forEach([b,b.upload],(function(t){t.addEventListener(e,(function(t){triggerEvent(r,"htmx:xhr:"+e,{lengthComputable:t.lengthComputable,loaded:t.loaded,total:t.total})}))}))})),triggerEvent(r,"htmx:beforeSend",P),b.send("get"===e?null:encodeParamsForBody(b,r,R)),l}triggerErrorEvent(r,"htmx:targetError",{target:getAttributeValue(r,"hx-target")})}}function determineHistoryUpdates(e,t){var r=t.xhr,n=null,o=null;if(hasHeader(r,/HX-Push:/i)?(n=r.getResponseHeader("HX-Push"),o="push"):hasHeader(r,/HX-Push-Url:/i)?(n=r.getResponseHeader("HX-Push-Url"),o="push"):hasHeader(r,/HX-Replace-Url:/i)&&(n=r.getResponseHeader("HX-Replace-Url"),o="replace"),n)return"false"===n?{}:{type:o,path:n};var a=t.pathInfo.finalRequestPath,i=t.pathInfo.responsePath,s=getClosestAttributeValue(e,"hx-push-url"),l=getClosestAttributeValue(e,"hx-replace-url"),u=getInternalData(e).boosted,c=null,f=null;return s?(c="push",f=s):l?(c="replace",f=l):u&&(c="push",f=i||a),f?"false"===f?{}:("true"===f&&(f=i||a),t.pathInfo.anchor&&-1===f.indexOf("#")&&(f=f+"#"+t.pathInfo.anchor),{type:c,path:f}):{}}function handleAjaxResponse(e,t){var r=t.xhr,n=t.target,o=t.etc;if(triggerEvent(e,"htmx:beforeOnLoad",t)){if(hasHeader(r,/HX-Trigger:/i)&&handleTrigger(r,"HX-Trigger",e),hasHeader(r,/HX-Location:/i)){saveCurrentPageToHistory();var a=r.getResponseHeader("HX-Location");return 0===a.indexOf("{")&&(g=parseJSON(a),a=g.path,delete g.path),void ajaxHelper("GET",a,g).then((function(){pushUrlIntoHistory(a)}))}if(hasHeader(r,/HX-Redirect:/i))location.href=r.getResponseHeader("HX-Redirect");else if(hasHeader(r,/HX-Refresh:/i)&&"true"===r.getResponseHeader("HX-Refresh"))location.reload();else{hasHeader(r,/HX-Retarget:/i)&&(t.target=getDocument().querySelector(r.getResponseHeader("HX-Retarget")));var i=determineHistoryUpdates(e,t),s=r.status>=200&&r.status<400&&204!==r.status,l=r.response,u=r.status>=400,c=mergeObjects({shouldSwap:s,serverResponse:l,isError:u},t);if(triggerEvent(n,"htmx:beforeSwap",c)){if(n=c.target,l=c.serverResponse,u=c.isError,t.failed=u,t.successful=!u,c.shouldSwap){286===r.status&&cancelPolling(e),withExtensions(e,(function(t){l=t.transformResponse(l,r,e)})),i.type&&saveCurrentPageToHistory();var f=o.swapOverride;hasHeader(r,/HX-Reswap:/i)&&(f=r.getResponseHeader("HX-Reswap"));var g=getSwapSpecification(e,f);n.classList.add(htmx.config.swappingClass);var d=function(){try{var o=document.activeElement,a={};try{a={elt:o,start:o?o.selectionStart:null,end:o?o.selectionEnd:null}}catch(e){}var s=makeSettleInfo(n);if(selectAndSwap(g.swapStyle,n,e,l,s),a.elt&&!bodyContains(a.elt)&&a.elt.id){var u=document.getElementById(a.elt.id),c={preventScroll:void 0!==g.focusScroll?!g.focusScroll:!htmx.config.defaultFocusScroll};u&&(a.start&&u.setSelectionRange&&u.setSelectionRange(a.start,a.end),u.focus(c))}if(n.classList.remove(htmx.config.swappingClass),forEach(s.elts,(function(e){e.classList&&e.classList.add(htmx.config.settlingClass),triggerEvent(e,"htmx:afterSwap",t)})),hasHeader(r,/HX-Trigger-After-Swap:/i)){var f=e;bodyContains(e)||(f=getDocument().body),handleTrigger(r,"HX-Trigger-After-Swap",f)}var d=function(){if(forEach(s.tasks,(function(e){e.call()})),forEach(s.elts,(function(e){e.classList&&e.classList.remove(htmx.config.settlingClass),triggerEvent(e,"htmx:afterSettle",t)})),i.type&&("push"===i.type?(pushUrlIntoHistory(i.path),triggerEvent(getDocument().body,"htmx:pushedIntoHistory",{path:i.path})):(replaceUrlInHistory(i.path),triggerEvent(getDocument().body,"htmx:replacedInHistory",{path:i.path}))),t.pathInfo.anchor){var n=find("#"+t.pathInfo.anchor);n&&n.scrollIntoView({block:"start",behavior:"auto"})}if(s.title){var o=find("title");o?o.innerHTML=s.title:window.document.title=s.title}if(updateScrollState(s.elts,g),hasHeader(r,/HX-Trigger-After-Settle:/i)){var a=e;bodyContains(e)||(a=getDocument().body),handleTrigger(r,"HX-Trigger-After-Settle",a)}};g.settleDelay>0?setTimeout(d,g.settleDelay):d()}catch(r){throw triggerErrorEvent(e,"htmx:swapError",t),r}};g.swapDelay>0?setTimeout(d,g.swapDelay):d()}u&&triggerErrorEvent(e,"htmx:responseError",mergeObjects({error:"Response Status Error Code "+r.status+" from "+t.pathInfo.requestPath},t))}}}}var extensions={};function extensionBase(){return{init:function(e){return null},onEvent:function(e,t){return!0},transformResponse:function(e,t,r){return e},isInlineSwap:function(e){return!1},handleSwap:function(e,t,r,n){return!1},encodeParameters:function(e,t,r){return null}}}function defineExtension(e,t){t.init&&t.init(internalAPI),extensions[e]=mergeObjects(extensionBase(),t)}function removeExtension(e){delete extensions[e]}function getExtensions(e,t,r){if(null==e)return t;null==t&&(t=[]),null==r&&(r=[]);var n=getAttributeValue(e,"hx-ext");return n&&forEach(n.split(","),(function(e){if("ignore:"!=(e=e.replace(/ /g,"")).slice(0,7)){if(r.indexOf(e)<0){var n=extensions[e];n&&t.indexOf(n)<0&&t.push(n)}}else r.push(e.slice(7))})),getExtensions(parentElt(e),t,r)}function ready(e){"loading"!==getDocument().readyState?e():getDocument().addEventListener("DOMContentLoaded",e)}function insertIndicatorStyles(){!1!==htmx.config.includeIndicatorStyles&&getDocument().head.insertAdjacentHTML("beforeend","<style>                      ."+htmx.config.indicatorClass+"{opacity:0;transition: opacity 200ms ease-in;}                      ."+htmx.config.requestClass+" ."+htmx.config.indicatorClass+"{opacity:1}                      ."+htmx.config.requestClass+"."+htmx.config.indicatorClass+"{opacity:1}                    </style>")}function getMetaConfig(){var e=getDocument().querySelector('meta[name="htmx-config"]');return e?parseJSON(e.content):null}function mergeMetaConfig(){var e=getMetaConfig();e&&(htmx.config=mergeObjects(htmx.config,e))}return ready((function(){mergeMetaConfig(),insertIndicatorStyles();var e=getDocument().body;processNode(e);var t=getDocument().querySelectorAll("[hx-trigger='restored'],[data-hx-trigger='restored']");e.addEventListener("htmx:abort",(function(e){var t=getInternalData(e.target);t&&t.xhr&&t.xhr.abort()})),window.onpopstate=function(e){e.state&&e.state.htmx&&(restoreHistory(),forEach(t,(function(e){triggerEvent(e,"htmx:restored",{document:getDocument(),triggerEvent:triggerEvent})})))},setTimeout((function(){triggerEvent(e,"htmx:load",{})}),0)})),htmx}()})),htmx.defineExtension("craft-cp",{onEvent:function(e,t){switch(e){case"htmx:configRequest":this.configureRequest(t);break;case"htmx:load":this.onLoad(t)}},configureRequest:function(e){Object.assign(e.detail.headers,Craft._actionHeaders())},transformResponse:function(e,t,r){const n=(new DOMParser).parseFromString(e,"text/html");if(n.body===document.body)return;const o=n.querySelectorAll("template.hx-head-html"),a=n.querySelectorAll("template.hx-body-html");for(let e=0;e<o.length;e++){const t=o[e].innerHTML;t&&Craft.appendHeadHtml(t)}for(let e=0;e<a.length;e++){const t=a[e].innerHTML;t&&Craft.appendBodyHtml(t)}return e},onLoad:function(e){Craft.initUiElements(e.detail.elt)}}),htmx.defineExtension("craft-condition",{onEvent:function(e,t){"htmx:configRequest"===e&&this.configureRequest(t)},configureRequest:function(e){let t=$(e.detail.target).children(".condition-main");t.length||(t=$(e.detail.target).closest(".condition-main"));const r=t.data("condition-config");if(r&&r.name){const t=e.detail.elt.getAttribute("hx-vals")||e.detail.elt.getAttribute("data-hx-vals"),n=t?Object.keys(JSON.parse(t)):[];e.detail.parameters=Object.fromEntries(Object.entries(e.detail.parameters).filter((([e])=>n.includes(e)||0===e.indexOf(r.name))))}e.detail.parameters.config=JSON.stringify(r||{})}}),"undefined"!=typeof Craft&&Object.assign(htmx.config,{indicatorClass:"spinner",requestClass:"loading"});