# Setup Guide

This guide assumes you have an [ActiveCampaign](https://www.activecampaign.com) account already.

## Compatibility

Uses `v3` of the REST API.

### Endpoints
Maps data to the following endpoints:

- **Deals**
- **Contact**
- **Account**

### Fields
Maps data to the following field types:

- **Standard**
- **Custom**

## Duplicate Check & Update

- Duplicate check on **Contact** email address (will update other details if it matches instead of creating a new contact).
- Duplicate check on **Account** name (will use an existing account if the value matches instead of creating a new one).

## Setup Instructions

### 1. Create & get API Key from ActiveCampaign

- Go to the [ActiveCampaign website](https://www.activecampaign.com) and log into your account.
- At the bottom left corner, click on the Settings nav menu option / gear icon (above the profile icon).
- On the next page, click the **Developer** subnav option near the middle of the page.
- Copy the values in the **API URL** and **API Key** fields.

### 2. Set up Integration on your site

- Switch back to your Freeform/Craft tab.
- Select *ActiveCampaign (v3)* from the **Service Provider** select dropdown.
- Enter a name and handle for the integration.
- Paste the **API URL** value from ActiveCampaign into the **API URL** field in Freeform.
- Paste the **API Key** value from ActiveCampaign into the **API Key** field in Freeform.

### 3. Additional Configuration

- In the **Pipeline** field, enter the name or ID of the ActiveCampaign Pipeline you wish to have *Deal* data sent to, e.g. `My Pipeline`.
- In the **Stage** field, enter the name or ID of the ActiveCampaign Stage you wish to have *Deal* data sent to, e.g. `To Contact`.
- In the **Owner** field (optional), enter the username or ID of the ActiveCampaign user to assign as the *Deal* owner.
- Click the **Save** button.

### 4. Verify Authorization

- After the integration is saved, it'll return you to the list of CRM integrations.
- Click into the newly created integration.
- Confirm that there is green circle with **Authorized** in the middle of the page.

### 5. Configure the Form

To use this integration on your form(s), you'll need to configure each form individually.

- Visit the form inside the form builder.
- Click on the **Integrations** tab.
- Click on **ActiveCampaign** in the list of available integrations.
- On the right side of the page:
    - Enable the integration.
    - Select the API endpoints you wish to map to.
    - Map Freeform fields to the ActiveCampaign fields as needed.

## Notes

When setting up the form inside the form builder, please be sure to map all required fields for *Deal*:
- Currency, e.g. use a hidden field that contains `usd` or `eur`.
- Owner (ID), e.g. use a hidden field that contains `1`.
- Value ($ amount), e.g. use a hidden field that contains `500.00` or a regular input/select that allows the user to select the value, etc.

If you want the form submitter to automatically (or optionally) be opted into an ActiveCampaign mailing list, use a hidden field or dropdown, radioes, checkbox, etc that contains the ID of the mailing list you wish to have them subscribed to. Then map that field to the **Mailing List ID** field under *Contact*.

---

<small>Do you need more from this integration? Is the integration you're looking for not here? Solspace offers [custom software development services](https://docs.solspace.com/support/premium/) to build any feature or change you need.</small>