<?php

namespace Solspace\Freeform\Library\Helpers;

class ArrayHelper
{
    /**
     * Returns true if any one element in the array passes the callable check.
     */
    public static function some(array $array, callable $fn): bool
    {
        foreach ($array as $value) {
            if ($fn($value)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Returns true if every element in the $array returns true on the callback call.
     */
    public static function every(array $array, callable $fn): bool
    {
        foreach ($array as $value) {
            if (!$fn($value)) {
                return false;
            }
        }

        return true;
    }

    public static function keyFlatten(array $array, ?int $depth = null, string $separator = '.'): array
    {
        $recursiveIterator = new \RecursiveIteratorIterator(new \RecursiveArrayIterator($array));

        $result = [];
        foreach ($recursiveIterator as $leafValue) {
            $keys = [];

            $maxDepth = min($depth ?? $recursiveIterator->getDepth(), $recursiveIterator->getDepth());
            foreach (range(0, $maxDepth) as $currentDepth) {
                $keys[] = $recursiveIterator->getSubIterator($currentDepth)->key();
            }
            $result[implode($separator, $keys)] = $leafValue;
        }

        return $result;
    }
}
